/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm.directdelivery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.workshop.MaterialWorkShopEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SDDPFBStatus;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FBDetailSpVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FbVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.SpVO;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalNoticeBillEntryDEntryFactory;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalNoticeBillEntryDEntryInfo;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalNoticeBillEntryFactory;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalNoticeBillEntryInfo;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalNoticeBillFactory;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalNoticeBillInfo;
import com.kingdee.eas.industry.emm.scm.im.inv.ArrivalTraficType;
import com.kingdee.eas.industry.emm.scm.im.inv.IArrivalNoticeBill;
import com.kingdee.eas.industry.emm.scm.sm.DPMapVO;
import com.kingdee.eas.industry.emm.scm.sm.DelieryPlanSTVO;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailCollection;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailFactory;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailInfo;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanFBdetialVO;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanMergeFactory;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanMergeInfo;
import com.kingdee.eas.industry.emm.scm.sm.IDeliveryPlanMerge;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryFBEntryFactory;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryFBEntryInfo;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryFBFactory;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryFBInfo;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DirectDeliveryPlanFBdetialVO;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.app.AbstractDirectDeliveryPlanFBFacadeControllerBean;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.sm.pur.PurReTypeInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;

public class DirectDeliveryPlanFBFacadeControllerBean
extends AbstractDirectDeliveryPlanFBFacadeControllerBean {
    @Override
    public HashMap _mergeDeliveryPlan(Context ctx, HashMap param) throws BOSException, EASBizException {
        return super._mergeDeliveryPlan(ctx, param);
    }

    private String getInsetSQLString(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append(" \n");
        sql.append(" insert into CT_SM_DeliveryPlanMerge  \n");
        sql.append(" (fid,cfpurchaseorguniti,cfmaterialid,cfmaterialname,cfunitid,cfstorageorgunitid, \n");
        sql.append(" cfsupplystorageorg,CFSupplierID,cfprojectid,cftracknumberid,cfdemandqty,cfdemanddate,cfdeliverywarehous ,cfmerge \n");
        sql.append(" ,FCreatorID,FLastUpdateUserID,fcreatetime,flastupdatetime,fcontrolunitid ,cfisolatedrule,CFDeliveredQty,CFPurPersonID,CFPurGroupID ,CFInWhQty,CFPurtypeID,CFDpType,CFWorkShop,CFMaterialWorkShop )");
        return sql.toString();
    }

    private java.util.Date getZERO(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private String createTableAndInit(Context ctx, String tableName, java.util.Date startDateT, java.util.Date endDate, int cycle) throws EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date startDate = this.getZERO(startDateT);
        java.util.Date tmpDate = this.addDays(startDate, cycle);
        this.insetTmp(ctx, tableName, sdf.format(startDate), sdf.format(tmpDate));
        while (tmpDate.before(endDate)) {
            java.util.Date tmpDate1 = tmpDate;
            tmpDate = this.addDays(tmpDate, cycle);
            this.insetTmp(ctx, tableName, sdf.format(tmpDate1), sdf.format(tmpDate));
        }
        return null;
    }

    private void insetTmp(Context ctx, String tableName, String startDate, String endDate) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  /*dialect*/ \n");
        sql.append("Insert into " + tableName + " (FID ,fstarttime ,Fendtime)");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("to_date('").append(startDate).append("' ,'yyyy-MM-dd HH24:mi:ss'),");
        sql.append("to_date('").append(endDate).append("' ,'yyyy-MM-dd HH24:mi:ss') )");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
        }
    }

    private String createTempTable(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table DataNew ( ");
        sql.append("FID VARCHAR(44),\r\n");
        sql.append("fstarttime timestamp,\r\n");
        sql.append("Fendtime timestamp );\r\n");
        return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
    }

    private java.util.Date addDays(java.util.Date date, int cycle) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, cycle);
        return ca.getTime();
    }

    protected void releaseTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    private DeliveryPlanMergeInfo getDpInfo(Context ctx, IRowSet irs) throws UuidException, SQLException {
        DeliveryPlanMergeInfo spInfo = new DeliveryPlanMergeInfo();
        spInfo.setId(BOSUuid.read((String)irs.getString("fid")));
        StorageOrgUnitInfo supOrgInfo = new StorageOrgUnitInfo();
        supOrgInfo.setId(BOSUuid.read((String)irs.getString("supplyorgID")));
        supOrgInfo.setName(irs.getString("supplyorgName"));
        supOrgInfo.setNumber(irs.getString("supplyorgNumber"));
        spInfo.setSupplyStorageOrgUnit(supOrgInfo);
        StorageOrgUnitInfo orgInfo = new StorageOrgUnitInfo();
        orgInfo.setId(BOSUuid.read((String)irs.getString("orgID")));
        orgInfo.setName(irs.getString("orgName"));
        orgInfo.setNumber(irs.getString("orgNumber"));
        spInfo.setStorageOrgUnit(orgInfo);
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)irs.getString("materialID")));
        materialInfo.setName(irs.getString("materialName"));
        materialInfo.setNumber(irs.getString("materialNumber"));
        spInfo.setMaterial(materialInfo);
        PurchaseOrgUnitInfo purInfo = new PurchaseOrgUnitInfo();
        purInfo.setId(BOSUuid.read((String)irs.getString("purOrgID")));
        purInfo.setName(irs.getString("purOrgName"));
        purInfo.setNumber(irs.getString("purOrgNumber"));
        spInfo.setPurchaseOrgUnit(purInfo);
        if (!IndustryUtils.isEmptyString((String)irs.getString("projectID"))) {
            ProjectInfo proInfo = new ProjectInfo();
            proInfo.setId(BOSUuid.read((String)irs.getString("projectID")));
            proInfo.setNumber(irs.getString("projectNumber"));
            proInfo.setName(irs.getString("projectName"));
            spInfo.setProject(proInfo);
        }
        if (!IndustryUtils.isEmptyString((String)irs.getString("trackNoID"))) {
            TrackNumberInfo trcInfo = new TrackNumberInfo();
            trcInfo.setId(BOSUuid.read((String)irs.getString("trackNoID")));
            trcInfo.setNumber(irs.getString("trackNoNumber"));
            trcInfo.setName(irs.getString("trackNoName"));
            spInfo.setTrackNumber(trcInfo);
        }
        if (!IndustryUtils.isEmptyString((String)irs.getString("purpersonID"))) {
            PersonInfo perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)irs.getString("purpersonID")));
            perInfo.setName(irs.getString("purpersonName"));
            perInfo.setNumber(irs.getString("purpersonNumber"));
            spInfo.setPurPerson(perInfo);
        }
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setId(BOSUuid.read((String)irs.getString("supplierID")));
        supplierInfo.setName(irs.getString("supplierName"));
        supplierInfo.setNumber(irs.getString("supplierNumber"));
        spInfo.setSupplier(supplierInfo);
        if (!IndustryUtils.isEmptyString((String)irs.getString("whID"))) {
            WarehouseInfo warInfo = new WarehouseInfo();
            warInfo.setId(BOSUuid.read((String)irs.getString("whID")));
            warInfo.setName(irs.getString("whName"));
            warInfo.setNumber(irs.getString("whNumber"));
            spInfo.setDeliveryWareHouse(warInfo);
        }
        if (!IndustryUtils.isEmptyString((String)irs.getString("unitID"))) {
            MeasureUnitInfo meInfo = new MeasureUnitInfo();
            meInfo.setId(BOSUuid.read((String)irs.getString("unitID")));
            meInfo.setName(irs.getString("unitName"));
            meInfo.setNumber(irs.getString("unitNumber"));
            spInfo.setUnit(meInfo);
        }
        if (!IndustryUtils.isEmptyString((String)irs.getString("purgroupID"))) {
            PurchaseGroupInfo pgInfo = new PurchaseGroupInfo();
            pgInfo.setId(BOSUuid.read((String)irs.getString("purgroupID")));
            pgInfo.setName(irs.getString("purgroupName"));
            pgInfo.setNumber(irs.getString("purgroupNumber"));
            spInfo.setPurGroup(pgInfo);
        }
        if (!IndustryUtils.isEmptyString((String)irs.getString("prtID"))) {
            PurReTypeInfo prInfo = new PurReTypeInfo();
            prInfo.setId(BOSUuid.read((String)irs.getString("prtID")));
            prInfo.setName(irs.getString("prtName"));
            prInfo.setNumber(irs.getString("prtNumber"));
            spInfo.setPurtype(prInfo);
        }
        spInfo.setDemandDate(irs.getDate("fdemanddate"));
        spInfo.setDemandQty(irs.getBigDecimal("cfdemandqty"));
        spInfo.setWorkShop(irs.getString("CFWorkShop"));
        if (!IndustryUtils.isEmptyString((String)irs.getString("CFMaterialWorkShop"))) {
            spInfo.setMaterialWorkShop(MaterialWorkShopEnum.getEnum(irs.getString("CFMaterialWorkShop")));
        }
        return spInfo;
    }

    @Override
    public HashMap _queryDeliveryPlanMerge(Context ctx, HashMap param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        String queryString = (String)param.get("queryString");
        String defineQuery = (String)param.get("defineQuery");
        int maxCount = (Integer)param.get("maxCount");
        HashMap<String, Cloneable> mapR = new HashMap<String, Cloneable>();
        ArrayList listOfVO = new ArrayList();
        HashMap<String, DelieryPlanSTVO> spVO_map = new HashMap<String, DelieryPlanSTVO>();
        HashSet<Date> setOfTime = new HashSet<Date>();
        StringBuffer sql = new StringBuffer();
        sql.append(" /*dialect*/");
        sql.append(" select tt.* from (");
        sql.append(" \n");
        sql.append("  select dp.fid,sum(tof.fusefbqty) as supplyqty ,min(dp.cfdemanddate) as fdemanddate ,min(dp.cfdeliveredqty) as cfdeliveredqty ,sum(dp.CFInWhQty) as inwhqty  \n");
        sql.append("  ,min(dp.cfdemandqty) as cfdemandqty,max(tspg.fid) as supplyorgID ,max(tspg.fnumber) as supplyorgNumber ,max(tspg.fname_l2) as supplyorgName \n");
        sql.append("  ,max(tsg.fid) as orgID ,max(tsg.fnumber) as orgNumber ,max(tsg.fname_l2) as orgName \n");
        sql.append("  ,max(tp.fid) as projectID ,max(tp.fnumber) as projectNumber ,max(tp.fname_l2) as projectName \n");
        sql.append("  ,max(tn.fid) as trackNoID ,max(tn.fnumber) as trackNoNumber ,max(tn.fname_l2) as trackNoName \n");
        sql.append("  ,max(tm.fid) as materialID ,max(tm.fnumber) as materialNumber ,max(tm.fname_l2) as materialName \n");
        sql.append("  ,max(tb.fid) as purOrgID ,max(tb.fnumber) as purOrgNumber ,max(tb.fname_l2) as purOrgName \n");
        sql.append("  ,max(ts.fid) as supplierID ,max(ts.fnumber) as supplierNumber ,max(ts.fname_l2) as supplierName \n");
        sql.append("  ,max(tw.fid) as whID ,max(tw.fnumber) as whNumber ,max(tw.fname_l2) as whName \n");
        sql.append("  ,max(pr.fid) as purpersonID ,max(pr.fnumber) as purpersonNumber ,max(pr.fname_l2) as purpersonName \n");
        sql.append("  ,max(mu.fid) as unitID ,max(mu.fnumber) as unitNumber ,max(mu.fname_l2) as unitName \n");
        sql.append("  ,max(pg.fid) as purgroupID ,max(pg.fnumber) as purgroupNumber ,max(pg.fname_l2) as purgroupName \n");
        sql.append("  ,max(prt.fid) as prtID ,max(prt.fnumber) as prtNumber ,max(prt.fname_l2) as prtName \n");
        sql.append("  ,max(dp.CFWorkShop) as CFWorkShop ,max(dp.CFMaterialWorkShop) as CFMaterialWorkShop \n");
        sql.append("  from ct_sm_directdeliverydemand dp   \n");
        sql.append("  left join t_org_baseunit tspg on dp.cfsupplystorageorg = tspg.fid \n");
        sql.append("  left join t_org_baseunit tsg on dp.cfstorageorgunitid = tsg.fid \n");
        sql.append("  left join T_MM_Project tp on tp.fid = dp.cfprojectid \n");
        sql.append("  left join T_MM_TrackNumber tn on tn.fid = dp.cftracknumberid    \n");
        sql.append("  left join t_bd_material tm on tm.fid = dp.cfmaterialid   \n");
        sql.append("  left join t_org_baseunit tb on tb.fid = dp.cfpurchaseorguniti  \n");
        sql.append("  left join T_BD_Supplier ts on ts.fid = dp.cfsupplierid \n");
        sql.append("  left join CT_SM_DDPTOFB tof on tof.fdpmergeid = dp.fid   \n");
        sql.append("  left join T_DB_WAREHOUSE tw on tw.fid = dp.cfdeliverywarehous \n");
        sql.append("  left join t_bd_person pr on pr.fid = dp.CFPurPersonID \n");
        sql.append("  left join T_BD_MeasureUnit mu on mu.fid = dp.cfunitid \n");
        sql.append("  left join T_BD_PurchaseGroup pg on pg.fid = dp.cfpurgroupid \n");
        sql.append("  left join CT_PUR_PurReType prt on prt.fid = dp.CFPurtypeID \n");
        sql.append("  where  1=1   \n");
        if (!IndustryUtils.isEmptyString((String)queryString)) {
            sql.append(" and \n").append(queryString);
        }
        if (!IndustryUtils.isEmptyString((String)defineQuery)) {
            defineQuery = defineQuery.replace("IS EMPTY", "is null ");
            defineQuery = defineQuery.replace("IS NOT EMPTY", "is not null ");
            sql.append(" and \n").append(defineQuery);
        }
        sql.append("  \n");
        sql.append("  group by dp.fid   \n");
        sql.append("  order by  fdemanddate    \n");
        sql.append("  )tt \n");
        sql.append("  where  rownum  < = " + maxCount + "\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            IDeliveryPlanMerge idpm = DeliveryPlanMergeFactory.getLocalInstance(ctx);
            DeliveryPlanMergeInfo spInfo = new DeliveryPlanMergeInfo();
            try {
                while (rowSet.next()) {
                    List<DeliveryPlanMergeInfo> spList;
                    DPMapVO sdVo;
                    HashMap<java.util.Date, DPMapVO> sdMap;
                    String stcokingplanID = rowSet.getString("fid");
                    BigDecimal supplyQty = rowSet.getBigDecimal("supplyqty");
                    java.util.Date demandDate = rowSet.getDate("fdemanddate");
                    BigDecimal deliveredQty = rowSet.getBigDecimal("cfdeliveredqty");
                    BigDecimal inWhQty = rowSet.getBigDecimal("inwhqty");
                    if (demandDate != null) {
                        demandDate = this.getZERO(demandDate);
                    }
                    setOfTime.add((Date)demandDate);
                    spInfo = this.getDpInfo(ctx, rowSet);
                    String key = (spInfo.getSupplier() != null ? spInfo.getSupplier().getId().toString() : "#") + (spInfo.getPurchaseOrgUnit() != null ? spInfo.getPurchaseOrgUnit().getId().toString() : "#") + spInfo.getMaterial().getId().toString() + (spInfo.getSupplyStorageOrgUnit() != null ? spInfo.getSupplyStorageOrgUnit().getId().toString() : "#") + (spInfo.getProject() != null ? spInfo.getProject().getId().toString() : "#") + (spInfo.getTrackNumber() != null ? spInfo.getTrackNumber().getId().toString() : "#") + (spInfo.getDeliveryWareHouse() != null ? spInfo.getDeliveryWareHouse().getId() : "#");
                    if (spInfo.getDemandQty().compareTo(BigDecimal.ZERO) == 0) continue;
                    DelieryPlanSTVO spVo = new DelieryPlanSTVO();
                    if (spVO_map.containsKey(key)) {
                        spVo = (DelieryPlanSTVO)spVO_map.get(key);
                        sdMap = spVo.getSdMap();
                        sdVo = new DPMapVO();
                        if (sdMap.containsKey(spInfo.getDemandDate())) {
                            sdVo = sdMap.get(spInfo.getDemandDate());
                            sdVo.setDemandQty(sdVo.getDemandQty().add(spInfo.getDemandQty()));
                            sdVo.setSupplierQty(sdVo.getSupplierQty().add(supplyQty != null ? supplyQty : BigDecimal.ZERO));
                            sdVo.setDeliveredQty(sdVo.getDeliveredQty().add(deliveredQty != null ? deliveredQty : BigDecimal.ZERO));
                            sdVo.setInWhQty(sdVo.getInWhQty().add(inWhQty != null ? inWhQty : BigDecimal.ZERO));
                            spList = sdVo.getDPList();
                            spList.add(spInfo);
                            sdVo.setDPList(spList);
                        } else {
                            sdVo.setDemandDate(spInfo.getDemandDate());
                            sdVo.setDemandQty(spInfo.getDemandQty());
                            sdVo.setSupplierQty(supplyQty != null ? supplyQty : BigDecimal.ZERO);
                            sdVo.setDeliveredQty(deliveredQty != null ? deliveredQty : BigDecimal.ZERO);
                            sdVo.setInWhQty(inWhQty != null ? inWhQty : BigDecimal.ZERO);
                            spList = new ArrayList<DeliveryPlanMergeInfo>();
                            spList.add(spInfo);
                            sdVo.setDPList(spList);
                        }
                        sdMap.put(spInfo.getDemandDate(), sdVo);
                        spVo.setSdMap(sdMap);
                    } else {
                        spVo.setPurchaseOrgUnitID(spInfo.getPurchaseOrgUnit() == null ? null : spInfo.getPurchaseOrgUnit().getId().toString());
                        spVo.setPurchaseOrgUnitName(spInfo.getPurchaseOrgUnit() == null ? null : spInfo.getPurchaseOrgUnit().getName());
                        spVo.setPurchaseOrgUnitNumber(spInfo.getPurchaseOrgUnit() == null ? null : spInfo.getPurchaseOrgUnit().getNumber());
                        spVo.setMaterialID(spInfo.getMaterial() == null ? null : spInfo.getMaterial().getId().toString());
                        spVo.setMaterialName(spInfo.getMaterial() == null ? null : spInfo.getMaterial().getName());
                        spVo.setMaterialNumber(spInfo.getMaterial() == null ? null : spInfo.getMaterial().getNumber());
                        spVo.setStorageOrgUnitID(spInfo.getStorageOrgUnit() == null ? null : spInfo.getStorageOrgUnit().getId().toString());
                        spVo.setStorageOrgUnitName(spInfo.getStorageOrgUnit() == null ? null : spInfo.getStorageOrgUnit().getName());
                        spVo.setStorageOrgUnitNumber(spInfo.getStorageOrgUnit() == null ? null : spInfo.getStorageOrgUnit().getNumber());
                        spVo.setSupplyStroageOrgUnitID(spInfo.getSupplyStorageOrgUnit() == null ? null : spInfo.getSupplyStorageOrgUnit().getId().toString());
                        spVo.setSupplyStroageOrgUnitName(spInfo.getSupplyStorageOrgUnit() == null ? null : spInfo.getSupplyStorageOrgUnit().getName());
                        spVo.setSupplyStroageOrgUnitNumber(spInfo.getSupplyStorageOrgUnit() == null ? null : spInfo.getSupplyStorageOrgUnit().getNumber());
                        spVo.setProjectID(spInfo.getProject() == null ? null : spInfo.getProject().getId().toString());
                        spVo.setProjectName(spInfo.getProject() == null ? null : spInfo.getProject().getName());
                        spVo.setProjectNumber(spInfo.getProject() == null ? null : spInfo.getProject().getNumber());
                        spVo.setTrackNumberID(spInfo.getTrackNumber() == null ? null : spInfo.getTrackNumber().getId().toString());
                        spVo.setTrackNumberName(spInfo.getTrackNumber() == null ? null : spInfo.getTrackNumber().getName());
                        spVo.setTrackNumberNumber(spInfo.getTrackNumber() == null ? null : spInfo.getTrackNumber().getNumber());
                        spVo.setSupplierID(spInfo.getSupplier() == null ? null : spInfo.getSupplier().getId().toString());
                        spVo.setSupplierName(spInfo.getSupplier() == null ? null : spInfo.getSupplier().getName());
                        spVo.setSupplierNumber(spInfo.getSupplier() == null ? null : spInfo.getSupplier().getNumber());
                        spVo.setBaseunitID(spInfo.getUnit() == null ? null : spInfo.getUnit().getId().toString());
                        spVo.setBaseunitName(spInfo.getUnit() == null ? null : spInfo.getUnit().getName());
                        spVo.setBaseunitNumber(spInfo.getUnit() == null ? null : spInfo.getUnit().getNumber());
                        spVo.setWhInfoID(spInfo.getDeliveryWareHouse() == null ? null : spInfo.getDeliveryWareHouse().getId().toString());
                        spVo.setWhInfoName(spInfo.getDeliveryWareHouse() == null ? null : spInfo.getDeliveryWareHouse().getName());
                        spVo.setWhInfoNumber(spInfo.getDeliveryWareHouse() == null ? null : spInfo.getDeliveryWareHouse().getNumber());
                        spVo.setPurGroupname(spInfo.getPurGroup() != null ? spInfo.getPurGroup().getName() : "");
                        spVo.setPurPersonname(spInfo.getPurPerson() != null ? spInfo.getPurPerson().getName() : "");
                        spVo.setPurTypeID(spInfo.getPurtype() == null ? null : spInfo.getPurtype().getId().toString());
                        spVo.setPurTypeName(spInfo.getPurtype() == null ? null : spInfo.getPurtype().getName());
                        spVo.setPurTypeNumber(spInfo.getPurtype() == null ? null : spInfo.getPurtype().getNumber());
                        spVo.setWorkShop(spInfo.getWorkShop());
                        spVo.setMaterialWorkShop(spInfo.getMaterialWorkShop() != null ? spInfo.getMaterialWorkShop().getAlias() : "");
                        sdMap = new HashMap();
                        sdVo = new DPMapVO();
                        sdVo.setDemandDate(spInfo.getDemandDate());
                        sdVo.setDemandQty(spInfo.getDemandQty());
                        sdVo.setSupplierQty(supplyQty != null ? supplyQty : BigDecimal.ZERO);
                        sdVo.setDeliveredQty(deliveredQty != null ? deliveredQty : BigDecimal.ZERO);
                        sdVo.setInWhQty(inWhQty != null ? inWhQty : BigDecimal.ZERO);
                        spList = new ArrayList();
                        spList.add(spInfo);
                        sdVo.setDPList(spList);
                        sdMap.put(spInfo.getDemandDate(), sdVo);
                        spVo.setSdMap(sdMap);
                    }
                    spVO_map.put(key, spVo);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        mapR.put("spVO_map", spVO_map);
        mapR.put("setOfTime", setOfTime);
        return mapR;
    }

    @Override
    protected IObjectValue _getExsitFBInfo(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        DirectDeliveryPlanFBdetialVO spVo = (DirectDeliveryPlanFBdetialVO)param.get("spVo");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" /*dialect*/  \n ");
        sql.append(" select fid from ct_sm_directdeliveryfb  \n ");
        sql.append(" where nvl(cfsupplystorageorg,'0') = '").append(spVo.getSupplyStroageOrgUnit() != null ? spVo.getSupplyStroageOrgUnit().getId().toString() : "0").append("' \n ");
        sql.append(" and  nvl(cfpurchaseorguniti,'0')  = '").append(spVo.getPurchaseOrgUnit() != null ? spVo.getPurchaseOrgUnit().getId().toString() : "0").append("' \n ");
        sql.append(" and   nvl(cfmaterialid,'0')  = '").append(spVo.getMaterial() != null ? spVo.getMaterial().getId().toString() : "0").append("' \n ");
        sql.append(" and   nvl(cfsupplierid,'0')  = '").append(spVo.getSupplier() != null ? spVo.getSupplier().getId().toString() : "0").append("' \n ");
        sql.append(" and  nvl(cfprojectid ,'0') = '").append(spVo.getProject() != null ? spVo.getProject().getId().toString() : "0").append("' \n ");
        sql.append(" and  nvl(cftracknumberid ,'0') = '").append(spVo.getTrackNumber() != null ? spVo.getTrackNumber().getId().toString() : "0").append("' \n ");
        sql.append(" and  nvl(cfstorageorgunitid,'0') = '").append(spVo.getStorageOrgUnit() != null ? spVo.getStorageOrgUnit().getId().toString() : "0").append("' \n");
        sql.append(" and  nvl(cfwarehouseid,'0') = '").append(spVo.getWhInfo() != null ? spVo.getWhInfo().getId().toString() : "0").append("' \n");
        sql.append(" and  to_char (cfdeliverydate ,'yyyy-MM-dd') =  ");
        sql.append("  '").append(sdf.format(spVo.getDemandDate())).append("'");
        sql.append(" and cfbasestatus = '20' \n ");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fid = null;
        if (irs != null) {
            try {
                if (irs.next()) {
                    fid = irs.getString("fid");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (fid != null) {
            DirectDeliveryFBInfo spFbInfo = DirectDeliveryFBFactory.getLocalInstance(ctx).getDirectDeliveryFBInfo((IObjectPK)new ObjectUuidPK(fid));
            return spFbInfo;
        }
        return super._getExsitFBInfo(ctx, param);
    }

    @Override
    protected HashMap _refreshSupplyList(Context ctx, HashMap param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("/*dialect*/");
        sql.append(" \n");
        sql.append(" update ct_sm_consignmentschedulefb set cfbasestatus = '20' \n");
        sql.append(" where cfdemandqty = cfsupdeqty \n");
        sql.append(" and cfdemandqty = cfdeliveryqty \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" /*dialect*/ \n");
        sql.append(" select sc.fid , nvl(sc.cfsupdeqty,0)-nvl(sc.cfdeliveryqty ,0) as qty ,sc.cfsupdedate as  fbdate , \n");
        sql.append(" sc.cfpurchaseorguniti ,sc.cfstorageorgunitid ,sc.cfsupplystorageorg,sc.cfmaterialid , \n");
        sql.append(" sc.cfprojectid ,sc.cftracknumberid ,sc.cfwarehouseid,sc.cfsupplierid \n");
        sql.append(" from ct_sm_consignmentschedulefb sc \n");
        sql.append(" where sc.cfbasestatus = '20' \n");
        sql.append(" order by sc.cfsupdedate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, FBDetailSpVO> fb_Map = new HashMap<String, FBDetailSpVO>();
        if (irs != null) {
            try {
                while (irs.next()) {
                    ArrayList<FbVO> fbList;
                    FBDetailSpVO fspVO;
                    String purchaseorgunitid = irs.getString("cfpurchaseorguniti");
                    String materialid = irs.getString("cfmaterialid");
                    String projectid = irs.getString("cfprojectid");
                    String tracknumberid = irs.getString("cftracknumberid");
                    String supplierid = irs.getString("cfsupplierid");
                    String supplyorgunitid = irs.getString("cfsupplystorageorg");
                    String storgerogunitid = irs.getString("cfstorageorgunitid");
                    String whid = irs.getString("cfwarehouseid");
                    String fid = irs.getString("fid");
                    BigDecimal qty = irs.getBigDecimal("qty");
                    Date fbDate = irs.getDate("fbDate");
                    String key = "#" + purchaseorgunitid + "#" + supplyorgunitid + "#" + supplierid + "#" + storgerogunitid + "#" + materialid + "#" + (projectid == null ? "" : projectid) + "#" + (tracknumberid == null ? "" : tracknumberid) + "#" + (whid == null ? "" : whid);
                    if (fb_Map.containsKey(key)) {
                        fspVO = (FBDetailSpVO)fb_Map.get(key);
                        fbList = fspVO.getFbList();
                        fbList.add(new FbVO((java.util.Date)fbDate, fid, qty));
                        fspVO.setFbList(fbList);
                        fb_Map.put(key, fspVO);
                        continue;
                    }
                    fspVO = new FBDetailSpVO();
                    fbList = new ArrayList<FbVO>();
                    fbList.add(new FbVO((java.util.Date)fbDate, fid, qty));
                    fspVO.setFbList(fbList);
                    fb_Map.put(key, fspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        sql.setLength(0);
        sql.append(" /*dialect*/ \n");
        sql.append("  select fid,nvl(cfdemandqty,0) as fqty,cfdemanddate rdate,\n");
        sql.append(" cfpurchaseorguniti,cfstorageorgunitid,cfsupplystorageorg ,cfmaterialid,cfprojectid,cftracknumberid,cfdeliverywarehous,cfsupplierid\n");
        sql.append("  from ct_sm_deliveryplanmerge\n");
        sql.append(" order by cfdemanddate\n");
        IRowSet irs_SP = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs_SP != null) {
            try {
                while (irs_SP.next()) {
                    String purchaseorgunitid = irs_SP.getString("cfpurchaseorguniti");
                    String materialid = irs_SP.getString("cfmaterialid");
                    String projectid = irs_SP.getString("cfprojectid");
                    String tracknumberid = irs_SP.getString("cftracknumberid");
                    String supplierid = irs_SP.getString("cfsupplierid");
                    String supplyorgunitid = irs_SP.getString("cfsupplystorageorg");
                    String storgerogunitid = irs_SP.getString("cfstorageorgunitid");
                    String whid = irs_SP.getString("cfdeliverywarehous");
                    String fid = irs_SP.getString("fid");
                    BigDecimal spqty = irs_SP.getBigDecimal("fqty");
                    Date spDate = irs_SP.getDate("rdate");
                    String key = "#" + purchaseorgunitid + "#" + supplyorgunitid + "#" + supplierid + "#" + storgerogunitid + "#" + materialid + "#" + (projectid == null ? "" : projectid) + "#" + (tracknumberid == null ? "" : tracknumberid) + "#" + (whid == null ? "" : whid);
                    if (!fb_Map.containsKey(key)) continue;
                    FBDetailSpVO fspVO = (FBDetailSpVO)fb_Map.get(key);
                    ArrayList spList = fspVO.getSpList();
                    spList.add(new SpVO((java.util.Date)spDate, fid, spqty));
                    fspVO.setSpList(spList);
                    fb_Map.put(key, fspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        Set keys = fb_Map.keySet();
        for (Object key : keys) {
            FBDetailSpVO fspVO = (FBDetailSpVO)fb_Map.get(key);
            this.handleProcess(ctx, fspVO);
        }
        return super._refreshSupplyList(ctx, param);
    }

    private void handleProcess(Context ctx, FBDetailSpVO fspVO) throws EASBizException {
        ArrayList fbList = fspVO.getFbList();
        ArrayList spList = fspVO.getSpList();
        if (spList == null || spList.size() == 0) {
            return;
        }
        int spCount = spList.size();
        int j = 0;
        for (int i = 0; i < fbList.size(); ++i) {
            FbVO fbVO = (FbVO)fbList.get(i);
            BigDecimal fbQty = fbVO.getQty();
            java.util.Date fbDate = fbVO.getFbDate();
            while (fbQty.compareTo(BigDecimal.ZERO) > 0 && j < spCount) {
                SpVO spVO = (SpVO)spList.get(j);
                if (DateUtils.isSameDay((java.util.Date)spVO.getSpDate(), (java.util.Date)fbDate) || this.getZERO(spVO.getSpDate()).after(this.getZERO(fbDate))) {
                    BigDecimal spQty = spVO.getSpqty();
                    if (spQty.compareTo(BigDecimal.ZERO) == 0) {
                        ++j;
                        continue;
                    }
                    if (spQty.compareTo(fbQty) > 0) {
                        this.insetNewRelation(ctx, fbVO, spVO, fbQty);
                        fbQty = BigDecimal.ZERO;
                        spVO.setSpqty(spQty.subtract(fbQty));
                        spList.set(j, spVO);
                        continue;
                    }
                    if (spQty.compareTo(fbQty) == 0) {
                        this.insetNewRelation(ctx, fbVO, spVO, fbQty);
                        fbQty = BigDecimal.ZERO;
                        spVO.setSpqty(BigDecimal.ZERO);
                        spList.set(j, spVO);
                        ++j;
                        continue;
                    }
                    if (spQty.compareTo(fbQty) >= 0) continue;
                    this.insetNewRelation(ctx, fbVO, spVO, spQty);
                    fbQty = fbQty.subtract(spQty);
                    spVO.setSpqty(BigDecimal.ZERO);
                    spList.set(j, spVO);
                    ++j;
                    continue;
                }
                ++j;
            }
            if (j >= spCount) break;
        }
    }

    private void insetNewRelation(Context ctx, FbVO fbVO, SpVO spVO, BigDecimal useQty) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  /*dialect*/ \n");
        sql.append(" insert into CT_SM_DPTOFB (fid,fdpMergeID ,fdpFBdetailid,fusefbqty,fdemanddate,fsupplydate)   \n");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("'").append(spVO.getSpID()).append("' ,");
        sql.append("'").append(fbVO.getFbID()).append("' ,");
        sql.append("").append(useQty).append(" ,");
        sql.append("to_date('").append(spVO.getSpDate()).append("' ,'yyyy-mm-dd'),");
        sql.append("to_date('").append(fbVO.getFbDate()).append("' ,'yyyy-mm-dd') )");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
        }
    }

    @Override
    protected String _singleSupply(Context ctx, IObjectValue param) throws BOSException, EASBizException {
        if (param == null) {
            return "\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a";
        }
        DirectDeliveryFBInfo info = (DirectDeliveryFBInfo)param;
        BigDecimal totalQty = (info.getSupDeQty() == null ? BigDecimal.ZERO : info.getSupDeQty()).subtract(info.getDeliveryQty() == null ? BigDecimal.ZERO : info.getDeliveryQty());
        this.deleteFBusedQty(ctx, info.getId().toString());
        if (totalQty.compareTo(BigDecimal.ZERO) <= 0) {
            totalQty = BigDecimal.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  /*dialect*/ \n");
        sql.append("  select dp.fid as fid ,max(dp.cfdemandqty) as qty,sum(pfb.fusefbqty) as useqty,min(dp.cfdemanddate) as redate    \n");
        sql.append("  from CT_SM_DirectDeliveryMerge dp    \n");
        sql.append("  left join CT_SM_DDPTOFB pfb on pfb.fdpmergeid = dp.fid    \n");
        sql.append(" where nvl(dp.cfsupplierid,'0') = '").append(info.getSupplier() != null ? info.getSupplier().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.cfprojectid,'0') = '").append(info.getProject() != null ? info.getProject().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.cftracknumberid,'0')= '").append(info.getTrackNumber() != null ? info.getTrackNumber().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.cfpurchaseorgunitid ,'0')= '").append(info.getPurchaseOrgUnit() != null ? info.getPurchaseOrgUnit().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.cfsupplystorageorg,'0') = '").append(info.getSupplyStorageOrgUnit() != null ? info.getSupplyStorageOrgUnit().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.cfstorageorgunitid,'0') = '").append(info.getStorageOrgUnit() != null ? info.getStorageOrgUnit().getId().toString() : "0").append("'  \n");
        sql.append(" and nvl(dp.cfdeliverywarehous,'0') = '").append(info.getWareHouse() != null ? info.getWareHouse().getId().toString() : "0").append("'  \n");
        sql.append(" and dp.cfmaterialid = '").append(info.getMaterial() != null ? info.getMaterial().getId().toString() : "0").append("'  \n");
        sql.append(" and dp.Cfdemanddate >= ");
        sql.append(" to_date('").append(info.getSupDeDate()).append("' ,'yyyy-MM-dd')");
        sql.append(" group by dp.fid   \n");
        sql.append(" order by redate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs != null) {
            try {
                while (irs.next() && totalQty.compareTo(BigDecimal.ZERO) > 0) {
                    String spfid = irs.getString("fid");
                    BigDecimal spQty = irs.getBigDecimal("qty");
                    BigDecimal userQty = irs.getBigDecimal("useqty") == null ? BigDecimal.ZERO : irs.getBigDecimal("useqty");
                    Date reDate = irs.getDate("redate");
                    if (userQty.compareTo(spQty) >= 0) continue;
                    if ((spQty = spQty.subtract(userQty)).compareTo(totalQty) < 0) {
                        this.updateFBTOTable(ctx, info, spfid, spQty, reDate);
                        totalQty = totalQty.subtract(spQty);
                        continue;
                    }
                    this.updateFBTOTable(ctx, info, spfid, totalQty, reDate);
                    totalQty = BigDecimal.ZERO;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5931\u8d25\uff01", "\u53cd\u9988\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        return "true";
    }

    private void updateFBTOTable(Context ctx, DirectDeliveryFBInfo info, String spid, BigDecimal useQty, java.util.Date reDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  /*dialect*/ \n");
        sql.append(" insert into CT_SM_DDPTOFB (fid,fdpMergeID ,fdpFBdetailid,fusefbqty,fdemanddate,fsupplydate)  \n");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("'").append(spid).append("' ,");
        sql.append("'").append(info.getId().toString()).append("' ,");
        sql.append("").append(useQty).append(" ,");
        sql.append("to_date('").append(reDate).append("' ,'yyyy-mm-dd'),");
        sql.append("to_date('").append(info.getSupDeDate()).append("' ,'yyyy-mm-dd') )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void deleteFBusedQty(Context ctx, String fbdID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  delete from CT_SM_DPTOFB   \n");
        sql.append("  where fdpFBdetailid = '").append(fbdID).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected String getBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws BOSException, EASBizException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        return billNumber;
    }

    @Override
    protected String _singleSupply4Port(Context ctx, DirectDeliveryPlanFBdetialVO param) throws BOSException, EASBizException {
        if (param == null) {
            return "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        }
        HashMap<String, DirectDeliveryPlanFBdetialVO> map = new HashMap<String, DirectDeliveryPlanFBdetialVO>();
        map.put("spVo", param);
        IObjectValue obj = this._getExsitFBInfo(ctx, map);
        DirectDeliveryFBInfo fbInfo = new DirectDeliveryFBInfo();
        fbInfo.setNumber(this.getBillNumber(ctx, (IObjectValue)fbInfo, ContextUtil.getCurrentCtrlUnit((Context)ctx) != null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : ""));
        if (obj != null) {
            fbInfo = (DirectDeliveryFBInfo)obj;
            DirectDeliveryFBEntryInfo fbeInfo = new DirectDeliveryFBEntryInfo();
            fbeInfo.setProject(fbInfo.getProject());
            fbeInfo.setPurchaseOrgUnit(fbInfo.getPurchaseOrgUnit());
            fbeInfo.setParent(fbInfo);
            fbeInfo.setStorageOrgUnit(fbInfo.getStorageOrgUnit());
            fbeInfo.setSupplyStorageOrgUnit(fbInfo.getSupplyStorageOrgUnit());
            fbeInfo.setSupplier(fbInfo.getSupplier());
            fbeInfo.setFbPerson(fbInfo.getFbPerson());
            fbeInfo.setFbReason(fbInfo.getFbExReason());
            fbeInfo.setTrackNumber(fbInfo.getTrackNumber());
            fbeInfo.setMaterial(fbInfo.getMaterial());
            fbeInfo.setMaterialName(fbInfo.getMaterialName());
            fbeInfo.setDemandQty(fbInfo.getDemandQty());
            fbeInfo.setDeliveriedQty(fbInfo.getDeliveryQty());
            fbeInfo.setDeliveryDate(fbInfo.getDeliveryDate());
            fbeInfo.setUnit(fbInfo.getUnit());
            DirectDeliveryFBEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)fbeInfo);
        } else {
            fbInfo.setPurchaseOrgUnit(param.getPurchaseOrgUnit());
            fbInfo.setSupplyStorageOrgUnit(param.getSupplyStroageOrgUnit());
            fbInfo.setStorageOrgUnit(param.getStorageOrgUnit());
            fbInfo.setMaterial(param.getMaterial());
            fbInfo.setMaterialName(param.getMaterial().getName());
            fbInfo.setUnit(param.getBaseunit());
            fbInfo.setSupplier(param.getSupplier());
            fbInfo.setProject(param.getProject());
            fbInfo.setTrackNumber(param.getTrackNumber());
            fbInfo.setWareHouse(param.getWhInfo());
            fbInfo.setDemandQty(param.getDemandQty());
            fbInfo.setDeliveryDate(param.getDemandDate());
        }
        fbInfo.setSupDeQty(param.getSupplierQty());
        fbInfo.setCmsFBStatus(param.getSupplierFBStatus());
        fbInfo.setSupDeDate(param.getSupplierDate());
        fbInfo.setSupplierFBDate(new java.util.Date());
        fbInfo.setDemandQty(param.getDemandQty());
        fbInfo.setFbPerson(param.getSupplierPerson());
        fbInfo.setFbExReason(param.getSupplierReason());
        if (obj == null) {
            fbInfo.setBaseStatus(SDDPFBStatus.OPEN);
            IObjectPK pk = DirectDeliveryFBFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)fbInfo);
            fbInfo.setId(BOSUuid.read((String)pk.toString()));
        } else {
            DirectDeliveryFBFactory.getLocalInstance(ctx).save((CoreBaseInfo)fbInfo);
        }
        this._singleSupply(ctx, (IObjectValue)fbInfo);
        return super._singleSupply4Port(ctx, param);
    }

    @Override
    protected String _genArrInfo(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap mergeMap = (HashMap)param.get("mergeMap");
        HashMap detailQtyMap = (HashMap)param.get("detailQtyMap");
        IArrivalNoticeBill ianb = ArrivalNoticeBillFactory.getLocalInstance(ctx);
        ArrivalNoticeBillInfo abInfo = new ArrivalNoticeBillInfo();
        abInfo.setSupplier((SupplierInfo)param.get("SupplierInfo"));
        abInfo.setPactnumber(param.get("txtpactnumber") != null ? (String)param.get("txtpactnumber") : "");
        abInfo.setSaleerTel(param.get("txtSaleerTel") != null ? (String)param.get("txtSaleerTel") : "");
        abInfo.setArrivaldate(param.get("pkArrivalDate") != null ? (java.util.Date)param.get("pkArrivalDate") : new java.util.Date());
        abInfo.setArrivaladdress(param.get("txtarrivaladdress") != null ? (String)param.get("txtarrivaladdress") : "");
        abInfo.setTraficertel(param.get("txttraficertel") != null ? (String)param.get("txttraficertel") : "");
        abInfo.setTraficType(param.get("traficType") != null ? (ArrivalTraficType)((Object)param.get("ArrivalTraficType")) : ArrivalTraficType.GL);
        abInfo.setSendbatch(param.get("txtsendbatch") != null ? (String)param.get("txtsendbatch") : "");
        abInfo.setInertel(param.get("txtinertel") != null ? (String)param.get("txtinertel") : "");
        abInfo.setOrdernumber(param.get("txtordernumber") != null ? (String)param.get("txtordernumber") : "");
        abInfo.setDescription(param.get("txtDescription") != null ? (String)param.get("txtDescription") : "");
        abInfo.setIsSource(true);
        abInfo.setStorageOrgUnit(param.get("supOrg") != null ? (StorageOrgUnitInfo)param.get("supOrg") : null);
        abInfo.setBizDate(new java.util.Date());
        IObjectPK pk = ianb.addnew((CoreBaseInfo)abInfo);
        abInfo.setId(BOSUuid.read((String)pk.toString()));
        ArrivalNoticeBillEntryInfo eInfo = (ArrivalNoticeBillEntryInfo)param.get("eInfo");
        eInfo.setParent(abInfo);
        try {
            BOSUuid euuid = this.initEntryUUID(ctx, eInfo);
            eInfo.setId(euuid);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        ArrivalNoticeBillEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)eInfo);
        HashMap mergeToDetail = (HashMap)param.get("mergeToDetail");
        Set keys_m = mergeToDetail.keySet();
        for (Object key : keys_m) {
            DeliveryPlanDetailCollection col = (DeliveryPlanDetailCollection)((Object)mergeToDetail.get(key));
            HashMap<String, ArrivalNoticeBillEntryDEntryInfo> mapArrE = new HashMap<String, ArrivalNoticeBillEntryDEntryInfo>();
            DeliveryPlanMergeInfo mergeInfo = (DeliveryPlanMergeInfo)mergeMap.get(key.toString());
            SelectorItemCollection sic_sp = new SelectorItemCollection();
            sic_sp.add(new SelectorItemInfo("deliveredQty"));
            BigDecimal dQty = BigDecimal.ZERO;
            for (int i = 0; i < col.size(); ++i) {
                DeliveryPlanDetailInfo dpInfo = col.get(i);
                ArrivalNoticeBillEntryDEntryInfo enInfo = new ArrivalNoticeBillEntryDEntryInfo();
                if (mapArrE.containsKey(dpInfo.getPurOrderEntryID())) {
                    enInfo = (ArrivalNoticeBillEntryDEntryInfo)mapArrE.get(dpInfo.getPurOrderEntryID());
                    enInfo.setQty(enInfo.getQty().add((BigDecimal)detailQtyMap.get(dpInfo.getId().toString())));
                } else {
                    enInfo.setMaterial(dpInfo.getMaterial());
                    enInfo.setWarehouse(dpInfo.getDeliveryWareHouse());
                    enInfo.setQty((BigDecimal)detailQtyMap.get(dpInfo.getId().toString()));
                    enInfo.setPurordernumber(dpInfo.getPurOrder().getNumber());
                    enInfo.setPurorderid(dpInfo.getPurOrder().getId().toString());
                    enInfo.setPurorderentryid(dpInfo.getPurOrderEntryID());
                    enInfo.setProject(dpInfo.getProject());
                    enInfo.setBegTrack(dpInfo.getTrackNumber());
                    enInfo.setEndTrack(dpInfo.getTrackNumber());
                    enInfo.setPackNumber(eInfo.getPackNumber());
                    enInfo.setSendBatch(param.get("txtsendbatch") != null ? (String)param.get("txtsendbatch") : null);
                    enInfo.setParent1(eInfo);
                    enInfo.setParentmainid(abInfo);
                    try {
                        String[] ws = this.getpr(ctx, dpInfo.getMaterial().getId().toString(), dpInfo.getStorageOrgUnit().getId().toString(), null);
                        enInfo.setWorkShopType(ws[0] != null ? MaterialWorkShopEnum.getEnum(ws[0]) : MaterialWorkShopEnum.unexistent);
                        enInfo.setWorkShop(IndustryUtils.isEmptyString((String)ws[1]) ? "\u65e0" : ws[1]);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    mapArrE.put(dpInfo.getPurOrderEntryID(), enInfo);
                }
                dQty = dQty.add((BigDecimal)detailQtyMap.get(dpInfo.getId().toString()));
                dpInfo.setDeliveredQty((dpInfo.getDeliveredQty() != null ? dpInfo.getDeliveredQty() : BigDecimal.ZERO).add((BigDecimal)detailQtyMap.get(dpInfo.getId().toString())));
                DeliveryPlanDetailFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)dpInfo, sic_sp);
            }
            dQty = dQty.add(mergeInfo.getDeliveredQty() == null ? BigDecimal.ZERO : mergeInfo.getDeliveredQty());
            mergeInfo.setDeliveredQty(dQty);
            DeliveryPlanMergeFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)mergeInfo, sic_sp);
            Set key_map = mapArrE.keySet();
            for (Object keyn : key_map) {
                ArrivalNoticeBillEntryDEntryInfo enInfo = (ArrivalNoticeBillEntryDEntryInfo)mapArrE.get(keyn);
                if (enInfo.getQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                BOSUuid enuuid = null;
                try {
                    enuuid = this.initEntryeUUID(ctx, enInfo);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                enInfo.setId(enuuid);
                ArrivalNoticeBillEntryDEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)enInfo);
            }
        }
        return super._genArrInfo(ctx, param);
    }

    private String[] getpr(Context ctx, String materialid, String orgid, String projectid) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append(" select sw.CFWorkShopType,sw.CFWorkShop  \n");
        sql.append(" from CT_SC_WorkShopMaterial sw  \n");
        sql.append(" -- left join CT_PUR_StationDivide sd on sw.CFWorkShopType = sd.CFMaterialWS and sw.CFWorkShop = sd.cflocationdefine \n");
        sql.append("  where sw.cfreceiveorgunitid ='" + orgid + "' \n");
        sql.append("   and sw.cfmaterialid = '" + materialid + "' \n");
        if (!IndustryUtils.isEmptyString((String)projectid)) {
            sql.append("   and sw.cfprojectid = '").append(projectid).append("' \n");
        }
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String CFWorkShopType = null;
        String CFWorkShop = null;
        if (irs != null && irs.next()) {
            CFWorkShopType = irs.getString("CFWorkShopType");
            CFWorkShop = irs.getString("CFWorkShop");
        }
        return new String[]{CFWorkShopType, CFWorkShop};
    }

    private BOSUuid initEntryUUID(Context ctx, ArrivalNoticeBillEntryInfo eInfo) throws BOSException, SQLException {
        boolean isFirst = true;
        BOSUuid uuid = null;
        while (isFirst) {
            isFirst = false;
            uuid = BOSUuid.create((BOSObjectType)eInfo.getBOSType());
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(" \n");
            sql.append(" select 1 from( \n");
            sql.append(" select upper(fid) as fid  from  CT_INV_ArrivalNoticeBillEntry  \n");
            sql.append("  )tt \n");
            sql.append("  where fid  = '" + uuid.toString().toUpperCase() + "' \n");
            IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (ir == null || !ir.next()) continue;
            isFirst = true;
        }
        return uuid;
    }

    private BOSUuid initEntryeUUID(Context ctx, ArrivalNoticeBillEntryDEntryInfo eInfo) throws BOSException, SQLException {
        boolean isFirst = true;
        BOSUuid uuid = null;
        while (isFirst) {
            isFirst = false;
            uuid = BOSUuid.create((BOSObjectType)eInfo.getBOSType());
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(" \n");
            sql.append(" select 1 from( \n");
            sql.append(" select upper(fid) as fid  from  CT_INV_ArrivalNBEDE  \n");
            sql.append("  )tt \n");
            sql.append("  where fid  = '" + uuid.toString().toUpperCase() + "' \n");
            IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (ir == null || !ir.next()) continue;
            isFirst = true;
        }
        return uuid;
    }

    @Override
    protected String _genArrInfoNew(Context ctx, HashMap param) throws BOSException, EASBizException {
        return super._genArrInfoNew(ctx, param);
    }

    @Override
    protected String _genUnHostDP(Context ctx, HashMap param) throws BOSException, EASBizException {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer sql = new StringBuffer();
        sql.append(" \n");
        sql.append(" /*dialect*/\n");
        sql.append("  insert into CT_SM_DeliveryPlanDetail \n");
        sql.append("  (fid,cfpurchaseorguniti,cfmaterialid,cfmaterialname,cfunitid,cfstorageorgunitid,cfflow,\n");
        sql.append("  cfsupplystorageorg,CFSupplierID,cfprojectid,cftracknumberid,cfdemandqty,cfdemanddate,cfdeliverywarehous  \n");
        sql.append("  ,FCreatorID,FLastUpdateUserID,fcreatetime,flastupdatetime,fcontrolunitid ,cfisolatedrule,CFDeliveredQty,\n");
        sql.append("  CFPurPersonID,CFPurGroupID ,CFInWhQty,CFPurtypeID,CFDpType )\n");
        sql.append(" select newbosid('17E0D35F') as fid ,pd.fpurchaseorgunitid  ,pde.fmaterialid ,pde.fmaterialname ,\n");
        sql.append(" pde.fbaseunitid ,pde.frequestorgunitid ,pde.cfflow,\n");
        sql.append(" pde.fstorageorgunitid ,pd.fsupplierid  ,pde.fprojectid , pde.ftracknoid  ,pde.fqty - pde.ftotalreceiveqty  ,pde.fdeliverydate ,\n");
        sql.append(" nvl(ir.cfdesignatedwareho,dw.Cfwarehouseid)  ,'' ,'' ,sysdate ,sysdate ,'' ,tm.fisolatedrule , 0 ,pd.fpurchasepersonid ,pd.fpurchasegroupid ,\n");
        sql.append("  0,pd.cfpurtypeid ,'20' \n");
        sql.append("   from t_sm_purorderentry pde\n");
        sql.append("  inner join t_sm_purorder pd on pd.fid = pde.fparentid\n");
        sql.append(" left join t_bd_materialplan tm on tm.forgunit = pde.fstorageorgunitid and tm.fmaterialid = pde.fmaterialid \n");
        sql.append("  left join ( \n");
        sql.append("   select cfflow,cfpurretypeid,max(cfdesignatedwareho) as cfdesignatedwareho \n");
        sql.append("   from CT_PUR_InStoreroomRules \n");
        sql.append("    group by  cfflow,cfpurretypeid\n");
        sql.append("   ) ir on ir.cfflow = pde.cfflow and ir.cfpurretypeid = pd.cfpurtypeid \n");
        sql.append("   left join (\n");
        sql.append("    select cfstorageorgunitid,cfmaterialid,max(Cfwarehouseid) as Cfwarehouseid\n");
        sql.append("   from CT_BD_DivisionWarehouse  \n");
        sql.append("     where Cfdeletedstatus = 1 \n");
        sql.append("    group by cfstorageorgunitid,cfmaterialid\n");
        sql.append("   ) dw on dw.cfstorageorgunitid = pde.frequestorgunitid and dw.cfmaterialid = pde.fmaterialid  \n");
        sql.append("   where pd.cfplanorgunitid is null\n");
        sql.append("   and pd.fbasestatus = 4\n");
        sql.append("  and pde.fqty - pde.ftotalreceiveqty > 0\n");
        sql.append("   and pd.fsupplierid is not null\n");
        sql.append("   and pd.fpurchaseorgunitid is not null  \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return super._genUnHostDP(ctx, param);
    }

    @Override
    protected String _createTmpTable(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table DataNew ( ");
        sql.append("Findex NUMERIC(10),\r\n");
        sql.append("FStep VARCHAR(255),\r\n");
        sql.append("Fcontent VARCHAR(255) ,\r\n");
        sql.append("Ftime  NUMERIC(28,10),\r\n");
        sql.append("Fstatus  VARCHAR(44),\r\n");
        sql.append("FlastIndex  VARCHAR(44),\r\n");
        sql.append("fistop  VARCHAR(44),\r\n");
        sql.append("Fpercent NUMERIC(10) );");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String _releaseTmpTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        return super._releaseTmpTable(ctx, tableName);
    }

    @Override
    protected String _refreshWareHouse(Context ctx, HashMap param) throws BOSException, EASBizException {
        List keyList = new ArrayList();
        keyList = (List)param.get("keyList");
        for (int i = 0; i < keyList.size(); ++i) {
            DeliveryPlanFBdetialVO fbVO = (DeliveryPlanFBdetialVO)keyList.get(i);
            StringBuffer sql = new StringBuffer();
            sql.append(" \n");
            sql.append("  update ct_sm_deliveryplanmerge dp set cfdeliverywarehous =  \n");
            sql.append("  ( \n");
            sql.append(" \t   select whid from  \n");
            sql.append("  (  \n");
            sql.append(" \t      select  isnull(ir.cfdesignatedwareho,dw.Cfwarehouseid)  as whid ,dpe.fid  \n");
            sql.append("       from ct_sm_deliveryplanmerge dpe  \n");
            sql.append(" \t      left join ( \n");
            sql.append("          select cfflow,cfpurretypeid,max(cfdesignatedwareho) as cfdesignatedwareho \n");
            sql.append("          from CT_PUR_InStoreroomRules  \n");
            sql.append("            group by  cfflow,cfpurretypeid \n");
            sql.append("       ) ir on ir.cfflow = dpe.cfflow and ir.cfpurretypeid = dpe.cfpurtypeid  \n");
            sql.append("       left join ( \n");
            sql.append("         select cfstorageorgunitid,cfmaterialid,max(Cfwarehouseid) as Cfwarehouseid \n");
            sql.append("            from CT_BD_DivisionWarehouse   \n");
            sql.append(" \t            where Cfdeletedstatus = 1  \n");
            sql.append("            group by cfstorageorgunitid,cfmaterialid \n");
            sql.append("       ) dw on dw.cfstorageorgunitid = dpe.cfstorageorgunitid and dw.cfmaterialid = dpe.cfmaterialid  \n");
            sql.append("       where dpe.cfdptype = '10' \n");
            sql.append("      and dpe.cfsupplystorageorg = '" + fbVO.getSupplyStroageOrgUnit().getId() + "' \n");
            sql.append("       and dpe.cfstorageorgunitid = '" + fbVO.getStorageOrgUnit().getId() + "' \n");
            sql.append("       and dpe.cfmaterialid = '" + fbVO.getMaterial().getId() + "' \n");
            sql.append("       )tt \n");
            sql.append("       where tt.fid = dp.fid) \n");
            sql.append("       where dp.cfdptype = '10' \n");
            sql.append("       and dp.cfsupplystorageorg = '" + fbVO.getSupplyStroageOrgUnit().getId() + "' \n");
            sql.append("       and dp.cfstorageorgunitid = '" + fbVO.getStorageOrgUnit().getId() + "' \n");
            sql.append("       and dp.cfmaterialid = '" + fbVO.getMaterial().getId() + "' \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.append(" \n");
            sql.append("  update ct_sm_deliveryplanDetail dp set cfdeliverywarehous =  \n");
            sql.append("  ( \n");
            sql.append(" \t   select whid from  \n");
            sql.append("  (  \n");
            sql.append(" \t      select  isnull(ir.cfdesignatedwareho,dw.Cfwarehouseid)  as whid ,dpe.fid  \n");
            sql.append("       from ct_sm_deliveryplanDetail dpe  \n");
            sql.append(" \t      left join ( \n");
            sql.append("          select cfflow,cfpurretypeid,max(cfdesignatedwareho) as cfdesignatedwareho \n");
            sql.append("          from CT_PUR_InStoreroomRules  \n");
            sql.append("            group by  cfflow,cfpurretypeid \n");
            sql.append("       ) ir on ir.cfflow = dpe.cfflow and ir.cfpurretypeid = dpe.cfpurtypeid  \n");
            sql.append("       left join ( \n");
            sql.append("         select cfstorageorgunitid,cfmaterialid,max(Cfwarehouseid) as Cfwarehouseid \n");
            sql.append("            from CT_BD_DivisionWarehouse   \n");
            sql.append(" \t            where Cfdeletedstatus = 1  \n");
            sql.append("            group by cfstorageorgunitid,cfmaterialid \n");
            sql.append("       ) dw on dw.cfstorageorgunitid = dpe.cfstorageorgunitid and dw.cfmaterialid = dpe.cfmaterialid  \n");
            sql.append("       where dpe.cfdptype = '10' \n");
            sql.append("      and dpe.cfsupplystorageorg = '" + fbVO.getSupplyStroageOrgUnit().getId() + "' \n");
            sql.append("       and dpe.cfstorageorgunitid = '" + fbVO.getStorageOrgUnit().getId() + "' \n");
            sql.append("       and dpe.cfmaterialid = '" + fbVO.getMaterial().getId() + "' \n");
            sql.append("       )tt \n");
            sql.append("       where tt.fid = dp.fid) \n");
            sql.append("       where dp.cfdptype = '10' \n");
            sql.append("       and dp.cfsupplystorageorg = '" + fbVO.getSupplyStroageOrgUnit().getId() + "' \n");
            sql.append("       and dp.cfstorageorgunitid = '" + fbVO.getStorageOrgUnit().getId() + "' \n");
            sql.append("       and dp.cfmaterialid = '" + fbVO.getMaterial().getId() + "' \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return "true";
    }

    @Override
    protected String _updatePlanOrg(Context ctx, String orgID, List idList, String type) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyList((List)idList) || IndustryUtils.isEmptyString((String)type)) {
            return "\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a\uff01";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" ");
        sql.append("update ");
        if ("PURORDER".equals(type)) {
            sql.append(" t_sm_purorder ");
        } else {
            sql.append(" t_sm_purrequest ");
        }
        sql.append("  set cfplanorgunitid = '" + orgID + "' ");
        sql.append("\t where fid  in ");
        sql.append(this.getStringIDByList(idList));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return super._updatePlanOrg(ctx, orgID, idList, type);
    }

    private String getStringIDByList(List idList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = idList.iterator();
        strBuf.append("(");
        while (it.hasNext()) {
            strBuf.append("'");
            strBuf.append(it.next());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.append(")");
        } else {
            strBuf.append(")");
        }
        return strBuf.toString();
    }
}

