/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.opening.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.sfc.opening.OpenIngItemRegisterEntryCollection;
import com.kingdee.eas.mm.sfc.opening.OpenIngItemRegisterEntryInfo;
import com.kingdee.eas.mm.sfc.opening.OpenIngItemRegisterFactory;
import com.kingdee.eas.mm.sfc.opening.OpenIngItemRegisterInfo;
import com.kingdee.eas.mm.sfc.opening.app.AbstractOpenIngItemRegisterControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OpenIngItemRegisterControllerBean
extends AbstractOpenIngItemRegisterControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.opening.app.OpenIngItemRegisterControllerBean");

    @Override
    public void auditor(Context ctx, String objectValueID) throws BOSException, EASBizException {
        OpenIngItemRegisterInfo opening = null;
        if (objectValueID.indexOf(",") == -1) {
            opening = this.getOpenIngItemRegisterInfo(ctx, (IObjectPK)new ObjectUuidPK(objectValueID));
            opening.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
            Date cuttTime = new Date();
            opening.setAuditorTime(cuttTime);
            opening.setBaseStatus(BillBaseStatusEnum.AUDITED);
            super.update(ctx, (IObjectPK)new ObjectUuidPK(opening.getId()), (CoreBaseInfo)opening);
            this.setManuOrderOpenQty(ctx, opening, "+");
        } else {
            String[] id = objectValueID.split(",");
            for (int i = 0; i < id.length; ++i) {
                opening = this.getOpenIngItemRegisterInfo(ctx, (IObjectPK)new ObjectUuidPK(id[i].trim().toString()));
                opening.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
                Date cuttTime = new Date();
                opening.setAuditorTime(cuttTime);
                opening.setBaseStatus(BillBaseStatusEnum.AUDITED);
                super.update(ctx, (IObjectPK)new ObjectUuidPK(opening.getId()), (CoreBaseInfo)opening);
                this.setManuOrderOpenQty(ctx, opening, "+");
            }
        }
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        OpenIngItemRegisterInfo openinfo = (OpenIngItemRegisterInfo)model;
        openinfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        IObjectPK pk = super.save(ctx, (CoreBaseInfo)openinfo);
        return pk;
    }

    public IObjectPK submit(Context arg0, CoreBaseInfo arg1) throws BOSException, EASBizException {
        OpenIngItemRegisterInfo openinfo = (OpenIngItemRegisterInfo)arg1;
        openinfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        IObjectPK pk = super.submit(arg0, (CoreBaseInfo)openinfo);
        return pk;
    }

    @Override
    public void unAuditor(Context ctx, String objectValueID) throws BOSException, EASBizException {
        super.unAuditor(ctx, objectValueID);
        this.updateStatus(ctx, objectValueID, BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    public void updateStatus(Context ctx, String objectValueID, BillBaseStatusEnum item) throws EASBizException, BOSException {
        OpenIngItemRegisterInfo opening = null;
        if (objectValueID.indexOf(",") == -1) {
            opening = this.getOpenIngItemRegisterInfo(ctx, (IObjectPK)new ObjectUuidPK(objectValueID));
            opening.setBaseStatus(item);
            if (item == BillBaseStatusEnum.TEMPORARILYSAVED) {
                this.setManuOrderOpenQty(ctx, opening, "-");
                opening.setAuditor(null);
                opening.setAuditorTime(null);
            }
            this.update(ctx, (IObjectPK)new ObjectUuidPK(opening.getId()), (CoreBaseInfo)opening);
        } else {
            String[] id = objectValueID.split(",");
            for (int i = 0; i < id.length; ++i) {
                opening = this.getOpenIngItemRegisterInfo(ctx, (IObjectPK)new ObjectUuidPK(id[i].trim().toString()));
                opening.setBaseStatus(item);
                if (item == BillBaseStatusEnum.TEMPORARILYSAVED) {
                    this.setManuOrderOpenQty(ctx, opening, "-");
                    opening.setAuditor(null);
                    opening.setAuditorTime(null);
                }
                this.update(ctx, (IObjectPK)new ObjectUuidPK(opening.getId()), (CoreBaseInfo)opening);
            }
        }
    }

    @Override
    public void appClose(Context ctx, String objectValuseid) throws BOSException, EASBizException {
        super.appClose(ctx, objectValuseid);
        this.updateStatus(ctx, objectValuseid, BillBaseStatusEnum.FINISH);
    }

    @Override
    public void unAppClose(Context ctx, String objectValuseid) throws BOSException, EASBizException {
        super.unAppClose(ctx, objectValuseid);
        this.updateStatus(ctx, objectValuseid, BillBaseStatusEnum.AUDITED);
    }

    @Override
    public void close(Context ctx, String objectValueid) throws BOSException, EASBizException {
        super.close(ctx, objectValueid);
        this.updateStatus(ctx, objectValueid, BillBaseStatusEnum.CLOSED);
    }

    @Override
    public void unClose(Context ctx, String objectValueid) throws BOSException, EASBizException {
        super.unClose(ctx, objectValueid);
        this.updateStatus(ctx, objectValueid, BillBaseStatusEnum.FINISH);
    }

    public void setManuOrderOpenQty(Context ctx, OpenIngItemRegisterInfo openinfo, String str) throws EASBizException, BOSException {
        OpenIngItemRegisterEntryCollection entrycon = openinfo.getEntrys();
        BigDecimal manuopenQty = new BigDecimal("0.00");
        BigDecimal openQty = new BigDecimal(0);
        Object orderinfo = null;
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal repQty = new BigDecimal("0.00");
        BigDecimal sumRepQty = new BigDecimal("0.00");
        if (openinfo.getManuOrder() != null && !openinfo.getManuOrder().getId().equals((Object)"")) {
            for (int i = 0; i < entrycon.size(); ++i) {
                OpenIngItemRegisterEntryInfo entryinfo = entrycon.get(i);
                ManufactureOrderStockInfo orderentryinfo = (ManufactureOrderStockInfo)ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(entryinfo.getSourceBillId()));
                if (orderentryinfo.get("openQty") != null) {
                    manuopenQty = new BigDecimal(orderentryinfo.get("openQty").toString());
                }
                if (entryinfo.getSumRepQty() != null) {
                    sumRepQty = entryinfo.getSumRepQty();
                }
                openQty = entryinfo.getOpenQty();
                if (str.equals("+")) {
                    orderentryinfo.put("openQty", (Object)manuopenQty.add(openQty));
                } else {
                    if (entryinfo.getRepQty() != null) {
                        repQty = new BigDecimal(entryinfo.getRepQty());
                    }
                    if (repQty.compareTo(ZERO) == 1) {
                        entryinfo.setRepQty("0");
                        entryinfo.setSumRepQty(new BigDecimal(0));
                        entryinfo.setRepTime(null);
                    }
                    orderentryinfo.put("openQty", (Object)manuopenQty.subtract(openQty).add(sumRepQty));
                }
                ManufactureOrderStockFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(orderentryinfo.getId()), (CoreBaseInfo)orderentryinfo);
            }
        }
    }

    @Override
    public void feeMaterial(Context ctx, String objectValueid) throws BOSException, EASBizException {
        OpenIngItemRegisterInfo opening = null;
        if (objectValueid.indexOf(",") == -1) {
            opening = this.getOpenIngItemRegisterInfo(ctx, (IObjectPK)new ObjectUuidPK(objectValueid));
            this.updateRepQty(ctx, opening);
        } else {
            String[] id = objectValueid.split(",");
            for (int i = 0; i < id.length; ++i) {
                opening = this.getOpenIngItemRegisterInfo(ctx, (IObjectPK)new ObjectUuidPK(id[i].trim().toString()));
                this.updateRepQty(ctx, opening);
            }
        }
    }

    private void updateRepQty(Context ctx, OpenIngItemRegisterInfo openinfo) throws EASBizException, BOSException {
        OpenIngItemRegisterEntryCollection opencon = openinfo.getEntrys();
        ManufactureOrderInfo orderinfo = null;
        BigDecimal actIssueQty = new BigDecimal(0.0);
        BigDecimal totalDirectReceiveQty = new BigDecimal(0.0);
        BigDecimal feedingQty = new BigDecimal(0.0);
        BigDecimal materialFeedingQty = new BigDecimal(0.0);
        BigDecimal rejectedQty = new BigDecimal(0.0);
        BigDecimal unitQty = new BigDecimal(0.0);
        BigDecimal openQty = new BigDecimal(0.0);
        BigDecimal finishedQty = new BigDecimal(0.0);
        BigDecimal repqty = new BigDecimal(0.0);
        BigDecimal sumRepQty = new BigDecimal(0.0);
        Date cuttTime = new Date();
        if (openinfo.getManuOrder() != null) {
            orderinfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(openinfo.getManuOrder().getId().toString()));
            finishedQty = orderinfo.getFinishedQty();
            for (int i = 0; i < opencon.size(); ++i) {
                OpenIngItemRegisterEntryInfo openentryinfo = opencon.get(i);
                if (openentryinfo.getSourceBillId() == null) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.sfc.opening.EMMSCMOpeningResource", (String)"0EMMSCMOpening-0000", (Locale)ctx.getLocale()) + "\uff1a" + openinfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.mm.sfc.opening.EMMSCMOpeningResource", (String)"0EMMSCMOpening-0001", (Locale)ctx.getLocale())));
                }
                ManufactureOrderStockInfo stockinfo = (ManufactureOrderStockInfo)ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(openentryinfo.getSourceBillId()));
                if (stockinfo.getActIssueQty() != null) {
                    actIssueQty = stockinfo.getActIssueQty();
                }
                if (stockinfo.getTotalDirectReceiveQty() != null) {
                    totalDirectReceiveQty = stockinfo.getTotalDirectReceiveQty();
                }
                if (stockinfo.getFeedingQty() != null) {
                    feedingQty = stockinfo.getFeedingQty();
                }
                if (stockinfo.getMaterialFeedingQty() != null) {
                    materialFeedingQty = stockinfo.getMaterialFeedingQty();
                }
                if (stockinfo.getRejectedQty() != null) {
                    rejectedQty = stockinfo.getRejectedQty();
                }
                if (stockinfo.getUnitQty() != null) {
                    unitQty = stockinfo.getUnitQty();
                }
                if (openentryinfo.getRepQty() != null) {
                    sumRepQty = openentryinfo.getSumRepQty();
                }
                openQty = new BigDecimal(stockinfo.get("openQty").toString());
                repqty = actIssueQty.add(totalDirectReceiveQty).add(feedingQty).add(materialFeedingQty).subtract(rejectedQty).subtract(finishedQty.multiply(unitQty)).add(openQty);
                sumRepQty = sumRepQty.add(repqty);
                if (repqty.compareTo(new BigDecimal(0)) == 1) {
                    if (repqty.compareTo(openentryinfo.getOpenQty().subtract(sumRepQty)) == 1) {
                        openentryinfo.setRepQty(openentryinfo.getOpenQty().subtract(sumRepQty).toString());
                        openentryinfo.setRepTime(cuttTime);
                        openentryinfo.setSumRepQty(sumRepQty);
                        stockinfo.put("openQty", (Object)openQty.subtract(repqty));
                        ManufactureOrderStockFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(stockinfo.getId()), (CoreBaseInfo)stockinfo);
                        continue;
                    }
                    openentryinfo.setRepQty(repqty.toString());
                    openentryinfo.setRepTime(cuttTime);
                    openentryinfo.setSumRepQty(sumRepQty);
                    stockinfo.put("openQty", (Object)openQty.subtract(repqty));
                    ManufactureOrderStockFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(stockinfo.getId()), (CoreBaseInfo)stockinfo);
                    continue;
                }
                openentryinfo.setRepQty("0");
                openentryinfo.setSumRepQty(sumRepQty);
            }
            OpenIngItemRegisterFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(openinfo.getId()), (CoreBaseInfo)openinfo);
        }
    }

    @Override
    public void getBOTPValuse(Context ctx, IObjectCollection objectCon) throws BOSException, EASBizException {
        CoreBillBaseCollection billcolle = (CoreBillBaseCollection)objectCon;
        if (billcolle.size() > 0) {
            IBOTMapping botFac = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botInfo = null;
            BOTMappingCollection botCol = botFac.getBOTMappingCollection("where name='MM_DMES035' and extRule.isEffected=1  ");
            if (botCol.size() != 1) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.sfc.opening.EMMSCMOpeningResource", (String)"0EMMSCMOpening-0002", (Locale)ctx.getLocale())));
            }
            botInfo = botCol.get(0);
            this.BotpToMaterialReq(ctx, billcolle, botInfo);
        }
    }

    protected void BotpToMaterialReq(Context ctx, CoreBillBaseCollection CollInfo, BOTMappingInfo botInfo) throws BOSException, EASBizException {
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = null;
        result = btp.transform(CollInfo, botInfo);
        BOTRelationCollection relations = result.getBOTRelationCollection();
        IObjectCollection bills = result.getBills();
        for (int i = 0; i < bills.size(); ++i) {
            OpenIngItemRegisterInfo openinfo = (OpenIngItemRegisterInfo)bills.getObject(i);
            btp.saveRelations((CoreBillBaseInfo)openinfo, relations);
        }
    }
}

