/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.processor.stocktransferplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferbillUtil;

public class SaleIssueWriteBackStockQtyProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -969432875670149126L;

    public SaleIssueWriteBackStockQtyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SaleIssueWriteBackStockQtyProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleIssueWriteBackStockQtyProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (null == collection || collection.size() == 0) {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            StockTransferBillInfo billInfo;
            IObjectValue objectValue = collection.getObject(i);
            StockTransferBillInfo stockTransferBillInfo = objectValue == null ? null : (billInfo = objectValue instanceof StockTransferBillInfo ? (StockTransferBillInfo)objectValue : null);
            if (!(objectValue instanceof StockTransferBillInfo)) continue;
            if (BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
                StockTransferbillUtil.checkCanSaveQty(this.ctx, billInfo);
                continue;
            }
            if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
                StockTransferbillUtil.checkCanAuditQty(this.ctx, billInfo);
                continue;
            }
            if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) continue;
            StockTransferbillUtil.checkCanUnAuditQty(this.ctx, billInfo);
        }
        StockTransferbillUtil.handleAfterTransform(this.ctx, collection);
    }
}

