/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.processor.stocktransferplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlan;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanCollection;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanFactory;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class TransferOrderWriteBackStockTransferPlanProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1343806838619587590L;

    public TransferOrderWriteBackStockTransferPlanProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public TransferOrderWriteBackStockTransferPlanProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public TransferOrderWriteBackStockTransferPlanProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (null == collection || collection.size() == 0) {
            return;
        }
        if (!(BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction) || BatchActionEnum.AUDIT.equals((Object)this.batchAction) || BatchActionEnum.ADDNEW.equals((Object)this.batchAction))) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            TransferOrderBillInfo tobInfo;
            IObjectValue objectValue = collection.getObject(i);
            TransferOrderBillInfo transferOrderBillInfo = objectValue == null ? null : (tobInfo = objectValue instanceof TransferOrderBillInfo ? (TransferOrderBillInfo)objectValue : null);
            if (tobInfo == null) continue;
            if (tobInfo.getSourceBillId() == null || "".equals(tobInfo.getSourceBillId())) {
                collection.removeObject(objectValue);
                continue;
            }
            if (tobInfo != null && BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
                this.auditCheck(this.ctx, (IObjectPK)new ObjectUuidPK(tobInfo.getId()));
                continue;
            }
            if (tobInfo == null || !BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) continue;
            this.checkIsOverProjectQry(this.ctx, tobInfo);
        }
        if (null == collection || collection.size() == 0) {
            return;
        }
        if (BatchActionEnum.ADDNEW.equals((Object)this.batchAction) || BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            this.writeBackSourceBill(this.ctx, collection, this.batchAction);
        }
    }

    protected void writeBackSourceBill(Context ctx, IObjectCollection objectCollection, BatchActionEnum action) throws BOSException, EASBizException {
        if (ctx == null || objectCollection == null || action == null) {
            return;
        }
        if (objectCollection.size() == 0 || action == null) {
            return;
        }
        int effectedRows = 0;
        StringBuffer sql = new StringBuffer();
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        for (int index = 0; index < objectCollection.size(); ++index) {
            TransferOrderBillEntryCollection tobeCollection;
            TransferOrderBillInfo tobInfo;
            IObjectValue objectValue = objectCollection.getObject(index);
            TransferOrderBillInfo transferOrderBillInfo = objectValue == null ? null : (tobInfo = objectValue instanceof TransferOrderBillInfo ? (TransferOrderBillInfo)objectValue : null);
            if (tobInfo == null || (tobeCollection = tobInfo.getEntry()) == null || tobeCollection.size() <= 0) continue;
            for (int entryIndex = 0; entryIndex < tobeCollection.size(); ++entryIndex) {
                BigDecimal qty;
                BOSObjectType sourceBillType;
                String sourceBillID;
                TransferOrderBillEntryInfo tobeInfo = tobeCollection.get(entryIndex);
                String string = sourceBillID = tobeInfo == null ? null : tobeInfo.getSourceBillId();
                BOSUuid sourceBillBOSUUID = sourceBillID == null ? null : (sourceBillID.trim().length() == 0 ? null : BOSUuid.read((String)sourceBillID));
                BOSObjectType bOSObjectType = sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                if (sourceBillID == null || sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType)) continue;
                BigDecimal bigDecimal = tobeInfo == null ? BigDecimal.ZERO : (qty = tobeInfo.getQty() == null ? BigDecimal.ZERO : tobeInfo.getQty());
                BigDecimal sumQty = qtyMap.containsKey(sourceBillID) ? (qtyMap.get(sourceBillID) == null ? BigDecimal.ZERO : (qtyMap.get(sourceBillID) instanceof BigDecimal ? (BigDecimal)qtyMap.get(sourceBillID) : BigDecimal.ZERO)) : BigDecimal.ZERO;
                qtyMap.put(sourceBillID, sumQty.add(qty));
            }
        }
        if (qtyMap != null && qtyMap.size() > 0) {
            Set qtyMapKeySet = qtyMap.keySet();
            for (Object qtyMapKey : qtyMapKeySet) {
                BOSObjectType sourceType;
                String sourceID;
                String string = sourceID = qtyMapKey == null ? null : qtyMapKey.toString();
                BOSUuid sourceBOSUUID = sourceID == null ? null : (sourceID.trim().length() == 0 ? null : BOSUuid.read((String)sourceID));
                BOSObjectType bOSObjectType = sourceType = sourceBOSUUID == null ? null : sourceBOSUUID.getType();
                if (sourceID == null || sourceID == null || sourceType == null || !new StockTransferPlan().getType().equals((Object)sourceType)) continue;
                if (BatchActionEnum.ADDNEW.equals((Object)action) || BatchActionEnum.SAVE.equals((Object)action) || BatchActionEnum.SUBMIT.equals((Object)action)) {
                    sql.setLength(0);
                    sql.append("Update CT_MO_StockTransferPlan UT\r\n");
                    sql.append("Set CFSubmitTransferQty=IsNull((");
                    sql.append("Select\r\n");
                    sql.append("Sum(TOBE.FQty) FTOBESumQty\r\n");
                    sql.append("From CT_MO_StockTransferPlan STP\r\n");
                    sql.append("Inner Join T_IM_TransferOrderBillEntry TOBE On TOBE.FSourceBillID=STP.FID\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And STP.FID='").append(sourceID).append("'\r\n");
                    sql.append("),0)\r\n");
                    sql.append(" + IsNull((");
                    sql.append("Select\r\n");
                    sql.append("Sum(SOBE.FQty) FTOBESumQty\r\n");
                    sql.append("From CT_MO_StockTransferPlan STP\r\n");
                    sql.append("Inner Join t_sd_saleorderentry SOBE On SOBE.FSourceBillID=STP.FID\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And STP.FID='").append(sourceID).append("'\r\n");
                    sql.append("),0)\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And UT.FID='").append(sourceID).append("'\r\n");
                }
                effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                this.writeStockTransferPlanDetial(ctx, sourceID, action);
                System.out.println("Execute SQL Effected Rows " + effectedRows + ":\r\n" + sql.toString());
            }
        }
    }

    protected void auditCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ITransferOrderBill iorderInstance = TransferOrderBillFactory.getLocalInstance((Context)ctx);
        if (iorderInstance.exists(pk)) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.clear();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("sourceBillId"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.seq"));
            sic.add(new SelectorItemInfo("entry.sourceBillId"));
            TransferOrderBillInfo tobInfo = iorderInstance.getTransferOrderBillInfo(pk, sic);
            TransferOrderBillEntryCollection tobeCollection = tobInfo.getEntry();
            ArrayList<String> sourceIDList = new ArrayList<String>();
            if (tobeCollection != null && tobeCollection.size() > 0) {
                for (int entryIndex = 0; entryIndex < tobeCollection.size(); ++entryIndex) {
                    BOSObjectType sourceBillType;
                    String sourceBillID;
                    TransferOrderBillEntryInfo tobeInfo = tobeCollection.get(entryIndex);
                    String string = sourceBillID = tobeInfo == null ? null : tobeInfo.getSourceBillId();
                    BOSUuid sourceBillBOSUUID = sourceBillID == null ? null : (sourceBillID.trim().length() == 0 ? null : BOSUuid.read((String)sourceBillID));
                    BOSObjectType bOSObjectType = sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                    if (sourceBillID == null || sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType) || sourceIDList.contains(sourceBillID)) continue;
                    sourceIDList.add(sourceBillID);
                }
            }
            if (sourceIDList != null && sourceIDList.size() > 0) {
                for (int index = 0; index < sourceIDList.size(); ++index) {
                    StockTransferPlanInfo stpInfo;
                    BOSObjectType sourceType;
                    String sourceID;
                    String string = sourceID = sourceIDList.get(index) == null ? null : sourceIDList.get(index).toString();
                    BOSUuid sourceBOSUUID = sourceID == null ? null : (sourceID.trim().length() == 0 ? null : BOSUuid.read((String)sourceID));
                    BOSObjectType bOSObjectType = sourceType = sourceBOSUUID == null ? null : sourceBOSUUID.getType();
                    if (sourceID == null || sourceBOSUUID == null || sourceType == null || !new StockTransferPlan().getType().equals((Object)sourceType)) continue;
                    sic.clear();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("submitQty"));
                    filterInfo.getFilterItems().clear();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sourceID, CompareType.EQUALS));
                    entityViewInfo.setFilter(filterInfo);
                    entityViewInfo.setSelector(sic);
                    StockTransferPlanCollection stpCollection = StockTransferPlanFactory.getLocalInstance((Context)ctx).getStockTransferPlanCollection(entityViewInfo);
                    StockTransferPlanInfo stockTransferPlanInfo = stpCollection == null ? null : (stpInfo = stpCollection.size() == 0 ? null : stpCollection.get(0));
                    if (stpInfo == null) continue;
                    BigDecimal stpSubmitQty = stpInfo.getSubmitQty() == null ? BigDecimal.ZERO : stpInfo.getSubmitQty();
                    String number = stpInfo.getNumber() == null ? "" : stpInfo.getNumber();
                    sic.clear();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("seq"));
                    sic.add(new SelectorItemInfo("qty"));
                    sic.add(new SelectorItemInfo("sourceBillId"));
                    filterInfo.getFilterItems().clear();
                    filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceID, CompareType.EQUALS));
                    entityViewInfo.setFilter(filterInfo);
                    entityViewInfo.setSelector(sic);
                    TransferOrderBillEntryCollection destTOBECollection = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx).getTransferOrderBillEntryCollection(entityViewInfo);
                    BigDecimal existsSumQty = BigDecimal.ZERO;
                    if (destTOBECollection != null && destTOBECollection.size() > 0) {
                        for (int entryIndex = 0; entryIndex < destTOBECollection.size(); ++entryIndex) {
                            TransferOrderBillEntryInfo tobeInfo = destTOBECollection.get(entryIndex);
                            BigDecimal qty = tobeInfo == null ? BigDecimal.ZERO : (tobeInfo.getQty() == null ? BigDecimal.ZERO : tobeInfo.getQty());
                            existsSumQty = existsSumQty.add(qty);
                        }
                    }
                    if (stpSubmitQty.compareTo(existsSumQty) >= 0) continue;
                    String strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"DBJHSQSLXYXY", (Object[])new Object[]{number, stpSubmitQty.setScale(2).toString(), existsSumQty.setScale(2).toString()});
                    throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0008", (Locale)ctx.getLocale()), strInfo));
                }
            }
        }
    }

    protected void autoBotp(Context ctx, TransferOrderBillInfo billInfo) throws BOSException, EASBizException {
        boolean isReverse = billInfo.getBizDirection().getValue() == 2;
        IBOTMapping botFac = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botInfo = null;
        BOTMappingCollection botCol = null;
        botCol = isReverse ? botFac.getBOTMappingCollection("where name='INM-039' and srcEntityName='5C2A1F0C' and destEntityName='CC3E933B' and extRule.isEffected=1  ") : botFac.getBOTMappingCollection("where name='INM-023' and srcEntityName='5C2A1F0C' and destEntityName='CC3E933B' and extRule.isEffected=1  ");
        if (botCol.size() != 1) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0009", (Locale)ctx.getLocale()));
        }
        botInfo = botCol.get(0);
        CoreBillBaseCollection coreBillBaseCol = new CoreBillBaseCollection();
        coreBillBaseCol.add((CoreBillBaseInfo)billInfo);
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = btp.transform(coreBillBaseCol, "CC3E933B", (IObjectPK)new ObjectUuidPK(botInfo.getId().toString()));
        if (result.getBills().size() <= 0) {
            return;
        }
        IObjectValue destBillInfo = result.getBills().getObject(0);
        btp.saveRelations((CoreBillBaseInfo)destBillInfo, result.getBOTRelationCollection());
    }

    protected void checkIsOverProjectQry(Context ctx, TransferOrderBillInfo transferOrderBillInfo) throws EASBizException, BOSException {
        if (transferOrderBillInfo == null) {
            return;
        }
        String fid = "";
        String sourceBillID = "";
        if (transferOrderBillInfo.getId() != null) {
            fid = transferOrderBillInfo.getId().toString();
            sourceBillID = transferOrderBillInfo.getSourceBillId();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select fmaterialnumber,fmaterialname,fprojectnumber,fthisqty,freqqty,fdbddqty,finorg,foutorg \r\n");
        sql.append(" from ( \r\n");
        sql.append(" Select m.fnumber as fmaterialnumber,m.fname_l2 as fmaterialname,m.fid as fmaterialid, \r\n");
        sql.append(" p.fnumber as fprojectnumber,p.fid as fprojectid,sum(a.fqty) as fthisqty, \r\n");
        sql.append(" isNull(sum(s.fqty),0) as freqqty,isNull(sum(e.fqty),0) as fdbddqty,inorg.fname_l2 as finorg, outorg.fname_l2 as foutorg \r\n");
        sql.append(" from T_IM_TransferOrderBillEntry a \r\n");
        sql.append(" inner join T_IM_TransferOrderBill aa on a.fparentid = aa.fid \r\n");
        sql.append(" inner join t_bd_material m on a.fmaterialid = m.fid \r\n");
        sql.append(" inner join t_mm_project p on a.fprojectid = p.fid \r\n");
        sql.append(" inner join t_org_storage inorg on aa.Freceiptstorageorgunitid = inorg.fid \r\n");
        sql.append(" inner join t_org_storage outorg on aa.Fissuestorageorgunitid = outorg.fid \r\n");
        sql.append(" inner join(select b.CFMaterialID as fmaterialid,b.cfprojectid as fprojectid,sum(b.CFSubmitQty) as fqty,b.Cfstorageorgunitid as Freceiptstorageorgunitid,b.Cfsupplysouid as Fissuestorageorgunitid \r\n");
        sql.append(" from CT_MO_StockTransferPlan b ");
        sql.append(" group by b.CFMaterialID,b.cfprojectid,b.Cfstorageorgunitid,b.Cfsupplysouid \r\n");
        sql.append(" ) s on m.fid = s.fmaterialid and p.fid = s.fprojectid and aa.Freceiptstorageorgunitid = s.Freceiptstorageorgunitid and aa.Fissuestorageorgunitid = s.Fissuestorageorgunitid \r\n");
        sql.append(" inner join(select d.fmaterialid as fmaterialid,d.fprojectid as fprojectid,sum(fqty) as fqty ,ca.Freceiptstorageorgunitid,ca.Fissuestorageorgunitid \r\n");
        sql.append(" from T_IM_TransferOrderBillEntry d  \r\n");
        sql.append(" inner join T_IM_TransferOrderBill ca on d.fparentid = ca.fid");
        sql.append(" where d.fparentid <> '").append(fid);
        sql.append("' and   ca.FSOURCEBILLID ='").append(sourceBillID).append("' group by d.fmaterialid,d.fprojectid,ca.Freceiptstorageorgunitid,ca.Fissuestorageorgunitid \r\n");
        sql.append(" ) e on m.fid = e.fmaterialid and p.fid = e.fprojectid  and aa.Freceiptstorageorgunitid = e.Freceiptstorageorgunitid and aa.Fissuestorageorgunitid = e.Fissuestorageorgunitid  \r\n");
        sql.append(" where a.fparentid = '").append(fid).append("' \r\n");
        sql.append(" and exists(select 1 from  CT_MO_StockTransferPlan c where c.fid = a.fsourcebillid) \r\n");
        sql.append(" group by m.fnumber,m.fname_l2,m.fid,p.fnumber,p.fid,inorg.fname_l2 , outorg.fname_l2,aa.Freceiptstorageorgunitid,aa.Fissuestorageorgunitid \r\n");
        sql.append(" ) aaa where aaa.fthisqty + aaa.fdbddqty > aaa.freqqty \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String ferrtext = "";
        try {
            while (rs.next()) {
                ferrtext = ferrtext + "\r\n" + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0010", (Locale)ctx.getLocale()) + rs.getString("fmaterialnumber") + " " + rs.getString("fmaterialname") + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0011", (Locale)ctx.getLocale()) + "[" + rs.getString("foutorg") + "]," + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0012", (Locale)ctx.getLocale()) + "[" + rs.getString("finorg") + "]," + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0013", (Locale)ctx.getLocale()) + "[" + rs.getString("fprojectnumber") + "]" + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0014", (Locale)ctx.getLocale()) + "[" + rs.getString("fthisqty") + "] + " + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0015", (Locale)ctx.getLocale()) + "[" + rs.getString("fdbddqty") + "] " + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0016", (Locale)ctx.getLocale()) + "[" + rs.getString("freqqty") + "]\uff0c" + EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0017", (Locale)ctx.getLocale()) + "!\r\n";
            }
            if (ferrtext != null && !"".equals(ferrtext)) {
                throw new EASBizException(new NumericExceptionSubItem("", ferrtext));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0004", (Locale)ctx.getLocale()) + e.getMessage()));
        }
    }

    public void handleAfterTransform(Context ctx, String action, IObjectCollection objectCollection) throws EASBizException, BOSException {
        if (objectCollection == null) {
            return;
        }
        if (objectCollection.size() == 0) {
            return;
        }
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int index = 0; index < objectCollection.size(); ++index) {
            TransferOrderBillEntryCollection tobeCollection;
            TransferOrderBillInfo tobInfo;
            IObjectValue objectValue = objectCollection.getObject(index);
            TransferOrderBillInfo transferOrderBillInfo = objectValue == null ? null : (tobInfo = objectValue instanceof TransferOrderBillInfo ? (TransferOrderBillInfo)objectValue : null);
            if (tobInfo == null || (tobeCollection = tobInfo.getEntry()) == null || tobeCollection.size() == 0) continue;
            for (int entryIndex = 0; entryIndex < tobeCollection.size(); ++entryIndex) {
                BigDecimal qty;
                BOSObjectType sourceBillType;
                String sourceBillID;
                TransferOrderBillEntryInfo tobeInfo = tobeCollection.get(entryIndex);
                String string = sourceBillID = tobeInfo == null ? null : tobeInfo.getSourceBillId();
                BOSUuid sourceBillBOSUUID = sourceBillID == null ? null : (sourceBillID.trim().length() == 0 ? null : BOSUuid.read((String)sourceBillID));
                BOSObjectType bOSObjectType = sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                if (sourceBillID == null || sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType)) continue;
                BigDecimal bigDecimal = tobeInfo == null ? BigDecimal.ZERO : (qty = tobeInfo.getQty() == null ? BigDecimal.ZERO : tobeInfo.getQty());
                BigDecimal sumQty = qtyMap.containsKey(sourceBillID) ? (qtyMap.get(sourceBillID) == null ? BigDecimal.ZERO : (qtyMap.get(sourceBillID) instanceof BigDecimal ? (BigDecimal)qtyMap.get(sourceBillID) : BigDecimal.ZERO)) : BigDecimal.ZERO;
                qtyMap.put(sourceBillID, sumQty.add(qty));
            }
        }
        if (qtyMap != null && qtyMap.size() > 0) {
            Set qtyMapKeySet = qtyMap.keySet();
            for (Object qtyMapKey : qtyMapKeySet) {
                BOSObjectType sourceBillType;
                String sourceBillID;
                String string = sourceBillID = qtyMapKey == null ? null : qtyMapKey.toString();
                BOSUuid sourceBillBOSUUID = sourceBillID == null ? null : (sourceBillID.trim().length() == 0 ? null : BOSUuid.read((String)sourceBillID));
                BOSObjectType bOSObjectType = sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                if (sourceBillID == null || sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType)) continue;
                BigDecimal newSumQty = qtyMap.containsKey(sourceBillID) ? (qtyMap.get(sourceBillID) == null ? BigDecimal.ZERO : (qtyMap.get(sourceBillID) instanceof BigDecimal ? (BigDecimal)qtyMap.get(sourceBillID) : BigDecimal.ZERO)) : BigDecimal.ZERO;
                sic.clear();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("submitQty"));
                filterInfo.getFilterItems().clear();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sourceBillID, CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                entityViewInfo.setSelector(sic);
                StockTransferPlanCollection stpCollection = StockTransferPlanFactory.getLocalInstance((Context)ctx).getStockTransferPlanCollection(entityViewInfo);
                StockTransferPlanInfo stpInfo = stpCollection == null ? null : (stpCollection.size() == 0 ? null : stpCollection.get(0));
                if (stpInfo == null) continue;
                BigDecimal stpSubmitQty = stpInfo.getSubmitQty() == null ? BigDecimal.ZERO : stpInfo.getSubmitQty();
                String number = stpInfo.getNumber() == null ? "" : stpInfo.getNumber();
                sic.clear();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("seq"));
                sic.add(new SelectorItemInfo("qty"));
                sic.add(new SelectorItemInfo("sourceBillId"));
                filterInfo.getFilterItems().clear();
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillID, CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                entityViewInfo.setSelector(sic);
                TransferOrderBillEntryCollection tobeCollection = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx).getTransferOrderBillEntryCollection(entityViewInfo);
                BigDecimal existsSumQty = BigDecimal.ZERO;
                if (tobeCollection != null && tobeCollection.size() > 0) {
                    for (int index = 0; index < tobeCollection.size(); ++index) {
                        TransferOrderBillEntryInfo tobeInfo = tobeCollection.get(index);
                        BigDecimal qty = tobeInfo == null ? BigDecimal.ZERO : (tobeInfo.getQty() == null ? BigDecimal.ZERO : tobeInfo.getQty());
                        existsSumQty = existsSumQty.add(qty);
                    }
                }
                if (stpSubmitQty.compareTo(newSumQty.add(existsSumQty)) >= 0) continue;
                String strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"DBJHXTDBDD", (Object[])new Object[]{number, stpSubmitQty.setScale(2, 4).toString(), newSumQty.setScale(2, 4).toString(), existsSumQty.setScale(2, 4).toString()});
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0018", (Locale)ctx.getLocale()), strInfo));
            }
        }
    }

    protected void writeStockTransferPlanDetial(Context ctx, String sourceBillid, BatchActionEnum action) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select fid, CFSTORAGEORGUNITID,CFMATERIALID,Isnull(CFTRANSFERQTY,0) As CFTRANSFERQTY ,Isnull(CFSUBMITQTY,0) As CFSUBMITQTY,Isnull(CFAUDITTRANSFERQTY,0) As CFAUDITTRANSFERQTY , \r\n");
        sql.append(" CFPROJECTID,CFTRACEID,CFPROJECTJCHID,Isnull(CFSUBMITTRANSFERQTY,0) As CFSUBMITTRANSFERQTY,CFPROCESSFLOW,CFSUPPLYSOUID \r\n");
        sql.append(" From CT_MO_StockTransferPlan UT\r\n");
        if (BatchActionEnum.DELETE.equals((Object)action)) {
            sql.append(" where fid in(").append(sourceBillid).append(")");
        } else {
            sql.append(" where fid = '").append(sourceBillid).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rs2 = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        int irow = 0;
        int rsSize = 0;
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                BigDecimal fqty = rs.getBigDecimal("CFSUBMITTRANSFERQTY");
                sql.setLength(0);
                sql.append(" Select ut.fid, ut.CFSTORAGEORGUNITID,ut.CFMATERIALID,Isnull(ut.CFTRANSFERQTY,0) As CFTRANSFERQTY,Isnull(ut.CFSUBMITQTY,0) As CFSUBMITQTY,Isnull(ut.CFAUDITTRANSFERQTY,0) As CFAUDITTRANSFERQTY, \r\n");
                sql.append(" ut.CFPROJECTID,ut.CFTRACEID,ut.CFPROJECTJCHID,Isnull(ut.CFSUBMITTRANSFERQTY,0) As CFSUBMITTRANSFERQTY,ut.CFPROCESSFLOW,ut.CFSUPPLYSOUID \r\n");
                sql.append(" From CT_MO_StockTransferPlandetial ut\r\n");
                sql.append(" Left outer join t_mm_tracknumber t on ut.CFTRACEID = t.fid \r\n");
                sql.append(" where exists(select 1 from t_bot_relation a where a.FSRCOBJECTID = ut.fid and a.FDESTOBJECTID = '").append(fid).append("' and a.FSRCENTITYID = '9CBCD44C' and a.FDESTENTITYID = '08B2670B')\r\n");
                sql.append(" and exists(Select 1 from CT_MO_StockTransferPlan b where b.fid = '").append(fid).append("' and isnull(b.CFMATERIALID,'Null') = isnull(ut.cfmaterialid,'Null') \r\n");
                sql.append(" and isnull(b.CFPROJECTID,'Null') = isnull(ut.CFPROJECTID,'Null') ");
                sql.append(" and isnull(b.CFSTORAGEORGUNITID,'Null') = isnull(ut.CFSTORAGEORGUNITID,'Null') ");
                sql.append(" and isnull(b.CFSUPPLYSOUID,'Null') = isnull(ut.CFSUPPLYSOUID,'Null') ");
                sql.append(" and isnull(b.CFPROCESSFLOW,'Null') = isnull(ut.CFPROCESSFLOW,'Null') ");
                sql.append(" )\r\n");
                sql.append(" order by t.fnumber \r\n");
                rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                rsSize = rs2.size();
                irow = 0;
                while (rs2.next()) {
                    String fdetialid = rs2.getString("fid");
                    BigDecimal fdetialsubmitQty = rs2.getBigDecimal("CFSUBMITTRANSFERQTY");
                    BigDecimal fdetialQty = rs2.getBigDecimal("CFSubmitQTY");
                    BigDecimal fnewdetialsubmitQty = new BigDecimal(0);
                    if (fdetialQty.compareTo(fqty) >= 0) {
                        fnewdetialsubmitQty = fqty;
                        fqty = new BigDecimal(0);
                    } else {
                        fnewdetialsubmitQty = fdetialQty;
                        fqty = fqty.subtract(fdetialQty);
                    }
                    if (++irow == rsSize && fqty.compareTo(new BigDecimal(0)) > 0) {
                        fnewdetialsubmitQty = fnewdetialsubmitQty.add(fqty);
                        fqty = new BigDecimal(0);
                    }
                    sql.setLength(0);
                    sql.append("update CT_MO_StockTransferPlandetial  ");
                    sql.append(" set CFSUBMITTRANSFERQTY = ").append(fnewdetialsubmitQty);
                    sql.append(" where fid = '").append(fdetialid).append("'");
                    sqlList.add(sql.toString());
                }
            }
            if (sqlList.size() > 0) {
                com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqlList);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0004", (Locale)ctx.getLocale()) + e.getMessage()));
        }
    }
}

