/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.inv;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.project.biz.reqclose.IndepentRequireCloseRecordFactory;
import com.kingdee.eas.industry.emm.project.biz.reqclose.issueBillTypeEnum;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SCMIssueBillAudit4AutoCloseIRProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 8438840743736487240L;
    private String eto20 = "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=";
    private String itemTracknoValue = "ITEM_TRACKNO";
    private String itemValue = "ITEM";

    public SCMIssueBillAudit4AutoCloseIRProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCMIssueBillAudit4AutoCloseIRProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCMIssueBillAudit4AutoCloseIRProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.doCheck(batchResults);
    }

    private void doCheck(BatchActionResults batchResults) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] collection = batchResults.getParamEntries();
        if (collection == null) {
            return;
        }
        int len = collection[0].toArray().length;
        boolean nrow = false;
        String headTableName = null;
        String entryTableName = null;
        String issueBillID = null;
        issueBillTypeEnum issuebillType = null;
        int size = len;
        for (int i = 0; i < size; ++i) {
            MaterialReqBillInfo info;
            if (collection[0].toArray()[i] instanceof MaterialReqBillInfo) {
                info = (MaterialReqBillInfo)collection[0].toArray()[i];
                if (info == null) continue;
                issueBillID = info.getId().toString();
                headTableName = "t_im_materialreqbill";
                entryTableName = "t_im_materialreqbillentry";
                issuebillType = issueBillTypeEnum.MRQ;
            } else if (collection[0].toArray()[i] instanceof SaleIssueBillInfo) {
                info = (SaleIssueBillInfo)collection[0].toArray()[i];
                if (info == null) continue;
                issueBillID = info.getId().toString();
                headTableName = "t_im_saleissuebill";
                entryTableName = "t_im_saleissueentry";
                issuebillType = issueBillTypeEnum.SALE;
            } else if (collection[0].toArray()[i] instanceof OtherIssueBillInfo) {
                info = (OtherIssueBillInfo)collection[0].toArray()[i];
                if (info == null) continue;
                issueBillID = info.getId().toString();
                headTableName = "t_im_otherissuebill";
                entryTableName = "t_im_otherissuebillentry";
                issuebillType = issueBillTypeEnum.OTHER;
            } else {
                if (!(collection[0].toArray()[i] instanceof MoveIssueBillInfo) || (info = (MoveIssueBillInfo)collection[0].toArray()[i]) == null) continue;
                issueBillID = info.getId().toString();
                headTableName = "t_im_moveissuebill";
                entryTableName = "t_im_moveissuebillentry";
                issuebillType = issueBillTypeEnum.MOVEISSUE;
            }
            try {
                if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                    this.issueBillAutoCloseIndepentRequire(issueBillID, headTableName, entryTableName, issuebillType);
                    continue;
                }
                if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) continue;
                this.issueBillAutoUnCloseIndepentRequire(issueBillID, headTableName, entryTableName, issuebillType);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void issueBillAutoUnCloseIndepentRequire(String issueBillID, String headTableName, String entryTableName, issueBillTypeEnum issuebillType) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> closeRecordBillIDList = new ArrayList<String>();
        sql.append(" Select a.fid ");
        sql.append(" from T_RC_IRequireCloseRecord a ");
        sql.append(" where a.Fissuebillid = '" + issueBillID + "' ");
        sql.append(" and a.Fisautoclose = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        while (rs.next()) {
            closeRecordBillIDList.add(rs.getString("fid"));
        }
        IndepentRequireCloseRecordFactory.getLocalInstance((Context)this.ctx).unClose(closeRecordBillIDList, false);
    }

    private void issueBillAutoCloseIndepentRequire(String issueBillID, String headTableName, String entryTableName, issueBillTypeEnum issuebillType) throws EASBizException, BOSException, SQLException {
        IRowSet rs = this.getUpdateIndepentType(issueBillID, headTableName);
        if (rs == null || rs.size() < 1) {
            return;
        }
        HashMap datamap = null;
        IRowSet rs2 = null;
        try {
            List dataList = this.getIssueBillMaterialData(issueBillID, entryTableName, headTableName);
            String fmaterialid = null;
            String fstorageorgunitid = null;
            String fprojectid = null;
            String ftracknumberid = null;
            String fbillid = null;
            String fbillentryid = null;
            String fissuebillid = null;
            String fissuebillentryid = null;
            String fissuebillnumber = null;
            BigDecimal fbillThisCloseQty = null;
            BigDecimal fbillClosedQty = null;
            BigDecimal fbillAllowcloseQty = null;
            int fisolatedrule = 0;
            BigDecimal fqty = null;
            HashMap<String, BigDecimal> billClosedQtyMap = new HashMap<String, BigDecimal>();
            String indepentRequireTypeStr = null;
            HashMap<String, Object> autoCloseDataMap = new HashMap<String, Object>();
            HashMap<String, Object> closeBillDataMap = null;
            autoCloseDataMap.put("isauto", "true");
            autoCloseDataMap.put("closeReason", "\u51fa\u5e93\u5355\u5ba1\u6838\u81ea\u52a8\u5173\u95ed");
            ArrayList autoCloseDataList = new ArrayList();
            while (rs.next()) {
                int indepentrequirebilltype = rs.getInt("findepentrequirebilltype");
                if (2 == indepentrequirebilltype) {
                    indepentRequireTypeStr = "MarketingFittingRollingPlan";
                } else if (1 == indepentrequirebilltype) {
                    indepentRequireTypeStr = "PCP";
                } else if (3 == indepentrequirebilltype) {
                    indepentRequireTypeStr = "ProjectPurRequre";
                } else if (4 == indepentrequirebilltype) {
                    indepentRequireTypeStr = "PurRequireMent";
                }
                for (int i = 0; i < dataList.size(); ++i) {
                    datamap = (HashMap)dataList.get(i);
                    fissuebillid = datamap.get("fid").toString();
                    fissuebillentryid = datamap.get("fentryid").toString();
                    fissuebillnumber = datamap.get("fnumber").toString();
                    fmaterialid = datamap.get("fmaterialid").toString();
                    fstorageorgunitid = datamap.get("fstorageorgunitid").toString();
                    fprojectid = null;
                    ftracknumberid = null;
                    if (datamap.get("fprojectid") != null) {
                        fprojectid = datamap.get("fprojectid").toString();
                    }
                    if (datamap.get("ftracknumberid") != null) {
                        ftracknumberid = datamap.get("ftracknumberid").toString();
                    }
                    fisolatedrule = Integer.parseInt(datamap.get("fisolatedrule").toString());
                    fqty = new BigDecimal(datamap.get("fqty").toString());
                    if (fqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    rs2 = this.getIndepentRequireData(fmaterialid, fstorageorgunitid, fprojectid, ftracknumberid, indepentrequirebilltype);
                    while (rs2.next() && fqty.compareTo(BigDecimal.ZERO) > 0) {
                        fbillid = rs2.getString("fbillid");
                        fbillentryid = rs2.getString("fbillentryid");
                        fbillClosedQty = billClosedQtyMap != null && billClosedQtyMap.containsKey(fbillentryid) ? new BigDecimal(billClosedQtyMap.get(fbillentryid).toString()) : BigDecimal.ZERO;
                        fbillAllowcloseQty = rs2.getBigDecimal("fbillqty").subtract(rs2.getBigDecimal("fcloseQty")).subtract(fbillClosedQty);
                        if (fbillAllowcloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (fqty.compareTo(fbillAllowcloseQty) >= 0) {
                            fbillThisCloseQty = fbillAllowcloseQty;
                            fqty = fqty.subtract(fbillAllowcloseQty);
                        } else {
                            fbillThisCloseQty = fqty;
                            fqty = BigDecimal.ZERO;
                        }
                        datamap.put("fqty", fqty);
                        if (fbillThisCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        billClosedQtyMap.put(fbillentryid, fbillThisCloseQty.add(fbillClosedQty));
                        closeBillDataMap = new HashMap<String, Object>();
                        closeBillDataMap.put("fthiscloseQty", fbillThisCloseQty);
                        closeBillDataMap.put("billentryid", fbillentryid);
                        closeBillDataMap.put("billid", fbillid);
                        closeBillDataMap.put("billtype", indepentRequireTypeStr);
                        closeBillDataMap.put("parentID", null);
                        closeBillDataMap.put("parentNumber", null);
                        closeBillDataMap.put("issuebillID", fissuebillid);
                        closeBillDataMap.put("issuebillEntryID", fissuebillentryid);
                        closeBillDataMap.put("issuebillNumber", fissuebillnumber);
                        closeBillDataMap.put("issuebillType", issuebillType);
                        autoCloseDataList.add(closeBillDataMap);
                    }
                }
            }
            autoCloseDataMap.put("closeDataList", autoCloseDataList);
            IndepentRequireCloseRecordFactory.getLocalInstance((Context)this.ctx).closebill(autoCloseDataMap);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private List getIssueBillMaterialData(String billid, String fentrytableName, String ftableName) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        ArrayList returnList = new ArrayList();
        sql.append(" Select  fid,fnumber,fentryid,fmaterialid,fqty,fstorageorgunitid, ");
        sql.append(" (case fisolatedrule when 1 then null else fprojectid end  ) As fprojectid, ");
        sql.append(" (case fisolatedrule when 3 then ftracknumberid else null end ) As ftracknumberid, ");
        sql.append(" fisolatedrule from ( ");
        sql.append(" Select  h.fid as fid,h.fnumber as fnumber,d.fid as fentryid, d.fmaterialid,d.fstorageorgunitid, ");
        sql.append(" d.fqty As fqty,d.fprojectid,d.ftracknumberid, ");
        sql.append(" (case mp.fmanufacturestrategyid when '" + this.eto20 + "' then (case mp.fisolatedrule when '" + this.itemTracknoValue + "' then 3 when '" + this.itemValue + "' then 2 else 1 end) else 1 end) As fisolatedrule ");
        sql.append(" from ").append(ftableName).append(" h  ");
        sql.append(" inner join ").append(fentrytableName).append(" d  on h.fid = d.fparentid ");
        sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = d.fmaterialid and mp.forgunit =  d.fstorageorgunitid ");
        sql.append(" where  h.fid = '").append(billid).append("' ");
        sql.append(" and d.fqty > 0 ");
        sql.append(" ) aa ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        HashMap<String, Object> datamap = null;
        Object fkey = null;
        while (rs.next()) {
            String fmaterialid = rs.getString("fmaterialid");
            String fstorageorgunitid = rs.getString("fstorageorgunitid");
            String fprojectid = rs.getString("fprojectid");
            String ftracknumberid = rs.getString("ftracknumberid");
            String fid = rs.getString("fid");
            String fnumber = rs.getString("fnumber");
            String fentryid = rs.getString("fentryid");
            int fisolatedrule = rs.getInt("fisolatedrule");
            BigDecimal fqty = rs.getBigDecimal("fqty");
            datamap = new HashMap<String, Object>();
            datamap.put("fmaterialid", fmaterialid);
            datamap.put("fstorageorgunitid", fstorageorgunitid);
            datamap.put("fprojectid", fprojectid);
            datamap.put("ftracknumberid", ftracknumberid);
            datamap.put("fisolatedrule", fisolatedrule);
            datamap.put("fid", fid);
            datamap.put("fnumber", fnumber);
            datamap.put("fentryid", fentryid);
            datamap.put("fqty", fqty);
            returnList.add(datamap);
        }
        return returnList;
    }

    private IRowSet getUpdateIndepentType(String billid, String ftableName) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        StringBuffer sql2orderby = new StringBuffer();
        sql2.append(" Select  a.findepentrequirebilltype,a.flevel ");
        sql2.append(" from t_rc_indepentrequirecloserule a  ");
        sql2.append(" where a.fstatus = 20 ");
        sql2.append(" and a.findepentrequirebilltype > 0 ");
        sql2orderby.append(" order by a.flevel desc ");
        sql.append(" Select  isnull(ftransactiontypeid,'*') As ftransactiontypeid , ");
        sql.append(" Isnull(fbiztypeid,'*') As fbiztypeid, ");
        sql.append(" Isnull(fbilltypeid,'*') As fbilltypeid ");
        sql.append("  from ").append(ftableName).append(" h ");
        sql.append(" where h.fid = '").append(billid).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        IRowSet rs2 = null;
        while (rs.next()) {
            String ftransactiontypeid = rs.getString("ftransactiontypeid");
            String fbiztypeid = rs.getString("fbiztypeid");
            String fbilltypeid = rs.getString("fbilltypeid");
            sql.setLength(0);
            sql.append(" and a.fbilltypeid ='").append(fbilltypeid).append("'");
            sql.append(" and a.fbiztypeid ='").append(fbiztypeid).append("'");
            sql.append(" and a.ftransactiontypeid ='").append(ftransactiontypeid).append("'");
            rs2 = DbUtil.executeQuery((Context)this.ctx, (String)(sql2.toString() + sql.toString() + sql2orderby.toString()));
            if (rs2 != null && rs2.size() > 0) {
                return rs2;
            }
            sql.setLength(0);
            sql.append(" and a.fbilltypeid ='").append(fbilltypeid).append("'");
            sql.append(" and a.fbiztypeid ='").append(fbiztypeid).append("'");
            sql.append(" and a.ftransactiontypeid is null ");
            rs2 = DbUtil.executeQuery((Context)this.ctx, (String)(sql2.toString() + sql.toString() + sql2orderby.toString()));
            if (rs2 != null && rs2.size() > 0) {
                return rs2;
            }
            sql.setLength(0);
            sql.append(" and a.fbilltypeid ='").append(fbilltypeid).append("'");
            sql.append(" and a.fbiztypeid is null ");
            sql.append(" and a.ftransactiontypeid is null ");
            rs2 = DbUtil.executeQuery((Context)this.ctx, (String)(sql2.toString() + sql.toString() + sql2orderby.toString()));
            if (rs2 == null || rs2.size() <= 0) continue;
            return rs2;
        }
        return null;
    }

    private IRowSet getIndepentRequireData(String fmaterialid, String fstorageorgunitid, String fprojectid, String ftracknumberid, int indepentrequirebilltype) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if (2 == indepentrequirebilltype) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,d.fid as fbillentryid \r\n");
            sql.append(" ,d.Cfrequireqty as fbillqty \r\n");
            sql.append(" ,isnull(d.fcloseqty,0) as fcloseqty \r\n");
            sql.append(" from  Ct_Pm_Marketingfrp h \r\n");
            sql.append(" inner join  Ct_Pm_Marketingfrpe d on h.fid = d.fparentid \r\n");
            sql.append(" where h.cfbasestatus = 4  \r\n");
            sql.append(" and d.Cfmaterialid = '").append(fmaterialid).append("' \r\n");
            if (fprojectid != null && !"".equals(fprojectid)) {
                sql.append(" and h.cfprojectid = '").append(fprojectid).append("' \r\n");
            }
            if (ftracknumberid != null && !"".equals(ftracknumberid)) {
                sql.append(" and d.Cftracknumberid = '").append(ftracknumberid).append("' \r\n");
            }
            if (fstorageorgunitid != null && !"".equals(fstorageorgunitid)) {
                sql.append(" and d.CFActualProcessUnitID = '").append(fstorageorgunitid).append("' \r\n");
            }
            sql.append(" and d.Cfrequireqty > isnull(d.fcloseqty,0)  \r\n");
            sql.append(" order by d.cfdeliverdate  \r\n");
        } else if (3 == indepentrequirebilltype) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,d.fid as fbillentryid \r\n");
            sql.append(" ,d.cfqty as fbillqty \r\n");
            sql.append(" ,isnull(d.fcloseqty,0) as fcloseqty \r\n");
            sql.append(" from  CT_PUR_BOMPurRequest h \r\n");
            sql.append(" inner join  CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid \r\n");
            sql.append(" where h.cfbasestatus = 4  \r\n");
            sql.append(" and h.Cfmaterialid = '").append(fmaterialid).append("' \r\n");
            if (fprojectid != null && !"".equals(fprojectid)) {
                sql.append(" and h.Cfprojectnoid = '").append(fprojectid).append("' \r\n");
            }
            if (ftracknumberid != null && !"".equals(ftracknumberid)) {
                sql.append(" and d.Cftracknumberid = '").append(ftracknumberid).append("' \r\n");
            }
            sql.append(" and d.cfqty > isnull(d.fcloseqty,0)  \r\n");
            sql.append(" order by h.Cfplantime  \r\n");
        } else if (1 == indepentrequirebilltype) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,h.fid as fbillentryid \r\n");
            sql.append(" ,h.fqty as fbillqty \r\n");
            sql.append(" ,isnull(h.fcloseqty,0) as fcloseqty \r\n");
            sql.append(" from  T_PCP_ProjectCP h \r\n");
            sql.append(" inner join T_PCP_ProjectCPSE e on e.fparentid=h.fid \r\n");
            sql.append(" where h.fstate = 4  \r\n");
            sql.append(" and h.fmaterialid = '").append(fmaterialid).append("' \r\n");
            if (fprojectid != null && !"".equals(fprojectid)) {
                sql.append(" and h.fprojectid = '").append(fprojectid).append("' \r\n");
            }
            if (ftracknumberid != null && !"".equals(ftracknumberid)) {
                sql.append(" and h.ftracknumberid = '").append(ftracknumberid).append("' \r\n");
            }
            if (fstorageorgunitid != null && !"".equals(fstorageorgunitid)) {
                sql.append(" and e.FStorageOrgUnitID = '").append(fstorageorgunitid).append("' \r\n");
            }
            sql.append(" and h.fqty > isnull(h.fcloseqty,0)  \r\n");
            sql.append(" order by h.Ffinishtime  \r\n");
        } else if (4 == indepentrequirebilltype) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,d.fid as fbillentryid \r\n");
            sql.append(" ,d.fqty as fbillqty \r\n");
            sql.append(" ,isnull((Select sum(fcloseqty)  \r\n");
            sql.append(" from T_RC_IRequireCloseRecord ir  \r\n");
            sql.append(" where ir.findepentrequirebillentryid = d.fid \r\n");
            sql.append(" and ir.findepentrequirebilltype = ").append(4).append("),0) As fcloseQty \r\n");
            sql.append(" from  T_SM_PurRequirement h \r\n");
            sql.append(" inner join  T_SM_PurRequirementEntry d on h.fid = d.fparentid \r\n");
            sql.append(" where h.fbasestatus = 4  \r\n");
            sql.append(" and d.fmaterialid = '").append(fmaterialid).append("' \r\n");
            if (fprojectid != null && !"".equals(fprojectid)) {
                sql.append(" and d.FProjectID = '").append(fprojectid).append("' \r\n");
            }
            if (ftracknumberid != null && !"".equals(ftracknumberid)) {
                sql.append(" and d.FTrackNoID = '").append(ftracknumberid).append("' \r\n");
            }
            if (fstorageorgunitid != null && !"".equals(fstorageorgunitid)) {
                sql.append(" and d.FReceivedOrgUnitID = '").append(fstorageorgunitid).append("' \r\n");
            }
            sql.append(" and d.fqty >  \r\n");
            sql.append(" isnull((Select sum(fcloseqty)  \r\n");
            sql.append(" from T_RC_IRequireCloseRecord ir  \r\n");
            sql.append(" where ir.findepentrequirebillentryid = d.fid \r\n");
            sql.append(" and ir.findepentrequirebilltype = ").append(4).append("),0)  \r\n");
            sql.append(" order by d.FRequirementDate  \r\n");
        } else {
            return null;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        return rs;
    }
}

