/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.util.VerifyUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseCollection;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.AbstractGeneBillBaseControllerBean;
import com.kingdee.eas.eqm.common.core.app.action.IServerActionManager;
import com.kingdee.eas.eqm.common.core.app.action.ServerActionManager;
import com.kingdee.eas.eqm.common.core.app.action.ServerEvent;
import com.kingdee.eas.eqm.common.core.app.util.GeneServerUtils;
import com.kingdee.eas.eqm.common.core.app.verify.GeneBillAddnewCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneBillAuditCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneBillDeleteCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneBillUnAuditCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.codingrule.ISuportCodingRule;
import com.kingdee.eas.eqm.common.core.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneStringUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class GeneBillBaseControllerBean
extends AbstractGeneBillBaseControllerBean
implements ISuportCodingRule {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.core.app.GeneBillBaseControllerBean");
    private IServerActionManager serverActionManager = null;
    private boolean checkLastUptTime = true;
    protected String permissionItem = null;

    protected void regesterServerAction(Context ctx, IServerActionManager serverActionManager) throws BOSException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        this.fireServerAction(ctx, srcBillVO, "BEFORE_UPDATE", new Object[]{srcBillPK, srcBillVO, billOperStateEnum, relationInfo});
    }

    public synchronized IServerActionManager getServerActionManager(Context ctx) throws BOSException {
        if (this.serverActionManager == null) {
            this.serverActionManager = new ServerActionManager();
            this.regesterServerAction(ctx, this.serverActionManager);
        }
        return this.serverActionManager;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean botp;
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        String tableName = this.getTableName(ctx);
        if (info.getNumber() != null) {
            info.setNumber(info.getNumber().trim());
        }
        IVerifyManager verifymanager = this.getSaveVerifyManager(ctx, info);
        verifymanager.verify();
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        if (GeneStringUtils.isEmpty(info.getNumber())) {
            this.getCodingRuleStrategy().initNumber(this, ctx, info);
        }
        if (info.getBillStatus() == GeneBillBaseStatusEnum.AddNew || info.getBillStatus() == null) {
            info.setBillStatus(GeneBillBaseStatusEnum.SAVE);
        }
        boolean bl = botp = info.getSourceBillId() != null;
        if (botp && GeneCommonUtils.isEmpty(info.getNumber())) {
            if (info.getId() != null) {
                info.setNumber("AutoNumberFromBTP_" + info.getId().toString());
            } else {
                info.setNumber("AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
        }
        this._checkNumberBlank(ctx, null, info);
        this._checkNumberDup(ctx, null, info);
        return super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        String tableName = this.getTableName(ctx);
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        if (info.getBillStatus() == GeneBillBaseStatusEnum.SAVE || info.getBillStatus() == GeneBillBaseStatusEnum.AddNew || info.getBillStatus() == null) {
            info.setBillStatus(GeneBillBaseStatusEnum.Submit);
        }
        this.handleNumber(ctx, info, false);
        IVerifyManager verifymanager = this.getSubmitVerifyManager(ctx, info);
        verifymanager.verify();
        if (info.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            IVerifyManager updateNewManager = this.getUpdateVerifyManager(ctx, info);
            updateNewManager.verify();
        } else {
            IVerifyManager addNewManager = this.getAddnewVerifyManager(ctx, info);
            addNewManager.verify();
        }
        IObjectPK pk = super._submit(ctx, model);
        if (this.isAuditBySubmit(ctx, info)) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return false;
    }

    protected void _checkNumberBlank(Context ctx, GeneBillBaseInfo model) throws BOSException, EASBizException {
        String number = model.getNumber();
        if (number == null || number.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        if (this.isCheckLastUptTime()) {
            GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, this.getTableName(ctx));
        }
        this.fireServerAction(ctx, model, "BEFORE_UPDATE");
        super._update(ctx, pk, model);
        this.fireServerAction(ctx, model, "AFTER_UPDATE");
    }

    protected boolean isCheckLastUptTime() {
        return this.checkLastUptTime;
    }

    protected void setCheckLastUptTime(boolean checkLastUptTime) {
        this.checkLastUptTime = checkLastUptTime;
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    protected void fireServerAction(Context ctx, Object model, String eventName) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        this.getServerActionManager(ctx).fireServerAction(ctx, event);
    }

    protected void fireServerAction(Context ctx, Object model, String eventName, Object[] args) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        event.setParams(args);
        this.getServerActionManager(ctx).fireServerAction(ctx, event);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GeneBillBaseInfo info = this.getGeneBillBaseInfo(ctx, pk);
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
        verifymanager.verify();
        this.fireServerAction(ctx, info, "BEFORE_DELETE");
        super._delete(ctx, pk);
        this.fireServerAction(ctx, info, "AFTER_DELETE");
        GeneCommonUtils.recycleNumber(ctx, (CoreBaseInfo)info, info.getMainOrgUnit().getId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        this.fireServerAction(ctx, pkArray, "BEFORE_BATCHDELETE");
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (int i = 0; i < pkArray.length; ++i) {
                GeneBillBaseInfo info = this.getGeneBillBaseInfo(ctx, pkArray[i]);
                IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
                verifymanager.verify();
                dao.deleteBatch(pkArray[i]);
            }
            dao.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        this.fireServerAction(ctx, pkArray, "AFTER_BATCHDELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.delete(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneBillDeleteCommonVerifyItem verifyItem = new GeneBillDeleteCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        GeneBillBaseCollection collection = new GeneBillBaseCollection();
        collection.add((GeneBillBaseInfo)objectValue);
        this._handleAfterTransform(ctx, action, (IObjectCollection)collection);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue qcInfo = collection.getObject(i);
            this.fireServerAction(ctx, qcInfo, "AFTER_TRANS_FORM");
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)this.getMainBizOrgType());
    }

    public ServerCodingRuleStrategy getCodingRuleStrategy() {
        return new ServerCodingRuleStrategy();
    }

    public FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        filter.getFilterItems().add(new FilterItemInfo(info.getBizOrgPropertyName() + ".id", (Object)info.getMainOrgUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    protected void handleNumber(Context ctx, IObjectValue model, boolean isSave) throws EASBizException, BOSException {
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        if (info.getNumber() == null || info.getNumber().trim().equals("")) {
            this.getCodingRuleStrategy().initNumber(this, ctx, info);
        }
        if (!isSave) {
            this._checkNumberBlank(ctx, null, info);
        }
        this._checkNumberDup(ctx, null, info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)info.getBizOrgPropertyName());
        LogControllManager.getInstance().enableLog();
        this.logAddnew(ctx, info);
        this.fireServerAction(ctx, info, "BEFORE_ADDNEW");
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.fireServerAction(ctx, info, "AFTER_ADDNEW");
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (GeneCommonUtils.isEmpty(colls)) {
            return null;
        }
        for (GeneBillBaseInfo info : colls) {
            VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)info.getBizOrgPropertyName());
            info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
            UserInfo userInfo = this.getUserInfo(ctx);
            if (info.getCreator() == null) {
                info.setCreator(userInfo);
            }
            Timestamp createtime = this.getTime();
            if (info.getCreateTime() == null) {
                info.setCreateTime(createtime);
            }
            info.setLastUpdateUser(userInfo);
            info.setLastUpdateTime(createtime);
        }
        this.fireServerAction(ctx, colls, "BEFORE_BATCHADDNEW");
        Connection cn = null;
        IObjectPK[] objectPKArray = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (IObjectValue value : colls) {
                dao.addNewBatch(value);
            }
            objectPKArray = dao.executeBatchWithReturn();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        this.fireServerAction(ctx, colls, "AFTER_BATCHADDNEW");
        return objectPKArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK[] _updateBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (GeneCommonUtils.isEmpty(colls)) {
            return null;
        }
        for (GeneBillBaseInfo info : colls) {
            if (!this.isCheckLastUptTime()) continue;
            GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, this.getTableName(ctx));
        }
        this.fireServerAction(ctx, colls, "BEFORE_BATCHUPDATE");
        Connection cn = null;
        IObjectPK[] objectPKArray = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (CoreBaseInfo value : colls) {
                ObjectUuidPK pk = new ObjectUuidPK(value.getId());
                if (value.getId() == null || !this._exists(ctx, (IObjectPK)pk)) continue;
                dao.updateBatch((IObjectPK)pk, (IObjectValue)value);
            }
            objectPKArray = dao.executeBatchWithReturn();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        this.fireServerAction(ctx, colls, "AFTER_BATCHUPDATE");
        return objectPKArray;
    }

    protected Result _addnew(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._addnew(ctx, colls);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected void updateBotpBillAddNewLastUpdateInfoNull(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    protected IVerifyManager getSaveVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        return verifymanager;
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneBillAddnewCommonVerifyItem verifyItem = new GeneBillAddnewCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    @Override
    public boolean isNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForCheckNumber(coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForCheckNumber(coreBillBaseInfo), "AND");
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GeneBillBaseInfo info = (GeneBillBaseInfo)this.getValue(ctx, pk);
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, this.getTableName(ctx));
        this.lockData(ctx, pk.toString());
        IVerifyManager verifymanager = this.getAuditVerifyManager(ctx, info);
        verifymanager.verify();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String sql = "update " + this.getTableName(ctx) + " set FBillStatus=? ,FAuditorId=? , FAuditTime=getDate() where fid =?";
        this.fireServerAction(ctx, info, "BEFORE_AUDIT");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(30), userId, pk.toString()});
        this.fireServerAction(ctx, info, "AFTER_AUDIT");
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneBillAuditCommonVerifyItem verifyItem = new GeneBillAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void lockData(Context ctx, String pk) throws BOSException {
        String tbl = this.getTableName(ctx);
        String sql = "update " + tbl + " set FLastUpdateTime= ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), pk.toString()});
    }

    protected void lockData(Context ctx, List ids) throws BOSException {
        String tbl = this.getTableName(ctx);
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("update " + tbl + " set FLastUpdateTime= now() ");
        sql.appendSql("where fid in (");
        sql.appendParam(ids.toArray());
        sql.appendSql(")");
        sql.execute(ctx);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneBillBaseInfo info = (GeneBillBaseInfo)this.getValue(ctx, pk);
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        IVerifyManager verifymanager = this.getUnAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBillStatus=? ,FAuditorId=null , FAuditTime=null where fid =?";
        this.fireServerAction(ctx, info, "BEFORE_UNAUDIT");
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(10), pk.toString()});
        this.fireServerAction(ctx, info, "AFTER_UNAUDIT");
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneBillUnAuditCommonVerifyItem verifyItem = new GeneBillUnAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        return entity.getTable().getName();
    }

    @Override
    public FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForCheckNumber((CoreBillBaseInfo)model);
    }

    @Override
    public void audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        super.audit(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.unAudit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    public void mutexRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean b = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(pk.toString());
        if (!b) {
            throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        }
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        String number = coreBillBaseInfo.getNumber();
        if (number == null || number.equals("")) {
            throw new GeneException(GeneException.NUMBERNOTNULL);
        }
        return true;
    }

    @Override
    protected void _logAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public GeneBillBaseInfo getGeneBillBaseInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getGeneBillBaseInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public GeneBillBaseInfo getGeneBillBaseInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getGeneBillBaseInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public GeneBillBaseInfo getGeneBillBaseInfo(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super.getGeneBillBaseInfo(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk, selector, sorter);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk, sorter);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        if (coreBillBaseInfo.getString("number") == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", coreBillBaseInfo.getString("number") == null ? null : coreBillBaseInfo.getString("number").trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForCheckNumber(coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForCheckNumber(coreBillBaseInfo), "AND");
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected void setPermissionItem(String permissionItem) {
        this.permissionItem = permissionItem;
    }

    protected String getPermissionItem() {
        return this.permissionItem;
    }
}

