/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.eqm.common.core.GeneBatchResult;
import com.kingdee.eas.eqm.common.core.GeneDataBaseBatchCollection;
import com.kingdee.eas.eqm.common.core.GeneDataBaseBatchInfo;
import com.kingdee.eas.eqm.common.core.app.AbstractGeneDataBaseBatchControllerBean;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.eqmcore.EQMDataBaseBatchInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class GeneDataBaseBatchControllerBean
extends AbstractGeneDataBaseBatchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.core.app.GeneDataBaseBatchControllerBean");
    private static final String resourceDir = "com.kingdee.eas.eqm.common.COMMONAutoGenerateResource";

    @Override
    protected GeneBatchResult _batchSubmitData(Context ctx, List editCollection) throws BOSException, EASBizException {
        if (GeneCommonUtils.isEmpty(editCollection)) {
            return null;
        }
        GeneBatchResult result = new GeneBatchResult();
        ArrayList removeList = new ArrayList();
        ArrayList<EQMDataBaseBatchInfo> insertList = new ArrayList<EQMDataBaseBatchInfo>();
        ArrayList<EQMDataBaseBatchInfo> updateList = new ArrayList<EQMDataBaseBatchInfo>();
        for (Object info : editCollection) {
            if (info instanceof String) {
                removeList.add(info);
                continue;
            }
            EQMDataBaseBatchInfo planInfo = (EQMDataBaseBatchInfo)info;
            if (planInfo.getCheckedStatus() == null) {
                planInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            }
            if (planInfo.getDeletedStatus() == null) {
                planInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            }
            if (planInfo.getBlockedStatus() == null) {
                planInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            }
            if (planInfo.getEffectedStatus() == null) {
                planInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            }
            if (planInfo.getOprStatus() == 1) {
                insertList.add(planInfo);
                continue;
            }
            if (planInfo.getOprStatus() == 2) {
                updateList.add(planInfo);
                continue;
            }
            if (planInfo.getOprStatus() != 3) continue;
            removeList.add(planInfo.getId().toString());
        }
        this.removePlan(ctx, removeList, result);
        this.insertPlan(ctx, insertList, result);
        this.updatePlan(ctx, updateList, result);
        String resPath = "com.kingdee.eas.eqm.common.core.GeneResource";
        if (result.getErrNum() > 0) {
            result.getHeadMsg().append(MessageFormat.format(ResourceBase.getString((String)resPath, (String)"BatchErrorMsg", (Locale)ctx.getLocale()), new Integer(result.getErrNum())));
        } else {
            result.getHeadMsg().append(MessageFormat.format(ResourceBase.getString((String)resPath, (String)"BatchSuccessMsg", (Locale)ctx.getLocale()), new Integer(result.getRightNum())) + "\n");
        }
        return result;
    }

    private void updatePlan(Context ctx, List updateList, GeneBatchResult result) throws BOSException, EASBizException {
        String tmpTblName = null;
        try {
            if (GeneCommonUtils.isEmpty(updateList)) {
                return;
            }
            StringBuffer errMsg = new StringBuffer();
            if (GeneCommonUtils.isEmpty(updateList = this.verifyBeforeModify(ctx, updateList, errMsg, result))) {
                return;
            }
            tmpTblName = this.createTempTable(ctx, (GeneDataBaseBatchInfo)updateList.get(0));
            this.insertDataToTmpTable(ctx, updateList, tmpTblName);
            updateList = this.verifyExist(ctx, updateList, errMsg, result);
            updateList = this.verifyLastUptTime(ctx, updateList, errMsg, tmpTblName, result);
            if (this.isNeedVerifyNumber()) {
                updateList = this.verifyNumberModify(ctx, updateList, errMsg, tmpTblName, result);
            }
            this.lockData(ctx, updateList);
            String orgUnitid = null;
            if (!GeneCommonUtils.isEmpty(updateList)) {
                for (GeneDataBaseBatchInfo baseBatchInfo : updateList) {
                    if (baseBatchInfo.getCU() != null) continue;
                    baseBatchInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
                GeneDbUtil.executeBatch(ctx, this.getUpdateSql(ctx), this.buildValues(ctx, updateList, false));
                this.afterUpdate(ctx, updateList);
                if (!this.isIgnoreOrgFilter()) {
                    orgUnitid = ((GeneDataBaseBatchInfo)updateList.get(0)).getMainOrgUnit().getId().toString();
                }
            }
            if (errMsg.toString().length() > 0) {
                result.getDetailMsg().append(errMsg.toString());
            }
            if (updateList.size() > 0) {
                result.setRightNum(result.getRightNum() + updateList.size());
                List l = this.findNewInsertObject(ctx, orgUnitid, updateList, 2);
                result.setUpdatedObject(l);
            }
            this.releaseTempTable(ctx, tmpTblName);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(ctx, tmpTblName);
        }
    }

    protected void afterUpdate(Context ctx, List updateList) throws EASBizException, BOSException {
        this.writeLog(ctx, updateList, (short)2);
    }

    private void insertPlan(Context ctx, List insertList, GeneBatchResult result) throws BOSException, EASBizException {
        String tmpTblName = null;
        try {
            if (GeneCommonUtils.isEmpty(insertList)) {
                return;
            }
            StringBuffer errMsg = new StringBuffer();
            if (GeneCommonUtils.isEmpty(insertList = this.verifyBeforeInsert(ctx, insertList, errMsg, result))) {
                return;
            }
            tmpTblName = this.createTempTable(ctx, (GeneDataBaseBatchInfo)insertList.get(0));
            this.insertDataToTmpTable(ctx, insertList, tmpTblName);
            if (this.isNeedVerifyNumber()) {
                insertList = this.verifyNumberAdd(ctx, insertList, errMsg, tmpTblName, result);
            }
            String orgUnitid = null;
            if (!GeneCommonUtils.isEmpty(insertList)) {
                for (GeneDataBaseBatchInfo baseBatchInfo : insertList) {
                    if (baseBatchInfo.getId() == null) {
                        baseBatchInfo.setId(BOSUuid.create((BOSObjectType)baseBatchInfo.getBOSType()));
                    }
                    if (baseBatchInfo.getCU() != null) continue;
                    baseBatchInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                }
                this.beforeInsert(insertList);
                GeneDbUtil.executeBatch(ctx, this.getInsertSql(ctx), this.buildValues(ctx, insertList, true));
                this.afterInsert(ctx, insertList);
                if (!this.isIgnoreOrgFilter()) {
                    orgUnitid = ((GeneDataBaseBatchInfo)insertList.get(0)).getMainOrgUnit().getId().toString();
                }
            }
            if (errMsg.toString().length() > 0) {
                result.getDetailMsg().append(errMsg.toString());
            }
            if (insertList.size() > 0) {
                result.setRightNum(result.getRightNum() + insertList.size());
                List l = this.findNewInsertObject(ctx, orgUnitid, insertList, 1);
                result.setInsertedObject(l);
            }
            this.releaseTempTable(ctx, tmpTblName);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(ctx, tmpTblName);
        }
    }

    protected void beforeInsert(List insertList) {
    }

    protected void afterInsert(Context ctx, List insertList) throws EASBizException, BOSException {
        this.writeLog(ctx, insertList, (short)1);
    }

    private void writeLog(Context ctx, List insertList, short oprStatus) throws BOSException {
        if (insertList == null || insertList.size() <= 0) {
            return;
        }
        if (this.getBatchLogItem(oprStatus) == null || "".equals(this.getBatchLogItem(oprStatus))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity(ctx, this.getBOSType());
        for (int i = 0; i < insertList.size(); ++i) {
            HashMap<String, Object> hashLog = new HashMap<String, Object>();
            LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
            hashLog.put("isSuccessed", new Boolean(false));
            hashLog.put("successed", new Boolean(true));
            hashLog.put("FEntityID", this.getBOSType().toString());
            hashLog.put("FEntityName", entityObjectInfo.getName());
            hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FMethodName", "batchSubmitData");
            GeneDataBaseBatchInfo baseBatchInfo = (GeneDataBaseBatchInfo)insertList.get(i);
            hashLog.put("FInstanceID", baseBatchInfo.getId() == null ? null : baseBatchInfo.getId().toString());
            hashLog.put("FInstanceNo", baseBatchInfo.getLogInfo());
            hashLog.put("FItemName", this.getBatchLogItem(oprStatus));
            hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
            appLog.writeLog(hashLog);
        }
    }

    protected abstract Object getBatchLogItem(short var1);

    private void removePlan(Context ctx, List removeList, GeneBatchResult result) throws BOSException, EASBizException {
        if (GeneCommonUtils.isEmpty(removeList)) {
            return;
        }
        try {
            StringBuffer errMsg = new StringBuffer();
            removeList = this.verifyBeforeRemove(ctx, removeList, errMsg, result);
            if (!GeneCommonUtils.isEmpty(removeList)) {
                Object[] numbers = null;
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                GeneDataBaseBatchInfo info = this.getGeneDataBaseBatchInfo(ctx, (IObjectPK)new ObjectUuidPK((String)removeList.get(0)));
                if (!this.isIgnoreOrgFilter() && info.getMainOrgUnit() != null && codingRuleManager.isExist((IObjectValue)info, info.getMainOrgUnit().getId().toString()) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getMainOrgUnit().getId().toString())) {
                    numbers = this.findDeleteNumbers(ctx, removeList);
                }
                List delObj = this.findDelObj(ctx, removeList);
                String sql = "DELETE FROM " + this.getTableName(ctx) + " WHERE FID in ('" + this.listToStr(removeList, false) + "')";
                GeneDbUtil.execute((Context)ctx, (String)sql);
                this.afterRemove(ctx, delObj);
                if (!GeneCommonUtils.isEmpty(numbers) && !this.isIgnoreOrgFilter() && info.getMainOrgUnit() != null) {
                    codingRuleManager.recycleBatchNumber((IObjectValue)info, info.getMainOrgUnit().getId().toString(), (String[])numbers);
                }
            }
            if (errMsg.toString().length() > 0) {
                result.getDetailMsg().append(errMsg.toString());
            }
            if (!GeneCommonUtils.isEmpty(removeList) && removeList.size() > 0) {
                result.setRightNum(result.getRightNum() + removeList.size());
                Iterator it = removeList.iterator();
                while (it.hasNext()) {
                    result.getDeletedPK().add((String)it.next());
                }
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List findDelObj(Context ctx, List removeList) throws BOSException {
        if (GeneCommonUtils.isEmpty(removeList)) {
            return null;
        }
        HashSet set = new HashSet();
        set.addAll(removeList);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(GeneSelectorUtils.getSelector(this.getBOSType(), "", true, true, true));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CoreBaseCollection obj = this.getCollection(ctx, viewInfo);
        ArrayList l = new ArrayList();
        if (obj != null) {
            Iterator iter = obj.iterator();
            while (iter.hasNext()) {
                l.add(iter.next());
            }
        }
        return l;
    }

    protected void afterRemove(Context ctx, List removeList) throws EASBizException, BOSException {
        this.writeLog(ctx, removeList, (short)3);
    }

    protected List verifyBeforeRemove(Context ctx, List removeList, StringBuffer errMsg, GeneBatchResult result) {
        return removeList;
    }

    protected List verifyBeforeModify(Context ctx, List updateList, StringBuffer errMsg, GeneBatchResult result) {
        return updateList;
    }

    protected List verifyBeforeInsert(Context ctx, List insertList, StringBuffer errMsg, GeneBatchResult result) {
        return insertList;
    }

    protected String getTmpTableDefinition(String tmpTableName, GeneDataBaseBatchInfo info) {
        StringBuffer sb = new StringBuffer();
        sb.append("Create table " + tmpTableName + " (");
        sb.append("FID VARCHAR(44),");
        sb.append("FNUMBER VARCHAR(255),");
        if (!this.isIgnoreOrgFilter()) {
            sb.append("" + this.getMainOrgField(info) + " VARCHAR(44),");
        }
        if (!GeneCommonUtils.isEmpty(this.getCustomerTmpTableDefinition())) {
            sb.append(this.getCustomerTmpTableDefinition());
        }
        sb.append("FLASTUPDATETIME DATETIME");
        sb.append(")");
        return sb.toString();
    }

    protected Object getCustomerTmpTableDefinition() {
        return null;
    }

    protected boolean isIgnoreOrgFilter() {
        return true;
    }

    protected Object[] getInsertTmpTableValue(GeneDataBaseBatchInfo info) {
        Object[] objs = new Object[this.isIgnoreOrgFilter() ? 3 : 4];
        objs[0] = this.fitValue(info.getId());
        objs[1] = this.fitValue(info.getNumber());
        if (this.isIgnoreOrgFilter()) {
            objs[2] = this.fitValue(info.getLastUpdateTime());
        } else {
            objs[2] = this.fitValue(info.getMainOrgUnit());
            objs[3] = this.fitValue(info.getLastUpdateTime());
        }
        return objs;
    }

    protected String getMainOrgField(GeneDataBaseBatchInfo info) {
        return "F" + info.getBizOrgPropertyName() + "ID";
    }

    protected String getUpdateSql(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        DataTableInfo table = entity.getTable();
        ColumnCollection columns = table.getColumns();
        StringBuffer sb = new StringBuffer();
        sb.append("Update " + table.getName() + " SET ");
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            String columnName;
            ColumnInfo column = columns.get(i);
            String string = columnName = column.isMultilingual() ? column.getName() + "_L2" : column.getName();
            if (columnName.equalsIgnoreCase("fid") || this.getUpdateExcludeColumns() != null && this.getUpdateExcludeColumns().contains(column.getName().toUpperCase())) continue;
            sb.append(columnName + "= ? ,");
        }
        if (sb.toString().lastIndexOf(",") > -1) {
            sb = sb.deleteCharAt(sb.toString().lastIndexOf(","));
        }
        sb.append("Where FID=?");
        return sb.toString();
    }

    protected Object[] getUpdateTableValue(Context ctx, GeneDataBaseBatchInfo info) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        DataTableInfo table = entity.getTable();
        ColumnCollection columns = table.getColumns();
        Object[] objs = new Object[columns.size() - (GeneCommonUtils.isEmpty(this.getUpdateExcludeColumns()) ? 0 : this.getUpdateExcludeColumns().size())];
        int j = 0;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            String columnName;
            ColumnInfo column = columns.get(i);
            String string = columnName = column.isMultilingual() ? column.getName() + "_L2" : column.getName();
            if (columnName.equalsIgnoreCase("fid") || this.getUpdateExcludeColumns() != null && this.getUpdateExcludeColumns().contains(column.getName().toUpperCase())) continue;
            objs[j] = this.findValue(info, entity, column);
            ++j;
        }
        objs[j] = info.getId().toString();
        return objs;
    }

    protected List getUpdateExcludeColumns() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("FLASTUPDATETIME");
        l.add("FLASTUPDATEUSERID");
        return l;
    }

    protected String getInsertSql(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        DataTableInfo table = entity.getTable();
        ColumnCollection columns = table.getColumns();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO " + table.getName() + " (");
        StringBuffer tmp = new StringBuffer();
        String split = "?";
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            String columnName;
            ColumnInfo column = columns.get(i);
            String string = columnName = column.isMultilingual() ? column.getName() + "_L2" : column.getName();
            if (this.getInsertExcludeColumns() != null && this.getInsertExcludeColumns().contains(column.getName())) continue;
            if (i == n - 1) {
                sb.append(columnName);
                tmp.append(split);
                continue;
            }
            sb.append(columnName + ",");
            tmp.append(split + ",");
        }
        sb.append(")Values(").append(tmp.toString()).append(")");
        return sb.toString();
    }

    protected Object[] getInsertTableValue(Context ctx, GeneDataBaseBatchInfo info) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        DataTableInfo table = entity.getTable();
        ColumnCollection columns = table.getColumns();
        Object[] objs = new Object[columns.size() - (GeneCommonUtils.isEmpty(this.getInsertExcludeColumns()) ? 0 : this.getInsertExcludeColumns().size())];
        int j = 0;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            ColumnInfo column = columns.get(i);
            if (this.getInsertExcludeColumns() != null && this.getInsertExcludeColumns().contains(column.getName())) continue;
            objs[j] = this.findValue(info, entity, column);
            ++j;
        }
        return objs;
    }

    protected List getInsertExcludeColumns() {
        return null;
    }

    protected void insertDataToTmpTable(Context ctx, List data, String tmpTblName) throws BOSException, EASBizException {
        if (GeneCommonUtils.isEmpty(tmpTblName) || GeneCommonUtils.isEmpty(data)) {
            return;
        }
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        Iterator it = data.iterator();
        int columns = 0;
        while (it.hasNext()) {
            GeneDataBaseBatchInfo info = (GeneDataBaseBatchInfo)it.next();
            Object[] infos = this.getInsertTmpTableValue(info);
            values.add(infos);
            columns = infos.length;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into " + tmpTblName + " values(");
        for (int i = 0; i < columns; ++i) {
            if (i == columns - 1) {
                sql.append("?");
                continue;
            }
            sql.append("?,");
        }
        sql.append(")");
        GeneDbUtil.executeBatch(ctx, sql.toString(), values);
    }

    private Object findValue(GeneDataBaseBatchInfo info, EntityObjectInfo entity, ColumnInfo column) {
        for (PropertyInfo propertyInfo : entity.getPropertiesRuntime()) {
            if (propertyInfo.getMappingField() == null || !propertyInfo.getMappingField().getName().equalsIgnoreCase(column.getName())) continue;
            Object obj = info.get(propertyInfo.getName());
            if (obj == null) {
                return obj;
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                return ((CoreBaseInfo)obj).getId() == null ? null : ((CoreBaseInfo)obj).getId().toString();
            }
            if (obj instanceof BOSUuid) {
                return ((BOSUuid)obj).toString();
            }
            return obj;
        }
        return null;
    }

    private String[] findDeleteNumbers(Context ctx, List removeList) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        if (GeneCommonUtils.isEmpty(removeList)) {
            return null;
        }
        String sql = "Select fnumber from " + this.getTableName(ctx) + " where fid in ('" + this.listToStr(removeList, false) + "')";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return result.toArray(new String[result.size()]);
    }

    protected String listToStr(List list, boolean isNumber) {
        Object[] numbers = new String[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj instanceof GeneDataBaseBatchInfo) {
                GeneDataBaseBatchInfo info = (GeneDataBaseBatchInfo)obj;
                if (isNumber) {
                    numbers[i] = info.getNumber();
                    continue;
                }
                numbers[i] = info.getId().toString();
                continue;
            }
            if (!(obj instanceof String)) continue;
            numbers[i] = (String)obj;
        }
        return StringUtils.arrayToString((Object[])numbers, (String)"','");
    }

    protected void executeBatch(Context ctx, List sqlList) throws BOSException {
        Statement stmt = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.createStatement();
            for (int i = 0; i < sqlList.size(); ++i) {
                if (sqlList.get(i) == null) continue;
                stmt.addBatch((String)sqlList.get(i));
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)cn);
    }

    private String createTempTable(Context ctx, GeneDataBaseBatchInfo info) throws BOSException, EASBizException {
        String tableName = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(this.getTableName(ctx));
        String createSql = this.getTmpTableDefinition(tableName, info);
        if (GeneCommonUtils.isEmpty(createSql)) {
            return tableName;
        }
        DbUtil.execute((Context)ctx, (String)createSql);
        return tableName;
    }

    protected Object fitValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String || obj instanceof BigDecimal || obj instanceof Short) {
            return obj;
        }
        if (obj instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj).getId() == null ? null : ((CoreBaseInfo)obj).getId().toString();
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        if (obj instanceof IntEnum) {
            return new Integer(((IntEnum)obj).getValue());
        }
        if (obj instanceof BOSUuid) {
            return ((BOSUuid)obj).toString();
        }
        return obj;
    }

    protected List verifyExist(Context ctx, List updateList, StringBuffer errMsg, GeneBatchResult result2) throws BOSException {
        if (GeneCommonUtils.isEmpty(updateList)) {
            return updateList;
        }
        String sql = "select fid from " + this.getTableName(ctx) + " where fid in ('" + this.listToStr(updateList, false) + "') ";
        ArrayList<String> result = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                String id = rs.getString("fid");
                result.add(id);
            }
            Iterator it = updateList.iterator();
            while (it.hasNext()) {
                GeneDataBaseBatchInfo info = (GeneDataBaseBatchInfo)it.next();
                Iterator iter = result.iterator();
                boolean find = false;
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    if (!info.getId().toString().equals(id)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                String msg = ResourceBase.getString((String)resourceDir, (String)"0_GeneDataBaseBatchControllerBean", (Locale)ctx.getLocale());
                MessageFormat mf = new MessageFormat(msg);
                sb.append(mf.format(new String[]{info.getNumber()}));
                it.remove();
                result2.setErrNum(result2.getErrNum() + 1);
            }
            if (sb.length() > 0) {
                errMsg.append(sb.toString() + "\n");
            }
            return updateList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public List verifyLastUptTime(Context ctx, List updateList, StringBuffer errMsg, String tmpTblName, GeneBatchResult result) throws BOSException {
        if (GeneCommonUtils.isEmpty(tmpTblName) || GeneCommonUtils.isEmpty(updateList)) {
            return updateList;
        }
        String sql = "Select a.fid \nfrom " + tmpTblName + " a inner join " + this.getTableName(ctx) + " b on a.fid = b.fid \n" + "where a.fid in ('" + this.listToStr(updateList, false) + "') and \n" + "      a.flastupdatetime < b.flastupdatetime \n";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                String id = rs.getString("fid");
                Iterator it = updateList.iterator();
                while (it.hasNext()) {
                    GeneDataBaseBatchInfo info = (GeneDataBaseBatchInfo)it.next();
                    if (info.getLastUpdateTime() == null || !info.getId().toString().equals(id)) continue;
                    String msg = ResourceBase.getString((String)resourceDir, (String)"1_GeneDataBaseBatchControllerBean", (Locale)ctx.getLocale());
                    MessageFormat mf = new MessageFormat(msg);
                    sb.append(mf.format(new String[]{info.getNumber()}));
                    it.remove();
                    result.setErrNum(result.getErrNum() + 1);
                }
            }
            if (sb.length() > 0) {
                errMsg.append(sb.toString() + "\n");
            }
            return updateList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected List verifyNumberModify(Context ctx, List insertList, StringBuffer errMsg, String tmpTblName, GeneBatchResult result) throws EASBizException, BOSException {
        if (GeneCommonUtils.isEmpty(tmpTblName) || GeneCommonUtils.isEmpty(insertList)) {
            return insertList;
        }
        String sql = "Select a.fnumber \nfrom " + tmpTblName + " a," + this.getTableName(ctx) + " b \n" + " where a.fnumber in ('" + this.listToStr(insertList, true) + "') " + (this.isIgnoreOrgFilter() ? "" : " and \n       a." + this.getMainOrgField((GeneDataBaseBatchInfo)insertList.get(0)) + " = b." + this.getMainOrgField((GeneDataBaseBatchInfo)insertList.get(0))) + " and \n" + "       a.fnumber = b.fnumber and a.fid<>b.fid \n";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String id = rs.getString("fnumber");
                Iterator it = insertList.iterator();
                while (it.hasNext()) {
                    GeneDataBaseBatchInfo info = (GeneDataBaseBatchInfo)it.next();
                    if (!info.getNumber().toString().equals(id)) continue;
                    String msg = ResourceBase.getString((String)resourceDir, (String)"2_GeneDataBaseBatchControllerBean", (Locale)ctx.getLocale());
                    MessageFormat mf = new MessageFormat(msg);
                    errMsg.append(mf.format(new String[]{info.getNumber()}));
                    it.remove();
                    result.setErrNum(result.getErrNum() + 1);
                }
            }
            return insertList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected void lockData(Context ctx, List updateList) throws BOSException {
        String sql = "update " + this.getTableName(ctx) + " set FLastUpdateTime= now() where fid in ('" + this.listToStr(updateList, false) + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private List buildValues(Context ctx, List insertList, boolean insert) {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (GeneDataBaseBatchInfo info : insertList) {
            if (insert) {
                values.add(this.getInsertTableValue(ctx, info));
                continue;
            }
            values.add(this.getUpdateTableValue(ctx, info));
        }
        return values;
    }

    private Set getIDSet(List insertList, int oprStatus) {
        HashSet<String> ids = new HashSet<String>();
        for (GeneDataBaseBatchInfo info : insertList) {
            if (1 == oprStatus) {
                if (info.getNumber() == null) continue;
                ids.add(info.getNumber());
                continue;
            }
            if (2 != oprStatus || info.getId() == null) continue;
            ids.add(info.getId().toString());
        }
        return ids;
    }

    public SelectorItemCollection getSelectorItemCollection() {
        return GeneSelectorUtils.getSelector(this.getBOSType(), null, true, true, false);
    }

    private List findNewInsertObject(Context ctx, String storageOrgUnitid, List insertList, int oprStatus) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(this.getSelectorItemCollection());
        FilterInfo filter = new FilterInfo();
        if (!this.isIgnoreOrgFilter()) {
            filter.getFilterItems().add(new FilterItemInfo(((GeneDataBaseBatchInfo)insertList.get(0)).getBizOrgPropertyName() + ".id", (Object)storageOrgUnitid, CompareType.EQUALS));
        }
        FilterInfo tmp = new FilterInfo();
        if (1 == oprStatus) {
            tmp = this.getFilterAfterInsert(insertList);
        } else if (2 == oprStatus) {
            tmp = this.getFilterAfterUpdate(insertList);
        }
        if (tmp != null) {
            filter.mergeFilter(tmp, "and");
        }
        viewInfo.setFilter(filter);
        ArrayList result = new ArrayList();
        List l = this._getGeneDtaBaseCollection(ctx, viewInfo, 0, -1);
        if (l != null && l.size() == 2) {
            IObjectCollection col = (IObjectCollection)l.get(1);
            Iterator it = col.iterator();
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        return result;
    }

    protected FilterInfo getFilterAfterUpdate(List insertList) {
        Set ids = this.getIDSet(insertList, 2);
        FilterInfo filter = new FilterInfo();
        if (ids != null && ids.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        }
        return filter;
    }

    protected FilterInfo getFilterAfterInsert(List insertList) {
        Set ids = this.getIDSet(insertList, 2);
        FilterInfo filter = new FilterInfo();
        if (ids != null && ids.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    protected List _getGeneDtaBaseCollection(Context ctx, EntityViewInfo viewInfo, int start, int length) throws BOSException, EASBizException {
        if (viewInfo == null) {
            return null;
        }
        GeneDataBaseBatchCollection collection = this.getGeneDataBaseBatchCollection(ctx, viewInfo);
        if (GeneCommonUtils.isEmpty((Object)collection)) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new Integer(collection.size()));
        l.add((Object)collection);
        return l;
    }

    public void releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        if (!StringUtil.isEmptyString((String)tableName)) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tableName);
        }
    }

    private List verifyNumberAdd(Context ctx, List insertList, StringBuffer errMsg, String tmpTblName, GeneBatchResult result) throws EASBizException, BOSException {
        if (GeneCommonUtils.isEmpty(tmpTblName) || GeneCommonUtils.isEmpty(insertList)) {
            return insertList;
        }
        String sql = "Select a.fnumber \nfrom " + tmpTblName + " a," + this.getTableName(ctx) + " b \n" + " where a.fnumber in ('" + this.listToStr(insertList, true) + "') " + (this.isIgnoreOrgFilter() ? "" : " and \n      a." + this.getMainOrgField((GeneDataBaseBatchInfo)insertList.get(0)) + " = b." + this.getMainOrgField((GeneDataBaseBatchInfo)insertList.get(0))) + " and \n" + "       a.fnumber = b.fnumber \n";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String id = rs.getString("fnumber");
                Iterator it = insertList.iterator();
                while (it.hasNext()) {
                    GeneDataBaseBatchInfo info = (GeneDataBaseBatchInfo)it.next();
                    if (!info.getNumber().toString().equals(id)) continue;
                    String msg = ResourceBase.getString((String)resourceDir, (String)"2_GeneDataBaseBatchControllerBean", (Locale)ctx.getLocale());
                    MessageFormat mf = new MessageFormat(msg);
                    errMsg.append(mf.format(new String[]{info.getNumber()}));
                    it.remove();
                    result.setErrNum(result.getErrNum() + 1);
                }
            }
            return insertList;
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected GeneDataBaseBatchInfo copyFromInfoValue(GeneDataBaseBatchInfo info, GeneDataBaseBatchInfo targetInfo) {
        targetInfo.setMainOrgUnit(info.getMainOrgUnit());
        targetInfo.setHelpCode(info.getHelpCode());
        targetInfo.setDeletedStatus(info.getDeletedStatus());
        targetInfo.setCheckedStatus(info.getCheckedStatus());
        targetInfo.setBlockedStatus(info.getBlockedStatus());
        targetInfo.setEffectedStatus(info.getEffectedStatus());
        targetInfo.setName(info.getName());
        targetInfo.setNumber(info.getNumber());
        targetInfo.setDescription(info.getDescription());
        targetInfo.setSimpleName(info.getSimpleName());
        targetInfo.setCreateTime(info.getCreateTime());
        targetInfo.setCreator(info.getCreator());
        targetInfo.setLastUpdateTime(info.getLastUpdateTime());
        targetInfo.setLastUpdateUser(info.getLastUpdateUser());
        targetInfo.setCU(info.getCU());
        return targetInfo;
    }

    @Override
    protected int _getGeneDtaBaseCount(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        if (viewInfo == null) {
            return 0;
        }
        try {
            GeneDataBaseBatchCollection collection = this.getGeneDataBaseBatchCollection(ctx, viewInfo);
            if (GeneCommonUtils.isEmpty((Object)collection)) {
                return 0;
            }
            return collection.size();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

