/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneDataBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.AbstractGeneDataBaseControllerBean;
import com.kingdee.eas.eqm.common.core.app.action.IServerActionManager;
import com.kingdee.eas.eqm.common.core.app.action.ServerActionManager;
import com.kingdee.eas.eqm.common.core.app.action.ServerEvent;
import com.kingdee.eas.eqm.common.core.app.util.GeneServerUtils;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseAddnewCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseAuditCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseBlockedCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseCancelCancelCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseCancelCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseDeleteCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseUnAuditCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseUnBlockedCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.GeneDataBaseUpdateCommonVerifyItem;
import com.kingdee.eas.eqm.common.core.codingrule.ISuportCodingRule;
import com.kingdee.eas.eqm.common.core.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.eqm.common.core.util.GeneFilterUtils;
import com.kingdee.eas.eqm.common.core.util.GeneStringUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class GeneDataBaseControllerBean
extends AbstractGeneDataBaseControllerBean
implements ISuportCodingRule {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.core.app.GeneDataBaseControllerBean");
    private IServerActionManager serverActionManager = null;
    protected String permissionItem = null;
    private static final String SHARE_TYPE_NAME = "controlType";
    private String controlType = null;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneDataBaseInfo info = (GeneDataBaseInfo)model;
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        String tableName = this.getTableName(ctx);
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneDataBaseInfo info = (GeneDataBaseInfo)model;
        if (info.getNumber() != null) {
            info.setNumber(info.getNumber().trim());
        }
        if (info.getMainOrgUnit() != null && info.getMainOrgUnit().getId() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        String tableName = this.getTableName(ctx);
        GeneServerUtils.checkLastUpTime(ctx, (ObjectBaseInfo)info, tableName);
        if (GeneStringUtils.isEmpty(info.getNumber())) {
            this.getCodingRuleStrategy().initNumber(this, ctx, info);
        }
        this._checkNumberBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        return super._submit(ctx, model);
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseUpdateCommonVerifyItem verifyItem = new GeneDataBaseUpdateCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseAddnewCommonVerifyItem verifyItem = new GeneDataBaseAddnewCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        GeneDataBaseInfo info = (GeneDataBaseInfo)model;
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        this.getCodingRuleStrategy().initEditNumber(this, ctx, info);
        this._checkNumberBlank(ctx, info);
        this._checkNameBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        IVerifyManager verifymanager = this.getUpdateVerifyManager(ctx, info);
        verifymanager.verify();
        super._update(ctx, pk, model);
    }

    public ServerCodingRuleStrategy getCodingRuleStrategy() {
        return new ServerCodingRuleStrategy();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        IVerifyManager verifymanager = this.getDeleteVerifyManager(ctx, info);
        verifymanager.verify();
        this.beforeDelete(ctx, pk);
        super._delete(ctx, pk);
        String orgID = "";
        orgID = info.getMainOrgUnit() != null ? info.getMainOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        this.getCodingRuleStrategy().recycleNumber(ctx, (CoreBaseInfo)info, orgID);
    }

    protected void beforeDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseDeleteCommonVerifyItem verifyItem = new GeneDataBaseDeleteCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneDataBaseInfo info = (GeneDataBaseInfo)model;
        if (GeneStringUtils.isEmpty(info.getNumber())) {
            this.getCodingRuleStrategy().initNumber(this, ctx, info);
        }
        LogControllManager.getInstance().enableLog();
        this.logAddnew(ctx, info);
        this._checkNumberBlank(ctx, info);
        this._checkNameBlank(ctx, info);
        this._checkNumberDup(ctx, info);
        IVerifyManager verifymanager = this.getAddnewVerifyManager(ctx, info);
        verifymanager.verify();
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNeedVerifyNumber()) {
            super._checkNameBlank(ctx, model);
        }
    }

    protected void _checkNumberBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNeedVerifyNumber()) {
            super._checkNumberBlank(ctx, model);
        }
    }

    private String getControlType(Context ctx, DataBaseInfo info) throws BOSException {
        if (this.controlType != null) {
            return this.controlType;
        }
        this.controlType = "";
        EntityObjectInfo eoi = this.getBOSEntity(ctx, (CoreBaseInfo)info);
        boolean hasShareType = false;
        hasShareType = eoi.containsExtendedPropertyKey(SHARE_TYPE_NAME);
        if (hasShareType) {
            this.controlType = eoi.getExtendedProperty(SHARE_TYPE_NAME);
        } else if (eoi.getBaseEntity().getName().equals("DataBaseD")) {
            this.controlType = "D";
        }
        return this.controlType;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNeedVerifyNumber()) {
            String controlType;
            GeneDataBaseInfo dataBaseInfo = (GeneDataBaseInfo)model;
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (dataBaseInfo.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
            }
            if ((controlType = GeneSeverMetadataUtils.getControlType(ctx, this.getBOSType())) != null && (controlType.equalsIgnoreCase("D") || controlType.equalsIgnoreCase("I"))) {
                if (dataBaseInfo.getMainOrgUnit() != null && FilterUtility.hasFilterItem((FilterInfo)filter)) {
                    GeneFilterUtils.mergeFilter(filter, new FilterItemInfo(dataBaseInfo.getBizOrgPropertyName() + ".id", (Object)dataBaseInfo.getMainOrgUnit().getId().toString()));
                }
            } else {
                FilterInfo filterCU = this.getFilterForDefaultCU(ctx, model);
                if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
                    filter.mergeFilter(filterCU, "AND");
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("id"));
            if (super._exists(ctx, filter)) {
                String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
            }
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isNeedVerifyNumber()) {
            super._checkNameDup(ctx, model);
        }
    }

    @Override
    public boolean isNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        String controlType;
        GeneDataBaseInfo coreBillBaseInfo = (GeneDataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if ((controlType = GeneSeverMetadataUtils.getControlType(ctx, this.getBOSType())) != null && (controlType.equalsIgnoreCase("D") || controlType.equalsIgnoreCase("I"))) {
            GeneDataBaseInfo baseInfo = (GeneDataBaseInfo)model;
            OrgUnitInfo org = baseInfo.getMainOrgUnit();
            if (org == null) {
                org = ContextUtil.getCurrentOrgUnit((Context)ctx);
            }
            FilterItemInfo storageOrgUnitItem = new FilterItemInfo(baseInfo.getBizOrgPropertyName() + ".id", (Object)org.getId().toString());
            GeneFilterUtils.mergeFilter(filter, storageOrgUnitItem);
        } else if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterForDefaultCU(ctx, coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForDefaultCU(ctx, coreBillBaseInfo), "AND");
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        IVerifyManager verifymanager = this.getAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FCheckedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    public void mutexRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean b = MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(pk.toString());
        if (!b) {
            throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
        }
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseAuditCommonVerifyItem verifyItem = new GeneDataBaseAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected void lockData(Context ctx, String pk) throws BOSException, EASBizException {
        String tbl = this.getTableName(ctx);
        String sql = "update " + tbl + " set FLastUpdateTime= now() where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        if (info.getMainOrgUnit() != null) {
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getMainOrgUnit().getId());
            String permitItem = this.getPermissionItem();
            if (!GeneStringUtils.isEmpty(permitItem)) {
                GeneServerUtils.checkPermission(ctx, (IObjectPK)orgPK, permitItem);
            }
        }
        IVerifyManager verifymanager = this.getUnAuditVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FCheckedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseUnAuditCommonVerifyItem verifyItem = new GeneDataBaseUnAuditCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getUnBlockedVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseUnBlockedCommonVerifyItem verifyItem = new GeneDataBaseUnBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getBlockedVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseBlockedCommonVerifyItem verifyItem = new GeneDataBaseBlockedCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    public String getTableName(Context ctx) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        return entity.getTable().getName();
    }

    @Override
    protected void _blocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _unBlocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getUnBlockedVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FBlockedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        GeneDataBaseInfo info = (GeneDataBaseInfo)this.getValue(ctx, pk);
        IVerifyManager verifymanager = this.getCancelCancelVerifyManager(ctx, info);
        verifymanager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FDeletedStatus=?   where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    protected IVerifyManager getCancelCancelVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseCancelCancelCommonVerifyItem verifyItem = new GeneDataBaseCancelCancelCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getCancelVerifyManager(Context ctx, GeneDataBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        GeneDataBaseCancelCommonVerifyItem verifyItem = new GeneDataBaseCancelCommonVerifyItem(info);
        verifymanager.addVerifyItem(verifyItem);
        return verifymanager;
    }

    @Override
    public FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForDefaultCU(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.audit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.unAudit(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.cancel(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.cancelCancel(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.blocked(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unBlocked(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.unBlocked(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mutexRequest(ctx, pk);
        try {
            LogControllManager.getInstance().enableLog();
            super.delete(ctx, pk);
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(pk.toString());
        }
    }

    @Override
    protected void _logAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    public synchronized IServerActionManager getServerActionManager(Context ctx) throws BOSException {
        if (this.serverActionManager == null) {
            this.serverActionManager = new ServerActionManager();
            this.regesterServerAction(ctx, this.serverActionManager);
        }
        return this.serverActionManager;
    }

    protected void regesterServerAction(Context ctx, IServerActionManager serverActionManager) throws BOSException {
    }

    protected void fireServerAction(Context ctx, Object model, String eventName, Object[] args) throws EASBizException, BOSException {
        ServerEvent event = new ServerEvent();
        event.setEventName(eventName);
        event.setSrcObject(model);
        event.setParams(args);
        this.getServerActionManager(ctx).fireServerAction(ctx, event);
    }

    protected boolean isNeedVerifyNumber() {
        return true;
    }

    @Override
    public GeneDataBaseInfo getGeneDataBaseInfo(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super.getGeneDataBaseInfo(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public GeneDataBaseInfo getGeneDataBaseInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getGeneDataBaseInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public GeneDataBaseInfo getGeneDataBaseInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getGeneDataBaseInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk, selector, sorter);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, pk, sorter);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    public CoreBaseInfo getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super.getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    protected void setPermissionItem(String permissionItem) {
        this.permissionItem = permissionItem;
    }

    protected String getPermissionItem() {
        return this.permissionItem;
    }
}

