/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.util;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public final class GeneDateUtils {
    Logger logger = Logger.getLogger(GeneDateUtils.class);
    public static final int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static final int KEY_STARTDATE = 0;
    public static final int KEY_ENDDATE = 1;
    public static final int KEY_HOUR = 2;
    public static final int KEY_MIN10 = 3;
    public static final int KEY_MIN20 = 4;
    public static final int KEY_MIN30 = 5;
    public static final int KEY_MIN40 = 6;
    public static final int KEY_MIN50 = 7;
    public static final int NANOS_MAX = 999999999;
    public static final DateFormat format = BOSLocaleUtil.getDateFormat();

    public static List getTimeList(int beginYear, int beginMonth, int endYear, int endMonth, int k) {
        ArrayList<List> list = new ArrayList<List>();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                list.add(GeneDateUtils.getTimeList(beginYear, j, k));
            }
        } else {
            int j;
            for (j = beginMonth; j < 12; ++j) {
                list.add(GeneDateUtils.getTimeList(beginYear, j, k));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < 12; ++j2) {
                    list.add(GeneDateUtils.getTimeList(i, j2, k));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                list.add(GeneDateUtils.getTimeList(endYear, j, k));
            }
        }
        return list;
    }

    public static List getTimeList(int beginYear, int beginMonth, int k) {
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        int max = ((Calendar)begincal).getActualMaximum(5);
        for (int i = 1; i < max; i += k) {
            list.add(begincal.getTime());
            ((Calendar)begincal).add(5, k);
        }
        begincal = new GregorianCalendar(beginYear, beginMonth, max);
        list.add(begincal.getTime());
        return list;
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Timestamp getTimeStampDayBegin() {
        return new Timestamp(GeneDateUtils.getDayBegin().getTime());
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String getDayBeginString() {
        Date d = GeneDateUtils.getDayBegin();
        return BOSLocaleUtil.getDateFormat().format(d);
    }

    public static Date getNextDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + 1);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + 1);
        return cal.getTime();
    }

    public static Date getBeforeMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - 1);
        return cal.getTime();
    }

    public static java.sql.Date getSQLBegin(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        java.sql.Date ds = new java.sql.Date(cal.getTimeInMillis());
        return ds;
    }

    public static java.sql.Date getSQLEnd(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Date getFirstSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = GeneDateUtils.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 3);
        return cal.getTime();
    }

    public static Date getFirstYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static int getSeason(int mouth) {
        return SEASON[mouth];
    }

    public static Date getBeforeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getAfterDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static boolean isFirstDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) == 0 && cal.get(5) == 1;
    }

    public static Date getFirstYearDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastYearDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static Date getDayBegin(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static long dateDiff(String interval, Date dDate1, Date dDate2) {
        int field;
        Date date2;
        Date date1;
        int desiredField = 0;
        int coef = 1;
        if (dDate1.getTime() > dDate2.getTime()) {
            coef = -1;
            date1 = dDate2;
            date2 = dDate1;
        } else {
            date1 = dDate1;
            date2 = dDate2;
        }
        if (interval.equals("yyyy")) {
            field = 1;
        } else if (interval.equals("m")) {
            field = 2;
        } else if (interval.equals("d")) {
            field = 5;
        } else if (interval.equals("y")) {
            field = 5;
        } else if (interval.equals("w")) {
            field = 4;
        } else if (interval.equals("ww")) {
            field = 3;
        } else if (interval.equals("h")) {
            field = 5;
            desiredField = 11;
        } else if (interval.equals("n")) {
            field = 5;
            desiredField = 12;
        } else if (interval.equals("s")) {
            field = 5;
            desiredField = 13;
        } else {
            return -1L;
        }
        Calendar calTmp = Calendar.getInstance();
        calTmp.setTime(date1);
        long nbOccurence = 0L;
        calTmp.add(field, 1);
        Date dateTemp = calTmp.getTime();
        while (dateTemp.getTime() <= date2.getTime()) {
            calTmp.add(field, 1);
            dateTemp = calTmp.getTime();
            ++nbOccurence;
        }
        if (desiredField == 11 || desiredField == 12 || desiredField == 13) {
            calTmp.setTime(date1);
            calTmp.add(field, (int)nbOccurence);
            dateTemp = calTmp.getTime();
            switch (desiredField) {
                case 11: {
                    nbOccurence *= 24L;
                    break;
                }
                case 12: {
                    nbOccurence = nbOccurence * 24L * 60L;
                    break;
                }
                case 13: {
                    nbOccurence = nbOccurence * 24L * 60L * 60L;
                }
            }
            calTmp.add(desiredField, 1);
            dateTemp = calTmp.getTime();
            while (dateTemp.getTime() <= date2.getTime()) {
                calTmp.add(desiredField, 1);
                dateTemp = calTmp.getTime();
                ++nbOccurence;
            }
        }
        return nbOccurence * (long)coef;
    }

    public static Date getFirstDayOfCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getFirstDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getEndDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getLastMonth() {
        Date date = GeneDateUtils.getDayBegin();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static String getLastMonthString() {
        Date d = GeneDateUtils.getLastMonth();
        return BOSLocaleUtil.getDateFormat().format(d);
    }

    public static String formatDate(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(d);
    }

    public static String formatDate2(Date d) {
        DateFormat df = BOSLocaleUtil.getDateFormat();
        return df.format(d);
    }

    public static Date max(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date min(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date2;
        }
        return date1;
    }

    public static java.sql.Date truncateSqlDate(java.sql.Date sqlDate) {
        Date date = new Date(sqlDate.getTime());
        return new java.sql.Date(DateTimeUtils.truncateDate((Date)date).getTime());
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return cal.getTime();
    }

    public static Date getFirstDayByWeekNum(int year, int week) {
        if (year < 0 || week < 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        int dayofweek = cal.get(7);
        cal.add(5, 7 * (week - 1) - dayofweek + 2);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, BigDecimal i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (i == null) {
            return date;
        }
        int d = i.intValue();
        cal.set(5, cal.get(5) + d);
        return cal.getTime();
    }

    public static Timestamp transformTimestamp(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date dateAddByMonth(Date date, int addMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        c.set(2, month + addMonth);
        return c.getTime();
    }

    public static Date dateAddMonth(Date date, int addMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, addMonth);
        return c.getTime();
    }

    public static Timestamp DateToTime(Date date) {
        return !EmptyUtil.isEmpty((Object)date) ? new Timestamp(date.getTime()) : new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public static Date timeToDate(Timestamp time) {
        return !EmptyUtil.isEmpty((Object)time) ? new Date(time.getTime()) : GeneDateUtils.now();
    }

    public static Date simpleDate(Date date) throws ParseException {
        Date d = !EmptyUtil.isEmpty((Object)date) ? date : new Date();
        return format.parse(format.format(d));
    }

    public static int compareByDate(Date dateLeft, Date dateRight) throws ParseException {
        Date ld = GeneDateUtils.simpleDate(dateLeft);
        Date sd = GeneDateUtils.simpleDate(dateRight);
        return ld.compareTo(sd);
    }

    public static int compareByAccurateDate(Date dateLeft, Date dateRight) throws ParseException {
        DateFormat sdf = BOSLocaleUtil.getDateTimeFormat();
        Date ld = sdf.parse(sdf.format(dateLeft));
        Date sd = sdf.parse(sdf.format(dateRight));
        if (ld.getTime() < sd.getTime()) {
            return -1;
        }
        if (ld.getTime() > sd.getTime()) {
            return 1;
        }
        return 0;
    }

    public static Calendar getCurrentCalendar(Date date, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, year);
        calendar.add(2, month);
        calendar.add(5, day);
        return calendar;
    }

    public static int compareToNowByDate(Date date) throws ParseException {
        return GeneDateUtils.compareByDate(null, date);
    }

    public static Date now() {
        return Calendar.getInstance().getTime();
    }

    public static Timestamp nowTime() {
        return GeneDateUtils.DateToTime(GeneDateUtils.now());
    }

    public static Timestamp nowStart() {
        return GeneDateUtils.time(null, 0);
    }

    public static Timestamp nowEnd() {
        return GeneDateUtils.time(null, 1);
    }

    public static Timestamp startTime(Date date) {
        return GeneDateUtils.time(date, 0);
    }

    public static Timestamp endTime(Date date) {
        return GeneDateUtils.time(date, 1);
    }

    public static Timestamp time(Date date, int key) {
        Date d = !EmptyUtil.isEmpty((Object)date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        Timestamp t = null;
        if (0 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(0);
        } else if (1 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        } else if (2 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 0, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        } else if (3 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 10, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        } else if (4 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 20, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        } else if (5 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 30, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        } else if (6 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 40, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        } else if (7 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), 50, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        }
        return t;
    }

    public static Timestamp queryTime(Date date, int key) {
        Date d = !EmptyUtil.isEmpty((Object)date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        Timestamp t = null;
        if (0 == key) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(0);
        } else if (1 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        }
        return t;
    }

    public static Timestamp firstDateOfMonth(Date date) {
        Date d = !EmptyUtil.isEmpty((Object)date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        Timestamp t = null;
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        t = new Timestamp(calendar.getTimeInMillis());
        t.setNanos(0);
        return t;
    }

    public static Timestamp lastDateOfMonth(Date date) {
        Date d = !EmptyUtil.isEmpty((Object)date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(2, 1);
        Timestamp t = null;
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        calendar.add(5, -1);
        t = new Timestamp(calendar.getTimeInMillis());
        t.setNanos(0);
        return t;
    }
}

