/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.util;

import com.kingdee.eas.framework.ObjectBaseInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class GeneStringUtils {
    public static boolean isNumber(String numStr) {
        if (numStr == null) {
            return false;
        }
        try {
            Double.parseDouble(numStr);
        }
        catch (NumberFormatException nex) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String intStr) {
        if (intStr == null) {
            return false;
        }
        try {
            Integer.parseInt(intStr);
        }
        catch (NumberFormatException nex) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() <= 0;
    }

    public static String toString(BigDecimal dec) {
        Method method = null;
        Class<?> cls = dec.getClass();
        try {
            method = cls.getMethod("toPlainString", null);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)dec, null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return dec.toString();
    }

    public static String nameFromSplits(String[] splits, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(splits[i]);
        }
        return sb.toString();
    }

    public static String getKeyIdList(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(ids[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    public static String getKeyIdList(ObjectBaseInfo[] vos, String delim) {
        if (vos == null || vos.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vos.length; ++i) {
            if (vos[i] == null) continue;
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(vos[i].getId().toString());
        }
        return sb.toString();
    }

    public static String getKeyIdListWithOutQuotationMask(Object[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(ids[i]);
        }
        return sb.toString();
    }

    public static LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public static LinkedHashSet getKeyIdList(String ids) {
        return GeneStringUtils.getKeyIdList(ids, ";");
    }

    public static String leftPadString(char ch, String str, int size) {
        if (str.length() > size) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(ch);
        }
        sb = sb.replace(sb.length() - str.length(), sb.length(), str);
        return sb.toString();
    }

    public static String rightPadString(char ch, String str, int size) {
        if (str.length() > size) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(ch);
        }
        sb = sb.replace(0, str.length(), str);
        return sb.toString();
    }

    public static String stripTrailingZeros(BigDecimal dec) {
        if (dec == null) {
            return null;
        }
        Method method = null;
        Class<?> cls = dec.getClass();
        try {
            method = cls.getMethod("stripTrailingZeros", null);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            try {
                dec = (BigDecimal)method.invoke((Object)dec, null);
                return GeneStringUtils.toString(dec);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else {
            String str = GeneStringUtils.toString(dec);
            while (str.endsWith("0")) {
                if (!(str = str.substring(0, str.length() - 1)).endsWith(".")) continue;
                str = str.substring(0, str.length() - 1);
                break;
            }
            return str;
        }
        return GeneStringUtils.toString(dec);
    }

    public static int getStringLength(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        char[] chars = str.toCharArray();
        int length = 0;
        for (int i = 0; i < chars.length; ++i) {
            byte[] bytes = ("" + chars[i]).getBytes();
            if (bytes.length == 2) {
                int[] ints = new int[]{bytes[0] & 0xFF, bytes[1] & 0xFF};
                if (ints[0] >= 129 && ints[0] <= 254 && ints[1] >= 64 && ints[1] <= 254) {
                    length += 2;
                    continue;
                }
                ++length;
                continue;
            }
            ++length;
        }
        return length;
    }
}

