/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.eqmcore.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.eqmcore.app.AbstractEqmFinanceFacadeControllerBean;
import com.kingdee.util.NumericExceptionSubItem;
import org.apache.log4j.Logger;

public class EqmFinanceFacadeControllerBean
extends AbstractEqmFinanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.eqmcore.app.util.EqmFinanceFacadeControllerBean");

    @Override
    protected CompanyOrgUnitInfo _getFinanceOrg(Context ctx, String orgUnitID, int fromOrg) throws BOSException, EASBizException {
        OrgUnitCollection unitCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(orgUnitID, fromOrg, 1);
        CompanyOrgUnitInfo financeOrg = (CompanyOrgUnitInfo)unitCol.get(0);
        if (financeOrg != null) {
            financeOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(financeOrg.getId().toString()), this.getFinanceOrgSic());
        }
        return financeOrg;
    }

    @Override
    protected CurrencyInfo _getCurrency(Context ctx, String orgUnitID, int fromOrgType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo financeOrg = this.getFinanceOrg(ctx, orgUnitID, fromOrgType);
        if (financeOrg == null) {
            return null;
        }
        return financeOrg.getBaseCurrency();
    }

    @Override
    protected CurrencyInfo _getCurrency(Context ctx, String[] orgUnitID, int[] fromOrgType) throws BOSException, EASBizException {
        if (orgUnitID == null || orgUnitID.length == 0) {
            return null;
        }
        if (orgUnitID.length != fromOrgType.length) {
            throw new EASBizException(new NumericExceptionSubItem("10", "CHECKTEXTLENGTH1"));
        }
        for (int index = 0; index < orgUnitID.length; ++index) {
            CurrencyInfo currency;
            if (orgUnitID[index] == null || (currency = this.getCurrency(ctx, orgUnitID[index], fromOrgType[index])) == null) continue;
            return currency;
        }
        return null;
    }

    private SelectorItemCollection getFinanceOrgSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }
}

