/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.eqmcore.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class EQMDBUtilForDB2 {
    public static final String CONFIG_EXCEPTION = "CONFIG_EXCEPTION";
    private static final int MAX_DATA_ROW = 8000;
    private static final Logger logger = Logger.getLogger(EQMDBUtilForDB2.class);

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    ps.setNull(i + 1, 0);
                    continue;
                }
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List paramsList) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block8: {
            int[] nArray;
            conn = null;
            ps = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                Object[] params = null;
                int k = 1;
                boolean flag = false;
                for (int i = 0; i < paramsList.size(); ++i) {
                    params = (Object[])paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] != null) {
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        ps.setNull(j + 1, 0);
                    }
                    ps.addBatch();
                    if (i == k * 8000) {
                        flag = true;
                    }
                    if (i <= k * 8000 || !flag) continue;
                    ps.executeBatch();
                    ++k;
                    flag = false;
                    ps.clearBatch();
                }
                if (flag) break block8;
                nArray = ps.executeBatch();
            }
            catch (SQLException exc) {
                try {
                    throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return nArray;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        EQMDBUtilForDB2.executeBatchAndReturn(ctx, sql, paramsList);
    }
}

