/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.common.eqmcore.app.util.EQMDBUtilForDB2;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.StatusChangeAction;
import com.kingdee.eas.eqm.maintain.app.action.WorkOrderPermitVerifyItem;
import com.kingdee.eas.eqm.maintain.app.verify.WorkOrderSubmitVerifyItem;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class AcceptanceAction
extends StatusChangeAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.maintain.app.action.AcceptanceAction");

    public AcceptanceAction(WorkOrderControllerBean controllerBean) {
        super(controllerBean);
        this.status = GeneBillBaseStatusEnum.Check;
    }

    @Override
    protected void verify(Context ctx, WorkOrderInfo workOrderInfo) throws EASBizException, BOSException {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new WorkOrderSubmitVerifyItem(ctx, (GeneBillBaseInfo)workOrderInfo, true));
        verifyManager.verify();
        if (!((workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Finish) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.StartWork) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Release) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) && workOrderInfo.isRequireCheck())) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_CHECK, new Object[]{workOrderInfo.getNumber()});
        }
        WorkOrderPermitVerifyItem workOrderstatus = new WorkOrderPermitVerifyItem(ctx, workOrderInfo, new GeneBillBaseStatusEnum[]{GeneBillBaseStatusEnum.Sign, GeneBillBaseStatusEnum.ForceClosed, GeneBillBaseStatusEnum.Recycle}, GeneBillBaseStatusEnum.Check);
        workOrderstatus.verify();
    }

    @Override
    protected void prepareData(Context ctx, WorkOrderInfo workOrderInfo) {
        String desc;
        String checkUser;
        Date checkDate = workOrderInfo.getCheckDate();
        if (checkDate == null) {
            workOrderInfo.setCheckDate(GeneDateUtils.now());
        }
        if ((checkUser = workOrderInfo.getCheckUser()) == null) {
            checkUser = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            workOrderInfo.setCheckUser(checkUser);
        }
        if ((desc = workOrderInfo.getDescription()) == null) {
            desc = "";
            workOrderInfo.setDescription(desc);
        }
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (workOrderInfo.getCheckPerson() == null) {
            try {
                if (this.isHROrgPerson(ctx, person, workOrderInfo.getMaintainOrgUnit())) {
                    workOrderInfo.setCheckPerson(person);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void changeWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        workOrderInfo.setBillStatus(this.status);
        String ID = workOrderInfo.getId().toString();
        String sql = "update T_EQM_WORKORDER set FBillStatus =?,FCheckUserID =?,FCheckDate =?,FDescription=? where FID =?";
        EQMDBUtilForDB2.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(this.status.getValue()), workOrderInfo.getCheckPerson() == null ? null : workOrderInfo.getCheckPerson().getId().toString(), new Timestamp(workOrderInfo.getCheckDate().getTime()), workOrderInfo.getDescription(), ID});
    }

    @Override
    protected List changeSubWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        return this.controllerBean.updateStatus(ctx, workOrderInfo);
    }

    @Override
    protected Object getLogItem() {
        return "eqm_maintain_workorder_acceptance";
    }

    protected boolean isHROrgPerson(Context ctx, PersonInfo person, StorageOrgUnitInfo storageOrgUnit) throws Exception {
        boolean isHROrgPerson = false;
        PositionMemberInfo positionMember = null;
        PositionMemberCollection positionMembers = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(this.getPositionMemberView(person.getId().toString()));
        for (int i = 0; i < positionMembers.size(); ++i) {
            positionMember = positionMembers.get(i);
        }
        IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ioc = iour.getToUnit(storageOrgUnit.getId().toString(), 4, 0);
        for (int index = 0; index < ioc.size(); ++index) {
            if (positionMember == null || positionMember.getPosition() == null || !ioc.get(index).getId().toString().equals(positionMember.getPosition().getAdminOrgUnit().getId().toString())) continue;
            isHROrgPerson = true;
            break;
        }
        return isHROrgPerson;
    }

    protected EntityViewInfo getPositionMemberView(String PersonID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)PersonID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        view.setSelector(sic);
        return view;
    }
}

