/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.common.eqmcore.app.util.EQMDBUtilForDB2;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.StatusChangeAction;
import com.kingdee.eas.eqm.maintain.app.action.WorkOrderPermitVerifyItem;
import com.kingdee.eas.eqm.maintain.app.verify.WorkOrderCloseVerifyItem;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ClosedAction
extends StatusChangeAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.maintain.app.action.ClosedAction");
    private IRowSet workOrderTree = null;
    private List updateList = null;

    public ClosedAction(WorkOrderControllerBean controllerBean) {
        super(controllerBean);
        this.status = GeneBillBaseStatusEnum.CLOSED;
    }

    @Override
    public void execute(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.execute(ctx, model);
        WorkOrderInfo workOrderInfo = (WorkOrderInfo)model;
        this.handleTaskReq(ctx, workOrderInfo);
        this.handleOutWarehs(ctx, workOrderInfo.getId().toString(), this.updateList, 49);
    }

    private void handleTaskReq(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        String sql = "SELECT DISTINCT T0.FID ,T0.FNumber FROM T_EQM_TASKREQ T0 INNER JOIN T_EQM_FAULTREPORTENTRY T1 ON T0.FID=T1.FTASKREQID WHERE T1.FPARENTID IN (?) AND T0.FBillStatus <> 49 AND T0.FBillStatus <> 60";
        IRowSet taskReqs = WorkOrderControllerBean.batchSelectByID(ctx, sql, this.workOrderTree, 100);
        if (taskReqs.size() <= 0) {
            return;
        }
        sql = "SELECT T0.FID,COUNT(*) AS COUNT FROM T_EQM_TASKREQ T0 INNER JOIN T_EQM_FAULTREPORTENTRY T1 ON T0.FID=T1.FTASKREQID INNER JOIN T_EQM_WORKORDER T2 ON T2.FID=T1.FPARENTID WHERE T0.FID IN (?) AND T0.FBILLSTATUS IN (10,20,30,40,70) AND T2.FBILLSTATUS IN (10,20,30,40,45,46,48) GROUP BY T0.FID";
        IRowSet notClosedtaskReqs = WorkOrderControllerBean.batchSelectByID(ctx, sql, taskReqs, 100);
        ArrayList<Object[]> toCloseList = new ArrayList<Object[]>();
        try {
            for (int i = 0; i < taskReqs.size(); ++i) {
                taskReqs.absolute(i + 1);
                boolean isNeedClose = true;
                for (int j = 0; j < notClosedtaskReqs.size(); ++j) {
                    notClosedtaskReqs.absolute(j + 1);
                    if (!taskReqs.getString("FID").equals(notClosedtaskReqs.getString("FID"))) continue;
                    isNeedClose = false;
                    break;
                }
                if (!isNeedClose) continue;
                toCloseList.add(new Object[]{new Integer(49), new Timestamp(workOrderInfo.getCloseDate().getTime()), taskReqs.getString("FID")});
                this.writeLog(ctx, "eqm_maintain_taskreq_closed", new BOSObjectType("1A2F30DB"), taskReqs.getString("FID"), taskReqs.getString("FNumber"));
            }
        }
        catch (Exception e) {
            throw new BOSException("Sql execute exception : ", (Throwable)e);
        }
        sql = "UPDATE T_EQM_TASKREQ SET FBILLSTATUS = ? ,FCloseDate = ? WHERE FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)sql, toCloseList);
    }

    private void handleOutWarehs(Context ctx, String workOrderID, List updateList, int billStatus) throws BOSException, EASBizException {
        Boolean deleteRalateOutWarehs = (Boolean)ctx.get((Object)"DELETE_RELATE_OUTWAREHS");
        ArrayList<Object> workOrderList = new ArrayList<Object>();
        for (Object[] objectList : updateList) {
            workOrderList.add(objectList[1]);
        }
        workOrderList.add(workOrderID);
        if (deleteRalateOutWarehs != null && deleteRalateOutWarehs.booleanValue()) {
            this.handleAfterWorkorderColse(ctx, workOrderID, workOrderList, 49);
        }
        this.forceCloseNotifyBill(ctx, 49, workOrderList);
    }

    public void handleAfterWorkorderColse(Context ctx, String workOrderID, List workOrderList, int billStatus) throws BOSException, EASBizException {
        ArrayList<String> reqBillIds = new ArrayList<String>();
        StringBuffer ksql = new StringBuffer();
        ksql.append(" SELECT  BILL.FId ");
        ksql.append(" FROM T_IM_MaterialReqBillEntry ENTRY INNER JOIN T_IM_MaterialReqBill BILL ON BILL.FID = ENTRY.FParentID ");
        ksql.append(" WHERE (BILL.FBaseStatus=1 ");
        ksql.append(" OR BILL.FBaseStatus=2 )");
        ksql.append("AND ENTRY.CFWorkOrderPlanNum in (");
        ksql.append(this.listToString(workOrderList));
        ksql.append(")");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            if (null != rows) {
                while (rows.next()) {
                    if (rows.getString("FId") == null || reqBillIds.contains(rows.getString("FId"))) continue;
                    reqBillIds.add(rows.getString("FId"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < reqBillIds.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(reqBillIds.get(i).toString());
            MaterialReqBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)pk);
        }
    }

    protected void forceCloseNotifyBill(Context ctx, int billStatus, List workOrderList) throws BOSException {
        ArrayList<Object[]> notifyBills = new ArrayList<Object[]>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        StringBuffer notifySql = new StringBuffer();
        notifySql.append(" SELECT  FId,FNumber");
        notifySql.append(" FROM T_EQM_MaintainNotify  ");
        notifySql.append("WHERE FBillStatus!=");
        notifySql.append(49);
        notifySql.append(" AND FBillStatus!=");
        notifySql.append(60);
        notifySql.append(" AND FSourceBillId in (");
        notifySql.append(this.listToString(workOrderList));
        notifySql.append(")");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)notifySql.toString());
            if (null != rows) {
                while (rows.next()) {
                    if (rows.getString("FId") == null) continue;
                    notifyBills.add(new Object[]{rows.getString("FId")});
                    ids.add(rows.getString("FId"));
                    numbers.add(rows.getString("FNumber"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (notifyBills.size() > 0) {
            String updateNotifySQL = "update T_EQM_MaintainNotify set FBillStatus =" + billStatus + " where FID=?";
            DbUtil.executeBatch((Context)ctx, (String)updateNotifySQL, notifyBills);
            String logItem = "eqm_maintainpickingnotify_forceclose";
            if (billStatus == 49) {
                logItem = "eqm_maintainpickingnotify_close";
            }
            for (int i = 0; i < ids.size(); ++i) {
                this.writeLog(ctx, logItem, new BOSObjectType("65A92E72"), ids.get(i).toString(), numbers.get(i).toString());
            }
        }
        ArrayList<Object[]> returnNotifyBills = new ArrayList<Object[]>();
        ids.clear();
        numbers.clear();
        StringBuffer returnNotifySql = new StringBuffer();
        returnNotifySql.append(" SELECT  FId,FNumber ");
        returnNotifySql.append(" FROM T_EQM_MaintainReturNotify ");
        returnNotifySql.append("WHERE FBillStatus!=");
        returnNotifySql.append(49);
        returnNotifySql.append(" AND FBillStatus!=");
        returnNotifySql.append(60);
        returnNotifySql.append(" AND FSourceBillId in (");
        returnNotifySql.append(this.listToString(workOrderList));
        returnNotifySql.append(")");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)returnNotifySql.toString());
            if (null != rows) {
                while (rows.next()) {
                    if (rows.getString("FId") == null) continue;
                    returnNotifyBills.add(new Object[]{rows.getString("FId")});
                    ids.add(rows.getString("FId"));
                    numbers.add(rows.getString("FNumber"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (returnNotifyBills.size() > 0) {
            String updateReturnNotifySQL = "update T_EQM_MaintainReturNotify set FBillStatus =" + billStatus + " where FID=?";
            DbUtil.executeBatch((Context)ctx, (String)updateReturnNotifySQL, returnNotifyBills);
            String logItem = "eqm_maintainreturningnotify_forceclose";
            if (billStatus == 49) {
                logItem = "eqm_maintainreturningnotify_close";
            }
            for (int i = 0; i < ids.size(); ++i) {
                this.writeLog(ctx, logItem, new BOSObjectType("97082992"), ids.get(i).toString(), numbers.get(i).toString());
            }
        }
    }

    private String listToString(List list) {
        if (null == list) {
            return "";
        }
        if (list.size() == 0) {
            return "";
        }
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof String)) continue;
            ids.append("'").append((String)list.get(i)).append("',");
        }
        ids.deleteCharAt(ids.length() - 1);
        return ids.toString();
    }

    @Override
    protected List changeSubWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        Object[] newObjectList;
        Object[] objectList;
        int i;
        String sql = "SELECT T0.FID,T0.FNUMBER,T0.FTaskType, T0.FPARENTID, FBILLSTATUS, FSTATUSEXTEND FROM T_EQM_WORKORDER T0 WHERE T0.FSUPERPARENTID = ? ";
        this.workOrderTree = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{workOrderInfo.getSuperParent().getId().toString()});
        this.updateList = this.controllerBean.updateStatusRecursive(ctx, workOrderInfo.getId().toString(), this.workOrderTree, workOrderInfo.getBillStatus());
        if (this.updateList.size() <= 0) {
            return this.updateList;
        }
        ArrayList<Object[]> tmpUpdateList = new ArrayList<Object[]>(this.updateList.size());
        for (int i2 = 0; i2 < this.updateList.size(); ++i2) {
            Object[] objectList2 = (Object[])this.updateList.get(i2);
            Object[] newObjectList2 = new Object[]{objectList2[0], objectList2[1]};
            tmpUpdateList.add(newObjectList2);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FBILLSTATUS= ?  WHERE FID = ?", tmpUpdateList);
        ArrayList<Object[]> newUpdateList = new ArrayList<Object[]>(this.updateList.size());
        for (i = 0; i < this.updateList.size(); ++i) {
            objectList = (Object[])this.updateList.get(i);
            newObjectList = new Object[]{workOrderInfo.getClosePerson() == null ? null : workOrderInfo.getClosePerson().getId().toString(), objectList[1]};
            newUpdateList.add(newObjectList);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FCloseUserID =? WHERE FID = ? AND (FCloseUserID is NULL)", newUpdateList);
        newUpdateList = new ArrayList(this.updateList.size());
        for (i = 0; i < this.updateList.size(); ++i) {
            objectList = (Object[])this.updateList.get(i);
            newObjectList = new Object[]{new Timestamp(workOrderInfo.getCloseDate().getTime()), objectList[1]};
            newUpdateList.add(newObjectList);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FCloseDate =?  WHERE FID = ? AND (FCloseDate IS NULL)", newUpdateList);
        return this.updateList;
    }

    @Override
    protected void changeWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        String ID = workOrderInfo.getId().toString();
        workOrderInfo.setBillStatus(this.status);
        String sql = "update T_EQM_WORKORDER set FBillStatus =?,FCloseUserID =?,FCloseDate =?,FRealEndTime=? where FID =?";
        EQMDBUtilForDB2.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(this.status.getValue()), workOrderInfo.getClosePerson() == null ? null : workOrderInfo.getClosePerson().getId().toString(), new Timestamp(workOrderInfo.getCloseDate().getTime()), new Timestamp(workOrderInfo.getRealEndTime().getTime()), ID});
    }

    @Override
    protected void prepareData(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        Date realEndTime;
        Date closeDate = workOrderInfo.getCloseDate();
        if (closeDate == null) {
            closeDate = GeneDateUtils.now();
            workOrderInfo.setCloseDate(closeDate);
        }
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (workOrderInfo.getClosePerson() == null) {
            try {
                if (this.isHROrgPerson(ctx, person, workOrderInfo.getMaintainOrgUnit())) {
                    workOrderInfo.setClosePerson(person);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((realEndTime = workOrderInfo.getRealEndTime()) == null) {
            realEndTime = GeneDateUtils.now();
            workOrderInfo.setRealEndTime(realEndTime);
        }
    }

    @Override
    protected void verify(Context ctx, WorkOrderInfo workOrderInfo) throws EASBizException, BOSException {
        if (workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.CLOSED) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceClosed)) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_CLOSE, new Object[]{workOrderInfo.getNumber()});
        }
        if (workOrderInfo.getRealStartTime() == null) {
            throw new WorkOrderException(WorkOrderException.REALSTARTTIME_CANNOT_NULL, new Object[]{workOrderInfo.getNumber().length() == 15 ? workOrderInfo.getNumber() + " " : workOrderInfo.getNumber()});
        }
        if (workOrderInfo.getRealEndTime() == null) {
            throw new WorkOrderException(WorkOrderException.REALENDTIME_CANNOT_NULL, new Object[]{workOrderInfo.getNumber().length() == 15 ? workOrderInfo.getNumber() + " " : workOrderInfo.getNumber()});
        }
        WorkOrderPermitVerifyItem workOrderstatus = new WorkOrderPermitVerifyItem(ctx, workOrderInfo, new GeneBillBaseStatusEnum[]{GeneBillBaseStatusEnum.Sign, GeneBillBaseStatusEnum.ForceClosed, GeneBillBaseStatusEnum.Recycle}, GeneBillBaseStatusEnum.CLOSED);
        workOrderstatus.verify();
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new WorkOrderCloseVerifyItem(ctx, (GeneBillBaseInfo)workOrderInfo, true));
        verifyManager.verify();
    }

    @Override
    protected Object getLogItem() {
        return "eqm_maintain_workorder_closed";
    }

    protected void writeLog(Context ctx, String logItem, BOSObjectType bosType, String id, String number) throws BOSException {
        if (logItem == null || "".equals(logItem)) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)bosType);
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", new Boolean(true));
        hashLog.put("FEntityID", bosType.toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "close");
        hashLog.put("FInstanceID", id);
        hashLog.put("FInstanceNo", number);
        hashLog.put("FItemName", logItem);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    protected boolean isHROrgPerson(Context ctx, PersonInfo person, StorageOrgUnitInfo storageOrgUnit) throws Exception {
        boolean isHROrgPerson = false;
        PositionMemberInfo positionMember = null;
        PositionMemberCollection positionMembers = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(this.getPositionMemberView(person.getId().toString()));
        for (int i = 0; i < positionMembers.size(); ++i) {
            positionMember = positionMembers.get(i);
        }
        IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ioc = iour.getToUnit(storageOrgUnit.getId().toString(), 4, 0);
        for (int index = 0; index < ioc.size(); ++index) {
            if (positionMember == null || positionMember.getPosition() == null || !ioc.get(index).getId().toString().equals(positionMember.getPosition().getAdminOrgUnit().getId().toString())) continue;
            isHROrgPerson = true;
            break;
        }
        return isHROrgPerson;
    }

    protected EntityViewInfo getPositionMemberView(String PersonID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)PersonID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        view.setSelector(sic);
        return view;
    }
}

