/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.maintain.WorkOrderCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.StatusChangeAction;
import com.kingdee.eas.eqm.maintain.app.action.WorkOrderPermitVerifyItem;
import com.kingdee.eas.eqm.maintain.app.verify.WorkOrderSubmitVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class FinishAction
extends StatusChangeAction {
    public FinishAction(WorkOrderControllerBean controllerBean) {
        super(controllerBean);
        this.status = GeneBillBaseStatusEnum.Finish;
    }

    @Override
    protected List changeSubWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        return this.controllerBean.updateStatus(ctx, workOrderInfo);
    }

    @Override
    protected void changeWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        BigDecimal duration = workOrderInfo.getDuration();
        BigDecimal sum = new BigDecimal("0.00");
        BigDecimal leftTime = new BigDecimal("0.00");
        if (duration != null) {
            this.controllerBean.loadSubOrderAndTask(ctx, workOrderInfo);
            WorkOrderCollection tasks = workOrderInfo.getTaskEntry();
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                WorkOrderInfo task = (WorkOrderInfo)it.next();
                BigDecimal taskDuration = task.getDuration();
                sum = sum.add(taskDuration);
            }
            leftTime = duration.subtract(sum);
        }
        workOrderInfo.setBillStatus(this.status);
        String sql = "update T_EQM_WORKORDER set FBillStatus =? ,FFremain=? where FID =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(this.status.getValue()), leftTime, workOrderInfo.getId().toString()});
    }

    @Override
    protected void prepareData(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void verify(Context ctx, WorkOrderInfo workOrderInfo) throws EASBizException, BOSException {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new WorkOrderSubmitVerifyItem(ctx, (GeneBillBaseInfo)workOrderInfo, true));
        verifyManager.verify();
        if (!(workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Release) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.StartWork))) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_FINISH, new Object[]{workOrderInfo.getNumber()});
        }
        WorkOrderPermitVerifyItem workOrderstatus = new WorkOrderPermitVerifyItem(ctx, workOrderInfo, new GeneBillBaseStatusEnum[]{GeneBillBaseStatusEnum.Sign, GeneBillBaseStatusEnum.ForceClosed, GeneBillBaseStatusEnum.Recycle}, GeneBillBaseStatusEnum.Finish);
        workOrderstatus.verify();
    }

    @Override
    protected Object getLogItem() {
        return "eqm_maintain_workorder_finish";
    }
}

