/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.ClosedAction;
import com.kingdee.eas.eqm.security.WorkPermitFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ForceClosedAction
extends ClosedAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.maintain.app.action.ForceClosedAction");
    private IRowSet workOrderTree = null;
    private List updateList = null;

    public ForceClosedAction(WorkOrderControllerBean controllerBean) {
        super(controllerBean);
        this.status = GeneBillBaseStatusEnum.ForceClosed;
    }

    @Override
    public void execute(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkOrderInfo workOrderInfo = (WorkOrderInfo)model;
        this.verify(ctx, workOrderInfo);
        this.prepareData(ctx, workOrderInfo);
        this.changeWorkOrderState(ctx, workOrderInfo);
        this.changeSubWorkOrderState(ctx, workOrderInfo);
        this.handleTaskReq(ctx, workOrderInfo);
        this.handleOutWarehs(ctx, workOrderInfo.getId().toString(), this.updateList, 60);
    }

    private void handleTaskReq(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        String sql = "SELECT DISTINCT T0.FID,T0.FNumber FROM T_EQM_TASKREQ T0 INNER JOIN T_EQM_FAULTREPORTENTRY T1 ON T0.FID=T1.FTASKREQID WHERE T1.FPARENTID IN (?) AND T0.FBillStatus <> 49 AND T0.FBillStatus <> 60";
        IRowSet taskReqs = WorkOrderControllerBean.batchSelectByID(ctx, sql, this.workOrderTree, 100);
        if (taskReqs.size() <= 0) {
            return;
        }
        sql = "SELECT T0.FID,COUNT(*) AS COUNT FROM T_EQM_TASKREQ T0 INNER JOIN T_EQM_FAULTREPORTENTRY T1 ON T0.FID=T1.FTASKREQID INNER JOIN T_EQM_WORKORDER T2 ON T2.FID=T1.FPARENTID WHERE T0.FID IN (?) AND T0.FBILLSTATUS IN (10,20,30,40,70) AND T2.FBILLSTATUS IN (10,20,30,40,45,46,48) GROUP BY T0.FID";
        IRowSet notClosedtaskReqs = WorkOrderControllerBean.batchSelectByID(ctx, sql, taskReqs, 100);
        ArrayList<Object[]> toCloseList = new ArrayList<Object[]>();
        try {
            for (int i = 0; i < taskReqs.size(); ++i) {
                taskReqs.absolute(i + 1);
                boolean isNeedClose = true;
                for (int j = 0; j < notClosedtaskReqs.size(); ++j) {
                    notClosedtaskReqs.absolute(j + 1);
                    if (!taskReqs.getString("FID").equals(notClosedtaskReqs.getString("FID"))) continue;
                    isNeedClose = false;
                    break;
                }
                if (!isNeedClose) continue;
                toCloseList.add(new Object[]{new Integer(60), new Timestamp(workOrderInfo.getCloseDate().getTime()), taskReqs.getString("FID")});
                this.writeLog(ctx, "eqm_maintain_taskreq_forceclosed", new BOSObjectType("1A2F30DB"), taskReqs.getString("FID"), taskReqs.getString("FNumber"));
            }
        }
        catch (Exception e) {
            throw new BOSException("Sql execute exception : ", (Throwable)e);
        }
        sql = "UPDATE T_EQM_TASKREQ SET FBILLSTATUS = ?,FCloseDate=? WHERE FID = ?";
        DbUtil.executeBatch((Context)ctx, (String)sql, toCloseList);
    }

    private void handleOutWarehs(Context ctx, String workOrderID, List updateList, int billStatus) throws BOSException, EASBizException {
        Boolean deleteRalateOutWarehs = (Boolean)ctx.get((Object)"DELETE_RELATE_OUTWAREHS");
        ArrayList<Object> workOrderList = new ArrayList<Object>();
        for (Object[] objectList : updateList) {
            workOrderList.add(objectList[1]);
        }
        workOrderList.add(workOrderID);
        if (deleteRalateOutWarehs != null && deleteRalateOutWarehs.booleanValue()) {
            this.handleAfterWorkorderColse(ctx, workOrderID, workOrderList, 60);
        }
        this.forceCloseNotifyBill(ctx, 60, workOrderList);
    }

    @Override
    protected List changeSubWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        Object[] newObjectList;
        Object[] objectList;
        int i;
        String sql = "SELECT T0.FID, T0.FNUMBER,T0.FTaskType,T0.FPARENTID, FBILLSTATUS, FSTATUSEXTEND FROM T_EQM_WORKORDER T0 WHERE T0.FSUPERPARENTID = ? ";
        this.workOrderTree = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{workOrderInfo.getSuperParent().getId().toString()});
        this.updateList = this.controllerBean.updateStatusRecursive(ctx, workOrderInfo.getId().toString(), this.workOrderTree, workOrderInfo.getBillStatus());
        if (this.updateList.size() <= 0) {
            return this.updateList;
        }
        ArrayList<Object[]> tmpUpdateList = new ArrayList<Object[]>(this.updateList.size());
        for (int i2 = 0; i2 < this.updateList.size(); ++i2) {
            Object[] objectList2 = (Object[])this.updateList.get(i2);
            Object[] newObjectList2 = new Object[]{objectList2[0], objectList2[1]};
            tmpUpdateList.add(newObjectList2);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FBILLSTATUS= ?  WHERE FID = ?", tmpUpdateList);
        ArrayList<Object[]> newUpdateList = new ArrayList<Object[]>(this.updateList.size());
        for (i = 0; i < this.updateList.size(); ++i) {
            objectList = (Object[])this.updateList.get(i);
            newObjectList = new Object[]{workOrderInfo.getClosePerson() == null ? null : workOrderInfo.getClosePerson().getId().toString(), objectList[1]};
            newUpdateList.add(newObjectList);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FCloseUserID =? WHERE FID = ? AND (FCloseUserID IS NULL)", newUpdateList);
        newUpdateList = new ArrayList(this.updateList.size());
        for (i = 0; i < this.updateList.size(); ++i) {
            objectList = (Object[])this.updateList.get(i);
            newObjectList = new Object[]{new Timestamp(workOrderInfo.getCloseDate().getTime()), objectList[1]};
            newUpdateList.add(newObjectList);
            this.closeWorkPermit(ctx, (String)objectList[1]);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FCloseDate =?  WHERE FID = ? AND (FCloseDate IS NULL)", newUpdateList);
        return this.updateList;
    }

    @Override
    protected void changeWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        String ID = workOrderInfo.getId().toString();
        workOrderInfo.setBillStatus(this.status);
        String sql = "update T_EQM_WORKORDER set FBillStatus =?,FCloseUserID =?,FCloseDate =? where FID =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(this.status.getValue()), workOrderInfo.getClosePerson() == null ? null : workOrderInfo.getClosePerson().getId().toString(), new Timestamp(workOrderInfo.getCloseDate().getTime()), ID});
        this.closeWorkPermit(ctx, ID);
    }

    protected void closeWorkPermit(Context ctx, String workorderid) throws BOSException, EASBizException {
        if (workorderid == null || workorderid.length() <= 0) {
            return;
        }
        String sql = "Select FID From T_EQM_WorkPermit  Where FWorkOrderID = '" + workorderid + "' AND FBillStatus<>" + 60 + " AND FBillStatus <> " + 32;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String fid = rs.getString("FID");
                WorkPermitFactory.getLocalInstance((Context)ctx).forceClosed((IObjectPK)new ObjectUuidPK(fid));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }

    @Override
    protected void prepareData(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        Date realEndTime;
        Date closeDate = workOrderInfo.getCloseDate();
        if (closeDate == null) {
            closeDate = GeneDateUtils.now();
            workOrderInfo.setCloseDate(closeDate);
        }
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (workOrderInfo.getClosePerson() == null) {
            try {
                if (this.isHROrgPerson(ctx, person, workOrderInfo.getMaintainOrgUnit())) {
                    workOrderInfo.setClosePerson(person);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((realEndTime = workOrderInfo.getRealEndTime()) == null) {
            realEndTime = GeneDateUtils.now();
            workOrderInfo.setRealEndTime(realEndTime);
        }
    }

    @Override
    protected void verify(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        if (workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.CLOSED) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceClosed) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Finish) || workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Check)) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_FORCECLOSE, new Object[]{workOrderInfo.getNumber()});
        }
    }

    @Override
    protected Object getLogItem() {
        return "eqm_maintain_workorder_forceclosed";
    }

    @Override
    protected boolean isHROrgPerson(Context ctx, PersonInfo person, StorageOrgUnitInfo storageOrgUnit) throws Exception {
        boolean isHROrgPerson = false;
        PositionMemberInfo positionMember = null;
        PositionMemberCollection positionMembers = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(this.getPositionMemberView(person.getId().toString()));
        for (int i = 0; i < positionMembers.size(); ++i) {
            positionMember = positionMembers.get(i);
        }
        IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ioc = iour.getToUnit(storageOrgUnit.getId().toString(), 4, 0);
        for (int index = 0; index < ioc.size(); ++index) {
            if (positionMember == null || positionMember.getPosition() == null || !ioc.get(index).getId().toString().equals(positionMember.getPosition().getAdminOrgUnit().getId().toString())) continue;
            isHROrgPerson = true;
            break;
        }
        return isHROrgPerson;
    }

    @Override
    protected EntityViewInfo getPositionMemberView(String PersonID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)PersonID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        view.setSelector(sic);
        return view;
    }
}

