/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.common.eqmcore.app.util.EQMDBUtilForDB2;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.StatusChangeAction;
import com.kingdee.eas.eqm.maintain.app.verify.WorkOrderSubmitVerifyItem;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ReleaseAction
extends StatusChangeAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.maintain.app.action.ReleaseAction");
    GeneBillBaseStatusEnum oldStatus = null;

    public ReleaseAction(WorkOrderControllerBean controllerBean) {
        super(controllerBean);
        this.status = GeneBillBaseStatusEnum.Release;
    }

    @Override
    protected List changeSubWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        if (this.oldStatus.equals((Object)GeneBillBaseStatusEnum.Finish)) {
            return this.updateStatusForRelease(ctx, workOrderInfo);
        }
        if (this.oldStatus.equals((Object)GeneBillBaseStatusEnum.Audit)) {
            Object[] newObjectList;
            Object[] objectList;
            int i;
            String sql = "SELECT T0.FID,T0.FNUMBER, T0.FTaskType,T0.FPARENTID, FBILLSTATUS, FSTATUSEXTEND FROM T_EQM_WORKORDER T0 WHERE T0.FSUPERPARENTID = ? ";
            IRowSet workOrderTree = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{workOrderInfo.getSuperParent().getId().toString()});
            List updateList = this.controllerBean.updateStatusRecursive(ctx, workOrderInfo.getId().toString(), workOrderTree, workOrderInfo.getBillStatus());
            if (updateList.size() <= 0) {
                return updateList;
            }
            ArrayList<Object[]> tmpUpdateList = new ArrayList<Object[]>(updateList.size());
            for (int i2 = 0; i2 < updateList.size(); ++i2) {
                Object[] objectList2 = (Object[])updateList.get(i2);
                Object[] newObjectList2 = new Object[]{objectList2[0], objectList2[1]};
                tmpUpdateList.add(newObjectList2);
            }
            DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FBILLSTATUS= ?  WHERE FID = ?", tmpUpdateList);
            ArrayList<Object[]> newUpdateList = new ArrayList<Object[]>(updateList.size());
            for (i = 0; i < updateList.size(); ++i) {
                objectList = (Object[])updateList.get(i);
                newObjectList = new Object[]{workOrderInfo.getReleasePerson() == null ? null : workOrderInfo.getReleasePerson().getId().toString(), objectList[1]};
                newUpdateList.add(newObjectList);
            }
            DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FReleaseUserEntityID =? WHERE FID = ? AND (FReleaseUserEntityID IS NULL)", newUpdateList);
            newUpdateList = new ArrayList(updateList.size());
            for (i = 0; i < updateList.size(); ++i) {
                objectList = (Object[])updateList.get(i);
                newObjectList = new Object[]{new Timestamp(workOrderInfo.getReleaseTime().getTime()), objectList[1]};
                newUpdateList.add(newObjectList);
            }
            DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FReleaseTime =?  WHERE FID = ? AND (FReleaseTime IS NULL)", newUpdateList);
            return updateList;
        }
        return null;
    }

    @Override
    protected void changeWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        workOrderInfo.setBillStatus(this.status);
        String sql = "update T_EQM_WORKORDER set FBillStatus =?,FReleaseTime=?,FReleaseUserEntityID=? where FID =?";
        EQMDBUtilForDB2.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(this.status.getValue()), workOrderInfo.getReleaseTime(), workOrderInfo.getReleasePerson() == null ? null : workOrderInfo.getReleasePerson().getId().toString(), workOrderInfo.getId().toString()});
        this.updateWorkPermitStatus(ctx, workOrderInfo.getId().toString());
    }

    @Override
    protected void prepareData(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        String desc;
        this.oldStatus = workOrderInfo.getBillStatus();
        Timestamp releaseTime = workOrderInfo.getReleaseTime();
        if (releaseTime == null) {
            workOrderInfo.setReleaseTime(GeneDateUtils.nowTime());
        }
        if ((desc = workOrderInfo.getDescription()) == null) {
            desc = "";
            workOrderInfo.setDescription(desc);
        }
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (workOrderInfo.getReleasePerson() == null) {
            try {
                if (this.isHROrgPerson(ctx, person, workOrderInfo.getMaintainOrgUnit())) {
                    workOrderInfo.setReleasePerson(person);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void verify(Context ctx, WorkOrderInfo workOrderInfo) throws EASBizException, BOSException {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new WorkOrderSubmitVerifyItem(ctx, (GeneBillBaseInfo)workOrderInfo, true));
        verifyManager.verify();
        if (!workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit) && !workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Finish)) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_RELEASE, new Object[]{workOrderInfo.getNumber()});
        }
        if (workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Finish) && !workOrderInfo.isRequireCheck()) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_CHECK_RELEASE, new Object[]{workOrderInfo.getNumber()});
        }
    }

    private List updateStatusForRelease(Context ctx, WorkOrderInfo model) throws BOSException, EASBizException {
        Object[] newObjectList;
        Object[] objectList;
        int i;
        String sql = "SELECT T0.FID,T0.FNUMBER,T0.FTaskType, T0.FPARENTID, FBILLSTATUS, FSTATUSEXTEND FROM T_EQM_WORKORDER T0 WHERE T0.FSUPERPARENTID = ? ";
        IRowSet workOrderTree = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{model.getSuperParent().getId().toString()});
        List updateList = this.updateStatusRecursiveForRelease(ctx, model.getId().toString(), workOrderTree, model.getBillStatus());
        String upadteString = "UPDATE T_EQM_WORKORDER SET FBILLSTATUS= ?, FEFFECTEDSTATUS =2 WHERE FID = ?";
        if (updateList.size() > 0) {
            ArrayList<Object[]> otherUpdateList = new ArrayList<Object[]>(updateList.size());
            for (i = 0; i < updateList.size(); ++i) {
                objectList = (Object[])updateList.get(i);
                newObjectList = new Object[]{objectList[0], objectList[1]};
                otherUpdateList.add(newObjectList);
            }
            DbUtil.executeBatch((Context)ctx, (String)upadteString, otherUpdateList);
        }
        upadteString = "UPDATE T_EQM_WORKORDER SET FReleaseUserEntityID=? WHERE FID = ? AND (FReleaseUserEntityID IS NULL) ";
        ArrayList<Object[]> newUpdateList = new ArrayList<Object[]>(updateList.size());
        for (i = 0; i < updateList.size(); ++i) {
            objectList = (Object[])updateList.get(i);
            newObjectList = new Object[]{model.getReleasePerson() == null ? null : model.getReleasePerson().getId().toString(), objectList[1]};
            newUpdateList.add(newObjectList);
        }
        if (updateList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)upadteString, newUpdateList);
        }
        upadteString = "UPDATE T_EQM_WORKORDER SET FReleaseTime=? WHERE FID = ? AND (FReleaseTime IS NULL) ";
        newUpdateList = new ArrayList(updateList.size());
        for (i = 0; i < updateList.size(); ++i) {
            objectList = (Object[])updateList.get(i);
            newObjectList = new Object[]{model.getReleaseTime(), objectList[1]};
            newUpdateList.add(newObjectList);
        }
        if (updateList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)upadteString, newUpdateList);
        }
        return updateList;
    }

    private List updateStatusRecursiveForRelease(Context ctx, String workOrderID, IRowSet workOrderTree, GeneBillBaseStatusEnum status) throws BOSException, EASBizException {
        try {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>();
            String parentID = workOrderID;
            int parentStatus = status.getValue();
            for (int i = 0; i < workOrderTree.size(); ++i) {
                workOrderTree.absolute(i + 1);
                String subWorkOrderID = workOrderTree.getString("FID");
                String subWorkOrderNumber = workOrderTree.getString("FNUMBER");
                int taskType = workOrderTree.getInt("FTaskType");
                String subWorkOrderParentID = workOrderTree.getString("FPARENTID");
                int subWorkOrderStatus = workOrderTree.getInt("FBILLSTATUS");
                int subWorkOrderStatusExtend = workOrderTree.getInt("FSTATUSEXTEND");
                if (!parentID.equals(subWorkOrderParentID) || subWorkOrderStatusExtend != 1) continue;
                this.updateWorkPermitStatus(ctx, subWorkOrderID);
                if (subWorkOrderStatus == parentStatus || parentStatus == 45 && (subWorkOrderStatus == 48 || subWorkOrderStatus == 49 || subWorkOrderStatus == 60)) continue;
                updateList.add(new Object[]{new Integer(parentStatus), subWorkOrderID, subWorkOrderNumber, new Integer(taskType)});
                updateList.addAll(this.updateStatusRecursiveForRelease(ctx, subWorkOrderID, workOrderTree, status));
            }
            return updateList;
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : ", (Throwable)e);
        }
    }

    private void updateWorkPermitStatus(Context ctx, String workorderid) throws EASBizException, BOSException {
        if (GeneCommonUtils.isEmpty((String)workorderid)) {
            return;
        }
        String sql = "UPDATE T_EQM_WorkPermit SET FIsStrictControl= 0  WHERE FBillStatus = 32 and FIsStrictControl=1 and FWorkOrderID = '" + workorderid + "'";
        GeneDbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected Object getLogItem() {
        return "eqm_maintain_workorder_release";
    }

    protected boolean isHROrgPerson(Context ctx, PersonInfo person, StorageOrgUnitInfo storageOrgUnit) throws Exception {
        boolean isHROrgPerson = false;
        PositionMemberInfo positionMember = null;
        PositionMemberCollection positionMembers = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(this.getPositionMemberView(person.getId().toString()));
        for (int i = 0; i < positionMembers.size(); ++i) {
            positionMember = positionMembers.get(i);
        }
        IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ioc = iour.getToUnit(storageOrgUnit.getId().toString(), 4, 0);
        for (int index = 0; index < ioc.size(); ++index) {
            if (positionMember == null || positionMember.getPosition() == null || !ioc.get(index).getId().toString().equals(positionMember.getPosition().getAdminOrgUnit().getId().toString())) continue;
            isHROrgPerson = true;
            break;
        }
        return isHROrgPerson;
    }

    protected EntityViewInfo getPositionMemberView(String PersonID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)PersonID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        view.setSelector(sic);
        return view;
    }
}

