/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.Action;
import com.kingdee.eas.eqm.maintain.app.action.StatusChangeAction;
import com.kingdee.eas.eqm.maintain.app.action.WorkOrderPermitVerifyItem;
import com.kingdee.eas.eqm.maintain.app.verify.WorkOrderSubmitVerifyItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;

public class StartWorkAction
extends StatusChangeAction
implements Action {
    public StartWorkAction(WorkOrderControllerBean controllerBean) {
        super(controllerBean);
        this.status = GeneBillBaseStatusEnum.StartWork;
    }

    @Override
    protected List changeSubWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException, EASBizException {
        String sql = "SELECT T0.FID, T0.FNUMBER,T0.FTaskType,T0.FPARENTID, FBILLSTATUS, FSTATUSEXTEND FROM T_EQM_WORKORDER T0 WHERE T0.FSUPERPARENTID = ? ";
        IRowSet workOrderTree = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{workOrderInfo.getSuperParent().getId().toString()});
        List updateList = this.controllerBean.updateStatusRecursive(ctx, workOrderInfo.getId().toString(), workOrderTree, GeneBillBaseStatusEnum.StartWork);
        if (updateList.size() <= 0) {
            return updateList;
        }
        ArrayList<Object[]> tmpUpdateList = new ArrayList<Object[]>(updateList.size());
        for (int i = 0; i < updateList.size(); ++i) {
            Object[] objectList = (Object[])updateList.get(i);
            Object[] newObjectList = new Object[]{objectList[0], objectList[1]};
            tmpUpdateList.add(newObjectList);
        }
        DbUtil.executeBatch((Context)ctx, (String)"UPDATE T_EQM_WORKORDER SET FBILLSTATUS= ?  WHERE FID = ?", tmpUpdateList);
        return updateList;
    }

    @Override
    protected void changeWorkOrderState(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException {
        workOrderInfo.setBillStatus(this.status);
        String sql = "update T_EQM_WORKORDER set FBillStatus =? where FID =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(this.status.getValue()), workOrderInfo.getId().toString()});
    }

    @Override
    protected void prepareData(Context ctx, WorkOrderInfo workOrderInfo) throws BOSException {
    }

    @Override
    protected void verify(Context ctx, WorkOrderInfo workOrderInfo) throws EASBizException, BOSException {
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new WorkOrderSubmitVerifyItem(ctx, (GeneBillBaseInfo)workOrderInfo, true));
        verifyManager.verify();
        if (!workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Release) && !workOrderInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) {
            throw new WorkOrderException(WorkOrderException.STATUS_ERROR_STARTWORK, new Object[]{workOrderInfo.getNumber()});
        }
        WorkOrderPermitVerifyItem workOrderstatus = new WorkOrderPermitVerifyItem(ctx, workOrderInfo, new GeneBillBaseStatusEnum[]{GeneBillBaseStatusEnum.Sign, GeneBillBaseStatusEnum.ForceClosed}, GeneBillBaseStatusEnum.StartWork);
        workOrderstatus.verify();
    }

    @Override
    protected Object getLogItem() {
        return "eqm_maintain_workorder_startWork";
    }
}

