/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.WorkOrderControllerBean;
import com.kingdee.eas.eqm.maintain.app.action.Action;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class StatusChangeAction
implements Action {
    protected GeneBillBaseStatusEnum status = null;
    protected WorkOrderControllerBean controllerBean = null;

    public StatusChangeAction(WorkOrderControllerBean controllerBean) {
        this.controllerBean = controllerBean;
    }

    protected BOSObjectType getBOSType() {
        return new BOSObjectType("81396A3F");
    }

    @Override
    public void execute(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkOrderInfo workOrderInfo = (WorkOrderInfo)model;
        this.verify(ctx, workOrderInfo);
        this.prepareData(ctx, workOrderInfo);
        this.changeWorkOrderState(ctx, workOrderInfo);
        List updateList = this.changeSubWorkOrderState(ctx, workOrderInfo);
        this.writeLog(ctx, updateList);
    }

    protected abstract void verify(Context var1, WorkOrderInfo var2) throws EASBizException, BOSException;

    protected abstract void prepareData(Context var1, WorkOrderInfo var2) throws EASBizException, BOSException;

    protected abstract void changeWorkOrderState(Context var1, WorkOrderInfo var2) throws EASBizException, BOSException;

    protected abstract List changeSubWorkOrderState(Context var1, WorkOrderInfo var2) throws BOSException, EASBizException;

    protected abstract Object getLogItem();

    private void writeLog(Context ctx, List updateList) throws BOSException {
        if (updateList == null || updateList.size() <= 0) {
            return;
        }
        ArrayList<WorkOrderInfo> workOrderList = new ArrayList<WorkOrderInfo>();
        Iterator it = updateList.iterator();
        WorkOrderInfo subWorkOrderInfo = null;
        while (it.hasNext()) {
            Object[] objectList = (Object[])it.next();
            if (objectList[3] == null || !objectList[3].equals(new Integer(10))) continue;
            subWorkOrderInfo = new WorkOrderInfo();
            if (objectList[2] != null) {
                subWorkOrderInfo.setNumber(objectList[2].toString());
            }
            subWorkOrderInfo.setId(BOSUuid.read((String)objectList[1].toString()));
            workOrderList.add(subWorkOrderInfo);
        }
        if (this.getLogItem() == null || "".equals(this.getLogItem())) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        WorkOrderInfo workOrderInfo = null;
        for (int i = 0; i < workOrderList.size(); ++i) {
            HashMap<String, Object> hashLog = new HashMap<String, Object>();
            LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
            hashLog.put("isSuccessed", new Boolean(false));
            hashLog.put("successed", new Boolean(true));
            hashLog.put("FEntityID", this.getBOSType().toString());
            hashLog.put("FEntityName", entityObjectInfo.getName());
            hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FMethodName", "close");
            workOrderInfo = (WorkOrderInfo)workOrderList.get(i);
            hashLog.put("FInstanceID", workOrderInfo.getId().toString());
            hashLog.put("FInstanceNo", workOrderInfo.getLogInfo());
            hashLog.put("FItemName", this.getLogItem());
            hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
            appLog.writeLog(hashLog);
        }
    }
}

