/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.maintain.FaultReportEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderMaterialEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanMaterialEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanServiceEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanToolsEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderPlanUserEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderRealTaskEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderServiceEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderToolsEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderUserEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WorkOrderSubmitVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";
    private Context ctx = null;
    private GeneBillBaseInfo info;
    private boolean verifyChildren;

    public WorkOrderSubmitVerifyItem(Context ctx, GeneBillBaseInfo info, boolean verifyChildren) {
        this.ctx = ctx;
        this.info = info;
        this.verifyChildren = verifyChildren;
    }

    public boolean verify() throws EASBizException, BOSException {
        WorkOrderInfo woInfo = (WorkOrderInfo)this.info;
        if (!this.verifyChildren) {
            this.verifyInput(woInfo);
            return true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FPARENTID, FBILLSTATUS, FSTATUSEXTEND FROM T_EQM_WORKORDER WHERE FSUPERPARENTID = '").append(woInfo.getSuperParent().getId().toString()).append("'").append(" AND FFastReport=0 AND FTaskType=10");
        IRowSet workOrderTree = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[0]);
        List submitList = this.submitRecursive(this.ctx, woInfo.getId().toString(), workOrderTree, woInfo.getBillStatus());
        if (submitList.size() > 0) {
            for (int i = 0; i < submitList.size(); ++i) {
                Object[] objectList = (Object[])submitList.get(i);
                String childID = (String)objectList[1];
                WorkOrderInfo childInfo = WorkOrderFactory.getLocalInstance(this.ctx).getWorkOrderInfo((IObjectPK)new ObjectUuidPK(childID), this.getSelector());
                this.verifyInput(childInfo);
            }
        }
        return true;
    }

    public void verifyInput(WorkOrderInfo info) throws BOSException, EASBizException {
        int i;
        if (info == null) {
            return;
        }
        if (info.getEqmLocation() == null && info.getEquipmentArchives() == null) {
            throw new WorkOrderException(WorkOrderException.CANNOT_SUBMIT, new Object[]{info.getNumber(), GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"LOC_OR_EQM_REQUIRED", null)});
        }
        if (info.getName() == null) {
            throw new WorkOrderException(WorkOrderException.NAME_CANNOT_NULL, new Object[]{info.getNumber()});
        }
        if (info.getPlanOrgunit() == null) {
            throw new WorkOrderException(WorkOrderException.PLANORG_CANNOT_NULL, new Object[]{info.getNumber()});
        }
        if (info.getMainOrgUnit() == null) {
            throw new WorkOrderException(WorkOrderException.MAINTAINORG_CANNOT_NULL, new Object[]{info.getNumber()});
        }
        if (info.getWorkOrderModel() == null) {
            throw new WorkOrderException(WorkOrderException.WOMODEL_CANNOT_NULL, new Object[]{info.getNumber()});
        }
        if (info.getPlanStartTime() == null) {
            throw new WorkOrderException(WorkOrderException.PLANSTARTTIME_CANNOT_NULL, new Object[]{info.getNumber()});
        }
        if (info.getPlanEndTime() == null) {
            throw new WorkOrderException(WorkOrderException.PLANENDTIME_CANNOT_NULL, new Object[]{info.getNumber()});
        }
        this.validateDateRange(info.getPowerOffStartTime(), info.getPowerOffEndTime(), info, "POWEROFFTIME_INVALID");
        this.validateDateRange(info.getPlanStartTime(), info.getPlanEndTime(), info, "PLANTIME_INVALID");
        this.validateDateRange(info.getRealStartTime(), info.getRealEndTime(), info, "REALTIME_INVALID");
        this.validateDateRange(info.getPlanPublishTime(), info.getPlanStartTime(), info, "PLANPUB_PLANTIME_INVALID");
        if (info.getTaskEntry() != null && info.getTaskEntry().size() > 0) {
            WorkOrderInfo planTask = null;
            for (i = 0; i < info.getTaskEntry().size(); ++i) {
                planTask = info.getTaskEntry().get(i);
                if (planTask == null) continue;
                if (planTask.getName() == null) {
                    throw new WorkOrderException(WorkOrderException.TASKNAME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                this.validateDateRange(planTask.getPlanStartTime(), planTask.getPlanEndTime(), info, "TASK_PLANTIME_INVALID");
            }
        }
        if (info.getPlanUserEntry() != null && info.getPlanUserEntry().size() > 0) {
            WorkOrderPlanUserEntryInfo planUser = null;
            for (i = 0; i < info.getPlanUserEntry().size(); ++i) {
                planUser = info.getPlanUserEntry().get(i);
                if (planUser == null) continue;
                if (planUser.getMaintainTeam() == null) {
                    throw new WorkOrderException(WorkOrderException.MAINTAINTEAM_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (planUser.getMaintainStaff() != null) continue;
                throw new WorkOrderException(WorkOrderException.MAINTAINSTAFF_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
        if (info.getPlanMaterialEntry() != null && info.getPlanMaterialEntry().size() > 0) {
            WorkOrderPlanMaterialEntryInfo planMaterial = null;
            for (i = 0; i < info.getPlanMaterialEntry().size(); ++i) {
                planMaterial = info.getPlanMaterialEntry().get(i);
                if (planMaterial == null) continue;
                if (planMaterial.getMaterial() == null) {
                    throw new WorkOrderException(WorkOrderException.MATERIAL_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (planMaterial.getAmount() == null) {
                    throw new WorkOrderException(WorkOrderException.MATERIALCOUNT_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (planMaterial.getMeasureunit() != null) continue;
                throw new WorkOrderException(WorkOrderException.MATERIALUNIT_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
        if (info.getPlanToolsEntry() != null && info.getPlanToolsEntry().size() > 0) {
            WorkOrderPlanToolsEntryInfo planTool = null;
            for (i = 0; i < info.getPlanToolsEntry().size(); ++i) {
                planTool = info.getPlanToolsEntry().get(i);
                if (planTool == null) continue;
                if (planTool.getTool() == null) {
                    throw new WorkOrderException(WorkOrderException.TOOL_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (planTool.getMeasureUnit() != null) continue;
                throw new WorkOrderException(WorkOrderException.TOOLUNIT_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
        if (info.getPlanServiceEntry() != null && info.getPlanServiceEntry().size() > 0) {
            WorkOrderPlanServiceEntryInfo planService = null;
            for (i = 0; i < info.getPlanServiceEntry().size(); ++i) {
                planService = info.getPlanServiceEntry().get(i);
                if (planService == null || planService.getName() != null) continue;
                throw new WorkOrderException(WorkOrderException.SERVICENAME_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
        if (info.getRealTaskEntry() != null && info.getRealTaskEntry().size() > 0) {
            WorkOrderRealTaskEntryInfo task = null;
            for (i = 0; i < info.getRealTaskEntry().size(); ++i) {
                task = info.getRealTaskEntry().get(i);
                if (task == null) continue;
                if (task.getDescribe() == null) {
                    throw new WorkOrderException(WorkOrderException.TASKNAME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (task.getStartTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALSTART_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (task.getEndTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALEND_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                this.validateDateRange(task.getStartTime(), task.getEndTime(), info, "TASK_REALTIME_INVALID");
            }
        }
        if (info.getUserEntry() != null && info.getUserEntry().size() > 0) {
            WorkOrderUserEntryInfo user = null;
            for (i = 0; i < info.getUserEntry().size(); ++i) {
                user = info.getUserEntry().get(i);
                if (user == null) continue;
                if (user.getMaintainStaff() == null) {
                    throw new WorkOrderException(WorkOrderException.MAINTAINSTAFF_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (user.getStartTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALUSERSTARTTIME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (user.getEndTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALUSERENDTIME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (user.getHours() == null) {
                    throw new WorkOrderException(WorkOrderException.REALUSERENDTIME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (user.getRecordUser() == null) {
                    throw new WorkOrderException(WorkOrderException.REALUSERRECUSER_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (user.getRecordTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALUSERRECTIME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                this.validateDateRange(user.getStartTime(), user.getEndTime(), info, "REALUSER_TIME_INVALID");
            }
        }
        if (info.getMaterialEntry() != null && info.getMaterialEntry().size() > 0) {
            WorkOrderMaterialEntryInfo material = null;
            for (i = 0; i < info.getMaterialEntry().size(); ++i) {
                material = info.getMaterialEntry().get(i);
                if (material == null) continue;
                if (material.getMaterial() == null) {
                    throw new WorkOrderException(WorkOrderException.MATERIAL_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (material.getMeasureunit() == null) {
                    throw new WorkOrderException(WorkOrderException.MATERIALUNIT_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (material.getPlanQty() == null) {
                    throw new WorkOrderException(WorkOrderException.REALMATERIALPLANQTY_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (material.getRealQty() == null) {
                    throw new WorkOrderException(WorkOrderException.REALMATERIALREALQTY_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (material.getRealCostQty() != null) continue;
                throw new WorkOrderException(WorkOrderException.RREALMATERIALREALCOST_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
        if (info.getToolsEntry() != null && info.getToolsEntry().size() > 0) {
            WorkOrderToolsEntryInfo tool = null;
            for (i = 0; i < info.getToolsEntry().size(); ++i) {
                tool = info.getToolsEntry().get(i);
                if (tool == null) continue;
                if (tool.getTool() == null) {
                    throw new WorkOrderException(WorkOrderException.TOOL_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (tool.getMeasureUnit() == null) {
                    throw new WorkOrderException(WorkOrderException.TOOLUNIT_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (tool.getAmount() == null) {
                    throw new WorkOrderException(WorkOrderException.REALTOOLAMOUNT_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (tool.getHours() != null) continue;
                throw new WorkOrderException(WorkOrderException.REALTOOLHOURS_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
        if (info.getServiceEntry() != null && info.getServiceEntry().size() > 0) {
            WorkOrderServiceEntryInfo service = null;
            for (i = 0; i < info.getServiceEntry().size(); ++i) {
                service = info.getServiceEntry().get(i);
                if (service == null) continue;
                if (service.getName() == null) {
                    throw new WorkOrderException(WorkOrderException.SERVICENAME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (service.getStartTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALSERSERVICESTARTTIME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (service.getEndTime() == null) {
                    throw new WorkOrderException(WorkOrderException.REALSERSERVICEENDTIME_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (service.getHours() == null) {
                    throw new WorkOrderException(WorkOrderException.REALSERSERVICEHOURS_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                this.validateDateRange(service.getStartTime(), service.getEndTime(), info, "REALSERVICE_TIME_INVALID");
            }
        }
        if (info.getFaultReportEntry() != null && info.getFaultReportEntry().size() > 0) {
            FaultReportEntryInfo fault = null;
            for (i = 0; i < info.getFaultReportEntry().size(); ++i) {
                fault = info.getFaultReportEntry().get(i);
                if (fault == null) continue;
                if (fault.getFaultSort() == null) {
                    throw new WorkOrderException(WorkOrderException.FAULTSORT_CANNOT_NULL, new Object[]{info.getNumber()});
                }
                if (fault.getFindDate() != null) continue;
                throw new WorkOrderException(WorkOrderException.FAULTFINDTIME_CANNOT_NULL, new Object[]{info.getNumber()});
            }
        }
    }

    private List submitRecursive(Context ctx, String workOrderID, IRowSet workOrderTree, GeneBillBaseStatusEnum status) throws BOSException, EASBizException {
        try {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>();
            String parentID = workOrderID;
            int parentStatus = status.getValue();
            for (int i = 0; i < workOrderTree.size(); ++i) {
                workOrderTree.absolute(i + 1);
                String subWorkOrderID = workOrderTree.getString("FID");
                String subWorkOrderParentID = workOrderTree.getString("FPARENTID");
                int subWorkOrderStatus = workOrderTree.getInt("FBILLSTATUS");
                int subWorkOrderStatusExtend = workOrderTree.getInt("FSTATUSEXTEND");
                if (!parentID.equals(subWorkOrderParentID) || subWorkOrderStatusExtend != 1 || subWorkOrderStatus > parentStatus) continue;
                updateList.add(new Object[]{new Integer(parentStatus), subWorkOrderID});
                updateList.addAll(this.submitRecursive(ctx, subWorkOrderID, workOrderTree, status));
            }
            return updateList;
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : ", (Throwable)e);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("planOrgUnit.id"));
        selector.add(new SelectorItemInfo("maintainOrgUnit.id"));
        selector.add(new SelectorItemInfo("eqmLocation.id"));
        selector.add(new SelectorItemInfo("equipmentArchives.id"));
        selector.add(new SelectorItemInfo("planStartTime"));
        selector.add(new SelectorItemInfo("planEndTime"));
        selector.add(new SelectorItemInfo("planPublishTime"));
        selector.add(new SelectorItemInfo("realStartTime"));
        selector.add(new SelectorItemInfo("realEndTime"));
        selector.add(new SelectorItemInfo("workOrderModel.id"));
        selector.add(new SelectorItemInfo("powerOffStartTime"));
        selector.add(new SelectorItemInfo("powerOffEndTime"));
        selector.add(new SelectorItemInfo("taskEntry"));
        selector.add(new SelectorItemInfo("planUserEntry.maintainTeam.id"));
        selector.add(new SelectorItemInfo("planUserEntry.maintainStaff.id"));
        selector.add(new SelectorItemInfo("planMaterialEntry.material.id"));
        selector.add(new SelectorItemInfo("planMaterialEntry.amount"));
        selector.add(new SelectorItemInfo("planMaterialEntry.measureunit.id"));
        selector.add(new SelectorItemInfo("planToolsEntry.tool.id"));
        selector.add(new SelectorItemInfo("planToolsEntry.measureUnit.id"));
        selector.add(new SelectorItemInfo("planServiceEntry.name"));
        selector.add(new SelectorItemInfo("realTaskEntry.describe"));
        selector.add(new SelectorItemInfo("realTaskEntry.startTime"));
        selector.add(new SelectorItemInfo("realTaskEntry.endTime"));
        selector.add(new SelectorItemInfo("userEntry.maintainTeam.id"));
        selector.add(new SelectorItemInfo("userEntry.maintainStaff.id"));
        selector.add(new SelectorItemInfo("userEntry.startTime"));
        selector.add(new SelectorItemInfo("userEntry.endTime"));
        selector.add(new SelectorItemInfo("userEntry.hours"));
        selector.add(new SelectorItemInfo("userEntry.recordUser.id"));
        selector.add(new SelectorItemInfo("userEntry.recordTime"));
        selector.add(new SelectorItemInfo("materialEntry.material.id"));
        selector.add(new SelectorItemInfo("materialEntry.measureunit.id"));
        selector.add(new SelectorItemInfo("materialEntry.planQty"));
        selector.add(new SelectorItemInfo("materialEntry.realQty"));
        selector.add(new SelectorItemInfo("materialEntry.realCostQty"));
        selector.add(new SelectorItemInfo("toolsEntry.tool.id"));
        selector.add(new SelectorItemInfo("toolsEntry.measureUnit.id"));
        selector.add(new SelectorItemInfo("toolsEntry.amount"));
        selector.add(new SelectorItemInfo("toolsEntry.hours"));
        selector.add(new SelectorItemInfo("serviceEntry.name"));
        selector.add(new SelectorItemInfo("serviceEntry.startTime"));
        selector.add(new SelectorItemInfo("serviceEntry.endTime"));
        selector.add(new SelectorItemInfo("serviceEntry.hours"));
        selector.add(new SelectorItemInfo("faultReportEntry.faultSort.id"));
        selector.add(new SelectorItemInfo("faultReportEntry.findDate"));
        return selector;
    }

    private void validateDateRange(Date from, Date to, WorkOrderInfo info, String resourceKey) throws WorkOrderException {
        if (from == null || to == null) {
            return;
        }
        if (from.compareTo(to) > 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = info.getNumber();
            objectArray[1] = GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)resourceKey, null);
            throw new WorkOrderException(WorkOrderException.CANNOT_SUBMIT, objectArray);
        }
    }
}

