/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EqmClassTeamFrequencyCollection;
import com.kingdee.eas.eqm.basedata.EqmClassTeamInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaSiteTaskEntryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaSiteTaskEntryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainRouteInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainSiteCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainSiteFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainSiteInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorFeatureCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorFeatureInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorInfo;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.eqmcore.EQMBillBaseEntryCollection;
import com.kingdee.eas.eqm.planning.CheckingPlanningException;
import com.kingdee.eas.eqm.planning.CheckingPlanningInfo;
import com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationInfo;
import com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationTaskMeterCollection;
import com.kingdee.eas.eqm.planning.EquipmentCheckingRegulationTaskMeterInfo;
import com.kingdee.eas.eqm.planning.RouteCheckingRegulationInfo;
import com.kingdee.eas.eqm.planning.app.AbstractCheckingPlanningFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CheckingPlanningFacadeControllerBean
extends AbstractCheckingPlanningFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String CHECKINGPLANNINGFACADE_RESOURCE_PATH = "com.kingdee.eas.eqm.planning.CheckingPlanningFacadeResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.app.CheckingPlanningFacadeControllerBean");
    private String table_CheckingPlaning = null;
    private String table_Task = null;
    private String table_Log = null;
    private String table_FactoryCalendarEntry = null;
    private static final Format dateFormat = BOSLocaleUtil.getDateFormat();
    private static final Format timeFormat = new SimpleDateFormat(" HH:mm:ss SSSSS");
    private static final Format midDateFormat = BOSLocaleUtil.getDateTimeFormat();
    private static final Format longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSSSS");
    private StringBuffer resultSB = new StringBuffer();
    private int seq = 0;

    @Override
    protected String[] _generateCheckingPlanning(Context ctx, IObjectValue regulationInfo, int generateType, java.util.Date pointedPlanDate, java.util.Date planStartDate, java.util.Date planEndDate) throws BOSException, EASBizException {
        long geneStart = System.currentTimeMillis();
        this.seq = 0;
        HashMap paraMap = this.getParameterFromRegulation(regulationInfo);
        String strStorageOrgUnitId = paraMap.get("strStorageOrgUnitId").toString();
        String strStorageOrgUnitName = paraMap.get("strStorageOrgUnitName").toString();
        int cpType = Integer.parseInt(paraMap.get("cpType").toString());
        int pointPeriod = Integer.parseInt(paraMap.get("pointPeriod").toString());
        int pointUnit = Integer.parseInt(paraMap.get("pointUnit").toString());
        int dateTag = Integer.parseInt(paraMap.get("dateTag").toString());
        int classTeamNumber = Integer.parseInt(paraMap.get("classTeamNumber").toString());
        int turns = Integer.parseInt(paraMap.get("turns").toString());
        EqmClassTeamFrequencyCollection classTeamEntryCollection = (EqmClassTeamFrequencyCollection)paraMap.get("classTeamEntryCollection");
        try {
            this.createTemporaryTable(ctx, strStorageOrgUnitId);
            List<java.util.Date> list = this.getPlanDateList(ctx, strStorageOrgUnitId, strStorageOrgUnitName, generateType, cpType, pointPeriod, pointUnit, dateTag, pointedPlanDate, planStartDate, planEndDate);
            if (list.size() != 0) {
                this.generatePlaningAndLog(ctx, regulationInfo, list, cpType, planStartDate, planEndDate, classTeamEntryCollection, classTeamNumber, turns);
                this.updateLastPlanningDate(ctx, regulationInfo, list.get(list.size() - 1));
                this.writeDataFromTempTableToEntityTable(ctx, this.table_CheckingPlaning, this.table_Task, this.table_Log);
                this.writeLog(ctx, regulationInfo);
            } else {
                this.resultSB.append(this.getResourceMsg("overwithnotresult"));
            }
        }
        catch (ParseException e) {
            throw new CheckingPlanningException(CheckingPlanningException.GETPLANDATELISTERROR);
        }
        finally {
            this.releaseTemporaryTable(ctx);
        }
        Timestamp endTime = new Timestamp(System.currentTimeMillis());
        String[] result = new String[]{midDateFormat.format(endTime) + " " + this.resultSB.toString()};
        long geneEnd = System.currentTimeMillis();
        double geneTime = (double)(geneEnd - geneStart) / 1000.0;
        System.out.println("Gene_Total_Time = " + geneTime + "s");
        return result;
    }

    private HashMap getParameterFromRegulation(IObjectValue regulationInfo) {
        HashMap<String, String> hm = new HashMap<String, String>();
        String strStorageOrgUnitId = "";
        String strStorageOrgUnitName = "";
        int cpType = 1;
        int pointPeriod = 0;
        int pointUnit = 0;
        int dateTag = 0;
        int classTeamNumber = 1;
        int turns = 1;
        EqmClassTeamFrequencyCollection classTeamEntryCollection = null;
        if (regulationInfo.getClass().equals(EquipmentCheckingRegulationInfo.class)) {
            EquipmentCheckingRegulationInfo equipmentCheckingRegulationInfo = (EquipmentCheckingRegulationInfo)regulationInfo;
            strStorageOrgUnitId = equipmentCheckingRegulationInfo.getMainOrgUnit().getId().toString();
            strStorageOrgUnitName = equipmentCheckingRegulationInfo.getMainOrgUnit().getName();
            cpType = equipmentCheckingRegulationInfo.getCptype().getValue();
            if (cpType == 10) {
                pointPeriod = equipmentCheckingRegulationInfo.getPointPeriod();
                pointUnit = equipmentCheckingRegulationInfo.getPointPlanningUnit().getValue();
            } else {
                EqmClassTeamInfo classTeamInfo = equipmentCheckingRegulationInfo.getClassTeam();
                if (classTeamInfo != null && (classTeamEntryCollection = classTeamInfo.getFrequency()) != null) {
                    classTeamNumber = classTeamEntryCollection.size();
                }
                turns = equipmentCheckingRegulationInfo.getTurns();
            }
            dateTag = equipmentCheckingRegulationInfo.getDateTag().getValue();
        } else {
            RouteCheckingRegulationInfo routeCheckingRegulationInfo = (RouteCheckingRegulationInfo)regulationInfo;
            strStorageOrgUnitId = routeCheckingRegulationInfo.getMainOrgUnit().getId().toString();
            strStorageOrgUnitName = routeCheckingRegulationInfo.getMainOrgUnit().getName();
            cpType = routeCheckingRegulationInfo.getCptype().getValue();
            if (cpType == 10) {
                pointPeriod = routeCheckingRegulationInfo.getPointPeriod();
                pointUnit = routeCheckingRegulationInfo.getPointPlanningUnit().getValue();
            } else {
                EqmClassTeamInfo classTeamInfo = routeCheckingRegulationInfo.getClassTeam();
                if (classTeamInfo != null && (classTeamEntryCollection = classTeamInfo.getFrequency()) != null) {
                    classTeamNumber = classTeamEntryCollection.size();
                }
                turns = routeCheckingRegulationInfo.getTurns();
            }
            dateTag = routeCheckingRegulationInfo.getDateTag().getValue();
        }
        hm.put("strStorageOrgUnitId", strStorageOrgUnitId);
        hm.put("strStorageOrgUnitName", strStorageOrgUnitName);
        hm.put("cpType", Integer.toString(cpType));
        hm.put("pointPeriod", Integer.toString(pointPeriod));
        hm.put("pointUnit", Integer.toString(pointUnit));
        hm.put("dateTag", Integer.toString(dateTag));
        hm.put("classTeamNumber", Integer.toString(classTeamNumber));
        hm.put("turns", Integer.toString(turns));
        hm.put("classTeamEntryCollection", (String)classTeamEntryCollection);
        return hm;
    }

    private boolean isExistWorkCalendar(Context ctx, String stoageOrgUnitId, java.util.Date startDate, java.util.Date endDate) throws CheckingPlanningException {
        boolean isExist = false;
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            StringBuffer sql_startDate = new StringBuffer();
            sql_startDate.append("select 1 from ").append(this.table_FactoryCalendarEntry).append(" where FWorkDate = to_date('").append(sf.format(startDate)).append("') ");
            IRowSet rs_startDate = DbUtil.executeQuery((Context)ctx, (String)sql_startDate.toString());
            StringBuffer sql_endDate = new StringBuffer();
            sql_endDate.append("select 1 from ").append(this.table_FactoryCalendarEntry).append(" where FWorkDate = to_date('").append(sf.format(endDate)).append("') ");
            IRowSet rs_endDate = DbUtil.executeQuery((Context)ctx, (String)sql_endDate.toString());
            isExist = rs_startDate.size() > 0 && rs_endDate.size() > 0;
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.GETORGUNITWORKCALENDARERROR);
        }
        return isExist;
    }

    private List<java.util.Date> getPlanDateList(Context ctx, String strStorageOrgUnitId, String strStorageOrgUnitName, int generateType, int cpType, int pointPeriod, int pointUnit, int dateTag, java.util.Date pointedPlanDate, java.util.Date planStartDate, java.util.Date planEndDate) throws EASBizException, BOSException, ParseException {
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        if (generateType == 20) {
            int period = 0;
            if (dateTag == 20) {
                if (!this.isExistWorkCalendar(ctx, strStorageOrgUnitId, planStartDate, planEndDate)) {
                    throw new CheckingPlanningException(CheckingPlanningException.WORKCALENDARNOTINIT, new String[]{strStorageOrgUnitName});
                }
                period = cpType == 10 ? (pointUnit == 30 ? pointPeriod * 30 : (pointUnit == 20 ? pointPeriod * 7 : pointPeriod)) : 1;
                java.util.Date date = planStartDate;
                java.util.Date date1 = planStartDate;
                while (GeneDateUtils.compareByDate((java.util.Date)planEndDate, (java.util.Date)date1) >= 0) {
                    if (this.isWorkDay(ctx, date1)) {
                        date = date1;
                        list.add(date);
                        break;
                    }
                    date1 = GeneDateUtils.getNextDay((java.util.Date)date1);
                }
                while (GeneDateUtils.compareByDate((java.util.Date)planEndDate, (java.util.Date)date) >= 0 && (date = this.findDateFromFactoryCalendar(ctx, date, period)) != null) {
                    if (GeneDateUtils.compareByDate((java.util.Date)planEndDate, (java.util.Date)date) < 0) continue;
                    list.add(date);
                }
            } else {
                period = cpType == 10 ? (pointUnit != 30 ? (pointUnit == 20 ? pointPeriod * 7 : pointPeriod) : pointPeriod) : 1;
                int i = 0;
                if (pointUnit == 30) {
                    java.util.Date date = planStartDate;
                    while (GeneDateUtils.compareByDate((java.util.Date)planEndDate, (java.util.Date)date) >= 0) {
                        list.add(date);
                        date = GeneDateUtils.dateAddMonth((java.util.Date)planStartDate, (int)(++i * period));
                    }
                } else {
                    java.util.Date date = planStartDate;
                    while (GeneDateUtils.compareByDate((java.util.Date)planEndDate, (java.util.Date)date) >= 0) {
                        list.add(date);
                        date = GeneDateUtils.getNextDay((java.util.Date)date, (int)period);
                    }
                }
            }
        } else {
            list.add(pointedPlanDate);
        }
        return list;
    }

    private void generatePlaningAndLog(Context ctx, IObjectValue regulationInfo, List<java.util.Date> planningTimeList, int cpType, java.util.Date planStartDate, java.util.Date planEndDate, EqmClassTeamFrequencyCollection classTeamEntryCollection, int classTeamNumber, int turns) throws BOSException, EASBizException {
        if (regulationInfo.getClass().equals(RouteCheckingRegulationInfo.class)) {
            RouteCheckingRegulationInfo routeCheckingRegulationInfo = (RouteCheckingRegulationInfo)regulationInfo;
            this.generatePlaningAndLogFromRouteCheckingRegulation(ctx, routeCheckingRegulationInfo, planningTimeList, cpType, planStartDate, planEndDate, classTeamEntryCollection, classTeamNumber, turns);
        } else {
            EquipmentCheckingRegulationInfo equipmentCheckingRegulationInfo = (EquipmentCheckingRegulationInfo)regulationInfo;
            this.generatePlaningAndLogFromEquipmentCheckingRegulation(ctx, equipmentCheckingRegulationInfo, planningTimeList, cpType, planStartDate, planEndDate, classTeamEntryCollection, classTeamNumber, turns);
        }
    }

    private void generatePlaningAndLogFromRouteCheckingRegulation(Context ctx, RouteCheckingRegulationInfo routeCheckingRegulationInfo, List<java.util.Date> planningTimeList, int cpType, java.util.Date planStartDate, java.util.Date planEndDate, EqmClassTeamFrequencyCollection classTeamEntryCollection, int classTeamNumber, int turns) throws EASBizException, BOSException {
        String maintainGroupId = "";
        String maintainRouteId = "";
        String maintainRouteNumber = "";
        String maintainRouteName = "";
        int cpObjectId = 10;
        String managerId = "";
        String maintainDeptId = "";
        String planOrgUnitId = "";
        int billStatus = 10;
        String billDescription = "";
        String maintainOrgId = "";
        String controlUnitId = "";
        String regulationNumber = routeCheckingRegulationInfo.getNumber();
        String regulationName = routeCheckingRegulationInfo.getName();
        String executorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String creatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String userName = ContextUtil.getCurrentUserInfo((Context)ctx).getName(ctx.getLocale()).toString();
        EquipmentMaintainRouteInfo equipmentMaintainRouteInfo = routeCheckingRegulationInfo.getMaintainRoute();
        if (routeCheckingRegulationInfo.getMaintainGroup() != null) {
            maintainGroupId = routeCheckingRegulationInfo.getMaintainGroup().getId().toString();
        }
        if (routeCheckingRegulationInfo.getMaintainRoute() != null) {
            maintainRouteId = routeCheckingRegulationInfo.getMaintainRoute().getId().toString();
            maintainRouteNumber = routeCheckingRegulationInfo.getMaintainRoute().getNumber();
            maintainRouteName = routeCheckingRegulationInfo.getMaintainRoute().getName();
        }
        if (routeCheckingRegulationInfo.getManager() != null) {
            managerId = routeCheckingRegulationInfo.getManager().getId().toString();
        }
        if (routeCheckingRegulationInfo.getMaintainDept() != null) {
            maintainDeptId = routeCheckingRegulationInfo.getMaintainDept().getId().toString();
        }
        if (routeCheckingRegulationInfo.getStorageOrgUnit() != null) {
            planOrgUnitId = routeCheckingRegulationInfo.getStorageOrgUnit().getId().toString();
            if (routeCheckingRegulationInfo.getStorageOrgUnit().getCU() != null) {
                controlUnitId = routeCheckingRegulationInfo.getStorageOrgUnit().getCU().getId().toString();
            }
        }
        if (routeCheckingRegulationInfo.getMaintainOrg() != null) {
            maintainOrgId = routeCheckingRegulationInfo.getMaintainOrg().getId().toString();
        }
        billDescription = cpType == 10 ? this.getResourceMsg("pointPlan") : this.getResourceMsg("circlePlan");
        int billCount = cpType == 20 ? classTeamNumber * turns * planningTimeList.size() : planningTimeList.size();
        String[] billNumbers = this.getNumbers(ctx, routeCheckingRegulationInfo.getMainOrgUnit().getId().toString(), billCount);
        List<String> idList = this.insertIntoTempCheckingPlaningTableAndTempLogTable(ctx, regulationNumber, regulationName, maintainGroupId, "", "", "", "", "", "", maintainRouteId, maintainRouteNumber, maintainRouteName, classTeamEntryCollection, classTeamNumber, turns, cpObjectId, cpType, managerId, maintainDeptId, planStartDate, planEndDate, planningTimeList, billNumbers, billDescription, billStatus, planOrgUnitId, maintainOrgId, controlUnitId, executorId, creatorId, userName);
        EquipmentMaintainSiteCollection equipmentMaintainSiteCollection = (EquipmentMaintainSiteCollection)this.SetSort((IObjectCollection)this.getSiteCollectionFromMaintainRouteInfo(ctx, equipmentMaintainRouteInfo), "OrderNumber");
        this.insertIntoTempTaskTable(ctx, idList, equipmentMaintainSiteCollection, null, null, null, null);
    }

    private IObjectCollection getTasksBySite(Context ctx, EquipmentMaintainSiteInfo equipmentMaintainSiteInfo) {
        EQMBillBaseEntryCollection col = null;
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("parent", (Object)equipmentMaintainSiteInfo.getId().toString(), CompareType.EQUALS));
            evi.setFilter(fi);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("statusMontor.*"));
            sic.add(new SelectorItemInfo("statusMontor.meter.*"));
            sic.add(new SelectorItemInfo("parent"));
            sic.add(new SelectorItemInfo("taskNumber"));
            sic.add(new SelectorItemInfo("demand"));
            sic.add(new SelectorItemInfo("OrderNumber"));
            sic.add(new SelectorItemInfo("remark"));
            evi.setSelector(sic);
            col = EquipmentMaSiteTaskEntryFactory.getLocalInstance((Context)ctx).getEQMBillBaseEntryCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return col;
    }

    private void generatePlaningAndLogFromEquipmentCheckingRegulation(Context ctx, EquipmentCheckingRegulationInfo equipmentCheckingRegulationInfo, List<java.util.Date> planningTimeList, int cpType, java.util.Date planStartDate, java.util.Date planEndDate, EqmClassTeamFrequencyCollection classTeamEntryCollection, int classTeamNumber, int turns) throws EASBizException, BOSException {
        EquipmentLocationInfo equipmentLocationInfo;
        EquipmentArchivesInfo equipmentArchivesInfo;
        String maintainGroupId = "";
        String equipmentLocationId = "";
        String equipmentLocationNumber = "";
        String equipmentLocationName = "";
        String equipmentArchivesId = "";
        String equipmentArchivesNumber = "";
        String equipmentArchivesName = "";
        int cpObjectId = 20;
        String managerId = "";
        String maintainDeptId = "";
        String planOrgUnitId = equipmentCheckingRegulationInfo.getStorageOrgUnit().getId().toString();
        int billStatus = 10;
        String billDescription = "";
        String maintainOrgId = "";
        String controlUnitId = equipmentCheckingRegulationInfo.getStorageOrgUnit().getCU().getId().toString();
        String creatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String executorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String userName = ContextUtil.getCurrentUserInfo((Context)ctx).getName().toString();
        String regulationNumber = equipmentCheckingRegulationInfo.getNumber();
        String regulationName = equipmentCheckingRegulationInfo.getName();
        if (equipmentCheckingRegulationInfo.getMaintainGroup() != null) {
            maintainGroupId = equipmentCheckingRegulationInfo.getMaintainGroup().getId().toString();
        }
        if (equipmentCheckingRegulationInfo.getManager() != null) {
            managerId = equipmentCheckingRegulationInfo.getManager().getId().toString();
        }
        if (equipmentCheckingRegulationInfo.getMaintainDept() != null) {
            maintainDeptId = equipmentCheckingRegulationInfo.getMaintainDept().getId().toString();
        }
        if (equipmentCheckingRegulationInfo.getMaintainOrg() != null) {
            maintainOrgId = equipmentCheckingRegulationInfo.getMaintainOrg().getId().toString();
        }
        if ((equipmentArchivesInfo = equipmentCheckingRegulationInfo.getEquipment()) != null) {
            equipmentArchivesId = equipmentArchivesInfo.getId().toString();
            equipmentArchivesNumber = equipmentArchivesInfo.getNumber().toString();
            equipmentArchivesName = equipmentArchivesInfo.getName().toString();
            equipmentLocationInfo = equipmentArchivesInfo.getLocation();
            if (equipmentLocationInfo != null) {
                equipmentLocationId = equipmentLocationInfo.getId().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                equipmentLocationInfo = EquipmentLocationFactory.getLocalInstance((Context)ctx).getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(equipmentLocationId), sic);
                equipmentLocationNumber = equipmentLocationInfo.getNumber().toString();
                equipmentLocationName = equipmentLocationInfo.getName().toString();
            }
        } else {
            equipmentLocationInfo = equipmentCheckingRegulationInfo.getLocation();
            if (equipmentLocationInfo != null) {
                equipmentLocationId = equipmentLocationInfo.getId().toString();
                equipmentLocationNumber = equipmentLocationInfo.getNumber().toString();
                equipmentLocationName = equipmentLocationInfo.getName().toString();
            }
        }
        billDescription = cpType == 10 ? this.getResourceMsg("pointPlan") : this.getResourceMsg("circlePlan");
        int billCount = cpType == 20 ? classTeamNumber * turns * planningTimeList.size() : planningTimeList.size();
        String[] billNumbers = this.getNumbers(ctx, equipmentCheckingRegulationInfo.getMainOrgUnit().getId().toString(), billCount);
        List<String> idList = this.insertIntoTempCheckingPlaningTableAndTempLogTable(ctx, regulationNumber, regulationName, maintainGroupId, equipmentLocationId, equipmentLocationNumber, equipmentLocationName, equipmentArchivesId, equipmentArchivesNumber, equipmentArchivesName, "", "", "", classTeamEntryCollection, classTeamNumber, turns, cpObjectId, cpType, managerId, maintainDeptId, planStartDate, planEndDate, planningTimeList, billNumbers, billDescription, billStatus, planOrgUnitId, maintainOrgId, controlUnitId, executorId, creatorId, userName);
        EquipmentStandardOperationInfo equipmentStandardOperationInfo = equipmentCheckingRegulationInfo.getStandardop();
        EquipmentCheckingRegulationTaskMeterCollection taskMeterCollection = (EquipmentCheckingRegulationTaskMeterCollection)this.SetSort((IObjectCollection)equipmentCheckingRegulationInfo.getTaskMeter(), "OrderNumber");
        this.insertIntoTempTaskTable(ctx, idList, null, equipmentLocationId, equipmentArchivesId, equipmentStandardOperationInfo, (IObjectCollection)taskMeterCollection);
    }

    private EquipmentMaintainSiteCollection getSiteCollectionFromMaintainRouteInfo(Context ctx, EquipmentMaintainRouteInfo equipmentMaintainRouteInfo) throws CheckingPlanningException {
        EquipmentMaintainSiteCollection equipmentMaintainSiteCollection = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("maintainRoute.id", (Object)equipmentMaintainRouteInfo.getId().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("equipmentArchives.id"));
        sic.add(new SelectorItemInfo("equipmentLocation.id"));
        sic.add(new SelectorItemInfo("standardOperation.id"));
        sic.add(new SelectorItemInfo("OrderNumber"));
        view.setSelector(sic);
        try {
            equipmentMaintainSiteCollection = EquipmentMaintainSiteFactory.getLocalInstance((Context)ctx).getEquipmentMaintainSiteCollection(view);
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.GETSITECOLLECTIONFROMMAINTAINROUTEINFOERROR);
        }
        return equipmentMaintainSiteCollection;
    }

    private IObjectCollection SetSort(IObjectCollection Col, String OrderByKey) {
        for (int i = 0; i <= Col.size() - 2; ++i) {
            for (int k = i + 1; k <= Col.size() - 1; ++k) {
                int a2;
                int a1 = Col.getObject(i).getInt(OrderByKey);
                if (a1 <= (a2 = Col.getObject(k).getInt(OrderByKey))) continue;
                Col.swap(Col.getObject(i), Col.getObject(k));
            }
        }
        return Col;
    }

    private String getFeatures(Context ctx, String sid) {
        try {
            EquipmentStatusMontorInfo smInfo = EquipmentStatusMontorFactory.getLocalInstance((Context)ctx).getEquipmentStatusMontorInfo((IObjectPK)new ObjectUuidPK(sid));
            EquipmentStatusMontorFeatureCollection coll = smInfo.getFeatures();
            Iterator ir = coll.iterator();
            StringBuffer tempCharacteristicValue = new StringBuffer();
            while (ir.hasNext()) {
                EquipmentStatusMontorFeatureInfo featureInfo = (EquipmentStatusMontorFeatureInfo)ir.next();
                tempCharacteristicValue.append(featureInfo.getFeatureValue());
                tempCharacteristicValue.append("#");
            }
            if (tempCharacteristicValue.length() > 0) {
                return tempCharacteristicValue.substring(0, tempCharacteristicValue.length() - 1);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private CoreBaseCollection getTaskCollectionFromStaOpr(Context ctx, EquipmentStandardOperationInfo equipmentStandardOperationInfo) throws CheckingPlanningException {
        CoreBaseCollection equipmentStaOprTaskCollection = null;
        FilterInfo taskFilter = new FilterInfo();
        taskFilter.getFilterItems().add(new FilterItemInfo("standardOperation.id", (Object)equipmentStandardOperationInfo.getId().toString(), CompareType.EQUALS));
        EntityViewInfo taskView = new EntityViewInfo();
        taskView.setFilter(taskFilter);
        SelectorItemCollection taskSic = new SelectorItemCollection();
        taskSic.add(new SelectorItemInfo("demand"));
        taskSic.add(new SelectorItemInfo("remark"));
        taskSic.add(new SelectorItemInfo("OrderNumber"));
        taskView.setSelector(taskSic);
        try {
            equipmentStaOprTaskCollection = EquipmentStaOprTaskFactory.getLocalInstance((Context)ctx).getCollection(taskView);
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.GETTASKCOLLECTIONFROMSTAOPRERROR);
        }
        return equipmentStaOprTaskCollection;
    }

    private void createTemporaryTable(Context ctx, String storageOrgUnitId) throws CheckingPlanningException, BOSException {
        StringBuffer createCheckingPlaningSql = new StringBuffer();
        createCheckingPlaningSql.append("Create Table temp_CheckingPlanning(").append("FMaintainGroupID VARCHAR(44),").append("FLocationID VARCHAR(44),").append("FMaintainRouteID VARCHAR(44),").append("FShiftID VARCHAR(44),").append("FTurns INT,").append("FCpObject INT,").append("FEquipmentID VARCHAR(44),").append("FManagerID VARCHAR(44),").append("FInputTime DateTime,").append("FMaintainDeptID VARCHAR(44),").append("FPlanningTime DateTime,").append("FStorageOrgUnitID VARCHAR(44),").append("FBillStatus INT,").append("FNumber NVARCHAR(80),").append("FDescription NVARCHAR(255),").append("FCpType INT,").append("FMaintainOrgID VARCHAR(44),").append("FControlUnitID VARCHAR(44),").append("FID VARCHAR(44) DEFAULT '' NOT NULL,").append("FExecutorID VARCHAR(44),").append("FCreatorID VARCHAR(44),").append("FCreateTime DateTime)");
        StringBuffer createTaskSql = new StringBuffer();
        createTaskSql.append("Create Table temp_CheckingPlanningTask (").append("FID VARCHAR(44) DEFAULT '' NOT NULL,").append("FSeq INT DEFAULT 0 NOT NULL,").append("FParentID VARCHAR(44),").append("FAchievesID VARCHAR(44),").append("FLocationID VARCHAR(44),").append("FTaskDescription NVARCHAR(255),").append("FDemand NVARCHAR(200),").append("FTaskMeter NVARCHAR(44),").append("FMeterType int,").append("FUnitID varchar(44),").append("FCharacteristicValue NVARCHAR(200),").append("FwarningFloorLimit Numeric(20,12),").append("FwarningTopLimit Numeric(20,12),").append("FoperateFloorLimit Numeric(20,12),").append("FoperateTopLimit Numeric(20,12),").append("ForderNumber int,").append("FsiteNumber int)");
        StringBuffer createLogSql = new StringBuffer();
        createLogSql.append("Create Table temp_CheckPointLog (").append("FStorageOrgUnitID VARCHAR(44),").append("FControlUnitID VARCHAR(44),").append("FID VARCHAR(44) DEFAULT '' NOT NULL,").append("FCalcProcess NVARCHAR(44),").append("FRegulation NVARCHAR(44),").append("FMaintainorgID VARCHAR(44),").append("FCHECKPLANNINGID VARCHAR(44),").append("FPlaningTime DateTime,").append("FEqmClassTeamID VARCHAR(44),").append("FTurns INT,").append("FEquipmentMaintain VARCHAR(44),").append("FEquipmentLocation VARCHAR(44),").append("FEquipmentArchives VARCHAR(44),").append("FPlanningEndTime DateTime,").append("FPlanningStartTime DateTime,").append("FCheckPointType INT,").append("FCheckPointObject INT,").append("FRunningStartTime DateTime,").append("FRunningEndTime DateTime,").append("FExecutorID VARCHAR(44),").append("FRegulationName NVARCHAR(255),").append("FNumber NVARCHAR(44),").append("FCheckPlannNumber NVARCHAR(44))");
        StringBuffer createFactoryCalendarEntrySql = new StringBuffer();
        createFactoryCalendarEntrySql.append("Create Table temp_FactoryCalendarEntry (").append("FID VARCHAR(44) DEFAULT '' NOT NULL,").append("FParentID VARCHAR(44),").append("FDateType INT,").append("FWorkDate DateTime,").append("FWorkDateSeq INT,").append("FYearSeq INT,").append("FMonthSeq INT,").append("FWeekSeq INT,").append("FNextWorkDaySeq INT,").append("FPreWorkDaySeq INT,").append("FSeq INT)");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            this.table_CheckingPlaning = pool.createTempTable(createCheckingPlaningSql.toString());
            this.table_Task = pool.createTempTable(createTaskSql.toString());
            this.table_Log = pool.createTempTable(createLogSql.toString());
            this.table_FactoryCalendarEntry = pool.createTempTable(createFactoryCalendarEntrySql.toString());
        }
        catch (Exception e) {
            throw new CheckingPlanningException(CheckingPlanningException.CREATETEMPORARYTABLEERROR);
        }
        StringBuffer insertFactoryCalendarEntrySql = new StringBuffer();
        insertFactoryCalendarEntrySql.append("insert into ").append(this.table_FactoryCalendarEntry).append(" (FID, FParentID, FDateType, FWorkDate, ").append("FWorkDateSeq, FYearSeq, FMonthSeq, FWeekSeq, FNextWorkDaySeq, FPreWorkDaySeq, FSeq) ").append("select ce.FID, ce.FParentID, ce.FDateType, ce.FWorkDate, ce.FWorkDateSeq, ").append("ce.FYearSeq, ce.FMonthSeq, ce.FWeekSeq, ce.FNextWorkDaySeq, ce.FPreWorkDaySeq, ce.FSeq ").append("from T_MM_FactoryCalendar c ").append("right join T_MM_FactoryCalendarEntry ce ").append("on c.FID = ce.FParentID ").append("where c.FStorageOrgUnitID = '").append(storageOrgUnitId).append("'");
        DbUtil.execute((Context)ctx, (String)insertFactoryCalendarEntrySql.toString());
    }

    private void releaseTemporaryTable(Context ctx) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(this.table_CheckingPlaning);
        pool.releaseTable(this.table_Task);
        pool.releaseTable(this.table_Log);
        pool.releaseTable(this.table_FactoryCalendarEntry);
    }

    private List<String> insertIntoTempCheckingPlaningTableAndTempLogTable(Context ctx, String regulationNumber, String regulationName, String maintainGroupId, String equipmentLocationId, String equipmentLocationNumber, String equipmentLocationName, String equipmentArchivesId, String equipmentArchivesNumber, String equipmentArchivesName, String maintainRouteId, String maintainRouteNumber, String maintainRouteName, EqmClassTeamFrequencyCollection classTeamEntryCollection, int classTeamNumber, int turns, int cpObject, int cpType, String managerId, String maintainDeptId, java.util.Date planStartDate, java.util.Date planEndDate, List<java.util.Date> planningTimeList, String[] numbers, String description, int billStatus, String planOrgUnitId, String maintainOrgId, String controlUnitId, String executorId, String creatorId, String userName) throws CheckingPlanningException {
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<java.util.Date> circlePlanningTimeList = new ArrayList<java.util.Date>();
        ArrayList<String> classTeamFrequencyIdList = new ArrayList<String>();
        ArrayList<Integer> turnsList = new ArrayList<Integer>();
        if (cpType == 20) {
            int j;
            int k;
            int i;
            for (i = 0; i < planningTimeList.size(); ++i) {
                k = classTeamNumber * turns;
                for (j = 0; j < k; ++j) {
                    circlePlanningTimeList.add(planningTimeList.get(i));
                }
            }
            for (i = 0; i < planningTimeList.size(); ++i) {
                for (j = 0; j < classTeamNumber; ++j) {
                    for (k = 0; k < turns; ++k) {
                        classTeamFrequencyIdList.add(classTeamEntryCollection.get(j).getId().toString());
                        turnsList.add(new Integer(k + 1));
                    }
                }
            }
        }
        if (numbers == null) {
            int i;
            String number = null;
            ArrayList<String> numberList = new ArrayList<String>();
            if (cpType == 10) {
                for (i = 0; i < planningTimeList.size(); ++i) {
                    number = "EI" + dateFormat.format(planningTimeList.get(i)) + timeFormat.format(new Timestamp(System.currentTimeMillis())) + String.valueOf(Math.random()).substring(2, 6);
                    numberList.add(number);
                }
                numbers = numberList.toArray(new String[0]);
            } else if (cpType == 20) {
                for (i = 0; i < circlePlanningTimeList.size(); ++i) {
                    number = "EI" + dateFormat.format(circlePlanningTimeList.get(i)) + timeFormat.format(new Timestamp(System.currentTimeMillis())) + String.valueOf(Math.random()).substring(2, 6);
                    numberList.add(number);
                }
                numbers = numberList.toArray(new String[0]);
            }
        }
        StringBuffer insertCPSqlSB = new StringBuffer();
        insertCPSqlSB.append("insert into ").append(this.table_CheckingPlaning).append("(FMaintainGroupID,FLocationID,FMaintainRouteID,FShiftID,FTurns,FCpObject,FEquipmentID,FManagerID,FInputTime").append(",FMaintainDeptID,FPlanningTime,FStorageOrgUnitID,FBillStatus,FNumber,FDescription,FCpType,FMaintainOrgID").append(",FControlUnitID,FID,FExecutorID,FCreatorID,FCreateTime)").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertCPSql = insertCPSqlSB.toString();
        StringBuffer insertCPLogSqlSB = new StringBuffer();
        insertCPLogSqlSB.append("insert into ").append(this.table_Log).append("( FStorageOrgUnitID,FControlUnitID,FID,FCalcProcess,FRegulation,FMaintainorgID,FCheckPlanningID").append(",FPlaningTime,FEqmClassTeamID,FTurns,FEquipmentMaintain,FEquipmentLocation,FEquipmentArchives").append(",FPlanningEndTime,FPlanningStartTime,FCheckPointType,FCheckPointObject,FRunningStartTime,FRunningEndTime").append(",FExecutorID,FRegulationName,FNumber,FCheckPlannNumber)").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertCPLogSql = insertCPLogSqlSB.toString();
        ArrayList<Object[]> insertCPParamsList = new ArrayList<Object[]>();
        ArrayList<Object[]> insertCPLogParamsList = new ArrayList<Object[]>();
        this.resultSB.append(this.getResourceMsg("totalGene")).append(" [ ").append(numbers.length).append(" ] ").append(this.getResourceMsg("pieceOfCheckPlan")).append(this.getResourceMsg("calinfo")).append("\n").append("\n");
        for (int i = 0; i < numbers.length; ++i) {
            java.util.Date createTime = new java.util.Date();
            java.util.Date inputTime = new java.util.Date();
            Timestamp startTime = new Timestamp(System.currentTimeMillis());
            String proceedNumber = longDateFormat.format(startTime);
            String newID = BOSUuid.create((String)"3F4D9F03").toString();
            idList.add(newID);
            this.resultSB.append(this.getResourceMsg("proceedNumber")).append(" [ ").append(proceedNumber).append(" ] ").append("\n").append(midDateFormat.format(startTime)).append(" ").append(this.getResourceMsg("beginGenerate")).append(this.getResourceMsg("executor")).append(" ").append(userName).append("\n");
            if (maintainRouteNumber != null && maintainRouteNumber.length() > 0) {
                this.resultSB.append(this.getResourceMsg("maintainroute")).append(" [ ").append(maintainRouteNumber).append(" ").append(maintainRouteName).append(" ] ");
            } else if (equipmentArchivesNumber != null && equipmentArchivesNumber.length() > 0) {
                this.resultSB.append(this.getResourceMsg("equipment")).append(" [ ").append(equipmentArchivesNumber).append(" ").append(equipmentArchivesName).append(" ] ");
            } else if (equipmentLocationNumber != null && equipmentLocationNumber.length() > 0) {
                this.resultSB.append(this.getResourceMsg("location")).append(" [ ").append(equipmentLocationNumber).append(" ").append(equipmentLocationName).append(" ] ");
            }
            this.resultSB.append(this.getResourceMsg("generate")).append(description).append(" [ ").append(numbers[i]).append(" ] ").append("\n").append("\n");
            insertCPParamsList.add(new Object[]{maintainGroupId, equipmentLocationId, maintainRouteId, cpType == 10 ? null : (String)classTeamFrequencyIdList.get(i), cpType == 10 ? 0 : (Integer)turnsList.get(i), cpObject, equipmentArchivesId, managerId, this.transUtilDate2FormatSqlDate(inputTime, dateFormat), maintainDeptId, cpType == 10 ? this.transUtilDate2FormatSqlDate(planningTimeList.get(i), dateFormat) : this.transUtilDate2FormatSqlDate((java.util.Date)circlePlanningTimeList.get(i), dateFormat), planOrgUnitId, billStatus, numbers[i], description, cpType, maintainOrgId, controlUnitId, newID, executorId, creatorId, this.transUtilDate2FormatSqlDate(createTime, dateFormat)});
            Timestamp endTime = new Timestamp(System.currentTimeMillis());
            String logId = BOSUuid.create((String)"BBEDD490").toString();
            insertCPLogParamsList.add(new Object[]{planOrgUnitId, controlUnitId, logId, proceedNumber, regulationNumber, maintainOrgId, newID, cpType == 10 ? this.transUtilDate2FormatSqlDate(planningTimeList.get(i), dateFormat) : this.transUtilDate2FormatSqlDate((java.util.Date)circlePlanningTimeList.get(i), dateFormat), cpType == 10 ? null : (String)classTeamFrequencyIdList.get(i), cpType == 10 ? 0 : (Integer)turnsList.get(i), maintainRouteId, equipmentLocationId, equipmentArchivesId, planEndDate != null ? this.transUtilDate2FormatSqlDate(planEndDate, dateFormat) : null, planStartDate != null ? this.transUtilDate2FormatSqlDate(planStartDate, dateFormat) : null, cpType, cpObject, this.transFormatSqlTimestamp(startTime, midDateFormat), this.transFormatSqlTimestamp(endTime, midDateFormat), executorId, regulationName, proceedNumber, numbers[i]});
        }
        try {
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertCPSql, insertCPParamsList);
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.INSERTINTOTEMPCHECKINGPLANINGTABLEERROR);
        }
        try {
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertCPLogSql, insertCPLogParamsList);
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.INSERTINTOTEMPLOGTABLEERROR);
        }
        return idList;
    }

    private void insertIntoTempTaskTable(Context ctx, List<String> idList, EquipmentMaintainSiteCollection equipmentMaintainSiteCollection, String equipmentLocationId, String equipmentArchivesId, EquipmentStandardOperationInfo equipmentStandardOperationInfo, IObjectCollection taskMeterCollection) throws CheckingPlanningException, BOSException {
        StringBuffer insertSqlSB = new StringBuffer();
        insertSqlSB.append("insert into ").append(this.table_Task).append(" (FID, FSeq, FParentID, FAchievesID, FLocationID,").append(" FTaskDescription, FDemand,").append(" FTaskMeter, FMeterType, FUnitID, FCharacteristicValue,").append(" FwarningTopLimit, FwarningFloorLimit, FoperateTopLimit, FoperateFloorLimit)").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertSql = insertSqlSB.toString();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        if (equipmentMaintainSiteCollection != null && equipmentMaintainSiteCollection.size() > 0) {
            for (EquipmentMaintainSiteInfo equipmentMaintainSiteInfo : equipmentMaintainSiteCollection) {
                EquipmentStandardOperationInfo standardOperationInfo = equipmentMaintainSiteInfo.getStandardOperation();
                EquipmentArchivesInfo equipmentArchivesInfo = equipmentMaintainSiteInfo.getEquipmentArchives();
                EquipmentLocationInfo equipmentLocationInfo = null;
                if (equipmentArchivesInfo != null) {
                    equipmentArchivesId = equipmentArchivesInfo.getId().toString();
                    equipmentLocationInfo = equipmentArchivesInfo.getLocation();
                    if (equipmentLocationInfo != null) {
                        equipmentLocationId = equipmentLocationInfo.getId().toString();
                    }
                } else {
                    equipmentLocationInfo = equipmentMaintainSiteInfo.getEquipmentLocation();
                    if (equipmentLocationInfo != null) {
                        equipmentLocationId = equipmentLocationInfo.getId().toString();
                    }
                }
                if (equipmentMaintainSiteInfo.getTasks().size() > 0) {
                    IObjectCollection siteTaskMeterCollection = this.SetSort(this.getTasksBySite(ctx, equipmentMaintainSiteInfo), "OrderNumber");
                    for (EquipmentMaSiteTaskEntryInfo siteTaskMeterInfo : siteTaskMeterCollection) {
                        String remark = siteTaskMeterInfo.getRemark();
                        String demand = siteTaskMeterInfo.getDemand();
                        if (siteTaskMeterInfo.getStatusMontor() == null) {
                            this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, remark, demand, null, 0, null, null, null, null, null, null);
                            continue;
                        }
                        EquipmentStatusMontorInfo statusMontor = siteTaskMeterInfo.getStatusMontor();
                        String taskMeterId = statusMontor.getId().toString();
                        int meterType = statusMontor.getMeter().getMeterType().getValue();
                        String meterUnit = statusMontor.getMeter().getUnit() == null ? null : statusMontor.getMeter().getUnit().getId().toString();
                        String characteristicValue = this.getFeatures(ctx, taskMeterId);
                        String warnUpLimit = statusMontor.getWarnUpLimit().toPlainString();
                        String warnDownLimit = statusMontor.getWarnDownLimit().toPlainString();
                        String oprUpLimit = statusMontor.getOprUpLimit().toPlainString();
                        String oprDownLimit = statusMontor.getOprDownLimit().toPlainString();
                        this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, remark, demand, taskMeterId, meterType, meterUnit, characteristicValue, warnUpLimit, warnDownLimit, oprUpLimit, oprDownLimit);
                    }
                    continue;
                }
                if (standardOperationInfo != null) {
                    IObjectCollection equipmentStaOprTaskCollection = this.SetSort((IObjectCollection)this.getTaskCollectionFromStaOpr(ctx, standardOperationInfo), "ordernumber");
                    if (equipmentStaOprTaskCollection.size() != 0) {
                        for (EquipmentStaOprTaskInfo equipmentStaOprTaskInfo : equipmentStaOprTaskCollection) {
                            String demand = equipmentStaOprTaskInfo.getDemand();
                            String remark = equipmentStaOprTaskInfo.getRemark();
                            this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, remark, demand, null, 0, null, null, null, null, null, null);
                        }
                        continue;
                    }
                    this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, null, null, null, 0, null, null, null, null, null, null);
                    continue;
                }
                this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, null, null, null, 0, null, null, null, null, null, null);
            }
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertSql, paramsList);
            return;
        }
        if (taskMeterCollection != null && taskMeterCollection.size() > 0) {
            for (EquipmentCheckingRegulationTaskMeterInfo taskMeterInfo : taskMeterCollection) {
                String remark = taskMeterInfo.getTaskDescription();
                String demand = taskMeterInfo.getTaskRequire();
                if (taskMeterInfo.getStatusMonitor() == null) {
                    this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, remark, demand, null, 0, null, null, null, null, null, null);
                    continue;
                }
                EquipmentStatusMontorInfo statusMontor = taskMeterInfo.getStatusMonitor();
                String taskMeterId = statusMontor.getId().toString();
                int meterType = statusMontor.getMeter().getMeterType().getValue();
                String meterUnit = statusMontor.getMeter().getUnit() == null ? null : statusMontor.getMeter().getUnit().getId().toString();
                String characteristicValue = this.getFeatures(ctx, taskMeterId);
                String warnUpLimit = statusMontor.getWarnUpLimit().toPlainString();
                String warnDownLimit = statusMontor.getWarnDownLimit().toPlainString();
                String oprUpLimit = statusMontor.getOprUpLimit().toPlainString();
                String oprDownLimit = statusMontor.getOprDownLimit().toPlainString();
                this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, remark, demand, taskMeterId, meterType, meterUnit, characteristicValue, warnUpLimit, warnDownLimit, oprUpLimit, oprDownLimit);
            }
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertSql, paramsList);
            return;
        }
        if (equipmentStandardOperationInfo != null) {
            IObjectCollection equipmentStaOprTaskCollection = this.SetSort((IObjectCollection)this.getTaskCollectionFromStaOpr(ctx, equipmentStandardOperationInfo), "ordernumber");
            if (equipmentStaOprTaskCollection.size() != 0) {
                for (EquipmentStaOprTaskInfo equipmentStaOprTaskInfo : equipmentStaOprTaskCollection) {
                    String demand = equipmentStaOprTaskInfo.getDemand();
                    String remark = equipmentStaOprTaskInfo.getRemark();
                    this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, remark, demand, null, 0, null, null, null, null, null, null);
                }
                GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertSql, paramsList);
                return;
            }
            this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, null, null, null, 0, null, null, null, null, null, null);
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertSql, paramsList);
            return;
        }
        this.createInsertParamList4TempTaskTable(paramsList, idList, equipmentArchivesId, equipmentLocationId, null, null, null, 0, null, null, null, null, null, null);
        GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)insertSql, paramsList);
    }

    private void createInsertParamList4TempTaskTable(List<Object[]> paramsList, List<String> idList, String equipmentArchivesId, String equipmentLocationId, String remark, String demand, String taskMeterId, int meterType, String meterUnit, String characteristicValue, String warnUpLimit, String warnDownLimit, String oprUpLimit, String oprDownLimit) {
        for (int i = 0; i < idList.size(); ++i) {
            String taskId = BOSUuid.create((String)"E7B3B475").toString();
            paramsList.add(new Object[]{taskId, this.getSeq(), idList.get(i), equipmentArchivesId, equipmentLocationId, remark, demand, taskMeterId, String.valueOf(meterType), meterUnit, characteristicValue, new BigDecimal(warnUpLimit == null ? "0.00" : warnUpLimit), new BigDecimal(warnDownLimit == null ? "0.00" : warnDownLimit), new BigDecimal(oprUpLimit == null ? "0.00" : oprUpLimit), new BigDecimal(oprDownLimit == null ? "0.00" : oprDownLimit)});
        }
    }

    private Integer getSeq() {
        return new Integer(++this.seq);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateLastPlanningDate(Context ctx, IObjectValue regulationInfo, java.util.Date lastDate) throws CheckingPlanningException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sql = new StringBuffer();
        if (regulationInfo.getClass().equals(EquipmentCheckingRegulationInfo.class)) {
            EquipmentCheckingRegulationInfo equipmentCheckingRegulationInfo = (EquipmentCheckingRegulationInfo)regulationInfo;
            String equipmentCheckingRegulationId = equipmentCheckingRegulationInfo.getId().toString();
            java.util.Date lastPlanningDate = equipmentCheckingRegulationInfo.getLastPlanningTime();
            try {
                if (lastPlanningDate != null && GeneDateUtils.compareByDate((java.util.Date)lastDate, (java.util.Date)lastPlanningDate) < 0) return;
                sql.append("UPDATE T_EQM_EQUIPMENTCHECKREGULATION SET FLASTPLANNINGTIME =").append("to_date('").append(dateFormat.format(lastDate)).append("')").append(" WHERE FID = '").append(equipmentCheckingRegulationId).append("'");
                conn = EJBFactory.getConnection((Context)ctx);
                DbUtil.execute((Context)ctx, (String)sql.toString());
                return;
            }
            catch (SQLException e) {
                throw new CheckingPlanningException(CheckingPlanningException.UPDATELASTPLANNINGDATEERROR);
            }
            catch (ParseException e) {
                throw new CheckingPlanningException(CheckingPlanningException.UPDATEEQUIPMENTCHECKINGREGULATIONLASTPLANNINGDATEERROR);
            }
            catch (BOSException e) {
                throw new CheckingPlanningException(CheckingPlanningException.UPDATELASTPLANNINGDATEERROR);
            }
            finally {
                SQLUtils.cleanup(statement, conn);
            }
        }
        RouteCheckingRegulationInfo routeCheckingRegulationInfo = (RouteCheckingRegulationInfo)regulationInfo;
        String routeCheckingRegulationId = routeCheckingRegulationInfo.getId().toString();
        java.util.Date lastPlanningDate = routeCheckingRegulationInfo.getLastPlanningTime();
        try {
            if (lastPlanningDate != null && GeneDateUtils.compareByDate((java.util.Date)lastDate, (java.util.Date)lastPlanningDate) < 0) return;
            sql.append("UPDATE T_EQM_ROUTECHECKINGREGULATION SET FLASTPLANNINGTIME =").append("to_date('").append(dateFormat.format(lastDate)).append("')").append(" WHERE FID = '").append(routeCheckingRegulationId).append("'");
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            DbUtil.execute((Context)ctx, (String)sql.toString());
            return;
        }
        catch (SQLException e) {
            throw new CheckingPlanningException(CheckingPlanningException.UPDATELASTPLANNINGDATEERROR);
        }
        catch (ParseException e) {
            throw new CheckingPlanningException(CheckingPlanningException.UPDATEROUTECHECKINGREGULATIONLASTPLANNINGDATEERROR);
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.UPDATELASTPLANNINGDATEERROR);
        }
        finally {
            SQLUtils.cleanup(statement, conn);
        }
    }

    private void writeDataFromTempTableToEntityTable(Context ctx, String tempCheckingPlanTableName, String tempTaskTableName, String tempLogTableName) throws CheckingPlanningException {
        try {
            StringBuffer sql_insert = new StringBuffer();
            sql_insert.append("insert into T_EQM_CheckPlanning").append("(FMaintainGroupID,FLocationID,FMaintainRouteID,FShiftID,FTurns,FCpObject,FEquipmentID,FManagerID,FInputTime").append(",FMaintainDeptID,FPlanningTime,FStorageOrgUnitID,FBillStatus,FNumber,FDescription,FCpType,FMaintainOrgID").append(",FControlUnitID,FID,FExecutorID,FCreatorID,FCreateTime)").append(" select FMaintainGroupID,FLocationID,FMaintainRouteID,FShiftID,FTurns,FCpObject,FEquipmentID,FManagerID,FInputTime").append(",FMaintainDeptID,FPlanningTime,FStorageOrgUnitID,FBillStatus,FNumber,FDescription,FCpType,FMaintainOrgID").append(",FControlUnitID,FID,FExecutorID,FCreatorID,FCreateTime").append(" from ").append(tempCheckingPlanTableName);
            int defaultWarningConclusion = 10;
            StringBuffer sql_insertTask = new StringBuffer();
            sql_insertTask.append("insert into T_EQM_CheckPlanningCpTask").append("(FID,FSeq,FParentID,FAchievesID,FLocationID,FTaskDescription,FDemand").append(",FMontorID,FMeterType,FMeasureUnitID,FWarningFeatureValue,FWarnDownLimit,FWarnUpLimit,FOprDownLimit,FOprUpLimit,FWarningConclusion)").append(" select FID,Fseq,FParentID,FAchievesID,FLocationID,FTaskDescription,FDemand").append(",FTaskMeter,FMeterType,FUnitID,FCharacteristicValue,FwarningFloorLimit,FwarningTopLimit,FoperateFloorLimit,FoperateTopLimit,").append(defaultWarningConclusion).append(" from ").append(tempTaskTableName);
            StringBuffer sql_insertLog = new StringBuffer();
            sql_insertLog.append("insert into T_EQM_CheckPointLog").append("(FStorageOrgUnitID,FControlUnitID,FID,FCalcProcess,FRegulation,FMaintainorgID,FCheckPlanningID").append(",FPlaningTime,FEqmClassTeamID,FTurns,FEquipmentMaintain,FEquipmentLocation,FEquipmentArchives").append(",FPlanningEndTime,FPlanningStartTime,FCheckPointType,FCheckPointObject,FRunningStartTime,FRunningEndTime").append(",FExecutorID,FRegulationName,FNumber,FCheckPlannNumber)").append(" select FStorageOrgUnitID,FControlUnitID,FID,FCalcProcess,FRegulation,FMaintainorgID,FCheckPlanningID").append(",FPlaningTime,FEqmClassTeamID,FTurns,FEquipmentMaintain,FEquipmentLocation,FEquipmentArchives").append(",FPlanningEndTime,FPlanningStartTime,FCheckPointType,FCheckPointObject,FRunningStartTime,FRunningEndTime").append(",FExecutorID,FRegulationName,FNumber,FCheckPlannNumber").append(" from ").append(tempLogTableName);
            ArrayList<String> insertSqlList = new ArrayList<String>();
            insertSqlList.add(sql_insertTask.toString());
            insertSqlList.add(sql_insert.toString());
            insertSqlList.add(sql_insertLog.toString());
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, insertSqlList);
        }
        catch (BOSException e) {
            throw new CheckingPlanningException(CheckingPlanningException.WRITEDATAFROMTEMPTABLETOENTITYTABLEERROR);
        }
    }

    private String getResourceMsg(String key) {
        return GeneResourceUtil.getWithoutParameMsgForServer((String)CHECKINGPLANNINGFACADE_RESOURCE_PATH, (String)key);
    }

    private void writeLog(Context ctx, IObjectValue regulationInfo) throws BOSException {
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = null;
        String loginfo = null;
        String regulationid = null;
        String item = "";
        if (regulationInfo.getClass().equals(RouteCheckingRegulationInfo.class)) {
            RouteCheckingRegulationInfo routeCheckingRegulationInfo = (RouteCheckingRegulationInfo)regulationInfo;
            entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)routeCheckingRegulationInfo.getBOSType());
            loginfo = routeCheckingRegulationInfo.getLogInfo();
            regulationid = routeCheckingRegulationInfo.getId().toString();
            item = "eqm_RouteCheckingRegulation_generate";
        } else {
            EquipmentCheckingRegulationInfo equipmentCheckingRegulationInfo = (EquipmentCheckingRegulationInfo)regulationInfo;
            entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)equipmentCheckingRegulationInfo.getBOSType());
            loginfo = equipmentCheckingRegulationInfo.getLogInfo();
            regulationid = equipmentCheckingRegulationInfo.getId().toString();
            item = "eqm_EquipmentCheckingRegulation_generate";
        }
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", new Boolean(true));
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "generateCheckingPlanning");
        hashLog.put("FInstanceID", regulationid);
        hashLog.put("FInstanceNo", loginfo);
        hashLog.put("FItemName", item);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private String[] getNumbers(Context ctx, String storageOrgUnitID, int count) throws BOSException, EASBizException {
        CheckingPlanningInfo checkingPlanningInfo;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.getCodingRule((IObjectValue)(checkingPlanningInfo = new CheckingPlanningInfo()), storageOrgUnitID) == null) {
            return null;
        }
        String[] nums = codingRuleManager.getBatchNumber((IObjectValue)checkingPlanningInfo, storageOrgUnitID, count);
        return nums;
    }

    private java.util.Date findDateFromFactoryCalendar(Context ctx, java.util.Date date, int dayCount) throws BOSException, EASBizException {
        Date workDate = null;
        IRowSet rs = null;
        StringBuffer strBuffSql = new StringBuffer();
        strBuffSql.append("select FWorkDate from ").append(this.table_FactoryCalendarEntry);
        try {
            int currSeq = this.getWorkDateSeq(ctx, date);
            if (currSeq == 0) {
                return null;
            }
            strBuffSql.append(" where FWorkDateSeq = ").append(currSeq += dayCount);
            rs = DbUtil.executeQuery((Context)ctx, (String)strBuffSql.toString());
            if (!rs.next()) {
                return null;
            }
            workDate = rs.getDate("FWorkDate");
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        return workDate;
    }

    private int getWorkDateSeq(Context ctx, java.util.Date date) throws BOSException {
        int workSeq = 0;
        IRowSet rs = null;
        try {
            StringBuffer strBuffSql = new StringBuffer();
            strBuffSql.append("select max(FWorkDateSeq) as FWorkDateSeq from ").append(this.table_FactoryCalendarEntry).append(" where FDateType = 1 ");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String workDate = df.format(date);
            strBuffSql.append("and FWorkDate <= {d'").append(workDate).append("'}");
            rs = DbUtil.executeQuery((Context)ctx, (String)strBuffSql.toString());
            if (rs.next()) {
                workSeq = rs.getInt("FWorkDateSeq");
            }
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        return workSeq;
    }

    private boolean isWorkDay(Context ctx, java.util.Date date) throws BOSException, EASBizException {
        boolean isYes = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String workDate = year + "-" + month + "-" + day;
        StringBuffer strBuffSql = new StringBuffer();
        strBuffSql.append("select FDateType from ").append(this.table_FactoryCalendarEntry).append(" where FWorkDate = {d'").append(workDate).append("'} ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuffSql.toString());
        try {
            int dateType;
            if (rs.next() && (dateType = rs.getInt("FDateType")) == 1) {
                isYes = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        return isYes;
    }

    private Date transUtilDate2FormatSqlDate(java.util.Date date, Format dateFormat) {
        Date sqlDate = new Date(date.getTime());
        return sqlDate;
    }

    private Timestamp transFormatSqlTimestamp(Timestamp time, Format dateFormat) {
        Timestamp timestamp = new Timestamp(time.getTime());
        return timestamp;
    }
}

