/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetRestrictCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetRestrictFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetRestrictInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprRestrictCollection;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprRestrictFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprRestrictInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentStaOprAssetRestrict;
import com.kingdee.eas.eqm.basedata.IEquipmentStaOprRestrict;
import com.kingdee.eas.eqm.planning.EQMCalendarTypeEnum;
import com.kingdee.eas.eqm.planning.EQMStrategyLevelEnum;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyInfo;
import com.kingdee.eas.eqm.planning.app.AbstractRestrainHandleFacadeControllerBean;
import com.kingdee.eas.eqm.planning.app.IStandardOperationRestrict;
import com.kingdee.eas.eqm.planning.app.SORestrictAdapter;
import com.kingdee.eas.eqm.planning.app.SORestrictSpecialAdapter;
import com.kingdee.eas.eqm.planning.app.verify.DAGValidator;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RestrainHandleFacadeControllerBean
extends AbstractRestrainHandleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.app.RestrainHandleFacadeControllerBean");
    private static final Format dateFormat = BOSLocaleUtil.getDateFormat();

    private Date addDays(Context ctx, Date date, int days, EQMCalendarTypeEnum dateType, String storageOrgUnitId) throws BOSException, EASBizException {
        Date result = null;
        if (EQMCalendarTypeEnum.WORKCALENDAR == dateType) {
            IFactoryCalendar c = FactoryCalendarFactory.getLocalInstance((Context)ctx);
            result = c.findDateFromFCalendar(storageOrgUnitId, date, 1, days, 2);
        } else {
            result = DateTimeUtils.addDay((Date)date, (long)days);
        }
        return result;
    }

    private Date subtractDays(Context ctx, Date date, int days, EQMCalendarTypeEnum dateType, String storageOrgUnitId) throws BOSException, EASBizException {
        return this.addDays(ctx, date, -days, dateType, storageOrgUnitId);
    }

    @Override
    protected boolean _checkRestrain(Context ctx, IObjectValue standardOperation, IObjectValue asset, Date planDate, Date sameStrtgFromDate, Date sameStrtgToDate, boolean isMain, String tempTableName, EQMCalendarTypeEnum dateType, IObjectValue strategy) throws BOSException, EASBizException {
        PreMaintainStrategyInfo strategyInfo = (PreMaintainStrategyInfo)strategy;
        boolean isLocation = false;
        String assetId = null;
        if (asset instanceof EquipmentArchivesInfo) {
            isLocation = false;
            assetId = ((EquipmentArchivesInfo)asset).getId().toString();
        } else if (asset instanceof EquipmentLocationInfo) {
            isLocation = true;
            assetId = ((EquipmentLocationInfo)asset).getId().toString();
        } else {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"2_RestrainHandleFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        boolean result = false;
        EquipmentStandardOperationInfo standardOperationInfo = this.reloadStandardOperation(ctx, standardOperation);
        List restrains = this.getBeRestrainList(ctx, (IObjectValue)standardOperationInfo, asset);
        result = this.existWorkOrderFromRestrictStandardOperations(ctx, planDate, isMain, dateType, strategyInfo, isLocation, assetId, restrains, "T_EQM_WorkOrder");
        if (result) {
            return result;
        }
        result = this.existWorkOrderFromRestrictStandardOperations(ctx, planDate, isMain, dateType, strategyInfo, isLocation, assetId, restrains, tempTableName);
        if (result) {
            return result;
        }
        return false;
    }

    private boolean existWorkOrderFromRestrictStandardOperations(Context ctx, Date planDate, boolean isMain, EQMCalendarTypeEnum dateType, PreMaintainStrategyInfo strategyInfo, boolean isLocation, String assetId, List restrains, String tableName) throws BOSException, EASBizException {
        for (int i = 0; i < restrains.size(); ++i) {
            IStandardOperationRestrict restric = (IStandardOperationRestrict)restrains.get(i);
            Date negative = this.subtractDays(ctx, planDate, restric.getPositiveInterval(), dateType, strategyInfo.getStorageOrgUnit().getId().toString());
            Date positive = this.addDays(ctx, planDate, restric.getNegativeInterval(), dateType, strategyInfo.getStorageOrgUnit().getId().toString());
            EquipmentStandardOperationInfo sourceOperation = restric.getSourceStandardOperation();
            StringBuffer query = new StringBuffer();
            query.append("select FID from ").append(tableName).append(" AS WO ");
            query.append(" where fstandardOpID = '").append(sourceOperation.getId()).append("' and ");
            if (isLocation) {
                query.append("fEqmLocationID='").append(assetId).append("'");
            } else {
                query.append("fEquipmentArchivesID='");
                query.append(assetId);
                query.append("'");
            }
            query.append(" and FPlanStartTime <= to_date('").append(dateFormat.format(positive)).append("')");
            query.append(" and FPlanStartTime >= to_date('").append(dateFormat.format(negative)).append("')");
            query.append(" and FBillStatus <> ").append(60);
            if (strategyInfo.getStrategyLevel() == EQMStrategyLevelEnum.TOP && isMain) {
                query.append(" and FID=FSuperParentID");
            } else if (strategyInfo.getStrategyLevel() == EQMStrategyLevelEnum.TOP && !isMain) {
                query.append(" and (FID<>FSuperParentID and FParentID=FSuperParentID").append(" and FParentID in (select fid from ").append(tableName).append(" where fid = fSuperparentID and fstandardOpID is null))");
            } else if (strategyInfo.getStrategyLevel() == EQMStrategyLevelEnum.DOWN && isMain) {
                query.append(" and FID=FSuperParentID");
            }
            IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)query.toString());
            if (reqRow.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean existDownWorkOrderFromStrategy(Context ctx, Date sameStrtgFromDate, Date sameStrtgToDate, boolean isMain, PreMaintainStrategyInfo strategyInfo, String tableName) throws BOSException {
        StringBuffer strb = new StringBuffer();
        strb.append("select FID from ").append(tableName).append(" AS WO ");
        strb.append(" where  FID<>FSuperParentID and FPmstrategyID='").append(strategyInfo.getId()).append("'");
        strb.append(" and FParentID<>FSuperParentID ");
        strb.append(" and FPlanStartTime<=to_date('").append(dateFormat.format(sameStrtgToDate)).append("')");
        strb.append(" and FPlanStartTime>=to_date('").append(dateFormat.format(sameStrtgFromDate)).append("')");
        strb.append(" and FBillStatus<>").append(60);
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)strb.toString());
        return reqRow.size() > 0;
    }

    @Override
    protected List _sortStandardOperation(Context ctx, List standardOperations, IObjectValue asset) throws BOSException {
        DAGValidator dagValidator = this.buildDAGData(ctx, standardOperations, asset);
        List nodes = dagValidator.sort();
        return this.findOperationListByNodeList(standardOperations, nodes);
    }

    private List findOperationListByNodeList(List standardOperations, List nodes) {
        ArrayList<EquipmentStandardOperationInfo> resultList = new ArrayList<EquipmentStandardOperationInfo>();
        for (int i = 0; i < nodes.size(); ++i) {
            DAGValidator.Node node = (DAGValidator.Node)nodes.get(i);
            resultList.add(this.getSandardOperationById(node.getKey(), standardOperations));
        }
        return resultList;
    }

    private DAGValidator buildDAGData(Context ctx, List standardOperations, IObjectValue asset) throws BOSException {
        DAGValidator dagValidator = new DAGValidator();
        for (int i = 0; i < standardOperations.size(); ++i) {
            EquipmentStandardOperationInfo infoVo = (EquipmentStandardOperationInfo)standardOperations.get(i);
            EquipmentStandardOperationInfo info = null;
            try {
                info = this.reloadStandardOperation(ctx, (IObjectValue)infoVo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            if (info == null || info.getId() == null) continue;
            dagValidator.addNode(info.getId().toString(), info.getName());
            for (int j = 0; j < standardOperations.size(); ++j) {
                if (i == j) continue;
                EquipmentStandardOperationInfo otherInfoVo = (EquipmentStandardOperationInfo)standardOperations.get(j);
                EquipmentStandardOperationInfo otherInfo = null;
                try {
                    otherInfo = this.reloadStandardOperation(ctx, (IObjectValue)otherInfoVo);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                if (otherInfo == null || otherInfo.getId() == null || !this.isRestrict(info, asset, otherInfo)) continue;
                dagValidator.addArc(otherInfo.getId().toString(), info.getId().toString());
            }
        }
        return dagValidator;
    }

    private EquipmentStandardOperationInfo getSandardOperationById(String id, List standardOperations) {
        EquipmentStandardOperationInfo result = null;
        for (int i = 0; i < standardOperations.size(); ++i) {
            EquipmentStandardOperationInfo info = (EquipmentStandardOperationInfo)standardOperations.get(i);
            if (!info.getId().toString().equals(id)) continue;
            return info;
        }
        return result;
    }

    private boolean isRestrict(EquipmentStandardOperationInfo sourceOperation, IObjectValue asset, EquipmentStandardOperationInfo targetOperation) {
        if (this.restrictBySpecial(sourceOperation, asset, targetOperation) == 1) {
            return true;
        }
        if (this.restrictBySpecial(sourceOperation, asset, targetOperation) == -1) {
            return false;
        }
        return this.isValidByRestrict(sourceOperation, targetOperation);
    }

    private boolean isValidByRestrict(EquipmentStandardOperationInfo sourceOperation, EquipmentStandardOperationInfo targetOperation) {
        EquipmentStaOprRestrictCollection restricts = targetOperation.getRestricts();
        for (int j = 0; j < restricts.size(); ++j) {
            EquipmentStaOprRestrictInfo restrict = restricts.get(j);
            if (!restrict.isValid() || !restrict.getStaopr().getId().equals((Object)sourceOperation.getId())) continue;
            return true;
        }
        return false;
    }

    private int restrictBySpecial(EquipmentStandardOperationInfo sourceOperation, IObjectValue asset, EquipmentStandardOperationInfo targetOperation) {
        EquipmentStaOprAssetCollection assets = targetOperation.getAssets();
        EquipmentStaOprAssetInfo assetInfo = this.getStaOprAsset(asset, assets);
        if (assetInfo == null) {
            return 0;
        }
        for (int i = 0; i < assetInfo.getAssetRestricts().size(); ++i) {
            EquipmentStaOprAssetRestrictInfo restrict = assetInfo.getAssetRestricts().get(i);
            if (sourceOperation.getId().equals((Object)restrict.getStaopr().getId()) && restrict.isValid()) {
                return 1;
            }
            if (!sourceOperation.getId().equals((Object)restrict.getStaopr().getId()) || restrict.isValid()) continue;
            return -1;
        }
        return 0;
    }

    private EquipmentStaOprAssetInfo getStaOprAsset(IObjectValue asset, EquipmentStaOprAssetCollection assets) {
        EquipmentStaOprAssetInfo resultAsset = null;
        for (int i = 0; i < assets.size(); ++i) {
            EquipmentStaOprAssetInfo assetInfo = assets.get(i);
            if (asset instanceof EquipmentArchivesInfo && assetInfo.getEquipmentArchives() != null) {
                if (!((EquipmentArchivesInfo)asset).getId().equals((Object)assetInfo.getEquipmentArchives().getId())) break;
                resultAsset = assetInfo;
                break;
            }
            if (!(asset instanceof EquipmentLocationInfo) || assetInfo.getEquipmentLocation() == null) continue;
            if (!((EquipmentLocationInfo)asset).getId().equals((Object)assetInfo.getEquipmentLocation().getId())) break;
            resultAsset = assetInfo;
            break;
        }
        return resultAsset;
    }

    @Override
    protected List _getBeRestrainList(Context ctx, IObjectValue standardOperation, IObjectValue asset) throws BOSException, EASBizException {
        ArrayList<IStandardOperationRestrict> results = new ArrayList<IStandardOperationRestrict>();
        EquipmentStandardOperationInfo currentStandardOperationInfo = this.reloadStandardOperation(ctx, standardOperation);
        String assetId = asset.get("id").toString();
        IEquipmentStaOprAssetRestrict iAssetRestrict = EquipmentStaOprAssetRestrictFactory.getLocalInstance((Context)ctx);
        EntityViewInfo restrictView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        restrictView.setFilter(filter);
        FilterItemInfo item = new FilterItemInfo("staopr.id", (Object)currentStandardOperationInfo.getId().toString());
        filter.getFilterItems().add(item);
        if (asset instanceof EquipmentArchivesInfo) {
            item = new FilterItemInfo("asset.equipmentArchives.id", (Object)assetId);
            filter.getFilterItems().add(item);
        } else if (asset instanceof EquipmentLocationInfo) {
            item = new FilterItemInfo("asset.equipmentLocation.id", (Object)assetId);
            filter.getFilterItems().add(item);
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        restrictView.setSelector(selectors);
        selectors.add(new SelectorItemInfo("positiveinterval"));
        selectors.add(new SelectorItemInfo("negativeinterval"));
        selectors.add(new SelectorItemInfo("valid"));
        selectors.add(new SelectorItemInfo("asset.*"));
        selectors.add(new SelectorItemInfo("asset.standardOperation.*"));
        EquipmentStaOprAssetRestrictCollection assetRestricts = iAssetRestrict.getEquipmentStaOprAssetRestrictCollection(restrictView);
        for (int i = 0; i < assetRestricts.size(); ++i) {
            EquipmentStaOprAssetRestrictInfo info = assetRestricts.get(i);
            if (!info.isValid()) continue;
            results.add(new SORestrictSpecialAdapter(info));
        }
        IEquipmentStaOprRestrict iRestrict = EquipmentStaOprRestrictFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = this.buildRestrictStandardOperationView(currentStandardOperationInfo);
        EquipmentStaOprRestrictCollection restricts = iRestrict.getEquipmentStaOprRestrictCollection(view);
        for (int i = 0; i < restricts.size(); ++i) {
            EquipmentStaOprRestrictInfo info = restricts.get(i);
            if (!info.isValid()) continue;
            boolean noSpecil = true;
            for (int j = 0; j < assetRestricts.size(); ++j) {
                EquipmentStaOprAssetRestrictInfo special = assetRestricts.get(j);
                if (!special.getAsset().getStandardOperation().getId().equals((Object)info.getStandardOperation().getId())) continue;
                noSpecil = false;
                break;
            }
            if (!noSpecil) continue;
            results.add(new SORestrictAdapter(info));
        }
        return results;
    }

    private EntityViewInfo buildRestrictStandardOperationView(EquipmentStandardOperationInfo currentStandardOperationInfo) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("staopr.id", (Object)currentStandardOperationInfo.getId().toString());
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    @Override
    protected List _getRestrainList(Context ctx, IObjectValue standardOperation, IObjectValue asset) throws BOSException, EASBizException {
        EquipmentStaOprAssetRestrictInfo info;
        int i;
        ArrayList<IStandardOperationRestrict> results = new ArrayList<IStandardOperationRestrict>();
        EquipmentStandardOperationInfo standardOperationInfo = this.reloadStandardOperation(ctx, standardOperation);
        EquipmentStaOprAssetInfo assetInfo = this.getStaOprAsset(asset, standardOperationInfo.getAssets());
        if (assetInfo != null) {
            for (i = 0; i < assetInfo.getAssetRestricts().size(); ++i) {
                info = assetInfo.getAssetRestricts().get(i);
                if (!info.isValid()) continue;
                results.add(new SORestrictSpecialAdapter(info));
            }
        }
        for (i = 0; i < standardOperationInfo.getRestricts().size(); ++i) {
            info = standardOperationInfo.getRestricts().get(i);
            if (!info.isValid() || this.restrictBySpecial(info.getStaopr(), asset, standardOperationInfo) != 0) continue;
            results.add(new SORestrictAdapter((EquipmentStaOprRestrictInfo)info));
        }
        return results;
    }

    private EquipmentStandardOperationInfo reloadStandardOperation(Context ctx, IObjectValue standardOperation) throws BOSException, EASBizException {
        EquipmentStandardOperationInfo standardOperationInfo = (EquipmentStandardOperationInfo)standardOperation;
        ObjectUuidPK pk = new ObjectUuidPK(standardOperationInfo.getId());
        standardOperationInfo = EquipmentStandardOperationFactory.getLocalInstance((Context)ctx).getEquipmentStandardOperationInfo((IObjectPK)pk, this.getStandardOperationSelectors());
        return standardOperationInfo;
    }

    private SelectorItemCollection getStandardOperationSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("restricts.id"));
        selectors.add(new SelectorItemInfo("restricts.valid"));
        selectors.add(new SelectorItemInfo("restricts.negativeInterval"));
        selectors.add(new SelectorItemInfo("restricts.positiveInterval"));
        selectors.add(new SelectorItemInfo("restricts.staopr.id"));
        selectors.add(new SelectorItemInfo("assets.id"));
        selectors.add(new SelectorItemInfo("assets.name"));
        selectors.add(new SelectorItemInfo("assets.equipmentArchives.id"));
        selectors.add(new SelectorItemInfo("assets.equipmentArchives.name"));
        selectors.add(new SelectorItemInfo("assets.equipmentLocation.id"));
        selectors.add(new SelectorItemInfo("assets.equipmentLocation.name"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.id"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.valid"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.negativeInterval"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.positiveInterval"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.asset.id"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.asset.equipmentLocation.id"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.asset.equipmentLocation.name"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.asset.equipmentArchives.id"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.asset.equipmentArchives.name"));
        selectors.add(new SelectorItemInfo("assets.assetRestricts.staopr.id"));
        return selectors;
    }

    @Override
    protected List _findStandardOperationListNotBeRestricted(Context ctx, List standardOperations, IObjectValue asset) throws BOSException, EASBizException {
        DAGValidator dagValidator = this.buildDAGData(ctx, standardOperations, asset);
        List nodes = dagValidator.getRootNodes();
        return this.findOperationListByNodeList(standardOperations, nodes);
    }

    @Override
    protected boolean _checkRestrain(Context ctx, IObjectValue soruceStaOpr, IObjectValue targetStaOpr, IObjectValue asset) throws BOSException {
        try {
            EquipmentStandardOperationInfo s1 = this.reloadStandardOperation(ctx, soruceStaOpr);
            EquipmentStandardOperationInfo s2 = this.reloadStandardOperation(ctx, targetStaOpr);
            return this.isRestrict(s1, asset, s2);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            return false;
        }
    }
}

