/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.CountTypeEnum;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.common.core.util.GeneFilterUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.planning.BaseDateFrequencyEntryCollection;
import com.kingdee.eas.eqm.planning.BaseDateFrequencyEntryInfo;
import com.kingdee.eas.eqm.planning.BaseMeterFrequencyEntryCollection;
import com.kingdee.eas.eqm.planning.BaseMeterFrequencyEntryInfo;
import com.kingdee.eas.eqm.planning.BaseSpecifyDateEntryCollection;
import com.kingdee.eas.eqm.planning.BaseSpecifyDateEntryInfo;
import com.kingdee.eas.eqm.planning.EQMCalendarTypeEnum;
import com.kingdee.eas.eqm.planning.EQMPlanningException;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyFactory;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyInfo;
import com.kingdee.eas.eqm.planning.PreMaintainStrategySeqItemInfo;
import com.kingdee.eas.eqm.planning.app.AbstractStrategyDateHandleFacadeControllerBean;
import com.kingdee.eas.eqm.planning.app.DateUtils;
import com.kingdee.eas.eqm.planning.util.PMUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StrategyDateHandleFacadeControllerBean
extends AbstractStrategyDateHandleFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.app.StrategyDateHandleFacadeControllerBean");
    private static int DAYSPERWEEK = 7;
    private static int DAYSPERMONTH = 30;
    private static int DAYSPERYEAR = 365;
    public static final String KDTMETERREADING_ID = "id";
    public static final String KDTMETERREADING_METERID = "meter.id";
    public static final String KDTMETERREADING_METERNUMBER = "meter.number";
    public static final String KDTMETERREADING_METERNAME = "meter.name";
    public static final String KDTMETERREADING_DAYAVERAGEVALUE = "dayAverageValue";
    public static final String KDTMETERREADING_READINGDATE = "readingDate";
    public static final String KDTMETERREADING_CURRENTVALUE = "currentValue";
    public static final String KDTMETERREADING_averageCalWAY = "averageCalWay";
    private static final Format dateFormat = BOSLocaleUtil.getDateFormat();

    @Override
    protected Map _getFirstDateFromDateEntry(Context ctx, IObjectValue msInfo, IObjectValue msoInfo, java.util.Date startDate, java.util.Date endDate, boolean isSeq) throws BOSException, EASBizException {
        BaseDateFrequencyEntryCollection seqColl;
        Map rtnMap;
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)msInfo;
        PreMaintainStrategySeqItemInfo pmsoInfo = (PreMaintainStrategySeqItemInfo)msoInfo;
        String id = "";
        boolean isLocation = false;
        if (pmsInfo.getArchives() != null) {
            id = pmsInfo.getArchives().getId().toString();
            isLocation = false;
        } else {
            id = pmsInfo.getLocation().getId().toString();
            isLocation = true;
        }
        java.util.Date woDate = this.getLastWorkOrderDate(ctx, (IObjectValue)pmsoInfo.getStandardOperation(), id, isLocation, isSeq, startDate);
        int frqTimes = pmsoInfo.getFrequencyTimes();
        if (woDate == null) {
            woDate = startDate;
        }
        if ((rtnMap = this.getNextDate(ctx, seqColl = pmsInfo.getDateSeqEntry(), woDate, frqTimes, pmsInfo.getStorageOrgUnit().getId().toString(), pmsInfo.getCalendarType())) == null) {
            return null;
        }
        java.util.Date rtnDate = (java.util.Date)rtnMap.keySet().iterator().next();
        if (rtnDate == null) {
            return null;
        }
        return rtnMap;
    }

    @Override
    protected List _getAllDateListFromDateEntry(Context ctx, IObjectValue msInfo, IObjectValue msoInfo, Map firstWODateMap, java.util.Date endDate, boolean isSeq) throws BOSException, EASBizException {
        Map rtnMap;
        ArrayList<Map> rtnLst = new ArrayList<Map>();
        rtnLst.add(firstWODateMap);
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)msInfo;
        PreMaintainStrategySeqItemInfo pmsoInfo = (PreMaintainStrategySeqItemInfo)msoInfo;
        java.util.Date rtnDate = null;
        int frqTimes = pmsoInfo.getFrequencyTimes();
        BaseDateFrequencyEntryCollection seqColl = pmsInfo.getDateSeqEntry();
        rtnDate = (java.util.Date)firstWODateMap.keySet().iterator().next();
        while (DateUtils.beforeOrSame(rtnDate, endDate) && (rtnMap = this.getNextDate(ctx, seqColl, rtnDate, frqTimes, pmsInfo.getStorageOrgUnit().getId().toString(), pmsInfo.getCalendarType())) != null && (rtnDate = (java.util.Date)rtnMap.keySet().iterator().next()) != null) {
            if (!DateUtils.beforeOrSame(rtnDate, endDate)) continue;
            rtnLst.add(rtnMap);
        }
        return rtnLst;
    }

    private Map getNextDate(Context ctx, BaseDateFrequencyEntryCollection seqColl, java.util.Date cptDate, int frqTimes, String storage, EQMCalendarTypeEnum ctEnum) throws BOSException, EASBizException {
        BaseDateFrequencyEntryInfo interval = this._findIntervalDateIn(cptDate, seqColl);
        if (interval == null) {
            interval = this._findIntervalDateMostNear(cptDate, seqColl);
        }
        if (interval == null) {
            return null;
        }
        int offset = this.caculateOffset(frqTimes, interval);
        java.util.Date nextDate = this.getDateByCanlandar(ctx, cptDate, storage, ctEnum, offset);
        HashMap<java.util.Date, Integer> result = new HashMap<java.util.Date, Integer>();
        result.put(nextDate, new Integer((int)Math.floor((double)(interval.getInterval() * this.getDays(interval) * frqTimes) / 2.0)));
        return result;
    }

    private BaseDateFrequencyEntryInfo _findIntervalDateIn(java.util.Date date, BaseDateFrequencyEntryCollection intervals) {
        BaseDateFrequencyEntryInfo result = null;
        for (int i = 0; i < intervals.size(); ++i) {
            BaseDateFrequencyEntryInfo it = intervals.get(i);
            if (!DateUtils.afterOrSame(date, it.getFromDate()) || !DateUtils.beforeOrSame(date, it.getToDate())) continue;
            result = it;
            break;
        }
        return result;
    }

    private BaseDateFrequencyEntryInfo _findIntervalDateMostNear(java.util.Date date, BaseDateFrequencyEntryCollection intervals) {
        List intervalList = this.getSortedListByFromDate(intervals);
        for (BaseDateFrequencyEntryInfo it : intervalList) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (!sdf.parse(dateFormat.format(date)).before(sdf.parse(dateFormat.format(it.getFromDate())))) continue;
                return it;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List getSortedListByFromDate(BaseDateFrequencyEntryCollection intervals) {
        ArrayList<BaseDateFrequencyEntryInfo> intervalList = new ArrayList<BaseDateFrequencyEntryInfo>();
        for (int i = 0; i < intervals.size(); ++i) {
            intervalList.add(intervals.get(i));
        }
        Collections.sort(intervalList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                BaseDateFrequencyEntryInfo it1 = (BaseDateFrequencyEntryInfo)obj1;
                BaseDateFrequencyEntryInfo it2 = (BaseDateFrequencyEntryInfo)obj2;
                if (Date.valueOf(dateFormat.format(it1.getFromDate())).before(Date.valueOf(dateFormat.format(it2.getFromDate())))) {
                    return -1;
                }
                if (Date.valueOf(dateFormat.format(it1.getFromDate())).after(Date.valueOf(dateFormat.format(it2.getFromDate())))) {
                    return 1;
                }
                return 0;
            }
        });
        return intervalList;
    }

    private int caculateOffset(int frqTimes, BaseDateFrequencyEntryInfo interval) {
        int offset = interval.getInterval() * frqTimes * this.getDays(interval);
        return offset;
    }

    private java.util.Date getDateByCanlandar(Context ctx, java.util.Date startDate, String storage, EQMCalendarTypeEnum ctEnum, int offset) throws BOSException, EASBizException {
        if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
            Calendar cp = Calendar.getInstance();
            cp.setTime(startDate);
            cp.add(5, offset);
            return cp.getTime();
        }
        java.util.Date date = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storage, startDate, 1, offset, 2);
        this.validFactoryDate(ctx, date, storage);
        return date;
    }

    private int getDays(BaseDateFrequencyEntryInfo interval) {
        int days = 0;
        switch (interval.getDateUnit().getValue()) {
            case 10: {
                days = 1;
                break;
            }
            case 20: {
                days = DAYSPERWEEK;
                break;
            }
            case 30: {
                days = DAYSPERMONTH;
                break;
            }
            case 40: {
                days = DAYSPERYEAR;
            }
        }
        return days;
    }

    private List groupMeterEntries(BaseMeterFrequencyEntryCollection meterEntryCollection) {
        return null;
    }

    @Override
    protected Map _getFirstDateFromMeterEntry(Context ctx, IObjectValue msInfo, IObjectValue soEntryInfo, java.util.Date startDate, java.util.Date endDate, String id, boolean isLocation, boolean isSeq, boolean needGetLastWO, Object[] lastMeterMap) throws BOSException, EASBizException {
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)msInfo;
        HashMap<String, Object[]> rtnMap = new HashMap<String, Object[]>();
        HashMap meterMap = new HashMap();
        HashMap multiMeterMap = new HashMap();
        java.util.Date nextDate = null;
        java.util.Date minDate = null;
        java.util.Date maxDate = null;
        Object assetInfo = null;
        assetInfo = pmsInfo.getArchives() != null ? pmsInfo.getArchives() : pmsInfo.getLocation();
        String storage = pmsInfo.getStorageOrgUnit().getId().toString();
        EQMCalendarTypeEnum ctEnum = pmsInfo.getCalendarType();
        PreMaintainStrategySeqItemInfo seqInfo = (PreMaintainStrategySeqItemInfo)soEntryInfo;
        int frqTimes = seqInfo.getFrequencyTimes();
        List meterColl = pmsInfo.getMeterEntryItems();
        List sortedMeterEntryItems = pmsInfo.getMeterEntryItems();
        block4: for (int i = 0; i < meterColl.size(); ++i) {
            Calendar cp;
            BaseMeterFrequencyEntryInfo meterInfo = (BaseMeterFrequencyEntryInfo)sortedMeterEntryItems.get(i);
            if (meterInfo.getMeter().getCountType() == CountTypeEnum.value) continue;
            String meterID = meterInfo.getMeter().getId().toString();
            int interval = meterInfo.getInterval();
            if (!meterMap.containsKey(meterID)) {
                BigDecimal dayAvg = this.getAvgValueFromMeter(ctx, meterID, meterInfo.getMeter().getName(), (IObjectValue)assetInfo);
                if (lastMeterMap != null && lastMeterMap[0] != null && lastMeterMap[1] != null) {
                    Map dMap = this.getLastEstimateInfoNoWO(ctx, (IObjectValue)assetInfo, storage, startDate, ctEnum, meterInfo, dayAvg, frqTimes, lastMeterMap);
                    if (dMap == null) continue;
                    meterMap.putAll(dMap);
                } else if (lastMeterMap == null || lastMeterMap[0] == null) {
                    Map dMap;
                    List woLst = new ArrayList();
                    if (needGetLastWO) {
                        woLst = this.getLastWorkOrderColumnValue(ctx, (IObjectValue)seqInfo.getStandardOperation(), id, isLocation, isSeq, startDate, new String[]{"fID", "FLastDate"});
                    }
                    java.util.Date woPlanDate = null;
                    String woID = null;
                    if (woLst.size() > 0) {
                        woID = (String)woLst.get(0);
                    }
                    woPlanDate = woLst.size() == 0 || woLst.get(1) == null ? startDate : (java.util.Date)woLst.get(1);
                    if (woID != null) {
                        dMap = this.getLastEstimateInfoWithWO(ctx, (IObjectValue)assetInfo, storage, woID, woPlanDate, ctEnum, meterInfo, dayAvg, frqTimes);
                        if (dMap == null) continue;
                        meterMap.putAll(dMap);
                    } else {
                        dMap = this.getLastEstimateInfoNoWO(ctx, (IObjectValue)assetInfo, storage, woPlanDate, ctEnum, meterInfo, dayAvg, frqTimes, null);
                        if (dMap == null) continue;
                        meterMap.putAll(dMap);
                    }
                }
            }
            if (rtnMap.containsKey(meterID) || multiMeterMap.containsKey(meterID)) continue;
            Object[] mtApp = (Object[])meterMap.get(meterID);
            java.util.Date lastWODate = (java.util.Date)mtApp[0];
            BigDecimal lastWORead = (BigDecimal)mtApp[1];
            BigDecimal avgValue = (BigDecimal)mtApp[2];
            CountTypeEnum countType = (CountTypeEnum)mtApp[3];
            BigDecimal nextReading = null;
            BigDecimal lastWOReading = null;
            int days = (int)Math.floor(new BigDecimal(frqTimes * interval).doubleValue() / avgValue.doubleValue());
            int seconds = (int)Math.floor(new BigDecimal(frqTimes * interval).doubleValue() / avgValue.doubleValue() * 86400.0);
            nextReading = countType == CountTypeEnum.up ? lastWORead.add(new BigDecimal(interval * frqTimes)) : lastWORead.subtract(new BigDecimal(interval * frqTimes));
            if (days < 1) {
                if (lastWOReading != null) {
                    if (countType == CountTypeEnum.up && nextReading.compareTo(lastWOReading) > 0) {
                        lastWOReading = lastWOReading.add(avgValue);
                    } else if (countType == CountTypeEnum.down && nextReading.compareTo(lastWOReading) < 0) {
                        lastWOReading = lastWOReading.subtract(avgValue);
                    }
                } else if (lastWOReading == null) {
                    if (countType == CountTypeEnum.up) {
                        lastWOReading = lastWORead.add(avgValue);
                    } else if (countType == CountTypeEnum.down) {
                        lastWOReading = lastWORead.subtract(avgValue);
                    }
                }
            }
            if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                cp = Calendar.getInstance();
                cp.setTime(lastWODate);
                cp.add(5, days);
                nextDate = cp.getTime();
            } else {
                nextDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storage, lastWODate, 1, days, 2);
                this.validFactoryDate(ctx, nextDate, storage);
            }
            if (days < 1 && seconds > 0) {
                cp = Calendar.getInstance();
                cp.setTime(lastWODate);
                cp.add(13, seconds);
                nextDate = cp.getTime();
            }
            if (nextDate == null || DateUtils.after(nextDate, endDate)) break;
            switch (pmsInfo.getSequenceFireRule().getValue()) {
                case 10: {
                    if (minDate == null) {
                        minDate = nextDate;
                        rtnMap.put(meterID, new Object[]{nextDate, nextReading, avgValue, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue.doubleValue() / 2.0)), lastWOReading});
                        continue block4;
                    }
                    if (nextDate.before(minDate)) {
                        rtnMap.clear();
                        minDate = nextDate;
                        rtnMap.put(meterID, new Object[]{nextDate, nextReading, avgValue, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue.doubleValue() / 2.0)), lastWOReading});
                        continue block4;
                    }
                    multiMeterMap.put(meterID, null);
                    continue block4;
                }
                case 20: {
                    if (maxDate == null) {
                        maxDate = nextDate;
                        rtnMap.put(meterID, new Object[]{nextDate, nextReading, avgValue, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue.doubleValue() / 2.0)), lastWOReading});
                        continue block4;
                    }
                    if (!nextDate.before(maxDate)) {
                        rtnMap.clear();
                        maxDate = nextDate;
                        rtnMap.put(meterID, new Object[]{nextDate, nextReading, avgValue, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue.doubleValue() / 2.0)), lastWOReading});
                        continue block4;
                    }
                    multiMeterMap.put(meterID, null);
                }
            }
        }
        return rtnMap;
    }

    private EquipmentMeterApplyInfo getLastReadingOfMeter(Context ctx, String meterID, IObjectValue assetInfo) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (assetInfo instanceof EquipmentArchivesInfo) {
            filter.getFilterItems().add(new FilterItemInfo("equipment.id", (Object)((EquipmentArchivesInfo)assetInfo).getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("location.id", (Object)((EquipmentLocationInfo)assetInfo).getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo(KDTMETERREADING_METERID, (Object)meterID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(KDTMETERREADING_READINGDATE, null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo(KDTMETERREADING_CURRENTVALUE, (Object)new BigDecimal(0), CompareType.GREATER));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(KDTMETERREADING_ID);
        sic.add(KDTMETERREADING_DAYAVERAGEVALUE);
        sic.add(KDTMETERREADING_READINGDATE);
        sic.add(KDTMETERREADING_CURRENTVALUE);
        sic.add(KDTMETERREADING_averageCalWAY);
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
        viewInfo.setSelector(sic);
        SorterItemCollection sorterCollection = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo(KDTMETERREADING_READINGDATE);
        sortItemInfo.setSortType(SortType.DESCEND);
        sorterCollection.add(sortItemInfo);
        viewInfo.setSorter(sorterCollection);
        CoreBaseCollection c = EquipmentMeterApplyFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (c.size() > 0) {
            return (EquipmentMeterApplyInfo)c.get(0);
        }
        return null;
    }

    private Map getLastEstimateInfoWithWO(Context ctx, IObjectValue assetInfo, String storageOrgUnitID, String woID, java.util.Date woPlanDate, EQMCalendarTypeEnum ctEnum, BaseMeterFrequencyEntryInfo meterInfo, BigDecimal dayAvg, int frqTimes) throws BOSException, EASBizException {
        HashMap<String, Object[]> meterMap = new HashMap<String, Object[]>();
        EquipmentMeterInfo equipMeterInfo = meterInfo.getMeter();
        String meterID = equipMeterInfo.getId().toString();
        CountTypeEnum countType = equipMeterInfo.getCountType();
        BigDecimal lastReading = this.getLastReadingFromWO(ctx, woID, meterID);
        if (lastReading == null) {
            EquipmentMeterApplyInfo maInfo = this.getLastReadingOfMeter(ctx, meterID, assetInfo);
            if (maInfo != null) {
                if (maInfo.getDayAverageValue() == null) {
                    throw new EQMPlanningException(EQMPlanningException.METERAVGVALUEISNULL, new Object[]{meterInfo.getMeter().getName()});
                }
                Timestamp readingDate = maInfo.getReadingDate();
                if (Date.valueOf(dateFormat.format(readingDate)).after(Date.valueOf(dateFormat.format(woPlanDate)))) {
                    BigDecimal dateLen = new BigDecimal(0);
                    if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                        dateLen = new BigDecimal(DateUtils.getDiffDays(readingDate, woPlanDate));
                    } else if (ctEnum == EQMCalendarTypeEnum.WORKCALENDAR) {
                        int startSeq = this.getWorkDateSeq(ctx, woPlanDate, storageOrgUnitID);
                        int endSeq = this.getWorkDateSeq(ctx, readingDate, storageOrgUnitID);
                        dateLen = new BigDecimal(endSeq - startSeq);
                    }
                    if (countType == CountTypeEnum.up ? (lastReading = new BigDecimal(maInfo.getCurrentValue()).subtract(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(meterInfo.getToReading()) == 1 : countType == CountTypeEnum.down && (lastReading = new BigDecimal(maInfo.getCurrentValue()).add(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(meterInfo.getFromReading()) == -1) {
                        return null;
                    }
                    meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
                } else {
                    BigDecimal dateLen = new BigDecimal(0);
                    if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                        dateLen = new BigDecimal(DateUtils.getDiffDays(woPlanDate, readingDate));
                    } else if (ctEnum == EQMCalendarTypeEnum.WORKCALENDAR) {
                        int startSeq = this.getWorkDateSeq(ctx, readingDate, storageOrgUnitID);
                        int endSeq = this.getWorkDateSeq(ctx, woPlanDate, storageOrgUnitID);
                        dateLen = new BigDecimal(endSeq - startSeq);
                    }
                    if (countType == CountTypeEnum.up ? (lastReading = new BigDecimal(maInfo.getCurrentValue()).add(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(meterInfo.getToReading()) == 1 : countType == CountTypeEnum.down && (lastReading = new BigDecimal(maInfo.getCurrentValue()).subtract(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(meterInfo.getFromReading()) == -1) {
                        return null;
                    }
                    meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
                }
            } else {
                lastReading = new BigDecimal(0);
                meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
            }
        } else {
            meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
        }
        return meterMap;
    }

    private Map getLastEstimateInfoNoWO(Context ctx, IObjectValue assetInfo, String storageOrgUnitID, java.util.Date woPlanDate, EQMCalendarTypeEnum ctEnum, BaseMeterFrequencyEntryInfo meterInfo, BigDecimal dayAvg, int frqTimes, Object[] lastMeterMap) throws BOSException, EASBizException {
        EquipmentMeterApplyInfo maInfo;
        BigDecimal toReading;
        HashMap<String, Object[]> meterMap = new HashMap<String, Object[]>();
        EquipmentMeterInfo equipMeterInfo = meterInfo.getMeter();
        String meterID = equipMeterInfo.getId().toString();
        CountTypeEnum countType = equipMeterInfo.getCountType();
        BigDecimal lastReading = null;
        BigDecimal fromReading = meterInfo.getFromReading();
        if (fromReading == null) {
            fromReading = new BigDecimal(Double.MIN_VALUE);
        }
        if ((toReading = meterInfo.getToReading()) == null) {
            toReading = new BigDecimal(Double.MAX_VALUE);
        }
        if ((maInfo = this.getLastReadingOfMeter(ctx, meterID, assetInfo)) != null) {
            if (maInfo.getDayAverageValue() == null) {
                throw new EQMPlanningException(EQMPlanningException.METERAVGVALUEISNULL, new Object[]{meterInfo.getMeter().getName()});
            }
            BigDecimal dateLen = new BigDecimal(0);
            if (lastMeterMap != null && lastMeterMap[0] != null && lastMeterMap[1] != null) {
                if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                    dateLen = new BigDecimal(DateUtils.getDiffDays((java.util.Date)lastMeterMap[0], woPlanDate));
                } else if (ctEnum == EQMCalendarTypeEnum.WORKCALENDAR) {
                    int startSeq = this.getWorkDateSeq(ctx, woPlanDate, storageOrgUnitID);
                    int endSeq = this.getWorkDateSeq(ctx, (java.util.Date)lastMeterMap[0], storageOrgUnitID);
                    dateLen = new BigDecimal(endSeq - startSeq);
                }
                if (countType == CountTypeEnum.up ? (lastReading = ((BigDecimal)lastMeterMap[1]).subtract(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(toReading) == 1 : countType == CountTypeEnum.down && (lastReading = ((BigDecimal)lastMeterMap[1]).add(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(fromReading) == -1) {
                    return null;
                }
                meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
            } else if (Date.valueOf(dateFormat.format(maInfo.getReadingDate())).after(Date.valueOf(dateFormat.format(woPlanDate)))) {
                if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                    dateLen = new BigDecimal(DateUtils.getDiffDays(maInfo.getReadingDate(), woPlanDate));
                } else if (ctEnum == EQMCalendarTypeEnum.WORKCALENDAR) {
                    int startSeq = this.getWorkDateSeq(ctx, woPlanDate, storageOrgUnitID);
                    int endSeq = this.getWorkDateSeq(ctx, maInfo.getReadingDate(), storageOrgUnitID);
                    dateLen = new BigDecimal(endSeq - startSeq);
                }
                if (countType == CountTypeEnum.up ? (lastReading = new BigDecimal(maInfo.getCurrentValue()).subtract(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(toReading) == 1 : countType == CountTypeEnum.down && (lastReading = new BigDecimal(maInfo.getCurrentValue()).add(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(fromReading) == -1) {
                    return null;
                }
                meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
            } else {
                if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                    dateLen = new BigDecimal(DateUtils.getDiffDays(woPlanDate, maInfo.getReadingDate()));
                } else if (ctEnum == EQMCalendarTypeEnum.WORKCALENDAR) {
                    int startSeq = this.getWorkDateSeq(ctx, maInfo.getReadingDate(), storageOrgUnitID);
                    int endSeq = this.getWorkDateSeq(ctx, woPlanDate, storageOrgUnitID);
                    dateLen = new BigDecimal(endSeq - startSeq);
                }
                if (countType == CountTypeEnum.up ? (lastReading = new BigDecimal(maInfo.getCurrentValue()).add(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(toReading) == 1 : countType == CountTypeEnum.down && (lastReading = new BigDecimal(maInfo.getCurrentValue()).subtract(dateLen.multiply(maInfo.getDayAverageValue()))).compareTo(fromReading) == -1) {
                    return null;
                }
                if (lastReading != null) {
                    meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
                }
            }
        } else {
            lastReading = new BigDecimal(0);
            meterMap.put(meterID, new Object[]{woPlanDate, lastReading, dayAvg, countType});
        }
        return meterMap;
    }

    private Object[] addDaysToMeterFromReading(Context ctx, String storageOrgUnitID, java.util.Date woPlanDate, EQMCalendarTypeEnum ctEnum, BaseMeterFrequencyEntryInfo meterInfo, BigDecimal dayAvg, CountTypeEnum countType, BigDecimal lastReading) throws BOSException, EASBizException {
        BigDecimal b = lastReading;
        int days = 0;
        while (b.compareTo(countType == CountTypeEnum.up ? meterInfo.getFromReading() : meterInfo.getToReading()) == (countType == CountTypeEnum.up ? -1 : 1)) {
            ++days;
            if (countType == CountTypeEnum.up) {
                b = b.add(dayAvg);
                continue;
            }
            b = b.subtract(dayAvg.abs());
        }
        java.util.Date date = null;
        if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
            date = DateTimeUtils.addDay((java.util.Date)woPlanDate, (long)days);
        } else if (ctEnum == EQMCalendarTypeEnum.WORKCALENDAR) {
            date = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, woPlanDate, 1, days, 2);
        }
        Object[] dateObjects = new Object[]{date, b, dayAvg, countType};
        return dateObjects;
    }

    private BigDecimal getLastReadingFromWO(Context ctx, String woID, String meterID) throws BOSException, EASBizException {
        BigDecimal rtn = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(KDTMETERREADING_METERID, (Object)meterID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("workOrder.id", (Object)woID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 ");
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(KDTMETERREADING_CURRENTVALUE);
        viewInfo.setSelector(sic);
        SorterItemCollection sorterCollection = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo(KDTMETERREADING_READINGDATE);
        sortItemInfo.setSortType(SortType.DESCEND);
        sorterCollection.add(sortItemInfo);
        viewInfo.setSorter(sorterCollection);
        CoreBaseCollection c = EquipmentReadingHistoryFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (c.size() > 0) {
            EquipmentReadingHistoryInfo maInfo = (EquipmentReadingHistoryInfo)c.get(0);
            if (maInfo.getCurrentValue() == null) {
                return null;
            }
            return new BigDecimal(maInfo.getCurrentValue());
        }
        return rtn;
    }

    private int getWorkDateSeq(Context ctx, java.util.Date startDate, String storageOrgUnitId) throws BOSException {
        int workSeq = 0;
        if (storageOrgUnitId == null || storageOrgUnitId.trim().length() == 0) {
            return workSeq;
        }
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer strBuffSql = new StringBuffer("select max(ce.fworkdateseq) as fworkdateseq from T_MM_FactoryCalendar c right join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.fdatetype=1 and c.fstorageorgunitid='");
            strBuffSql.append(storageOrgUnitId);
            strBuffSql.append("'");
            if (startDate != null) {
                DateFormat df = BOSLocaleUtil.getDateFormat();
                String time = df.format(startDate);
                strBuffSql.append(" and ce.FWorkDate<={d'" + time + "'}");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)strBuffSql.toString());
            strBuffSql = null;
            if (rs.next()) {
                workSeq = rs.getInt("FWorkDateSeq");
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(ps, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return workSeq;
    }

    private BigDecimal getAvgValueFromMeter(Context ctx, String meterID, String meterName, IObjectValue assetInfo) throws BOSException, EASBizException {
        EquipmentMeterApplyInfo maInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (assetInfo instanceof EquipmentArchivesInfo) {
            filter.getFilterItems().add(new FilterItemInfo("equipment.id", (Object)((EquipmentArchivesInfo)assetInfo).getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("location.id", (Object)((EquipmentLocationInfo)assetInfo).getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo(KDTMETERREADING_METERID, (Object)meterID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo(KDTMETERREADING_READINGDATE);
        sorterItem.setSortType(SortType.DESCEND);
        sorters.add(sorterItem);
        viewInfo.setSorter(sorters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(KDTMETERREADING_DAYAVERAGEVALUE);
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
        viewInfo.setSelector(sic);
        CoreBaseCollection c = EquipmentMeterApplyFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (c.size() > 0 && (maInfo = (EquipmentMeterApplyInfo)c.get(0)).getDayAverageValue() != null) {
            return maInfo.getDayAverageValue();
        }
        throw new EQMPlanningException(EQMPlanningException.METERAVGVALUEISNULL, new Object[]{meterName});
    }

    @Override
    protected Map _getlatestDateFromMeterEntry(Context ctx, IObjectValue msInfo, IObjectValue soEntryInfo, java.util.Date startDate, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object[]> rtnMap = new HashMap<String, Object[]>();
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)msInfo;
        HashMap<String, Object[]> valueMap = new HashMap<String, Object[]>();
        HashMap<String, Object[]> meterMap = new HashMap<String, Object[]>();
        java.util.Date nextDate = null;
        Object maxDate = null;
        String storage = pmsInfo.getStorageOrgUnit().getId().toString();
        EQMCalendarTypeEnum ctEnum = pmsInfo.getCalendarType();
        PreMaintainStrategySeqItemInfo seqInfo = (PreMaintainStrategySeqItemInfo)soEntryInfo;
        int frqTimes = seqInfo.getFrequencyTimes();
        BaseMeterFrequencyEntryCollection meterColl = pmsInfo.getMeterSeqEntry();
        for (int i = 0; i < meterColl.size(); ++i) {
            BaseMeterFrequencyEntryInfo meterInfo = meterColl.get(i);
            String meterID = meterInfo.getMeter().getId().toString();
            BigDecimal fromReading = meterInfo.getFromReading();
            BigDecimal toReading = meterInfo.getToReading();
            int interval = meterInfo.getInterval();
            if (toReading == null) {
                toReading = new BigDecimal(Double.MAX_VALUE);
            }
            HashSet<String> a = new HashSet<String>();
            a.add(meterID);
            if (!meterMap.containsKey(meterID)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(KDTMETERREADING_METERID, a, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(KDTMETERREADING_ID);
                sic.add(KDTMETERREADING_DAYAVERAGEVALUE);
                sic.add(KDTMETERREADING_READINGDATE);
                sic.add(KDTMETERREADING_CURRENTVALUE);
                sic.add(KDTMETERREADING_averageCalWAY);
                sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new EquipmentMeterInfo().getBOSType(), (String)"meter", (boolean)false));
                viewInfo.setSelector(sic);
                CoreBaseCollection c = EquipmentMeterApplyFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
                if (c.size() > 0) {
                    EquipmentMeterApplyInfo maInfo = (EquipmentMeterApplyInfo)c.get(0);
                    meterMap.put(meterID, new Object[]{maInfo.getCurrentValue(), maInfo.getReadingDate(), maInfo.getDayAverageValue()});
                }
            }
            if (valueMap.containsKey(meterID)) break;
            Object[] mtApp = (Object[])meterMap.get(meterID);
            BigDecimal currentValue = new BigDecimal((String)mtApp[0]);
            java.util.Date readDate = (java.util.Date)mtApp[1];
            BigDecimal avgValue = (BigDecimal)mtApp[2];
            if (avgValue == null) {
                throw new EQMPlanningException(EQMPlanningException.METERAVGVALUEISNULL, new Object[]{meterInfo.getMeter().getName()});
            }
            if (currentValue == null) {
                currentValue = new BigDecimal(0);
            }
            if (currentValue.compareTo(toReading) > 0 || currentValue.compareTo(fromReading) < 0) break;
            int mltp = (int)Math.floor(currentValue.doubleValue() / new Double(interval));
            BigDecimal modVal = currentValue.subtract(new BigDecimal(interval * mltp));
            int days = (int)Math.floor((new Double(interval) - modVal.doubleValue()) / avgValue.doubleValue()) * frqTimes;
            if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                Calendar cp = Calendar.getInstance();
                cp.setTime(readDate);
                cp.add(5, days);
                nextDate = cp.getTime();
            } else {
                nextDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storage, readDate, 1, days, 2);
                this.validFactoryDate(ctx, nextDate, storage);
            }
            if (nextDate == null || Date.valueOf(dateFormat.format(nextDate)).after(Date.valueOf(dateFormat.format(endDate)))) break;
            valueMap.put(meterID, new Object[]{nextDate, new BigDecimal((mltp + 1) * frqTimes * interval), avgValue, new Integer((int)Math.floor(new Double(interval) / avgValue.doubleValue()))});
        }
        for (String name : meterMap.keySet()) {
            Object[] objs = (Object[])valueMap.get(name);
            java.util.Date value = (java.util.Date)objs[0];
            if (value == null) {
                return null;
            }
            if (!Date.valueOf(dateFormat.format(value)).after(Date.valueOf(dateFormat.format(maxDate)))) continue;
            rtnMap.clear();
            rtnMap.put(name, objs);
        }
        return rtnMap;
    }

    @Override
    protected List _getAllDateListFromMeterEntryBaseMeter(Context ctx, IObjectValue msInfo, IObjectValue soEntryInfo, Map meterMap, java.util.Date endDate) throws BOSException, EASBizException {
        Object[] objs2;
        Map map;
        ArrayList rtnLst = new ArrayList();
        Iterator e = meterMap.keySet().iterator();
        if (!e.hasNext()) {
            return null;
        }
        String meterID = (String)e.next();
        Object[] objs = (Object[])meterMap.get(meterID);
        java.util.Date firstDate = (java.util.Date)objs[0];
        if (Date.valueOf(dateFormat.format(firstDate)).after(Date.valueOf(dateFormat.format(endDate)))) {
            return null;
        }
        int interval = (Integer)objs[3];
        HashMap<java.util.Date, Integer> a = new HashMap<java.util.Date, Integer>();
        a.put(firstDate, new Integer(interval));
        rtnLst.add(a);
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)msInfo;
        List meterColl = pmsInfo.getMeterEntryItems();
        EQMCalendarTypeEnum ctEnum = pmsInfo.getCalendarType();
        PreMaintainStrategySeqItemInfo seqInfo = (PreMaintainStrategySeqItemInfo)soEntryInfo;
        int frqTimes = seqInfo.getFrequencyTimes();
        Object[] keys = meterMap.keySet().toArray();
        java.util.Date rtnDate = firstDate;
        while (Date.valueOf(dateFormat.format(rtnDate)).before(Date.valueOf(dateFormat.format(endDate))) && (map = this.getMeterNextDate(ctx, meterMap, meterColl, pmsInfo.getStorageOrgUnit().getId().toString(), ctEnum, frqTimes, endDate)).size() != 0 && (rtnDate = (java.util.Date)(objs2 = (Object[])map.get(keys[0]))[0]) != null) {
            if (Date.valueOf(dateFormat.format(rtnDate)).before(Date.valueOf(dateFormat.format(endDate)))) {
                HashMap<java.util.Date, Integer> m = new HashMap<java.util.Date, Integer>();
                m.put(rtnDate, (Integer)objs[3]);
                rtnLst.add(m);
            }
            meterMap.clear();
            meterMap.put(keys[0], map.get(keys[0]));
        }
        return rtnLst;
    }

    private boolean isOutUpperboundary(BigDecimal fromReading, BigDecimal toReading, BigDecimal currentReading, CountTypeEnum type) {
        return type == CountTypeEnum.up ? currentReading.compareTo(toReading) == 1 : currentReading.compareTo(fromReading) == -1;
    }

    private Map getMeterNextDate(Context ctx, Map meterMap, List meterColl, String storage, EQMCalendarTypeEnum ctEnum, int frqTimes, java.util.Date endDate) throws BOSException, EASBizException {
        HashMap<String, Object[]> rtnMap = new HashMap<String, Object[]>();
        Iterator e = meterMap.keySet().iterator();
        if (!e.hasNext()) {
            return null;
        }
        String meterID = (String)e.next();
        Object[] objs = (Object[])meterMap.get(meterID);
        java.util.Date nextDate = (java.util.Date)objs[0];
        BigDecimal currentRead = (BigDecimal)objs[1];
        BigDecimal avgValue = (BigDecimal)objs[2];
        BigDecimal lastWORead = (BigDecimal)objs[4];
        for (int i = 0; i < meterColl.size(); ++i) {
            Calendar cp;
            BaseMeterFrequencyEntryInfo entryInfo = (BaseMeterFrequencyEntryInfo)meterColl.get(i);
            BigDecimal fromReading = entryInfo.getFromReading();
            BigDecimal toReading = entryInfo.getToReading();
            if (toReading == null) {
                toReading = new BigDecimal(Double.MAX_VALUE);
            }
            CountTypeEnum countType = entryInfo.getMeter().getCountType();
            if (!meterID.equals(entryInfo.getMeter().getId().toString()) || this.isOutUpperboundary(fromReading, toReading, currentRead, countType)) continue;
            int interval = entryInfo.getInterval();
            int days = (int)Math.floor(new BigDecimal(frqTimes * interval).doubleValue() / avgValue.doubleValue());
            int seconds = (int)Math.floor(new BigDecimal(frqTimes * interval).doubleValue() / avgValue.doubleValue() * 86400.0);
            BigDecimal newValue = null;
            newValue = countType == CountTypeEnum.up ? currentRead.add(new BigDecimal(frqTimes * interval)) : currentRead.subtract(new BigDecimal(frqTimes * interval));
            if (days < 1 && lastWORead != null) {
                if (countType == CountTypeEnum.up && newValue.compareTo(lastWORead) > 0) {
                    lastWORead = lastWORead.add(avgValue);
                } else if (countType == CountTypeEnum.down && newValue.compareTo(lastWORead) < 0) {
                    lastWORead = lastWORead.subtract(avgValue);
                }
            }
            if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                cp = Calendar.getInstance();
                cp.setTime(nextDate);
                cp.add(5, days);
                nextDate = cp.getTime();
            } else {
                nextDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storage, nextDate, 1, days, 2);
                this.validFactoryDate(ctx, nextDate, storage);
            }
            if (days < 1 && seconds > 0) {
                cp = Calendar.getInstance();
                cp.setTime(nextDate);
                cp.add(13, seconds);
                nextDate = cp.getTime();
            }
            if (Date.valueOf(dateFormat.format(nextDate)).after(Date.valueOf(dateFormat.format(endDate)))) {
                return null;
            }
            rtnMap.put(meterID, new Object[]{nextDate, newValue, avgValue, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue.doubleValue() / 2.0)), lastWORead});
            break;
        }
        return rtnMap;
    }

    public Map getMeterNextDateAfresh(Context ctx, List meterColl2, String storage, int frqTimes, EQMCalendarTypeEnum ctEnum, java.util.Date fromDate, java.util.Date endDate) throws EASBizException, BOSException {
        Object assetInfo = null;
        PreMaintainStrategyInfo pmsInfo = null;
        java.util.Date minDate = null;
        java.util.Date maxDate = null;
        java.util.Date nextDate = null;
        HashMap<String, Object[]> rtnMap = new HashMap<String, Object[]>();
        if (meterColl2.size() > 0) {
            block4: for (int i = 0; i < meterColl2.size(); ++i) {
                BaseMeterFrequencyEntryInfo entryInfo = (BaseMeterFrequencyEntryInfo)meterColl2.get(i);
                if (assetInfo == null) {
                    pmsInfo = entryInfo.getParent();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo(KDTMETERREADING_ID));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("sequenceFireRule"));
                    sic.add(new SelectorItemInfo("archives.id"));
                    sic.add(new SelectorItemInfo("location.id"));
                    pmsInfo = PreMaintainStrategyFactory.getLocalInstance(ctx).getPreMaintainStrategyInfo((IObjectPK)new ObjectUuidPK(pmsInfo.getId()), sic);
                    assetInfo = pmsInfo.getArchives() != null ? pmsInfo.getArchives() : pmsInfo.getLocation();
                }
                EquipmentMeterInfo meter = entryInfo.getMeter();
                String meterID = meter.getId().toString();
                BigDecimal dayAvg = this.getAvgValueFromMeter(ctx, meter.getId().toString(), meter.getName(), (IObjectValue)assetInfo);
                int interval = entryInfo.getInterval();
                Map dMap = this.getLastEstimateInfoNoWO(ctx, (IObjectValue)assetInfo, storage, fromDate, ctEnum, entryInfo, dayAvg, frqTimes, null);
                if (dMap == null || dMap.keySet().size() == 0) continue;
                Object[] mtApp = (Object[])dMap.get(meterID);
                java.util.Date lastWODate2 = (java.util.Date)mtApp[0];
                BigDecimal lastWORead2 = (BigDecimal)mtApp[1];
                BigDecimal avgValue2 = (BigDecimal)mtApp[2];
                CountTypeEnum countType2 = (CountTypeEnum)mtApp[3];
                BigDecimal nextReading2 = null;
                BigDecimal lastWOReading2 = null;
                int days = (int)Math.floor(new BigDecimal(frqTimes * interval).doubleValue() / avgValue2.doubleValue());
                nextReading2 = countType2 == CountTypeEnum.up ? lastWORead2.add(new BigDecimal(interval * frqTimes)) : lastWORead2.subtract(new BigDecimal(interval * frqTimes));
                if (days < 1) {
                    if (lastWOReading2 != null) {
                        if (countType2 == CountTypeEnum.up && nextReading2.compareTo(lastWOReading2) > 0) {
                            ++days;
                            lastWOReading2 = lastWOReading2.add(avgValue2);
                        } else if (countType2 == CountTypeEnum.down && nextReading2.compareTo(lastWOReading2) < 0) {
                            ++days;
                            lastWOReading2 = lastWOReading2.subtract(avgValue2);
                        }
                    } else if (lastWOReading2 == null) {
                        if (countType2 == CountTypeEnum.up) {
                            lastWOReading2 = lastWORead2.add(avgValue2);
                        } else if (countType2 == CountTypeEnum.down) {
                            lastWOReading2 = lastWORead2.subtract(avgValue2);
                        }
                    }
                }
                if (ctEnum == EQMCalendarTypeEnum.GENERALCALENDAR) {
                    Calendar cp = Calendar.getInstance();
                    cp.setTime(lastWODate2);
                    cp.add(5, days);
                    nextDate = cp.getTime();
                } else {
                    nextDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storage, lastWODate2, 1, days, 2);
                    this.validFactoryDate(ctx, nextDate, storage);
                }
                switch (pmsInfo.getSequenceFireRule().getValue()) {
                    case 10: {
                        if (minDate == null) {
                            minDate = nextDate;
                            rtnMap.put(meterID, new Object[]{nextDate, nextReading2, avgValue2, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue2.doubleValue() / 2.0)), lastWOReading2});
                            PMUtils.setMFEntryID2Ctx(ctx, entryInfo.getId().toString());
                            continue block4;
                        }
                        if (!Date.valueOf(dateFormat.format(nextDate)).before(Date.valueOf(dateFormat.format(minDate)))) continue block4;
                        rtnMap.clear();
                        minDate = nextDate;
                        rtnMap.put(meterID, new Object[]{nextDate, nextReading2, avgValue2, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue2.doubleValue() / 2.0)), lastWOReading2});
                        PMUtils.setMFEntryID2Ctx(ctx, entryInfo.getId().toString());
                        continue block4;
                    }
                    case 20: {
                        if (maxDate == null) {
                            maxDate = nextDate;
                            rtnMap.put(meterID, new Object[]{nextDate, nextReading2, avgValue2, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue2.doubleValue() / 2.0)), lastWOReading2});
                            PMUtils.setMFEntryID2Ctx(ctx, entryInfo.getId().toString());
                            continue block4;
                        }
                        if (Date.valueOf(dateFormat.format(nextDate)).before(Date.valueOf(dateFormat.format(maxDate)))) continue block4;
                        rtnMap.clear();
                        maxDate = nextDate;
                        rtnMap.put(meterID, new Object[]{nextDate, nextReading2, avgValue2, new Integer((int)Math.floor(new Double(interval) * (double)frqTimes / avgValue2.doubleValue() / 2.0)), lastWOReading2});
                        PMUtils.setMFEntryID2Ctx(ctx, entryInfo.getId().toString());
                    }
                }
            }
        }
        for (String meterID : rtnMap.keySet()) {
            Object[] obj = (Object[])rtnMap.get(meterID);
            java.util.Date date = (java.util.Date)obj[0];
            if (date != null && !DateUtils.after(date, endDate)) continue;
            rtnMap.remove(meterID);
        }
        return rtnMap;
    }

    @Override
    protected java.util.Date _getLastWorkOrderDate(Context ctx, IObjectValue soInfo, String id, boolean isLocation, boolean isSeq, java.util.Date startDate) throws BOSException, EASBizException {
        List woLst = this.getLastWorkOrderColumnValue(ctx, soInfo, id, isLocation, isSeq, startDate, new String[]{"FLastDate"});
        if (woLst == null || woLst.size() == 0) {
            return null;
        }
        java.util.Date rtnDate = (java.util.Date)woLst.get(0);
        return rtnDate;
    }

    private List getLastWorkOrderColumnValue(Context ctx, IObjectValue soInfo, String id, boolean isLocation, boolean isSeq, java.util.Date startDate, String[] columnNames) throws BOSException, EASBizException {
        ArrayList<Object> rtnLst = new ArrayList<Object>();
        EquipmentStandardOperationInfo esoInfo = (EquipmentStandardOperationInfo)soInfo;
        StringBuffer sql_query = new StringBuffer();
        sql_query.append("select ");
        sql_query.append(StringUtils.arrayToString((Object[])columnNames, (String)","));
        sql_query.append(" from (select a.*,case when fBillStatus = ").append(49).append(" then FRealEndTime else FPlanEndTime end as fLastDate");
        sql_query.append(" from T_EQM_WorkOrder a) a ");
        sql_query.append(" where fstandardOpID = '").append(esoInfo.getId().toString()).append("'");
        if (isLocation) {
            sql_query.append("and fEqmLocationID = '" + id + "'");
        } else {
            sql_query.append("and fEquipmentArchivesID = '" + id + "'");
        }
        sql_query.append(" and fBillStatus <> ").append(10);
        sql_query.append(" and fBillStatus<> ").append(20);
        sql_query.append(" and fBillStatus<> ").append(60);
        sql_query.append(" and (FSourcetype = ").append(30);
        sql_query.append(" or FSourcetype = ").append(60).append(")");
        if (isSeq) {
            sql_query.append(" and fid <> fSuperparentID and fParentID in (select fid from T_EQM_WorkOrder where fid = fSuperparentID").append(" and fstandardOpid is null)");
        } else {
            sql_query.append(" and fid = fSuperparentID");
        }
        sql_query.append(" and fLastDate<to_date('").append(dateFormat.format(startDate)).append("')");
        sql_query.append(" order by FLastDate DESC");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get Last wo Date: " + sql_query));
        }
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql_query.toString());
        try {
            if (reqRow.next()) {
                for (int i = 0; i < columnNames.length; ++i) {
                    rtnLst.add(reqRow.getObject(columnNames[i]));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rtnLst;
    }

    @Override
    protected List _getAllDateListFromSpeciDateEntry(Context ctx, IObjectValue msInfo, java.util.Date startDate, java.util.Date endDate, int freqTimes, IObjectValue soInfo, boolean isMain) throws BOSException, EASBizException {
        ArrayList<java.util.Date[]> results = new ArrayList<java.util.Date[]>();
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)msInfo;
        EquipmentStandardOperationInfo esoInfo = (EquipmentStandardOperationInfo)soInfo;
        for (int year = DateTimeUtils.getYear((java.util.Date)startDate); year <= DateTimeUtils.getYear((java.util.Date)endDate); ++year) {
            BaseSpecifyDateEntryCollection sdeColl = pmsInfo.getSpecifyDateEntry();
            for (int index = 0; index < sdeColl.size(); ++index) {
                java.util.Date newToDate;
                BaseSpecifyDateEntryInfo info = sdeColl.get(index);
                Timestamp fromDate = info.getSpecifyDateFrom();
                Timestamp toDate = info.getSpecifyDateTo();
                java.util.Date newFromDate = this.getDateReplaceWithYear(fromDate, year);
                java.util.Date date = newToDate = toDate != null ? this.getDateReplaceWithYear(toDate, year) : this.getMaxDate();
                if (Date.valueOf(dateFormat.format(startDate)).after(Date.valueOf(dateFormat.format(newToDate))) || Date.valueOf(dateFormat.format(endDate)).before(Date.valueOf(dateFormat.format(newFromDate)))) continue;
                EntityViewInfo viewInfo = this.buildViewInfo(pmsInfo, esoInfo, isMain, newFromDate, newToDate);
                CoreBaseCollection c = WorkOrderFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
                if (c.size() > 0) {
                    results.add(new java.util.Date[]{null});
                    continue;
                }
                results.add(new java.util.Date[]{this.getGreator(startDate, newFromDate), fromDate, toDate});
            }
        }
        return results;
    }

    private java.util.Date getGreator(java.util.Date date1, java.util.Date date2) {
        return DateUtils.after(date1, date2) ? date1 : date2;
    }

    private java.util.Date getMaxDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(9999, 12, 31);
        return calendar.getTime();
    }

    private java.util.Date getDateReplaceWithYear(java.util.Date fromDate, int year) {
        Calendar fromClnd = Calendar.getInstance();
        fromClnd.setTime(Date.valueOf(dateFormat.format(fromDate)));
        fromClnd.set(year, fromClnd.get(2), fromClnd.get(5));
        return fromClnd.getTime();
    }

    private EntityViewInfo buildViewInfo(PreMaintainStrategyInfo pmsInfo, EquipmentStandardOperationInfo esoInfo, boolean isMain, java.util.Date from, java.util.Date to) {
        String sql;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (pmsInfo.getArchives() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("equipmentArchives.id", (Object)pmsInfo.getArchives().getId().toString(), CompareType.EQUALS));
        } else if (pmsInfo.getLocation() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("eqmLocation.id", (Object)pmsInfo.getLocation().getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("standardOp.id", (Object)esoInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("sourcetype", (Object)new Integer(10), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("planStartTime", (Object)from, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("planStartTime", (Object)to, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(60), CompareType.NOTEQUALS));
        if (isMain) {
            sql = "select FID from T_EQM_WorkOrder where fID =  FSuperParentID";
            GeneFilterUtils.mergeFilter((FilterInfo)filterInfo, (FilterItemInfo)new FilterItemInfo(KDTMETERREADING_ID, (Object)sql, CompareType.INNER));
        } else {
            sql = "select FID from T_EQM_WorkOrder where fID <>  FSuperParentID and fparentID = fSuperparentID and fparentID  in(select fid from t_eqm_workorder where  fstandardOpid is null and fid = FSuperParentID) ";
            GeneFilterUtils.mergeFilter((FilterInfo)filterInfo, (FilterItemInfo)new FilterItemInfo(KDTMETERREADING_ID, (Object)sql, CompareType.INNER));
        }
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        viewInfo.setSelector(selectors);
        return viewInfo;
    }

    @Override
    protected Map _getNextDateBaseDateEntry(Context ctx, IObjectCollection seqColl, java.util.Date cptDate, int frqTimes, String storage, EQMCalendarTypeEnum ctEnum) throws BOSException, EASBizException {
        return this.getNextDate(ctx, (BaseDateFrequencyEntryCollection)seqColl, cptDate, frqTimes, storage, ctEnum);
    }

    @Override
    protected Map _getNextDateBaseMeterEntry(Context ctx, Map meterMap, List meterColl, String storage, EQMCalendarTypeEnum ctEnum, int frqTimes, java.util.Date endDate) throws BOSException, EASBizException {
        return this.getMeterNextDate(ctx, meterMap, meterColl, storage, ctEnum, frqTimes, endDate);
    }

    private void validFactoryDate(Context ctx, java.util.Date date, String storageOrgUnitId) throws BOSException, EASBizException, EQMPlanningException {
        if (date == null) {
            IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitInfo org = iStorage.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitId), GeneSelectorUtils.getSelector((String)"", (String[])new String[]{"name"}));
            String orgName = org.getName(ctx.getLocale());
            throw new EQMPlanningException(EQMPlanningException.WORKCALENDARNOTINIT, new Object[]{orgName});
        }
    }

    @Override
    protected java.util.Date _getLastWODateForDownStrategy(Context ctx, java.util.Date fromDate, java.util.Date toDate, IObjectValue strategyInfo) throws BOSException, EASBizException {
        PreMaintainStrategyInfo pmsInfo = (PreMaintainStrategyInfo)strategyInfo;
        StringBuffer strb = new StringBuffer();
        strb.append("select top 1 FPlanStartTime from T_EQM_WorkOrder ");
        strb.append(" where  FID<>FSuperParentID and FPmstrategyID='").append(pmsInfo.getId()).append("'");
        strb.append(" and FMaintainRouteID is null ");
        strb.append(" and FParentID<>FSuperParentID ");
        strb.append(" and FTaskType = 10 ");
        strb.append(" and FPlanStartTime<=to_date('").append(dateFormat.format(toDate)).append("')");
        strb.append(" and FPlanStartTime>=to_date('").append(dateFormat.format(fromDate)).append("')");
        strb.append(" and FBillStatus<>").append(60);
        strb.append(" ORDER BY FPlanStartTime DESC");
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)strb.toString());
        if (reqRow.size() > 0) {
            try {
                reqRow.next();
                return reqRow.getDate("FPlanStartTime");
            }
            catch (SQLException e) {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
        }
        return null;
    }
}

