/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.planning.EQMPlanningException;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaAssetCollection;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaAssetFactory;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaAssetInfo;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaInfo;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class AssetOnlyInOneMaintainSchemaVerifyItem
extends AbstractVerifyItem {
    private static final String EQUIPMENT_ARCHIVES = "equipmentArchives";
    private static final String EQUIPMENT_LOCATION = "equipmentLocation";
    private EquipmentMaintainSchemaInfo maintainSchemaInfo;
    private Context ctx;

    public AssetOnlyInOneMaintainSchemaVerifyItem(Context ctx, EquipmentMaintainSchemaInfo maintainSchemaInfo) {
        this.ctx = ctx;
        this.maintainSchemaInfo = maintainSchemaInfo;
    }

    public boolean verify() throws EASBizException, BOSException {
        List c;
        List c2;
        Set archivesIds = this.getArchivesIds();
        if (!archivesIds.isEmpty() && !(c2 = this.getOtherAssetsWhoContainsCurrentArchives(archivesIds)).isEmpty()) {
            throw new EQMPlanningException(EQMPlanningException.ARCHIVESONLYINONESCHEMA, new Object[]{this.buildDetailMsg(c2, EQUIPMENT_ARCHIVES)});
        }
        Set locationIds = this.getLocationIds();
        if (!locationIds.isEmpty() && !(c = this.getOtherAssetsWhoContainsCurrentLocations(locationIds)).isEmpty()) {
            throw new EQMPlanningException(EQMPlanningException.LOCATIONONLYINONESCHEMA, new Object[]{this.buildDetailMsg(c, EQUIPMENT_LOCATION)});
        }
        return true;
    }

    private List getOtherAssetsWhoContainsCurrentArchives(Set archivesIds) throws BOSException {
        ArrayList<EquipmentMaintainSchemaAssetInfo> result = new ArrayList<EquipmentMaintainSchemaAssetInfo>();
        EquipmentMaintainSchemaAssetCollection c = EquipmentMaintainSchemaAssetFactory.getLocalInstance(this.ctx).getEquipmentMaintainSchemaAssetCollection(this.getViewInfo(archivesIds, EQUIPMENT_ARCHIVES));
        for (int i = 0; i < c.size(); ++i) {
            if (this.getAssetIds().contains(c.get(i).getId())) continue;
            result.add(c.get(i));
        }
        return result;
    }

    private List getOtherAssetsWhoContainsCurrentLocations(Set locationIds) throws BOSException {
        ArrayList<EquipmentMaintainSchemaAssetInfo> result = new ArrayList<EquipmentMaintainSchemaAssetInfo>();
        EquipmentMaintainSchemaAssetCollection c = EquipmentMaintainSchemaAssetFactory.getLocalInstance(this.ctx).getEquipmentMaintainSchemaAssetCollection(this.getViewInfo(locationIds, EQUIPMENT_LOCATION));
        for (int i = 0; i < c.size(); ++i) {
            if (this.getAssetIds().contains(c.get(i).getId())) continue;
            result.add(c.get(i));
        }
        return result;
    }

    private Set getAssetIds() {
        HashSet<BOSUuid> assetIds = new HashSet<BOSUuid>();
        for (int i = 0; i < this.maintainSchemaInfo.getAssets().size(); ++i) {
            EquipmentMaintainSchemaAssetInfo assetInfo = this.maintainSchemaInfo.getAssets().get(i);
            if (assetInfo.getId() == null) continue;
            assetIds.add(assetInfo.getId());
        }
        return assetIds;
    }

    private Set getLocationIds() {
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        Iterator it = this.maintainSchemaInfo.getAssets().iterator();
        while (it.hasNext()) {
            EquipmentMaintainSchemaAssetInfo assetInfo = (EquipmentMaintainSchemaAssetInfo)it.next();
            if (assetInfo.getEquipmentLocation() == null || assetInfo.getEquipmentArchives() != null) continue;
            ids.add(assetInfo.getEquipmentLocation().getId());
        }
        return ids;
    }

    private Set getArchivesIds() {
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        Iterator it = this.maintainSchemaInfo.getAssets().iterator();
        while (it.hasNext()) {
            EquipmentMaintainSchemaAssetInfo assetInfo = (EquipmentMaintainSchemaAssetInfo)it.next();
            if (assetInfo.getEquipmentArchives() == null) continue;
            ids.add(assetInfo.getEquipmentArchives().getId());
        }
        return ids;
    }

    private String buildDetailMsg(List c, String assetName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            EquipmentMaintainSchemaAssetInfo info = (EquipmentMaintainSchemaAssetInfo)c.get(i);
            if (assetName.equals(EQUIPMENT_ARCHIVES)) {
                sb.append(info.getEquipmentArchives().getName());
            } else if (assetName.equals(EQUIPMENT_LOCATION)) {
                sb.append(info.getEquipmentLocation().getName());
            }
            String msg = ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"5_AssetOnlyInOneMaintainSchemaVerifyItem", (Locale)this.ctx.getLocale());
            MessageFormat mf = new MessageFormat(msg);
            sb.append(mf.format(new String[]{info.getMaintainSchema().getName()}));
        }
        return sb.toString();
    }

    private EntityViewInfo getViewInfo(Set equipmentIds, String assetName) {
        EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)this.getFilter(equipmentIds, assetName), (SelectorItemCollection)this.getSelectors(assetName), null);
        return entityViewInfo;
    }

    private FilterInfo getFilter(Set equipmentIds, String assetName) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(assetName + ".id", (Object)equipmentIds, CompareType.INCLUDE));
        if (this.maintainSchemaInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("maintainSchema.id", (Object)this.maintainSchemaInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (EQUIPMENT_LOCATION.equals(assetName)) {
            filter.getFilterItems().add(new FilterItemInfo("equipmentArchives.id", null));
        }
        return filter;
    }

    private SelectorItemCollection getSelectors(String assetName) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("maintainSchema.id"));
        selector.add(new SelectorItemInfo("maintainSchema.number"));
        selector.add(new SelectorItemInfo("maintainSchema.name"));
        selector.add(new SelectorItemInfo(assetName + ".id"));
        selector.add(new SelectorItemInfo(assetName + ".name"));
        selector.add(new SelectorItemInfo(assetName + ".number"));
        return selector;
    }
}

