/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BPResult;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.ISparepartPlanSchema;
import com.kingdee.eas.eqm.basedata.SparepartPlanSchemaFactory;
import com.kingdee.eas.eqm.basedata.SparepartPlanSchemaInfo;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanException;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogInfo;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderFactory;
import com.kingdee.eas.eqm.planning.spareparts.app.AbstractSparePartsPlanCalcFacadeControllerBean;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPRunner;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;
import com.kingdee.eas.eqm.planning.spareparts.util.SparepartUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SparePartsPlanCalcFacadeControllerBean
extends AbstractSparePartsPlanCalcFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.spareparts.app.SparePartsPlanCalcFacadeControllerBean");
    private String SIMPLE_DATE_PATTERN = "yyyy-MM-dd";
    private String RUN_PERMISSION = "eqm_SparePartsPlanCalc_01run";
    private static final String ENTITYNAME = ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"70_SparePartsPlanCalcFacadeControllerBean", (Locale)ContextUtils.getLocaleFromEnv());

    @Override
    protected void _runSPP(Context ctx, IObjectValue mrpRunLog) throws BOSException, EASBizException {
        SparePartsPlanRunLogInfo info = (SparePartsPlanRunLogInfo)mrpRunLog;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"begin run SparePartsPlan...");
        }
        ctx.put((Object)"CurOU", (Object)info.getStorageOrgUnit());
        SPRunner spRunner = new SPRunner(ctx);
        try {
            spRunner.run(info);
            this.writeLog(ctx, info, "cal", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "cal", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "cal", new Boolean(false));
            throw e2;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"end run SparePartsPlan...");
        }
    }

    private void requestMutex(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean bLock = mutex.requestObjIDForUpdate(storageOrgUnitID, ctx.getCaller().toString(), Uuid.create());
        if (!bLock) {
            throw new SparePartsPlanException(SparePartsPlanException.LOCK_ERROR);
        }
    }

    protected void checkParams(Context ctx, SparePartsPlanRunLogInfo logInfo) throws BOSException, EASBizException {
        if (logInfo == null || logInfo.getStorageOrgUnit() == null || logInfo.getStorageOrgUnit().getId() == null || logInfo.getPlanSchema() == null || logInfo.getPlanSchema().getId() == null) {
            throw new SparePartsPlanException(SparePartsPlanException.PARAM_ERROR);
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("isCalNetting"));
        selectors.add(new SelectorItemInfo("isShopBuildding"));
        selectors.add(new SelectorItemInfo("isProjectedS"));
        selectors.add(new SelectorItemInfo("isAvailablStock"));
        selectors.add(new SelectorItemInfo("planType"));
        selectors.add(new SelectorItemInfo("bomType"));
        selectors.add(new SelectorItemInfo("materialRange"));
        selectors.add(new SelectorItemInfo("warehouseRange"));
        ISparepartPlanSchema planVersion = SparepartPlanSchemaFactory.getLocalInstance((Context)ctx);
        SparepartPlanSchemaInfo planVersionInfo = planVersion.getSparepartPlanSchemaInfo((IObjectPK)new ObjectStringPK(logInfo.getPlanSchema().getId().toString()), selectors);
        logInfo.setPlanSchema(planVersionInfo);
    }

    @Override
    protected void _backRun(Context ctx, IObjectValue mrpRunLog) throws BOSException, EASBizException {
        SparePartsPlanRunLogInfo logValue = (SparePartsPlanRunLogInfo)mrpRunLog;
        this.checkParams(ctx, logValue);
        String storageOrgUnitID = logValue.getStorageOrgUnit().getId().toString();
        this.requestMutex(ctx, storageOrgUnitID);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"begin to back run SparePartsPlan...");
        }
        BPOption bpOption = new BPOption();
        bpOption.setImmediately(true);
        DynamicBackground bd = new DynamicBackground();
        BPResult result = bd.invokeBackound(this.getBOSType(), "runSPP", new Class[]{SparePartsPlanRunLogInfo.class}, new Object[]{mrpRunLog}, bpOption);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("end to back run SparePartsPlan result is " + result.toString()));
        }
    }

    @Override
    protected void _runSPP4Scheduling(Context ctx, String storageOrgUnitNumber, String planVersionNumber, String planDate, String userNumber) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnit(ctx, storageOrgUnitNumber);
        SparepartPlanSchemaInfo planVersion = null;
        UserInfo caller = this.getCaller(ctx, userNumber);
        IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectStringPK userPk = new ObjectStringPK(caller.getId().toString());
        ObjectStringPK orgPK = new ObjectStringPK(storageOrgUnit.getId().toString());
        boolean flag = true;
        try {
            flag = perm.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPK, this.RUN_PERMISSION);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!flag) {
            throw new SparePartsPlanException(SparePartsPlanException.BACKRUNUSERNOPERMISSION_ERROR);
        }
        planVersion = this.getPlanVersionSetInfo(ctx, planVersionNumber, storageOrgUnit.getId().toString());
        SparePartsPlanRunLogInfo runLogInfo = new SparePartsPlanRunLogInfo();
        runLogInfo.setCreator(caller);
        runLogInfo.setStorageOrgUnit(storageOrgUnit);
        runLogInfo.setPlanSchema(planVersion);
        java.util.Date dplanDate = new java.util.Date();
        if (planDate != null && !"".equals(planDate)) {
            DateFormat df = BOSLocaleUtil.getDateFormat();
            try {
                dplanDate = df.parse(planDate);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        runLogInfo.setPlanDate(dplanDate);
        String number = this.getMRPLogNumber(ctx, runLogInfo, storageOrgUnit.getId().toString());
        runLogInfo.setNumber(number);
        this.checkParams(ctx, runLogInfo);
        String storageOrgUnitID = runLogInfo.getStorageOrgUnit().getId().toString();
        this.requestMutex(ctx, storageOrgUnitID);
        this._runSPP(ctx, (IObjectValue)runLogInfo);
    }

    protected UserInfo getCaller(Context ctx, String userNumber) throws BOSException, EASBizException {
        if (userNumber == null || userNumber.length() == 0) {
            throw new SparePartsPlanException(SparePartsPlanException.BACKRUNUSER_ERROR);
        }
        UserInfo caller = UserFactory.getLocalInstance((Context)ctx).getUser(userNumber);
        if (caller == null) {
            throw new SparePartsPlanException(SparePartsPlanException.BACKRUNUSER_ERROR);
        }
        return caller;
    }

    protected String getMRPLogNumber(Context ctx, SparePartsPlanRunLogInfo runLogInfo, String storageOrgUnitID) throws BOSException, EASBizException {
        String number = SPUtil.getBizNumber(ctx, (IObjectValue)runLogInfo, storageOrgUnitID);
        if (number == null) {
            number = number.substring(0, (number = String.valueOf(System.currentTimeMillis())).length() > 44 ? 44 : number.length());
        }
        if (number == null) {
            throw new SparePartsPlanException(SparePartsPlanException.MRP_RUN_LOG_RULE_NOT_EXIST);
        }
        return number;
    }

    protected StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String number) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = null;
        String sql = "select fid,fcontrolunitid from t_org_storage where fnumber = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
        try {
            if (rs.next()) {
                storageOrgUnit = new StorageOrgUnitInfo();
                storageOrgUnit.setId(BOSUuid.read((String)rs.getString("fid")));
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)rs.getString("fcontrolunitid")));
                storageOrgUnit.setCU(ctrlUnitInfo);
                storageOrgUnit.setNumber(number);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (storageOrgUnit == null) {
            throw new SparePartsPlanException(SparePartsPlanException.STORAGEORGUNITNUMBER_ERROR);
        }
        return storageOrgUnit;
    }

    public SparepartPlanSchemaInfo getPlanVersionSetInfo(Context ctx, String number, String storageOrgUnitID) throws BOSException, EASBizException {
        SparepartPlanSchemaInfo planVersion = null;
        String sql = "select fid from T_EQM_SparepartPlanSchema where fnumber = ? and fstorageorgunitid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number, storageOrgUnitID});
        try {
            if (rs.next()) {
                planVersion = new SparepartPlanSchemaInfo();
                planVersion.setId(BOSUuid.read((String)rs.getString("fid")));
                planVersion.setNumber(number);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (planVersion == null) {
            throw new SparePartsPlanException(SparePartsPlanException.PLANVERSION_ERROR);
        }
        return planVersion;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HashMap _calculateEndDateByPlan(Context ctx, String planVersionSetId, java.util.Date startDate) throws BOSException, EASBizException {
        HashMap<String, Object> has = new HashMap<String, Object>();
        StringBuffer errBuff = new StringBuffer(500);
        if (planVersionSetId == null) throw new SparePartsPlanException(SparePartsPlanException.PLANVERSIONIDNOTBLANK);
        if (planVersionSetId.trim().length() == 0) {
            throw new SparePartsPlanException(SparePartsPlanException.PLANVERSIONIDNOTBLANK);
        }
        if (startDate == null) {
            throw new SparePartsPlanException(SparePartsPlanException.PLANDATEISNULL);
        }
        IRowSet rs = null;
        try {
            String sql = "select p.fstorageorgunitid,h.fhorizonunit,h.fhorizonlength from T_EQM_SparepartPlanSchema p ,T_EQM_PlanningHorizon h where p.FPlanningHorizonID=h.fid and p.fid='" + planVersionSetId + "'";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            int hUnit = 0;
            int hLength = 0;
            String strOrgId = null;
            if (!rs.next()) {
                ObjectUuidPK pk;
                ISparepartPlanSchema ips = SparepartPlanSchemaFactory.getLocalInstance((Context)ctx);
                SparepartPlanSchemaInfo psInfo = (SparepartPlanSchemaInfo)ips.getValue((IObjectPK)(pk = new ObjectUuidPK(planVersionSetId)));
                if (psInfo == null) throw new SparePartsPlanException(SparePartsPlanException.NOCURRIDPV);
                throw new SparePartsPlanException(SparePartsPlanException.PLANVERSIONNOTPH);
            }
            strOrgId = rs.getString("fstorageorgunitid");
            hUnit = rs.getInt("fhorizonunit");
            hLength = rs.getInt("fhorizonlength");
            if (strOrgId == null) {
                strOrgId = "";
                if (errBuff.toString().length() == 0) {
                    throw new SparePartsPlanException(SparePartsPlanException.PLANVERSIONNOSTOREORGNULL);
                }
            }
            if (hUnit != 10) throw new SparePartsPlanException(SparePartsPlanException.PHUNITNOTDAY);
            SQLUtils.cleanup((ResultSet)rs);
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            cal.add(5, hLength);
            java.util.Date endDate = cal.getTime();
            SimpleDateFormat df = new SimpleDateFormat(this.SIMPLE_DATE_PATTERN);
            cal.add(5, 1);
            java.util.Date toDate = cal.getTime();
            String toTime = df.format(toDate);
            StringBuffer strSql = new StringBuffer("select ce.fworkdate, ce.fid, ce.FWorkDateSeq from T_MM_FactoryCalendar c right join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.FDateType=1 and c.fstorageorgunitid='");
            strSql.append(strOrgId + "'");
            strSql.append(" and ce.fworkdate<{d'" + toTime + "'}");
            strSql.append(" order by ce.fworkdate");
            rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
            strSql = null;
            Date initDate = null;
            String startDateId = null;
            int startDateSeq = 0;
            if (rs.next()) {
                initDate = rs.getDate("fWorkDate");
                startDateId = rs.getString("fid");
                startDateSeq = rs.getInt("FWorkDateSeq");
            }
            if (initDate == null) throw new SparePartsPlanException(SparePartsPlanException.CURRFCNOTEXIST);
            has.put("StartDate", initDate);
            has.put("StartDateID", startDateId);
            has.put("StartDateSeq", new Integer(startDateSeq));
            SQLUtils.cleanup((ResultSet)rs);
            strSql = new StringBuffer("select ce.fworkdate , ce.fid, ce.FWorkDateSeq from T_MM_FactoryCalendar c right join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid where ce.FDateType=1 and c.fstorageorgunitid='");
            strSql.append(strOrgId + "'");
            strSql.append(" and ce.fworkdate<{d'" + toTime + "'}");
            strSql.append(" order by ce.fworkdate desc ");
            rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString());
            strSql = null;
            String endDateId = null;
            int endDateSeq = 0;
            if (rs.next()) {
                endDate = rs.getDate("fWorkDate");
                endDateId = rs.getString("fid");
                endDateSeq = rs.getInt("FWorkDateSeq");
            }
            has.put("EndDate", endDate);
            has.put("EndDateID", endDateId);
            has.put("EndDateSeq", new Integer(endDateSeq));
            if (rs == null) return has;
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL Execution Error", (Throwable)e);
                catch (EASBizException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return has;
    }

    private void writeLog(Context ctx, SparePartsPlanRunLogInfo info, String operation, Boolean isSuccessed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", isSuccessed);
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", ENTITYNAME);
        hashLog.put("FEntityAlias_L2", ENTITYNAME);
        hashLog.put("FMethodName", "close");
        hashLog.put("FCompanyName_L1", info.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L2", info.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L3", info.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FInstanceID", info.getId().toString());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("cal")) {
            logItem = "eqm_SparePartsPlanCalc_run";
        }
        return logItem;
    }

    @Override
    protected Map _batchEdit(Context ctx, Map editValues) throws BOSException, EASBizException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        this.removeCannotUpdateBills(ctx, editValues);
        if (editValues.size() != 0) {
            String updSql = "update T_EQM_SparepartPlanOrder set FPlanCount = ?, FBasePlanCount = ?, flastupdateuserid = ?, flastupdatetime = ? where fid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(editValues.size());
            ArrayList ids = new ArrayList();
            HashMap idnumbers = new HashMap();
            for (Object id : editValues.keySet()) {
                List value = (List)editValues.get(id);
                Object[] param = new Object[]{value.get(1), value.get(2), ctx.getCaller() == null ? "" : ctx.getCaller().toString(), new Timestamp(new java.util.Date().getTime()), id};
                paramsList.add(param);
                ids.add(id);
                idnumbers.put(id, value.get(0));
            }
            DbUtil.executeBatch((Context)ctx, (String)updSql, paramsList);
            this.writeBatchEditLog(ctx, ids, idnumbers, true);
        }
        result.put("BATCH_UPDATE_SIZE", new Integer(editValues.size()));
        return result;
    }

    private void writeBatchEditLog(Context ctx, List ids, Map idnumbers, boolean success) throws BOSException {
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)SparepartPlanOrderFactory.getLocalInstance(ctx).getType());
        for (int i = 0; i < ids.size(); ++i) {
            HashMap<String, Object> hashLog = new HashMap<String, Object>();
            LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
            hashLog.put("isSuccessed", new Boolean(false));
            hashLog.put("successed", new Boolean(true));
            hashLog.put("FEntityID", entityObjectInfo.getBOSType().toString());
            hashLog.put("FEntityName", entityObjectInfo.getName());
            hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FMethodName", "update");
            hashLog.put("FInstanceID", ids.get(i));
            hashLog.put("FInstanceNo", idnumbers.get(ids.get(i)));
            hashLog.put("FItemName", "eqm_SparepartPlanOrder_update");
            hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
            appLog.writeLog(hashLog);
        }
    }

    protected void removeCannotUpdateBills(Context ctx, Map editValues) throws BOSException {
        this.removeByStatus(ctx, editValues);
        this.removeByPermission(ctx, editValues);
    }

    protected void removeByStatus(Context ctx, Map editValues) throws BOSException {
        if (editValues.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("select fid from T_EQM_SparepartPlanOrder where fbillstatus in (");
        sql.append(30).append(", ");
        sql.append(49).append(", ");
        sql.append(65).append(") \n");
        sql.append("and fid in (").append(SparepartUtil.getInSQLFromSet(editValues.keySet())).append(")");
        this.removeBySQL(ctx, editValues, sql.toString());
    }

    private void removeByPermission(Context ctx, Map editValues) throws BOSException {
        if (editValues.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select bill.fid from T_EQM_SparepartPlanOrder as bill \n");
        sql.append("where bill.FStorageOrgUnitID not in ( \n");
        sql.append("select perm.forgid from T_PM_UserOrgPerm as perm \n");
        sql.append("left outer join t_pm_user as u \n");
        sql.append("on perm.fowner = u.fid \n");
        sql.append("left outer join T_PM_PermItem as pi \n");
        sql.append("on perm.FPermItemID = pi.fid \n");
        sql.append("where u.fid = '").append(ctx.getCaller() == null ? "" : ctx.getCaller().toString()).append("' \n");
        sql.append("and pi.fnumber like 'eqm_SparepartPlanOrder_04update' \n");
        sql.append(")");
        sql.append("and bill.fid in (").append(SparepartUtil.getInSQLFromSet(editValues.keySet())).append(")");
        this.removeBySQL(ctx, editValues, sql.toString());
    }

    private void removeBySQL(Context ctx, Map editValues, String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                if (!editValues.containsKey(id)) continue;
                editValues.remove(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

