/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.ISparePartsPlanCalcFacade;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanCalcFacadeFactory;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDate;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class SPCalculateDateRange
extends SPStep {
    @Override
    protected String getStepDesc() {
        StringBuffer sb = new StringBuffer(SPResource.getString(this.runParam.getCtx(), "SP_CALCDATERANGE")).append("\r\n");
        DateFormat sdFormat = BOSLocaleUtil.getDateTimeFormat();
        if (this.runParam.getBeginDate() != null) {
            sb.append("begin date: ").append(sdFormat.format(this.runParam.getBeginDate()));
        }
        if (this.runParam.getEndDate() != null) {
            sb.append(" end date: ").append(sdFormat.format(this.runParam.getEndDate()));
        }
        return sb.toString();
    }

    @Override
    protected String getStepNum() {
        return "20.01";
    }

    @Override
    protected Object innerExecute(SPCalcParam runParam) throws EASBizException, BOSException {
        if (runParam.isUseFactoryCalendar()) {
            ISparePartsPlanCalcFacade calcFacade = SparePartsPlanCalcFacadeFactory.getLocalInstance(runParam.getCtx());
            HashMap has = calcFacade.calculateEndDateByPlan(runParam.getRunLogInfo().getPlanSchema().getId().toString(), runParam.getPlanDate().getDate().getTime());
            Calendar beginDate = Calendar.getInstance();
            beginDate.setTime((Date)has.get("StartDate"));
            SPDate beginMRPDate = new SPDate();
            beginMRPDate.setDate(beginDate);
            beginMRPDate.setCalendarID((String)has.get("StartDateID"));
            beginMRPDate.setWorkDaySeqID((Integer)has.get("StartDateSeq"));
            runParam.setMRPBeginDate(beginMRPDate);
            Calendar endDate = Calendar.getInstance();
            endDate.setTime((Date)has.get("EndDate"));
            SPDate endMRPDate = new SPDate();
            endMRPDate.setDate(endDate);
            endMRPDate.setCalendarID((String)has.get("EndDateID"));
            endMRPDate.setWorkDaySeqID((Integer)has.get("EndDateSeq"));
            runParam.setMRPEndDate(endMRPDate);
        } else {
            runParam.setMRPBeginDate(runParam.getPlanDate());
            Calendar cal = SPUtil.createCalendar(runParam.getPlanDate().getDate().getTime());
            int hlLength = runParam.getPlanSchemaParam().getInfo().getPlanningHorizon().getHorizonLength();
            cal.add(5, hlLength);
            SPDate endMRPDate = new SPDate();
            endMRPDate.setDate(cal);
            runParam.setMRPEndDate(endMRPDate);
        }
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected int getProgressPercent() {
        return 1;
    }
}

