/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetPurOrderBillData;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetPurRequestBillData;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetSparepartPlanOrder;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetStockTransferBillData;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetTransferOrderBillData;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;
import java.util.ArrayList;
import java.util.List;

public class SPGetBillData
extends SPStep {
    private List billList = null;

    public SPGetBillData(SPCalcParam runParam) {
        this.registBill(runParam);
    }

    private void registBill(SPCalcParam runParam) {
        this.billList = new ArrayList();
        if (runParam.getPlanSchemaParam().isUsingPurReq()) {
            this.billList.add(new SPGetPurRequestBillData());
        }
        if (runParam.getPlanSchemaParam().isUsingPurOrder()) {
            this.billList.add(new SPGetPurOrderBillData());
        }
        if (runParam.getPlanSchemaParam().isUsingInvTrans()) {
            this.billList.add(new SPGetStockTransferBillData());
        }
        if (runParam.getPlanSchemaParam().isUsingTransferOrder()) {
            this.billList.add(new SPGetTransferOrderBillData());
        }
        if (runParam.getPlanSchemaParam().isUsingSpareparsPlanOrder()) {
            this.billList.add(new SPGetSparepartPlanOrder());
        }
    }

    @Override
    protected String getStepDesc() {
        return this.runParam.isNeedNetRequirement() ? SPResource.getString(this.runParam.getCtx(), "SP_GETESTIMATEDQTY") : "";
    }

    @Override
    protected String getStepNum() {
        return "50.99";
    }

    @Override
    protected Object innerExecute(SPCalcParam runParam) throws EASBizException, BOSException {
        if (!runParam.isNeedNetRequirement()) {
            return null;
        }
        String tableName = null;
        try {
            tableName = SPUtil.createTempTable(runParam.getCtx(), "  CREATE TABLE ESTIMATEDQTY (\r\nFID INT ,\r\nFMATERIALID VARCHAR(44) NOT NULL,\r\nFPlanVersionID VARCHAR(44) NOT NULL,\r\nFRunLogID VARCHAR(44) NOT NULL,\r\nFREQUIREDDATE DATETIME NOT NULL,\r\nFADJUSTDATE DATETIME , \r\nFBASEQTY NUMERIC(21,8) \r\n) ");
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        runParam.getTempTableList().add(tableName);
        runParam.setEstimatedQtyTableName(tableName);
        for (SPStep step : this.billList) {
            step.execute(runParam);
        }
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    @Override
    protected int getProgressPercent() {
        return 0;
    }
}

