/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;

public class SPPONumberGenerator {
    private static SparepartPlanOrderInfo PO_Instance = new SparepartPlanOrderInfo();
    private ICodingRuleManager codingRuleManager = null;
    private RuleStatus ruleStatus = null;
    private SPCalcParam runParam = null;
    private Stack numberStack = new Stack();

    public SPPONumberGenerator(SPCalcParam runParam) throws BOSException {
        this.runParam = runParam;
        this.codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)runParam.getCtx());
    }

    public String getNumber(int calQty) throws EASBizException, BOSException {
        if (this.numberStack.size() == 0) {
            this.preGetBillNumbers(calQty);
        }
        return (String)this.numberStack.pop();
    }

    private void preGetBillNumbers(int calQty) throws EASBizException, BOSException {
        int numberOfbatch = 10;
        int matCount = this.runParam.getMaterialCount();
        if (matCount <= 100) {
            numberOfbatch = 10;
        } else if (matCount > 100 && matCount <= 1000) {
            numberOfbatch = 50;
        } else if (matCount > 1000) {
            numberOfbatch = 100;
        }
        String[] nums = null;
        this.ruleStatus = this.codingRuleManager.getRuleStatus((IObjectValue)PO_Instance, this.runParam.getStorageOrgUnitID());
        if (this.ruleStatus.isExist()) {
            nums = this.codingRuleManager.getBatchNumber((IObjectValue)PO_Instance, this.runParam.getStorageOrgUnitID(), numberOfbatch);
        } else {
            nums = new String[numberOfbatch];
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssss");
            String number = "sppo-" + sdf.format(new Date(System.currentTimeMillis())) + (int)(Math.random() * 10000.0) + calQty;
            for (int i = 0; i < numberOfbatch; ++i) {
                nums[i] = number + i;
            }
        }
        for (int i = 0; i < nums.length; ++i) {
            this.numberStack.push(nums[i]);
        }
    }

    public void recycleNumbers() throws EASBizException, BOSException {
        if (this.numberStack.size() > 0) {
            if (this.codingRuleManager.isUseIntermitNumber((IObjectValue)PO_Instance, this.runParam.getStorageOrgUnitID())) {
                String[] nums = new String[this.numberStack.size()];
                System.arraycopy(this.numberStack.toArray(), 0, nums, 0, this.numberStack.size());
                this.codingRuleManager.recycleBatchNumber((IObjectValue)PO_Instance, this.runParam.getStorageOrgUnitID(), nums);
            }
            if (!this.ruleStatus.isExist()) {
                this.numberStack.clear();
            }
        }
    }
}

