/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.BillParamEntryCollection;
import com.kingdee.eas.eqm.basedata.BillParamEntryInfo;
import com.kingdee.eas.eqm.basedata.BillParamPrecomposeFactory;
import com.kingdee.eas.eqm.basedata.BillParamPrecomposeInfo;
import com.kingdee.eas.eqm.basedata.IBillParamPrecompose;
import com.kingdee.eas.eqm.basedata.ISPStoreStateEntry;
import com.kingdee.eas.eqm.basedata.ISPStoreTypeEntry;
import com.kingdee.eas.eqm.basedata.MaterielScopeEnum;
import com.kingdee.eas.eqm.basedata.SPStoreStateEntryCollection;
import com.kingdee.eas.eqm.basedata.SPStoreStateEntryFactory;
import com.kingdee.eas.eqm.basedata.SPStoreStateEntryInfo;
import com.kingdee.eas.eqm.basedata.SPStoreTypeEntryCollection;
import com.kingdee.eas.eqm.basedata.SPStoreTypeEntryFactory;
import com.kingdee.eas.eqm.basedata.SPStoreTypeEntryInfo;
import com.kingdee.eas.eqm.basedata.SparepartPlanSchemaInfo;
import com.kingdee.eas.eqm.basedata.WarehouseScopeEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SPPlanSchemaParam {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPPlanSchemaParam");
    protected String PURREQ = "";
    protected String PURORDER = "";
    protected String INVTRANS = "";
    protected String TRANSFERORDER = "";
    protected String SPAREPARSPLANORDER = "";
    protected String NORMALPUR = "";
    protected String INVTRANSYJ = "";
    protected String INVTRANSCB = "";
    protected String TRANSFERORDER2 = "";
    protected String TRANSFERORDER3 = "";
    protected String TRANSFERORDER4 = "";
    private static final String PURREQ_NORMALPUR_ID = "5DydsD3eTraqwSjNnNCPSignT1Y=";
    private static final String PURORDER_NORMALPUR_ID = "1snF/ss0Q3yKpeduD+xI8CgnT1Y=";
    private static final String INVTRANS_INVTRANSYJ_ID = "2J5MV/5WSTutoV6gx1vOWCgnT1Y=";
    private static final String INVTRANS_INVTRANSCB_ID = "6OMz8cvhTkiV3kK4Wu8qTSgnT1Y=";
    private static final String TRANSFERORDER_TRANSFERORDER2_ID = "9vsvoyNHQVuN+JKpgAAKGignT1Y=";
    private static final String TRANSFERORDER_TRANSFERORDER3_ID = "0a8Z4tADS2+ZqwmcH1jy2gNm4D4=";
    private static final String TRANSFERORDER_TRANSFERORDER4_ID = "+USdEsS4QAWfZ/KouvXZ6wNm4D4=";
    private static final String SPAREPARSPLANORDER_ID = "2EkUWgBoQrGI7p3Rz9AriQNm4D4=";
    private static final String NORMALPUR_NUMBER = "'110'";
    private static final String INVTRANSYJ_NUMBER = "'320'";
    private static final String INVTRANSCB_NUMBER = "'321'";
    private static final String TRANSFERORDER2_NUMBER = "'310'";
    private static final String TRANSFERORDER3_NUMBER = "'370'";
    private static final String TRANSFERORDER4_NUMBER = "'380'";
    private BillParamPrecomposeInfo purreqNormalInfo = null;
    private BillParamPrecomposeInfo purorderNormalInfo = null;
    private SPStoreTypeEntryCollection storeTypeInfos = null;
    private SPStoreStateEntryCollection storeStateInfos = null;
    private BillParamPrecomposeInfo invtransYJInfo = null;
    private BillParamPrecomposeInfo invtransCBInfo = null;
    private BillParamPrecomposeInfo transferorder2Info = null;
    private BillParamPrecomposeInfo transferorder3Info = null;
    private BillParamPrecomposeInfo transferorder4Info = null;
    private BillParamPrecomposeInfo planorderInfo = null;
    private boolean usingPurOrder = false;
    private boolean usingPurReq = false;
    private boolean usingInvTrans = false;
    private boolean usingTransferOrder = false;
    private boolean usingSpareparsPlanOrder = false;
    private List purOrderType = new ArrayList();
    private List purReqType = new ArrayList();
    private List invTransType = new ArrayList();
    private List transferType = new ArrayList();
    private List invType = new ArrayList();
    private List invStatus = new ArrayList();
    private List spoStatus = new ArrayList();
    private boolean userDefinedWarehouse = false;
    private boolean userDefinedMaterial = false;
    private SparepartPlanSchemaInfo info = null;

    public SPPlanSchemaParam(SparepartPlanSchemaInfo info, Context ctx) {
        this.info = info;
        try {
            ISPStoreTypeEntry storeType = SPStoreTypeEntryFactory.getLocalInstance((Context)ctx);
            ISPStoreStateEntry storeState = SPStoreStateEntryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getId()));
            view.setFilter(filter);
            this.storeTypeInfos = storeType.getSPStoreTypeEntryCollection(view);
            this.storeStateInfos = storeState.getSPStoreStateEntryCollection(view);
            IBillParamPrecompose ibp = BillParamPrecomposeFactory.getLocalInstance((Context)ctx);
            this.purorderNormalInfo = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(PURORDER_NORMALPUR_ID));
            if (this.purorderNormalInfo != null) {
                this.PURORDER = this.purorderNormalInfo.getBillName();
                this.NORMALPUR = this.purorderNormalInfo.getBusinessType();
            }
            this.purreqNormalInfo = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(PURREQ_NORMALPUR_ID));
            if (this.purreqNormalInfo != null) {
                this.PURREQ = this.purreqNormalInfo.getBillName();
                this.NORMALPUR = this.purreqNormalInfo.getBusinessType();
            }
            this.invtransYJInfo = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(INVTRANS_INVTRANSYJ_ID));
            if (this.invtransYJInfo != null) {
                this.INVTRANS = this.invtransYJInfo.getBillName();
                this.INVTRANSYJ = this.invtransYJInfo.getBusinessType();
            }
            this.invtransCBInfo = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(INVTRANS_INVTRANSCB_ID));
            if (this.invtransCBInfo != null) {
                this.INVTRANS = this.invtransCBInfo.getBillName();
                this.INVTRANSCB = this.invtransCBInfo.getBusinessType();
            }
            this.transferorder2Info = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(TRANSFERORDER_TRANSFERORDER2_ID));
            if (this.transferorder2Info != null) {
                this.TRANSFERORDER = this.transferorder2Info.getBillName();
                this.TRANSFERORDER2 = this.transferorder2Info.getBusinessType();
            }
            this.transferorder3Info = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(TRANSFERORDER_TRANSFERORDER3_ID));
            if (this.transferorder3Info != null) {
                this.TRANSFERORDER = this.transferorder3Info.getBillName();
                this.TRANSFERORDER3 = this.transferorder3Info.getBusinessType();
            }
            this.transferorder4Info = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(TRANSFERORDER_TRANSFERORDER4_ID));
            if (this.transferorder4Info != null) {
                this.TRANSFERORDER = this.transferorder4Info.getBillName();
                this.TRANSFERORDER4 = this.transferorder4Info.getBusinessType();
            }
            this.planorderInfo = ibp.getBillParamPrecomposeInfo((IObjectPK)new ObjectUuidPK(SPAREPARSPLANORDER_ID));
            if (this.planorderInfo != null) {
                this.SPAREPARSPLANORDER = this.planorderInfo.getBillName();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
    }

    public void doIt() {
        BillParamEntryCollection billEntry = this.info.getBillParamEntry();
        Iterator storeTypeItr = this.storeTypeInfos.iterator();
        Iterator storeStateItr = this.storeStateInfos.iterator();
        BillParamEntryInfo info1 = null;
        int count = billEntry.size();
        for (int i = 0; i < count; ++i) {
            info1 = billEntry.get(i);
            if (this.PURREQ.equals(info1.getBillName()) && this.NORMALPUR.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                this.purReqType.add(NORMALPUR_NUMBER);
            }
            if (this.PURORDER.equals(info1.getBillName()) && this.NORMALPUR.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                this.purOrderType.add(NORMALPUR_NUMBER);
            }
            if (this.INVTRANS.equals(info1.getBillName())) {
                if (this.INVTRANSYJ.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                    this.invTransType.add(INVTRANSYJ_NUMBER);
                }
                if (this.INVTRANSCB.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                    this.invTransType.add(INVTRANSCB_NUMBER);
                }
            }
            if (this.TRANSFERORDER.equals(info1.getBillName())) {
                if (this.TRANSFERORDER2.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                    this.transferType.add(TRANSFERORDER2_NUMBER);
                }
                if (this.TRANSFERORDER3.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                    this.transferType.add(TRANSFERORDER3_NUMBER);
                }
                if (this.TRANSFERORDER4.equals(info1.getBusinessType()) && info1.isJoinCalculate()) {
                    this.transferType.add(TRANSFERORDER4_NUMBER);
                }
            }
            if (!this.SPAREPARSPLANORDER.equals(info1.getBillName()) || !info1.isJoinCalculate()) continue;
            this.usingSpareparsPlanOrder = true;
        }
        if (!this.purReqType.isEmpty()) {
            this.usingPurReq = true;
        }
        if (!this.purOrderType.isEmpty()) {
            this.usingPurOrder = true;
        }
        if (!this.invTransType.isEmpty()) {
            this.usingInvTrans = true;
        }
        if (!this.transferType.isEmpty()) {
            this.usingTransferOrder = true;
        }
        if (MaterielScopeEnum.UserDef.equals((Object)this.info.getMaterielScope())) {
            this.userDefinedMaterial = true;
        }
        if (WarehouseScopeEnum.UserDef.equals((Object)this.info.getWareHouseScope())) {
            this.userDefinedWarehouse = true;
        }
        if (this.info.isSavedStatus()) {
            this.spoStatus.add(String.valueOf(10));
        }
        if (this.info.isSumittedStatus()) {
            this.spoStatus.add(String.valueOf(20));
        }
        if (this.info.isAuditedStatus()) {
            this.spoStatus.add(String.valueOf(30));
        }
        if (this.info.isReleaseStatus()) {
            this.spoStatus.add(String.valueOf(45));
        }
        if (this.info.isStartWorkStatus()) {
            this.spoStatus.add(String.valueOf(44));
        }
        try {
            while (storeTypeItr.hasNext()) {
                SPStoreTypeEntryInfo storeTypeInfo = (SPStoreTypeEntryInfo)storeTypeItr.next();
                if (!storeTypeInfo.isSelected()) continue;
                this.invType.add(storeTypeInfo.getNumber());
            }
            while (storeStateItr.hasNext()) {
                SPStoreStateEntryInfo storeStateInfo = (SPStoreStateEntryInfo)storeStateItr.next();
                if (!storeStateInfo.isSelected()) continue;
                this.invStatus.add(storeStateInfo.getNumber());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public String getInvTypeSql(String prex, boolean alwaysTrue) {
        List list = this.invType;
        String str = "";
        if (null != list) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    str = str + " OR ";
                }
                str = str + " " + prex + " = '" + (String)list.get(i) + "' ";
            }
        }
        if ("".equals(str)) {
            str = alwaysTrue ? " 1=1 " : " 1=2 ";
        }
        return str;
    }

    public String getInvStatusSql(String prex, boolean alwaysTrue) {
        List list = this.invStatus;
        String str = "";
        if (null != list) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    str = str + " OR ";
                }
                str = str + " " + prex + " = '" + (String)list.get(i) + "' ";
            }
        }
        if ("".equals(str)) {
            str = alwaysTrue ? " 1=1 " : " 1=2 ";
        }
        return str;
    }

    public String getBillStatusSql(String prex, String billType, boolean alwaysTrue) {
        List list = null;
        String str = "";
        if (this.SPAREPARSPLANORDER.equals(billType)) {
            list = this.spoStatus;
        }
        if (null != list) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    str = str + " OR ";
                }
                str = str + " " + prex + " = " + (String)list.get(i) + " ";
            }
        }
        if ("".equals(str)) {
            str = alwaysTrue ? " 1=1 " : " 1=2 ";
        }
        return str;
    }

    public String getBizTypeSql(String prex, String billType, boolean alwaysTrue) {
        List list = null;
        String str = "";
        if (this.PURREQ.equals(billType)) {
            list = this.purReqType;
        } else if (this.PURORDER.equals(billType)) {
            list = this.purOrderType;
        } else if (this.INVTRANS.equals(billType)) {
            list = this.invTransType;
        } else if (this.TRANSFERORDER.equals(billType)) {
            list = this.transferType;
        }
        if (null != list) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    str = str + " OR ";
                }
                str = str + " " + prex + " = " + (String)list.get(i) + " ";
            }
        }
        if ("".equals(str)) {
            str = alwaysTrue ? " 1=1 " : " 1=2 ";
        }
        return str;
    }

    public boolean isCalcNetDemand() {
        return this.info.isCalculateNetReq();
    }

    public boolean isUsingPurOrder() {
        return this.usingPurOrder;
    }

    public boolean isUsingPurReq() {
        return this.usingPurReq;
    }

    public boolean isUsingInvTrans() {
        return this.usingInvTrans;
    }

    public boolean isUsingTransferOrder() {
        return this.usingTransferOrder;
    }

    public boolean isUsingSpareparsPlanOrder() {
        return this.usingSpareparsPlanOrder;
    }

    public boolean isUserDefinedWarehouse() {
        return this.userDefinedWarehouse;
    }

    public boolean isUserDefinedMaterial() {
        return this.userDefinedMaterial;
    }

    public SparepartPlanSchemaInfo getInfo() {
        return this.info;
    }
}

