/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcNetDemand;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalculateDateRange;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPClearRunningTable;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetAllMaterials;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetBillData;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetGrossRequirements;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPGetMaterialOnHand;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPMergeEstimatedRequirements;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPMergeGrossRequirements;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPOrderGenerator;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPPlanVersionPeriod;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPRunCrush;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPRunEnd;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPRunStart;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;

public class SPRunner {
    private Context ctx;

    public SPRunner(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SparePartsPlanRunLogInfo logValue) throws BOSException, EASBizException {
        SPCalcParam runParam = new SPCalcParam();
        runParam.setRunLogInfo(logValue);
        runParam.setCtx(this.ctx);
        try {
            SPRunStart start = new SPRunStart();
            start.execute(runParam);
            SPCalculateDateRange calculateDateRang = new SPCalculateDateRange();
            calculateDateRang.execute(runParam);
            SPClearRunningTable clearTable = new SPClearRunningTable();
            clearTable.execute(runParam);
            SPPlanVersionPeriod planVersionPeriod = new SPPlanVersionPeriod();
            planVersionPeriod.execute(runParam);
            SPGetGrossRequirements getGrossRequirements = new SPGetGrossRequirements();
            getGrossRequirements.execute(runParam);
            SPMergeGrossRequirements mergeGrossRequirements = new SPMergeGrossRequirements();
            mergeGrossRequirements.execute(runParam);
            SPGetAllMaterials getMaterials = new SPGetAllMaterials();
            getMaterials.execute(runParam);
            if (runParam.isNeedNetRequirement()) {
                SPGetMaterialOnHand getOnhand = new SPGetMaterialOnHand();
                getOnhand.execute(runParam);
                SPGetBillData getBillData = new SPGetBillData(runParam);
                getBillData.execute(runParam);
                SPMergeEstimatedRequirements mergeEstimatedRequirements = new SPMergeEstimatedRequirements();
                mergeEstimatedRequirements.execute(runParam);
            }
            SPCalcNetDemand netCalc = new SPCalcNetDemand();
            netCalc.execute(runParam);
            SPOrderGenerator genOrder = new SPOrderGenerator();
            genOrder.execute(runParam);
            SPRunEnd runEnd = new SPRunEnd();
            runEnd.execute(runParam);
        }
        catch (Exception e) {
            SPRunCrush crush = new SPRunCrush();
            crush.setException(e);
            crush.execute(runParam);
        }
        finally {
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
            mutex.releaseObjIDForUpdate(runParam.getStorageOrgUnitID());
            SPUtil.releasseAllTmpTable(this.ctx, runParam.getTempTableList());
            SPUtil.releasseAllTmpIdx(this.ctx, runParam.getTempIdxNameList());
        }
    }
}

