/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.app.DataImportEqmArchivesGroupTools;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.app.util.GeneServerUtils;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.eqm.planning.spareparts.ISparepartPlanOrder;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderInfo;
import com.kingdee.eas.eqm.planning.spareparts.datatask.DataImportsparepartPlanOrderTools;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportsparepartPlanOrder
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.planning.spareparts.SparepartsPlanTransmissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SparepartPlanOrderFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.planning.spareparts.app.ExpSparepartPlanOrderQuery";
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object str = null;
        StorageOrgUnitInfo storageInfo = null;
        SparepartPlanOrderInfo info = new SparepartPlanOrderInfo();
        Hashtable baseData = hsData;
        Object orgId = null;
        String bizDate = this.getDataString(baseData, "FBizDate");
        String requestDate = this.getDataString(baseData, "FRequestDate");
        String planCount = this.getDataString(baseData, "FPlanCount");
        String billStatus = this.getDataString(baseData, "FBillStatus");
        String remark = this.getDataString(baseData, "FRemark");
        storageInfo = this.dealWithOrg(ctx, baseData, info);
        this.dealWithFNumber(ctx, baseData, info);
        this.dealWithMaterialAndUnit(ctx, baseData, info);
        this.dealWithMaterialPlan(ctx, baseData, info);
        Date bizDateFormat = null;
        if (bizDate == null || "".equals(bizDate.trim())) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("bizDate_IsNotNull"));
        }
        try {
            bizDateFormat = DataImportEqmTools.getFormatDate((String)bizDate);
            info.setBizDate(bizDateFormat);
        }
        catch (ParseException e) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("bizDateErr"));
        }
        Date requestDateFormat = null;
        if (requestDate == null || "".equals(requestDate.trim())) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("requestDate_IsNotNull"));
        }
        try {
            requestDateFormat = DataImportEqmTools.getFormatDate((String)requestDate);
            info.setRequestDate(requestDateFormat);
        }
        catch (ParseException e) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("requestDateErr"));
        }
        int precision = info.getMeasureUnit().getQtyPrecision();
        if (planCount == null || "".equals(planCount.trim())) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("planCount_IsNotNull"));
        }
        info.setPlanCount(DataImportEqmTools.getNumByPrecision((String)planCount, (int)precision, (String)DataImportsparepartPlanOrder.getResourceMsg("FPlanCount"), (boolean)true));
        if (info.getPlanCount().compareTo(new BigDecimal("0")) == 0) {
            throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"73_DataImportsparepartPlanOrder"));
        }
        if (billStatus == null || "".equals(billStatus.trim())) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("billStatus_IsNotNull"));
        }
        info.setBillStatus(DataImportsparepartPlanOrderTools.getBillBaseStatus(billStatus));
        this.dealWitLlaunchCount(ctx, baseData, info);
        this.dealWitLAudit(ctx, baseData, info);
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)remark, (String)DataImportsparepartPlanOrder.getResourceMsg("remark"), (int)255);
        info.setDescription(remark);
        this.dealWithBaseCount(ctx, baseData, info);
        info.setFromBOTP(false);
        info.setHasEffected(false);
        if (GeneBillBaseStatusEnum.SAVE == info.getBillStatus()) {
            info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        } else {
            info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        }
        return info;
    }

    private StorageOrgUnitInfo dealWithOrg(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        StorageOrgUnitInfo storageInfo = null;
        String orgNumber = this.getDataString(baseData, "FStorageOrgUnit_number");
        if (orgNumber == null || "".equals(orgNumber.trim())) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("org_IsNotNull"));
        }
        this.isAuthorizedOrgUnit(ctx, orgNumber);
        try {
            storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, orgNumber);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info.setStorageOrgUnit(storageInfo);
        return storageInfo;
    }

    private void dealWithFNumber(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        String str = null;
        str = this.getDataString(baseData, "FNumber");
        if (str == null || "".equals(str.trim())) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("number_IsNotNull"));
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)DataImportsparepartPlanOrder.getResourceMsg("FNumber"), (int)80);
        try {
            ISparepartPlanOrder iSparepartPlanOrder = SparepartPlanOrderFactory.getLocalInstance(ctx);
            SparepartPlanOrderInfo tempInfo = null;
            try {
                tempInfo = (SparepartPlanOrderInfo)this.getInfoByNumber(ctx, (ICoreBase)iSparepartPlanOrder, str, info.getStorageOrgUnit().getNumber(), null);
            }
            catch (BOSException e) {
                // empty catch block
            }
            if (tempInfo != null) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("numberIsExist"));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info.setNumber(str);
    }

    private void dealWithMaterialAndUnit(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        block6: {
            String material_Number = this.getDataString(baseData, "FMaterialNumber_number");
            String measureUnit_number = this.getDataString(baseData, "FMeasureUnit_number");
            if (material_Number == null || "".equals(material_Number.trim())) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("materialNumber_IsNotNull"));
            }
            if (measureUnit_number == null || "".equals(measureUnit_number.trim())) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("MeasureUnit_number_IsNotNull"));
            }
            try {
                IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.getSelector().add(new SelectorItemInfo("id"));
                viewInfo.getSelector().add(new SelectorItemInfo("number"));
                viewInfo.getSelector().add(new SelectorItemInfo("name"));
                viewInfo.getSelector().add(new SelectorItemInfo("baseUnit.id"));
                viewInfo.getSelector().add(new SelectorItemInfo("baseUnit.qtyPrecision"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)material_Number));
                filter.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2), CompareType.NOTEQUALS));
                viewInfo.setFilter(filter);
                MaterialInfo materialInfo = (MaterialInfo)this.getInfoByNumber(ctx, (ICoreBase)iMat, material_Number, null, viewInfo);
                IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo3 = new EntityViewInfo();
                FilterInfo filter3 = new FilterInfo();
                filter3.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString()));
                filter3.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                filter3.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getStorageOrgUnit().getId().toString()));
                viewInfo3.setFilter(filter3);
                MaterialInventoryCollection materialInventoryCollection = iMaterialInventory.getMaterialInventoryCollection(viewInfo3);
                if (materialInventoryCollection == null || materialInventoryCollection.size() == 0) {
                    String msg = ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"74_DataImportsparepartPlanOrder");
                    MessageFormat mf = new MessageFormat(msg);
                    String result = mf.format(new String[]{material_Number});
                    throw new TaskExternalException(result);
                }
                info.setMaterialNumber(materialInfo);
                info.setBaseUnit(materialInfo.getBaseUnit());
                IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo1 = new EntityViewInfo();
                viewInfo1.getSelector().add(new SelectorItemInfo("id"));
                viewInfo1.getSelector().add(new SelectorItemInfo("number"));
                viewInfo1.getSelector().add(new SelectorItemInfo("name"));
                viewInfo1.getSelector().add(new SelectorItemInfo("qtyPrecision"));
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("number", (Object)measureUnit_number));
                viewInfo1.setFilter(filter1);
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.getInfoByNumber(ctx, (ICoreBase)iMeasureUnit, measureUnit_number, null, viewInfo1);
                if (measureUnitInfo == null) break block6;
                MultiMeasureUnitInfo multiMeasureUnitInfo = DataImportEqmArchivesGroupTools.getMultiMeasureUnit((Context)ctx, (MaterialInfo)materialInfo, (MeasureUnitInfo)measureUnitInfo);
                if (multiMeasureUnitInfo != null) {
                    info.setMeasureUnit(measureUnitInfo);
                    baseData.put("multiMeasureUnitInfo", multiMeasureUnitInfo);
                    break block6;
                }
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("Material_MeasureUnitErr"));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void dealWithMaterialPlan(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("material.id", (Object)info.getMaterialNumber().getId().toString(), CompareType.EQUALS));
            items.add(new FilterItemInfo("ORGUNIT.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            viewInfo.setFilter(filter);
            CoreBaseCollection c = MaterialPlanFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
            MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)c.get(0);
            if (materialPlanInfo != null) {
                info.setMaterialPlan(materialPlanInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void dealWitLlaunchCount(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        int precision;
        String launchCount = this.getDataString(baseData, "FLaunchCount");
        BigDecimal launchCountFormat = DataImportEqmTools.getNumByPrecision((String)launchCount, (int)(precision = info.getMeasureUnit().getQtyPrecision()), (String)DataImportsparepartPlanOrder.getResourceMsg("FLaunchCount"), (boolean)true, (boolean)true);
        if (launchCountFormat == null) {
            launchCountFormat = new BigDecimal("0");
        }
        if (GeneBillBaseStatusEnum.SAVE == info.getBillStatus() || GeneBillBaseStatusEnum.Submit == info.getBillStatus()) {
            if (launchCountFormat.compareTo(new BigDecimal("0")) != 0) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("LaunchCount_ZERO"));
            }
        } else if (GeneBillBaseStatusEnum.Audit == info.getBillStatus() || GeneBillBaseStatusEnum.ForceComplete == info.getBillStatus()) {
            if (launchCountFormat.compareTo(info.getPlanCount()) > -1) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("LaunchCount_LessThan_Plan"));
            }
        } else if (GeneBillBaseStatusEnum.CLOSED == info.getBillStatus() && launchCountFormat.compareTo(info.getPlanCount()) != 0) {
            throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("LaunchCount_Plan"));
        }
        info.setLaunchCount(launchCountFormat);
    }

    private void dealWithBaseCount(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        MultiMeasureUnitInfo multiMeasureUnitInfo = (MultiMeasureUnitInfo)baseData.get("multiMeasureUnitInfo");
        BigDecimal rate = multiMeasureUnitInfo.getBaseConvsRate();
        int precision = multiMeasureUnitInfo.getQtyPrecision();
        info.setBaseLaunchCount(rate.multiply(info.getLaunchCount()).setScale(precision, 1));
        info.setBasePlanCount(rate.multiply(info.getPlanCount()).setScale(precision, 1));
    }

    private void dealWitLAudit(Context ctx, Hashtable baseData, SparepartPlanOrderInfo info) throws TaskExternalException {
        String auditUser = this.getDataString(baseData, "FAuditUser");
        String auditTime = this.getDataString(baseData, "FAuditTime");
        if (GeneBillBaseStatusEnum.Audit == info.getBillStatus() || GeneBillBaseStatusEnum.CLOSED == info.getBillStatus() || GeneBillBaseStatusEnum.ForceComplete == info.getBillStatus()) {
            if (auditUser == null || "".equals(auditUser.trim())) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("FAuditor_Number_IsNotNull"));
            }
            if (auditTime == null || "".equals(auditTime.trim())) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("FAuditTime_IsNotNull"));
            }
            try {
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                info.setAuditor((UserInfo)this.getInfoByNumber(ctx, (ICoreBase)iUser, auditUser, null, null));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
            }
            try {
                info.setAuditTime(DataImportEqmTools.getFormatDate((String)auditTime));
            }
            catch (ParseException e) {
                throw new TaskExternalException(DataImportsparepartPlanOrder.getResourceMsg("FAuditTimeErr"));
            }
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        Locale locale = ctx.getLocale();
        try {
            String orgId = rs.getString("storageOrgUnit.id");
            GeneServerUtils.checkPermission((Context)ctx, (IObjectPK)new ObjectUuidPK(orgId), (String)"eqm_SparepartPlanOrder_12export");
        }
        catch (Exception e1) {
            return null;
        }
        try {
            int precision = Integer.parseInt(rs.getString("MeasureUnit.qtyPrecision") != null ? rs.getString("MeasureUnit.qtyPrecision") : "4");
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FMaterialNumber_number", rs.getString("MaterialNumber.number"));
            this.putTable(result, "FMaterialNumber_name", rs.getString("MaterialNumber.name"));
            this.putTable(result, "FBillStatus", GeneBillBaseStatusEnum.getEnum((int)rs.getInt("billStatus")).getAlias(locale));
            this.putTable(result, "FMaterialNumber_model", rs.getString("MaterialNumber.model"));
            this.putTable(result, "FMeasureUnit_number", rs.getString("MeasureUnit.number"));
            this.putTable(result, "FMeasureUnit_name", rs.getString("MeasureUnit.name"));
            this.putTable(result, "FRequestDate", rs.getString("RequestDate"));
            String planCount = DataImportEqmTools.getNumByPrecision((String)rs.getString("PlanCount"), (int)precision);
            this.putTable(result, "FPlanCount", planCount);
            String launchCount = DataImportEqmTools.getNumByPrecision((String)rs.getString("LaunchCount"), (int)precision);
            this.putTable(result, "FLaunchCount", launchCount);
            this.putTable(result, "FAuditUser", rs.getString("auditor.number"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }

    protected String getImportPermItemName() {
        return "eqm_SparepartPlanOrder_11import";
    }
}

