/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentFaultSortTreeInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.report.util.EQMReportServerUtils;
import com.kingdee.eas.eqm.report.util.ReportUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class EQMDefectPoolReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.report.app.EQMDefectPoolReport");
    private static String TAB_CATE_FAULT = "";
    private static String TAB_LO_FAULT = "";
    private static String RESOURCE_PATH = "com.kingdee.eas.eqm.report.EQMReportResource";
    private static String CATEGORY = "category";
    private static String LOCATION = "location";
    private static String ALL = "all";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        String storagenumber = "";
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            storagenumber = ReportUtil.StringUtil(filter.getString("storageOrgUnit"));
            StringBuffer sql = new StringBuffer();
            sql.append(" select FName_" + this.getContext().getLocale() + " from T_ORG_Storage storage where  storage.FNumber in(" + storagenumber + ")");
            storagenumber = ReportUtil.getNameByNumber(sql, storagenumber, this.getContext());
        } else {
            storagenumber = "" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_ALL");
        }
        String bizDateFrom = "";
        if (filter.getString("findDateFrom") != null && filter.getString("findDateFrom").length() > 0) {
            bizDateFrom = filter.getString("findDateFrom").substring(0, 10);
        }
        String bizDateTo = "";
        if (filter.getString("findDateTo") != null && filter.getString("findDateTo").length() > 0) {
            bizDateTo = filter.getString("findDateTo").substring(0, 10);
        }
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORTAPPLAY") + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "STORAGE_TITLE") + "\uff1a" + storagenumber);
        titles.AddTitle(1, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORTBIASIS_TIME") + "\uff1a" + bizDateFrom);
        titles.AddTitle(2, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_TO") + "\uff1a" + bizDateTo);
        return titles;
    }

    private List getRowSetForcolum(RptParams filter) throws BOSException {
        ArrayList<String> frow = new ArrayList<String>();
        try {
            IRowSet rows = DbUtil.executeQuery((Context)this.getContext(), (String)this.getFaultSorts(filter));
            if (rows.size() > 0) {
                while (rows.next()) {
                    if (this.buildWhichGroupByFilters(filter).equals("location")) {
                        if (rows.getString("FFaultsortNameLo") == null) continue;
                        frow.add(rows.getString("FFaultsortNameLo"));
                        continue;
                    }
                    if (rows.getString("FFaultsortName") == null) continue;
                    frow.add(rows.getString("FFaultsortName"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException();
        }
        return frow;
    }

    private String getTempTableNameMain(RptParams filter) throws BOSException {
        String tempTableNameMain;
        StringBuffer createTableMain = this.getTempTableMain(filter);
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableNameMain;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempMidTabNameLoFausort;
        String tempMiddleTableNameLo;
        String tempMidTabNameCateFausort;
        String tempMiddleTableName;
        StringBuffer createTempMidCateFaultsort;
        StringBuffer createTempMid;
        String groupBy = this.buildWhichGroupByFilters(filter);
        String tempTableNameMain = null;
        if (groupBy.equals(CATEGORY)) {
            createTempMid = this.getTempTableMidCate(filter);
            createTempMidCateFaultsort = this.getTempTableMidCateFaultsorts(filter);
            try {
                tempMiddleTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMid.toString());
                TAB_CATE_FAULT = tempMidTabNameCateFausort = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMidCateFaultsort.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.dealWithMidFausortForCate(tempMidTabNameCateFausort, filter);
            tempTableNameMain = this.getTempTableNameMain(filter);
            this.insertTempTableMidByCategory(tempMiddleTableName, filter, tempMidTabNameCateFausort);
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableCategory(tempTableNameMain, tempMiddleTableName, filter, tempMidTabNameCateFausort));
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableCategorySpec(tempTableNameMain, tempMiddleTableName, filter, tempMidTabNameCateFausort));
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempMiddleTableName);
        }
        if (groupBy.equals(LOCATION)) {
            StringBuffer createTempMidLo = this.getTempTableMidLo(filter);
            StringBuffer createTempMidLoFaultsort = this.getTempTableMidLoFaultsorts(filter);
            try {
                tempMiddleTableNameLo = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMidLo.toString());
                TAB_LO_FAULT = tempMidTabNameLoFausort = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMidLoFaultsort.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.dealWithMidFausortForLoc(tempMidTabNameLoFausort, filter);
            tempTableNameMain = this.getTempTableNameMain(filter);
            this.insertTempTableMidByLocation(tempMiddleTableNameLo, filter, tempMidTabNameLoFausort);
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableLocation(tempTableNameMain, tempMiddleTableNameLo, filter, tempMidTabNameLoFausort));
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableLocationSpec(tempTableNameMain, tempMiddleTableNameLo, filter, tempMidTabNameLoFausort));
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempMiddleTableNameLo);
        }
        if (groupBy.equals(ALL)) {
            createTempMid = this.getTempTableMidCate(filter);
            createTempMidCateFaultsort = this.getTempTableMidCateFaultsorts(filter);
            try {
                tempMiddleTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMid.toString());
                tempMidTabNameCateFausort = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMidCateFaultsort.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            StringBuffer createTempMidLo = this.getTempTableMidLo(filter);
            StringBuffer createTempMidLoFaultsort = this.getTempTableMidLoFaultsorts(filter);
            try {
                tempMiddleTableNameLo = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMidLo.toString());
                tempMidTabNameLoFausort = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempMidLoFaultsort.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.dealWithMidFausortForCate(tempMidTabNameCateFausort, filter);
            this.dealWithMidFausortForLoc(tempMidTabNameLoFausort, filter);
            this.insertTempTableMidByLocation(tempMiddleTableNameLo, filter, tempMidTabNameLoFausort);
            this.insertTempTableMidByCategory(tempMiddleTableName, filter, tempMidTabNameCateFausort);
            DbUtil.execute((Context)this.getContext(), (String)this.updateFaultsort(tempMidTabNameCateFausort, tempMidTabNameLoFausort));
            TAB_CATE_FAULT = tempMidTabNameCateFausort;
            tempTableNameMain = this.getTempTableNameMain(filter);
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableLocation(tempTableNameMain, tempMiddleTableNameLo, filter, tempMidTabNameLoFausort));
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableCategory(tempTableNameMain, tempMiddleTableName, filter, tempMidTabNameCateFausort));
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableCategorySpec(tempTableNameMain, tempMiddleTableName, filter, tempMidTabNameCateFausort));
            DbUtil.execute((Context)this.getContext(), (String)this.insertTableLocationSpec(tempTableNameMain, tempMiddleTableNameLo, filter, tempMidTabNameLoFausort));
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempMiddleTableName);
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempMiddleTableNameLo);
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempMidTabNameLoFausort);
        }
        DbUtil.execute((Context)this.getContext(), (String)this.insertTabTotal(tempTableNameMain, filter));
        return tempTableNameMain;
    }

    private void dealWithMidFausortForLoc(String tempMidTabNameLoFausort, RptParams filter) throws BOSException {
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTabLoFaultsort(tempMidTabNameLoFausort, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTabLoFaultsort2(tempMidTabNameLoFausort, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithFaultsortTotalLo(tempMidTabNameLoFausort, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.updateTempMidfausortLo(tempMidTabNameLoFausort, filter));
    }

    private void dealWithMidFausortForCate(String tempMidTabNameCateFausort, RptParams filter) throws BOSException {
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableCateFaultsorts(tempMidTabNameCateFausort, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableCateFaultsorts2(tempMidTabNameCateFausort, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithFaultsortTotal(tempMidTabNameCateFausort, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.updateTempMidfausort(tempMidTabNameCateFausort, filter));
    }

    private String updateFaultsort(String tempMidTabNameCateFausort, String tempMidTabNameLoFausort) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameCateFausort + " (FTempBasisid,FTempFaultsorts,FFaultsortName,FTempColum) " + "(select FTempBasisidLo," + "FTempFaultsortsLo," + "FFaultsortNameLo," + "FTempColum");
        sql.append(" from " + tempMidTabNameLoFausort + " t where FTempColum = 'Ftotal')");
        return sql.toString();
    }

    private String insertTabTotal(String tempTableNameMain, RptParams filter) throws BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTableNameMain + " (FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
        List frow = this.getRowSetForcolum(filter);
        if (frow.size() > 0) {
            for (i = 0; i < frow.size(); ++i) {
                sql.append("ffault" + i + ",");
            }
        }
        sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FUnTimeAmountTotal,FFixedTimeTotal,FStopTimeTotal,FForOrder) (select '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "AGGREGATELY") + "'," + "sum(t.FDefectAmount) FDefectAmount," + "sum(t.FFixdFaultsTotal) FFixdFaultsTotal," + "sum(t.FClosed) FClosed,");
        if (frow.size() > 0) {
            for (i = 0; i < frow.size(); ++i) {
                sql.append("sum(t.ffault" + i + ") ffault" + i + ",");
            }
        }
        sql.append("sum(t.FCurrentDefectTotals) FCurrentDefectTotals,sum(t.FApplayStatus) FApplayStatus,sum(t.FPlanStatus) FPlanStatus,sum(t.FCloseStatus) FCloseStatus,sum(t.FBeforeTotals) FBeforeTotals,sum(t.FFixedDefectTotals) FFixedDefectTotals,sum(t.FUnTimeAmountTotal) FUnTimeAmountTotal,sum(t.FFixedTimeTotal) FFixedTimeTotal,sum(t.FStopTimeTotal) FStopTimeTotal,3 ");
        sql.append("from " + tempTableNameMain + " t)");
        return sql.toString();
    }

    private StringBuffer getTempTableMain(RptParams filter) throws BOSException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getEQMDefectPool ( ");
        createTable.append("FBasis varchar(255) DEFAULT(' ')");
        createTable.append(",FDefectAmount decimal(21,0)  default(0)");
        createTable.append(",FFixdFaultsTotal decimal(21,0)  default(0)");
        createTable.append(",FClosed decimal(21,0)  default(0)");
        createTable.append(",FCurrentDefect varchar(44) DEFAULT(' ')");
        createTable.append(",FCurrentDefectTotals decimal(21,0)  default(0)");
        createTable.append(",FApplayStatus decimal(21,0)  default(0)");
        createTable.append(",FPlanStatus decimal(21,0)  default(0)");
        createTable.append(",FCloseStatus decimal(21,0) default(0) ");
        createTable.append(",FFaultSort varchar(44) DEFAULT(' ')");
        List frow = this.getRowSetForcolum(filter);
        if (frow.size() > 0) {
            for (int i = 0; i < frow.size(); ++i) {
                createTable.append(",FFault" + i + " decimal(21,0) default(0) ");
            }
        }
        createTable.append(",FBeforeTotals decimal(21,0) default(0) ");
        createTable.append(",FFixedDefectTotals decimal(21,0) default(0) ");
        createTable.append(",FFixedPer decimal(21,2) default(0) ");
        createTable.append(",FUnTimeAmountTotal decimal(21,0) default(0) ");
        createTable.append(",FOnTimePer decimal(21,2) default(0) ");
        createTable.append(",FFixedTimeAverage decimal(21,2) default(0) ");
        createTable.append(",FFixedTimeTotal decimal(21,2) default(0) ");
        createTable.append(",FNoFaultAverage decimal(21,2) default(0) ");
        createTable.append(",FStopTimeTotal decimal(21,2) default(0) ");
        createTable.append(",FForOrder decimal(21,2) default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        String groupBy = this.buildWhichGroupByFilters(filter);
        StringBuffer basisColum = new StringBuffer();
        if (groupBy.equals("category")) {
            basisColum.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMCATEGORY"));
        } else if (groupBy.equals("location")) {
            basisColum.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMLOCATION"));
        } else {
            basisColum.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMCATEGORY") + "/" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMLOCATION"));
        }
        ReportHeader root = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", root);
        ReportHeader child = root.addChild("FBasis", basisColum.toString());
        dctHeader.put(child.getFieldName(), child);
        child.setType(1);
        child.setAlign(1);
        child.setWidth(120);
        child = root.addChild("FDefectAmount", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "DEFECTTOTALS"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child = root.addChild("FFixdFaultsTotal", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "DEFECTFIXED"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child = root.addChild("FClosed", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "UNCLOSED"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child = root.addChild("FCurrentDefect", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "CURRENTDEFECT"));
        ReportHeader nextChild = child.addChild("FCurrentDefectTotals", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "CURRENTDEFECT") + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_TOTALS"));
        dctHeader.put(nextChild.getFieldName(), nextChild);
        nextChild.setLevel(2);
        nextChild.setType(2);
        nextChild.setAlign(3);
        nextChild.setDecimal(0);
        nextChild = child.addChild("FApplayStatus", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "APPLAYSTATUS"));
        dctHeader.put(nextChild.getFieldName(), nextChild);
        nextChild.setLevel(2);
        nextChild.setType(2);
        nextChild.setAlign(3);
        nextChild.setDecimal(0);
        nextChild = child.addChild("FPlanStatus", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "PLANSTATUS"));
        dctHeader.put(nextChild.getFieldName(), nextChild);
        nextChild.setLevel(2);
        nextChild.setType(2);
        nextChild.setAlign(3);
        nextChild.setDecimal(0);
        nextChild = child.addChild("FCloseStatus", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "FIXEDTOTALS"));
        dctHeader.put(nextChild.getFieldName(), nextChild);
        nextChild.setLevel(2);
        nextChild.setType(2);
        nextChild.setAlign(3);
        nextChild.setDecimal(0);
        List frow = this.getRowSetForcolum(filter);
        if (frow.size() > 0) {
            child = root.addChild("FFaultSort", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "CURRENTDEFECTTYPE"));
            dctHeader.put(child.getFieldName(), child);
            if (frow.size() == 1) {
                child.setCaption(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "CURRENTDEFECTTYPE") + "\n" + (String)frow.get(0));
                child.setFieldName("FFault0");
                child.setType(2);
                child.setAlign(3);
                child.setDecimal(0);
            } else {
                for (int i = 0; i < frow.size(); ++i) {
                    ReportHeader underChild = child.addChild("FFault" + i, (String)frow.get(i));
                    dctHeader.put(underChild.getFieldName(), underChild);
                    underChild.setLevel(2);
                    underChild.setType(2);
                    underChild.setAlign(3);
                    underChild.setDecimal(0);
                }
            }
        }
        child = root.addChild("FBeforeTotals", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "BEFOREDEFECTS"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setWidth(120);
        child = root.addChild("FFixedDefectTotals", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "FIXFIXEDDEFECTS"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child = root.addChild("FFixedPer", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "FIXEDPER"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setDecimal(2);
        child = root.addChild("FUnTimeAmountTotal", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "UNINTIMES"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child = root.addChild("FOnTimePer", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "INTIMEPER"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setDecimal(2);
        if (!groupBy.equals("location")) {
            child = root.addChild("FFixedTimeAverage", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "AVEFIXTIME"));
            dctHeader.put(child.getFieldName(), child);
            child.setType(2);
            child.setAlign(3);
            child.setWidth(120);
        }
        child = root.addChild("FFixedTimeTotal", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "FIXEDTOTALTIMES"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        if (!groupBy.equals("location")) {
            child = root.addChild("FNoFaultAverage", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "UNDEFECTTIMEAVE"));
            dctHeader.put(child.getFieldName(), child);
            child.setType(2);
            child.setAlign(3);
            child.setWidth(130);
        }
        if (!groupBy.equals("location")) {
            child = root.addChild("FStopTimeTotal", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "TOTALSTOPTIMES"));
            dctHeader.put(child.getFieldName(), child);
            child.setType(2);
            child.setAlign(3);
        }
        return root;
    }

    private String getFaultSorts(RptParams filter) {
        StringBuffer sql = new StringBuffer();
        if (this.buildWhichGroupByFilters(filter).equals("category")) {
            sql.append("select distinct ffaultsortname from " + TAB_CATE_FAULT + " where FTempColum = 'Ftotal'");
        } else if (this.buildWhichGroupByFilters(filter).equals("location")) {
            sql.append("select distinct FFaultsortNameLo from " + TAB_LO_FAULT + " where FTempColum = 'Ftotal'");
        } else {
            sql.append("select distinct ffaultsortname from " + TAB_CATE_FAULT + " where FTempColum = 'Ftotal'");
        }
        return sql.toString();
    }

    private String insertTableCategory(String tempTableNameMain, String tempMiddleTableName, RptParams filter, String tempMidTabNameCateFausort) throws BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        List frow = this.getRowSetForcolum(filter);
        sql.append("insert into " + tempTableNameMain + " (FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
        if (frow.size() > 0) {
            for (i = 0; i < frow.size(); ++i) {
                sql.append("FFault" + i + ",");
            }
        }
        sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FFixedPer,FUnTimeAmountTotal,FOnTimePer,FFixedTimeAverage,FFixedTimeTotal,FNoFaultAverage,FStopTimeTotal,FForOrder) (select t.ftempbasisname,max(case t.ftabcolum when 'FDefectAmount' then t.ftempacount else 0 end) FDefectAmount,max(case t.ftabcolum when 'FFixdFaultsTotal' then t.ftempacount else 0 end) FFixdFaultsTotal,max(case t.ftabcolum when 'FClosed' then t.ftempacount else 0 end) FClosed,");
        if (frow.size() > 0) {
            for (i = 0; i < frow.size(); ++i) {
                sql.append("max(case tt.FFaultsortName when '" + (String)frow.get(i) + "' then tt.FTempFaultsorts else 0 end) FFault" + i + ",");
            }
        }
        sql.append("max(case t.ftabcolum when 'FCurrentDefectTotals' then t.ftempacount else 0 end) FCurrentDefectTotals,max(case t.ftabcolum when 'FApplayStatus' then t.ftempacount else 0 end) FApplayStatus,max(case t.ftabcolum when 'FPlanStatus' then t.ftempacount else 0 end) FPlanStatus,max(case t.ftabcolum when 'FCloseStatus' then t.ftempacount else 0 end) FCloseStatus,max(case t.ftabcolum when 'FBeforeTotals' then t.ftempacount else 0 end) FBeforeTotals,max(case t.ftabcolum when 'FFixedDefectTotals' then t.ftempacount else 0 end) FFixedDefectTotals,max(case t.ftabcolum when 'FFixedPer' then t.ftempacount else 0 end) FFixedPer,max(case t.ftabcolum when 'FUnTimeAmountTotal' then t.ftempacount else 0 end) FUnTimeAmountTotal,max(case t.ftabcolum when 'FOnTimePer' then t.ftempacount else 0 end) FOnTimePer,max(case t.ftabcolum when 'FFixedTimeAverage' then t.ftempacount else 0 end) FFixedTimeAverage,max(case t.ftabcolum when 'FFixedTimeTotal' then t.ftempacount else 0 end) FFixedTimeTotal,max(case t.ftabcolum when 'FNoFaultAverage' then t.ftempacount else 0 end) FNoFaultAverage,max(case t.ftabcolum when 'FStopTimeTotal' then t.ftempacount else 0 end) FStopTimeTotal,1");
        sql.append(" from " + tempMiddleTableName + " " + "t left outer join " + tempMidTabNameCateFausort + " tt on t.ftempbasis=tt.ftempbasisid " + "where t.ftempbasis is not null and tt.FFaultsortName is not null and tt.FTempColum = 'Ftotal' " + " group by ftempbasis ,t.ftempbasisname )");
        return sql.toString();
    }

    private String insertTableCategorySpec(String tempTableNameMain, String tempMiddleTableName, RptParams filter, String tempMidTabNameCateFausort) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTableNameMain + " (FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
        sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FFixedPer,FUnTimeAmountTotal,FOnTimePer,FFixedTimeAverage,FFixedTimeTotal,FNoFaultAverage,FStopTimeTotal,FForOrder) (select t.ftempbasisname,max(case t.ftabcolum when 'FDefectAmount' then t.ftempacount else 0 end) FDefectAmount,max(case t.ftabcolum when 'FFixdFaultsTotal' then t.ftempacount else 0 end) FFixdFaultsTotal,max(case t.ftabcolum when 'FClosed' then t.ftempacount else 0 end) FClosed,");
        sql.append("max(case t.ftabcolum when 'FCurrentDefectTotals' then t.ftempacount else 0 end) FCurrentDefectTotals,max(case t.ftabcolum when 'FApplayStatus' then t.ftempacount else 0 end) FApplayStatus,max(case t.ftabcolum when 'FPlanStatus' then t.ftempacount else 0 end) FPlanStatus,max(case t.ftabcolum when 'FCloseStatus' then t.ftempacount else 0 end) FCloseStatus,max(case t.ftabcolum when 'FBeforeTotals' then t.ftempacount else 0 end) FBeforeTotals,max(case t.ftabcolum when 'FFixedDefectTotals' then t.ftempacount else 0 end) FFixedDefectTotals,max(case t.ftabcolum when 'FFixedPer' then t.ftempacount else 0 end) FFixedPer,max(case t.ftabcolum when 'FUnTimeAmountTotal' then t.ftempacount else 0 end) FUnTimeAmountTotal,max(case t.ftabcolum when 'FOnTimePer' then t.ftempacount else 0 end) FOnTimePer,max(case t.ftabcolum when 'FFixedTimeAverage' then t.ftempacount else 0 end) FFixedTimeAverage,max(case t.ftabcolum when 'FFixedTimeTotal' then t.ftempacount else 0 end) FFixedTimeTotal,max(case t.ftabcolum when 'FNoFaultAverage' then t.ftempacount else 0 end) FNoFaultAverage,max(case t.ftabcolum when 'FStopTimeTotal' then t.ftempacount else 0 end) FStopTimeTotal,1");
        sql.append(" from " + tempMiddleTableName + " t " + "where t.ftempbasis is not null and t.ftempbasis in(" + "select distinct t.ftempbasis from " + tempMiddleTableName + " t where t.ftempbasis not in " + "(select distinct tt.ftempbasisid from " + tempMidTabNameCateFausort + " tt))" + " group by ftempbasis ,t.ftempbasisname )");
        return sql.toString();
    }

    private String insertTableLocation(String tempTableNameMain, String tempMiddleTableNameLo, RptParams filter, String tempMidTabNameLoFausort) throws BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        List frow = this.getRowSetForcolum(filter);
        sql.append("insert into " + tempTableNameMain + " (FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
        if (frow.size() > 0) {
            for (i = 0; i < frow.size(); ++i) {
                sql.append("FFault" + i + ",");
            }
        }
        sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FFixedPer,FUnTimeAmountTotal,FOnTimePer,FFixedTimeTotal,FForOrder) (select t.FTempBasisNameLo,max(case t.FTabColumLo when 'FDefectAmount' then t.FTempAcountLo else 0 end) FDefectAmount,max(case t.FTabColumLo when 'FFixdFaultsTotal' then t.FTempAcountLo else 0 end) FFixdFaultsTotal,max(case t.FTabColumLo when 'FClosed' then t.FTempAcountLo else 0 end) FClosed,");
        if (frow.size() > 0) {
            for (i = 0; i < frow.size(); ++i) {
                sql.append("max(case tt.FFaultsortNameLo when '" + (String)frow.get(i) + "' then tt.FTempFaultsortsLo else 0 end) FFault" + i + ",");
            }
        }
        sql.append("max(case t.FTabColumLo when 'FCurrentDefectTotals' then t.FTempAcountLo else 0 end) FCurrentDefectTotals,max(case t.FTabColumLo when 'FApplayStatus' then t.FTempAcountLo else 0 end) FApplayStatus,max(case t.FTabColumLo when 'FPlanStatus' then t.FTempAcountLo else 0 end) FPlanStatus,max(case t.FTabColumLo when 'FCloseStatus' then t.FTempAcountLo else 0 end) FCloseStatus,max(case t.FTabColumLo when 'FBeforeTotals' then t.FTempAcountLo else 0 end) FBeforeTotals,max(case t.FTabColumLo when 'FFixedDefectTotals' then t.FTempAcountLo else 0 end) FFixedDefectTotals,max(case t.FTabColumLo when 'FFixedPer' then t.FTempAcountLo else 0 end) FFixedPer,max(case t.FTabColumLo when 'FUnTimeAmountTotal' then t.FTempAcountLo else 0 end) FUnTimeAmountTotal,max(case t.FTabColumLo when 'FOnTimePer' then t.FTempAcountLo else 0 end) FOnTimePer,max(case t.FTabColumLo when 'FFixedTimeTotal' then t.FTempAcountLo else 0 end) FFixedTimeTotal,2");
        sql.append(" from " + tempMiddleTableNameLo + " " + "t left outer join " + tempMidTabNameLoFausort + " tt on t.FTempBasisLo=tt.FTempBasisidLo " + "where t.FTempBasisLo is not null and tt.FFaultsortNameLo is not null and tt.FTempColum = 'Ftotal' " + "group by FTempBasisLo ,t.FTempBasisNameLo )");
        return sql.toString();
    }

    private String insertTableLocationSpec(String tempTableNameMain, String tempMiddleTableNameLo, RptParams filter, String tempMidTabNameLoFausort) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTableNameMain + " (FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
        sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FFixedPer,FUnTimeAmountTotal,FOnTimePer,FFixedTimeTotal,FForOrder) (select t.FTempBasisNameLo,max(case t.FTabColumLo when 'FDefectAmount' then t.FTempAcountLo else 0 end) FDefectAmount,max(case t.FTabColumLo when 'FFixdFaultsTotal' then t.FTempAcountLo else 0 end) FFixdFaultsTotal,max(case t.FTabColumLo when 'FClosed' then t.FTempAcountLo else 0 end) FClosed,");
        sql.append("max(case t.FTabColumLo when 'FCurrentDefectTotals' then t.FTempAcountLo else 0 end) FCurrentDefectTotals,max(case t.FTabColumLo when 'FApplayStatus' then t.FTempAcountLo else 0 end) FApplayStatus,max(case t.FTabColumLo when 'FPlanStatus' then t.FTempAcountLo else 0 end) FPlanStatus,max(case t.FTabColumLo when 'FCloseStatus' then t.FTempAcountLo else 0 end) FCloseStatus,max(case t.FTabColumLo when 'FBeforeTotals' then t.FTempAcountLo else 0 end) FBeforeTotals,max(case t.FTabColumLo when 'FFixedDefectTotals' then t.FTempAcountLo else 0 end) FFixedDefectTotals,max(case t.FTabColumLo when 'FFixedPer' then t.FTempAcountLo else 0 end) FFixedPer,max(case t.FTabColumLo when 'FUnTimeAmountTotal' then t.FTempAcountLo else 0 end) FUnTimeAmountTotal,max(case t.FTabColumLo when 'FOnTimePer' then t.FTempAcountLo else 0 end) FOnTimePer,max(case t.FTabColumLo when 'FFixedTimeTotal' then t.FTempAcountLo else 0 end) FFixedTimeTotal,2");
        sql.append(" from " + tempMiddleTableNameLo + " t " + "where t.FTempBasisLo is not null and t.ftempbasislo in(" + "select distinct t.ftempbasislo from " + tempMiddleTableNameLo + " t " + "where t.ftempbasislo not in (select distinct tt.ftempbasisidlo from " + tempMidTabNameLoFausort + " tt))");
        sql.append(" group by FTempBasisLo ,t.FTempBasisNameLo )");
        return sql.toString();
    }

    private StringBuffer getTempTableMidCate(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempMidTableCate ( ");
        createTable.append("FTempBasis varchar(44) DEFAULT(' ')");
        createTable.append(",FTempBasisName Nvarchar(255) DEFAULT(' ')");
        createTable.append(",FTempAcount decimal(21,4)  default(0)");
        createTable.append(",FTabColum varchar(44) DEFAULT(' ')");
        createTable.append(" ) ");
        return createTable;
    }

    private StringBuffer getTempTableMidLo(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempMidTableLo ( ");
        createTable.append("FTempBasisLo varchar(44) DEFAULT(' ')");
        createTable.append(",FTempBasisNameLo Nvarchar(255) DEFAULT(' ')");
        createTable.append(",FTempAcountLo decimal(21,4)  default(0)");
        createTable.append(",FTabColumLo varchar(44) DEFAULT(' ')");
        createTable.append(" ) ");
        return createTable;
    }

    private StringBuffer getTempTableMidCateFaultsorts(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempMidTableCateFaults ( ");
        createTable.append("FTempBasisid varchar(44) DEFAULT(' ')");
        createTable.append(",FTempFaultsorts decimal(21,0)  default(0)");
        createTable.append(",FFaultsortName Nvarchar(255) DEFAULT(' ')");
        createTable.append(",FTempColum varchar(44) DEFAULT(' ')");
        createTable.append(" ) ");
        return createTable;
    }

    private StringBuffer getTempTableMidLoFaultsorts(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempMidTableLoFaults ( ");
        createTable.append("FTempBasisidLo varchar(44) DEFAULT(' ')");
        createTable.append(",FTempFaultsortsLo decimal(21,0)  default(0)");
        createTable.append(",FFaultsortNameLo Nvarchar(255) DEFAULT(' ')");
        createTable.append(",FTempColum varchar(44) DEFAULT(' ')");
        createTable.append(" ) ");
        return createTable;
    }

    private void insertTempTableMidByCategory(String tempMiddleTableName, RptParams filter, String tempMidTabNameCateFausort) throws BOSException {
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableFixedFaults(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableFixedFaults2(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithFixedFaultsTotal(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableCurrents(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.iinsertMidTableCurrents2(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithCurrentDets(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableApplayStatus(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTablePlanStatus(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableClosed(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableBeforeFaults(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableBeforeFaults2(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithBeforTotals(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableClearBefores(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableClearBefores2(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWitheFixedDefects(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableUnontimes(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableUnontimes2(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithUnTimeAmountTotal(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableontimes(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableontimes2(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableAverFixed(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableTotalFixedTime(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableAveNormal(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableTotalStotime(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithTotalFualts(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithUnClosedFaults(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithClearFaultsTotal(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithClearFaultsRate(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithOntimeTotals(tempMiddleTableName, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithOntimeRate(tempMiddleTableName, filter));
    }

    private String dealWithFixedFaultsTotal(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildFixedFaultsTotals(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildFixedFaultsTotals(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname, sum(t.ftempacount),'FFixdFaultsTotal' from " + tempMiddleTableName + " t " + "where t.ftabcolum = 'FFixdFaults' " + "  group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String updateTempMidfausort(String tempMidTabNameLoFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempMidTabNameLoFausort + " set FFaultsortName = " + "(select ef.fname_" + this.getContext().getLocale() + " from t_eqm_equipmentfaultsorttree ef where ef.fnumber = FFaultsortName and FTempColum = 'Ftotal')");
        return sql.toString();
    }

    private String dealWithFaultsortTotal(String tempMidTabNameCateFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameCateFausort + " " + "(FTempBasisid,FTempFaultsorts,FFaultsortName,FTempColum) (" + this.buildFaultsortTotal(filter, tempMidTabNameCateFausort));
        sql.append(")");
        return sql.toString();
    }

    private String buildFaultsortTotal(RptParams filter, String tempMidTabNameCateFausort) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisid, sum(t.FTempFaultsorts),t.FFaultsortName,'Ftotal' from " + tempMidTabNameCateFausort + " t " + "where t.FTempColum = 'Fmid' " + "  group by t.FTempBasisid,t.FFaultsortName");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithUnTimeAmountTotal(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildUnTimeAmountTotal(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildUnTimeAmountTotal(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname, sum(t.ftempacount),'FUnTimeAmountTotal' from " + tempMiddleTableName + " t " + "where t.ftabcolum = 'FUnTimeAmount' " + "  group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWitheFixedDefects(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildFixedDefects(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildFixedDefects(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname, sum(t.ftempacount),'FFixedDefectTotals' from " + tempMiddleTableName + " t " + "where t.ftabcolum = 'FFixedDefect' " + "  group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithBeforTotals(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildBeforTotals(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildBeforTotals(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname, sum(t.ftempacount),'FBeforeTotals' from " + tempMiddleTableName + " t " + "where t.ftabcolum = 'FBeforeTotal' " + "  group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithCurrentDets(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildCurrentDets(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildCurrentDets(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname, sum(t.ftempacount),'FCurrentDefectTotals' from " + tempMiddleTableName + " t " + "where t.ftabcolum = 'FCurrentDefectTotal' " + "  group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithOntimeRate(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildOntimeRate(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildOntimeRate(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname,round(t1.ftempacount/t.ftempacount*100,4),'FOnTimePer' from " + tempMiddleTableName + " t left join " + tempMiddleTableName + " t1 on (" + "t.ftempbasis = t1.ftempbasis)" + " where t.ftabcolum = 'FDefectAmount' and t1.ftabcolum = 'FOnTimeAmountTotal'");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithOntimeTotals(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildOntimeTotals(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildOntimeTotals(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname, sum(t.ftempacount),'FOnTimeAmountTotal' from " + tempMiddleTableName + " t " + "where t.ftabcolum = 'FOnTimeAmount' " + "  group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithUnClosedFaults(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildTotalUnClosedFaults(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildTotalUnClosedFaults(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select st.ftempbasis,st.ftempbasisname, sum(st.amount),'FClosed' from (select t.ftempbasis,t.ftempbasisname,t.ftempacount as amount from " + tempMiddleTableName + " t where t.ftabcolum = 'FDefectAmount' union " + "select t1.ftempbasis,t1.ftempbasisname,(0-t1.ftempacount) as amount from " + tempMiddleTableName + " t1 where t1.ftabcolum = 'FFixdFaultsTotal') st" + " where st.ftempbasisname is not null");
        sb.append("  group by st.ftempbasis,st.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithClearFaultsTotal(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildTotalFixedFaults(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildTotalFixedFaults(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname,sum(t.ftempacount),'FFixdFaultsTotal' from " + tempMiddleTableName + " t " + " where t.ftabcolum = 'FFixdFaults'" + " group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithClearFaultsRate(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildClearFaultsRate(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildClearFaultsRate(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname,round(t1.ftempacount/t.ftempacount*100,4),'FFixedPer' from " + tempMiddleTableName + " t left join " + tempMiddleTableName + " t1 on (" + "t.ftempbasis = t1.ftempbasis)" + " where t.ftabcolum = 'FDefectAmount' and t1.ftabcolum = 'FFixdFaultsTotal'");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithTotalFualts(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildTotalFaultSorts(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildTotalFaultSorts(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasis,t.ftempbasisname,sum(t.ftempacount),'FDefectAmount' from " + tempMiddleTableName + " t " + " where t.ftabcolum = 'FCurrentDefectTotals'" + " or t.ftabcolum = 'FBeforeTotals' or t.ftabcolum = 'FFixedDefectTotals'" + " group by t.ftempbasis,t.ftempbasisname");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String insertMidTableCateFaultsorts2(String tempMidTabNameCateFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameCateFausort + " " + "(FTempBasisid,FTempFaultsorts,FFaultsortName,FTempColum) (" + this.buildFaultSortsFromFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableCateFaultsorts(String tempMidTabNameCateFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameCateFausort + " " + "(FTempBasisid,FTempFaultsorts,FFaultsortName,FTempColum) (" + this.buildFaultSortsFromTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private void insertTempTableMidByLocation(String tempMiddleTableNameLo, RptParams filter, String tempMidTabNameLoFausort) throws BOSException {
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableFixedFaultsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableFixedFaultsLo2(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithFixedFaultsTotalLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableCurrentsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.iinsertMidTableCurrentsLo2(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithCurrentDetsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableApplayStatusLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTablePlanStatusLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableClosedLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableBeforeFaultsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableBeforeFaultsLo2(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithBeforTotalsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableClearBeforesLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableClearBeforesLo2(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWitheFixedDefectsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableUnontimesLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableUnontimesLo2(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithUnTimeAmountTotalLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableontimesLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableontimesLo2(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.insertMidTableTotalFixedTimeLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithTotalFualtsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithUnClosedFaultsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithClearFaultsTotalLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithClearFaultsRateLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithOntimeTotalsLo(tempMiddleTableNameLo, filter));
        DbUtil.execute((Context)this.getContext(), (String)this.dealWithOntimeRateLo(tempMiddleTableNameLo, filter));
    }

    private String dealWithFixedFaultsTotalLo(String tempMiddleTableNameLo, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableNameLo + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildFixedFaultsTotalsLo(filter, tempMiddleTableNameLo));
        sql.append(")");
        return sql.toString();
    }

    private String buildFixedFaultsTotalsLo(RptParams filter, String tempMiddleTableNameLo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.ftempbasisLo,t.ftempbasisnameLo, sum(t.ftempacountLo),'FFixdFaultsTotal' from " + tempMiddleTableNameLo + " t " + "where t.ftabcolumLo = 'FFixdFaults' " + "  group by t.ftempbasisLo,t.ftempbasisnameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String updateTempMidfausortLo(String tempMidTabNameLoFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempMidTabNameLoFausort + " set FFaultsortNameLo = " + "(select ef.fname_" + this.getContext().getLocale() + " from t_eqm_equipmentfaultsorttree ef where ef.fnumber = FFaultsortNameLo and FTempColum = 'Ftotal')");
        return sql.toString();
    }

    private String dealWithFaultsortTotalLo(String tempMidTabNameCateFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameCateFausort + " " + "(FTempBasisidLo,FTempFaultsortsLo,FFaultsortNameLo,FTempColum) (" + this.buildFaultsortTotalLo(filter, tempMidTabNameCateFausort));
        sql.append(")");
        return sql.toString();
    }

    private String buildFaultsortTotalLo(RptParams filter, String tempMidTabNameCateFausort) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisidLo, sum(t.FTempFaultsortsLo),t.FFaultsortNameLo,'Ftotal' from " + tempMidTabNameCateFausort + " t " + "where t.FTempColum = 'Fmid' " + "  group by t.FTempBasisidLo,t.FFaultsortNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithUnTimeAmountTotalLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildUnTimeAmountTotalLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildUnTimeAmountTotalLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo, sum(t.FTempAcountLo),'FUnTimeAmountTotal' from " + tempMiddleTableName + " t " + "where t.FTabColumLo = 'FUnTimeAmount' " + "  group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWitheFixedDefectsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildFixedDefectsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildFixedDefectsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo, sum(t.FTempAcountLo),'FFixedDefectTotals' from " + tempMiddleTableName + " t " + "where t.FTabColumLo = 'FFixedDefect' " + "  group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithBeforTotalsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildBeforTotalsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildBeforTotalsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo, sum(t.FTempAcountLo),'FBeforeTotals' from " + tempMiddleTableName + " t " + "where t.FTabColumLo = 'FBeforeTotal' " + "  group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithCurrentDetsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildCurrentDetsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildCurrentDetsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo, sum(t.FTempAcountLo),'FCurrentDefectTotals' from " + tempMiddleTableName + " t " + "where t.FTabColumLo = 'FCurrentDefectTotal' " + "  group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithOntimeRateLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildOntimeRateLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildOntimeRateLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo,round(t1.FTempAcountLo/t.FTempAcountLo*100,4),'FOnTimePer' from " + tempMiddleTableName + " t left join " + tempMiddleTableName + " t1 on (" + "t.FTempBasisLo = t1.FTempBasisLo)" + " where t.FTabColumLo = 'FDefectAmount' and t1.FTabColumLo = 'FOnTimeAmountTotal'");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithOntimeTotalsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildOntimeTotalsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildOntimeTotalsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo, sum(t.FTempAcountLo),'FOnTimeAmountTotal' from " + tempMiddleTableName + " t " + "where t.FTabColumLo = 'FOnTimeAmount' " + "  group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithUnClosedFaultsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildTotalUnClosedFaultsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildTotalUnClosedFaultsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select st.FTempBasisLo,st.FTempBasisNameLo, sum(st.amount),'FClosed' from (select t.FTempBasisLo,t.FTempBasisNameLo, t.FTempAcountLo as amount from " + tempMiddleTableName + " t where t.ftabcolumLo = 'FDefectAmount' union " + "select t1.FTempBasisLo,t1.FTempBasisNameLo, (0-t1.FTempAcountLo) as amount from " + tempMiddleTableName + " t1 where t1.ftabcolumLo = 'FFixdFaultsTotal') st" + " where st.FTempBasisNameLo is not null ");
        sb.append("group by st.FTempBasisLo,st.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithClearFaultsTotalLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildTotalFixedFaultsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildTotalFixedFaultsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo,sum(t.FTempAcountLo),'FFixdFaultsTotal' from " + tempMiddleTableName + " t " + " where t.FTabColumLo = 'FFixdFaults'" + " group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithClearFaultsRateLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildClearFaultsRateLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildClearFaultsRateLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo,round(t1.FTempAcountLo/t.FTempAcountLo*100,4),'FFixedPer' from " + tempMiddleTableName + " t left join " + tempMiddleTableName + " t1 on (" + "t.FTempBasisLo = t1.FTempBasisLo)" + " where t.FTabColumLo = 'FDefectAmount' and t1.FTabColumLo = 'FFixdFaultsTotal'");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String dealWithTotalFualtsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildTotalFaultSortsLo(filter, tempMiddleTableName));
        sql.append(")");
        return sql.toString();
    }

    private String buildTotalFaultSortsLo(RptParams filter, String tempMiddleTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select t.FTempBasisLo,t.FTempBasisNameLo,sum(t.FTempAcountLo),'FDefectAmount' from " + tempMiddleTableName + " t " + " where t.FTabColumLo = 'FCurrentDefectTotals'" + " or t.FTabColumLo = 'FBeforeTotals' or t.FTabColumLo = 'FFixedDefectTotals'" + " group by t.FTempBasisLo,t.FTempBasisNameLo");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String insertMidTabLoFaultsort2(String tempMidTabNameLoFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameLoFausort + " " + "(FTempBasisidLo,FTempFaultsortsLo,FFaultsortNameLo,FTempColum) (" + this.buildFaultSortsFromTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTabLoFaultsort(String tempMidTabNameLoFausort, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMidTabNameLoFausort + " " + "(FTempBasisidLo,FTempFaultsortsLo,FFaultsortNameLo,FTempColum) (" + this.buildFaultSortsFromFaultLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableCurrentsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildCurDefectsOfFaultLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableFixedFaultsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildFixedOfFaultLoc(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableFixedFaultsLo2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildFixedOfTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String iinsertMidTableCurrentsLo2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildCurDefectsOfTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableApplayStatusLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildApplayStatusOfTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTablePlanStatusLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildPlanStatusOfTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableClosedLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildCloseStatusOfTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableBeforeFaultsLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildBeforeFaultsFromTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableBeforeFaultsLo2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildBeforeFaultsFromFaultLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableClearBeforesLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildClearBeforeFaultsLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableClearBeforesLo2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildClearBeforesFromTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableUnontimesLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildUnOntimeFaultsFromTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableUnontimesLo2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildUnOntimeFaultsFromFaultLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableontimesLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildOntimeFaultsFromTaskLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableontimesLo2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildOntimeFaultsFromFaultLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableTotalFixedTimeLo(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasisLo,FTempBasisNameLo,FTempAcountLo,FTabColumLo) (" + this.buildTotalFixedtimeLo(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableTotalStotime(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildTotalStomTime(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableAveNormal(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildAverageNormalTime(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableTotalFixedTime(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildTotalFixedtime(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableAverFixed(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildAverageFixedtime(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableUnontimes2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildUnOntimeFaultsFromTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableUnontimes(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildUnOntimeFaultsFromFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableontimes2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildOntimeFaultsFromTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableontimes(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildOntimeFaultsFromFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableClearBefores2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildClearBeforesFromFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableClearBefores(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildClearBeforesFromTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableBeforeFaults2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildBeforeFaultsFromTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableBeforeFaults(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildBeforeFaultsFromFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableClosed(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildCloseStatusOfTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTablePlanStatus(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildPlanStatusOfTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableApplayStatus(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildApplayStatusOfTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String iinsertMidTableCurrents2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildCurDefectsOfFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableCurrents(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildCurDefectsOfTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableFixedFaults(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildFixedOfFault(filter));
        sql.append(")");
        return sql.toString();
    }

    private String insertMidTableFixedFaults2(String tempMiddleTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempMiddleTableName + " " + "(FTempBasis,FTempBasisName,FTempAcount,FTabColum) (" + this.buildFixedOfTask(filter));
        sql.append(")");
        return sql.toString();
    }

    private Object buildFixedOfFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FFixdFaults' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and tw.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildFixedOfTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FFixdFaults' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildCurDefectsOfFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FCurrentDefectTotal' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildCurDefectsOfTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FCurrentDefectTotal' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildApplayStatusOfTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FApplayStatus' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and (t.fbillstatus = 20 or t.fbillstatus = 30) ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildPlanStatusOfTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FPlanStatus' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus = 40");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildCloseStatusOfTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FCloseStatus' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus = 49");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildBeforeFaultsFromTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FBeforeTotal' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append("and ((t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 and t.fbillstatus <> 49)");
        sb.append(" OR (t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') and " + "t.fclosedate >= to_date('" + this.getBizDateTo(filter) + "') and t.fbillstatus <> 10" + " and t.fbillstatus <> 60 )" + ")");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildBeforeFaultsFromFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FBeforeTotal' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and ((t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 and tw.fbillstatus <> 49");
        sb.append(" ) OR (t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') and " + "tw.fclosedate >= to_date('" + this.getBizDateTo(filter) + "') and tw.fbillstatus <> 10" + " and tw.fbillstatus <> 60 " + "))");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildClearBeforesFromFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FFixedDefect' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(" and t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildClearBeforesFromTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FFixedDefect' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(" and t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildUnOntimeFaultsFromTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FUnTimeAmount' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(" and t.fclosedate > t.fcompletedate ");
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildUnOntimeFaultsFromFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FUnTimeAmount' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(" and tw.fclosedate >tw.FPlanEndTime ");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildOntimeFaultsFromTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FOnTimeAmount' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(" and t.fclosedate <= t.fcompletedate ");
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildOntimeFaultsFromFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,count(*),'FOnTimeAmount' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(" and tw.fclosedate <= tw.FPlanEndTime ");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildAverageFixedtime(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid ,tc.fname_" + this.getContext().getLocale() + ",round(sum(tr.fhours)*1.0/count(tr.fid), 4),'FFixedTimeAverage' from " + "t_eqm_faultreportentry t ");
        sb.append("inner join t_eqm_workorder tw on t.fparentid = tw.fid left join t_org_storage ts on tw.fplanorgunitid = ts.fid left join t_org_storage ts2 on tw.fmaintainorgunitid = ts2.fid left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid left join t_eqm_equipmentcategory tc on te.fcategoryid = tc.fid left join t_eqm_reportstoptime tr on te.fid = tr.fequipmentnumberid left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID where tw.fequipmentarchivesid is not null and t.ftaskreqid is null and tr.FWorkOrderID is not null");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(this.buildWhereFilters(filter));
        if (filter.getString("findDateTo") != null && !"".equals(filter.getString("findDateTo"))) {
            sb.append(" and tr.FEndDate < to_date('" + this.getBizDateTo(filter) + "')");
        }
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildTotalFixedtime(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid ,tc.fname_" + this.getContext().getLocale() + ",round(sum((datediff(to_date(tochar(tw.frealstarttime, 'yyyy-mm-dd " + "HH24:mi:ss')),to_date(tochar(tw.frealendtime, 'yyyy-mm-dd HH24:mi:ss'))))*1.0 /(60*60)),4),'FFixedTimeTotal' " + "from t_eqm_workorder tw " + "inner join( " + "select distinct tw.fid " + " from t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(this.buildWhereFilters(filter));
        if (filter.getString("findDateTo") != null && !"".equals(filter.getString("findDateTo"))) {
            sb.append(" and tw.FRealEndTime < to_date('" + this.getBizDateTo(filter) + "')");
        }
        sb.append(" ) t on tw.fid = t.fid left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid left join t_eqm_equipmentcategory tc on te.fcategoryid = tc.fid where 1=1 " + this.buildWhereFiltersOfReportCategory(filter) + "");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildAverageNormalTime(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select va.tcid, va.tcname, sum(va.qty) / count(va.teid),'FNoFaultAverage' from (SELECT tc.fid tcid,tc.fname_" + this.getContext().getLocale() + " tcname," + "te.fid teid," + "te.fname," + "round(((datediff(to_date(tochar(min(te.feffectdate),'yyyy-mm-dd') || ' 00:00:00')," + "to_date(tochar(max(tr.fstartdate),'yyyy-mm-dd HH24:mi:ss'))))*1.0 / (60 * 60) - " + "(sum(distinct(tr.fhours))-" + "(datediff(to_date(tochar(max(tr.fstartdate),'yyyy-mm-dd HH24:mi:ss'))," + "to_date(tochar(max(tr.FEndDate),'yyyy-mm-dd HH24:mi:ss'))))*1.0 / (60 * 60))" + ")*1.0 / count(distinct(tr.fid)),4) qty " + "FROM t_eqm_faultreportentry T ");
        sb.append("inner join t_eqm_workorder tw on t.fparentid = tw.fid left join t_org_storage ts on tw.fplanorgunitid = ts.fid left join t_org_storage ts2 on tw.fmaintainorgunitid = ts2.fid left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid left join t_eqm_equipmentcategory tc on te.fcategoryid = tc.fid left join t_eqm_reportstoptime tr on te.fid = tr.fequipmentnumberid left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID where tw.fequipmentarchivesid is not null and t.ftaskreqid is null and tr.FWorkOrderID is not null ");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(this.buildWhereFilters(filter));
        if (filter.getString("findDateTo") != null && !"".equals(filter.getString("findDateTo"))) {
            sb.append(" and tr.FEndDate < to_date('" + this.getBizDateTo(filter) + "')");
        }
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" GROUP BY tc.fid, tc.fname_" + this.getContext().getLocale() + ", te.fid, te.fname) va");
        sb.append(" group by tcid, tcname ");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildTotalStomTime(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,tc.fname_" + this.getContext().getLocale() + " ,sum(tr.fhours),'FStopTimeTotal' from " + "t_eqm_equipmentarchives te " + "inner join " + "(select distinct te.fid " + "from t_eqm_faultreportentry t " + "inner join t_eqm_workorder tw on t.fparentid = tw.fid " + "left join t_org_storage ts on tw.fplanorgunitid = ts.fid " + "left join t_org_storage ts2 on tw.fmaintainorgunitid = ts2.fid " + "left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid " + "left join t_eqm_reportstoptime tr on te.fid = tr.fequipmentnumberid " + "left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID " + "where tw.fequipmentarchivesid is not null and t.ftaskreqid is null and tr.FWorkOrderID is not null " + this.buildWhereFilters(filter) + "");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(")");
        sb.append(" t on te.fid = t.fid left join t_eqm_equipmentcategory tc on te.fcategoryid = tc.fid left join t_eqm_reportstoptime tr on te.fid = tr.fequipmentnumberid where tr.FWorkOrderID is not null AND ");
        if (filter.getString("findDateTo") != null && !"".equals(filter.getString("findDateTo"))) {
            sb.append(" tr.FEndDate < to_date('" + this.getBizDateTo(filter) + "')");
        }
        sb.append("" + this.buildWhereFiltersOfReportCategory(filter) + " group by tc.fid,tc.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildFixedOfFaultLoc(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FFixdFaults' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildFixedOfTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FFixdFaults' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildCurDefectsOfFaultLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FCurrentDefectTotal' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildCurDefectsOfTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FCurrentDefectTotal' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildApplayStatusOfTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FApplayStatus' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and (t.fbillstatus = 20 or t.fbillstatus = 30) ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildPlanStatusOfTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FPlanStatus' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus = 40");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildCloseStatusOfTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FCloseStatus' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus = 49");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildBeforeFaultsFromTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FBeforeTotal' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append("and ((t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60  and t.fbillstatus <> 49)");
        sb.append("OR (t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') and " + "t.fclosedate >= to_date('" + this.getBizDateTo(filter) + "') and t.fbillstatus <> 10" + " and t.fbillstatus <> 60)" + ")");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildBeforeFaultsFromFaultLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FBeforeTotal' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and (( t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 and tw.fbillstatus <> 49)");
        sb.append("OR (t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') and " + "tw.fclosedate >= to_date('" + this.getBizDateTo(filter) + "') and tw.fbillstatus <> 10" + " and tw.fbillstatus <> 60 )" + ")");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildClearBeforeFaultsLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FFixedDefect' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(" and t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildClearBeforesFromTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid,tl.fname_" + this.getContext().getLocale() + ",count(*),'FFixedDefect' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(" and t.ffinddate < to_date('" + filter.getString("findDateFrom") + "') ");
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildUnOntimeFaultsFromTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FUnTimeAmount' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(" and t.fclosedate > t.fcompletedate ");
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildUnOntimeFaultsFromFaultLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FUnTimeAmount' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(" and tw.fclosedate >tw.FPlanEndTime ");
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildOntimeFaultsFromTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FOnTimeAmount' from " + "t_eqm_taskreq t " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.fclosedate"));
        sb.append(" and t.fclosedate <= t.fcompletedate ");
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildOntimeFaultsFromFaultLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",count(*),'FOnTimeAmount' from " + "t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "tw.fclosedate"));
        sb.append(" and tw.fclosedate <= tw.FPlanEndTime ");
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildTotalFixedtimeLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,tl.fname_" + this.getContext().getLocale() + ",round(sum(datediff(to_date(tochar(tw.frealstarttime, " + "'yyyy-mm-dd HH24:mi:ss')),to_date(tochar(tw.frealendtime, 'yyyy-mm-dd HH24:mi:ss'))) /(60 * 60)),4),'FFixedTimeTotal' " + "from t_eqm_workorder tw " + "inner join( " + "select distinct tw.fid " + "from t_eqm_faultreportentry t " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        if (filter.getString("findDateTo") != null && !"".equals(filter.getString("findDateTo"))) {
            sb.append(" and tw.FRealEndTime < to_date('" + this.getBizDateTo(filter) + "')");
        }
        sb.append(" ) t on tw.fid = t.fid left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid left join t_eqm_equipmentlocation tl on tl.fid = tw.feqmlocationid where 1=1 " + this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,tl.fname_" + this.getContext().getLocale() + "");
        String sfilter = sb.toString();
        return sfilter;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        int i;
        StringBuffer sql = new StringBuffer();
        String groupBy = this.buildWhichGroupByFilters(filter);
        List frow = this.getRowSetForcolum(filter);
        if (groupBy.equals("location")) {
            sql.append("SELECT FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
            if (frow.size() > 0) {
                for (i = 0; i < frow.size(); ++i) {
                    sql.append("FFault" + i + ",");
                }
            }
            sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FFixedPer,FUnTimeAmountTotal,FOnTimePer,FFixedTimeTotal");
        } else {
            sql.append("SELECT FBasis,FDefectAmount,FFixdFaultsTotal,FClosed,");
            if (frow.size() > 0) {
                for (i = 0; i < frow.size(); ++i) {
                    sql.append("FFault" + i + ",");
                }
            }
            sql.append("FCurrentDefectTotals,FApplayStatus,FPlanStatus,FCloseStatus,FBeforeTotals,FFixedDefectTotals,FFixedPer,FUnTimeAmountTotal,FOnTimePer,FFixedTimeAverage,FFixedTimeTotal,FNoFaultAverage,FStopTimeTotal");
        }
        sql.append(" FROM " + tableName + " order by FForOrder asc \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)start, (int)rows);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(TAB_CATE_FAULT);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(TAB_LO_FAULT);
        return rs;
    }

    private String buildWhichGroupByFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getObject("EQMCategoryFrom") != null && !"".equals(filter.getObject("EQMCategoryFrom")) || filter.getObject("EQMCategoryTo") != null && !"".equals(filter.getObject("EQMCategoryTo"))) {
            if ((filter.getObject("EQMLocationTo") == null || "".equals(filter.getObject("EQMLocationTo"))) && (filter.getObject("EQMLocationFrom") == null || "".equals(filter.getObject("EQMLocationFrom")))) {
                sb.append("category");
            }
        } else if ((filter.getObject("EQMLocationTo") != null && !"".equals(filter.getObject("EQMLocationTo")) || filter.getObject("EQMLocationFrom") != null && !"".equals(filter.getObject("EQMLocationFrom"))) && (filter.getObject("EQMCategoryFrom") == null || "".equals(filter.getObject("EQMCategoryFrom")) && (filter.getObject("EQMCategoryTo") == null || "".equals(filter.getObject("EQMCategoryTo"))))) {
            sb.append("location");
        }
        if ((filter.getObject("EQMCategoryFrom") != null && !"".equals(filter.getObject("EQMCategoryFrom")) || filter.getObject("EQMCategoryTo") != null && !"".equals(filter.getObject("EQMCategoryTo"))) && (filter.getObject("EQMLocationFrom") != null && !"".equals(filter.getObject("EQMLocationFrom")) || filter.getObject("EQMLocationTo") != null && !"".equals(filter.getObject("EQMLocationTo")))) {
            sb.append("all");
        }
        if (GeneCommonUtils.isEmpty((Object)filter.getObject("EQMCategoryFrom")) && GeneCommonUtils.isEmpty((Object)filter.getObject("EQMCategoryTo")) && GeneCommonUtils.isEmpty((Object)filter.getObject("EQMLocationFrom")) && GeneCommonUtils.isEmpty((Object)filter.getObject("EQMLocationTo"))) {
            sb.append("all");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String getJoinTableFaultEntryByCate() {
        StringBuffer sb = new StringBuffer();
        sb.append(" inner join t_eqm_workorder tw on t.fparentid = tw.fid left join t_org_storage ts on tw.fplanorgunitid = ts.fid left join t_org_storage ts2 on tw.fmaintainorgunitid = ts2.fid left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid left join t_eqm_equipmentcategory tc on te.fcategoryid = tc.fid left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID where tw.fequipmentarchivesid is not null and t.ftaskreqid is null ");
        return sb.toString();
    }

    private String getJoinTableFaultEntryByLo() {
        StringBuffer sb = new StringBuffer();
        sb.append(" inner join t_eqm_workorder tw on t.fparentid = tw.fid left join t_org_storage ts on tw.fplanorgunitid = ts.fid left join t_org_storage ts2 on tw.fmaintainorgunitid = ts2.fid left join t_eqm_equipmentarchives te on te.fid = tw.fequipmentarchivesid left join t_eqm_equipmentlocation tl on tl.fid = tw.feqmlocationid left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID where tw.feqmlocationid is not null and tw.fequipmentarchivesid is null and t.ftaskreqid is null ");
        return sb.toString();
    }

    private String getJoinTableTaskseqByCate() {
        StringBuffer sb = new StringBuffer();
        sb.append("left join t_eqm_equipmentarchives te on te.fid = t.fequipmentarchivesid left join t_eqm_equipmentcategory tc on tc.fid = te.fcategoryid left join t_org_storage ts on ts.fid = t.fstorageorgunitid left join t_org_storage ts2 on ts2.fid = t.fmaintainorgunitid left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID where t.fequipmentarchivesid is not null ");
        return sb.toString();
    }

    private String getJoinTableTaskseqByLo() {
        StringBuffer sb = new StringBuffer();
        sb.append("left join t_eqm_equipmentlocation tl on tl.fid = t.fequipmentlocationid left join t_eqm_equipmentarchives te on te.fid = t.fequipmentarchivesid left join t_org_storage ts on ts.fid = t.fstorageorgunitid left join t_org_storage ts2 on ts2.fid = t.fmaintainorgunitid left join T_EQM_EquipmentFaultSortTree fst on fst.fid = t.FFaultSortID where t.fequipmentlocationid is not null and t.FEquipmentArchivesID is null ");
        return sb.toString();
    }

    private Object buildFaultSortsFromFault(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,count(fs.fid),case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end,'Fmid' from t_eqm_faultreportentry t left join t_eqm_equipmentfaultsorttree fs on t.ffaultsortid = fs.fid " + this.getJoinTableFaultEntryByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tc.fid, case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildFaultSortsFromTask(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tc.fid,count(fs.fid),case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end,'Fmid' from t_eqm_taskreq t left join t_eqm_equipmentfaultsorttree fs on t.ffaultsortid = fs.fid " + this.getJoinTableTaskseqByCate() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportCategory(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tc.fid,case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildFaultSortsFromFaultLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid ,count(fs.fid),case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end,'Fmid' from t_eqm_faultreportentry t left join t_eqm_equipmentfaultsorttree fs on t.ffaultsortid = fs.fid " + this.getJoinTableFaultEntryByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and tw.fbillstatus <> 10 and tw.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end");
        String sfilter = sb.toString();
        return sfilter;
    }

    private Object buildFaultSortsFromTaskLo(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select tl.fid,count(fs.fid), case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end,'Fmid' from t_eqm_taskreq t left join t_eqm_equipmentfaultsorttree fs on t.ffaultsortid = fs.fid " + this.getJoinTableTaskseqByLo() + "");
        sb.append(this.buildWhereFilters(filter));
        sb.append(this.buildWhereFiltersOfDate(filter, "t.ffinddate"));
        sb.append(this.buildWhereFiltersOfReportLocation(filter));
        sb.append(" and t.fbillstatus <> 10 and t.fbillstatus <> 60 ");
        sb.append(" group by tl.fid,case when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') ='0' then fs.fnumber when concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'0') !='0' then concat(substring(fs.flongnumber,0,(case when charindex('!', fs.flongnumber)-1<0 then charindex('!', fs.flongnumber) else charindex('!', fs.flongnumber)-1 end)),'') end");
        String sfilter = sb.toString();
        return sfilter;
    }

    private String buildWhereFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            sb.append(" and ts.FNumber in(" + ReportUtil.StringUtil(filter.getString("storageOrgUnit")));
            sb.append(")");
        }
        if (filter.getString("EQMMaintainOrgUnit") != null && !"".equals(filter.getString("EQMMaintainOrgUnit"))) {
            sb.append(" and ts2.FNumber in(" + ReportUtil.StringUtil(filter.getString("EQMMaintainOrgUnit")));
            sb.append(")");
        }
        if (filter.getObject("EQMArchivesFrom") != null && !"".equals(filter.getObject("EQMArchivesFrom"))) {
            sb.append(" and te.FNumber >='").append(((EquipmentArchivesInfo)filter.getObject("EQMArchivesFrom")).getNumber()).append("'");
        }
        if (filter.getObject("EQMArchivesTo") != null && !"".equals(filter.getObject("EQMArchivesTo"))) {
            sb.append(" and te.FNumber <='").append(((EquipmentArchivesInfo)filter.getObject("EQMArchivesTo")).getNumber()).append("'");
        }
        if (filter.getObject("EQMStopCodeFrom") != null && !"".equals(filter.getObject("EQMStopCodeFrom"))) {
            sb.append(" and fst.FNumber >='").append(((EquipmentFaultSortTreeInfo)filter.getObject("EQMStopCodeFrom")).getNumber()).append("'");
        }
        if (filter.getObject("EQMStopCodeTo") != null && !"".equals(filter.getObject("EQMStopCodeTo"))) {
            sb.append(" and fst.FNumber <='").append(((EquipmentFaultSortTreeInfo)filter.getObject("EQMStopCodeTo")).getNumber()).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String buildWhereFiltersOfDate(RptParams filter, String dateType) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("findDateFrom") != null && !"".equals(filter.getString("findDateFrom"))) {
            sb.append(" and " + dateType + " >= to_date('" + filter.getString("findDateFrom") + "')");
        }
        if (filter.getString("findDateTo") != null && !"".equals(filter.getString("findDateTo"))) {
            sb.append(" and " + dateType + " < to_date('" + this.getBizDateTo(filter) + "')");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String getBizDateTo(RptParams filter) {
        String bizDateTo = filter.getString("findDateTo").substring(0, 10);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String time = sdf.format(sdf.parse(bizDateTo));
            Calendar cd = Calendar.getInstance();
            cd.setTime(sdf.parse(time));
            cd.add(5, 1);
            Date date = cd.getTime();
            bizDateTo = sdf.format(date).toString();
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        return bizDateTo;
    }

    private String buildWhereFiltersOfReportCategory(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getObject("EQMCategoryFrom") != null && !"".equals(filter.getObject("EQMCategoryFrom"))) {
            sb.append(" and tc.FNumber >='").append(((EquipmentCategoryInfo)filter.getObject("EQMCategoryFrom")).getNumber()).append("'");
        }
        if (filter.getObject("EQMCategoryTo") != null && !"".equals(filter.getObject("EQMCategoryTo"))) {
            sb.append(" and tc.FNumber <='").append(((EquipmentCategoryInfo)filter.getObject("EQMCategoryTo")).getNumber()).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }

    private String buildWhereFiltersOfReportLocation(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getObject("EQMLocationFrom") != null && !"".equals(filter.getObject("EQMLocationFrom"))) {
            sb.append(" and tl.FNumber >='").append(((EquipmentLocationInfo)filter.getObject("EQMLocationFrom")).getNumber()).append("'");
        }
        if (filter.getObject("EQMLocationTo") != null && !"".equals(filter.getObject("EQMLocationTo"))) {
            sb.append(" and tl.FNumber <='").append(((EquipmentLocationInfo)filter.getObject("EQMLocationTo")).getNumber()).append("'");
        }
        sfilter = sb.toString();
        return sfilter;
    }
}

