/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.security.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.EquipmentDocBAFacadeFactory;
import com.kingdee.eas.eqm.basedata.IsolationTempInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.security.SecurityMeasureCollection;
import com.kingdee.eas.eqm.security.SecurityMeasureException;
import com.kingdee.eas.eqm.security.SecurityMeasureInfo;
import com.kingdee.eas.eqm.security.WorkPermitFactory;
import com.kingdee.eas.eqm.security.WorkPermitInfo;
import com.kingdee.eas.eqm.security.WorkPermitSecurityMeasureCollection;
import com.kingdee.eas.eqm.security.WorkPermitSecurityMeasureFactory;
import com.kingdee.eas.eqm.security.WorkPermitSecurityMeasureInfo;
import com.kingdee.eas.eqm.security.app.AbstractSecurityMeasureControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class SecurityMeasureControllerBean
extends AbstractSecurityMeasureControllerBean {
    private static final long serialVersionUID = 1L;
    private static SelectorItemCollection sic = new SelectorItemCollection();

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SecurityMeasureInfo info = null;
        try {
            info = (SecurityMeasureInfo)super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SecurityMeasureInfo info = null;
        try {
            info = (SecurityMeasureInfo)super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
        return info;
    }

    @Override
    protected void _forceClosed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        info.setOperation(GeneBillBaseStatusEnum.ForceClosed.getAlias());
        if (info != null) {
            this.verifyForceClosed(info);
            info.setBillStatus(GeneBillBaseStatusEnum.ForceClosed);
            try {
                super._update(ctx, pk, model);
                this.writeLog(ctx, info, "forceclosed", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, info, "forceclosed", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, info, "forceclosed", new Boolean(false));
                throw e2;
            }
        }
    }

    @Override
    protected void _batchForceClosed(Context ctx, IObjectCollection securityMeasureInfos) throws BOSException, EASBizException {
        SecurityMeasureCollection smCollections = new SecurityMeasureCollection();
        for (SecurityMeasureInfo smInfo : securityMeasureInfos) {
            if (smInfo == null) continue;
            this.verifyForceClosed(smInfo);
            smInfo.setBillStatus(GeneBillBaseStatusEnum.ForceClosed);
            smCollections.add(smInfo);
        }
        super._updateBatchData(ctx, (IObjectCollection)smCollections);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        if (info.getIsolationTemp() != null) {
            EquipmentDocBAFacadeFactory.getLocalInstance((Context)ctx).copyRelation(info.getIsolationTemp().getId().toString(), pk.toString());
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SecurityMeasureInfo oldInfo = (SecurityMeasureInfo)this._getValue(ctx, pk, sic);
        IsolationTempInfo oldIsoTempInfo = oldInfo.getIsolationTemp();
        IsolationTempInfo newIsoTempinfo = ((SecurityMeasureInfo)model).getIsolationTemp();
        if (!GeneCommonUtils.equals((Object)newIsoTempinfo, (Object)oldIsoTempInfo)) {
            if (oldIsoTempInfo != null) {
                EquipmentDocBAFacadeFactory.getLocalInstance((Context)ctx).removeRelation(((SecurityMeasureInfo)model).getId().toString(), oldIsoTempInfo.getId().toString());
            }
            if (newIsoTempinfo != null) {
                EquipmentDocBAFacadeFactory.getLocalInstance((Context)ctx).copyRelation(newIsoTempinfo.getId().toString(), ((SecurityMeasureInfo)model).getId().toString());
            }
        }
        super._update(ctx, pk, model);
    }

    private void verifyForceClosed(SecurityMeasureInfo info) throws SecurityMeasureException {
        if (info != null && info.getBillStatus() != GeneBillBaseStatusEnum.SAVE && info.getBillStatus() != GeneBillBaseStatusEnum.Submit && info.getBillStatus() != GeneBillBaseStatusEnum.Audit && info.getBillStatus() != GeneBillBaseStatusEnum.StartIsolation && info.getBillStatus() != GeneBillBaseStatusEnum.FinishIsolation && info.getBillStatus() != GeneBillBaseStatusEnum.StartRestore && info.getBillStatus() != GeneBillBaseStatusEnum.FinishRestore) {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_FORCECLOSED, new Object[]{info.getNumber()});
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        this.verifyAudit(info);
        try {
            super._audit(ctx, pk);
            this.writeLog(ctx, info, "audit", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "audit", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "audit", new Boolean(false));
            throw e2;
        }
    }

    @Override
    protected void _isolationStart(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        if (info != null && info.getBillStatus() == GeneBillBaseStatusEnum.Audit) {
            info.setBillStatus(GeneBillBaseStatusEnum.StartIsolation);
            if (info.getIsolationStartTime() == null) {
                info.setIsolationStartTime(new Date());
            }
            try {
                super._update(ctx, pk, model);
                this.writeLog(ctx, info, "isolationstart", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, info, "isolationstart", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, info, "isolationstart", new Boolean(false));
                throw e2;
            }
        } else {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_ISOSTART, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void _isolationFinish(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        if (info != null && info.getBillStatus() == GeneBillBaseStatusEnum.StartIsolation) {
            info.setBillStatus(GeneBillBaseStatusEnum.FinishIsolation);
            if (info.getIsolationEndTime() == null) {
                info.setIsolationEndTime(new Date());
            }
            if (info.getIsolationPerson() == null) {
                info.setIsolationPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            }
            try {
                super._update(ctx, pk, model);
                this.writeLog(ctx, info, "isolationfinish", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, info, "isolationfinish", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, info, "isolationfinish", new Boolean(false));
                throw e2;
            }
        } else {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_ISOFINISH, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void _restoreStart(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        if (info != null && info.getBillStatus() == GeneBillBaseStatusEnum.FinishIsolation) {
            String number = info.getNumber();
            this.verifyRestoreStart(ctx, number, info);
            info.setBillStatus(GeneBillBaseStatusEnum.StartRestore);
            if (info.getRestoreStartTime() == null) {
                info.setRestoreStartTime(new Date());
            }
            try {
                super._update(ctx, pk, model);
                this.writeLog(ctx, info, "restorestart", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, info, "restorestart", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, info, "restorestart", new Boolean(false));
                throw e2;
            }
        } else {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_CHANGE, new Object[]{info.getNumber()});
        }
    }

    private void verifyRestoreStart(Context ctx, String number, SecurityMeasureInfo info) throws SecurityMeasureException {
        GeneBillBaseStatusEnum permitstatus = null;
        boolean isController = false;
        if (info.getWorkPermit() != null) {
            permitstatus = info.getWorkPermit().getBillStatus();
            isController = info.getWorkPermit().isStrictControl();
        }
        GeneBillBaseStatusEnum orderstatus = null;
        if (info.getWorkOrder() != null) {
            orderstatus = info.getWorkOrder().getBillStatus();
        }
        if (permitstatus != null && orderstatus != null) {
            if (isController && (permitstatus != GeneBillBaseStatusEnum.Sign && permitstatus != GeneBillBaseStatusEnum.Recycle || orderstatus != GeneBillBaseStatusEnum.Finish && orderstatus != GeneBillBaseStatusEnum.Check && orderstatus != GeneBillBaseStatusEnum.CLOSED && orderstatus != GeneBillBaseStatusEnum.ForceClosed)) {
                throw new SecurityMeasureException(SecurityMeasureException.NOT_RESTORESTART_TRUE, new Object[]{number});
            }
            if (!isController && permitstatus != GeneBillBaseStatusEnum.Sign && permitstatus != GeneBillBaseStatusEnum.Recycle) {
                throw new SecurityMeasureException(SecurityMeasureException.NOT_RESTORESTART_FALSE, new Object[]{number});
            }
        } else {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_ORDER, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void _restoreFinish(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        if (info != null && info.getBillStatus() == GeneBillBaseStatusEnum.StartRestore) {
            info.setBillStatus(GeneBillBaseStatusEnum.FinishRestore);
            if (info.getRetoreEndTime() == null) {
                info.setRetoreEndTime(new Date());
            }
            if (info.getRetorePerson() == null) {
                info.setRetorePerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            }
            try {
                super._update(ctx, pk, model);
                this.writeLog(ctx, info, "restorefinish", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, info, "restorefinish", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, info, "restorefinish", new Boolean(false));
                throw e2;
            }
        } else {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_RESTOREEND, new Object[]{info.getNumber()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _checkUseable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        boolean isController = info.getWorkPermit().isStrictControl();
        if (info == null) return;
        if (info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.FinishRestore)) {
            info.setBillStatus(GeneBillBaseStatusEnum.CheckThough);
        } else {
            if (info.getBillStatus() != GeneBillBaseStatusEnum.SAVE && info.getBillStatus() != GeneBillBaseStatusEnum.Submit) throw new SecurityMeasureException(SecurityMeasureException.NOT_THROUGHCHECK, new Object[]{info.getNumber()});
            if (info.getBillStatus() == null || isController) throw new SecurityMeasureException(SecurityMeasureException.NOT_CHECHUSEABLE, new Object[]{info.getNumber()});
            info.setBillStatus(GeneBillBaseStatusEnum.CheckThough);
        }
        if (info.getValidateTime() == null) {
            info.setValidateTime(new Date());
        }
        if (info.getValidator() == null) {
            info.setValidator(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        }
        try {
            super._update(ctx, pk, model);
            this.writeLog(ctx, info, "checkuseable", new Boolean(true));
            return;
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "checkuseable", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "checkuseable", new Boolean(false));
            throw e2;
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SecurityMeasureInfo smi = (SecurityMeasureInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(smi.getId());
        boolean exits = this._exists(ctx, (IObjectPK)pk);
        WorkPermitInfo wp = smi.getWorkPermit();
        IObjectPK PK = super._submit(ctx, model);
        if (exits) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent.*"));
            sic.add(new SelectorItemInfo("secMeasure.*"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("secMeasure.id", (Object)smi.getId().toString(), CompareType.EQUALS);
            FilterItemInfo wpfilterItem = new FilterItemInfo("parent.id", (Object)wp.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItem);
            filterInfo.getFilterItems().add(wpfilterItem);
            viewInfo.setFilter(filterInfo);
            WorkPermitSecurityMeasureCollection wpsmInfoList = WorkPermitSecurityMeasureFactory.getLocalInstance(ctx).getWorkPermitSecurityMeasureCollection(viewInfo);
            WorkPermitSecurityMeasureInfo wpsmInfo = null;
            Iterator itera = wpsmInfoList.iterator();
            while (itera.hasNext()) {
                wpsmInfo = (WorkPermitSecurityMeasureInfo)itera.next();
                wpsmInfo.setSecMeasure(smi);
                wpsmInfo.setParent(wp);
            }
            Iterator iter = wp.getSecurityMeasure().iterator();
            while (iter.hasNext()) {
                WorkPermitSecurityMeasureInfo info = (WorkPermitSecurityMeasureInfo)iter.next();
                if (!info.getId().toString().equals(wpsmInfo.getId().toString())) continue;
                iter.remove();
            }
            if (wpsmInfo != null) {
                wp.getSecurityMeasure().add(wpsmInfo);
            }
        } else {
            WorkPermitSecurityMeasureInfo wpsm = new WorkPermitSecurityMeasureInfo();
            wpsm.setParent(wp);
            wpsm.setSecMeasure(smi);
            wp.getSecurityMeasure().add(wpsm);
        }
        ObjectUuidPK wppk = new ObjectUuidPK(wp.getId());
        WorkPermitFactory.getLocalInstance(ctx).updateForSM((IObjectPK)wppk, wp);
        return PK;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SecurityMeasureInfo smi = (SecurityMeasureInfo)model;
        boolean update = false;
        if (smi != null && smi.getId() != null) {
            update = true;
        }
        IObjectPK pk = super._save(ctx, model);
        if (!update) {
            WorkPermitInfo wp = smi.getWorkPermit();
            WorkPermitSecurityMeasureInfo wpsm = new WorkPermitSecurityMeasureInfo();
            wpsm.setParent(wp);
            wpsm.setSecMeasure(smi);
            wp.getSecurityMeasure().add(wpsm);
            ObjectUuidPK wppk = new ObjectUuidPK(wp.getId());
            WorkPermitFactory.getLocalInstance(ctx).updateForSM((IObjectPK)wppk, wp);
        }
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue model = this._getValue(ctx, pk, sic);
        SecurityMeasureInfo info = (SecurityMeasureInfo)model;
        if (info != null && (info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.StartIsolation) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.FinishIsolation) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.StartRestore) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceClosed) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.FinishRestore))) {
            throw new SecurityMeasureException(SecurityMeasureException.NOT_DELETE, new Object[]{info.getNumber(), info.getBillStatus().getAlias()});
        }
        try {
            super._delete(ctx, pk);
            this.writeLog(ctx, info, "delete", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "delete", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "delete", new Boolean(false));
            throw e2;
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] ps = service.getAllProcessInstancesByBizobjId(pk.toString());
        for (int i = 0; i < ps.length; ++i) {
            ProcessInstInfo pi = ps[i];
            service.abortProcessInst(pi.getProcInstId());
        }
    }

    @Override
    public IObjectPK statusChange(Context ctx, SecurityMeasureInfo model, GeneBillBaseStatusEnum status, String isSubmit) throws BOSException, EASBizException {
        model.setOperation(status.getAlias());
        return super.statusChange(ctx, model, status, isSubmit);
    }

    @Override
    protected IObjectPK _statusChange(Context ctx, IObjectValue model, GeneBillBaseStatusEnum status, String isSubmit) throws BOSException, EASBizException {
        if (isSubmit != null && isSubmit.equals("true")) {
            return this._submit(ctx, model);
        }
        if (isSubmit != null && isSubmit.equals("false")) {
            SecurityMeasureInfo workPermitInfo = (SecurityMeasureInfo)model;
            ObjectUuidPK pk = new ObjectUuidPK(workPermitInfo.getId());
            if (status.equals((Object)GeneBillBaseStatusEnum.ForceClosed)) {
                this._forceClosed(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.FinishIsolation)) {
                this._isolationFinish(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.FinishRestore)) {
                this._restoreFinish(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.StartIsolation)) {
                this._isolationStart(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.StartRestore)) {
                this._restoreStart(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.CheckThough)) {
                this._checkUseable(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.SAVE)) {
                workPermitInfo.setOperation(ResourceBase.getString((String)"com.kingdee.eas.eqm.security.SECURITYAutoGenerateResource", (String)"0_SecurityMeasureControllerBean", (Locale)ctx.getLocale()));
                this._unAudit(ctx, (IObjectPK)new ObjectUuidPK(workPermitInfo.getId()));
            } else {
                throw new BOSException("uncorrected status :" + status);
            }
            return pk;
        }
        return null;
    }

    @Override
    protected boolean _auditForWF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            SecurityMeasureInfo info = (SecurityMeasureInfo)this._getValue(ctx, pk, sic);
            this.verifyAudit(info);
            this._audit(ctx, pk);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void verifyAudit(SecurityMeasureInfo info) throws SecurityMeasureException {
        if (info != null && info.getWorkPermit() != null) {
            if (info.getWorkPermit().getBillStatus() == GeneBillBaseStatusEnum.Recycle) {
                throw new SecurityMeasureException(SecurityMeasureException.NOT_AUDITPERMITRECYCLE);
            }
            if (info.getWorkPermit().getBillStatus() != GeneBillBaseStatusEnum.Audit) {
                throw new SecurityMeasureException(SecurityMeasureException.NOT_AUDITPERMIT, new Object[]{info.getNumber()});
            }
            if (info.getBillStatus() != GeneBillBaseStatusEnum.Submit) {
                throw new SecurityMeasureException(SecurityMeasureException.NOT_AUDIT_SU, new Object[]{info.getNumber()});
            }
        }
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM031", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SecurityMeasureInfo model = (SecurityMeasureInfo)this._getValue(ctx, pk, sic);
        if (this.canUnAudit(ctx, (GeneBillBaseInfo)model)) {
            try {
                super._unAudit(ctx, pk);
                this.writeLog(ctx, model, "unaudit", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, model, "unaudit", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, model, "unaudit", new Boolean(false));
                throw e2;
            }
        } else {
            throw new SecurityMeasureException(SecurityMeasureException.PARAMCANNOTUNAUDIT, new String[0]);
        }
    }

    private boolean canUnAudit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM032", (String)info.getMainOrgUnit().getId().toString());
    }

    private void writeLog(Context ctx, SecurityMeasureInfo securityMeasureInfo, String operation, Boolean isSuccessed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", isSuccessed);
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "close");
        hashLog.put("FCompanyName_L1", securityMeasureInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L2", securityMeasureInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L3", securityMeasureInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FInstanceID", securityMeasureInfo.getId().toString());
        hashLog.put("FInstanceNo", securityMeasureInfo.getLogInfo());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("delete")) {
            logItem = "eqm_securitymeasure_delete";
        } else if (operation.equals("audit")) {
            logItem = "eqm_securitymeasure_audit";
        } else if (operation.equals("unaudit")) {
            logItem = "eqm_securitymeasure_unaudit";
        } else if ("isolationstart".equals(operation)) {
            logItem = "eqm_securitymeasure_isolationstart";
        } else if ("isolationfinish".equals(operation)) {
            logItem = "eqm_securitymeasure_isolationfinish";
        } else if ("restorestart".equals(operation)) {
            logItem = "eqm_securitymeasure_restorestart";
        } else if ("restorefinish".equals(operation)) {
            logItem = "eqm_securitymeasure_restorefinish";
        } else if ("checkuseable".equals(operation)) {
            logItem = "eqm_securitymeasure_checkuseable";
        } else if ("forceclosed".equals(operation)) {
            logItem = "eqm_securitymeasure_forceclosed";
        }
        return logItem;
    }

    static {
        sic.add(new SelectorItemInfo("workPermit"));
        sic.add(new SelectorItemInfo("workPermit.number"));
        sic.add(new SelectorItemInfo("workPermit.billStatus"));
        sic.add(new SelectorItemInfo("workOrder"));
        sic.add(new SelectorItemInfo("workOrder.number"));
        sic.add(new SelectorItemInfo("workOrder.billStatus"));
        sic.add(new SelectorItemInfo("workPermit.strictControl"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("workPermit.strictControl"));
        sic.add(new SelectorItemInfo("*"));
    }
}

