/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.security.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.security.SecurityMeasureCollection;
import com.kingdee.eas.eqm.security.SecurityMeasureFactory;
import com.kingdee.eas.eqm.security.SecurityMeasureInfo;
import com.kingdee.eas.eqm.security.WorkPermitException;
import com.kingdee.eas.eqm.security.WorkPermitInfo;
import com.kingdee.eas.eqm.security.WorkPermitSecurityMeasureCollection;
import com.kingdee.eas.eqm.security.WorkPermitSecurityMeasureFactory;
import com.kingdee.eas.eqm.security.WorkPermitSecurityMeasureInfo;
import com.kingdee.eas.eqm.security.app.AbstractWorkPermitControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkPermitControllerBean
extends AbstractWorkPermitControllerBean {
    private static final long serialVersionUID = 1L;
    private static SelectorItemCollection sic = new SelectorItemCollection();

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = null;
        try {
            info = (WorkPermitInfo)super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        WorkPermitInfo info = null;
        try {
            info = (WorkPermitInfo)super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
        return info;
    }

    @Override
    protected void _forceClosed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        this.verifyForceClosed(info);
        info.setBillStatus(GeneBillBaseStatusEnum.ForceClosed);
        try {
            this._update(ctx, pk, (IObjectValue)info);
            WorkPermitSecurityMeasureCollection wpsmList = info.getSecurityMeasure();
            SecurityMeasureCollection smCollections = new SecurityMeasureCollection();
            Iterator iter = wpsmList.iterator();
            while (iter.hasNext()) {
                WorkPermitSecurityMeasureInfo wpsm = (WorkPermitSecurityMeasureInfo)iter.next();
                if (wpsm.getSecMeasure().getBillStatus().getValue() == 71 || wpsm.getSecMeasure().getBillStatus().getValue() == 60) continue;
                smCollections.add(wpsm.getSecMeasure());
            }
            SecurityMeasureFactory.getLocalInstance(ctx).batchForceClosed(smCollections);
            this.writeLog(ctx, (GeneBillBaseInfo)info, "forceClosed", true);
        }
        catch (Exception e) {
            this.writeLog(ctx, (GeneBillBaseInfo)info, "forceClosed", false);
        }
    }

    @Override
    protected void _recall(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        this.verifyRecall(info);
        info.setBillStatus(GeneBillBaseStatusEnum.Recycle);
        if (info.getBackTime() == null) {
            info.setBackTime(new Date());
        }
        if (info.getBackPerson() == null) {
            info.setBackPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        }
        try {
            this._update(ctx, pk, (IObjectValue)info);
            this.writeLog(ctx, (GeneBillBaseInfo)info, "recall", true);
        }
        catch (Exception e) {
            this.writeLog(ctx, (GeneBillBaseInfo)info, "recall", false);
        }
    }

    @Override
    protected void _sign(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        this.verifySign(info);
        info.setBillStatus(GeneBillBaseStatusEnum.Sign);
        if (info.getSignTime() == null) {
            info.setSignTime(new Date());
        }
        if (info.getSignPerson() == null) {
            info.setSignPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        }
        try {
            this._update(ctx, pk, (IObjectValue)info);
            this.writeLog(ctx, (GeneBillBaseInfo)info, "sign", true);
        }
        catch (Exception e) {
            this.writeLog(ctx, (GeneBillBaseInfo)info, "sign", false);
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        this.verifyAudit(info);
        super._audit(ctx, pk);
        info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        WorkPermitSecurityMeasureCollection wpsaList = info.getSecurityMeasure();
        Iterator iter = wpsaList.iterator();
        while (iter.hasNext()) {
            WorkPermitSecurityMeasureInfo wpsm = (WorkPermitSecurityMeasureInfo)iter.next();
            ObjectUuidPK securityMeasureId = new ObjectUuidPK(wpsm.getSecMeasure().getId());
            SecurityMeasureInfo securityMeasure = (SecurityMeasureInfo)SecurityMeasureFactory.getLocalInstance(ctx).getValue((IObjectPK)securityMeasureId);
            securityMeasure.setWorkPermit(info);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)model;
        if (info.getWorkOrder() != null) {
            WorkPermitSecurityMeasureCollection wpsaList = info.getSecurityMeasure();
            Iterator iter = wpsaList.iterator();
            while (iter.hasNext()) {
                WorkPermitSecurityMeasureInfo wpsm = (WorkPermitSecurityMeasureInfo)iter.next();
                ObjectUuidPK securityMeasureId = new ObjectUuidPK(wpsm.getSecMeasure().getId());
                SecurityMeasureInfo securityMeasure = (SecurityMeasureInfo)SecurityMeasureFactory.getLocalInstance(ctx).getValue((IObjectPK)securityMeasureId);
                securityMeasure.setWorkOrder(info.getWorkOrder());
                SecurityMeasureFactory.getLocalInstance(ctx).update((IObjectPK)securityMeasureId, (CoreBaseInfo)securityMeasure);
            }
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        this.verifyDeleteWorkPermit(info);
        WorkPermitSecurityMeasureCollection wpsaList = info.getSecurityMeasure();
        ArrayList<ObjectUuidPK> securityMeasureEntryIdList = new ArrayList<ObjectUuidPK>();
        ArrayList<ObjectUuidPK> securityMeasureIdList = new ArrayList<ObjectUuidPK>();
        ArrayList<String> securityMeasureIds = new ArrayList<String>();
        HashMap<String, String> idnames = new HashMap<String, String>();
        Iterator iter = wpsaList.iterator();
        while (iter.hasNext()) {
            WorkPermitSecurityMeasureInfo wpsm = (WorkPermitSecurityMeasureInfo)iter.next();
            ObjectUuidPK securityMeasureEntryId = new ObjectUuidPK(wpsm.getId());
            this.verifyDeleteSecurityMeasure(wpsm.getSecMeasure());
            securityMeasureEntryIdList.add(securityMeasureEntryId);
            ObjectUuidPK securityMeasureId = new ObjectUuidPK(wpsm.getSecMeasure().getId());
            securityMeasureIdList.add(securityMeasureId);
            securityMeasureIds.add(securityMeasureId.toString());
            idnames.put(securityMeasureId.toString(), wpsm.getSecMeasure().getName());
        }
        this.batchDeleteSecurityMeasure(ctx, securityMeasureEntryIdList, securityMeasureIdList, securityMeasureIds, idnames, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected void _updateForSM(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super.setCheckLastUptTime(false);
        super._update(ctx, pk, model);
        super.setCheckLastUptTime(true);
    }

    @Override
    protected void _deleteSecurityMeasure(Context ctx, List entryPkList, IObjectPK workPermitPK) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("secMeasure.*"));
        for (int i = 0; i < entryPkList.size(); ++i) {
            IObjectPK entryPk = (IObjectPK)entryPkList.get(i);
            WorkPermitSecurityMeasureInfo wpsmInfo = (WorkPermitSecurityMeasureInfo)WorkPermitSecurityMeasureFactory.getLocalInstance(ctx).getValue(entryPk, sic);
            WorkPermitSecurityMeasureFactory.getLocalInstance(ctx).delete(entryPk);
            String securityMeasureId = ((SecurityMeasureInfo)wpsmInfo.get("secmeasure")).getId().toString();
            ObjectUuidPK smPK = new ObjectUuidPK(securityMeasureId);
            SecurityMeasureFactory.getLocalInstance(ctx).delete((IObjectPK)smPK);
        }
    }

    protected void batchDeleteSecurityMeasure(Context ctx, List entryPkList, List pkList, List idList, Map idNames, IObjectPK workPermitPK) throws BOSException, EASBizException {
        if (entryPkList != null && entryPkList.size() > 0) {
            BatchExecuteParamsEntry p;
            Class[] parameTypes = new Class[]{IObjectPK.class};
            ArrayList<BatchExecuteParamsEntry> aryEntry = new ArrayList<BatchExecuteParamsEntry>();
            ArrayList<BatchExecuteParamsEntry> ary = new ArrayList<BatchExecuteParamsEntry>();
            for (int i = 0; i < entryPkList.size(); ++i) {
                p = new BatchExecuteParamsEntry(parameTypes);
                p.add(entryPkList.get(i));
                aryEntry.add(p);
            }
            for (int j = 0; j < pkList.size(); ++j) {
                p = new BatchExecuteParamsEntry(parameTypes);
                p.add(pkList.get(j));
                ary.add(p);
            }
            BatchExecuteParamsEntry[] paramSMEntries = aryEntry.toArray(new BatchExecuteParamsEntry[aryEntry.size()]);
            BatchExecuteParamsEntry[] paramSM = ary.toArray(new BatchExecuteParamsEntry[ary.size()]);
            StringBuffer tips = new StringBuffer();
            try {
                BatchExecuteResult resultEntry = WorkPermitSecurityMeasureFactory.getLocalInstance(ctx).batchExecute("delete", parameTypes, paramSMEntries);
                BatchExecuteResult result = SecurityMeasureFactory.getLocalInstance(ctx).batchExecute("delete", parameTypes, paramSM);
                if (result != null && result.size() > 0 && result.getException(0) != null) {
                    for (int i = 0; i < result.size(); ++i) {
                        tips.append("\n").append(result.getException(i).getMessage().toString());
                    }
                    this.writeLog(ctx, idList, idNames, false);
                    throw new WorkPermitException(WorkPermitException.DELETEPERMITERROR, new Object[]{tips.toString()});
                }
                this.writeLog(ctx, idList, idNames, true);
            }
            catch (BaseException e) {
                throw new WorkPermitException(WorkPermitException.DELETEPERMITERROR, new Object[]{tips.toString()});
            }
        }
    }

    private void writeLog(Context ctx, List ids, Map idnames, boolean successed) throws BOSException {
        if (idnames == null || idnames.size() <= 0) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)SecurityMeasureFactory.getLocalInstance(ctx).getType());
        for (int i = 0; i < ids.size(); ++i) {
            HashMap<String, Object> hashLog = new HashMap<String, Object>();
            LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
            hashLog.put("isSuccessed", new Boolean(false));
            hashLog.put("successed", new Boolean(successed));
            hashLog.put("FEntityID", entityObjectInfo.getBOSType().toString());
            hashLog.put("FEntityName", entityObjectInfo.getName());
            hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
            hashLog.put("FMethodName", "delete");
            hashLog.put("FInstanceID", ids.get(i));
            hashLog.put("FInstanceNo", idnames.get(ids.get(i)));
            hashLog.put("FItemName", "eqm_securitymeasure_delete");
            hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
            appLog.writeLog(hashLog);
        }
    }

    private void verifyForceClosed(WorkPermitInfo info) throws WorkPermitException {
        if (!(info == null || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Sign) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.SAVE) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Submit))) {
            throw new WorkPermitException(WorkPermitException.NOT_FORCECLOSED, new Object[]{info.getNumber()});
        }
    }

    private void verifyRecall(WorkPermitInfo info) throws WorkPermitException {
        GeneBillBaseStatusEnum workPermitStatus = info.getBillStatus();
        if (workPermitStatus.equals((Object)GeneBillBaseStatusEnum.SAVE) || workPermitStatus.equals((Object)GeneBillBaseStatusEnum.Submit)) {
            if (!info.isStrictControl()) {
                return;
            }
            if (info.isStrictControl() && info.getWorkOrder() != null && (info.getWorkOrder().getBillStatus().equals((Object)GeneBillBaseStatusEnum.Finish) || info.getWorkOrder().getBillStatus().equals((Object)GeneBillBaseStatusEnum.Check) || info.getWorkOrder().getBillStatus().equals((Object)GeneBillBaseStatusEnum.CLOSED) || info.getWorkOrder().getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceClosed) || info.getWorkOrder().getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceComplete) || info.getWorkOrder().getBillStatus().equals((Object)GeneBillBaseStatusEnum.Suspend))) {
                return;
            }
            throw new WorkPermitException(WorkPermitException.NOT_RECALL_STRICT, new Object[]{info.getNumber()});
        }
        if (workPermitStatus.equals((Object)GeneBillBaseStatusEnum.Sign)) {
            GeneBillBaseStatusEnum status = info.getWorkOrder().getBillStatus();
            if (!info.isStrictControl()) {
                return;
            }
            if (info.isStrictControl() && (status.equals((Object)GeneBillBaseStatusEnum.Finish) || status.equals((Object)GeneBillBaseStatusEnum.Check) || status.equals((Object)GeneBillBaseStatusEnum.CLOSED) || status.equals((Object)GeneBillBaseStatusEnum.ForceClosed) || status.equals((Object)GeneBillBaseStatusEnum.ForceComplete) || status.equals((Object)GeneBillBaseStatusEnum.Suspend))) {
                return;
            }
            throw new WorkPermitException(WorkPermitException.NOT_RECALL_STRICT, new Object[]{info.getNumber()});
        }
        if (workPermitStatus.equals((Object)GeneBillBaseStatusEnum.Recycle)) {
            throw new WorkPermitException(WorkPermitException.NOT_RECALL_AL, new Object[]{info.getNumber()});
        }
        if (!info.isStrictControl()) {
            throw new WorkPermitException(WorkPermitException.NOT_RECALL_NOSTRICT, new Object[]{info.getNumber()});
        }
        throw new WorkPermitException(WorkPermitException.NOT_RECALL_STRICT, new Object[]{info.getNumber()});
    }

    private void verifySign(WorkPermitInfo info) throws WorkPermitException {
        if (info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) {
            Iterator iterator = info.getSecurityMeasure().iterator();
            while (iterator.hasNext()) {
                WorkPermitSecurityMeasureInfo saObject = (WorkPermitSecurityMeasureInfo)iterator.next();
                if (saObject.getSecMeasure().getBillStatus().equals((Object)GeneBillBaseStatusEnum.FinishIsolation) || saObject.getSecMeasure().getBillStatus().equals((Object)GeneBillBaseStatusEnum.CheckThough) || saObject.getSecMeasure().getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceClosed)) continue;
                throw new WorkPermitException(WorkPermitException.NOT_SIGN, new Object[]{info.getNumber()});
            }
        } else {
            throw new WorkPermitException(WorkPermitException.NOT_SIGN, new Object[]{info.getNumber()});
        }
    }

    protected boolean _isforceClosed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = this.getWorkPermitInfo(ctx, pk);
        return info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Sign);
    }

    private void verifyDeleteWorkPermit(WorkPermitInfo info) throws WorkPermitException {
        if (info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Sign) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.ForceClosed) || info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Recycle)) {
            throw new WorkPermitException(WorkPermitException.NOT_DELETE, new Object[]{info.getNumber(), info.getBillStatus().getAlias()});
        }
    }

    private void verifyDeleteSecurityMeasure(SecurityMeasureInfo info) throws WorkPermitException {
        if (info != null && info.getBillStatus() != null && info.getBillStatus().getValue() >= 30) {
            throw new WorkPermitException(WorkPermitException.NOT_DEL_SM_ENTRY, new Object[]{info.getNumber(), info.getBillStatus().getAlias()});
        }
    }

    private void verifyAudit(WorkPermitInfo info) throws WorkPermitException {
        if (info.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) {
            throw new WorkPermitException(WorkPermitException.NOT_AUDIT_AU, new Object[]{info.getNumber()});
        }
        if (info.getWorkOrder() == null || info.getWorkOrder().getNumber() == null) {
            throw new WorkPermitException(WorkPermitException.NOT_AUDIT_WO, new Object[]{info.getNumber()});
        }
        GeneBillBaseStatusEnum status = info.getWorkOrder().getBillStatus();
        if (!(status.equals((Object)GeneBillBaseStatusEnum.Release) || status.equals((Object)GeneBillBaseStatusEnum.Finish) || status.equals((Object)GeneBillBaseStatusEnum.Check) || status.equals((Object)GeneBillBaseStatusEnum.StartWork) || status.equals((Object)GeneBillBaseStatusEnum.CLOSED) || status.equals((Object)GeneBillBaseStatusEnum.ForceClosed) || status.equals((Object)GeneBillBaseStatusEnum.Suspend) || status.equals((Object)GeneBillBaseStatusEnum.ForceComplete))) {
            throw new WorkPermitException(WorkPermitException.NOT_AUDIT, new Object[]{info.getNumber()});
        }
    }

    @Override
    public IObjectPK changeStatus(Context ctx, WorkPermitInfo model, GeneBillBaseStatusEnum status, String isSubmit) throws BOSException, EASBizException {
        model.setOperation(status.getAlias());
        return super.changeStatus(ctx, model, status, isSubmit);
    }

    @Override
    protected IObjectPK _changeStatus(Context ctx, IObjectValue model, GeneBillBaseStatusEnum status, String isSubmit) throws BOSException, EASBizException {
        if (isSubmit != null && isSubmit.equals("true")) {
            return this._submit(ctx, model);
        }
        if (isSubmit != null && isSubmit.equals("false")) {
            WorkPermitInfo workPermitInfo = (WorkPermitInfo)model;
            ObjectUuidPK pk = new ObjectUuidPK(workPermitInfo.getId());
            if (status.equals((Object)GeneBillBaseStatusEnum.ForceClosed)) {
                this._forceClosed(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.Sign)) {
                this._sign(ctx, (IObjectPK)pk);
            } else if (status.equals((Object)GeneBillBaseStatusEnum.Recycle)) {
                this._recall(ctx, (IObjectPK)pk);
            } else {
                throw new BOSException("uncorrected status :" + status);
            }
            return pk;
        }
        return null;
    }

    @Override
    protected boolean _auditForWF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WorkPermitInfo info = (WorkPermitInfo)this._getValue(ctx, pk, sic);
        try {
            this.verifyAudit(info);
            super._audit(ctx, pk);
            this.writeLog(ctx, (GeneBillBaseInfo)info, "auditForWF", true);
        }
        catch (Exception e) {
            this.writeLog(ctx, (GeneBillBaseInfo)info, "auditForWF", false);
            return false;
        }
        return true;
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM030", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    private void writeLog(Context ctx, GeneBillBaseInfo info, String operation, boolean successed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", new Boolean(successed));
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", operation);
        hashLog.put("FInstanceID", info.getId() == null ? null : info.getId().toString());
        hashLog.put("FInstanceNo", info.getLogInfo());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("addnew")) {
            logItem = "eqm_workpermit_addnew";
        } else if (operation.equals("update")) {
            logItem = "eqm_workpermit_update";
        } else if (operation.equals("delete")) {
            logItem = "eqm_workpermit_delete";
        } else if (operation.equals("audit")) {
            logItem = "eqm_workpermit_audit";
        } else if (operation.equals("auditForWF")) {
            logItem = "eqm_workpermit_auditforWF";
        } else if (operation.equals("sign")) {
            logItem = "eqm_workpermit_sign";
        } else if (operation.equals("recall")) {
            logItem = "eqm_workpermit_recall";
        } else if (operation.equals("forceClosed")) {
            logItem = "eqm_workpermit_forceclosed";
        }
        return logItem;
    }

    static {
        sic.add(new SelectorItemInfo("workOrder"));
        sic.add(new SelectorItemInfo("workOrder.number"));
        sic.add(new SelectorItemInfo("workOrder.billStatus"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("strictControl"));
        sic.add(new SelectorItemInfo("comment"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("planOrgUnit.*"));
        sic.add(new SelectorItemInfo("startTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("signTime"));
        sic.add(new SelectorItemInfo("backTime"));
        sic.add(new SelectorItemInfo("signPerson.*"));
        sic.add(new SelectorItemInfo("backPerson.*"));
        sic.add(new SelectorItemInfo("securityMeasure.secMeasure.billStatus"));
        sic.add(new SelectorItemInfo("securityMeasure.secMeasure.number"));
        sic.add(new SelectorItemInfo("securityMeasure.secMeasure.workPermit.*"));
        sic.add(new SelectorItemInfo("securityMeasure.secMeasure.*"));
    }
}

