/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.security.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.security.WorkPermitException;
import com.kingdee.eas.eqm.security.WorkPermitInfo;

public class WorkPermitAuditVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private GeneBillBaseInfo info;

    public WorkPermitAuditVerifyItem(GeneBillBaseInfo info) {
        this.info = info;
    }

    public boolean verify() throws EASBizException, BOSException {
        WorkPermitInfo wpInfo = (WorkPermitInfo)this.info;
        if (wpInfo.getBillStatus().equals((Object)GeneBillBaseStatusEnum.Audit)) {
            throw new WorkPermitException(WorkPermitException.NOT_AUDIT_AU, new Object[]{wpInfo.getNumber()});
        }
        if (wpInfo.getWorkOrder() == null || wpInfo.getWorkOrder().getNumber() == null) {
            throw new WorkPermitException(WorkPermitException.NOT_AUDIT_WO, new Object[]{wpInfo.getNumber()});
        }
        GeneBillBaseStatusEnum status = wpInfo.getWorkOrder().getBillStatus();
        if (!(status.equals((Object)GeneBillBaseStatusEnum.Release) || status.equals((Object)GeneBillBaseStatusEnum.Finish) || status.equals((Object)GeneBillBaseStatusEnum.Check) || status.equals((Object)GeneBillBaseStatusEnum.StartWork) || status.equals((Object)GeneBillBaseStatusEnum.CLOSED) || status.equals((Object)GeneBillBaseStatusEnum.ForceClosed) || status.equals((Object)GeneBillBaseStatusEnum.Suspend) || status.equals((Object)GeneBillBaseStatusEnum.ForceComplete))) {
            throw new WorkPermitException(WorkPermitException.NOT_AUDIT, new Object[]{wpInfo.getNumber()});
        }
        return true;
    }
}

