/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.CashDiscountCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscountEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.IOtherBillDisposer;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.util.Date;

public class OtherBillDisposer
implements IPaymentDisposer,
IOtherBillDisposer {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private static final String AP_OTHER_BILL_BOS_TYPE = "48DA3A71";
    private static final String PAYREQUEST_BILL_BOS_TYPE = "D001019A";

    public BigDecimal getCashRebate(IObjectValue info, CashDiscountCollection cdColl, Date billDate, BigDecimal apAmount, String sourceBillId, String sourceBillEntryId) {
        CurrencyInfo currencyInfo;
        OtherBillInfo otherBillInfo = (OtherBillInfo)info;
        if (otherBillInfo == null || otherBillInfo.getCashDiscount() == null || billDate == null || apAmount == null || sourceBillId == null || sourceBillEntryId == null) {
            return null;
        }
        BigDecimal cashDiscount = ZERO;
        try {
            BigDecimal amount = null;
            OtherBillentryCollection entryCol = otherBillInfo.getEntry();
            if (sourceBillEntryId != null && !"".equals(sourceBillEntryId) && entryCol.containsKey(BOSUuid.read((String)sourceBillEntryId))) {
                amount = entryCol.get(BOSUuid.read((String)sourceBillEntryId)).getRecievePayAmount();
            }
            if (amount == null || apAmount.compareTo(amount) < 0) {
                return null;
            }
            Date otherBillDate = otherBillInfo.getBillDate();
            int ages = ArApBillHelper.getDays(billDate, otherBillDate);
            CashDiscountInfo cashDiscountInfo = otherBillInfo.getCashDiscount();
            if (cashDiscountInfo == null) {
                return null;
            }
            if (cashDiscountInfo != null && cdColl.containsKey((Object)cashDiscountInfo.getId())) {
                cashDiscountInfo = cdColl.get((Object)cashDiscountInfo.getId());
            }
            CashDiscountEntryCollection cashDisEntryCol = cashDiscountInfo.getEntries();
            int size = cashDisEntryCol.size();
            for (int i = 0; i < size; ++i) {
                CashDiscountEntryInfo cashEntryInfo = cashDisEntryCol.get(i);
                if (ages >= cashEntryInfo.getDays()) continue;
                cashDiscount = cashEntryInfo.getDiscount();
                break;
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
        if (cashDiscount == null) {
            return null;
        }
        int precision = 2;
        if (otherBillInfo.getCurrency() != null && (currencyInfo = otherBillInfo.getCurrency()) != null) {
            precision = currencyInfo.getPrecision();
        }
        return apAmount.multiply(ArApBaseCalculate.calRate(cashDiscount, 2)).setScale(precision, 4);
    }

    public void dispose4Delete(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
    }

    public void dispose4Pay(Context ctx, PaymentBillInfo beforePayBillInfo) throws BOSException, EASBizException {
        ArApBillFacadeFactory.getLocalInstance((Context)ctx).autoVerify4RecPay2ArAp((CoreBillBaseInfo)beforePayBillInfo);
    }

    public void dispose4CancelPay(Context ctx, PaymentBillInfo beforePayBillInfo) throws BOSException, EASBizException {
        BOSUuid payBillId = beforePayBillInfo.getId();
        if (null == payBillId) {
            return;
        }
        SelectorItemCollection payBillselector = ArApSelectorFactory.getPayBillSelector();
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        PaymentBillInfo payBillInfo = iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(payBillId.toString()), payBillselector);
        if (payBillInfo.isAssoGen() && payBillInfo.isIsTransOtherBill()) {
            ArApServiceHandler arapServiceHandler = new ArApServiceHandler();
            arapServiceHandler.writeBackOrderBill(ctx, payBillInfo.getId().toString(), false, true);
            arapServiceHandler.reverseTransOtherBill(ctx, payBillInfo, false);
        }
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        DisposerActionEnum actionType = action.getActionType();
        if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            this.dispose4Pay(ctx, (PaymentBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
            this.dispose4CancelPay(ctx, (PaymentBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            this.dispose4AntiAudit(ctx, (PaymentBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.AUDIT.equals((Object)actionType)) {
            this.dispose4Audit(ctx, (PaymentBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            this.dispose4Delete(ctx, (PaymentBillInfo)action.getDestBill());
        }
    }

    public void dispose4Audit(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        if (!payBillInfo.isIsInitializeBill() && payBillInfo.isAssoGenByApBill() && !payBillInfo.isIsTransBill() && payBillInfo.getBillStatus() == BillStatusEnum.SUBMIT) {
            ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)payBillInfo, BOTBillOperStateEnum.AUDIT);
        }
    }

    public void dispose4AntiAudit(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String sourceBillId, String sourceBillEntryId) {
        if (billDate == null || apAmount == null || sourceBillId == null || sourceBillEntryId == null) {
            return null;
        }
        BigDecimal cashDiscount = ZERO;
        try {
            IOtherBill iOtherBill = OtherBillFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(sourceBillId);
            OtherBillInfo otherBillInfo = iOtherBill.getOtherBillInfo((IObjectPK)pk);
            BigDecimal amount = null;
            OtherBillentryCollection entryCol = otherBillInfo.getEntry();
            for (int i = 0; i < entryCol.size(); ++i) {
                OtherBillentryInfo entryInfo = entryCol.get(i);
                if (!sourceBillEntryId.equals(entryInfo.getId().toString())) continue;
                amount = entryInfo.getRecievePayAmount();
                break;
            }
            if (amount == null || apAmount.compareTo(amount) < 0) {
                return null;
            }
            Date otherBillDate = otherBillInfo.getBillDate();
            int ages = ArApBillHelper.getDays(billDate, otherBillDate);
            CashDiscountInfo cashDiscountInfo = otherBillInfo.getCashDiscount();
            String oql = "where cashDiscount = '" + cashDiscountInfo.getId().toString() + "' order by days asc";
            ICashDiscountEntry iCashDisEntry = CashDiscountEntryFactory.getRemoteInstance();
            CashDiscountEntryCollection cashDisEntryCol = iCashDisEntry.getCashDiscountEntryCollection(oql);
            int size = cashDisEntryCol.size();
            for (int i = 0; i < size; ++i) {
                CashDiscountEntryInfo cashEntryInfo = cashDisEntryCol.get(i);
                if (ages >= cashEntryInfo.getDays()) continue;
                cashDiscount = cashEntryInfo.getDiscount();
                break;
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
        if (cashDiscount == null) {
            return null;
        }
        return apAmount.multiply(ArApBaseCalculate.calRate(cashDiscount, 2));
    }
}

