/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.csinterface.util.FileContentReader;
import com.kingdee.eas.fi.ap.ApElecInoviceFacdeFactory;
import com.kingdee.eas.fi.ap.ApInvoiceCollection;
import com.kingdee.eas.fi.ap.ApInvoiceFactory;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ap.IApElecInoviceFacde;
import com.kingdee.eas.fi.ap.IApInvoice;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.app.AbstractApElecInoviceFacdeControllerBean;
import com.kingdee.eas.fi.ar.ArElecInvoiceFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.arap.EIVCConfigFactory;
import com.kingdee.eas.fi.arap.EIVCConfigInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.MatchPairType;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.EIVCService;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.H;
import com.kingdee.eas.fi.arap.util.MatchType;
import com.kingdee.eas.fi.arap.util.remote.exception.AfterInvokingRemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.MethodState;
import com.kingdee.eas.fi.arap.util.remote.exception.RemoteMethodException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApElecInoviceFacdeControllerBean
extends AbstractApElecInoviceFacdeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.ApElecInoviceFacdeControllerBean");
    AsstActTypeInfo asstActTypeInfo = null;

    public void throwEASException(String message, Throwable e) throws EASBizException {
        logger.error((Object)message, e);
        H.throwEASBizException(message, e);
    }

    public void throwEASException(String message) throws EASBizException {
        logger.error((Object)message);
        throw new EASBizException(new NumericExceptionSubItem("1", message));
    }

    public void throwBOSException(Throwable e) throws BOSException {
        logger.error((Object)e);
        throw new BOSException(e);
    }

    private CurrencyInfo getCurrency(Context ctx, ApInvoiceInfo info) {
        if (info.getCompany() == null || info.getCompany().getBaseCurrency() == null) {
            CurrencyInfo ret = new CurrencyInfo();
            ret.setId(H.UID("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            return ret;
        }
        return info.getCompany().getBaseCurrency();
    }

    private AsstActTypeInfo getAsstActType(Context ctx, ApInvoiceInfo info) throws SQLException, BOSException {
        if (this.asstActTypeInfo == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)" select  fid from T_BD_AsstActType where upper(FREALTIONDATAOBJECT) = upper('T_BD_Supplier') ");
            if (rs.next()) {
                String asstActTypeId = rs.getString(1);
                this.asstActTypeInfo = new AsstActTypeInfo();
                this.asstActTypeInfo.setId(BOSUuid.read((String)asstActTypeId));
            }
            rs.close();
        }
        return this.asstActTypeInfo;
    }

    private String getAsstActID(Context ctx, ApInvoiceInfo info) throws BOSException, SQLException {
        String asstActID = this.getAsstActIDByRegisterNo(ctx, info.getTaxRegisterNo());
        if (asstActID != null) {
            return asstActID;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select  fid from T_BD_Supplier where FNAME_l2 = '" + info.getAsstActName() + "'"));
        if (rs.next()) {
            asstActID = rs.getString(1);
        }
        rs.close();
        return asstActID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAsstActIDByRegisterNo(Context ctx, String registerNo) throws SQLException, BOSException {
        try (IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select  fid from T_BD_Supplier where FTAXREGISTERNO = '" + registerNo + "'"));){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return null;
    }

    private String getPhoneNumber(Context ctx, String username, boolean forTest) throws EASBizException {
        try {
            CloudRegistUserInfo crui = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getCloudRegistUserInfo(username);
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            return crui.getPhone();
        }
        catch (Throwable e) {
            String phonelist = FileContentReader.readUTF8FileContent((String)(System.getProperty("eas.properties.dir") + File.separator + "phones.txt"));
            if (phonelist != null) {
                String[] lines;
                for (String line : lines = phonelist.split("\r\n")) {
                    String[] content;
                    if (line.indexOf("=") == -1 || !username.equalsIgnoreCase((content = line.split("="))[0])) continue;
                    return content[1];
                }
            }
            e.printStackTrace();
            this.throwEASException(this.getResourceStr(ctx, "GetColdPhoneError"), e);
            return "15011399612";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getOwnRevenueNumbers(Context ctx, String[] companyids, boolean fortest) throws BOSException, EASBizException {
        if (H.isEmpty(companyids)) {
            return null;
        }
        StringBuilder sf = new StringBuilder();
        for (int i = 0; i < companyids.length; ++i) {
            if (i > 0) {
                sf.append(",");
            }
            sf.append("'").append(companyids[i]).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)String.format("select  fid,ftaxpayerID,ftaxregisterName from T_ORG_Company where fid in(%s); ", sf));
        try {
            HashMap<String, String> tmp = new HashMap<String, String>();
            while (rs.next()) {
                tmp.put(rs.getString(1), rs.getString(2));
            }
            String[] ret = new String[companyids.length];
            for (int i = 0; i < companyids.length; ++i) {
                ret[i] = (String)tmp.get(companyids[i]);
            }
            String[] i = ret;
            return i;
        }
        catch (SQLException e) {
            e.printStackTrace();
            String[] stringArray = new String[]{"1234567890"};
            return stringArray;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private CompanyOrgUnitInfo[] getCompanys(Context ctx, String[] companysIds) throws BOSException {
        CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(H.newEV(H.SIC("id,name,number,company.id,company.baseCurrency.id"), H.FILTER(H.include("id", companysIds))));
        HashMap<String, CompanyOrgUnitInfo> tmp = new HashMap<String, CompanyOrgUnitInfo>();
        for (int i = 0; i < col.size(); ++i) {
            tmp.put(H.IDSTR(col.get(i)), col.get(i));
        }
        CompanyOrgUnitInfo[] ret = new CompanyOrgUnitInfo[companysIds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (CompanyOrgUnitInfo)tmp.get(companysIds[i]);
        }
        return ret;
    }

    @Override
    protected Map _revertInvoice(Context ctx, Map param) throws BOSException, EASBizException {
        String[] pkStrArr = (String[])param.get("pks");
        Map cache = H.CACHE();
        Map<Object, List> rows = H.getRows(ctx, "select fid,fcompanyid from T_AP_ApInvoice where FRandomCode is not null and " + H.include("fid", pkStrArr));
        if (rows == null) {
            this.throwEASException(this.getResourceStr(ctx, "NoCancelBill"));
        }
        List fids = rows.get(1);
        List fcompanyids = rows.get(2);
        Map tmp = H.JSMAP(new Object[0]);
        for (int i = 0; i < fids.size(); ++i) {
            List<String> ids;
            String fid = (String)fids.get(i);
            String fcompanyid = (String)fcompanyids.get(i);
            if (tmp.containsKey(fcompanyid)) {
                ids = (List)tmp.get(fcompanyid);
            } else {
                ids = new ArrayList();
                tmp.put(fcompanyid, ids);
            }
            ids.add(fid);
        }
        String[] companysIds = new String[tmp.keySet().size()];
        tmp.keySet().toArray(companysIds);
        CompanyOrgUnitInfo[] companys = this.getCompanys(ctx, companysIds);
        for (int i = 0; i < companys.length; ++i) {
            cache.put(H.IDSTR(companys[i]), companys[i]);
        }
        ArrayList allids = new ArrayList();
        String msg = "";
        String detailMsg = "";
        IApElecInoviceFacde biz = ApElecInoviceFacdeFactory.getLocalInstance(ctx);
        for (Map.Entry entry : tmp.entrySet()) {
            String companyid = (String)entry.getKey();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
            List ids = (List)entry.getValue();
            param.put("ids", ids);
            param.put("companyid", companyid);
            try {
                Map ret = biz.revertApInvoiceOneCompany(param, cache);
                if (ret == null || ret.get("ids") == null) continue;
                int count = ((Collection)ret.get("ids")).size();
                allids.addAll((Collection)ret.get("ids"));
                detailMsg = detailMsg + this.getResourceStr(ctx, "CancelDownloadBill", new Object[]{company.getName(), count});
            }
            catch (Throwable e) {
                detailMsg = detailMsg + company.getName() + this.getResourceStr(ctx, "CancelDownloadError") + e.getMessage() + "<br>";
            }
        }
        return H.JSMAP("pks", allids, "msg", String.format(this.getResourceStr(ctx, "SuccessCancelBill"), allids.size()), "detailMsg", detailMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _revertApInvoiceOneCompany(Context ctx, Map param, Map cache) throws BOSException, EASBizException {
        List ids;
        if (cache == null) {
            cache = H.CACHE();
        }
        if (H.isEmpty(ids = (List)param.get("ids"))) {
            this.throwEASException(this.getResourceStr(ctx, "MustInputParamt"));
        }
        IObjectPK[] pks = new IObjectPK[ids.size()];
        int len = ids.size();
        for (int i = 0; i < len; ++i) {
            pks[i] = new ObjectUuidPK((String)ids.get(i));
        }
        String companyid = (String)param.get("companyid");
        if (H.isEmpty(companyid)) {
            this.throwEASException(this.getResourceStr(ctx, "MustInputCompanyId"));
        }
        EIVCService eivs = this.getEIVConn(ctx, companyid, cache);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
        String phone = this.getPhoneNumber(ctx, ctx.getUserName(), false);
        if (H.isEmpty(phone)) {
            this.throwEASException(this.getResourceStr(ctx, "GetPhoneErrorCheck"));
        }
        IApInvoice svr = null;
        svr = ApInvoiceFactory.getLocalInstance(ctx);
        ApInvoiceCollection infos = svr.getApInvoiceCollection(H.newEV(H.SIC("id,number,code,randomCode,company.id"), H.FILTER(H.FITEM("isCreatedByElev = 1"), H.include("id", pks))));
        ctx.put((Object)"revertInvoice", (Object)true);
        try {
            for (int i = 0; i < infos.size(); ++i) {
                svr.delete(H.PK(infos.get(i)));
            }
        }
        finally {
            ctx.remove((Object)"revertInvoice");
        }
        try {
            String[] invoiceCode = new String[infos.size()];
            String[] invoiceNumber = new String[infos.size()];
            String[] randomCode = new String[infos.size()];
            String[] companyids = new String[infos.size()];
            for (int i = 0; i < infos.size(); ++i) {
                invoiceCode[i] = infos.get(i).getCode();
                invoiceNumber[i] = infos.get(i).getNumber();
                randomCode[i] = infos.get(i).getRandomCode();
                companyids[i] = H.IDSTR(infos.get(i).getCompany());
            }
            String[] ownRevenueNumbers = this.getOwnRevenueNumbers(ctx, companyids, false);
            if (H.isEmpty(ownRevenueNumbers)) {
                this.throwEASException(this.getResourceStr(ctx, "GetOrgEleBillError"));
            }
            int new_Statue = 2;
            if (invoiceCode.length > 0) {
                eivs.setDownloadFlag(phone, ownRevenueNumbers, invoiceCode, invoiceNumber, randomCode, new_Statue);
            }
        }
        catch (RemoteMethodException e) {
            if (H.same((Object)e.err.methodState, (Object)MethodState.INVOKED)) {
                logger.error((Object)"\u8bbe\u7f6e\u53d1\u7968\u72b6\u6001-\u5df2\u6b63\u786e\u8bbe\u7f6e\u53d1\u7968\u4e91\u5e73\u53f0\u7684\u53d1\u7968\u72b6\u6001\uff0c\u672c\u5730\u5904\u7406\u4ee3\u7801\u5b58\u5728\u5f02\u5e38,\u8bb0\u5f55\u65e5\u5fd7", (Throwable)e);
                this.throwEASException(this.getResourceStr(ctx, "SetBillStatueLocaleCodeException") + e.getMessage(), e);
            }
            this.throwEASException(this.getResourceStr(ctx, "ReWriteBillColdStatueFailu") + e.getMessage(), e);
        }
        return H.JSMAP("ids", ids);
    }

    private String getPairName(Context ctx, MatchPairType pairType) {
        if (MatchPairType.PurOrder == pairType) {
            return this.getResourceStr(ctx, "Order");
        }
        if (MatchPairType.PurInWareHs == pairType) {
            return this.getResourceStr(ctx, "PutInStorageBill");
        }
        return this.getResourceStr(ctx, "ErrorMatchBill");
    }

    private boolean hasInvBlueAndRed(List<Map> invdatas) {
        if (invdatas.size() == 0) {
            return false;
        }
        boolean hasBlue = false;
        boolean hasRed = false;
        for (int i = 0; i < invdatas.size(); ++i) {
            Map invdata = invdatas.get(i);
            if (!hasBlue) {
                boolean bl = hasBlue = H.BDEC(invdata.get("entries.actualAmount")).compareTo(SysConstant.BIGZERO) == 1;
            }
            if (hasRed) continue;
            hasRed = H.BDEC(invdata.get("entries.actualAmount")).compareTo(SysConstant.BIGZERO) == -1;
        }
        return hasBlue && hasRed;
    }

    private boolean zeroInvByBlueAndRed(List<Map> invdatas) {
        BigDecimal invAmt = new BigDecimal(0.0);
        for (int i = 0; i < invdatas.size(); ++i) {
            BigDecimal tmp = H.BDEC(invdatas.get(i).get("entries.actualAmount"));
            invAmt = invAmt.add(tmp);
        }
        return invAmt.compareTo(SysConstant.BIGZERO) == 0;
    }

    private boolean isInvCorrectBlueAndRed(List<Map> invdatas) {
        if (!this.hasInvBlueAndRed(invdatas)) {
            return false;
        }
        int blueCount = 0;
        for (int i = 0; i < invdatas.size(); ++i) {
            if (H.BDEC(invdatas.get(i).get("entries.actualAmount")).compareTo(SysConstant.BIGZERO) != 1) continue;
            ++blueCount;
        }
        return blueCount == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _makeMatch(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList groups;
        String json = (String)((Map)param.get("param")).get("data");
        HashMap jsobj = (HashMap)Kson.getGson().fromJson(json, HashMap.class);
        MatchPairType pairType = MatchPairType.valueOf((String)jsobj.get("MatchPairType"));
        if (pairType == null) {
            this.throwEASException(this.getResourceStr(ctx, "MushPointMatchType"));
        }
        if ((groups = (ArrayList)jsobj.get("groups")) == null || groups.size() == 0) {
            this.throwEASException(this.getResourceStr(ctx, "NoAvalMatchMsg"));
        }
        HashSet<String> bizTypeids = new HashSet<String>();
        HashSet<String> purchaseOrgUnitids = new HashSet<String>();
        HashSet<String> companyids = new HashSet<String>();
        for (Object gp : groups) {
            Object tmp;
            int i;
            List invdatas = (List)gp.get("invdatas");
            List orddatas = (List)gp.get("orddatas");
            boolean hasInvBlueAndRed = this.hasInvBlueAndRed(invdatas);
            boolean zeroInvByBlueAndRed = this.zeroInvByBlueAndRed(invdatas);
            boolean isInvCorrectBlueAndRed = this.isInvCorrectBlueAndRed(invdatas);
            if (hasInvBlueAndRed && !isInvCorrectBlueAndRed) {
                this.throwEASException(this.getResourceStr(ctx, "BillRedBluePushCanSelectOne"));
            }
            BigDecimal ordAmt = new BigDecimal(0.0);
            BigDecimal invAmt = new BigDecimal(0.0);
            for (i = 0; i < invdatas.size(); ++i) {
                tmp = H.BDEC(((Map)invdatas.get(i)).get("entries.actualAmount"));
                if ((invAmt = invAmt.add((BigDecimal)tmp)).compareTo(H.BDEC(0.0)) != 0 || hasInvBlueAndRed && zeroInvByBlueAndRed) continue;
                this.throwEASException(this.getResourceStr(ctx, "BillAmountCannotZero"));
            }
            for (i = 0; i < orddatas.size(); ++i) {
                tmp = H.BDEC(((Map)orddatas.get(i)).get("matchAmount"));
                if ((ordAmt = ordAmt.add(H.BDEC(((Map)orddatas.get(i)).get("matchAmount")))).compareTo(H.BDEC(0.0)) == 0) {
                    this.throwEASException(this.getPairName(ctx, pairType) + this.getResourceStr(ctx, "AmountCannotZero"));
                }
                companyids.add(((Map)orddatas.get(i)).get("companyOrgUnit.id").toString());
                if (companyids.size() > 1) {
                    this.throwEASException(this.getPairName(ctx, pairType) + this.getResourceStr(ctx, "OrgNoIdentical") + ((Map)orddatas.get(i)).get("number"));
                }
                if (pairType != MatchPairType.PurInWareHs) continue;
                bizTypeids.add(((Map)orddatas.get(i)).get("bizType.id").toString());
                if (bizTypeids.size() > 1) {
                    this.throwEASException(this.getResourceStr(ctx, "InStorageTypeNoIdentical") + ((Map)orddatas.get(i)).get("number"));
                }
                purchaseOrgUnitids.add(((Map)orddatas.get(i)).get("entries.purchaseorgunit.id").toString());
                if (purchaseOrgUnitids.size() <= 1) continue;
                this.throwEASException(this.getResourceStr(ctx, "InStoragePurOrgNoIdentical") + ((Map)orddatas.get(i)).get("number"));
            }
            if (!(H.same(invAmt, ordAmt) || hasInvBlueAndRed && zeroInvByBlueAndRed)) {
                this.throwEASException(String.format(this.getResourceStr(ctx, "BillAmountAnd") + this.getPairName(ctx, pairType) + this.getResourceStr(ctx, "AmountNoIdenticalBill") + this.getPairName(ctx, pairType) + "%s ", ((Map)invdatas.get(0)).get("number"), invAmt, ordAmt));
            }
            invAmt = H.BDEC(((Map)invdatas.get(0)).get("entries.actualAmount"));
            ordAmt = H.BDEC(((Map)orddatas.get(0)).get("matchAmount"));
            MatchType mtype = this.getMathedType(ctx, invdatas, orddatas);
            if (mtype == MatchType.many2Many) {
                this.throwEASException(this.getResourceStr(ctx, "NoSportMuliBillMatchDeal", new Object[]{this.getPairName(ctx, pairType)}));
            }
            gp.put("MatchType", mtype);
        }
        LinkedHashSet<String> lockIds = new LinkedHashSet<String>();
        for (Map gp : groups) {
            Object o2;
            List invdatas = (List)gp.get("invdatas");
            lockIds.addAll(H.PROPS2SET("id", invdatas));
            for (Object o2 : invdatas) {
                lockIds.add((String)o2.get("entries.id"));
            }
            List orddatas = (List)gp.get("orddatas");
            lockIds.addAll(H.PROPS2SET("id", orddatas));
            o2 = orddatas.iterator();
            while (o2.hasNext()) {
                Map o3 = (Map)o2.next();
                lockIds.add((String)o3.get("entries.id"));
            }
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map resultRequest = iMutex.batchRequestObjIDForUpdate(H.LIST(lockIds));
        boolean isConflict = false;
        String conflictedId = null;
        for (String id : lockIds) {
            Object ret = resultRequest.get(id);
            if (!H.same(ret, false)) continue;
            isConflict = true;
            conflictedId = id;
            break;
        }
        if (isConflict) {
            ArrayList<String> releaseIds = new ArrayList<String>();
            for (String id : lockIds) {
                Object ret = resultRequest.get(id);
                if (!H.same(ret, true)) continue;
                releaseIds.add(id);
            }
            iMutex.batchReleaseObjIDForUpdate(releaseIds);
            IObjectValue obj = (IObjectValue)H.getInfo(ctx, new Object[]{H.SIC("id,number"), conflictedId});
            this.throwEASException(String.format(this.getResourceStr(ctx, "BillHaveLockWait"), obj.get("number")));
        }
        ArrayList errmsgs = new ArrayList();
        String detailMsg = "";
        int success = 0;
        HashMap cache = new HashMap();
        try {
            LinkedHashSet<IObjectPK> auditedOtherBills = this._innerGenMatchAuditedOtherBills(ctx, pairType, groups, cache);
            if (auditedOtherBills != null) {
                success += auditedOtherBills.size();
                for (IObjectPK pk : auditedOtherBills) {
                    OtherBillInfo othinfo = (OtherBillInfo)H.getInfo(ctx, new Object[]{H.SIC("id,number"), pk});
                    detailMsg = detailMsg + String.format(this.getResourceStr(ctx, "ApBillNumber"), othinfo.getNumber());
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(H.LIST(lockIds));
        }
        String msg = this.getResourceStr(ctx, "HaveCreateApBill", new Object[]{success});
        StringBuffer errorMessage = new StringBuffer();
        if (errmsgs.size() > 0) {
            msg = msg + this.getResourceStr(ctx, "FailuZhang", new Object[]{errmsgs.size()});
            for (String errmsg : errmsgs) {
                errorMessage.append(",").append(errmsg);
            }
        }
        detailMsg = errorMessage.length() == 0 ? detailMsg : errorMessage.substring(1);
        return H.JSMAP("data", H.JSMAP("error", errmsgs.size(), "msg", msg, "detailMsg", detailMsg));
    }

    protected LinkedHashSet<IObjectPK> _innerGenMatchAuditedOtherBills(Context ctx, MatchPairType pairType, ArrayList<Map<String, Object>> groups, Map cache) throws BOSException, EASBizException {
        LinkedHashSet<IObjectPK> auditedOtherBills = new LinkedHashSet<IObjectPK>();
        IOtherBill otherbillBiz = OtherBillFactory.getLocalInstance(ctx);
        LinkedHashMap excuteGroup = new LinkedHashMap();
        for (int i = 0; i < groups.size(); ++i) {
            String invid;
            Map pair;
            String invid2;
            Map invdata;
            int j;
            Map<String, Object> gp = groups.get(i);
            List invdatas = (List)gp.get("invdatas");
            List orddatas = (List)gp.get("orddatas");
            boolean hasInvBlueAndRed = this.hasInvBlueAndRed(invdatas);
            boolean zeroInvByBlueAndRed = this.zeroInvByBlueAndRed(invdatas);
            boolean isInvCorrectBlueAndRed = this.isInvCorrectBlueAndRed(invdatas);
            if (!hasInvBlueAndRed) {
                for (j = 0; j < invdatas.size(); ++j) {
                    invdata = (Map)invdatas.get(j);
                    invid2 = (String)invdata.get("id");
                    ArrayList<Map> ls = (ArrayList<Map>)excuteGroup.get(invid2);
                    if (ls == null) {
                        ls = new ArrayList<Map>();
                        excuteGroup.put(invid2, ls);
                    }
                    pair = H.JSMAP("invdata", invdata, "orddata", orddatas.get(j));
                    ls.add(pair);
                }
            }
            if (invdatas.size() < orddatas.size()) {
                for (j = orddatas.size() - invdatas.size(); j < orddatas.size(); ++j) {
                    invdata = (Map)invdatas.get(0);
                    invid2 = (String)invdata.get("id");
                    ArrayList<Map> pairs = (ArrayList<Map>)excuteGroup.get(invid2);
                    if (pairs == null) {
                        pairs = new ArrayList<Map>();
                        excuteGroup.put(invid2, pairs);
                    }
                    pair = H.JSMAP("invdata", invdata, "orddata", orddatas.get(j));
                    pairs.add(pair);
                }
            }
            if (invdatas.size() <= orddatas.size() || !isInvCorrectBlueAndRed) continue;
            Map orddata = (Map)orddatas.get(0);
            Map blueInvdata = null;
            BigDecimal blueAmount = SysConstant.BIGZERO;
            BigDecimal redAmount = SysConstant.BIGZERO;
            ArrayList<Map> redInvdatas = new ArrayList<Map>();
            for (int j2 = 0; j2 < invdatas.size(); ++j2) {
                Map invdata2 = (Map)invdatas.get(j2);
                BigDecimal amt = H.BDEC(((Map)invdatas.get(j2)).get("entries.actualAmount"));
                if (amt.compareTo(SysConstant.BIGZERO) == 1) {
                    blueInvdata = invdata2;
                    blueAmount = amt;
                }
                if (amt.compareTo(SysConstant.BIGZERO) != -1) continue;
                redInvdatas.add(invdata2);
                redAmount = redAmount.add(amt);
            }
            if (zeroInvByBlueAndRed) {
                String operahash = System.currentTimeMillis() + "" + gp.hashCode();
                invid = blueInvdata == null ? "" : (String)blueInvdata.get("id");
                DbUtil.execute((Context)ctx, (String)("update T_AP_ApInvoice set FIsMatch = 1 where fid ='" + invid + "'; "));
                this.saveBotpRelation(ctx, null, (String)orddata.get("id"), invid, H.BOSTYPE(orddata.get("id")), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                for (int j3 = 0; j3 < redInvdatas.size(); ++j3) {
                    Map invdata3 = (Map)redInvdatas.get(j3);
                    invid = (String)invdata3.get("id");
                    DbUtil.execute((Context)ctx, (String)("update T_AP_ApInvoice set FIsMatch = 1 where fid ='" + invid + "'; "));
                    this.saveBotpRelation(ctx, null, (String)orddata.get("id"), invid, H.BOSTYPE(orddata.get("id")), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                    this.saveBotpRelation(ctx, null, (String)blueInvdata.get("id"), invid, H.BOSTYPE(ApInvoiceInfo.class), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                }
                continue;
            }
            if (blueInvdata == null) continue;
            blueInvdata.put("entries.actualAmount", blueAmount.add(redAmount));
            Map pair2 = H.JSMAP("invdata", blueInvdata, "orddata", orddata, "redInvdatas", redInvdatas);
            invid = (String)blueInvdata.get("id");
            ArrayList<Map> pairs = (ArrayList<Map>)excuteGroup.get(invid);
            if (pairs == null) {
                pairs = new ArrayList<Map>();
                excuteGroup.put(invid, pairs);
            }
            pairs.add(pair2);
        }
        for (ArrayList pairs : excuteGroup.values()) {
            try {
                if (pairType == MatchPairType.PurOrder) {
                    auditedOtherBills.addAll(this.genAuditedOtherBillsForPurOrder(ctx, this.getPairName(ctx, pairType), pairs, otherbillBiz, cache));
                    continue;
                }
                if (pairType != MatchPairType.PurInWareHs) continue;
                auditedOtherBills.addAll(this.genAuditedOtherBillsForPurInWareHs(ctx, this.getPairName(ctx, pairType), pairs, otherbillBiz, cache));
            }
            catch (Throwable e) {
                for (IObjectPK othBillPk : auditedOtherBills) {
                    try {
                        otherbillBiz.unAudit(othBillPk);
                    }
                    catch (Throwable throwable) {}
                }
                Map invdata = (Map)((Map)pairs.get(0)).get("invdata");
                Map orddata = (Map)((Map)pairs.get(0)).get("orddata");
                H.throwEASBizException(String.format(this.getResourceStr(ctx, "BillMatch") + this.getPairName(ctx, pairType) + this.getResourceStr(ctx, "CreatApBillError"), invdata.get("number"), orddata.get("number")), e);
            }
        }
        return auditedOtherBills;
    }

    private LinkedHashSet<IObjectPK> genAuditedOtherBillsForPurInWareHs(Context ctx, String pairName, ArrayList<Map> pairs, IOtherBill otherbillBiz, Map cache) throws BOSException, BOTPException, EASBizException, BTPException {
        Map invdata;
        HashMap<String, PurInWarehsBillInfo> infoMap = new HashMap<String, PurInWarehsBillInfo>();
        HashMap<String, PurInWarehsEntryInfo> entryinfoMap = new HashMap<String, PurInWarehsEntryInfo>();
        CoreBillBaseCollection orderBills = new CoreBillBaseCollection();
        for (Map pair : pairs) {
            BOSUuid ordentryid;
            PurInWarehsEntryInfo entryinfo;
            invdata = (Map)pair.get("invdata");
            Map orddata = (Map)pair.get("orddata");
            BOSUuid ordid = H.UID(orddata.get("id"));
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)infoMap.get(ordid.toString());
            if (info == null) {
                info = new PurInWarehsBillInfo();
                infoMap.put(ordid.toString(), info);
                info.setId(ordid);
                orderBills.add((CoreBillBaseInfo)info);
            }
            if ((entryinfo = (PurInWarehsEntryInfo)entryinfoMap.get((ordentryid = H.UID(orddata.get("entries.id"))).toString())) == null) {
                entryinfo = new PurInWarehsEntryInfo();
                entryinfoMap.put(ordentryid.toString(), entryinfo);
                entryinfo.setId(ordentryid);
                info.getEntries().addObject((IObjectValue)entryinfo);
                entryinfo.setParent(info);
                entryinfo.put("allMatchAmount", (Object)new BigDecimal(0.0));
                entryinfo.put("allMatchQty", (Object)new BigDecimal(0.0));
            }
            entryinfo.put("allMatchAmount", (Object)H.BDEC(orddata.get("matchAmount")).add((BigDecimal)entryinfo.get("allMatchAmount")));
            entryinfo.put("allMatchQty", (Object)H.BDEC(orddata.get("matchQty")).add((BigDecimal)entryinfo.get("allMatchQty")));
        }
        LinkedHashSet<IObjectPK> auditedOtherBills = new LinkedHashSet<IObjectPK>();
        String operahash = System.currentTimeMillis() + "" + pairs.hashCode();
        invdata = (Map)pairs.get(0).get("invdata");
        String invid = (String)invdata.get("id");
        String otherBillBOSType = H.BOSTYPE(OtherBillInfo.class).toString();
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(orderBills, otherBillBOSType, DefineSysEnum.BTP);
        if (botMappingCollection.size() < 1) {
            this.throwEASException(this.getResourceStr(ctx, "NoDefineApBotpNotMatch", new Object[]{pairName}));
        }
        IBTPManager ibtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = ibtpManager.transformForBotp(orderBills, otherBillBOSType, H.PK(botMappingCollection.get(0)));
        ICodingRuleManager crubiz = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (result != null && result.getBills() != null && result.getBills().size() > 0) {
            IObjectCollection otherBills = result.getBills();
            int num = otherBills.size();
            for (int i = 0; i < num; ++i) {
                OtherBillInfo otherBillInfo = (OtherBillInfo)otherBills.getObject(i);
                IObjectPK othInfo = null;
                try {
                    AbstractObjectCollection en = otherBillInfo.getEntries();
                    for (int j = 0; j < en.size(); ++j) {
                        OtherBillentryInfo ent = (OtherBillentryInfo)en.getObject(i);
                        if (ent.getAccount() != null) continue;
                        AccountViewInfo acc = this.getDefaultAccountViewInfo(ctx, otherBillInfo, ent, cache);
                        ent.setAccount(acc);
                    }
                    CodingRuleInfo codeRuleInfo = crubiz.getCodingRule((IObjectValue)otherBillInfo, H.IDSTR(otherBillInfo.getCompany()));
                    if (codeRuleInfo == null || !codeRuleInfo.isIsEnabled()) {
                        otherBillInfo.setNumber(invdata.get("code") + "-" + invdata.get("number") + (otherBills.size() > 1 ? "-" + (i + 1) : ""));
                    }
                    otherBillInfo.setIsCreatedByApElecInvoice(true);
                    for (int j = 0; j < otherBillInfo.getEntries().size(); ++j) {
                        OtherBillentryInfo othEntry = otherBillInfo.getEntry().get(j);
                        String ordentryid = othEntry.getSourceBillEntryId();
                        PurInWarehsEntryInfo entry = (PurInWarehsEntryInfo)entryinfoMap.get(ordentryid);
                        othEntry.setQuantity((BigDecimal)entry.get("allMatchQty"));
                        othEntry.setBaseQty((BigDecimal)entry.get("allMatchQty"));
                        othEntry.setAssistQty((BigDecimal)entry.get("allMatchQty"));
                        otherBillInfo.setAmountLocal(null);
                        ArApBillHelper.calculate(ctx, otherBillInfo, null);
                        BigDecimal allMatchAmount = (BigDecimal)entry.get("allMatchAmount");
                        othEntry.setRecievePayAmount(allMatchAmount);
                        othEntry.setRecievePayAmountLocal(allMatchAmount);
                        BigDecimal taxRate = othEntry.getTaxRate() == null ? new BigDecimal("0.0") : othEntry.getTaxRate();
                        BigDecimal amout = allMatchAmount.divide(H.BDEC("1." + taxRate.toString()), othEntry.getAmount().scale(), RoundingMode.HALF_UP);
                        othEntry.setAmount(amout);
                        othEntry.setTaxAmount(allMatchAmount.subtract(amout));
                        otherBillInfo.setAmountLocal(null);
                        ArApBillHelper.calculate(ctx, otherBillInfo, null);
                        othEntry.setInvoicedAmt(othEntry.getInvoicedAmt().add(allMatchAmount));
                    }
                    othInfo = otherbillBiz.save((CoreBaseInfo)otherBillInfo);
                    othInfo = otherbillBiz.submit((CoreBaseInfo)otherBillInfo);
                }
                catch (Throwable e) {
                    for (int j = 0; j < otherBills.size(); ++j) {
                        othInfo = H.PK(otherBills.getObject(j));
                        otherbillBiz.delete(othInfo);
                    }
                    this.throwEASException(String.format(this.getResourceStr(ctx, "CreatApBillDealError"), otherBillInfo.getNumber()), e);
                }
                try {
                    otherbillBiz.audit(othInfo);
                }
                catch (Throwable e) {
                    otherbillBiz.unAudit(othInfo);
                    this.throwEASException(this.getResourceStr(ctx, "CannotCreatApBill"), e);
                }
                if (i == 0) {
                    for (int j = 0; j < orderBills.size(); ++j) {
                        String purInWareHsID = H.IDSTR(orderBills.get(j));
                        this.saveBotpRelation(ctx, H.IDSTR(botMappingCollection.get(0)), purInWareHsID, invid, H.BOSTYPE(PurInWarehsBillInfo.class), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                    }
                }
                this.saveBotpRelation(ctx, H.IDSTR(botMappingCollection.get(0)), invid, H.IDSTR(otherBillInfo), H.BOSTYPE(ApInvoiceInfo.class), H.BOSTYPE(otherBillInfo), operahash);
                auditedOtherBills.add(othInfo);
            }
            DBUtil.execute((Context)ctx, (String)("update T_AP_ApInvoice set FIsMatch = 1  where fid ='" + invid + "'"));
        }
        return auditedOtherBills;
    }

    @Override
    protected Map _downloadInvoice(Context ctx, Map param) throws BOSException, EASBizException {
        String[] companysIds;
        String companysIdsStr = (String)param.get("companysIds");
        if (H.isEmpty(companysIdsStr)) {
            this.throwEASException(this.getResourceStr(ctx, "MustInputCompanyParamt"));
        }
        if (H.isEmpty(companysIds = companysIdsStr.split(","))) {
            this.throwEASException(this.getResourceStr(ctx, "MustInputCompanyParamt"));
        }
        Map cache = H.CACHE();
        CompanyOrgUnitInfo[] companys = this.getCompanys(ctx, companysIds);
        for (int i = 0; i < companys.length; ++i) {
            cache.put(H.IDSTR(companys[i]), companys[i]);
        }
        ArrayList allpks = new ArrayList();
        String msg = "";
        String detailMsg = "";
        IApElecInoviceFacde biz = ApElecInoviceFacdeFactory.getLocalInstance(ctx);
        for (int i = 0; i < companysIds.length; ++i) {
            param.put("companyid", companysIds[i]);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companysIds[i]);
            Map ret = null;
            try {
                ret = biz.downloadApInvoiceOneCompany(param, cache);
                if (ret == null || ret.get("pks") == null) continue;
                int count = ((Collection)ret.get("pks")).size();
                allpks.addAll((Collection)ret.get("pks"));
                detailMsg = detailMsg + company.getName() + this.getResourceStr(ctx, "DownloadBill", new Object[]{count});
                continue;
            }
            catch (Throwable e) {
                detailMsg = detailMsg + company.getName() + this.getResourceStr(ctx, "DownloadFailu") + e.getMessage() + "<br>";
            }
        }
        return H.JSMAP("pks", allpks, "msg", String.format(this.getResourceStr(ctx, "SuccessDownloadBill"), allpks.size()), "detailMsg", detailMsg);
    }

    @Override
    protected Map _downloadApInvoiceOneCompany(Context ctx, Map param, Map cache) throws BOSException, EASBizException {
        if (cache == null) {
            cache = H.CACHE();
        }
        Date beginDate = H.DATE(param.get("beginDate"), "yyyy-MM-dd");
        Date endDate = H.DATE(param.get("endDate"), "yyyy-MM-dd");
        String companyid = (String)param.get("companyid");
        if (H.isEmpty(companyid)) {
            this.throwEASException(this.getResourceStr(ctx, "MustInputCompanyIdParamt"));
        }
        EIVCService eivs = this.getEIVConn(ctx, companyid, cache);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
        String supplierIdsStr = (String)param.get("supplierIds");
        String[] supplierIds = supplierIdsStr == null ? null : supplierIdsStr.split(",");
        String phone = this.getPhoneNumber(ctx, ctx.getUserName(), false);
        if (H.isEmpty(phone)) {
            this.throwEASException(this.getResourceStr(ctx, "GetPhoneErrorCheck"));
        }
        String[] companysIds = new String[]{companyid};
        HashMap<String, CompanyOrgUnitInfo> regNo_company = new HashMap<String, CompanyOrgUnitInfo>();
        String[] ownRevenueNumbers = this.getOwnRevenueNumbers(ctx, companysIds, false);
        CompanyOrgUnitInfo[] companys = this.getCompanys(ctx, companysIds);
        for (int i = 0; i < ownRevenueNumbers.length; ++i) {
            regNo_company.put(ownRevenueNumbers[i], companys[i]);
        }
        if (H.isEmpty(ownRevenueNumbers)) {
            this.throwEASException(this.getResourceStr(ctx, "NoConfigerNumberCheck"));
        }
        ArrayList<String> otherNums = new ArrayList<String>();
        String[] oppRevenueNumbers = null;
        if (supplierIds != null) {
            for (int i = 0; i < supplierIds.length; ++i) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select  FTAXREGISTERNO from T_BD_Supplier where fid = '" + supplierIds[i] + "'"));
                try {
                    if (!rs.next() || rs.getString(1) == null) continue;
                    otherNums.add(rs.getString(1));
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            oppRevenueNumbers = new String[otherNums.size()];
            otherNums.toArray(oppRevenueNumbers);
        }
        IApInvoice svr = null;
        svr = ApInvoiceFactory.getLocalInstance(ctx);
        ApInvoiceInfo[] infos = null;
        int new_Statue = 2;
        try {
            infos = eivs.getApInvoices(phone, ownRevenueNumbers, oppRevenueNumbers, beginDate, endDate, new_Statue);
            for (int i = 0; i < infos.length; ++i) {
                ApInvoiceInfo info = infos[i];
                String selfRegisterNo = (String)info.get("selfRegisterNo");
                info.setCompany(company);
                info.setCurrency(this.getCurrency(ctx, info));
                info.setAsstActID(this.getAsstActID(ctx, info));
                info.setAsstActType(this.getAsstActType(ctx, info));
            }
        }
        catch (RemoteMethodException e) {
            this.throwEASException(this.getResourceStr(ctx, "GetBillColdBillDateError"), e);
        }
        catch (SQLException e) {
            this.throwEASException(this.getResourceStr(ctx, "GetBillColdBillDateError"), e);
        }
        ArrayList<ApInvoiceInfo> sucInfos = new ArrayList<ApInvoiceInfo>();
        if (infos != null) {
            for (ApInvoiceInfo info : infos) {
                if (info.getCode() == null || info.getNumber() == null) continue;
                try {
                    info.setType(InvoiceTypeEnum.VAT);
                    info.setIsCreatedByElev(true);
                    IObjectPK pk = svr.submit((CoreBaseInfo)info);
                    info.setId(BOSUuid.read((String)pk.toString()));
                    sucInfos.add(info);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            String[] invoiceCode = new String[sucInfos.size()];
            String[] invoiceNumber = new String[sucInfos.size()];
            String[] randomCode = new String[sucInfos.size()];
            String[] compids = new String[sucInfos.size()];
            ownRevenueNumbers = new String[sucInfos.size()];
            oppRevenueNumbers = new String[sucInfos.size()];
            for (int i = 0; i < sucInfos.size(); ++i) {
                invoiceCode[i] = ((ApInvoiceInfo)sucInfos.get(i)).getCode();
                invoiceNumber[i] = ((ApInvoiceInfo)sucInfos.get(i)).getNumber();
                randomCode[i] = null;
                compids[i] = H.IDSTR(((ApInvoiceInfo)sucInfos.get(i)).getCompany());
                ownRevenueNumbers[i] = (String)((ApInvoiceInfo)sucInfos.get(i)).get("selfregisterno");
                oppRevenueNumbers[i] = (String)((ApInvoiceInfo)sucInfos.get(i)).get("taxregisterno");
            }
            int used_Statue = 1;
            if (sucInfos.size() > 0) {
                String[] newRandomcode = eivs.setDownloadFlag(phone, ownRevenueNumbers, invoiceCode, invoiceNumber, randomCode, used_Statue);
                for (int i = 0; i < sucInfos.size(); ++i) {
                    ((ApInvoiceInfo)sucInfos.get(i)).setRandomCode(newRandomcode[i]);
                    DbUtil.execute((Context)ctx, (String)("update T_ap_apinvoice set FRANDOMCODE ='" + newRandomcode[i] + "' where fid = '" + H.IDSTR(sucInfos.get(i)) + "'; "));
                }
            }
        }
        catch (RemoteMethodException e) {
            if (e instanceof AfterInvokingRemoteMethodException && H.same((Object)e.err.methodState, (Object)MethodState.INVOKED)) {
                String err = this.getResourceStr(ctx, "SetBillStatueLocaleCodeException");
                e.printStackTrace();
                this.throwEASException(err, e);
            }
            this.throwEASException(this.getResourceStr(ctx, "ReWriteBillColdStatueFailu"), e);
        }
        ArrayList<String> pks = new ArrayList<String>();
        for (int i = 0; i < sucInfos.size(); ++i) {
            pks.add(H.IDSTR(sucInfos.get(i)));
        }
        return H.JSMAP("pks", pks);
    }

    private EIVCService getEIVConn(Context ctx, String companyid, Map cache) throws BOSException, EASBizException {
        EIVCService eivs;
        CompanyOrgUnitInfo company;
        if (cache.containsKey(companyid)) {
            company = (CompanyOrgUnitInfo)cache.get(companyid);
        } else {
            company = this.getCompanys(ctx, new String[]{companyid})[0];
            cache.put(companyid, company);
        }
        if (cache.containsKey("eivs" + companyid)) {
            eivs = (EIVCService)cache.get("eivs" + companyid);
        } else {
            EIVCConfigInfo cfg = EIVCConfigFactory.getLocalInstance(ctx).getEIVCConfigInfo("select baseurl");
            if (cfg == null) {
                this.throwEASException(this.getResourceStr(ctx, "BillCodeNoConfiger"));
            }
            String baseurl = cfg.getBaseurl();
            Map<Object, Object> row = H.getOneRow(ctx, "select fclientid,fsecretid from T_ARP_EIVCConfigCompany where FCompanyid='" + companyid + "'");
            if (row == null) {
                this.throwEASException(company.getName() + this.getResourceStr(ctx, "NoConfigureBillConnData"));
            }
            String clientId = (String)row.get("fclientid");
            String secretId = (String)row.get("fsecretid");
            eivs = new EIVCService(baseurl, clientId, secretId);
            try {
                eivs.refreshToken();
            }
            catch (RemoteMethodException e1) {
                this.throwEASException(company.getName() + this.getResourceStr(ctx, "getBillConnError"), e1);
            }
            cache.put("eivs" + companyid, company);
        }
        return eivs;
    }

    private LinkedHashSet<IObjectPK> genAuditedOtherBillsForPurOrder(Context ctx, String pairName, ArrayList<Map> pairs, IOtherBill otherbillBiz, Map cache) throws BOSException, BOTPException, EASBizException, BTPException {
        HashMap<String, PurOrderInfo> infoMap = new HashMap<String, PurOrderInfo>();
        HashMap<String, PurOrderEntryInfo> entryinfoMap = new HashMap<String, PurOrderEntryInfo>();
        CoreBillBaseCollection orderBills = new CoreBillBaseCollection();
        List redInvdatas = null;
        for (Map pair : pairs) {
            BOSUuid ordentryid;
            PurOrderEntryInfo entryinfo;
            List tmpRedInvdatas = (List)pair.get("redInvdatas");
            if (tmpRedInvdatas != null) {
                redInvdatas = redInvdatas == null ? tmpRedInvdatas : Boolean.valueOf(redInvdatas.addAll(tmpRedInvdatas));
            }
            Map invdata = (Map)pair.get("invdata");
            Map orddata = (Map)pair.get("orddata");
            BOSUuid ordid = H.UID(orddata.get("id"));
            PurOrderInfo info = (PurOrderInfo)infoMap.get(ordid.toString());
            if (info == null) {
                info = new PurOrderInfo();
                infoMap.put(ordid.toString(), info);
                info.setId(ordid);
                orderBills.add((CoreBillBaseInfo)info);
            }
            if ((entryinfo = (PurOrderEntryInfo)entryinfoMap.get((ordentryid = H.UID(orddata.get("entries.id"))).toString())) == null) {
                entryinfo = new PurOrderEntryInfo();
                entryinfoMap.put(ordentryid.toString(), entryinfo);
                entryinfo.setId(ordentryid);
                info.getEntries().add(entryinfo);
                entryinfo.setParent(info);
                entryinfo.put("allMatchAmount", (Object)new BigDecimal(0.0));
                entryinfo.put("allMatchQty", (Object)new BigDecimal(0.0));
            }
            entryinfo.put("allMatchAmount", (Object)H.BDEC(orddata.get("matchAmount")).add((BigDecimal)entryinfo.get("allMatchAmount")));
            entryinfo.put("allMatchQty", (Object)H.BDEC(orddata.get("matchQty")).add((BigDecimal)entryinfo.get("allMatchQty")));
        }
        LinkedHashSet<IObjectPK> auditedOtherBills = new LinkedHashSet<IObjectPK>();
        String operahash = System.currentTimeMillis() + "" + pairs.hashCode();
        Map invdata = (Map)pairs.get(0).get("invdata");
        String invid = (String)invdata.get("id");
        if (H.BDEC(invdata.get("entries.actualAmount")).compareTo(new BigDecimal(0.0)) == -1) {
            String ordid = (String)infoMap.keySet().iterator().next();
            this.saveBotpRelation(ctx, null, ordid, invid, H.BOSTYPE(PurOrderInfo.class), H.BOSTYPE(ApInvoiceInfo.class), operahash);
            DBUtil.execute((Context)ctx, (String)("update T_AP_ApInvoice set FIsMatch = 1  where fid ='" + invid + "'"));
            return auditedOtherBills;
        }
        String otherBillBOSType = H.BOSTYPE(OtherBillInfo.class).toString();
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(orderBills, otherBillBOSType, DefineSysEnum.BTP);
        if (botMappingCollection.size() < 1) {
            this.throwEASException(this.getResourceStr(ctx, "NoDefineApBotpNotMatch", new Object[]{pairName}));
        }
        IBTPManager ibtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = ibtpManager.transformForBotp(orderBills, otherBillBOSType, H.PK(botMappingCollection.get(0)));
        ICodingRuleManager crubiz = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (result != null && result.getBills() != null && result.getBills().size() > 0) {
            IObjectCollection otherBills = result.getBills();
            int num = otherBills.size();
            for (int i = 0; i < num; ++i) {
                OtherBillInfo otherBillInfo = (OtherBillInfo)otherBills.getObject(i);
                IObjectPK othInfo = null;
                try {
                    AbstractObjectCollection en = otherBillInfo.getEntries();
                    for (int j = 0; j < en.size(); ++j) {
                        OtherBillentryInfo ent = (OtherBillentryInfo)en.getObject(i);
                        if (ent.getAccount() != null) continue;
                        AccountViewInfo acc = this.getDefaultAccountViewInfo(ctx, otherBillInfo, ent, cache);
                        ent.setAccount(acc);
                    }
                    CodingRuleInfo codeRuleInfo = crubiz.getCodingRule((IObjectValue)otherBillInfo, H.IDSTR(otherBillInfo.getCompany()));
                    if (codeRuleInfo == null || !codeRuleInfo.isIsEnabled()) {
                        otherBillInfo.setNumber(invdata.get("code") + "-" + invdata.get("number") + (otherBills.size() > 1 ? "-" + (i + 1) : ""));
                    }
                    otherBillInfo.setIsCreatedByApElecInvoice(true);
                    for (int j = 0; j < otherBillInfo.getEntries().size(); ++j) {
                        OtherBillentryInfo othEntry = otherBillInfo.getEntry().get(j);
                        String ordentryid = othEntry.getSourceBillEntryId();
                        PurOrderEntryInfo entry = (PurOrderEntryInfo)entryinfoMap.get(ordentryid);
                        PurOrderInfo orderInfo = entry.getParent();
                        othEntry.setQuantity((BigDecimal)entry.get("allMatchQty"));
                        othEntry.setBaseQty((BigDecimal)entry.get("allMatchQty"));
                        othEntry.setAssistQty((BigDecimal)entry.get("allMatchQty"));
                        otherBillInfo.setAmountLocal(null);
                        ArApBillHelper.calculate(ctx, otherBillInfo, null);
                        BigDecimal allMatchAmount = (BigDecimal)entry.get("allMatchAmount");
                        othEntry.setRecievePayAmount(allMatchAmount);
                        othEntry.setRecievePayAmountLocal(allMatchAmount);
                        BigDecimal taxRate = othEntry.getTaxRate() == null ? new BigDecimal("0.0") : othEntry.getTaxRate();
                        BigDecimal amout = allMatchAmount.divide(H.add(H.BDEC(1), taxRate), othEntry.getAmount().scale(), RoundingMode.HALF_UP);
                        othEntry.setAmount(amout);
                        othEntry.setTaxAmount(allMatchAmount.subtract(amout));
                        otherBillInfo.setAmountLocal(null);
                        ArApBillHelper.calculate(ctx, otherBillInfo, null);
                        othEntry.setInvoicedAmt(othEntry.getInvoicedAmt().add(allMatchAmount));
                        DBUtil.execute((Context)ctx, (String)("update T_SM_PurOrderEntry set FTOTALINVOICEDAMT = FTOTALINVOICEDAMT + " + othEntry.getInvoicedAmt() + "  where fid ='" + ordentryid + "'"));
                        DBUtil.execute((Context)ctx, (String)("update T_SM_PURORDER set FINVOICEDAMOUNT = FINVOICEDAMOUNT + " + othEntry.getInvoicedAmt() + "  where fid ='" + H.IDSTR(orderInfo) + "'"));
                    }
                    othInfo = otherbillBiz.save((CoreBaseInfo)otherBillInfo);
                    othInfo = otherbillBiz.submit((CoreBaseInfo)otherBillInfo);
                }
                catch (Throwable e) {
                    for (int j = 0; j < otherBills.size(); ++j) {
                        othInfo = H.PK(otherBills.getObject(j));
                        otherbillBiz.delete(othInfo);
                    }
                    this.throwEASException(String.format(this.getResourceStr(ctx, "CreatApBillDealError"), otherBillInfo.getNumber()), e);
                }
                try {
                    otherbillBiz.audit(othInfo);
                }
                catch (Throwable e) {
                    otherbillBiz.unAudit(othInfo);
                    this.throwEASException(this.getResourceStr(ctx, "CannotCreatApBill"), e);
                }
                if (i == 0) {
                    for (int j = 0; j < orderBills.size(); ++j) {
                        String purOrderID = H.IDSTR(orderBills.get(j));
                        this.saveBotpRelation(ctx, H.IDSTR(botMappingCollection.get(0)), purOrderID, invid, H.BOSTYPE(PurOrderInfo.class), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                        if (redInvdatas == null) continue;
                        for (int k = 0; k < redInvdatas.size(); ++k) {
                            Map redInvdata = (Map)redInvdatas.get(k);
                            this.saveBotpRelation(ctx, null, purOrderID, (String)redInvdata.get("id"), H.BOSTYPE(PurOrderInfo.class), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                        }
                    }
                }
                this.saveBotpRelation(ctx, H.IDSTR(botMappingCollection.get(0)), invid, H.IDSTR(otherBillInfo), H.BOSTYPE(ApInvoiceInfo.class), H.BOSTYPE(otherBillInfo), operahash);
                if (redInvdatas != null) {
                    for (int k = 0; k < redInvdatas.size(); ++k) {
                        Map redInvdata = (Map)redInvdatas.get(k);
                        this.saveBotpRelation(ctx, null, (String)redInvdata.get("id"), H.IDSTR(otherBillInfo), H.BOSTYPE(ApInvoiceInfo.class), H.BOSTYPE(otherBillInfo), operahash);
                    }
                }
                auditedOtherBills.add(othInfo);
            }
            DBUtil.execute((Context)ctx, (String)("update T_AP_ApInvoice set FIsMatch = 1  where fid ='" + invid + "'"));
            if (redInvdatas != null) {
                for (int k = 0; k < redInvdatas.size(); ++k) {
                    Map redInvdata = (Map)redInvdatas.get(k);
                    this.saveBotpRelation(ctx, null, invid, (String)redInvdata.get("id"), H.BOSTYPE(ApInvoiceInfo.class), H.BOSTYPE(ApInvoiceInfo.class), operahash);
                    DBUtil.execute((Context)ctx, (String)("update T_AP_ApInvoice set FIsMatch = 1  where fid ='" + redInvdata.get("id") + "'"));
                }
            }
        }
        return auditedOtherBills;
    }

    private void make2Relations(Context ctx, String id1, String id2, String BotpId, BOSObjectType type1, BOSObjectType type2, String operahash) throws BOSException {
        this.saveBotpRelation(ctx, BotpId, id1, id2, type1, type2, operahash);
        this.saveBotpRelation(ctx, BotpId, id2, id1, type2, type1, operahash);
    }

    private AccountViewInfo getDefaultAccountViewInfo(Context ctx, OtherBillInfo otherBillInfo, OtherBillentryInfo entry, Map cache) throws EASBizException, BOSException {
        boolean isContrast;
        boolean isArBill = false;
        String companyid = H.IDSTR(otherBillInfo.getCompany());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get("company");
        if (company == null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(companyid));
        }
        String cuid = H.IDSTR(company.getCU());
        String currencyid = H.IDSTR(otherBillInfo.getCurrency());
        String asstActId = otherBillInfo.getAsstActID();
        AccountViewInfo accountInfo = (AccountViewInfo)cache.get(companyid + cuid + currencyid + asstActId);
        if (accountInfo != null) {
            return accountInfo;
        }
        try {
            accountInfo = ArApServerUtils.getKAClassAccount(ctx, companyid, otherBillInfo.getAsstActID(), isArBill, false, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
        if (accountInfo != null && !(isContrast = iContrastAcct.isContrastAccount(cuid, companyid, accountInfo.getId().toString(), AccountControlAttribute.AP))) {
            accountInfo = null;
        }
        if (accountInfo != null) {
            ArrayList<String> list = new ArrayList<String>();
            AccountCurrencyCollection accCurCol = null;
            AccountCurrencyInfo accCurInfo = null;
            AccountingCurrencyEnum accCurEnum = null;
            accCurCol = accountInfo.getAccountCurrency();
            accCurEnum = accountInfo.getAccountingcurrency();
            int subsize = accCurCol.size();
            for (int j = 0; j < subsize; ++j) {
                accCurInfo = accCurCol.get(j);
                if (accCurInfo.getCurrency() == null) continue;
                list.add(accCurInfo.getCurrency().getId().toString());
            }
            if (AccountingCurrencyEnum.ONECURRENCY == accCurEnum) {
                if (!list.contains(currencyid)) {
                    accountInfo = null;
                }
            } else if (AccountingCurrencyEnum.NOCURRENCY == accCurEnum) {
                // empty if block
            }
        }
        cache.put(companyid + cuid + currencyid + asstActId, accountInfo);
        return accountInfo;
    }

    protected void saveBotpRelation(Context ctx, String BotpId, String srcId, String destId, BOSObjectType srcType, BOSObjectType destType, String operation) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setDestObjectID(destId);
        info.setSrcEntityID(srcType.toString());
        info.setDestEntityID(destType.toString());
        info.setOperatorID(operation);
        info.setBOTMappingID(BotpId);
        info.setType(0);
        info.setDate(new Date());
        info.setIsEffected(true);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _common(Context ctx, Map queryparam) throws BOSException, EASBizException {
        block41: {
            block39: {
                if ("autoGetArInvoice".equals(queryparam.get("action"))) {
                    Map out = ArElecInvoiceFacadeFactory.getLocalInstance(ctx).autoDownloadInvoices();
                    return out;
                }
                if ("saveConn".equals(queryparam.get("action"))) {
                    Map data = (Map)queryparam.get("data");
                    return this.saveConn(ctx, data);
                }
                if ("testConn".equals(queryparam.get("action"))) {
                    Map data = (Map)queryparam.get("data");
                    return this.testConn(ctx, data);
                }
                if (!"getConfig".equals(queryparam.get("action"))) break block39;
                Map<Object, Object> main = H.getOneRow(ctx, "select top 1 fid,fbaseurl from T_ARP_EIVCConfig");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select a.fcompanyid , b.FNAME_l2 as \"fcompanyname\",a.fclientid  , a.fsecretid  from T_ARP_EIVCConfigCompany a,  t_org_company b where a.fcompanyid = b.fid   ");
                ArrayList entry = new ArrayList();
                ICompanyOrgUnit cbiz = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                Map cache = H.CACHE();
                try {
                    IRowSetMetaData meta = rs.getRowSetMetaData();
                    int idx = 0;
                    while (rs.next()) {
                        ++idx;
                        HashMap<String, Object> record = new HashMap<String, Object>();
                        for (int i = 1; i <= meta.getColumnCount(); ++i) {
                            String clabel = meta.getColumnName(i).toLowerCase();
                            if ("fcompanyname".equals(clabel)) {
                                String fcompanyid = (String)record.get("fcompanyid");
                                CompanyOrgUnitInfo info = null;
                                if (cache.containsKey("company" + fcompanyid)) {
                                    info = (CompanyOrgUnitInfo)cache.get("company" + fcompanyid);
                                } else {
                                    info = cbiz.getCompanyOrgUnitInfo(H.PK(fcompanyid), H.SIC("id,name,number,company.id"));
                                    cache.put("company" + fcompanyid, info);
                                }
                                record.put(clabel, info);
                                continue;
                            }
                            record.put(clabel, rs.getObject(i));
                        }
                        record.put("rid", idx);
                        record.put("isok", this.getResourceStr(ctx, "NoCheck"));
                        entry.add(record);
                    }
                }
                catch (Throwable e) {
                    try {
                        this.throwEASException(this.getResourceStr(ctx, "GetConfigureError"), e);
                    }
                    catch (Throwable throwable) {
                        H.safeClose(rs);
                        throw throwable;
                    }
                    H.safeClose(rs);
                }
                H.safeClose(rs);
                return H.JSMAP("data", H.JSMAP("main", main, "entry", entry));
            }
            if ("testno".equals(queryparam.get("action"))) {
                Map data = (Map)queryparam.get("data");
                String companyid = (String)data.get("companyid");
                CompanyOrgUnitInfo company = companyid == null || companyid.equals("null") ? (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company) : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(companyid));
                String[] companyids = new String[]{H.IDSTR(company)};
                String[] ownRevenueNumbers = this.getOwnRevenueNumbers(ctx, companyids, true);
                return H.JSMAP("data", ownRevenueNumbers);
            }
            if ("testphone".equals(queryparam.get("action"))) {
                Map data = (Map)queryparam.get("data");
                String user = (String)data.get("user");
                if (user == null || user.equals("null")) {
                    user = ctx.getUserName();
                }
                String phone = this.getPhoneNumber(ctx, ctx.getUserName(), true);
                return H.JSMAP("data", phone);
            }
            if (!"matchDataQuery".equals(queryparam.get("action"))) break block41;
            Map param = (Map)queryparam.get("data");
            MatchPairType pairtype = MatchPairType.valueOf((String)param.get("MatchPairType"));
            if (pairtype == null) {
                this.throwEASException(this.getResourceStr(ctx, "MushPointMatchType"));
            }
            String queryPK = null;
            if (pairtype == MatchPairType.PurOrder) {
                queryPK = "com.kingdee.eas.scm.sm.pur.app.PurOrderQuery";
            } else if (pairtype == MatchPairType.PurInWareHs) {
                queryPK = "com.kingdee.eas.scm.im.inv.PurInWarehsQuery";
            }
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
            String companyId = (String)param.get("companyId");
            String currencyId = (String)param.get("currencyId");
            String supplierId = (String)param.get("supplierId");
            String selectOql = null;
            if (pairtype == MatchPairType.PurOrder) {
                selectOql = "id,supplier.name,number,bizDate,material.name,entries.qty,entries.totalInvoicedQty,entries.totalInvoicedAmount,entries.actualTaxPrice,entries.taxAmount,entries.id,currency.id,companyOrgUnit.id,supplier.id";
            } else if (pairtype == MatchPairType.PurInWareHs) {
                selectOql = "id,bizType.id,supplier.name,number,bizDate,material.name,entry.qty \"entries.qty\",entry.writtenOffQty \"entries.totalInvoicedQty\",entry.writtenOffAmount \"entries.totalInvoicedAmount\",entry.actualTaxPrice \"entries.actualTaxPrice\",entry.taxAmount \"entries.taxAmount\",entry.purchaseorgunit.id \"entries.purchaseorgunit.id\",entry.id \"entries.id\",currency.id,companyOrgUnit.id,supplier.id";
            }
            EntityViewInfo entityViewInfo = H.newEV(H.SIC(selectOql), H.FILTER("where companyOrgUnit.id = '" + companyId + "' and currency.id='" + currencyId + "' and supplier.id = '" + supplierId + "' "));
            exec.setObjectView(entityViewInfo);
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isAutoTranslateEnum = true;
            exec.option().isIgnorePermissionCheck = false;
            IRowSet rs = exec.executeQuery();
            ArrayList data = new ArrayList();
            try {
                IRowSetMetaData meta = rs.getRowSetMetaData();
                int idx = 0;
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        record.put(meta.getColumnName(i), rs.getObject(i));
                    }
                    record.put("rowid", record.get("entries.id").toString());
                    BigDecimal canAmt = H.BDEC(record.get("entries.taxAmount").toString()).subtract(H.BDEC(record.get("entries.totalInvoicedAmount").toString()));
                    record.put("entries.canMatchAmount", canAmt);
                    BigDecimal canQty = H.BDEC(record.get("entries.qty").toString()).subtract(H.BDEC(record.get("entries.totalInvoicedQty").toString()));
                    record.put("entries.canMatchQty", canQty);
                    record.put("order", ++idx);
                    record.put("oldorder", idx);
                    record.put("isCheck", 0);
                    record.put("matchAmount", record.get("entries.canMatchAmount"));
                    record.put("matchQty", record.get("entries.canMatchQty"));
                    data.add(record);
                }
            }
            catch (Throwable e) {
                try {
                    this.throwEASException(this.getResourceStr(ctx, "GetPurOrderDataError"), e);
                }
                catch (Throwable throwable) {
                    H.safeClose(rs);
                    throw throwable;
                }
                H.safeClose(rs);
            }
            H.safeClose(rs);
            return H.JSMAP("data", data);
        }
        if ("invDataQuery".equals(queryparam.get("action"))) {
            Map param = (Map)queryparam.get("data");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.ap.app.ApInvoiceWebQuery"));
            String numbers = (String)param.get("numbers");
            String codes = (String)param.get("codes");
            EntityViewInfo entityViewInfo = H.newEV(H.SIC("isCheck,isMatch,company.name,code,number,asstAcct,billDate,entries.txtMaterial,entries.quantity,entries.unitPrice,entries.amount,entries.actualAmount,description, asstActID, id,entries.id,currency.id,company.id"), H.FILTER("where number in (" + numbers + ") and code in (" + codes + ") "));
            exec.setObjectView(entityViewInfo);
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isAutoTranslateEnum = true;
            exec.option().isIgnorePermissionCheck = false;
            IRowSet rs = exec.executeQuery();
            ArrayList data = new ArrayList();
            try {
                IRowSetMetaData meta = rs.getRowSetMetaData();
                int idx = 0;
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        record.put(meta.getColumnName(i), rs.getObject(i));
                    }
                    record.put("rowid", record.get("id").toString() + record.get("entries.id").toString());
                    record.put("order", ++idx);
                    record.put("oldorder", idx);
                    data.add(record);
                }
            }
            catch (Throwable e) {
                this.throwEASException(this.getResourceStr(ctx, "GetBillDataError"), e);
            }
            return H.JSMAP("data", data);
        }
        if ("bizCommonQuery".equals(queryparam.get("action"))) {
            Map param = (Map)queryparam.get("data");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.ap.app.ApInvoiceWebQuery"));
            String filter = (String)param.get("filter");
            EntityViewInfo entityViewInfo = H.newEV(H.SIC("isCheck,isMatch,code,number,asstAcct,billDate,entries.txtMaterial,entries.quantity, entries.unitPrice,entries.amount,entries.actualAmount,description,asstActID,id,entries.id,currency.id,company.id,company.name"), H.FILTER(filter));
            exec.setObjectView(entityViewInfo);
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isAutoTranslateEnum = true;
            exec.option().isIgnorePermissionCheck = false;
            IRowSet rs = exec.executeQuery();
            ArrayList data = new ArrayList();
            try {
                IRowSetMetaData meta = rs.getRowSetMetaData();
                int idx = 0;
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        record.put(meta.getColumnName(i), rs.getObject(i));
                    }
                    if (record.get("entries.id") == null) continue;
                    record.put("rowid", record.get("id").toString() + record.get("entries.id").toString());
                    record.put("order", ++idx);
                    record.put("oldorder", idx);
                    data.add(record);
                }
            }
            catch (Throwable e) {
                this.throwEASException(this.getResourceStr(ctx, "GetBillDataError"), e);
            }
            return H.JSMAP("data", data);
        }
        if ("submitMatch".equals(queryparam.get("action"))) {
            // empty if block
        }
        return null;
    }

    private MatchType getMathedType(Context ctx, List<Map> invdatas, List<Map> orddatas) throws EASBizException {
        if (invdatas.size() > 1 && orddatas.size() > 1 && invdatas.size() != orddatas.size()) {
            this.throwEASException(String.format(this.getResourceStr(ctx, "GroupBillDataOrderData"), invdatas.size(), orddatas.size()));
        }
        HashSet<String> invids = new HashSet<String>();
        HashSet<String> ordids = new HashSet<String>();
        for (Map idata : invdatas) {
            invids.add((String)idata.get("id"));
        }
        for (Map odata : orddatas) {
            ordids.add((String)odata.get("id"));
        }
        if (invids.size() == 1 && ordids.size() == 1) {
            return MatchType.one2One;
        }
        if (invids.size() == 1 && ordids.size() > 1) {
            return MatchType.one2Many;
        }
        if (invids.size() > 1 && ordids.size() == 1) {
            return MatchType.many2One;
        }
        if (invids.size() > 1 && ordids.size() > 1) {
            return MatchType.many2Many;
        }
        return null;
    }

    private boolean hasBlueAndRed(BigDecimal bdec, BigDecimal bdec2) {
        return bdec.compareTo(H.BDEC(0.0)) != bdec2.compareTo(H.BDEC(0.0));
    }

    @Override
    protected void _assignSupplier(Context ctx, String[] invoiceIdArr, String[] orgIdArr, String supplierId) throws BOSException, EASBizException {
        int i;
        ISupplier iSupp = SupplierFactory.getLocalInstance((Context)ctx);
        SupplierInfo supplier = iSupp.getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierId));
        Locale loc = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_AP_ApInvoice SET ");
        sql.append(" FAsstActID = '").append(supplier.getId().toString()).append("'");
        sql.append(", FAsstActNumber = '").append(supplier.getNumber()).append("'");
        sql.append(", FAsstActName_").append(loc.toString()).append(" = '").append(supplier.getName()).append("'");
        sql.append(" WHERE FID IN (");
        int len = invoiceIdArr.length;
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("'").append(invoiceIdArr[i]).append("'");
        }
        sql.append(")");
        sql.append(" AND FCompanyId IN (");
        len = orgIdArr.length;
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("'").append(orgIdArr[i]).append("'");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected Map _testConn(Context ctx, Map param) throws BOSException, EASBizException {
        String msg = this.getResourceStr(ctx, "ConnectSuccess");
        String baseurl = (String)param.get("baseurl");
        List entry = (List)param.get("entry");
        if (H.isEmpty(entry)) {
            return null;
        }
        for (int i = 0; i < entry.size(); ++i) {
            Map e = (Map)entry.get(i);
            String clientid = (String)e.get("fclientid");
            String secretid = (String)e.get("fsecretid");
            if (H.hasEmpty(clientid, secretid)) {
                e.put("isok", this.getResourceStr(ctx, "NoRightConfigure"));
                continue;
            }
            EIVCService eivs = new EIVCService(baseurl, clientid, secretid);
            try {
                eivs.refreshToken();
            }
            catch (RemoteMethodException e1) {
                e.put("isok", this.getResourceStr(ctx, "getTokenFailu"));
                continue;
            }
            e.put("isok", this.getResourceStr(ctx, "ConnectOk"));
        }
        return H.JSMAP("entry", entry);
    }

    @Override
    protected Map _saveConn(Context ctx, Map param) throws BOSException, EASBizException {
        String sql;
        String msg = this.getResourceStr(ctx, "SaveSuccess");
        Map<Object, Object> row = H.getOneRow(ctx, "select top 1 fid,fbaseurl   from T_ARP_EIVCConfig");
        String baseurl = (String)param.get("baseurl");
        if (row == null) {
            sql = String.format("insert into T_ARP_EIVCConfig(fid, fbaseurl) values (newbosid('16A61648'), '%s'); ", baseurl);
        } else {
            String fid = (String)row.get(1);
            sql = String.format("update T_ARP_EIVCConfig set fbaseurl='%s'  where fid ='%s'; ", baseurl, fid);
        }
        DbUtil.execute((Context)ctx, (String)sql);
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_ARP_EIVCConfigCompany;");
        List entry = (List)param.get("entry");
        if (H.exist(entry)) {
            for (int i = 0; i < entry.size(); ++i) {
                Map e = (Map)entry.get(i);
                String companyid = (String)e.get("fcompanyid");
                String clientid = (String)e.get("fclientid");
                clientid = clientid == null ? "null" : "'" + clientid + "'";
                String secretid = (String)e.get("fsecretid");
                secretid = secretid == null ? "null" : "'" + secretid + "'";
                DbUtil.execute((Context)ctx, (String)String.format("insert into T_ARP_EIVCConfigCompany(fcompanyid,fclientid,fsecretid) values('%s',%s,%s)", companyid, clientid, secretid));
            }
        }
        return H.JSMAP("msg", msg);
    }

    private String getResourceStr(Context ctx, String key) {
        String resClassName = "com.kingdee.eas.fi.ap.ApAllResource";
        return EASResource.getString((String)resClassName, (String)key, (Locale)ctx.getOriginLocale());
    }

    private String getResourceStr(Context ctx, String key, Object[] params) {
        String str = this.getResourceStr(ctx, key);
        MessageFormat mf = new MessageFormat(str);
        String result = mf.format(params);
        return result;
    }
}

