/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.BillStatusEnum;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.app.AbstractApOtherBillReportFacadeControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ApOtherBillReportFacadeControllerBean
extends AbstractApOtherBillReportFacadeControllerBean {
    private static final long serialVersionUID = 3667780299482424448L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.ApOtherBillReportFacadeControllerBean");
    private static final long DAY_MINISECONDS = 86400000L;
    private static String rt = "\r\n";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTableName = this.queryAndFillTempTable(ctx, params);
        int count = this.getRowCount(ctx, params, tempTableName);
        params.setString("tempTable", tempTableName);
        params.setInt("rowCount", count);
        return params;
    }

    private String queryAndFillTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTableName = "Tmp_Ap_OtherBill_Report";
        String sql = this.getCreateSql(ctx, params, tempTableName);
        CreateTempTableResult createRslt = this.executeCreateTableAsSelectInto(sql, null, ctx);
        tempTableName = createRslt.getTempTable();
        this.sumQueryData(ctx, tempTableName, params);
        this.sumCurrencyData(ctx, tempTableName);
        return tempTableName;
    }

    private String getCreateSql(Context ctx, RptParams params, String tempTableName) throws EASBizException, BOSException {
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer("");
        this.getQueryFieldsSql(sb, lang);
        sb.append("\r\n into ").append(tempTableName).append(rt);
        this.getQueryFromOriginTableSql(sb);
        this.getQueryConditionSql(ctx, params, sb);
        logger.debug((Object)("apBillRpt BillSql:\r\n" + sb));
        return sb.toString();
    }

    private void getQueryFieldsSql(StringBuffer sb, String lang) {
        sb.append("select 0 flag,");
        sb.append("totherbill.FID fid, ");
        sb.append("totherbill.FNumber fnumber,").append(rt);
        sb.append("totherbill.FBillStatus fbillstate,");
        sb.append("totherbill.FBillDate fbilldate,").append(rt);
        sb.append("totherbill.FBillType fbilltype,");
        sb.append("totherbill.FSourceBillType fsourcebilltype,");
        sb.append("tasstActType.FNumber fasstacttypenumber,");
        sb.append("tasstActType.FName_" + lang + " fasstacttype,");
        sb.append("totherbill.isnull(totherbill.FAsstActNumber, '') fasstactnumber, ");
        sb.append("totherbill.FAsstActName_" + lang + " fasstactname,").append(rt);
        sb.append("tcurrency.isnull(tcurrency.FNumber, '') fcurrencynumber, ");
        sb.append("tcurrency.FName_" + lang + " fcurrency,");
        sb.append("tcurrency.FPrecision fprecision, ");
        sb.append("tpurorg.FName_" + lang + " fpurorg,");
        sb.append("tadminorg.isnull(tadminorg.FNumber, '') fadminorgnumber, ");
        sb.append("tadminorg.FName_" + lang + " fadminorg,").append(rt);
        sb.append("tperson.isnull(tperson.FNumber, '') fpersonnumber, ");
        sb.append("tperson.FName_" + lang + " fperson,");
        sb.append("tstorage.isnull(tstorage.FNumber, '') fstoragenumber, ");
        sb.append("tstorage.FName_" + lang + " fstorage,");
        sb.append("totherbill.FAbstractName FAbstractName,");
        sb.append("sum(totherbillentry.isnull(totherbillentry.FRecievePayAmount, 0)) frecievePayAmount,");
        sb.append("sum(totherbillentry.isnull(totherbillentry.FRecievePayAmountLocal, 0)) frecievePayAmountLocal,").append(rt);
        sb.append("sum(totherbillentry.isnull(totherbillentry.FVerifyAmount, 0)) fverifyamount,");
        sb.append("sum(totherbillentry.isnull(totherbillentry.FVerifyAmountLocal, 0)) fverifyamountlocal,").append(rt);
        sb.append("sum(totherbillentry.isnull(totherbillentry.FUnVerifyAmount, 0)) funverifyamount,");
        sb.append("sum(totherbillentry.isnull(totherbillentry.FUnVerifyAmountLocal, 0)) funverifyamountlocal").append(" ");
    }

    private void getQueryFromOriginTableSql(StringBuffer sb) {
        sb.append("from T_AP_OtherBill totherbill inner join T_AP_OtherBillentry totherbillentry ").append(rt);
        sb.append("on totherbill.fid = totherbillentry.fparentid").append(rt);
        sb.append("left join T_BD_AsstActType tasstActType ");
        sb.append("on totherbill.FAsstActTypeID=tasstActType.FID").append(rt);
        sb.append("left join T_BD_Currency tcurrency ");
        sb.append("on totherbill.FCurrencyID=tcurrency.FID").append(rt);
        sb.append("left join T_ORG_Purchase tpurorg ");
        sb.append("on totherbill.FPurOrgID=tpurorg.FID").append(rt);
        sb.append("left join T_ORG_Admin tadminorg ");
        sb.append("on totherbill.FAdminOrgUnitID=tadminorg.FID").append(rt);
        sb.append("left join T_BD_Person tperson ");
        sb.append("on totherbill.FPersonID=tperson.FID").append(rt);
        sb.append("left join t_org_storage tstorage ");
        sb.append("on  totherbillentry.FRecSendOrgUnitID=tstorage.FID");
        sb.append(rt);
    }

    private void getQueryConditionSql(Context ctx, RptParams params, StringBuffer sb) throws EASBizException, BOSException {
        sb.append("where ");
        sb.append("totherbill.FCompanyID='").append(params.getString("company")).append("'").append(rt);
        if (this.notNullString(params.getString("billType"))) {
            sb.append("and totherbill.FBillType=").append(params.getString("billType")).append(rt);
        }
        if (this.notNullString(params.getString("currency"))) {
            sb.append("and totherbill.FCurrencyID='").append(params.getString("currency")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("asstActType"))) {
            sb.append("and totherbill.FAsstActTypeID='").append(params.getString("asstActType")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("asstActNumberFrom"))) {
            sb.append("and totherbill.FAsstActNumber>='").append(params.getString("asstActNumberFrom")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("asstActNumberTo"))) {
            sb.append("and totherbill.FAsstActNumber<='").append(params.getString("asstActNumberTo")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("billDateFrom"))) {
            sb.append("and totherbill.FBillDate >={").append(params.getString("billDateFrom")).append("}");
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.notNullString(params.getString("billDateTo"))) {
            try {
                Date billToDate = dtFormat.parse(params.getString("billDateTo"));
                billToDate.setTime(billToDate.getTime() + 86400000L);
                String billToDateString = dtFormat.format(billToDate);
                sb.append("and totherbill.FBillDate <{").append(billToDateString).append("}");
            }
            catch (Exception e) {
                sb.append("and totherbill.FBillDate <={").append(params.getString("billDateTo")).append("}");
            }
        }
        if (this.notNullString(params.getString("numberFrom"))) {
            sb.append("and totherbill.FNumber>='").append(params.getString("numberFrom")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("numberTo"))) {
            sb.append("and totherbill.FNumber<='").append(params.getString("numberTo")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("purOrgNumberFrom"))) {
            sb.append("and tpurorg.FNumber>='").append(params.getString("purOrgNumberFrom")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("purOrgNumberTo"))) {
            sb.append("and tpurorg.FNumber<='").append(params.getString("purOrgNumberTo")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("adminOrgNumberFrom"))) {
            sb.append("and tadminorg.FNumber>='").append(params.getString("adminOrgNumberFrom")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("adminOrgNumberTo"))) {
            sb.append("and tadminorg.FNumber<='").append(params.getString("adminOrgNumberTo")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("personNumberFrom"))) {
            sb.append("and tperson.FNumber>='").append(params.getString("personNumberFrom")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("personNumberTo"))) {
            sb.append("and tperson.FNumber<='").append(params.getString("personNumberTo")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("receivedOrgUnitNumberFrom"))) {
            sb.append("and tstorage.FNumber>='").append(params.getString("receivedOrgUnitNumberFrom")).append("'").append(rt);
        }
        if (this.notNullString(params.getString("receivedOrgUnitNumberTo"))) {
            sb.append("and tstorage.FNumber<='").append(params.getString("receivedOrgUnitNumberTo")).append("'").append(rt);
        }
        if ("no".equals(params.getString("audit"))) {
            sb.append("and totherbill.FBillStatus in (").append(1).append(",");
            sb.append(2).append(")").append(rt);
        } else if ("yes".equals(params.getString("audit"))) {
            sb.append("and totherbill.FBillStatus=").append(3).append("").append(rt);
        } else {
            sb.append("and totherbill.FBillStatus <>").append(-1).append("").append(rt);
        }
        if ("no".equals(params.getString("verify"))) {
            sb.append("(totherbill.FVerifyAmount = 0 or totherbill.FVerifyAmount is null)").append(rt);
        } else if ("some".equals(params.getString("verify"))) {
            sb.append("and ((totherbill.FVerifyAmount > 0");
            sb.append(" and totherbill.FVerifyAmount < totherbill.FAmount)");
            sb.append(" or (totherbill.FVerifyAmount < 0 and totherbill.FVerifyAmount > totherbill.FAmount))");
            sb.append(rt);
        } else if ("yes".equals(params.getString("verify"))) {
            sb.append("and (totherbill.FVerifyAmount = totherbill.FAmount and totherbill.FVerifyAmount <> 0 )").append(rt);
        }
        if ("no".equals(params.getString("voucher"))) {
            sb.append("and totherbill.FFiVouchered = 0");
            sb.append(" and totherbill.FBillDate>={").append(dtFormat.format(this.getSysStartDate(ctx, params))).append("}");
            sb.append(rt);
        } else if ("yes".equals(params.getString("voucher"))) {
            sb.append("and (totherbill.FFiVouchered = 1");
            sb.append(" or totherbill.FBillDate<{").append(dtFormat.format(this.getSysStartDate(ctx, params))).append("})");
            sb.append(rt);
        }
    }

    private Date getSysStartDate(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = this.getCompany(ctx, params.getString("company"));
        SystemStatusCtrolInfo systmSttsCtrlInf = this.getSysStatusCtrolInfo(ctx, currentCompany, SystemEnum.ACCOUNTSPAYABLE);
        if (systmSttsCtrlInf == null) {
            return null;
        }
        PeriodInfo startPeriod = systmSttsCtrlInf.getStartPeriod();
        if (startPeriod == null) {
            return null;
        }
        return startPeriod.getBeginDate();
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
    }

    private SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, CompanyOrgUnitInfo cmpnyOrgUntInf, SystemEnum system) throws BOSException, EASBizException {
        if (cmpnyOrgUntInf == null) {
            return null;
        }
        String cmpnyOrgUntID = cmpnyOrgUntInf.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,currentPeriod.*,startPeriod.* where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    private void sumQueryData(Context ctx, String tempTableName, RptParams params) throws BOSException {
        StringBuffer sb = new StringBuffer("");
        this.getInsertSumSql(sb, params, tempTableName);
        logger.debug((Object)("apBillRpt RptSql:\r\n" + sb));
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void getInsertSumSql(StringBuffer sb, RptParams params, String tempTableName) {
        sb.append("Insert into ").append(tempTableName).append("(flag").append(rt);
        sb.append(",fcurrencynumber, fcurrency, fprecision");
        if (this.notNullString(params.getString("sumAdminorg"))) {
            sb.append(",fadminorgnumber, fadminorg");
        }
        if (this.notNullString(params.getString("sumPerson"))) {
            sb.append(",fpersonnumber, fperson");
        }
        if (this.notNullString(params.getString("sumAsstact"))) {
            sb.append(", fasstacttypenumber, fasstacttype");
            sb.append(",fasstactnumber, fasstactname");
        }
        sb.append(",frecievePayAmount, frecievePayAmountLocal").append(rt);
        sb.append(",fverifyamount, fverifyamountlocal").append(rt);
        sb.append(",funverifyamount, funverifyamountlocal)").append(rt);
        sb.append("select 1");
        sb.append(", fcurrencynumber, fcurrency, fprecision");
        if (this.notNullString(params.getString("sumAdminorg"))) {
            sb.append(", fadminorgnumber,  fadminorg");
        }
        if (this.notNullString(params.getString("sumPerson"))) {
            sb.append(", fpersonnumber, fperson");
        }
        if (this.notNullString(params.getString("sumAsstact"))) {
            sb.append(",fasstacttypenumber, fasstacttype");
            sb.append(",fasstactnumber, fasstactname");
        }
        sb.append(",sum(frecievePayAmount), sum(frecievePayAmountLocal)").append(rt);
        sb.append(", sum(fverifyamount),sum(fverifyamountlocal)").append(rt);
        sb.append(",sum(funverifyamount), sum(funverifyamountlocal)").append(rt);
        sb.append("from ").append(tempTableName).append(rt);
        sb.append("group by ");
        sb.append("fcurrencynumber, fcurrency, fprecision");
        if (this.notNullString(params.getString("sumAsstact"))) {
            sb.append(", fasstacttypenumber, fasstacttype");
            sb.append(", fasstactnumber, fasstactname");
        }
        if (this.notNullString(params.getString("sumAdminorg"))) {
            sb.append(", fadminorgnumber, fadminorg");
        }
        if (this.notNullString(params.getString("sumPerson"))) {
            sb.append(",fpersonnumber, fperson");
        }
    }

    private void sumCurrencyData(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert into ").append(tempTableName);
        sb.append("(flag").append(rt);
        sb.append(",fcurrencynumber, fcurrency, fprecision");
        sb.append(", frecievePayAmount, frecievePayAmountLocal").append(rt);
        sb.append(", fverifyamount, fverifyamountlocal").append(rt);
        sb.append(", funverifyamount, funverifyamountlocal)").append(rt);
        sb.append("select 2");
        sb.append(",fcurrencynumber, fcurrency, fprecision");
        sb.append(",sum(frecievePayAmount), sum(frecievePayAmountLocal)").append(rt);
        sb.append(",sum(fverifyamount),sum(fverifyamountlocal)").append(rt);
        sb.append(",sum(funverifyamount),sum(funverifyamountlocal)").append(rt);
        sb.append("from ").append(tempTableName).append(rt);
        sb.append("where flag = 1").append(rt);
        sb.append(" group by ");
        sb.append(" fcurrencynumber, fcurrency, fprecision");
        logger.debug((Object)("apBillRpt RptSql:\r\n" + sb));
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private int getRowCount(Context ctx, RptParams rptParams, String tempTableName) throws BOSException {
        String countSql = "select count(1) cc from " + tempTableName;
        if (!("yes".equals(rptParams.getString("sumAsstact")) || "yes".equals(rptParams.getString("sumAdminorg")) || "yes".equals(rptParams.getString("sumPerson")))) {
            countSql = countSql + " where flag <> 1";
        }
        RptRowSet countRS = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (countRS.next()) {
            count = countRS.getInt(0);
        }
        return count;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("");
        this.getSelectSql(sb, params);
        RptRowSet rs = this.executeQuery(sb.toString(), null, from, len, ctx);
        this.replaceEnumWithString(ctx, rs);
        params.setObject("rowset", (Object)rs);
        return params;
    }

    private void replaceEnumWithString(Context ctx, RptRowSet rs) {
        Locale locale = ctx.getLocale();
        while (rs.next()) {
            String billTypeString = "";
            String sourceBillTypeString = "";
            if (rs.getObject("fbillstate") != null) {
                String billStateString = BillStatusEnum.getEnum(rs.getInt("fbillstate")).getAlias(locale);
                rs.setValue("fbillstate", (Object)billStateString);
            }
            if (rs.getObject("fbilltype") != null) {
                OtherBillType billTypeEum = OtherBillType.getEnum((int)rs.getInt("fbilltype"));
                if (billTypeEum != null) {
                    billTypeString = billTypeEum.getAlias(locale);
                }
                rs.setValue("fbilltype", (Object)billTypeString);
            }
            if (rs.getObject("fsourcebilltype") == null) continue;
            VerificateBillTypeEnum sourceBillTypeEnum = VerificateBillTypeEnum.getEnum((int)rs.getInt("fsourcebilltype"));
            if (sourceBillTypeEnum != null) {
                sourceBillTypeString = sourceBillTypeEnum.getAlias(locale);
            }
            rs.setValue("fsourcebilltype", (Object)sourceBillTypeString);
        }
        rs.reset();
    }

    private void getSelectSql(StringBuffer sb, RptParams params) {
        sb.append("select flag, fcurrency, fprecision, fnumber, ").append(rt);
        sb.append("fbillstate, fbilldate,fbilltype,").append(rt);
        sb.append(" fsourcebilltype,fasstacttype,fasstactnumber,");
        sb.append("fasstactname, fpurorg, fadminorg,").append(rt);
        sb.append("fperson,fstorage, fabstractname,frecievePayAmount, frecievePayAmountLocal,").append(rt);
        sb.append("fverifyamount, fverifyamountlocal,").append(rt);
        sb.append("funverifyamount, funverifyamountlocal").append(rt);
        sb.append("from ").append(params.getString("tempTable")).append(rt);
        boolean isNeedAllSum = false;
        if ("yes".equals(params.getString("sumAsstact"))) {
            isNeedAllSum = true;
        } else if ("yes".equals(params.getString("sumAdminorg"))) {
            isNeedAllSum = true;
        } else if ("yes".equals(params.getString("sumPerson"))) {
            isNeedAllSum = true;
        }
        if (!isNeedAllSum) {
            sb.append("where flag <> 1 ").append(rt);
        }
        sb.append("order by fcurrencynumber");
        if ("yes".equals(params.getString("sumAsstact"))) {
            sb.append(", fasstacttypenumber, fasstactnumber");
        }
        if ("yes".equals(params.getString("sumAdminorg"))) {
            sb.append(",fadminorgnumber");
        }
        if ("yes".equals(params.getString("sumPerson"))) {
            sb.append(",fpersonnumber");
        }
        sb.append(",flag ,fbilldate, fnumber");
        logger.debug((Object)("apBillRpt RptSql:\r\n" + sb));
    }

    private boolean notNullString(String string) {
        return string != null && string.trim().length() != 0;
    }

    private boolean isAllString(String string) {
        return string != null && "All".equals(string);
    }

    protected String getTempTableName(String desc, Context ctx) throws BOSException {
        String tbl = null;
        return tbl;
    }
}

