/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.IOtherBillPlan;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillPlanFactory;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OtherBillDataImport
extends AbstractDataTransmission {
    private static final Logger logger = CoreUIObject.getLogger(OtherBillDataImport.class);
    int[] SOURCE_BILL_TYPE = new int[]{0, 9, 10, 12, 14};
    private BigDecimal amountVal = null;
    private BigDecimal amountLocalVal = null;
    private BigDecimal exchangeRateVal = null;
    String[] DECIMAL_FIELDS = new String[]{"FExchangeRate", "FAmount", "FAmountLocal", "FVerifyAmount", "FVerifyAmountLocal", "FUnVerifyAmount", "FUnVerifyAmountLocal"};
    String[] DECIMAL_OBJS = new String[]{"exchangeRate", "amount", "amountLocal", "verifyAmount", "verifyAmountLocal", "unVerifyAmount", "unVerifyAmountLocal"};
    String[] DATE_FIELDS = new String[]{"FBillDate", "FCreateTime", "FLastUpdateTime", "FBizDate", "FAuditDate"};
    String[] DATE_OBJS = new String[]{"billDate", "createTime", "lastUpdateTime", "bizDate", "auditDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FHasEffected", "FFiVouchered", "FIsReversed", "FIsReverseBill"};
    String[] BOOLEAN_OBJS = new String[]{"hasEffected", "FiVouchered", "isReversed", "isReverseBill"};
    String[] STRING_FIELDS = new String[]{"FNumber", "FAsstActNumber", "FAsstActName", "FAbstractName"};
    String[] STRING_OBJS = new String[]{"number", "asstActNumber", "asstActName", "abstractName"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String value;
        Object o;
        int i;
        OtherBillInfo otherBillInfo = new OtherBillInfo();
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata != null) {
            str = numberdata.toString();
            if (!StringUtils.isEmpty((String)str)) {
                otherBillInfo.setNumber(str);
                try {
                    IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
                    OtherBillCollection collection = iOtherBill.getOtherBillCollection("where number ='" + str + "'");
                    if (collection != null && collection.size() > 0) {
                        otherBillInfo.setId(collection.get(0).getId());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        } else {
            throw new TaskExternalException("number  not found!!!!");
        }
        for (int i2 = 0; i2 < this.DECIMAL_FIELDS.length; ++i2) {
            try {
                String s = (String)((DataToken)hsData.get((Object)this.DECIMAL_FIELDS[i2])).data;
                if (StringUtils.isEmpty((String)s)) continue;
                BigDecimal value2 = new BigDecimal(s);
                this.setCheckField(this.DECIMAL_FIELDS[i2], value2);
                if (value2 == null) continue;
                otherBillInfo.setBigDecimal(this.DECIMAL_OBJS[i2], value2);
                continue;
            }
            catch (Exception nex) {
                logger.error((Object)nex);
                throw new TaskExternalException("[" + this.DECIMAL_OBJS[i2] + "] format error, it must be a number!!!");
            }
        }
        DateFormat formater = DateFormat.getInstance();
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            Object objVal = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
            String sDate = (String)objVal;
            if (objVal == null || sDate.equals("")) continue;
            try {
                Date value3 = DateTimeUtils.parseDate((String)sDate, (String)"dd/MM/yyyy");
                otherBillInfo.setDate(this.DATE_OBJS[i], value3);
                continue;
            }
            catch (ParseException e) {
                throw new TaskExternalException("[" + this.DATE_FIELDS[i] + "] format error, it must be a date String of yyyy-MM-dd ");
            }
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
                otherBillInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue(value));
                continue;
            }
            catch (Exception nex) {
                logger.error((Object)nex);
                throw new TaskExternalException("[" + this.BOOLEAN_FIELDS[i] + "] format error, it must be Y or N!!!");
            }
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            otherBillInfo.setString(this.STRING_OBJS[i], value);
        }
        Object data = ((DataToken)hsData.get((Object)"FBillStatus")).data;
        String bizNameCode = (String)data;
        value = null;
        int iBizCode = -1;
        try {
            iBizCode = Integer.parseInt(bizNameCode);
            if (!this.checkBillStatus(iBizCode)) {
                throw new TaskExternalException("The BillStatus is wrong");
            }
            if (data != null && (value = data.toString()) != null) {
                otherBillInfo.setBillStatus(this.getBillStatus(value));
            }
        }
        catch (NumberFormatException ex) {
            throw new TaskExternalException("The BillStatus must be 1 or 2 or 3");
        }
        data = ((DataToken)hsData.get((Object)"FSourceBillType")).data;
        String tempBillType = bizNameCode = (String)data;
        try {
            iBizCode = Integer.parseInt(bizNameCode);
            if (!this.checkSourceBillType(Integer.parseInt(bizNameCode))) {
                throw new TaskExternalException("The SourceBillType is wrong");
            }
            otherBillInfo.setSourceBillType(this.getSourceBillType(value));
        }
        catch (NumberFormatException ex) {
            throw new TaskExternalException("The SourceBillType is wrong!");
        }
        data = ((DataToken)hsData.get((Object)"FBillType")).data;
        bizNameCode = (String)data;
        try {
            iBizCode = Integer.parseInt(bizNameCode);
            if (!this.checkBillType(Integer.parseInt(bizNameCode), Integer.parseInt(tempBillType))) {
                throw new TaskExternalException("The BillType is wrong");
            }
            otherBillInfo.setBillType(this.getBillType(iBizCode));
        }
        catch (NumberFormatException ex) {
            throw new TaskExternalException("The BillType must be 1 or 2");
        }
        try {
            SettlementTypeInfo info;
            SettlementTypeCollection collection;
            FilterInfo filter;
            EntityViewInfo viewInfo;
            CurrencyInfo info2;
            ICurrency icurreny;
            CurrencyCollection collection2;
            CtrlUnitInfo cuinfo;
            ICtrlUnit ictrlUnit;
            CtrlUnitCollection cuCollection;
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = null;
            data = ((DataToken)hsData.get((Object)"FCreatorID")).data;
            if (data != null) {
                str = data.toString();
                userInfo = this.getUserFromNumber(iuser, str);
                if (userInfo != null) {
                    otherBillInfo.setCreator(userInfo);
                }
            } else {
                userInfo = SysContext.getSysContext().getCurrentUserInfo();
                otherBillInfo.setCreator(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FLastUpdateUserID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                otherBillInfo.setLastUpdateUser(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FControlUnitID")).data) != null && (str = ((DataToken)hsData.get((Object)"FControlUnitID")).data.toString()) != null && str.length() > 0 && (cuCollection = (ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx)).getCtrlUnitCollection("where number='" + str + "'")) != null && cuCollection.size() > 0 && (cuinfo = cuCollection.get(0)) != null) {
                otherBillInfo.setCU(cuinfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FHandlerID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                otherBillInfo.setHandler(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FAuditorID")).data) != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                otherBillInfo.setAuditor(userInfo);
            }
            if ((data = ((DataToken)hsData.get((Object)"FCurrencyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection2 = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where number='" + str + "'")) != null && collection2.size() > 0 && (info2 = collection2.get(0)) != null) {
                otherBillInfo.setCurrency(info2);
            }
            if ((data = ((DataToken)hsData.get((Object)"FSettleTypeID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                ISettlementType isettlement = SettlementTypeFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = isettlement.getSettlementTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setSettleType(info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCompanyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                collection2 = icompanyOrg.getCompanyOrgUnitCollection("where number='" + str + "'");
                if (collection2 != null && collection2.size() > 0) {
                    info2 = collection2.get(0);
                    if (info2 != null) {
                        otherBillInfo.setCompany((CompanyOrgUnitInfo)info2);
                    }
                } else {
                    throw new TaskExternalException("The company is error!");
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FAdminOrgID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IAdminOrgUnit iadminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iadminOrg.getAdminOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setAdminOrgUnit((AdminOrgUnitInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FPurManID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iPerson.getPersonCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setPerson((PersonInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FPurOrgID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IPurchaseOrgUnit ipurOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = ipurOrg.getPurchaseOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setPurOrg((PurchaseOrgUnitInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FAccountantID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IUser iAccountant = UserFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iAccountant.getUserCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setAccountant((UserInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FAsstActTypeID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iAsstActType.getAsstActTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setAsstActType((AsstActTypeInfo)info);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FCashDiscountID")).data) != null && (str = data.toString()) != null && str.length() > 0) {
                ICashDiscount iCashDiscount = CashDiscountFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iCashDiscount.getCashDiscountCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    otherBillInfo.setCashDiscount((CashDiscountInfo)info);
                }
            }
            if (!this.checkAmtIsRight()) {
                throw new TaskExternalException("The amount ,amountLocal,exchangeRate relation is wrong!");
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return otherBillInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"22_OtherBillDataImport", (Locale)ctx.getLocale()));
        ICoreBase iOtherBill = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iOtherBill.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iOtherBill.addnew(coreBaseInfo);
                OtherBillInfo info = this.getBillInfo(coreBaseInfo.getString("number"), ctx);
                IOtherBillPlan otherBillPlan = OtherBillPlanFactory.getLocalInstance(ctx);
                OtherBillPlanInfo newOtherBillPlanInfo = new OtherBillPlanInfo();
                newOtherBillPlanInfo.setParent(info);
                newOtherBillPlanInfo.setSeq(1);
                newOtherBillPlanInfo.setRecievePayDate(info.getBillDate());
                newOtherBillPlanInfo.setRecievePayAmount(info.getAmount());
                newOtherBillPlanInfo.setRecievePayAmountLocal(info.getAmountLocal());
                newOtherBillPlanInfo.setVerifyAmount(new BigDecimal(0));
                newOtherBillPlanInfo.setVerifyAmountLocal(new BigDecimal(0));
                otherBillPlan.addnew((CoreBaseInfo)newOtherBillPlanInfo);
            } else {
                iOtherBill.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private OtherBillInfo getBillInfo(String billNum, Context ctx) throws TaskExternalException {
        OtherBillInfo info = null;
        String oql = null;
        oql = "where number = '" + billNum + "'";
        try {
            IOtherBill iBill = OtherBillFactory.getLocalInstance(ctx);
            info = iBill.getOtherBillInfo(oql);
            if (info == null) {
                throw new TaskExternalException("the bill num is not right.");
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("can not get the bill by the bill Number, becuase " + e.getMessage());
        }
        return info;
    }

    private boolean getBooleanValue(String sourceValue) {
        return !(sourceValue = sourceValue.trim()).equalsIgnoreCase("N") && !sourceValue.equalsIgnoreCase("NO") && !sourceValue.equalsIgnoreCase("0");
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private BillStatusEnum getBillStatus(String value) {
        BillStatusEnum retval = BillStatusEnum.AUDITED;
        if (value != null) {
            value = value.trim();
            List EnumList = BillStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                BillStatusEnum statusEnum = (BillStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(statusEnum.getValue());
                String enumName = statusEnum.getName();
                String enumAlias = statusEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = statusEnum;
                break;
            }
        }
        return retval;
    }

    private boolean checkBillStatus(int value) {
        return value == 1 || value == 2 || value == 3;
    }

    private boolean checkSourceBillType(int value) {
        boolean ret = false;
        int count = this.SOURCE_BILL_TYPE.length;
        for (int i = 0; i < count; ++i) {
            if (value != this.SOURCE_BILL_TYPE[i]) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean checkBillType(int value, int sourceBillType) {
        boolean ret = false;
        if (value != 1 && value != 2) {
            return false;
        }
        ret = sourceBillType == 9 ? value == 1 : true;
        return ret;
    }

    private VerificateBillTypeEnum getSourceBillType(String value) {
        VerificateBillTypeEnum retval = VerificateBillTypeEnum.OtherPaymentBill;
        if (value != null) {
            value = value.trim();
            List EnumList = VerificateBillTypeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                VerificateBillTypeEnum billTypeEnum = (VerificateBillTypeEnum)EnumList.get(i);
                String enumValue = String.valueOf(billTypeEnum.getValue());
                String enumName = billTypeEnum.getName();
                String enumAlias = billTypeEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                retval = billTypeEnum;
                break;
            }
        }
        return retval;
    }

    private OtherBillType getBillType(int iBizCode) throws TaskExternalException {
        OtherBillType billTypeEnum = null;
        switch (iBizCode) {
            case 1: {
                billTypeEnum = OtherBillType.OtherPay;
                break;
            }
            case 2: {
                billTypeEnum = OtherBillType.InvoiceBill;
                break;
            }
            case 3: {
                billTypeEnum = OtherBillType.ExpenseInvoice;
            }
        }
        if (billTypeEnum == null) {
            throw new TaskExternalException("The billType must be 1 or 2!");
        }
        return billTypeEnum;
    }

    private boolean checkAmtIsRight() throws TaskExternalException {
        boolean ret = true;
        if (this.amountVal.multiply(this.exchangeRateVal).compareTo(this.amountLocalVal) != 0) {
            ret = false;
        }
        return ret;
    }

    private void setCheckField(String fieldName, BigDecimal value) throws TaskExternalException {
        if (fieldName.equalsIgnoreCase("FAmount")) {
            this.amountVal = value;
        } else if (fieldName.equalsIgnoreCase("FAmountLocal")) {
            this.amountLocalVal = value;
        } else if (fieldName.equalsIgnoreCase("FExchangeRate")) {
            this.exchangeRateVal = value;
        }
    }
}

