/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.PayPlanRptParam;
import com.kingdee.eas.fi.ap.app.AbstractPayPlanRptFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class PayPlanRptFacadeControllerBean
extends AbstractPayPlanRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.PayPlanRptFacadeControllerBean");
    public static final String CR = "\r\n";

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException {
        TempTableUtil.releasTempTable(ctx, tableName);
    }

    @Override
    protected PayPlanRptParam _querySummaryRpt(Context ctx, PayPlanRptParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        boolean isNewQuery = param.isNewQuery();
        PayPlanRptParam resultParam = null;
        if (isNewQuery || StringUtils.isEmpty((String)tempTable)) {
            if (!StringUtils.isEmpty((String)tempTable)) {
                this._releaseTempTable(ctx, tempTable);
            }
            tempTable = this.createTempTable(ctx, param);
            resultParam = this.getSummaryRptData(ctx, tempTable);
        } else {
            resultParam = this.queryRptData(ctx, param);
            resultParam.setTotalRowCount(param.getTotalRowCount());
        }
        return resultParam;
    }

    private PayPlanRptParam getSummaryRptData(Context ctx, String tempTable) throws BOSException {
        StringBuffer sb = null;
        String tempTable1 = null;
        TreeSet<String> dateColumnSet = new TreeSet<String>();
        HashMap<String, SummaryRptSqlParamsBuilder> sqlBuilderMap = new HashMap<String, SummaryRptSqlParamsBuilder>();
        HashMap<String, Object[]> leftColumnValues = new HashMap<String, Object[]>();
        sb = new StringBuffer();
        sb.append("SELECT currencyNumber, companyNumber, currencyName, companyName, fPrecision");
        sb.append(", recievePayDate, SUM(unVerifyAmount) unVerifyAmount");
        sb.append(", currencyId, companyId, newbosid('88888888') FID");
        sb.append(" FROM ").append(tempTable);
        sb.append(" WHERE unVerifyAmount != 0");
        sb.append(" GROUP BY currencyNumber, companyNumber, currencyName, companyName, fPrecision");
        sb.append(", recievePayDate, currencyId, companyId");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String recievePayDate = rs.getString("recievePayDate");
                dateColumnSet.add(recievePayDate);
                String currencyId = rs.getString("currencyId");
                String companyId = rs.getString("companyId");
                String key = currencyId + "-" + companyId;
                SummaryRptSqlParamsBuilder builder = null;
                if (!sqlBuilderMap.containsKey(key)) {
                    builder = new SummaryRptSqlParamsBuilder();
                    sqlBuilderMap.put(key, builder);
                    leftColumnValues.put(key, new Object[]{rs.getString("currencyName"), rs.getString("companyName"), rs.getString("currencyNumber"), rs.getString("companyNumber"), currencyId, companyId, rs.getInt("fPrecision"), rs.getString("FID")});
                } else {
                    builder = (SummaryRptSqlParamsBuilder)sqlBuilderMap.get(key);
                }
                builder.add(recievePayDate, rs.getBigDecimal("unVerifyAmount"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList dateColumnList = new ArrayList(dateColumnSet);
        int dateColumnCount = dateColumnList.size();
        sb = new StringBuffer();
        sb.append("(").append(CR);
        sb.append("FID varchar(44) PRIMARY KEY").append(CR);
        for (int i = 0; i < dateColumnCount; ++i) {
            sb.append(",F").append(dateColumnList.get(i).toString().replace("-", ""));
            sb.append(" NUMERIC(17,4)").append(CR);
        }
        sb.append(",currencyName VARCHAR(255)").append(CR);
        sb.append(",companyName VARCHAR(255)").append(CR);
        sb.append(",currencyNumber VARCHAR(80)").append(CR);
        sb.append(",companyNumber VARCHAR(80)").append(CR);
        sb.append(",currencyId VARCHAR(44)").append(CR);
        sb.append(",companyId VARCHAR(44)").append(CR);
        sb.append(",fPrecision int").append(CR);
        sb.append(",rowSummary NUMERIC(17,4)").append(CR);
        sb.append(",isSummaryRow int").append(CR);
        sb.append(")");
        tempTable1 = TempTableUtil.createTempTable(ctx, sb.toString());
        sb = new StringBuffer();
        StringBuffer valueSb = new StringBuffer();
        sb.append("INSERT INTO ").append(tempTable1).append(" (");
        for (int i = 0; i < dateColumnCount; ++i) {
            sb.append("F").append(dateColumnList.get(i).toString().replace("-", "")).append(", ");
            valueSb.append("?").append(", ");
        }
        sb.append("currencyName, companyName, currencyNumber, companyNumber, currencyId, companyId, fPrecision, FID, isSummaryRow) VALUES (");
        sb.append(valueSb).append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Set entrySet = sqlBuilderMap.entrySet();
        for (Map.Entry entry : entrySet) {
            SummaryRptSqlParamsBuilder builder = (SummaryRptSqlParamsBuilder)entry.getValue();
            Object[] leftValues = (Object[])leftColumnValues.get(entry.getKey());
            Object[] params = builder.buildParams(dateColumnList, leftValues.length + 1);
            for (Object params[dateColumnCount + i] : leftValues) {
            }
            params[dateColumnCount + leftValues.length] = 0;
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sb.toString(), paramsList);
        sb = new StringBuffer();
        sb.append("UPDATE ").append(tempTable1).append(" SET rowSummary = ");
        if (dateColumnCount > 0) {
            for (int i = 0; i < dateColumnCount; ++i) {
                if (i > 0) {
                    sb.append(" + ");
                }
                sb.append("F").append(dateColumnList.get(i).toString().replace("-", ""));
            }
        } else {
            sb.append("0");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer();
        StringBuffer sumSb = new StringBuffer();
        sb.append("INSERT INTO ").append(tempTable1);
        sb.append(" (isSummaryRow, FID, currencyName, companyName, currencyNumber, companyNumber, fPrecision, ");
        for (int i = 0; i < dateColumnCount; ++i) {
            sb.append("F").append(dateColumnList.get(i).toString().replace("-", "")).append(", ");
            sumSb.append("SUM(F").append(dateColumnList.get(i).toString().replace("-", "")).append(")").append(", ");
        }
        sb.append("rowSummary) SELECT 1, newbosid('88888888') AS FID");
        sb.append(", currencyName, ").append(this.getResourceStr(ctx, "Total")).append(" , currencyNumber, companyNumber, fPrecision, ").append(sumSb).append("SUM(rowSummary) as rowSummary");
        sb.append(" FROM ").append(tempTable1);
        sb.append(" GROUP BY currencyName, companyName, currencyNumber, companyNumber, fPrecision");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        int totalRowCount = 0;
        rs = DbUtil.executeQuery((Context)ctx, (String)("select count(1) as count from " + tempTable1));
        try {
            while (rs.next()) {
                totalRowCount = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        PayPlanRptParam resultParam = new PayPlanRptParam();
        resultParam.setTempTable(tempTable1);
        resultParam.setDetailTempTable(tempTable);
        resultParam.setSummaryRpt(true);
        resultParam.setDateColumnList(dateColumnList);
        resultParam.setTotalRowCount(totalRowCount);
        return resultParam;
    }

    @Override
    protected PayPlanRptParam _queryDetailRpt(Context ctx, PayPlanRptParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        boolean isNewQuery = param.isNewQuery();
        if (isNewQuery || StringUtils.isEmpty((String)tempTable)) {
            if (!StringUtils.isEmpty((String)tempTable)) {
                this._releaseTempTable(ctx, tempTable);
            }
            tempTable = this.createTempTable(ctx, param);
            param.setTempTable(tempTable);
        }
        PayPlanRptParam result = this.queryRptData(ctx, param);
        int totalRowCount = 0;
        if (param.isNewQuery()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(1) as count from " + tempTable));
            try {
                while (rs.next()) {
                    totalRowCount = rs.getInt("count");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            result.setTotalRowCount(totalRowCount);
        } else {
            result.setTotalRowCount(param.getTotalRowCount());
        }
        return result;
    }

    private PayPlanRptParam queryRptData(Context ctx, PayPlanRptParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        int startIndex = param.getStartIndex();
        int endIndex = param.getEndIndex();
        boolean isSummaryRpt = param.isSummaryRpt();
        StringBuffer sb = new StringBuffer();
        String selectFields = "*";
        sb.append("SELECT ");
        sb.append(selectFields).append(" FROM ").append(tempTable);
        sb.append(" ORDER BY currencyNumber, companyNumber");
        if (!isSummaryRpt) {
            if (param.getSummaryType() == PayPlanRptParam.SUMMARY_BY_ASSTACT) {
                sb.append(", asstActNumber");
            }
            sb.append(", recievePayDate, billNumber");
        }
        sb.append(", isSummaryRow");
        IRowSet rs = null;
        rs = startIndex >= 0 && endIndex >= 0 ? DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (int)(startIndex - 1), (int)(endIndex - startIndex + 1)) : DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        PayPlanRptParam result = new PayPlanRptParam();
        result.setTempTable(tempTable);
        result.setStartIndex(startIndex);
        result.setEndIndex(endIndex);
        result.setRs(rs);
        return result;
    }

    private String createTempTable(Context ctx, PayPlanRptParam param) throws BOSException, EASBizException {
        SimpleDateFormat df;
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(" FID varchar(44) PRIMARY KEY").append(",companyNumber nvarchar(80)").append(",currencyNumber nvarchar(80)").append(",asstActNumber nvarchar(80)").append(",recievePayDate varchar(20)").append(",billType nvarchar(255)").append(",voucherTypeName nvarchar(255)").append(",voucherNumber nvarchar(80)").append(",recievePayAmount NUMERIC(17,4)").append(",verifyAmount NUMERIC(17,4)").append(",unVerifyAmount NUMERIC(17,4)").append(",companyName nvarchar(255)").append(",currencyName nvarchar(255)").append(",companyId varchar(44)").append(",currencyId varchar(44)").append(",fPrecision int").append(",asstActName nvarchar(255)").append(",isSummaryRow int").append(",billNumber nvarchar(80)").append(",billId varchar(44)");
        sb.append(")");
        String tempTable = TempTableUtil.createTempTable(ctx, sb.toString());
        String asstActTypeId = param.getCussTypeId();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("realtionDataObject");
        AsstActTypeInfo cussTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeId), sic);
        CSSPGroupInfo cSSPGroupInfo = null;
        boolean isJoinQuery = false;
        sb = new StringBuffer();
        Locale loc = ctx.getLocale();
        sb.append("INSERT INTO ").append(tempTable);
        sb.append("(FID, companyNumber, currencyNumber, asstActNumber, recievePayDate, billType");
        sb.append(", voucherTypeName, voucherNumber, recievePayAmount, verifyAmount, unVerifyAmount, ");
        sb.append("companyName, currencyName, companyId, currencyId,fPrecision,asstActName, isSummaryRow, billNumber, billId)");
        sb.append(CR);
        if (param.getDetailTempTable() != null) {
            isJoinQuery = true;
            sb.append("SELECT ");
            sb.append("FID, companyNumber, currencyNumber, asstActNumber, recievePayDate, billType");
            sb.append(", voucherTypeName, voucherNumber, recievePayAmount, verifyAmount, unVerifyAmount, ");
            sb.append("companyName, currencyName, companyId, currencyId,fPrecision,asstActName, isSummaryRow, billNumber, billID");
            sb.append(" FROM ").append(param.getDetailTempTable()).append(CR);
        } else {
            sb.append("SELECT ");
            sb.append(" newbosid('88888888') FID, ");
            sb.append(" company.fNumber").append(" AS companyNumber,").append(CR);
            sb.append(" currency.fNumber").append(" AS currencyNumber,").append(CR);
            sb.append(" asstAct.fNumber").append(" AS asstActNumber,").append(CR);
            sb.append(" to_char(payPlan.fRecievePayDate, 'yyyy-MM-dd')").append(" AS recievePayDate,").append(CR);
            sb.append(" CASE head.fBillType");
            sb.append(" WHEN 201 THEN '").append(OtherBillType.OtherPay.getAlias()).append("'").append(CR);
            sb.append(" WHEN 202 THEN '").append(OtherBillType.InvoiceBill.getAlias()).append("'").append(CR);
            sb.append(" WHEN 203 THEN '").append(OtherBillType.ExpenseInvoice.getAlias()).append("'").append(CR);
            sb.append(" WHEN 204 THEN '").append(OtherBillType.DebitAdjust.getAlias()).append("'").append(CR);
            sb.append(" END AS billType,").append(CR);
            sb.append(" voucherTypes.FName_").append(loc).append(" AS voucherTypeName,").append(CR);
            sb.append(" head.fVoucherNumber").append(" AS voucherNumber,").append(CR);
            sb.append(" payPlan.FRecievePayAmount AS recievePayAmount,").append(CR);
            sb.append(" payPlan.FVerifyAmount AS verifyAmount,").append(CR);
            sb.append(" (payPlan.FRecievePayAmount - payPlan.FVerifyAmount) AS unVerifyAmount,").append(CR);
            sb.append(" company.fName_").append(loc).append(" AS companyName,").append(CR);
            sb.append(" currency.fName_").append(loc).append(" AS currencyName,").append(CR);
            sb.append(" company.fid AS companyId,").append(CR);
            sb.append(" currency.fid AS currencyId,").append(CR);
            sb.append(" currency.fPrecision AS fPrecision,").append(CR);
            sb.append(" asstAct.fName_").append(loc).append(" AS asstActName,").append(CR);
            sb.append(" 0 AS isSummaryRow,").append(CR);
            sb.append(" head.fNumber AS billNumber,").append(CR);
            sb.append(" head.fid AS billId").append(CR);
            sb.append(" FROM T_AP_OtherBillPlan payPlan");
            sb.append(" INNER JOIN T_AP_OtherBill head ON payPlan.fParentId = head.fid").append(CR);
            sb.append(" INNER JOIN T_ORG_Company company ON head.fCompanyId = company.fid").append(CR);
            sb.append(" INNER JOIN T_BD_Currency currency ON head.fCurrencyId = currency.fid").append(CR);
            sb.append(" INNER JOIN T_BD_AsstActType asstActType ON head.fAsstActTypeId = asstActType.fid").append(CR);
            String asstActTable = cussTypeInfo.getRealtionDataObject();
            sb.append(" INNER JOIN ").append(asstActTable).append(" asstAct ON head.fAsstActID = asstAct.fid").append(CR);
            if (param.getCsspGrpId() != null && ("t_bd_supplier".equalsIgnoreCase(asstActTable) || "t_bd_customer".equalsIgnoreCase(asstActTable))) {
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("groupStandard.id");
                cSSPGroupInfo = CSSPGroupFactory.getLocalInstance((Context)ctx).getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(param.getCsspGrpId()), sic);
                if (cSSPGroupInfo != null) {
                    sb.append(" INNER JOIN T_BD_CSSPGroup asstActGroup ON asstActGroup.fid = asstAct.FBrowseGroupID").append(CR);
                }
            }
            sb.append(" LEFT OUTER JOIN T_BD_VoucherTypes voucherTypes ON head.fVoucherTypeID = voucherTypes.fid").append(CR);
        }
        String companyIds = CollectionUtil.ids2SqlString(param.getCompanyIds());
        sb.append(" WHERE ").append(isJoinQuery ? "companyId" : "company.fid").append(" in (").append(companyIds).append(")").append(CR);
        if (param.getCurrencyIds() != null) {
            String currencyIds = CollectionUtil.ids2SqlString(param.getCurrencyIds());
            sb.append(" AND ").append(isJoinQuery ? "currencyId" : "currency.fid").append(" in (").append(currencyIds).append(")").append(CR);
        }
        if (isJoinQuery && param.getPayDateFrom() != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            sb.append(" AND recievePayDate = '").append(df.format(param.getPayDateFrom())).append("'").append(CR);
        }
        if (!isJoinQuery) {
            sb.append(" AND head.fPaymentTypeID = '2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5'").append(CR);
            df = new SimpleDateFormat("yyyy-MM-dd");
            if (param.getPayDateFrom() != null) {
                sb.append(" AND payPlan.fRecievePayDate >= {d'").append(df.format(param.getPayDateFrom())).append("'}").append(CR);
            }
            Date dateTo = param.getPayDateTo();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateTo);
            calendar.add(5, 1);
            dateTo = calendar.getTime();
            sb.append(" AND payPlan.fRecievePayDate < {d'").append(df.format(dateTo)).append("'}").append(CR);
            sb.append(" AND head.fAsstActTypeId = '").append(asstActTypeId).append("'").append(CR);
            if (cSSPGroupInfo != null) {
                sb.append(" AND asstActGroup.fid = '").append(cSSPGroupInfo.getId().toString()).append("'").append(CR);
                if (cSSPGroupInfo.getGroupStandard() != null) {
                    sb.append(" AND asstActGroup.FCSSPGroupStandardID = '").append(cSSPGroupInfo.getGroupStandard().getId().toString()).append("'").append(CR);
                }
            }
            if (param.getCussAcctFromIds() != null) {
                String asstActIds = CollectionUtil.ids2SqlString(param.getCussAcctFromIds());
                sb.append(" AND asstAct.fid in (").append(asstActIds).append(")").append(CR);
            } else {
                if (param.getCussAcctFromNum() != null) {
                    sb.append(" AND asstAct.fNumber >= '").append(param.getCussAcctFromNum()).append("'").append(CR);
                }
                if (param.getCussAcctToNum() != null) {
                    sb.append(" AND asstAct.fNumber <= '").append(param.getCussAcctToNum()).append("'").append(CR);
                }
            }
            if (param.getBizeIndex() == 1) {
                sb.append(" AND head.fIsBizBill = 0").append(CR);
            } else if (param.getBizeIndex() == 2) {
                sb.append(" AND head.fIsBizBill = 1").append(CR);
            }
        }
        DbUtil.execute((Context)ctx, (String)sb.toString());
        if (!param.isSummaryRpt()) {
            sb = new StringBuffer();
            sb.append("INSERT INTO ").append(tempTable);
            sb.append(" (FID, currencyNumber, companyNumber, currencyName, companyName,fPrecision");
            if (param.getSummaryType() == PayPlanRptParam.SUMMARY_BY_PAYDATE) {
                sb.append(", recievePayDate");
            } else {
                sb.append(", asstActNumber, asstActName");
            }
            sb.append(", recievePayAmount, verifyAmount, unVerifyAmount, isSummaryRow, billNumber)").append(CR);
            sb.append(" SELECT newbosid('88888888'), currencyNumber, companyNumber, currencyName, companyName, fPrecision");
            if (param.getSummaryType() == PayPlanRptParam.SUMMARY_BY_PAYDATE) {
                sb.append(", recievePayDate").append(CR);
            } else {
                sb.append(", asstActNumber, asstActName").append(CR);
            }
            sb.append(", SUM(recievePayAmount) AS recievePayAmount").append(CR);
            sb.append(", SUM(verifyAmount) AS verifyAmount").append(CR);
            sb.append(", SUM(unVerifyAmount) AS unVerifyAmount").append(CR);
            sb.append(", 1 AS isSummaryRow").append(CR);
            sb.append(", ").append(this.getResourceStr(ctx, "Total")).append(" AS billNumber").append(CR);
            sb.append(" FROM ").append(tempTable);
            sb.append(" GROUP BY companyNumber, currencyNumber, currencyName, companyName, fPrecision");
            if (param.getSummaryType() == PayPlanRptParam.SUMMARY_BY_PAYDATE) {
                sb.append(", recievePayDate").append(CR);
            } else {
                sb.append(", asstActNumber, asstActName").append(CR);
            }
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return tempTable;
    }

    private String getResourceStr(Context ctx, String key) {
        String resClassName = "com.kingdee.eas.fi.ap.ApAllResource";
        return EASResource.getString((String)resClassName, (String)key, (Locale)ctx.getOriginLocale());
    }

    private class SummaryRptSqlParamsBuilder {
        Map keyValue = new HashMap();

        private SummaryRptSqlParamsBuilder() {
        }

        void add(String dateColumnName, BigDecimal unVerifyAmount) {
            this.keyValue.put(dateColumnName, unVerifyAmount);
        }

        Object[] buildParams(List dateColumnList, int leftCount) {
            Object[] params = new Object[dateColumnList.size() + leftCount];
            int len = dateColumnList.size();
            for (int i = 0; i < len; ++i) {
                params[i] = BigDecimal.ZERO;
            }
            Set entrySet = this.keyValue.entrySet();
            for (Map.Entry entry : entrySet) {
                int index = dateColumnList.indexOf(entry.getKey());
                params[index] = entry.getValue();
            }
            return params;
        }
    }
}

