/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.ApBalanceFacadeFactory;
import com.kingdee.eas.fi.ap.IApBalanceFacade;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.IPayRequestSumEntry;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.ap.PaymentBillBizException;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApPeriodHelper;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.PaymentBillDataProcess;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.PaySubmitService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class ApPaySubmitService
extends PaySubmitService {
    private static final String AR_RESOURCE = "com.kingdee.eas.fi.ar.ARResources";
    private static final String AP_RESOURCE = "com.kingdee.eas.fi.ap.ApResource";
    private static final String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";
    private ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private ArApServiceHandler arapServiceHandler = new ArApServiceHandler();
    private boolean isHasValue = false;
    private final String PAYYREQ_BILL_BOSTYPE = "D001019A";
    private final String APOTHER_BILL_BOSTYPE = "48DA3A71";

    public void beforeSubmit() throws EASBizException, BOSException {
        int i;
        boolean isAudit;
        boolean valSettle;
        PeriodInfo period;
        if (this.info.isIsInitializeBill()) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()), "fi_ap_InitPayBill_batchSubmit");
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        boolean isSubmit = false;
        if (this.info.getBillStatus() == BillStatusEnum.SUBMIT) {
            isSubmit = true;
        }
        if (this.info.get("isEmergency") == null) {
            this.info.setIsEmergency(IsMergencyEnum.normal);
        }
        super.beforeSubmit();
        if (this.info.getSourceSysType() == null) {
            this.info.setSourceSysType(SourceTypeEnum.AP);
        }
        if (this.info.getSourceType() == null) {
            this.info.setSourceType(this.info.getSourceSysType());
        }
        this.checkSportCBPay();
        if (this.info.getEntries() == null || this.info.getEntries().size() == 0) {
            this.throwSubmitExcetion(this.ctx, "Condition_HeadEntries");
        }
        if ((period = this.arapServiceHandler.checkSystemIfStart(this.ctx, SystemEnum.ACCOUNTSPAYABLE, this.info.getCompany())) == null) {
            throw new RecPayException(RecPayException.AP_SYSTEM_NO_PERIOD);
        }
        this.arapHelper.verifyAccountView(this.ctx, this.info.getPayerAccount(), this.info.getCurrency(), this.info.getCompany());
        String companyId = this.info.getCompany().getId().toString();
        ArApServerUtils.commonBugdetCheck(this.ctx, companyId, (IObjectValue)this.info);
        RecPayServiceUtil.verifyPayerAccount(this.info.getPayerAccountBank(), this.info.getCurrency(), this.info.getPayerAccount(), this.info.getPayBillType());
        if (this.info.isIsInitializeBill() && this.info.isAssoGen() && RecPayHelper.SRC_AP_BOSTYPE.equals((Object)this.arapServiceHandler.getSrcBillBOSType(this.info))) {
            throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)AR_RESOURCE, (String)"204_ApPaySubmitService", (Locale)this.ctx.getLocale())});
        }
        if (this.info.getEntries() != null && this.info.getEntries().get(0) != null && this.info.getEntries().get(0).getContractNum() != null) {
            this.info.setContractNum(this.info.getEntries().get(0).getContractNum());
        }
        this.arapServiceHandler.checkBizDate(this.info);
        this.arapServiceHandler.checkPayeeForPayment(this.ctx, this.info);
        this.arapHelper.checkPayeeForPayment(this.ctx, this.info);
        if (this.info.isIsDiffCurSettlement()) {
            RecPayServiceUtil.reverseOtherBillLock(this.ctx, (RecPayBillInfo)this.info, false, BOTBillOperStateEnum.EDIT);
        } else {
            RecPayServiceUtil.reversePayAmountFields(this.ctx, this.info, BatchActionEnum.SUBMIT);
        }
        RecPayServiceUtil.reverseRecPayLockAmt(this.ctx, (RecPayBillInfo)this.info, false);
        ApServerUtils.lockPaymentBill(this.ctx, this.info);
        this.serviceHandler.checkIsInQueue(this.ctx, this.info);
        if (this.info.getCU() == null && this.info.getCompany().getCU() != null) {
            this.info.setCU(this.info.getCompany().getCU());
        }
        if (this.isAddNew) {
            FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"sourceType");
        }
        this.arapServiceHandler.checkNumber(this.ctx, (RecPayBillInfo)this.info);
        this.checkPayInfo(this.ctx, this.info);
        if (this.info.isIsTransBill() && this.info.isIsTransOtherBill()) {
            this.arapServiceHandler.reverseTransOtherBill(this.ctx, this.info, true);
            this.info.setBillStatus(BillStatusEnum.PAYED);
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
            this.info.setAuditDate(new Date());
            this.info.setPayDate(new Date());
            this.info.setAuditor(userInfo);
            this.info.setCashier(userInfo);
        }
        PaymentBillDataProcess.setAmountProp((Context)this.ctx, (PaymentBillInfo)this.info);
        if (ZERO.compareTo(this.info.getAmount()) == 0) {
            throw new ArApRecPayException(ArApRecPayException.PAY_AMTNOTZERO);
        }
        if (this.info.getPayBillType() != null) {
            Integer payType = null;
            if (this.info.getPayBillType().isIsPreSet()) {
                payType = Integer.valueOf(this.info.getPayBillType().getNumber());
            } else if (this.info.getPayBillType().getPreSetBillType() != null) {
                PaymentBillTypeInfo prePayType = PaymentBillTypeFactory.getLocalInstance((Context)this.ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(this.info.getPayBillType().getPreSetBillType().getId()));
                payType = new Integer(prePayType.getNumber());
            }
            boolean blueFlag = this.arapHelper.checkIsDefaultBlueBillType(payType);
            boolean redFlag = this.arapHelper.checkIsDefaultRedBillType(payType);
            int sign = this.info.getAmount().signum();
            if (blueFlag && sign == -1 || redFlag && sign == 1) {
                throw new ArApRecPayException(ArApRecPayException.PAY_TYPEAMTNOTMATCH);
            }
        }
        String asstActId = null;
        if (this.info.getPayeeID() != null) {
            asstActId = this.info.getPayeeID();
        }
        boolean bl = valSettle = !this.info.isIsInitializeBill() && this.param.get("CS027") != null && "true".equalsIgnoreCase(this.param.get("CS027").toString());
        if (valSettle && EmptyUtil.isEmpty((CoreBaseInfo)this.info.getSettlementType())) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"SettleTypeNotEmpty");
            throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
        }
        boolean isPAYBILL_PurPayAmtOverAmt = false;
        if (this.param.get("PAYBILL_PurPayAmtOverAmt") != null && ("true".equalsIgnoreCase(this.param.get("PAYBILL_PurPayAmtOverAmt").toString()) || "1".equalsIgnoreCase(this.param.get("PAYBILL_PurPayAmtOverAmt").toString()))) {
            isPAYBILL_PurPayAmtOverAmt = true;
        }
        PaymentBillTypeInfo billType = this.info.getPayBillType();
        RecPayHelper handler = new RecPayHelper();
        AccountViewInfo acct = this.info.getOppAccount();
        if (acct != null && !billType.isIsFinanceTranUp()) {
            if (acct.getId() != null) {
                acct = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acct.getId().toString()));
            }
            if (acct.isIsBank()) {
                String bankAccountNumber;
                if (EmptyUtil.isEmpty((String)this.info.getPayeeAccountBank())) {
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayeeAccountBankCanNotBeNull", (Locale)this.ctx.getLocale());
                    throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
                }
                String companyNumber = this.info.getCompany().getId().toString();
                if (!handler.getBankAccountNumberBelong(this.ctx, companyNumber, bankAccountNumber = this.info.getPayeeAccountBank())) {
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayeeAccountBankCanNotExist", (Locale)this.ctx.getLocale());
                    throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
                }
                String accountId = this.info.getOppAccount().getId().toString();
                if (!handler.getAccountBelong(this.ctx, companyId, accountId, bankAccountNumber)) {
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"RelAcctViewNotEqualOppAcctView", (Locale)this.ctx.getLocale());
                    throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
                }
            }
        }
        if (this.info.getPayBillType() != null && !this.isPreBillType() && ("NLGLdwEREADgAAHcwKgSRj6TKVs=".equals(this.info.getPayBillType().getId().toString()) || this.info.getPayBillType().isIsPurPay()) && !isPAYBILL_PurPayAmtOverAmt) {
            CurrencyInfo cur = this.info.getCurrency();
            int precision = 2;
            if (cur != null) {
                precision = cur.getPrecision();
            }
            IApBalanceFacade iApBalance = ApBalanceFacadeFactory.getLocalInstance((Context)this.ctx);
            HashMap apMap = iApBalance.getApBalance((IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()), (IObjectPK)new ObjectUuidPK(asstActId));
            Object balance = apMap.get("Balance");
            BigDecimal apBal = ZERO;
            if (balance instanceof BigDecimal) {
                apBal = (BigDecimal)balance;
            }
            if (this.info.getLocalAmt() != null && this.info.getLocalAmt().compareTo(apBal) > 0) {
                throw new ArApRecPayException(ArApRecPayException.PURPAYAMTOVERAMT, new Object[]{apBal.setScale(precision, 4).toString(), this.info.getLocalAmt().subtract(apBal).setScale(precision, 4).toString()});
            }
        }
        this.checkPayAmtForPayRequestBill(this.ctx, this.info);
        if (isSubmit && this.info.isIsInitializeBill() && !this.isHasValue) {
            this.writeBackInitBill(true);
        }
        if (this.info.get("id") != null && PaymentBillFactory.getLocalInstance((Context)this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.get("id").toString())) && (isAudit = PaymentBillFactory.getLocalInstance((Context)this.ctx).exists("where billStatus>=12 and id = '" + this.info.get("id").toString() + "'"))) {
            throw new CasForArApException(CasForArApException.BILLISAUDITED);
        }
        for (i = 0; i < this.info.getEntries().size(); ++i) {
            if (this.info.getEntries().get(i).getId() != null) continue;
            this.info.getEntries().get(i).setId(BOSUuid.create((BOSObjectType)this.info.getEntries().get(i).getBOSType()));
        }
        for (i = 0; i < this.info.getAssItems().size(); ++i) {
            if (this.info.getAssItems().get(i).getId() != null) continue;
            this.info.getAssItems().get(i).setId(BOSUuid.create((BOSObjectType)this.info.getAssItems().get(i).getBOSType()));
        }
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> sourceIDSet = new HashSet<String>();
        String tableName = "T_CAS_PaymentBillEntry";
        int size = this.info.getEntries().size();
        for (int i2 = 0; i2 < size; ++i2) {
            String sourceBillID = this.info.getEntries().get(i2).getSourceBillId();
            ids.add(this.info.getEntries().get(i2).getId().toString());
            if (StringUtil.isEmpty((String)sourceBillID)) continue;
            sourceIDSet.add(sourceBillID);
        }
        if (sourceIDSet.size() > 0) {
            PaymentBillInfo oldModel = null;
            if (this.info.get("id") != null) {
                String id = this.info.get("id").toString();
                try {
                    oldModel = (PaymentBillInfo)PaymentBillFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(id));
                }
                catch (Exception e) {
                    oldModel = null;
                }
            }
            if (ArApRecPayServerHelper.isExistsBizFlowField((Context)this.ctx, (String)tableName) && ArApRecPayServerHelper.isHasBizFlowValue((Context)this.ctx, (String)tableName, ids)) {
                this.isHasValue = true;
            }
            if (this.isHasValue) {
                if (oldModel != null && oldModel.getBillStatus().getValue() == 11) {
                    try {
                        BizBillValueChangeUtil.handleBillSubmit((Context)this.ctx, (IObjectValue)oldModel, (IObjectValue)this.info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArApRecPayServerHelper.doWriteBack((Context)this.ctx, (IObjectValue)this.info, (BatchActionEnum)BatchActionEnum.SUBMIT);
                if (oldModel != null && oldModel.getBillStatus().getValue() == 11) {
                    try {
                        BizBillValueChangeUtil.resetBillChange((Context)this.ctx, (IObjectValue)this.info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArApBillReverseHelper.reversePlanAmount(this.ctx, false, sourceIDSet);
            }
        }
        ArApBillUtil.checkAmtAndAmtLocalPrecision(this.ctx, (BillBaseInfo)this.info, this.info.getCurrency());
        ArApBillUtil.setDefaultValueZero(this.ctx, (BillBaseInfo)this.info);
    }

    private boolean isPreBillType() {
        boolean retValue = false;
        if (this.info != null && this.info.getPayBillType() != null && this.info.getPayBillType().getPreSetBillType() != null && this.info.getPayBillType().getPreSetBillType().getId() != null && this.info.getPayBillType().getPreSetBillType().getId().toString().equals("NLGLdwEREADgAAHjwKgSRj6TKVs=")) {
            retValue = true;
        }
        return retValue;
    }

    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        boolean needCheck;
        super.afterSubmit(pk);
        ArApRecPayServerHelper.injectBizFlow((Context)this.ctx, (IObjectValue)this.info, (BatchActionEnum)BatchActionEnum.SUBMIT);
        if (!this.info.isIsInitializeBill() && !this.info.isIsTransBill() && this.isAuditNow(this.ctx, this.info, this.param)) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(pk.toString());
            PaymentBillFactory.getLocalInstance((Context)this.ctx).audit(idSet);
        }
        if (this.info.isIsTransOtherBill() && SourceTypeEnum.AP.equals((Object)this.info.getSourceType())) {
            this.arapServiceHandler.writeBackOrderBill(this.ctx, this.info.getId().toString(), true, true);
        }
        if (this.info.isIsInitializeBill() && !this.isHasValue) {
            this.writeBackInitBill(false);
        }
        BOSUuid billId = this.info.getId();
        PaymentBillEntryCollection entryColl = this.info.getEntries();
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            String srcBillId = entryColl.get(i).getString("sourceBillId");
            if (StringUtils.isEmpty((String)srcBillId)) continue;
            srcIdSet.add(srcBillId);
        }
        String relation = this.info.getExtendedProperty("rebuildBOTRelation");
        try {
            if (!(this.info == null || billId == null || srcIdSet.isEmpty() || relation != null && Boolean.valueOf(relation).booleanValue())) {
                ArApServerUtils.createBotpRelation(this.ctx, srcIdSet, billId.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean bl = needCheck = this.param.get("AP_033") != null && "true".equalsIgnoreCase(this.param.get("AP_033").toString());
        if (needCheck) {
            this.checkAmtForRedBlueSourceBill(this.ctx, this.info);
        }
        ApServerUtils.checkCurrency(this.ctx, this.info);
        Boolean AP_037 = this.param.get("AP_037") != null && "true".equalsIgnoreCase(this.param.get("AP_037").toString());
        if (!AP_037.booleanValue()) {
            ApServerUtils.checkAmtForDiffCurrencyPay(this.ctx, this.info);
        }
    }

    private boolean isAuditNow(Context ctx, PaymentBillInfo info, HashMap param) throws BOSException {
        boolean isApRecBill = SourceTypeEnum.AP.equals((Object)info.getSourceType());
        boolean isAuditNow = false;
        if (param.get("PAYBILL_AUDIT_NOW") != null && ("true".equalsIgnoreCase(param.get("PAYBILL_AUDIT_NOW").toString()) || "1".equalsIgnoreCase(param.get("PAYBILL_AUDIT_NOW").toString()))) {
            isAuditNow = true;
        }
        return isApRecBill && isAuditNow && !info.isIsInitializeBill();
    }

    private void throwSubmitExcetion(Context ctx, String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)resourcePath, (String)messageItem, (Locale)ctx.getLocale())});
    }

    private void checkPayInfo(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        PaymentBillInfo currInfo;
        String resourcePath = resourcePath;
        String message = ResourceBase.getString((String)resourcePath, (String)"payBillTypeIsNull", (Locale)ctx.getLocale());
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        if (info.getId() != null && iPaymentBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString())) && !(currInfo = iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()))).getBillStatus().equals((Object)BillStatusEnum.SAVE) && !currInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
            throw new PaymentBillBizException(PaymentBillBizException.BILL_ISNOT_SAVEORSUBMIT);
        }
        if (info.getPayBillType() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{message});
        }
        if (info.getSourceType() != null && !info.getSourceType().equals((Object)info.getPayBillType().getSourceSysType())) {
            throw new RecPayException(RecPayException.PAYBILLTYPENOTMATCHSYSTYPE);
        }
        this.checkBizDate();
        if (info.isIsTransOtherBill()) {
            StringBuffer sb = new StringBuffer("");
            AbstractArApBillBaseInfo sourceBillInfo = null;
            if (info.getSourceBillId() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcBillIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            } else if (BOSObjectType.create((String)"FC910EF3").equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType())) {
                sourceBillInfo = OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo("SELECT adminOrgUnit, person WHERE id = '" + info.getSourceBillId() + "'");
            }
            if (sourceBillInfo != null && sourceBillInfo.getAdminOrgUnit() != null && info.getAdminOrgUnitId_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcOUIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (sourceBillInfo != null && sourceBillInfo.getPerson() != null && info.getPersonID_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcPersonIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (info.getAsstActTypeID_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcAsstActTypeIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (info.getAsstActID_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcAcctCussentIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (info.getBillDate_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcBillDateIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (sb.length() > 0) {
                throw new CasForArApException(CasForArApException.TRANSFAILED, new Object[]{sb.toString()});
            }
        }
        if (SourceTypeEnum.AP.equals((Object)info.getSourceType()) && info.isIsInitializeBill()) {
            BigDecimal verifyAmount = null;
            BigDecimal payAmount = null;
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                verifyAmount = info.getEntries().get(i).getAmountVc() == null ? SysConstant.BIGZERO : info.getEntries().get(i).getAmountVc();
                BigDecimal bigDecimal = payAmount = info.getEntries().get(i).getAmount() == null ? SysConstant.BIGZERO : info.getEntries().get(i).getAmount();
                if (verifyAmount.compareTo(SysConstant.BIGZERO) == 0 || payAmount.abs().compareTo(verifyAmount.abs()) > 0) continue;
                throw new CasForArApException(CasForArApException.VERIFYAMT_NO_MORETHAN_RECPAYAMOUNT);
            }
        }
    }

    protected ServiceHandler getServiceHandler() {
        return this.arapServiceHandler;
    }

    protected List getParamNumberList() {
        List list = super.getParamNumberList();
        list.add("PAYBILL_PurPayAmtOverAmt");
        list.add("PAYBILL_AUDIT_NOW");
        list.add("CS027");
        list.add("AP_033");
        list.add("AP_037");
        return list;
    }

    public void checkPayAmtForPayRequestBill(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (info.getEntries().size() == 0) {
            return;
        }
        String sourceBillId = info.getEntries().get(0).getSourceBillId();
        if (sourceBillId == null) {
            return;
        }
        if (!BOSObjectType.create((String)"D001019A").equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        SelectorItemCollection selector = ev.getSelector();
        selector.add("unpayAmount");
        PaymentBillEntryCollection infoCollection = info.getEntries();
        IPayRequestBillEntry ipayreqEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        IPayRequestSumEntry iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
        PayRequestBillEntryInfo sourcebillEntryInfo = null;
        PayRequestSumEntryInfo sourcebillSumEntryInfo = null;
        String sourceBillEntryId = null;
        BigDecimal payamount = BigDecimal.ZERO;
        BigDecimal sourceUnreqAmount = BigDecimal.ZERO;
        BigDecimal totalPayAmt = BigDecimal.ZERO;
        BigDecimal totalSrcUnreqAmount = BigDecimal.ZERO;
        for (int i = 0; i < infoCollection.size(); ++i) {
            PaymentBillEntryInfo entryInfo = infoCollection.get(i);
            sourceBillEntryId = entryInfo.getSourceBillEntryId();
            payamount = entryInfo.getAmount() == null ? ZERO : entryInfo.getAmount();
            totalPayAmt = totalPayAmt.add(payamount);
            if (ApServerUtils.isPayReqSumEntry(sourceBillEntryId)) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceBillEntryId, CompareType.EQUALS));
                sourcebillSumEntryInfo = iPayRequestSumEntry.getPayRequestSumEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryId));
                sourceUnreqAmount = sourcebillSumEntryInfo.getUnpayAmount() == null ? ZERO : sourcebillSumEntryInfo.getUnpayAmount();
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceBillEntryId, CompareType.EQUALS));
                sourcebillEntryInfo = ipayreqEntry.getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryId));
                sourceUnreqAmount = sourcebillEntryInfo.getUnpayAmount() == null ? ZERO : sourcebillEntryInfo.getUnpayAmount();
            }
            totalSrcUnreqAmount = totalSrcUnreqAmount.add(sourceUnreqAmount);
            Object[] msg = new String[]{"" + (i + 1), "" + payamount.abs(), "" + sourceUnreqAmount.abs()};
            if (payamount.abs().compareTo(sourceUnreqAmount.abs()) != 1) continue;
            throw new CasForArApException(CasForArApException.PAYAMOUNTLESSPAYREQAMOUNTL, msg);
        }
        if (totalPayAmt.abs().compareTo(totalSrcUnreqAmount.abs()) == 1) {
            throw new PaymentBillBizException(PaymentBillBizException.PAYAMOUNTLESSPAYREQAMOUNTL_BILL, new Object[]{totalPayAmt.abs(), totalSrcUnreqAmount.abs()});
        }
    }

    public void checkAmtForRedBlueSourceBill(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (info.getEntries().size() == 0) {
            return;
        }
        String sourceBillId = info.getEntries().get(0).getSourceBillId();
        if (sourceBillId == null) {
            return;
        }
        if (info.isIsDiffCurSettlement()) {
            return;
        }
        String srcEntryTable = "";
        String sumFieldName = "";
        String billName = "";
        String amountName = "";
        if (BOSObjectType.create((String)"D001019A").equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            srcEntryTable = "T_AP_PAYREQUESTBILLENTRY";
            sumFieldName = "entry.FUNPAYAMOUNT";
            billName = ResourceBase.getString((String)AP_RESOURCE, (String)"PayReqBill", (Locale)ctx.getLocale());
            amountName = ResourceBase.getString((String)AP_RESOURCE, (String)"UnPaidAmt", (Locale)ctx.getLocale());
        } else if (BOSObjectType.create((String)"48DA3A71").equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            srcEntryTable = "T_AP_OTHERBILLENTRY";
            sumFieldName = "entry.FUNVERIFYAMOUNT";
            billName = ResourceBase.getString((String)AP_RESOURCE, (String)"APBill", (Locale)ctx.getLocale());
            amountName = ResourceBase.getString((String)AP_RESOURCE, (String)"UnVerifyAmt", (Locale)ctx.getLocale());
        } else {
            return;
        }
        PaymentBillEntryCollection infoCollection = info.getEntries();
        PaymentBillEntryInfo entryInfo = null;
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < infoCollection.size(); ++i) {
            entryInfo = infoCollection.get(i);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillId())) continue;
            srcIdSet.add(entryInfo.getSourceBillId());
        }
        String payBillId = info.getId().toString();
        String sourceBillIds = ListUtil.transList2String(srcIdSet);
        StringBuilder sqlBuilder = new StringBuilder(500);
        sqlBuilder.append("SELECT * FROM (");
        sqlBuilder.append("\t\tSELECT entry.FPARENTID FID");
        sqlBuilder.append("\t\t\t,sum(").append(sumFieldName).append(") FAmount");
        sqlBuilder.append("\t\tFROM ").append(srcEntryTable).append(" entry");
        sqlBuilder.append("\t\tWHERE entry.FPARENTID IN ").append(sourceBillIds);
        sqlBuilder.append("\t\tGROUP BY entry.FPARENTID");
        sqlBuilder.append("\t\t) result1");
        sqlBuilder.append(" INNER JOIN (");
        sqlBuilder.append("\t\tSELECT entry.FSOURCEBILLID FID");
        sqlBuilder.append("\t\t\t,sum(entry.FAMOUNT) FAmount");
        sqlBuilder.append("\t\tFROM T_CAS_PAYMENTBILLENTRY entry");
        sqlBuilder.append("\t\tWHERE entry.FPAYMENTBILLID = '").append(payBillId).append("'");
        sqlBuilder.append("\t\tGROUP BY entry.FSOURCEBILLID");
        sqlBuilder.append("\t\t) result2 ON result1.FID = result2.FID");
        sqlBuilder.append("\tWHERE result1.FID IN ").append(sourceBillIds);
        sqlBuilder.append("\t\tAND abs(result2.FAmount) > abs(result1.Famount)");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        try {
            if (result.next()) {
                throw new PaymentBillBizException(PaymentBillBizException.PAYAMOUNTLESSPAYREQAMOUNTL_BILL, new Object[]{billName, amountName});
            }
        }
        catch (SQLException exc) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
    }

    private void writeBackInitBill(boolean isSubmited) throws BOSException {
        try {
            if (this.info != null && this.info.isIsInitializeBill()) {
                String[] disposerName = new String[]{"com.kingdee.eas.scm.sm.pur.PurOrderDisposer", "com.kingdee.eas.scm.sm.sc.SubContractOrderDisposer"};
                int size = disposerName.length;
                for (int i = 0; i < size; ++i) {
                    IPaymentDisposer disposer = (IPaymentDisposer)Class.forName(disposerName[i]).newInstance();
                    BillDisposerAction disposerAction = new BillDisposerAction();
                    disposerAction.setDestBill((CoreBaseInfo)this.info);
                    if (isSubmited) {
                        disposerAction.setActionType(DisposerActionEnum.CANCEL_PAY);
                    } else {
                        disposerAction.setActionType(DisposerActionEnum.PAY);
                    }
                    disposer.dispose(this.ctx, disposerAction);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkSportCBPay() throws ArApRecPayException {
        if (this.info.isIsCBPay()) {
            throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)resourcePath, (String)"AP_PAYBILL_NOTSUPPORT_CBPAY", (Locale)this.ctx.getLocale())});
        }
    }

    protected void checkBizDate() throws EASBizException, BOSException {
        PeriodInfo currentPeriod;
        if (this.info.getSourceType().getValue() == 101 && (currentPeriod = ArApPeriodHelper.getApCurrentPeriod(this.ctx, this.info.getCompany())) != null && this.info.getBizDate() != null && currentPeriod.getBeginDate().compareTo(this.info.getBizDate()) > 0 && !this.info.isIsInitializeBill()) {
            throw new RecPayException(RecPayException.AP_BILLDATEMUSTGREATTHANBEGINDATE);
        }
    }
}

