/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AP2POWriteBackForInvoice {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.util.AP2POWriteBackForInvoice");
    public static String PO_BOSTYPE = "3171BFAD";
    public static String AP_BOSTYPE = "48DA3A71";

    public static void PRBWriteBackOrderForInvoiceByUpdate(Context ctx, PayRequestBillInfo prbInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        Object obj;
        if (!IncomeInvoiceServerUtils.isSupport()) {
            return;
        }
        PayRequestBillEntryCollection entryCol = prbInfo.getEntrys();
        if (entryCol == null || entryCol.size() <= 0) {
            return;
        }
        String coreBillId = entryCol.get(0).getCoreBillId();
        if (coreBillId == null || !PO_BOSTYPE.equals(BOSUuid.read((String)coreBillId).getType().toString())) {
            return;
        }
        String sourceBillId = entryCol.get(0).getSourceBillId();
        if (sourceBillId != null && AP_BOSTYPE.equals(BOSUuid.read((String)sourceBillId).getType().toString())) {
            return;
        }
        BigDecimal totalAmountTax = BigDecimal.ZERO;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", prbInfo.getId().toString());
        param.put("ctx", (String)ctx);
        Map resultGetAmountTaxSum = new HashMap();
        try {
            resultGetAmountTaxSum = IncomeInvoiceServerUtils.getAmountTaxSum(param);
        }
        catch (BOSException e1) {
            logger.info((Object)("\u8c03\u7528com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils.getAmountTaxSum(param)\u51fa\u9519:(\u53c2\u6570param:" + ((Object)param).toString() + ")\r\n" + e1.getMessage()));
            throw e1;
        }
        catch (EASBizException e2) {
            logger.info((Object)("\u8c03\u7528com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils.getAmountTaxSum(param)\u51fa\u9519:(\u53c2\u6570param:" + ((Object)param).toString() + ")\r\n" + e2.getMessage()));
            throw e2;
        }
        if (resultGetAmountTaxSum != null && (obj = resultGetAmountTaxSum.get("totalAmountTax")) instanceof BigDecimal) {
            totalAmountTax = (BigDecimal)obj;
        }
        if (totalAmountTax.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        HashMap<String, BigDecimal> coreBillThisFMatchInvAmount = new HashMap<String, BigDecimal>();
        boolean isEnd = false;
        for (int i = 0; i < entryCol.size(); ++i) {
            PayRequestBillEntryInfo entryInfo = entryCol.get(i);
            BigDecimal reqPayAmount = entryInfo.getReqPayAmount() == null ? BigDecimal.ZERO : entryInfo.getReqPayAmount();
            String tempCoreBillId = entryInfo.getCoreBillId();
            if (totalAmountTax.subtract(reqPayAmount).compareTo(BigDecimal.ZERO) <= 0) {
                reqPayAmount = totalAmountTax;
                isEnd = true;
            }
            totalAmountTax = totalAmountTax.subtract(reqPayAmount);
            if (tempCoreBillId != null) {
                if (coreBillThisFMatchInvAmount.get(tempCoreBillId) != null) {
                    coreBillThisFMatchInvAmount.put(tempCoreBillId, ((BigDecimal)coreBillThisFMatchInvAmount.get(tempCoreBillId)).add(reqPayAmount));
                } else {
                    coreBillThisFMatchInvAmount.put(tempCoreBillId, reqPayAmount);
                }
            }
            if (isEnd) break;
        }
        String operator = " + ";
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            operator = " + ";
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            operator = " - ";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SM_PurOrder set FMatchInvAmount = FMatchInvAmount").append(operator).append(" ? where fid = ?");
        ArrayList<Object[]> sqlParamList = new ArrayList<Object[]>();
        for (Map.Entry entry : coreBillThisFMatchInvAmount.entrySet()) {
            sqlParamList.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), sqlParamList);
        Set coreBillIdSet = coreBillThisFMatchInvAmount.keySet();
        AP2POWriteBackForInvoice.updatePOInvoiceMatch(ctx, coreBillIdSet);
    }

    public static void PRBWriteBackOrderForInvoiceByUpdate(Context ctx, String id, BOTBillOperStateEnum bOTBillOperStateEnum) throws EASBizException, BOSException {
        if (id == null || id.length() == 0) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billStatus");
        sic.add("CU.id");
        sic.add("entrys.reqPayAmount");
        sic.add("entrys.coreBillId");
        sic.add("entrys.coreBillEntryId");
        PayRequestBillInfo payRequestBIllInfo = PayRequestBillFactory.getLocalInstance(ctx).getPayRequestBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, payRequestBIllInfo, bOTBillOperStateEnum);
    }

    public static void writeBackOrderForInvoiceByUpdate(Context ctx, OtherBillInfo otherBillInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        Object obj;
        if (!IncomeInvoiceServerUtils.isSupport()) {
            return;
        }
        if (otherBillInfo.isIsMatchGenerate()) {
            return;
        }
        OtherBillentryCollection entryCol = otherBillInfo.getEntry();
        if (entryCol == null || entryCol.size() <= 0) {
            return;
        }
        String coreBillId = entryCol.get(0).getCoreBillId();
        if (coreBillId == null || !PO_BOSTYPE.equals(BOSUuid.read((String)coreBillId).getType().toString())) {
            return;
        }
        BigDecimal totalAmountTax = BigDecimal.ZERO;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", otherBillInfo.getId().toString());
        param.put("ctx", (String)ctx);
        Map resultGetAmountTaxSum = new HashMap();
        try {
            resultGetAmountTaxSum = IncomeInvoiceServerUtils.getAmountTaxSum(param);
        }
        catch (BOSException e1) {
            logger.info((Object)("\u8c03\u7528com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils.getAmountTaxSum(param)\u51fa\u9519:(\u53c2\u6570param:" + ((Object)param).toString() + ")\r\n" + e1.getMessage()));
            throw e1;
        }
        catch (EASBizException e2) {
            logger.info((Object)("\u8c03\u7528com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils.getAmountTaxSum(param)\u51fa\u9519:(\u53c2\u6570param:" + ((Object)param).toString() + ")\r\n" + e2.getMessage()));
            throw e2;
        }
        if (resultGetAmountTaxSum != null && (obj = resultGetAmountTaxSum.get("totalAmountTax")) instanceof BigDecimal) {
            totalAmountTax = (BigDecimal)obj;
        }
        if (totalAmountTax.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        HashMap<String, BigDecimal> coreBillThisFMatchInvAmount = new HashMap<String, BigDecimal>();
        boolean isEnd = false;
        for (int i = 0; i < entryCol.size(); ++i) {
            OtherBillentryInfo entryInfo = entryCol.get(i);
            BigDecimal apAmount = entryInfo.getRecievePayAmount() == null ? BigDecimal.ZERO : entryInfo.getRecievePayAmount();
            String tempCoreBillId = entryInfo.getCoreBillId();
            if (totalAmountTax.subtract(apAmount).compareTo(BigDecimal.ZERO) <= 0) {
                apAmount = totalAmountTax;
                isEnd = true;
            }
            totalAmountTax = totalAmountTax.subtract(apAmount);
            if (tempCoreBillId != null) {
                if (coreBillThisFMatchInvAmount.get(tempCoreBillId) != null) {
                    coreBillThisFMatchInvAmount.put(tempCoreBillId, ((BigDecimal)coreBillThisFMatchInvAmount.get(tempCoreBillId)).add(apAmount));
                } else {
                    coreBillThisFMatchInvAmount.put(tempCoreBillId, apAmount);
                }
            }
            if (isEnd) break;
        }
        String operator = " + ";
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            operator = " + ";
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            operator = " - ";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SM_PurOrder set FMatchInvAmount = FMatchInvAmount").append(operator).append(" ? where fid = ?");
        ArrayList<Object[]> sqlParamList = new ArrayList<Object[]>();
        for (Map.Entry entry : coreBillThisFMatchInvAmount.entrySet()) {
            sqlParamList.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), sqlParamList);
        Set coreBillIdSet = coreBillThisFMatchInvAmount.keySet();
        AP2POWriteBackForInvoice.updatePOInvoiceMatch(ctx, coreBillIdSet);
    }

    public static void writeBackOrderForInvoiceByCover(Context ctx, OtherBillInfo otherBillInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException {
        HashMap<String, String> codeNumberMap = new HashMap<String, String>();
        if (!IncomeInvoiceServerUtils.isSupport()) {
            return;
        }
        if (!otherBillInfo.isIsMatchGenerate()) {
            return;
        }
        OtherBillentryCollection entryCol = otherBillInfo.getEntry();
        if (entryCol == null || entryCol.size() <= 0) {
            return;
        }
        String coreBillId = entryCol.get(0).getCoreBillId();
        if (coreBillId == null || !BOSUuid.read((String)coreBillId).getType().toString().equals("3171BFAD")) {
            return;
        }
        boolean isOrderMatch = true;
        String sourceBillId = entryCol.get(0).getSourceBillId();
        isOrderMatch = sourceBillId != null && BOSUuid.read((String)sourceBillId).getType().toString().equals("3171BFAD");
        String invoiceCode = otherBillInfo.getInvoiceCode();
        String invoiceNumber = otherBillInfo.getInvoiceNumber();
        if (invoiceCode == null || invoiceNumber == null) {
            return;
        }
        String[] codeArray = invoiceCode.split(";");
        String[] numberArray = invoiceNumber.split(";");
        for (int i = 0; i < codeArray.length; ++i) {
            codeNumberMap.put(codeArray[i] + numberArray[i], "true");
        }
        HashSet<String> coreBillIdSet = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            if (entryCol.get(i).getCoreBillId() == null) continue;
            coreBillIdSet.add(entryCol.get(i).getCoreBillId());
        }
        HashSet<String> sourceBillEntryIdSet = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            if (entryCol.get(i).getSourceBillEntryId() == null) continue;
            sourceBillEntryIdSet.add(entryCol.get(i).getSourceBillEntryId());
        }
        HashMap<String, BigDecimal> thisMatchAmount = new HashMap<String, BigDecimal>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        if (!isOrderMatch) {
            sql.append("piwe.FPurOrderID as orderId,");
        } else {
            sql.append("imre.FBillID as orderId,");
        }
        sql.append(" isnull(imre.FMatchedAmt,0) as matchedAmt from T_ARAP_InvoiceMatchRecordEntry imre");
        sql.append(" left join T_ARAP_InvoiceMatchRecord imr on imre.FParentID = imr.fid");
        if (!isOrderMatch) {
            sql.append(" left join T_IM_PurInWarehsEntry piwe on imre.FBillEntryID = piwe.fid");
        }
        sql.append(" where imre.FBillEntryID in ").append(FMHelper.setTran2String(sourceBillEntryIdSet));
        sql.append(" and imr.FDestBillNumber = '").append(otherBillInfo.getNumber()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String orderID = "";
            BigDecimal matchedAmt = BigDecimal.ZERO;
            while (rowSet.next()) {
                orderID = rowSet.getString("orderId");
                matchedAmt = rowSet.getBigDecimal("matchedAmt");
                if (thisMatchAmount.get(orderID) == null) {
                    thisMatchAmount.put(orderID, matchedAmt);
                    continue;
                }
                thisMatchAmount.put(orderID, ((BigDecimal)thisMatchAmount.get(orderID)).add(matchedAmt));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String operator = " + ";
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            operator = " + ";
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            operator = " - ";
        }
        AP2POWriteBackForInvoice.updatePoInvoiceAmount(ctx, thisMatchAmount, operator);
        HashSet<String> prqBillIdSet = new HashSet<String>();
        PayRequestBillEntryCollection entrysColl = PayRequestBillEntryFactory.getLocalInstance(ctx).getPayRequestBillEntryCollection("select parent where coreBillId in " + FMHelper.setTran2String(coreBillIdSet));
        if (entrysColl.size() > 0) {
            for (int i = 0; i < entrysColl.size(); ++i) {
                prqBillIdSet.add(entrysColl.get(i).getParent().getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            EntityViewInfo entityView = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", prqBillIdSet, CompareType.INCLUDE));
            entityView.setFilter(filter);
            entityView.getSelector().add(new SelectorItemInfo("requestAmount"));
            entityView.getSelector().add(new SelectorItemInfo("entrys.coreBillId"));
            entityView.getSelector().add(new SelectorItemInfo("entrys.reqPayAmount"));
            PayRequestBillCollection PayrequestInfoColl = PayRequestBillFactory.getLocalInstance(ctx).getPayRequestBillCollection(entityView);
            IRowSet rs = null;
            HashSet<String> prqIds = new HashSet<String>();
            HashMap<String, BigDecimal> prqInvoiceAmountTax = new HashMap<String, BigDecimal>();
            for (int i = 0; i < PayrequestInfoColl.size(); ++i) {
                prqIds.add(PayrequestInfoColl.get(i).getId().toString());
            }
            String prqIdSQL = FMHelper.setTran2String(prqIds);
            String lock = " UPDATE T_AP_PAYREQUESTBILL SET FID = FID WHERE FID IN " + prqIdSQL;
            DBUtil.execute((Context)ctx, (String)lock);
            sql.append(" SELECT TBR.FDESTOBJECTID AS TAXID FROM T_BOT_RELATION TBR");
            sql.append(" WHERE TBR.FDESTENTITYID='1343913D' AND TBR.FSRCOBJECTID IN ").append(prqIdSQL);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                try {
                    int count = 0;
                    StringBuilder taxIdSQL = new StringBuilder(200).append(" ( ");
                    while (rs.next()) {
                        if (count != 0) {
                            taxIdSQL.append(",");
                        }
                        taxIdSQL.append("'").append(rs.getString("TAXID")).append("'");
                        ++count;
                    }
                    taxIdSQL.append(" ) ");
                    lock = " UPDATE T_IM_IncomeInvoice SET FID = FID WHERE FID IN " + taxIdSQL;
                    DBUtil.execute((Context)ctx, (String)lock);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            sql.setLength(0);
            sql.append(" select invoice.FInvoiceCode as code,invoice.FInvoiceNumber as number,prq.fid as id, invoice.famountTax as amountTax from T_IM_IncomeInvoice invoice ");
            sql.append(" left join T_bot_relation relation on relation.fDestObjectID = invoice.fid ");
            sql.append(" left join T_ap_payrequestBill prq on prq.fid = relation.fSrcObjectID ");
            sql.append(" where prq.fid in ").append(prqIdSQL);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                try {
                    String code = "";
                    String number = "";
                    String pryId = "";
                    while (rs.next()) {
                        code = rs.getString("code");
                        number = rs.getString("number");
                        pryId = rs.getString("id");
                        if (!"true".equals(codeNumberMap.get(code + number))) continue;
                        if (prqInvoiceAmountTax.get(pryId) == null) {
                            prqInvoiceAmountTax.put(pryId, rs.getBigDecimal("amountTax"));
                            continue;
                        }
                        prqInvoiceAmountTax.put(pryId, ((BigDecimal)prqInvoiceAmountTax.get(pryId)).add(rs.getBigDecimal("amountTax")));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                HashMap<String, BigDecimal> coreBillThisFMatchPrePayAmount = new HashMap<String, BigDecimal>();
                block14: for (int i = 0; i < PayrequestInfoColl.size(); ++i) {
                    BigDecimal prePayAmount = BigDecimal.ZERO;
                    PayRequestBillInfo info = PayrequestInfoColl.get(i);
                    BigDecimal sumAmountTax = (BigDecimal)prqInvoiceAmountTax.get(info.getId().toString());
                    sumAmountTax = sumAmountTax == null ? BigDecimal.ZERO : sumAmountTax;
                    prePayAmount = sumAmountTax.compareTo(info.getRequestAmount()) < 0 ? sumAmountTax : info.getRequestAmount();
                    PayRequestBillEntryCollection entryColl = info.getEntrys();
                    boolean isEnd = false;
                    if (entryColl == null || entryColl.size() <= 0) continue;
                    for (int j = 0; j < entryColl.size(); ++j) {
                        PayRequestBillEntryInfo entryInfo = entryColl.get(j);
                        BigDecimal reqPayAmount = entryInfo.getReqPayAmount() == null ? BigDecimal.ZERO : entryInfo.getReqPayAmount();
                        String tempCoreBillId = entryInfo.getCoreBillId();
                        if (prePayAmount.subtract(reqPayAmount).compareTo(BigDecimal.ZERO) <= 0) {
                            reqPayAmount = prePayAmount;
                            isEnd = true;
                        }
                        prePayAmount = prePayAmount.subtract(reqPayAmount);
                        if (tempCoreBillId != null) {
                            if (coreBillThisFMatchPrePayAmount.get(tempCoreBillId) != null) {
                                coreBillThisFMatchPrePayAmount.put(tempCoreBillId, ((BigDecimal)coreBillThisFMatchPrePayAmount.get(tempCoreBillId)).add(reqPayAmount));
                            } else {
                                coreBillThisFMatchPrePayAmount.put(tempCoreBillId, reqPayAmount);
                            }
                        }
                        if (isEnd) continue block14;
                    }
                }
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                    operator = " - ";
                } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    operator = " + ";
                }
                AP2POWriteBackForInvoice.updatePoInvoiceAmount(ctx, coreBillThisFMatchPrePayAmount, operator);
            }
        }
        AP2POWriteBackForInvoice.updatePOInvoiceMatch(ctx, coreBillIdSet);
    }

    private static void updatePOInvoiceMatch(Context ctx, Set coreBillIdSet) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SM_PurOrder set FInvoiceMatch = (case when isnull(FMatchInvAmount,0) = 0 then 0 when isnull(FMatchInvAmount,0) >= isnull(FTotalTaxAmount,0) then 2 else 1 end)").append(" where fid in ").append(FMHelper.setTran2String((Set)coreBillIdSet));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updatePoInvoiceAmount(Context ctx, Map<String, BigDecimal> thisMatchAmount, String operator) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SM_PurOrder set FMatchInvAmount = FMatchInvAmount").append(operator).append(" ? where fid = ?");
        ArrayList<Object[]> sqlParamList = new ArrayList<Object[]>();
        for (Map.Entry<String, BigDecimal> entry : thisMatchAmount.entrySet()) {
            sqlParamList.add(new Object[]{entry.getValue(), entry.getKey()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), sqlParamList);
    }
}

