/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.PayRequestBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PayReqCommmonServerUtil {
    public static void handleSumEntrys(PayRequestBillInfo payReqInfo) {
        boolean isBillContainsPrePayType = PayReqCommmonServerUtil.isBillContainsPrePayType(payReqInfo);
        Set<String> sumFields = PayReqCommmonServerUtil.getSumFileds(isBillContainsPrePayType);
        LinkedHashMap<String, PayRequestSumEntryInfo> groupMap = new LinkedHashMap<String, PayRequestSumEntryInfo>();
        PayRequestBillEntryCollection entryColl = payReqInfo.getEntrys();
        Iterator entryCollIterator = entryColl.iterator();
        PayRequestBillEntryInfo entryInfo = null;
        String key = null;
        PayRequestSumEntryInfo sumEntryInfo = null;
        BigDecimal auditAmount = BigDecimal.ZERO;
        BigDecimal auditAmountLoc = BigDecimal.ZERO;
        BigDecimal lockAmount = BigDecimal.ZERO;
        BigDecimal lockAmountLoc = BigDecimal.ZERO;
        BigDecimal payedAmt = BigDecimal.ZERO;
        BigDecimal reqPayAmount = BigDecimal.ZERO;
        BigDecimal unLockAmount = BigDecimal.ZERO;
        BigDecimal unLockAmountLoc = BigDecimal.ZERO;
        BigDecimal unpayAmount = BigDecimal.ZERO;
        BigDecimal surceReqAmt = BigDecimal.ZERO;
        BigDecimal srcUnreqAmt = BigDecimal.ZERO;
        BigDecimal srcPpayUnreqAmt = BigDecimal.ZERO;
        String coreBillNumber = null;
        String coreBillId = null;
        while (entryCollIterator.hasNext()) {
            entryInfo = (PayRequestBillEntryInfo)entryCollIterator.next();
            if (null != entryInfo.getAuditAmount()) {
                auditAmount = entryInfo.getAuditAmount();
            }
            if (null != entryInfo.getAuditAmountLoc()) {
                auditAmountLoc = entryInfo.getAuditAmountLoc();
            }
            if (null != entryInfo.getLockAmount()) {
                lockAmount = entryInfo.getLockAmount();
            }
            if (null != entryInfo.getLockAmountLoc()) {
                lockAmountLoc = entryInfo.getLockAmountLoc();
            }
            if (null != entryInfo.getTotalPayAmt()) {
                payedAmt = entryInfo.getTotalPayAmt();
            }
            if (null != entryInfo.getReqPayAmount()) {
                reqPayAmount = entryInfo.getReqPayAmount();
            }
            if (null != entryInfo.getUnLockAmount()) {
                unLockAmount = entryInfo.getUnLockAmount();
            }
            if (null != entryInfo.getUnLockAmountLoc()) {
                unLockAmountLoc = entryInfo.getUnLockAmountLoc();
            }
            if (null != entryInfo.getUnpayAmount()) {
                unpayAmount = entryInfo.getUnpayAmount();
            }
            if (null != entryInfo.getSourcePayAmt()) {
                surceReqAmt = entryInfo.getSourcePayAmt();
            }
            if (null != entryInfo.getSrcUnreqAmt()) {
                srcUnreqAmt = entryInfo.getSrcUnreqAmt();
            }
            if (null != entryInfo.getSrcPpayUnreqAmt()) {
                srcPpayUnreqAmt = entryInfo.getSrcPpayUnreqAmt();
            }
            if (null != entryInfo.getCoreBillNumber() && isBillContainsPrePayType) {
                coreBillNumber = entryInfo.getCoreBillNumber();
            }
            if (null != entryInfo.getCoreBillId() && isBillContainsPrePayType) {
                coreBillId = entryInfo.getCoreBillId();
            }
            if (null == groupMap.get(key = PayReqCommmonServerUtil.assembleSumKey(sumFields, entryInfo))) {
                sumEntryInfo = new PayRequestSumEntryInfo();
                sumEntryInfo.setAccountBank(entryInfo.getAccountBank());
                sumEntryInfo.setAccountBankNo(entryInfo.getAccountBankNo());
                sumEntryInfo.setBankNumber(entryInfo.getBankNumber());
                sumEntryInfo.setAsstActID(entryInfo.getAsstActID());
                sumEntryInfo.setAsstActName(entryInfo.getAsstActName());
                sumEntryInfo.setAsstActNumber(entryInfo.getAsstActNumber());
                if (entryInfo.getPayBank() != null) {
                    sumEntryInfo.setPayBank(entryInfo.getPayBank().getBank());
                    sumEntryInfo.setPayBankAccount(entryInfo.getPayBank());
                }
                sumEntryInfo.setSettlementType(entryInfo.getBanlanceType());
                sumEntryInfo.setAsstActType(entryInfo.getAsstActType());
                sumEntryInfo.setPayableDate(entryInfo.getPayableDate());
                sumEntryInfo.setPayType(entryInfo.getPayType());
                sumEntryInfo.setAuditAmount(auditAmount);
                sumEntryInfo.setAuditAmountLoc(auditAmountLoc);
                sumEntryInfo.setLockAmount(lockAmount);
                sumEntryInfo.setLockAmountLoc(lockAmountLoc);
                sumEntryInfo.setPayedAmt(payedAmt);
                sumEntryInfo.setReqPayAmount(reqPayAmount);
                sumEntryInfo.setUnLockAmount(unLockAmount);
                sumEntryInfo.setUnLockAmountLoc(unLockAmountLoc);
                sumEntryInfo.setUnpayAmount(unpayAmount);
                sumEntryInfo.setSurceReqAmt(surceReqAmt);
                sumEntryInfo.setSrcUnreqAmt(srcUnreqAmt);
                sumEntryInfo.setSrcPpayUnreqAmt(srcPpayUnreqAmt);
                sumEntryInfo.setCoreBillNumber(coreBillNumber);
                sumEntryInfo.setCoreBillId(coreBillId);
                sumEntryInfo.setFundPropertyNew(entryInfo.getFundPropertyNew());
                sumEntryInfo.setSettlementType(entryInfo.getBanlanceType());
                groupMap.put(key, sumEntryInfo);
                continue;
            }
            sumEntryInfo = (PayRequestSumEntryInfo)groupMap.get(key);
            sumEntryInfo.setAuditAmount(sumEntryInfo.getAuditAmount().add(auditAmount));
            sumEntryInfo.setAuditAmountLoc(sumEntryInfo.getAuditAmountLoc().add(auditAmountLoc));
            sumEntryInfo.setLockAmount(sumEntryInfo.getLockAmount().add(lockAmount));
            sumEntryInfo.setLockAmountLoc(sumEntryInfo.getLockAmountLoc().add(lockAmountLoc));
            sumEntryInfo.setPayedAmt(sumEntryInfo.getPayedAmt().add(payedAmt));
            sumEntryInfo.setReqPayAmount(sumEntryInfo.getReqPayAmount().add(reqPayAmount));
            sumEntryInfo.setUnLockAmount(sumEntryInfo.getUnLockAmount().add(unLockAmount));
            sumEntryInfo.setUnLockAmountLoc(sumEntryInfo.getUnLockAmountLoc().add(unLockAmountLoc));
            sumEntryInfo.setUnpayAmount(sumEntryInfo.getUnpayAmount().add(unpayAmount));
            sumEntryInfo.setSurceReqAmt(sumEntryInfo.getSurceReqAmt().add(surceReqAmt));
            sumEntryInfo.setSrcUnreqAmt(sumEntryInfo.getSrcUnreqAmt().add(srcUnreqAmt));
            sumEntryInfo.setSrcPpayUnreqAmt(sumEntryInfo.getSrcPpayUnreqAmt().add(srcPpayUnreqAmt));
            groupMap.put(key, sumEntryInfo);
        }
        if (null != payReqInfo.getSumEntry() && payReqInfo.getSumEntry().size() != 0) {
            payReqInfo.getSumEntry().clear();
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            payReqInfo.getSumEntry().add((PayRequestSumEntryInfo)entry.getValue());
        }
    }

    public static boolean isBillContainsPrePayType(PayRequestBillInfo payReqInfo) {
        boolean isBillContainsPrePayType = false;
        PayRequestBillEntryCollection payRequestEntryColl = payReqInfo.getEntrys();
        Iterator payRequestEntryIterator = payRequestEntryColl.iterator();
        PayRequestBillEntryInfo entryInfo = null;
        PaymentBillTypeInfo payTypeInfo = null;
        while (payRequestEntryIterator.hasNext()) {
            entryInfo = (PayRequestBillEntryInfo)payRequestEntryIterator.next();
            payTypeInfo = entryInfo.getPayType();
            if (null == payTypeInfo || !payTypeInfo.isIsPrePay()) continue;
            isBillContainsPrePayType = true;
            break;
        }
        return isBillContainsPrePayType;
    }

    public static Set<String> getSumFileds(boolean isPrePay) {
        HashSet<String> sumFields = new HashSet<String>();
        sumFields.add("payType");
        sumFields.add("asstActType");
        sumFields.add("asstActNumber");
        sumFields.add("payableDate");
        if (isPrePay) {
            sumFields.add("coreBillId");
        }
        sumFields.add("fundPropertyNew");
        return sumFields;
    }

    public static String assembleSumKey(Set<String> sumFields, BillEntryBaseInfo entryInfo) {
        if (null == sumFields) {
            return null;
        }
        StringBuilder buf = new StringBuilder(100);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        int index = 0;
        Object obj = null;
        for (String field : sumFields) {
            if (index != 0) {
                buf.append("_");
            }
            ++index;
            obj = entryInfo.get(field);
            if (null == obj || obj instanceof String && StringUtils.isEmpty((String)obj.toString())) {
                buf.append("null");
                continue;
            }
            if (obj instanceof Date) {
                buf.append(sdf.format((Date)obj));
                continue;
            }
            if (obj instanceof CoreBaseInfo) {
                buf.append(((CoreBaseInfo)obj).getId().toString());
                continue;
            }
            buf.append(obj.toString());
        }
        return buf.toString();
    }

    public static void writeBackBillEntrySumID(Context ctx, IObjectPK pk, IPayRequestBill iPayRequestBill) throws EASBizException, BOSException {
        PayRequestBillInfo payReqInfo = iPayRequestBill.getPayRequestBillInfo(pk, PayReqCommmonServerUtil.getWriteBackSelector());
        boolean isBillContainsPrePayType = PayReqCommmonServerUtil.isBillContainsPrePayType(payReqInfo);
        Set<String> sumFields = PayReqCommmonServerUtil.getSumFileds(isBillContainsPrePayType);
        HashMap<String, String> sumEntryMap = new HashMap<String, String>();
        PayRequestSumEntryCollection sumEntry = payReqInfo.getSumEntry();
        Iterator sumEntryIterator = sumEntry.iterator();
        BillEntryBaseInfo sumInfo = null;
        String key = null;
        while (sumEntryIterator.hasNext()) {
            sumInfo = (BillEntryBaseInfo)sumEntryIterator.next();
            key = PayReqCommmonServerUtil.assembleSumKey(sumFields, sumInfo);
            sumEntryMap.put(key, sumInfo.getId().toString());
        }
        if (sumEntryMap.isEmpty()) {
            return;
        }
        PayRequestBillEntryCollection entryColl = payReqInfo.getEntrys();
        Iterator entrysIterator = entryColl.iterator();
        BillEntryBaseInfo entryInfo = null;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] params = null;
        StringBuilder sqlBuilder = new StringBuilder(100);
        sqlBuilder.append("UPDATE T_AP_PAYREQUESTBILLENTRY SET FSumEntryID = ? WHERE FID = ? ");
        String sumEntryId = null;
        while (entrysIterator.hasNext()) {
            entryInfo = (BillEntryBaseInfo)entrysIterator.next();
            key = PayReqCommmonServerUtil.assembleSumKey(sumFields, entryInfo);
            sumEntryId = (String)sumEntryMap.get(key);
            if (null == sumEntryId) continue;
            params = new Object[]{sumEntryId, entryInfo.getId().toString()};
            paramsList.add(params);
        }
        if (paramsList.size() == 0) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_NOT_MATCH_SUMENTRY);
        }
        DbUtil.executeBatch((Context)ctx, (String)sqlBuilder.toString(), paramsList);
    }

    public static SelectorItemCollection getWriteBackSelector() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.addObjectCollection((IObjectCollection)ArApSelectorFactory.getPayRequestBillEntrySelector("entrys"));
        selCol.addObjectCollection((IObjectCollection)ArApSelectorFactory.getPayRequestBillSumEntrySelector("sumEntry"));
        return selCol;
    }
}

