/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyBank;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyBank;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.app.web.SettleSplitHelper;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.app.web.ArApBillService;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.app.web.CodeRuleHelper;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.PlanHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class APBillService
extends ArApBillService {
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String STATUS_FINDVIEW = "FINDVIEW";
    private Context ctx;

    public APBillService(Context ctx) {
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        this.ctx = ctx;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> getCostCenterUnit(String adminOrgUnitId, String companyOrgUnitId) throws EASBizException, BOSException {
        OrgUnitCollection costCenterCollectionByOrg;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection costCenterCollection = iUtilRel.getToUnit(adminOrgUnitId, 0, 5);
        if (costCenterCollection.size() > 0 && (costCenterCollectionByOrg = iUtilRel.getFromUnit(companyOrgUnitId, 1, 5)).contains(costCenterCollection.get(0))) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("costCenterUnit", costCenterCollection.get(0));
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> getUIcache(String companyid, String status, Map otherInformation) throws EASBizException, BOSException {
        HashMap params = (HashMap)super.getUIcache(companyid, status, otherInformation);
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyid);
        keyMap.put("AP_036", companyPK);
        keyMap.put("AP_INTEGRATE_PWY", companyPK);
        HashMap paramValueMap = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(keyMap);
        params.put("isIntegratedByPWY", paramValueMap.get("AP_036"));
        params.put("AP_INTEGRATE_PWY", paramValueMap.get("AP_INTEGRATE_PWY"));
        return params;
    }

    @Override
    protected String getProjectFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getProjectF7Filer(companyid);
    }

    @Override
    protected String getTracknumberFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getTrackNumberF7Filer(companyid, null);
    }

    @Override
    protected String getPermissionItemByStatus(String status) {
        if (STATUS_ADDNEW.equals(status)) {
            return "fi_arap_ApOtherBill_Add";
        }
        if (STATUS_EDIT.equals(status)) {
            return "fi_ap_ApOtherBill_Update";
        }
        if (STATUS_VIEW.equals(status) || STATUS_FINDVIEW.equals(status)) {
            return "fi_ap_ApOtherBill_View";
        }
        return "fi_arap_ApOtherBill_Add";
    }

    public Map getParamValueMap(String[] prams, String orgId) throws EASBizException, BOSException {
        return ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(prams, orgId);
    }

    private Map getAdminOrgUnitByPerson(String personId, String purOrgUnitid, String companyid) throws EASBizException, BOSException {
        IOrgUnitRelation iUtilRel;
        OrgUnitCollection toUnit;
        boolean isbilldepart;
        OrgUnitInfo info = null;
        Map map = this.getParamValueMap(new String[]{"AP_BILL_DEPART", "AP_BILL_DEPART"}, companyid);
        boolean bl = isbilldepart = map.containsKey("AP_BILL_DEPART") ? Boolean.valueOf((String)map.get("AP_BILL_DEPART")) : true;
        if (isbilldepart && personId != null) {
            EntityViewInfo viewIn = new EntityViewInfo();
            FilterInfo filterIn = new FilterInfo();
            filterIn.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            filterIn.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)Boolean.TRUE));
            viewIn.setFilter(filterIn);
            SelectorItemCollection selectorAdmin = new SelectorItemCollection();
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.id"));
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.number"));
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.name"));
            viewIn.setSelector(selectorAdmin);
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)this.ctx);
            PositionMemberCollection positionColl = iPositionMember.getPositionMemberCollection(viewIn);
            if (positionColl.size() > 0) {
                info = positionColl.get(0).getPosition().getAdminOrgUnit();
            }
        } else if (purOrgUnitid != null && (toUnit = (iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx)).getToUnit(purOrgUnitid, 3, 0)).size() > 0) {
            info = toUnit.get(0);
        }
        HashMap<String, OrgUnitInfo> result = new HashMap<String, OrgUnitInfo>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    public Map<String, Object> getAdminOrgUnitByPurchaseOrgUnit(String purchaseOrgUnitId) throws EASBizException, BOSException {
        IOrgUnitRelation iUtilRel;
        OrgUnitCollection toUnit;
        AdminOrgUnitInfo info = null;
        if (!StringUtils.isEmpty((String)purchaseOrgUnitId) && (toUnit = (iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx)).getToUnit(purchaseOrgUnitId, 3, 0)).size() > 0) {
            info = (AdminOrgUnitInfo)toUnit.get(0);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    public Map<String, Object> fetchPrice(Object config) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getParamCol((Map)config);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getLocalInstance((Context)this.ctx).fetchPrice(paramCol);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("priceInfoCol", priceInfoCol);
        return result;
    }

    private PurPriceParamCollection getParamCol(Map config) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        String billTypeId = "510b6503-0105-1000-e000-010fc0a812fd463ED552";
        paramCol.setBillTypeId(billTypeId);
        paramCol.setMerge(((Boolean)config.get("isMerge")).booleanValue());
        paramCol.setSource((String)config.get("source"));
        String bizTypeId = (String)config.get("bizTypeId");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            paramCol.setBizTypeId(bizTypeId);
        }
        ArrayList paramArr = (ArrayList)config.get("paramArr");
        int len = paramArr.size();
        for (int i = 0; i < len; ++i) {
            PurPriceParam param = this.getParamInfo((Map)paramArr.get(i), billTypeId, bizTypeId);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    private PurPriceParam getParamInfo(Map config, String billTypeId, String bizTypeId) throws EASBizException, BOSException {
        PurPriceParam param = new PurPriceParam();
        try {
            ObjectUuidPK pk = null;
            if (!StringUtils.isEmpty((String)bizTypeId)) {
                String bizCategoryId;
                pk = new ObjectUuidPK(bizTypeId);
                BizTypeInfo bizType = BizTypeFactory.getLocalInstance((Context)this.ctx).getBizTypeInfo((IObjectPK)pk);
                if (bizType.getBizCategory() != null && ((bizCategoryId = bizType.getBizCategory().getId().toString()).equals("+f4mYqj4xUGaNf69/HWRdqk4kCA=") || bizCategoryId.equals("6LFeB81CJ0mD3wyAekUV7Kk4kCA="))) {
                    param.setMaterialPurchaseType(1);
                }
            }
            param.setBillTypeId(billTypeId);
            if (config.get("seq") != null) {
                param.setSeq(((Double)config.get("seq")).intValue());
            }
            param.setInTax(((Boolean)config.get("isInTax")).booleanValue());
            String purOrgUnitId = (String)config.get("purOrgUnitId");
            String currencyId = (String)config.get("currencyId");
            param.setPurOrgUnitId(StringUtils.isEmpty((String)purOrgUnitId) ? null : purOrgUnitId);
            param.setCurrencyId(StringUtils.isEmpty((String)currencyId) ? null : currencyId);
            param.setSupplierId((String)config.get("asstActId"));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            param.setBizDate(df.parse((String)config.get("bizDate")));
            String materialId = (String)config.get("materialId");
            String unitId = (String)config.get("unitId");
            String receiveOrgUnitId = (String)config.get("recOrgUnitId");
            String asstAttrId = (String)config.get("assistPropertyId");
            param.setMaterialId(StringUtils.isEmpty((String)materialId) ? null : materialId);
            param.setUnitId(StringUtils.isEmpty((String)unitId) ? null : unitId);
            pk = new ObjectUuidPK(materialId);
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)pk);
            param.setBaseUnitId(material.getBaseUnit().getId().toString());
            param.setRecOrgUnitId(StringUtils.isEmpty((String)receiveOrgUnitId) ? null : receiveOrgUnitId);
            param.setAssistPropertyId(StringUtils.isEmpty((String)asstAttrId) ? null : asstAttrId);
            if (!StringUtils.isEmpty((String)bizTypeId)) {
                param.setBizTypeId(bizTypeId);
            }
            if (config.containsKey("qty")) {
                if (config.get("qty") != null && !config.get("qty").equals("")) {
                    param.setQty(new BigDecimal(config.get("qty").toString()).abs());
                } else {
                    param.setQty(null);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return param;
    }

    public Map<String, Object> generatePlan(String apBillId, String payConditionId, Object otherInfo) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)payConditionId)) {
            return null;
        }
        OtherBillInfo info = null;
        ObjectUuidPK payConditionPk = new ObjectUuidPK(payConditionId);
        if (!StringUtils.isEmpty((String)apBillId)) {
            IOtherBill iAP = OtherBillFactory.getLocalInstance(this.ctx);
            ObjectUuidPK apBillPk = new ObjectUuidPK(apBillId);
            info = iAP.getOtherBillInfo((IObjectPK)apBillPk);
        }
        Map otherInfoMap = (Map)otherInfo;
        if (info == null) {
            info = new OtherBillInfo();
            Object companyid = otherInfoMap.get("companyid");
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            if (companyid != null) {
                company.setId(BOSUuid.read((String)companyid.toString()));
                info.setCompany(company);
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            info.setBillDate(df.parse((String)otherInfoMap.get("billDate")));
            info.setBizDate(df.parse((String)otherInfoMap.get("bizDate")));
            BigDecimal amount = new BigDecimal(String.valueOf(otherInfoMap.get("amount")));
            info.setAmount(amount);
            BigDecimal amountLocal = new BigDecimal(String.valueOf(otherInfoMap.get("amountLocal").toString()));
            info.setAmountLocal(amountLocal);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IPayCondition ipc = PayConditionFactory.getLocalInstance((Context)this.ctx);
        PayConditionInfo payConditionInfo = ipc.getPayConditionInfo((IObjectPK)payConditionPk);
        AbstractObjectCollection planCollection = PlanHelper.generatePlanCollection(this.ctx, info, payConditionInfo);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("planCollection", planCollection);
        return result;
    }

    @Override
    protected String getOrgFilterByCompany(String companyid, int orgType) throws EASBizException, BOSException {
        OrgUnitInfo info = null;
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)companyid)) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
            OrgUnitCollection toUnit = iUtilRel.getFromUnit(companyid, 1, orgType);
            HashSet<String> set = new HashSet<String>();
            int size = toUnit.size();
            for (int i = 0; i < size; ++i) {
                info = toUnit.get(i);
                set.add(info.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    public Map<String, Object> asstActChangeHandler(boolean isSupplier, String asstActId, String asstActTypeId, String purOrgId, boolean isBillDepart, String companyId, String billtype) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PersonInfo person = null;
        String bostype = BOSUuid.read((String)asstActId).getType().toString();
        if (isSupplier) {
            SupplierInfo supplier = SupplierFactory.getLocalInstance((Context)this.ctx).getSupplierInfo("SELECT taxRate WHERE id = '" + asstActId + "'");
            result.put("taxRate", supplier.getTaxRate());
            if (!StringUtils.isEmpty((String)purOrgId)) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)asstActId));
                filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)purOrgId));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("defaultPurchaser.*"));
                selector.add(new SelectorItemInfo("purchaseGroup.*"));
                view.setSelector(selector);
                ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)this.ctx);
                SupplierPurchaseInfoCollection collection = iSupplierPurchaseInfo.getSupplierPurchaseInfoCollection(view);
                if (collection.size() > 0 && collection.get(0).getDefaultPurchaser() != null) {
                    person = collection.get(0).getDefaultPurchaser();
                    result.put("person", person);
                    if (collection.get(0).getPurchaseGroup() != null) {
                        result.put("purchaseGroup", collection.get(0).getPurchaseGroup());
                    } else {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)person.getId()));
                        viewInfo.setFilter(filterInfo);
                        SelectorItemCollection selectorColl = new SelectorItemCollection();
                        selectorColl.add(new SelectorItemInfo("purGroup.*"));
                        viewInfo.setSelector(selectorColl);
                        SorterItemInfo sorterItemInfo = new SorterItemInfo();
                        sorterItemInfo.setPropertyName("purGroup.id");
                        sorterItemInfo.setSortType(SortType.DESCEND);
                        viewInfo.getSorter().add(sorterItemInfo);
                        IPurchasePerson iPurchasePerson = PurchasePersonFactory.getLocalInstance((Context)this.ctx);
                        PurchasePersonCollection purchaseColl = iPurchasePerson.getPurchasePersonCollection(viewInfo);
                        if (purchaseColl.size() > 0 && purchaseColl.get(0).getPurGroup().size() > 0) {
                            result.put("purchaseGroup", purchaseColl.get(0).getPurGroup());
                        }
                    }
                }
            }
        } else if (CustomerInfo.getBosType().equals(bostype)) {
            CustomerInfo customer = CustomerFactory.getLocalInstance((Context)this.ctx).getCustomerInfo("SELECT taxRate WHERE id = '" + asstActId + "'");
            result.put("taxRate", customer.getTaxRate());
        }
        Map map = null;
        map = isBillDepart && person != null ? this.getAdminOrgUnitByPerson(person.getId().toString(), purOrgId, companyId) : this.getAdminOrgUnitByPurchaseOrgUnit(purOrgId);
        result.putAll(map);
        PayConditionInfo payConditionInfo = PlanHelper.getPayCondition(this.ctx, asstActId, companyId);
        if (payConditionInfo != null && DeletedStatusEnum.DELETED.equals((Object)payConditionInfo.getDeletedStatus())) {
            payConditionInfo = null;
        }
        result.put("payCondition", payConditionInfo);
        if (companyId != null && asstActId != null) {
            try {
                boolean isContrast;
                boolean isArBill = false;
                if ("201".equals(billtype)) {
                    isArBill = true;
                }
                AccountViewInfo accountViewInfo = ArApServerUtils.getKAClassAccount(this.ctx, companyId, asstActId, isArBill, false, 0);
                IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)this.ctx);
                if (accountViewInfo != null && !(isContrast = iContrastAcct.isContrastAccount(ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString(), companyId, accountViewInfo.getId().toString(), AccountControlAttribute.AP))) {
                    accountViewInfo = null;
                }
                result.put("accountViewInfo", accountViewInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        Object accountBankInfo = this._getAsstActCompanyBankInfo(this.ctx, companyId, asstActId, asstActTypeId);
        result.put("accountBankInfo", accountBankInfo);
        return result;
    }

    protected Object _getAsstActCompanyBankInfo(Context ctx, String companyId, String asstActId, String asstActTypeId) throws BOSException, EASBizException {
        Object result = null;
        try {
            StringBuffer oql = new StringBuffer();
            IRowSet rs = null;
            oql.append("select fid, fRealtionDataObject from t_bd_asstActType where fid = '").append(asstActTypeId).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            String tableName = null;
            if (rs.next()) {
                tableName = rs.getString("fRealtionDataObject");
            }
            ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
            HashMap<String, ObjectUuidPK> hashKey = new HashMap<String, ObjectUuidPK>();
            hashKey.put("AP_PAYBILL_BANK", companyPK);
            HashMap apPaymentBankMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hashKey);
            Boolean isApPaymentBank = Boolean.valueOf((String)apPaymentBankMap.get("AP_PAYBILL_BANK"));
            Object asstActInfo = this.getAsstActInfo(ctx, tableName, asstActId);
            if ("T_BD_Customer".equals(tableName)) {
                if (((CustomerInfo)asstActInfo).isIsInternalCompany()) {
                    if (isApPaymentBank.booleanValue() && (result = this.getCustomerCompanyBankInfo(ctx, companyId, asstActId)) == null && ((CustomerInfo)asstActInfo).getInternalCompany() != null) {
                        result = this.getCompanyAccount(ctx, ((CustomerInfo)asstActInfo).getInternalCompany().getId().toString());
                    }
                } else {
                    result = this.getCustomerCompanyBankInfo(ctx, companyId, asstActId);
                }
            } else if ("T_BD_Supplier".equals(tableName)) {
                if (((SupplierInfo)asstActInfo).isIsInternalCompany()) {
                    if (isApPaymentBank.booleanValue() && (result = this.getSupplierCompanyBankInfo(ctx, companyId, asstActId)) == null && ((SupplierInfo)asstActInfo).getInternalCompany() != null) {
                        result = this.getCompanyAccount(ctx, ((SupplierInfo)asstActInfo).getInternalCompany().getId().toString());
                    }
                } else {
                    result = this.getSupplierCompanyBankInfo(ctx, companyId, asstActId);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Object getAsstActInfo(Context ctx, String tableName, String asstActId) throws BOSException, EASBizException {
        CustomerInfo asstActInfo = null;
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("isInternalCompany"));
        selCol.add(new SelectorItemInfo("internalCompany.id"));
        if ("T_BD_Customer".equals(tableName)) {
            asstActInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(asstActId), selCol);
        } else if ("T_BD_Supplier".equals(tableName)) {
            asstActInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(asstActId), selCol);
        }
        return asstActInfo;
    }

    private Map<String, Object> getCompanyAccount(Context ctx, String interalCompanyID) throws BOSException, EASBizException {
        HashMap<String, String> map = null;
        AccountBankInfo accountBankInfo = ArApBillUtil.getDefaultAcct(ctx, interalCompanyID);
        if (accountBankInfo != null) {
            map = new HashMap<String, String>();
            map.put("bank", accountBankInfo.getBank().getName());
            map.put("bankAccount", accountBankInfo.getBankAccountNumber());
            map.put("number", accountBankInfo.getNumber());
        }
        return map;
    }

    private SupplierCompanyBankInfo getSupplierCompanyBankInfo(Context ctx, String companyId, String supplierId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        EntityViewInfo view = null;
        oql.setLength(0);
        oql.append("select id where companyOrgUnit.id = ").append("'").append(companyId).append("'").append(" and supplier.id = ").append("'").append(supplierId).append("'");
        try {
            view = new EntityViewInfo(oql.toString());
            ISupplierCompanyInfo iCustComp = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            SupplierCompanyInfoCollection infos = iCustComp.getSupplierCompanyInfoCollection(view);
            if (infos != null && infos.size() > 0) {
                SupplierCompanyInfoInfo supCompInfo = infos.get(0);
                oql.setLength(0);
                oql.append("select bank, bankAccount, bankAddress,supplierCompanyInfo.id,isDefault where ");
                oql.append(" supplierCompanyInfo.id= '").append(supCompInfo.getId()).append("' ");
                view = new EntityViewInfo(oql.toString());
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("seq"));
                view.setSorter(sort);
                ISupplierCompanyBank iSupCompBank = SupplierCompanyBankFactory.getLocalInstance((Context)ctx);
                SupplierCompanyBankInfo supCompBankInfo = null;
                SupplierCompanyBankCollection supCompBankColls = iSupCompBank.getSupplierCompanyBankCollection(view);
                if (supCompBankColls != null && supCompBankColls.size() > 0) {
                    for (int i = 0; i < supCompBankColls.size(); ++i) {
                        if (!supCompBankColls.get(i).isIsDefault()) continue;
                        supCompBankInfo = supCompBankColls.get(i);
                        break;
                    }
                    if (supCompBankInfo == null) {
                        supCompBankInfo = supCompBankColls.get(0);
                    }
                    return supCompBankInfo;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private CustomerCompanyBankInfo getCustomerCompanyBankInfo(Context ctx, String companyId, String customerId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        EntityViewInfo view = null;
        oql.setLength(0);
        oql.append("select id where companyOrgUnit.id = ").append("'").append(companyId).append("'").append(" and customer.id = ").append("'").append(customerId).append("'");
        try {
            view = new EntityViewInfo(oql.toString());
            ICustomerCompanyInfo iCustComp = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            CustomerCompanyInfoCollection infos = iCustComp.getCustomerCompanyInfoCollection(view);
            if (infos != null && infos.size() > 0) {
                CustomerCompanyInfoInfo supCompInfo = infos.get(0);
                oql.setLength(0);
                oql.append("select bank, bankAccount, bankAddress,customerCompanyInfo.id,isDefault where ");
                oql.append(" customerCompanyInfo.id= '").append(supCompInfo.getId()).append("' ");
                view = new EntityViewInfo(oql.toString());
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("seq"));
                view.setSorter(sort);
                ICustomerCompanyBank iSupCompBank = CustomerCompanyBankFactory.getLocalInstance((Context)ctx);
                CustomerCompanyBankCollection supCompBankColls = iSupCompBank.getCustomerCompanyBankCollection(view);
                CustomerCompanyBankInfo supCompBankInfo = null;
                if (supCompBankColls != null && supCompBankColls.size() > 0) {
                    for (int i = 0; i < supCompBankColls.size(); ++i) {
                        if (!supCompBankColls.get(i).isIsDefault()) continue;
                        supCompBankInfo = supCompBankColls.get(i);
                        break;
                    }
                    if (supCompBankInfo == null) {
                        supCompBankInfo = supCompBankColls.get(0);
                    }
                    return supCompBankInfo;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public IObjectValue debitTransfer(String billId, boolean isAr) throws EASBizException, BOSException {
        String logItem = isAr ? "ar_otherbill_CreditTrans" : "ap_otherbill_DebitTrans";
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        ArApBillBaseInfo info = this.getInterface(isAr).getArApBillBaseInfo((IObjectPK)pk, sic);
        String billAliasKey = isAr ? "ARBill" : "2_OtherBillListUI";
        IObjectPK logPK = LogUtil.beginLog((Context)this.ctx, (String)(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)billAliasKey) + EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"debitTransferlog")), (BOSObjectType)bosType, (IObjectPK)pk, (String)info.getNumber(), (String)logItem);
        ArApBillBaseInfo destBillInfo = this.arap2arap(isAr, billId, 1);
        if (logPK != null) {
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)logPK);
        }
        return destBillInfo;
    }

    public IObjectValue allowance(String billId, boolean isAr) throws EASBizException, BOSException {
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        ArApBillBaseInfo info = this.getInterface(isAr).getArApBillBaseInfo((IObjectPK)pk, sic);
        String billAliasKey = isAr ? "ARBill" : "2_OtherBillListUI";
        IObjectPK logPK = LogUtil.beginLog((Context)this.ctx, (String)(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)billAliasKey) + EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"allowance")), (BOSObjectType)bosType, (IObjectPK)pk, (String)info.getNumber());
        ArApBillBaseInfo destBillInfo = this.arap2arap(isAr, billId, 2);
        if (logPK != null) {
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)logPK);
        }
        this.handleArapInfo(isAr, destBillInfo);
        return destBillInfo;
    }

    private ArApBillBaseInfo arap2arap(boolean isAr, String billId, int flag) throws EASBizException, BOSException {
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        paramMap.put("createToFlag", flag);
        paramMap.put("bizType", bosType);
        paramMap.put("transSelectors", BaseService.getBillSelectors());
        paramMap.put("selectId", billId);
        paramMap.put("currentUser", ContextUtil.getCurrentUserInfo((Context)this.ctx));
        HashMap hm = this.getInterface(isAr).processArap2Arap(paramMap);
        if (hm == null) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        ArApBillBaseInfo destBillInfo = (ArApBillBaseInfo)((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
        if (!this.getInterface(isAr).exists((IObjectPK)new ObjectUuidPK(destBillInfo.getId()))) {
            CodeRuleHelper codeHelper = new CodeRuleHelper();
            codeHelper.genNewBillNumber(this.getContext(), (IObjectValue)destBillInfo, (OrgUnitInfo)destBillInfo.getCompany());
        }
        return destBillInfo;
    }

    @Override
    protected String getCostCenterFilter(String companyId) throws EASBizException, BOSException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        HashSet<String> costCenterSet = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(companyId, 1, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            costCenterSet.add(orgIds.get(i).getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        if (costCenterSet.size() > 0) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", costCenterSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"null"));
        }
        return filterInfo.toString();
    }

    public void checkBeforeReverseBizBill(String billId, boolean isAr) throws EASBizException, BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        paramMap.put("isAR", isAr);
        paramMap.put("selectId", billId);
        paramMap.put("bizType", bosType.toString());
        SelectorItemCollection sic = BaseService.getBillSelectors();
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("payCondition.id"));
        sic.add(new SelectorItemInfo("payCondition.number"));
        sic.add(new SelectorItemInfo("payCondition.name"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActName"));
        sic.add(new SelectorItemInfo("asstActNumber"));
        sic.add(new SelectorItemInfo("asstActID"));
        paramMap.put("selector", sic);
        this.checkBeforeReverseBizBill(this.ctx, paramMap, isAr);
    }

    public IObjectValue reverseBizBill(String billId, boolean isAr) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        paramMap.put("isAR", isAr);
        paramMap.put("selectId", billId);
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        paramMap.put("bizType", bosType.toString());
        SelectorItemCollection sic = BaseService.getBillSelectors(isAr);
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.cu.id"));
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("payCondition.id"));
        sic.add(new SelectorItemInfo("payCondition.number"));
        sic.add(new SelectorItemInfo("payCondition.name"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActName"));
        sic.add(new SelectorItemInfo("asstActNumber"));
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("purOrg.id"));
        sic.add(new SelectorItemInfo("purOrg.number"));
        sic.add(new SelectorItemInfo("purOrg.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        sic.add(new SelectorItemInfo("entry.recAsstActType.id"));
        sic.add(new SelectorItemInfo("entry.recAsstActType.number"));
        sic.add(new SelectorItemInfo("entry.recAsstActType.name"));
        if (isAr) {
            sic.add(new SelectorItemInfo("disInvoicer"));
            sic.add(new SelectorItemInfo("recBillPhone"));
            sic.add(new SelectorItemInfo("recBillComName"));
            sic.add(new SelectorItemInfo("recBillAdress"));
            sic.add(new SelectorItemInfo("mailNumber"));
            sic.add(new SelectorItemInfo("recBillEmail"));
            sic.add(new SelectorItemInfo("expressBillNum"));
            sic.add(new SelectorItemInfo("mailDate"));
            sic.add(new SelectorItemInfo("invoiceType"));
            sic.add(new SelectorItemInfo("comInvoiceName"));
            sic.add(new SelectorItemInfo("taxNo"));
            sic.add(new SelectorItemInfo("addressAndTel"));
            sic.add(new SelectorItemInfo("oBankAndAcountNum"));
            sic.add(new SelectorItemInfo("planInvoiceDate"));
        } else {
            sic.add(new SelectorItemInfo("invoiceCode"));
            sic.add(new SelectorItemInfo("invoiceNumber"));
        }
        SelectorItemCollection depSic = ArApBillHelper.getEntityDepPropertySelector(null, bosType, true, true, true, null);
        sic = ArApBillUtil.margeSelector(depSic, sic);
        paramMap.put("selector", sic);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        paramMap = this.getInterface(isAr).reversedBizBill(paramMap);
        ArApBillBaseInfo destBillInfo = (ArApBillBaseInfo)paramMap.get("destBillInfo");
        this.handleArapInfo(isAr, destBillInfo);
        return destBillInfo;
    }

    public void unReversedBizBill(String billId, boolean isAr) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        this.getInterface(isAr).unReversedBizBill(new IObjectPK[]{pk});
    }

    public void checkBeforeBuildDebitAdjust(String billId, boolean isAr) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        paramMap.put("bizType", bosType);
        SelectorItemCollection sic = BaseService.getBillSelectors();
        paramMap.put("botpSelectors", sic);
        paramMap.put("idArray", billId);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("cu.id");
        sic.add("entry.id");
        ArApBillBaseInfo billInfo = this.getInterface(isAr).getArApBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        if (billInfo == null) {
            throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTUNAUDIT);
        }
        ArrayList<String> entriesKey = new ArrayList<String>();
        AbstractObjectCollection entries = null;
        entries = isAr ? ((com.kingdee.eas.fi.ar.OtherBillInfo)billInfo).getEntry() : ((OtherBillInfo)billInfo).getEntry();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entriesKey.add(entries.getObject(i).get("id").toString());
        }
        paramMap.put("entriesKey", entriesKey);
        paramMap.put("cuId", billInfo.getCU().getId());
        this.checkBeforeBuildDebitAdjust(this.ctx, paramMap, isAr);
    }

    public IObjectValue buildDebitAdjust(String billId, boolean isAr) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        BOSObjectType bosType = isAr ? ArApConstants.AR_OBILL_TYPE : ArApConstants.AP_OBILL_TYPE;
        paramMap.put("bizType", bosType);
        SelectorItemCollection sic = BaseService.getBillSelectors();
        sic.add("payCondition.id");
        sic.add("payCondition.number");
        sic.add("payCondition.name");
        sic.add("asstActName");
        sic.add("asstActNumber");
        sic.add("asstActID");
        sic.add("number");
        paramMap.put("botpSelectors", sic);
        paramMap.put("idArray", billId);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("cu.id");
        sic.add("entry.id");
        ArApBillBaseInfo billInfo = this.getInterface(isAr).getArApBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        ArrayList<String> entriesKey = new ArrayList<String>();
        AbstractObjectCollection entries = null;
        entries = isAr ? ((com.kingdee.eas.fi.ar.OtherBillInfo)billInfo).getEntry() : ((OtherBillInfo)billInfo).getEntry();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entriesKey.add(entries.getObject(i).get("id").toString());
        }
        paramMap.put("entriesKey", entriesKey);
        paramMap.put("cuId", billInfo.getCU().getId());
        HashMap hm = this.getInterface(isAr).buildDebitAdjust(paramMap);
        ArApBillBaseInfo destBillInfo = (ArApBillBaseInfo)((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
        this.handleArapInfo(isAr, destBillInfo);
        BigDecimal minusOne = new BigDecimal(-1);
        return destBillInfo;
    }

    public Map<String, Object> handlePersonChange(String personId, String purchaseOrgUnitId, String companyid, boolean isBillDepart) throws BOSException, EASBizException {
        Map map = null;
        map = isBillDepart ? this.getAdminOrgUnitByPerson(personId, purchaseOrgUnitId, companyid) : this.getAdminOrgUnitByPurchaseOrgUnit(purchaseOrgUnitId);
        StringBuffer sql = new StringBuffer();
        sql.append("select id,person.id,purGroup.*, purGroup.purOrg.id where purGroup.purOrg.id='");
        sql.append(purchaseOrgUnitId).append("'").append(" and person.id='").append(personId).append("'");
        sql.append(" and deletedStatus = ").append(1);
        IPurchasePerson is = PurchasePersonFactory.getLocalInstance((Context)this.ctx);
        PurchasePersonCollection purchasePersonCollection = is.getPurchasePersonCollection(sql.toString());
        PurchaseGroupInfo aPurchaseGroupInfo = null;
        if (purchasePersonCollection.size() > 0) {
            aPurchaseGroupInfo = purchasePersonCollection.get(0).getPurGroup();
        }
        if (aPurchaseGroupInfo == null || !ForbidStatusEnum.UNFORBID.equals((Object)aPurchaseGroupInfo.getDeletedStatus())) {
            aPurchaseGroupInfo = null;
        }
        map.put("purchaseGroupInfo", aPurchaseGroupInfo);
        return map;
    }

    private void checkBeforeBuildDebitAdjust(Context ctx, HashMap paramMap, boolean isAr) throws EASBizException, BOSException {
        if (paramMap.get("createTo") == null) {
            BOSObjectType bizType = (BOSObjectType)paramMap.get("bizType");
            String cuId = paramMap.get("cuId").toString();
            BOTMappingInfo btpMappingInfo = null;
            String selectId = paramMap.get("idArray").toString();
            SelectorItemCollection transSelectors = (SelectorItemCollection)paramMap.get("botpSelectors");
            ArApBillBaseInfo info = (ArApBillBaseInfo)this.getInterface(isAr).getValue((IObjectPK)new ObjectUuidPK(selectId), transSelectors);
            if (info == null) {
                throw new ObjectNotFoundException();
            }
            CoreBillBaseCollection coll = new CoreBillBaseCollection();
            try {
                btpMappingInfo = ArApBillHelper.getBotpMapping4DebitAdjust(ctx, bizType, cuId, selectId, (IObjectValue)info, (IntEnum)(isAr ? OtherBillTypeEnum.DebitAdjust : OtherBillType.DebitAdjust));
                if (btpMappingInfo == null) {
                    throw new OtherBillBizException(BTPException.GETMAPPINGINFOERROR);
                }
            }
            catch (Exception e) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
            if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
                throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTUNAUDIT);
            }
            if (info.isIsBizBill()) {
                throw new OtherBillBizException(OtherBillBizException.BIZARAPBILLCANNOTCREATETO);
            }
            if (info.getPaymentType().getId().toString().equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                throw new OtherBillBizException(OtherBillBizException.CASHPUR_FORBIDDEN);
            }
            AbstractObjectCollection destEntrys = null;
            destEntrys = isAr ? ((com.kingdee.eas.fi.ar.OtherBillInfo)info).getEntry() : ((OtherBillInfo)info).getEntry();
            ArrayList entryID = (ArrayList)paramMap.get("selectEntryId");
            boolean deleteentry = false;
            if (entryID != null && entryID.size() != 0) {
                deleteentry = true;
            }
            ArApBillEntryBaseInfo destEntryInfo = null;
            Iterator it = destEntrys.iterator();
            while (it.hasNext()) {
                destEntryInfo = (ArApBillEntryBaseInfo)it.next();
                if (!deleteentry || entryID.contains(destEntryInfo.getId().toString())) continue;
                it.remove();
            }
            coll.add((CoreBillBaseInfo)info);
            try {
                BTPTransformResult btpResult = null;
                IBTPManager iBTPManager = null;
                iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                if (bizType != null && btpMappingInfo != null && btpMappingInfo.getId() != null) {
                    btpResult = iBTPManager.transform(coll, bizType.toString(), (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId().toString()));
                }
                if (btpResult == null) {
                    throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
                }
            }
            catch (BOSException e) {
                throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
            }
            catch (BTPException e) {
                throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
            }
        }
    }

    protected void checkBeforeReverseBizBill(Context ctx, HashMap paramMap, boolean isAr) throws BOSException, EASBizException {
        ArApBillBaseInfo info = (ArApBillBaseInfo)this.getInterface(isAr).getValue((IObjectPK)new ObjectUuidPK(paramMap.get("selectId").toString()), (SelectorItemCollection)paramMap.get("selector"));
        if (info == null) {
            throw new ObjectNotFoundException();
        }
        String permItemName = isAr ? "fi_ar_ArOtherBill_ReversedBizBill" : "fi_ap_ApOtherBill_ReversedBizBill";
        ObjectStringPK orgPK = new ObjectStringPK(info.getCompany().getId().toString());
        this.checkFunctionPermission((IObjectPK)orgPK, permItemName);
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (!info.isIsBizBill()) {
            throw new OtherBillBizException(OtherBillBizException.NOTBIZARAPBILL, new String[]{""});
        }
        boolean isInvoiceBill = OtherBillTypeEnum.InvoiceBill.equals((Object)info.getBillTypeEnum()) || OtherBillType.InvoiceBill.equals((Object)info.getBillTypeEnum());
        AbstractObjectCollection destEntrys = info.getEntries();
        ArrayList entryID = paramMap.get("selectEntryId") != null ? (ArrayList)paramMap.get("selectEntryId") : null;
        boolean deleteentry = false;
        if (entryID != null && entryID.size() != 0) {
            deleteentry = true;
        }
        Iterator it = destEntrys.iterator();
        BigDecimal reversedBaseQty = null;
        ArApBillEntryBaseInfo destEntryInfo = null;
        while (it.hasNext()) {
            destEntryInfo = (ArApBillEntryBaseInfo)it.next();
            if (deleteentry && !entryID.contains(destEntryInfo.getId().toString())) {
                it.remove();
                continue;
            }
            if (isInvoiceBill) {
                reversedBaseQty = destEntryInfo.getBaseQty().subtract(destEntryInfo.getReversedBaseQty());
            }
            if (isInvoiceBill && reversedBaseQty.signum() != 0 || !isInvoiceBill && destEntryInfo.getUnVerifyAmountLocal().signum() != 0) continue;
            it.remove();
        }
        if (destEntrys.size() == 0) {
            throw new OtherBillBizException(OtherBillBizException.UNREVERSEDBASEQTYISZERO);
        }
    }

    private void checkFunctionPermission(IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getLocalInstance((Context)this.ctx);
        perm.checkFunctionPermission(this.ctx.getCaller(), orgPK, permItemName);
    }

    public void checkBeforeDebitTransfer(String billId, boolean isAr) throws BOSException, EASBizException {
        ArApBillBaseInfo info = (ArApBillBaseInfo)this.getInterface(isAr).getValue((IObjectPK)new ObjectUuidPK(billId), BaseService.getBillSelectors());
        ObjectStringPK orgPK = new ObjectStringPK(info.getCompany().getId().toString());
        String permItemName = isAr ? "fi_ar_OtherBill_CreditTrans" : "fi_ap_OtherBill_DebitTrans";
        this.checkFunctionPermission((IObjectPK)orgPK, permItemName);
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (info.isIsBizBill()) {
            throw new OtherBillBizException(OtherBillBizException.BIZARAPBILLCANNOTCREATETO);
        }
        if (info.getUnLockAmt().signum() == 0) {
            throw new OtherBillBizException(OtherBillBizException.ISALLLOCKED);
        }
    }

    private IArApBillBase getInterface(boolean isAr) throws BOSException {
        if (isAr) {
            return com.kingdee.eas.fi.ar.OtherBillFactory.getLocalInstance(this.ctx);
        }
        return OtherBillFactory.getLocalInstance(this.ctx);
    }

    public Map getAPCreateToBOTPOption(List billIds) throws BOSException, EASBizException {
        long beginTime = System.currentTimeMillis();
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(billIds);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        CoreBillBaseCollection billCol = OtherBillFactory.getLocalInstance(this.ctx).getCoreBillBaseCollection(evi);
        IBOTMapping ibot = BOTMappingFactory.getLocalInstance((Context)this.ctx);
        BOTMappingCollection botpCol = ibot.getMappingCollectionForSelect(billCol, "40284E81", DefineSysEnum.BTP);
        botpCol.addCollection(ibot.getMappingCollectionForSelect(billCol, "D001019A", DefineSysEnum.BTP));
        idSet = new HashSet();
        int size = botpCol.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(botpCol.get(i).getId().toString());
        }
        evi = new EntityViewInfo();
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("alias");
        sic.add("description");
        sic.add("destEntityName");
        sic.add("destEntityAlias");
        evi.setSelector(sic);
        botpCol = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingCollection(evi);
        System.out.println("operation costed " + (System.currentTimeMillis() - beginTime) + "ms");
        HashMap<String, BOTMappingCollection> map = new HashMap<String, BOTMappingCollection>();
        map.put("botpCol", botpCol);
        return map;
    }

    public void afterSetupCustomAmount(String listType, String botpId, Map data) throws BOSException, EASBizException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        SettleSplitHelper ssh = new SettleSplitHelper();
        if ("materialList".equals(listType)) {
            List entryIds = (List)data.get("entryIds");
            ssh.initSplitQueueByEntry(this.ctx, entryIds);
        } else {
            ssh.initSplitQueueByPlan(this.ctx, data);
        }
        EntityViewInfo evi = ssh.getBillIdEvi();
        OtherBillCollection apCol = OtherBillFactory.getLocalInstance(this.ctx).getOtherBillCollection(evi);
        int size_j = apCol.size();
        for (int j = 0; j < size_j; ++j) {
            OtherBillInfo info = apCol.get(j);
            OtherBillentryCollection entries = info.getEntry();
            OtherBillentryCollection entriesTmp = (OtherBillentryCollection)((Object)entries.clone());
            entries.clear();
            int size = entriesTmp.size();
            for (int i = 0; i < size; ++i) {
                OtherBillentryInfo entry = entriesTmp.get(i);
                ssh.setSplitQueue(entry.getId().toString());
                while (ssh.hasNext()) {
                    OtherBillentryInfo entrySplit = (OtherBillentryInfo)entry.clone();
                    entrySplit.setPayableDate(ssh.getPayableDate());
                    entrySplit.setLockUnVerifyAmt(ssh.getActiveAmt());
                    entrySplit.setLockUnVerifyAmtLocal(ssh.getActiveAmtLoc());
                    entries.addObjectDirect((IObjectValue)entrySplit);
                    ssh.dequeue();
                }
            }
            col.add((CoreBillBaseInfo)info);
        }
        BOTMappingInfo botpInfo = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingInfo("select destEntityName where id='" + botpId + "'");
        IBTPManager btpInstance = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        this.ctx.put((Object)"NO_SettingValue", (Object)"true");
        BTPTransformResult btpResult = btpInstance.transformForBotp(col, botpInfo.getDestEntityName(), (IObjectPK)new ObjectUuidPK(botpId));
        IObjectCollection targetBillCol = btpResult.getBills();
        for (int i = 0; i < targetBillCol.size(); ++i) {
            CoreBillBaseInfo coreInfo = (CoreBillBaseInfo)targetBillCol.getObject(i);
            btpInstance.saveRelations(coreInfo, btpResult.getBOTRelationCollection());
        }
        this.ctx.put((Object)"NO_SettingValue", null);
    }

    public boolean isOpenCodingRule(String orgId) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        return codingRuleManager.getRuleStatus((IObjectValue)new OtherBillInfo(), orgId).isExist();
    }

    private void handleArapInfo(boolean isAr, ArApBillBaseInfo info) throws BOSException, EASBizException {
        OtherBillInfo ap;
        com.kingdee.eas.fi.ar.OtherBillInfo ar;
        BigDecimal amtLoc;
        BigDecimal amt = amtLoc = BigDecimal.ZERO;
        boolean isNeedToCreatePlan = false;
        info.setBillDate(ArApServerUtils.getBizDateBySystem(null, isAr, info.getCompany()));
        info.setAmount(info.getAmount() == null ? BigDecimal.ZERO : info.getAmount());
        isNeedToCreatePlan = isAr ? (ar = (com.kingdee.eas.fi.ar.OtherBillInfo)info).getRecievePlan().size() == 0 && ar.getEntry().size() > 0 : (ap = (OtherBillInfo)info).getPayPlan().size() == 0 && ap.getEntry().size() > 0;
        AbstractObjectCollection entry = null;
        entry = isAr ? ((com.kingdee.eas.fi.ar.OtherBillInfo)info).getEntry() : ((OtherBillInfo)info).getEntry();
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            amt = amt.add((BigDecimal)entry.getObject(i).get("recievePayAmount"));
            amtLoc = amtLoc.add((BigDecimal)entry.getObject(i).get("recievePayAmountLocal"));
        }
        info.setAmount(amt);
        info.setAmountLocal(amtLoc);
        if (isNeedToCreatePlan) {
            ArApBillPlanBaseInfo plan = isAr ? new com.kingdee.eas.fi.ar.OtherBillPlanInfo() : new OtherBillPlanInfo();
            plan.setRecievePayDate(new Date());
            plan.setRecievePayAmount(amt);
            plan.setRecievePayAmountLocal(amtLoc);
            plan.setVerifyAmount(amt);
            plan.setVerifyAmountLocal(amtLoc);
            if (isAr) {
                ((com.kingdee.eas.fi.ar.OtherBillInfo)info).getRecievePlan().add((com.kingdee.eas.fi.ar.OtherBillPlanInfo)plan);
            } else {
                ((OtherBillInfo)info).getPayPlan().add((OtherBillPlanInfo)plan);
            }
        }
        if (null == info.getCU()) {
            info.setCU(info.getCompany() == null ? null : info.getCompany().getCU());
        }
    }

    @Override
    protected boolean isArBill(ArApBillBaseInfo info) {
        return OtherBillType.OtherPay.equals((Object)((OtherBillInfo)info).getBillType());
    }

    @Override
    protected boolean isAr() {
        return false;
    }

    @Override
    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }
}

