/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PaymentBillService {
    private Context ctx;

    public PaymentBillService(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> getUIcache(String id, String companyid) throws EASBizException, BOSException {
        PaymentBillCollection col = null;
        PaymentBillInfo payInfo = null;
        if (id != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            evi.setFilter(filter);
            col = PaymentBillFactory.getLocalInstance((Context)this.getContext()).getPaymentBillCollection(evi);
        }
        if (col != null && col.size() > 0) {
            payInfo = col.get(0);
        }
        return this.getUIcache(payInfo);
    }

    public Map<String, Object> getUIcache(PaymentBillInfo payInfo) throws EASBizException, BOSException {
        boolean isImportBillCannotModi;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (payInfo == null) {
            return params;
        }
        String companyid = payInfo.getCompany().getId().toString();
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getCacheCurrentPeriod(13, companyid);
        if (currentPeriod == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            String name = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid), sic).getName();
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{name + " " + SystemEnum.ACCOUNTSPAYABLE.getAlias()});
        }
        params.put("projectfilter", this.getProjectFilter(companyid));
        params.put("tracknumberfilter", this.getTracknumberFilter(companyid));
        Object col = null;
        String srcBosType = null;
        String sParamValue = ParamManager.getParamValue((Context)this.getContext(), (IObjectPK)new ObjectUuidPK(payInfo.getCompany().getId()), (String)"G003");
        boolean bl = isImportBillCannotModi = sParamValue != null && ("true".equalsIgnoreCase(sParamValue) || "1".equals(sParamValue));
        if (payInfo.isIsImport() && isImportBillCannotModi) {
            throw new OtherBillBizException(OtherBillBizException.IMPORTBILL);
        }
        PaymentBillEntryInfo entry = payInfo.getEntries().get(0);
        if (entry != null && entry.getSourceBillId() != null) {
            srcBosType = BOSUuid.read((String)entry.getSourceBillId()).getType().toString();
        }
        params.put("srcBosType", srcBosType);
        PaymentTypeInfo creditPayInfo = PaymentTypeFactory.getLocalInstance((Context)this.getContext()).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
        params.put("creditPay", creditPayInfo);
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection profitCollection = iOrgUnitRelation.getFromUnit(companyid, 1, 6);
        StringBuilder sqlIDs = new StringBuilder();
        if (profitCollection != null && profitCollection.size() > 0) {
            for (int i = 0; i < profitCollection.size(); ++i) {
                OrgUnitInfo orgUnitInfo = profitCollection.get(i);
                if ("".equals(sqlIDs.toString())) {
                    sqlIDs.append("'").append(orgUnitInfo.getId().toString()).append("'");
                    continue;
                }
                sqlIDs.append(",'").append(orgUnitInfo.getId().toString()).append("'");
            }
        }
        params.put("profitCenterFilterIds", sqlIDs.toString());
        if (payInfo != null && payInfo.getCurrency() != null) {
            String excTableid = "";
            String basecurrencyid = "";
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            if (company != null && company.getBaseExchangeTable() != null) {
                excTableid = company.getBaseExchangeTable().getId().toString();
            } else {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
                excTableid = company.getBaseExchangeTable().getId().toString();
            }
            if (company != null && company.getBaseCurrency() != null) {
                basecurrencyid = company.getBaseCurrency().getId().toString();
            }
            String currencyid = payInfo.getCurrency().getId().toString();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String billDate = dateFormat.format(payInfo.getBizDate());
            Map exchangeData = PayRequestBillFacadeFactory.getLocalInstance(this.ctx).getExchange(excTableid, basecurrencyid, currencyid, billDate);
            params.put("exchangeData", exchangeData);
        }
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyid);
        keyMap.put("AR_039", companyPK);
        keyMap.put("PAYBILL_AUDIT_NOW", companyPK);
        keyMap.put("CS131", companyPK);
        HashMap paramValueMap = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(keyMap);
        params.put("paramValue", paramValueMap);
        String supplierTypeId = ArApBillHelper.getAsstactTypeSupplierId(this.ctx);
        params.put("supplierTypeId", supplierTypeId);
        return params;
    }

    private String getProjectFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getProjectF7Filer(companyid);
    }

    private String getTracknumberFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getTrackNumberF7Filer(companyid, null);
    }

    public PaymentBillInfo createNewModel(PaymentBillInfo billInfo, String operate) throws BOSException, EASBizException {
        billInfo.setSourceType(SourceTypeEnum.AP);
        billInfo.setSourceSysType(SourceTypeEnum.AP);
        if (operate == null) {
            billInfo.setIsInitializeBill(false);
            PaymentTypeInfo pamenttype = new PaymentTypeInfo();
            pamenttype.setId(BOSUuid.read((String)"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
            pamenttype.setNumber("004");
            pamenttype.setName(EASResource.getString((String)"com.kingdee.eas.fi.ap.ApAllResource", (String)"CreditBuy"));
            billInfo.setPaymentType(pamenttype);
            billInfo.setBillDate(ArApServerUtils.getBizDateBySystem(this.ctx, false, billInfo.getCompany()));
            billInfo.setBizDate(ArApServerUtils.getBizDateBySystem(this.ctx, false, billInfo.getCompany()));
            PaymentBillTypeInfo defaultBillTypeInfo = this.getDefaultBillType();
            if (null != defaultBillTypeInfo && DeletedStatusEnum.DELETED.equals((Object)defaultBillTypeInfo.getDeletedStatus())) {
                defaultBillTypeInfo = null;
            }
            if (defaultBillTypeInfo != null) {
                billInfo.setPayBillType(defaultBillTypeInfo);
                billInfo.setSourceSysType(defaultBillTypeInfo.getSourceSysType());
            } else {
                billInfo.setPayBillType(null);
            }
            AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
            String companyid = billInfo.getCompany().getId().toString();
            asstActTypeInfo = this.getAsstActType(companyid);
            billInfo.setPayeeType(asstActTypeInfo);
        } else if ("copy".equals(operate)) {
            Date d = null;
            d = billInfo.isIsInitializeBill() ? new BaseService(this.ctx).getBeforeSysDate(true, 13, billInfo.getCompany().getId().toString()) : ArApServerUtils.getBizDateBySystem(this.ctx, false, billInfo.getCompany());
            if (!ArApBillUtil.verifyAsstActIgnore(this.ctx, billInfo.getCompany(), billInfo.getPayeeID(), true).booleanValue()) {
                billInfo.setPayeeID(null);
                billInfo.setPayeeNumber(null);
                billInfo.setPayeeName(null);
            }
            billInfo.setBillDate(d);
            billInfo.setBizDate(d);
        }
        return billInfo;
    }

    private AsstActTypeInfo getAsstActType(String companyid) throws EASBizException, BOSException {
        AsstActTypeInfo info = null;
        AsstActTypeInfo oldInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyid);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeDefaultCollection(ev);
        info = asstActTypeColl.get(0).getAsstActType();
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            oldInfo = asstActTypeColl.get(i).getAsstActType();
            if (!oldInfo.getRealtionDataObject().equals("T_BD_Supplier")) continue;
            info = oldInfo;
            break;
        }
        return info;
    }

    protected PaymentBillTypeInfo getDefaultBillType() throws BOSException {
        PaymentBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"201", CompareType.EQUALS));
        PaymentBillTypeCollection coll = PaymentBillTypeFactory.getLocalInstance((Context)this.ctx).getPaymentBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }
}

