/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SettleSplitHelper {
    public static final String CR = "\r\n";
    private String deadAmtFieldName = "fUnLockAmount";
    private Set billIdSet = null;
    private Map settleMap = null;
    private List currentSplitQueue;
    private Map id_amt = null;

    private void initSplitQueue(Context ctx, boolean isByEntry, List ids) throws BOSException {
        StringBuffer buf = new StringBuffer();
        this.deadAmtFieldName = "fLockAmount";
        buf.append("SELECT fBillId, fEntryId, fPayableDate, fPlanId, ").append("(fPayableAmount - ").append(this.deadAmtFieldName).append(") as fActiveAmt, ").append("(fPayableAmountLoc - ").append(this.deadAmtFieldName).append("Loc) as fActiveAmtLoc ").append("FROM T_AP_SettlementList").append(CR).append(" WHERE ").append(this.getCondition(isByEntry, ids)).append(CR).append(" ORDER BY fPayableDate asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        this.settleMap = new HashMap();
        this.billIdSet = new HashSet();
        try {
            while (rs.next()) {
                List settleList;
                String entryId;
                String billId = rs.getString("fbillId");
                if (!this.billIdSet.contains(billId)) {
                    this.billIdSet.add(billId);
                }
                if (!this.settleMap.containsKey(entryId = rs.getString("fEntryId"))) {
                    settleList = new ArrayList();
                    this.settleMap.put(entryId, settleList);
                } else {
                    settleList = (List)this.settleMap.get(entryId);
                }
                Date payableDate = new Date(rs.getDate("fPayableDate").getTime());
                HashMap<String, Object> settle = new HashMap<String, Object>();
                settle.put("entryId", entryId);
                settle.put("planId", rs.getString("fPlanId"));
                settle.put("payableDate", payableDate);
                BigDecimal[] activeAmts = this.getActiveAmt(ctx, rs, isByEntry);
                settle.put("activeAmt", activeAmts[0]);
                settle.put("activeAmtLoc", activeAmts[1]);
                settleList.add(settle);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal[] getActiveAmt(Context ctx, IRowSet rs, boolean isByEntry) throws BOSException {
        BigDecimal activeAmt = null;
        BigDecimal activeAmtLoc = null;
        try {
            activeAmt = rs.getBigDecimal("fActiveAmt");
            activeAmtLoc = rs.getBigDecimal("fActiveAmtLoc");
            if (this.id_amt != null) {
                BigDecimal customAmt;
                String key = rs.getString(isByEntry ? "fEntryId" : "fPlanId");
                if (this.id_amt.get(key) == null) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.ap.ApAllResource", (String)"ErrorUnitAmountHaveZeroCannotSubmit", (Locale)ctx.getOriginLocale()));
                }
                if (this.id_amt.get(key) instanceof String) {
                    this.id_amt.put(key, new BigDecimal((String)this.id_amt.get(key)));
                }
                if ((customAmt = (BigDecimal)this.id_amt.get(key)).compareTo(activeAmt) <= 0) {
                    int scale = activeAmt.scale();
                    BigDecimal rate = activeAmtLoc.divide(activeAmt, scale, 4);
                    activeAmt = customAmt;
                    activeAmtLoc = activeAmt.multiply(rate);
                    this.id_amt.put(key, null);
                } else {
                    customAmt = customAmt.subtract(activeAmt);
                    this.id_amt.put(key, customAmt);
                }
            }
            return new BigDecimal[]{activeAmt, activeAmtLoc};
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void initSplitQueueByPlan(Context ctx, Map planId_Amt) throws BOSException {
        this.id_amt = planId_Amt;
        ArrayList planIds = new ArrayList();
        Set es = planId_Amt.entrySet();
        for (Map.Entry en : es) {
            planIds.add(en.getKey());
        }
        this.initSplitQueue(ctx, false, planIds);
    }

    public void initSplitQueueByEntry(Context ctx, List entryIds) throws BOSException {
        this.initSplitQueue(ctx, true, entryIds);
    }

    private String getCondition(boolean isByEntry, List ids) {
        StringBuffer buf = new StringBuffer();
        buf.append(isByEntry ? "fEntryId" : "fPlanId").append(" in (");
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            buf.append("'").append(ids.get(i)).append("',");
        }
        buf.replace(buf.length() - 1, buf.length(), ")");
        return buf.toString();
    }

    public void setSplitQueue(String entryId) {
        this.currentSplitQueue = (List)this.settleMap.get(entryId);
    }

    public boolean hasNext() {
        return this.currentSplitQueue != null && this.currentSplitQueue.size() != 0;
    }

    public BigDecimal getActiveAmt() {
        Map m = (Map)this.currentSplitQueue.get(0);
        return (BigDecimal)m.get("activeAmt");
    }

    public BigDecimal getActiveAmtLoc() {
        Map m = (Map)this.currentSplitQueue.get(0);
        return (BigDecimal)m.get("activeAmtLoc");
    }

    public Date getPayableDate() {
        Map m = (Map)this.currentSplitQueue.get(0);
        return (Date)m.get("payableDate");
    }

    public void dequeue() {
        this.currentSplitQueue.remove(0);
    }

    public EntityViewInfo getBillIdEvi() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.billIdSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        return evi;
    }
}

