/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillPlanCollection;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.app.webservice.AbstractOtherBillFacadeControllerBean;
import com.kingdee.eas.fi.ar.ArPrintBillEntryInfo;
import com.kingdee.eas.fi.ar.ArPrintBillInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.app.webservice.util.BillProertiesConvertor;
import com.kingdee.eas.fi.ar.app.webservice.util.BillPropertiesReader;
import com.kingdee.eas.fi.ar.app.webservice.util.WrongArgumentException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class OtherBillFacadeControllerBean
extends AbstractOtherBillFacadeControllerBean {
    private static final long serialVersionUID = -458889074084706685L;
    private static final String SUCCESS = "Y";
    private static final String FAILED = "N";
    private static final String BILLHEAD = "head";
    private static final String BILLENTRIS = "entry";
    private static final String BILLPLAN = "plan";
    private static final String OTHER = "other";
    private static final String BILLTYPE = "POtherBill";
    private static final String ENTRYXPATH = "//billEntries/entry";
    private static final String RECEIVEPLANXPATH = "//receivePlans/ReceivePlan";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.webservice.OtherBillFacadeControllerBean");
    private FilterItemInfo cuFilter = null;

    @Override
    protected String[] _submit(Context ctx, String xmlData) throws BOSException {
        this.cuFilter = null;
        BillPropertiesReader helper = null;
        try {
            helper = new BillPropertiesReader(xmlData, BILLTYPE);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)"wrong bill type");
            return new String[]{FAILED, e.getTypeNumber(), OTHER, "wrong bill type"};
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            return new String[]{FAILED, "1006", OTHER, e.getMessage()};
        }
        catch (SAXException e) {
            logger.debug((Object)e.getMessage());
            return new String[]{FAILED, "1006", OTHER, e.getMessage()};
        }
        Map head = helper.getHeadProperties("billHead");
        List entries = helper.getEntriesProperties(ENTRYXPATH);
        List payPlans = helper.getEntriesProperties(RECEIVEPLANXPATH);
        OtherBillInfo info = new OtherBillInfo();
        try {
            if (head == null) {
                return new String[]{FAILED, "1011", OTHER, "No head!"};
            }
            this.setHead(info, head, ctx);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)(e.getTypeNumber() + ":head field " + e.getField() + " error"));
            return new String[]{FAILED, e.getTypeNumber(), BILLHEAD, e.getField()};
        }
        try {
            if (entries.size() == 0) {
                return new String[]{FAILED, "1009", OTHER, "no entries"};
            }
            this.setEntries(info, entries, ctx);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)(e.getTypeNumber() + ":entry field " + e.getField() + " error"));
            return new String[]{FAILED, e.getTypeNumber(), BILLENTRIS, e.getField()};
        }
        try {
            if (payPlans.size() == 0) {
                return new String[]{FAILED, "1010", OTHER, "no receive plans"};
            }
            this.setPayPlans(info, payPlans);
        }
        catch (WrongArgumentException e) {
            logger.debug((Object)(e.getTypeNumber() + ":plan field " + e.getField() + " error"));
            return new String[]{FAILED, e.getTypeNumber(), BILLPLAN, e.getField()};
        }
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        try {
            iOtherBill.save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.error((Object)("APOtherBill save : " + e.getMessage()));
            return new String[]{FAILED, "1006", OTHER, "error occur when saving bill"};
        }
        return new String[]{SUCCESS};
    }

    private void setHead(OtherBillInfo info, Map head, Context ctx) throws BOSException, WrongArgumentException {
        this.verifyFieldNotNull("CU", head.get("CU"));
        CtrlUnitInfo cu = (CtrlUnitInfo)BillProertiesConvertor.getValueObject(head.get("CU"), CtrlUnitInfo.class, null, (Context)ctx);
        info.setCU(cu);
        this.verifyFieldNotNull("CU", cu);
        this.cuFilter = new FilterItemInfo("CU.id", (Object)cu.getId(), CompareType.EQUALS);
        info.setBillStatus(BillStatusEnum.SAVE);
        this.verifyFieldNotNull("creator", head.get("creator"));
        UserInfo userInfo = (UserInfo)BillProertiesConvertor.getValueObject(head.get("creator"), UserInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        this.verifyFieldNotNull("creator", userInfo);
        info.setCreator(userInfo);
        this.verifyFieldFormat("createTime", head.get("createTime"), "date");
        Timestamp createTime = BillProertiesConvertor.getTimestamp((String)((String)head.get("createTime")));
        info.setCreateTime(createTime);
        UserInfo lastUpdater = (UserInfo)BillProertiesConvertor.getValueObject(head.get("lastUpdateUser"), UserInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setLastUpdateUser(lastUpdater);
        if (!this.isNull(head.get("lastUpdateTime"))) {
            this.verifyFieldFormat("lastUpdateTime", head.get("lastUpdateTime"), "date");
        }
        Timestamp lastUpdateTime = BillProertiesConvertor.getTimestamp((String)((String)head.get("lastUpdateTime")));
        info.setLastUpdateTime(lastUpdateTime);
        this.verifyFieldNotNull("number", head.get("number"));
        info.setNumber((String)head.get("number"));
        this.verifyFieldFormat("bizDate", head.get("bizDate"), "date");
        Timestamp bizDate = BillProertiesConvertor.getTimestamp((String)((String)head.get("bizDate")));
        info.setBizDate(bizDate);
        UserInfo handler = (UserInfo)BillProertiesConvertor.getValueObject(head.get("handler"), UserInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setHandler(handler);
        String description = (String)head.get("description");
        info.setDescription(description);
        boolean hasEffected = BillProertiesConvertor.getBool((String)((String)head.get("hasEffected")));
        info.setHasEffected(hasEffected);
        UserInfo auditor = (UserInfo)BillProertiesConvertor.getValueObject(head.get("auditor"), UserInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setAuditor(auditor);
        if (!this.isNull(head.get("auditDate"))) {
            this.verifyFieldFormat("auditDate", head.get("auditDate"), "date");
        }
        Timestamp auditDate = BillProertiesConvertor.getTimestamp((String)((String)head.get("auditDate")));
        info.setAuditDate(auditDate);
        info.setSourceBillId((String)head.get("sourceBillId"));
        info.setSourceFunction((String)head.get("sourceFunction"));
        this.verifyFieldNotNull("company", head.get("company"));
        CompanyOrgUnitInfo comInfo = (CompanyOrgUnitInfo)BillProertiesConvertor.getValueObject(head.get("company"), CompanyOrgUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        this.verifyFieldNotNull("company", comInfo);
        info.setCompany(comInfo);
        info.setBillDate(info.getBizDate());
        this.verifyFieldNotNull("asstActType", head.get("asstActType"));
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)BillProertiesConvertor.getValueObject(head.get("asstActType"), AsstActTypeInfo.class, null, (Context)ctx);
        this.verifyFieldNotNull("asstActType", asstActTypeInfo);
        info.setAsstActType(asstActTypeInfo);
        this.setAsstActor(ctx, info, head, asstActTypeInfo);
        this.verifyFieldNotNull("currency", head.get("currency"));
        CurrencyInfo curInfo = (CurrencyInfo)BillProertiesConvertor.getValueObject(head.get("currency"), CurrencyInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        this.verifyFieldNotNull("currency", curInfo);
        info.setCurrency(curInfo);
        AdminOrgUnitInfo aouInfo = (AdminOrgUnitInfo)BillProertiesConvertor.getValueObject(head.get("adminOrgUnit"), AdminOrgUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setAdminOrgUnit(aouInfo);
        PersonInfo person = (PersonInfo)BillProertiesConvertor.getValueObject(head.get("person"), PersonInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setPerson(person);
        this.verifyFieldFormat("exchangeRate", head.get("exchangeRate"), "bigdecimal");
        info.setExchangeRate(BillProertiesConvertor.getBigDecimal((String)((String)head.get("exchangeRate"))));
        SettlementTypeInfo settleType = (SettlementTypeInfo)BillProertiesConvertor.getValueObject(head.get("settleType"), SettlementTypeInfo.class, null, (Context)ctx);
        info.setSettleType(settleType);
        this.verifyFieldFormat("amount", head.get("amount"), "bigdecimal");
        info.setAmount(BillProertiesConvertor.getBigDecimal((String)((String)head.get("amount"))));
        this.verifyFieldFormat("amountLocal", head.get("amountLocal"), "bigdecimal");
        info.setAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)head.get("amountLocal"))));
        info.setAbstractName((String)head.get("abstractName"));
        if (!this.isNull(head.get("verifyAmount"))) {
            this.verifyFieldFormat("verifyAmount", head.get("verifyAmount"), "bigdecimal");
        }
        info.setVerifyAmount(BillProertiesConvertor.getBigDecimal((String)((String)head.get("verifyAmount"))));
        if (!this.isNull(head.get("verifyAmountLocal"))) {
            this.verifyFieldFormat("verifyAmountLocal", head.get("verifyAmountLocal"), "bigdecimal");
        }
        info.setVerifyAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)head.get("verifyAmountLocal"))));
        this.verifyFieldFormat("unVerifyAmount", head.get("unVerifyAmount"), "bigdecimal");
        info.setUnVerifyAmount(BillProertiesConvertor.getBigDecimal((String)((String)head.get("unVerifyAmount"))));
        this.verifyFieldFormat("unVerifyAmountLocal", head.get("unVerifyAmountLocal"), "bigdecimal");
        info.setUnVerifyAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)head.get("unVerifyAmountLocal"))));
        info.setFiVouchered(false);
        this.verifyFieldFormat("sourceBillType", head.get("sourceBillType"), "int");
        VerificateBillTypeEnum sourceBillType = VerificateBillTypeEnum.getEnum((int)BillProertiesConvertor.getInt((String)((String)head.get("sourceBillType"))));
        this.verifyFieldNotNull("sourceBillType", sourceBillType);
        info.setSourceBillType(sourceBillType);
        CashDiscountInfo cashDiscount = (CashDiscountInfo)BillProertiesConvertor.getValueObject(head.get("cashDiscount"), CashDiscountInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setCashDiscount(cashDiscount);
        if (!this.isNull(head.get("isReversed"))) {
            this.verifyFieldFormat("isReversed", head.get("isReversed"), "bool");
        }
        info.setIsReversed(BillProertiesConvertor.getBool((String)((String)head.get("isReversed"))));
        if (!this.isNull(head.get("isReverseBill"))) {
            this.verifyFieldFormat("isReverseBill", head.get("isReverseBill"), "bool");
        }
        info.setIsReverseBill(BillProertiesConvertor.getBool((String)((String)head.get("isReverseBill"))));
        UserInfo accountant = (UserInfo)BillProertiesConvertor.getValueObject(head.get("accountant"), UserInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setAccountant(accountant);
        if (!this.isNull(head.get("isTransBill"))) {
            this.verifyFieldFormat("isTransBill", head.get("isTransBill"), "bool");
        }
        boolean isTransBill = BillProertiesConvertor.getBool((String)((String)head.get("isTransBill")));
        info.setIsTransBill(isTransBill);
        if (!this.isNull(head.get("isImportBill"))) {
            this.verifyFieldFormat("isImportBill", head.get("isImportBill"), "bool");
        }
        boolean isImportBill = BillProertiesConvertor.getBool((String)((String)head.get("isImportBill")));
        info.setIsImportBill(isImportBill);
        this.verifyFieldNotNull("bizType", head.get("bizType"));
        BizTypeInfo bizType = (BizTypeInfo)BillProertiesConvertor.getValueObject(head.get("bizType"), BizTypeInfo.class, null, (Context)ctx);
        this.verifyFieldNotNull("bizType", bizType);
        info.setBizType(bizType);
        this.verifyFieldNotNull("paymentType", head.get("paymentType"));
        PaymentTypeInfo paymentTypeInfo = (PaymentTypeInfo)BillProertiesConvertor.getValueObject(head.get("paymentType"), PaymentTypeInfo.class, null, (Context)ctx);
        this.verifyFieldNotNull("paymentType", paymentTypeInfo);
        info.setPaymentType(paymentTypeInfo);
        this.verifyFieldFormat("lastExhangeRate", head.get("lastExhangeRate"), "bigdecimal");
        info.setLastExhangeRate(BillProertiesConvertor.getBigDecimal((String)((String)head.get("lastExhangeRate"))));
        this.verifyFieldFormat("totalAmount", head.get("totalAmount"), "bigdecimal");
        info.setTotalAmount(BillProertiesConvertor.getBigDecimal((String)((String)head.get("totalAmount"))));
        if (!this.isNull(head.get("totalTax"))) {
            this.verifyFieldFormat("totalTax", head.get("totalTax"), "bigdecimal");
        }
        info.setTotalTax(BillProertiesConvertor.getBigDecimal((String)((String)head.get("totalTax"))));
        this.verifyFieldFormat("totalTaxAmount", head.get("totalTaxAmount"), "bigdecimal");
        info.setTotalTax(BillProertiesConvertor.getBigDecimal((String)((String)head.get("totalTaxAmount"))));
        if (!this.isNull(head.get("isExchanged"))) {
            this.verifyFieldFormat("isExchanged", head.get("isExchanged"), "bool");
        }
        info.setIsExchanged(BillProertiesConvertor.getBool((String)((String)head.get("isExchanged"))));
        if (!this.isNull(head.get("isInitializeBill"))) {
            this.verifyFieldFormat("isInitializeBill", head.get("isInitializeBill"), "bool");
        }
        info.setIsInitializeBill(BillProertiesConvertor.getBool((String)((String)head.get("isInitializeBill"))));
        this.verifyFieldFormat("redBlueType", head.get("redBlueType"), "bool");
        info.setRedBlueType(BillProertiesConvertor.getBool((String)((String)head.get("redBlueType"))));
        if (!this.isNull(head.get("year"))) {
            this.verifyFieldFormat("year", head.get("year"), "int");
        }
        info.setYear(BillProertiesConvertor.getInt((String)((String)head.get("year"))));
        if (!this.isNull(head.get("period"))) {
            this.verifyFieldFormat("period", head.get("period"), "int");
        }
        info.setPeriod(BillProertiesConvertor.getInt((String)((String)head.get("period"))));
        if (!this.isNull(head.get("isSCMBill"))) {
            this.verifyFieldFormat("isSCMBill", head.get("isSCMBill"), "bool");
        }
        info.setIsSCMBill(BillProertiesConvertor.getBool((String)((String)head.get("isSCMBill"))));
        info.setIsInTax(BillProertiesConvertor.getBool((String)((String)head.get("isInTax"))));
        PurchaseOrgUnitInfo purOrg = (PurchaseOrgUnitInfo)BillProertiesConvertor.getValueObject(head.get("purOrg"), PurchaseOrgUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setPurOrg(purOrg);
        this.verifyFieldFormat("billType", head.get("billType"), "int");
        OtherBillType otherBillType = OtherBillType.getEnum((int)BillProertiesConvertor.getInt((String)((String)head.get("billType"))));
        this.verifyFieldNotNull("billType", otherBillType);
        info.setBillType(otherBillType);
        PurchaseGroupInfo purGroup = (PurchaseGroupInfo)BillProertiesConvertor.getValueObject(head.get("purchaseGroup"), PurchaseGroupInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        info.setPurchaseGroup(purGroup);
    }

    private void setAsstActor(Context ctx, OtherBillInfo info, Map head, AsstActTypeInfo asstActTypeInfo) throws BOSException, WrongArgumentException {
        this.verifyFieldNotNull("asstActNumber", head.get("asstActNumber"));
        info.setAsstActNumber((String)head.get("asstActNumber"));
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", head.get("asstActNumber"), CompareType.EQUALS));
        evInfo.setFilter(filter);
        if (asstActTypeInfo == null) {
            return;
        }
        String relationDataObject = asstActTypeInfo.getRealtionDataObject();
        BOSObjectType bosType = null;
        if (StringUtils.isEmpty((String)relationDataObject)) {
            return;
        }
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean fMaterial = relationDataObject.equalsIgnoreCase("T_BD_Material");
        if (relationDataObject.equalsIgnoreCase("T_BD_AccountBanks")) {
            bosType = new AccountBankInfo().getBOSType();
        } else if (fCust) {
            bosType = new CustomerInfo().getBOSType();
        } else if (fSupp) {
            bosType = new SupplierInfo().getBOSType();
        } else if (fMaterial) {
            bosType = new MaterialInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_BD_Person")) {
            bosType = new PersonInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Company")) {
            bosType = new CompanyOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_CostCenter")) {
            bosType = new CostCenterOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Admin")) {
            bosType = new AdminOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Purchase")) {
            bosType = new PurchaseOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Storage")) {
            bosType = new StorageOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_Sale")) {
            bosType = new SaleOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_ORG_ProfitCenter")) {
            bosType = new ProfitCenterOrgUnitInfo().getBOSType();
        } else if (relationDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
            bosType = new GeneralAsstActTypeInfo().getBOSType();
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            IObjectCollection objValCol = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, evInfo);
            if (objValCol != null && objValCol.getObject(0) != null) {
                IObjectValue objVal = objValCol.getObject(0);
                info.setAsstActID(objVal.getString("id"));
                info.setAsstActName(objVal.getString("name"), ctx.getLocale());
                info.setAsstActNumber(objVal.getString("number"));
            }
        }
        catch (BOSException e) {
            throw new WrongArgumentException("asstActNumber", "1005");
        }
    }

    private void setEntries(OtherBillInfo info, List entries, Context ctx) throws BOSException, WrongArgumentException {
        OtherBillentryCollection collection = info.getEntry();
        Iterator entryIterator = entries.iterator();
        OtherBillType billType = info.getBillType();
        boolean isInvoice = billType.equals((Object)OtherBillType.InvoiceBill);
        OtherBillentryInfo entryInfo = null;
        while (entryIterator.hasNext()) {
            Map entry = (Map)entryIterator.next();
            entryInfo = this.getEntryInfo(entry, isInvoice, ctx);
            collection.add(entryInfo);
        }
    }

    private OtherBillentryInfo getEntryInfo(Map entry, boolean isInvoice, Context ctx) throws BOSException, WrongArgumentException {
        OtherBillentryInfo entryInfo = new OtherBillentryInfo();
        this.verifyFieldFormat("seq", entry.get("seq"), "int");
        entryInfo.setSeq(BillProertiesConvertor.getInt((String)((String)entry.get("seq"))));
        if (isInvoice) {
            this.verifyFieldNotNull("material", entry.get("material"));
            MaterialInfo mInfo = (MaterialInfo)BillProertiesConvertor.getValueObject(entry.get("material"), MaterialInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
            this.verifyFieldNotNull("material", mInfo);
            entryInfo.setMaterial(mInfo);
            entryInfo.setMeasureUnit(mInfo.getBaseUnit());
        } else {
            this.verifyFieldNotNull("expenseItem", entry.get("expenseItem"));
            ExpenseTypeInfo eInfo = (ExpenseTypeInfo)BillProertiesConvertor.getValueObject(entry.get("expenseItem"), ExpenseTypeInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
            this.verifyFieldNotNull("expenseItem", eInfo);
            entryInfo.setExpenseItem(eInfo);
        }
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)BillProertiesConvertor.getValueObject(entry.get("recSendOrgUnit"), StorageOrgUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setRecSendOrgUnit(storageOrgInfo);
        this.verifyFieldNotNull("measureUnit", entry.get("measureUnit"));
        MeasureUnitInfo measureUnit = (MeasureUnitInfo)BillProertiesConvertor.getValueObject(entry.get("measureUnit"), MeasureUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        this.verifyFieldNotNull("measureUnit", measureUnit);
        entryInfo.setMeasureUnit(measureUnit);
        AsstAttrValueInfo asstAttrValueInfo = (AsstAttrValueInfo)BillProertiesConvertor.getValueObject(entry.get("assistProperty"), AsstAttrValueInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setAssistProperty(asstAttrValueInfo);
        AccountViewInfo accountInfo = (AccountViewInfo)BillProertiesConvertor.getValueObject(entry.get("account"), AccountViewInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setAccount(accountInfo);
        this.verifyFieldFormat("recievePayAmount", entry.get("recievePayAmount"), "bigdecimal");
        entryInfo.setRecievePayAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("recievePayAmount"))));
        this.verifyFieldFormat("recievePayAmountLocal", entry.get("recievePayAmountLocal"), "bigdecimal");
        entryInfo.setRecievePayAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("recievePayAmountLocal"))));
        if (!this.isNull(entry.get("verifyAmount"))) {
            this.verifyFieldFormat("verifyAmount", entry.get("verifyAmount"), "bigdecimal");
        }
        entryInfo.setVerifyAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("verifyAmount"))));
        if (!this.isNull(entry.get("verifyAmountLocal"))) {
            this.verifyFieldFormat("verifyAmountLocal", entry.get("verifyAmountLocal"), "bigdecimal");
        }
        entryInfo.setVerifyAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("verifyAmountLocal"))));
        this.verifyFieldFormat("unVerifyAmount", entry.get("unVerifyAmount"), "bigdecimal");
        entryInfo.setUnVerifyAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("unVerifyAmount"))));
        this.verifyFieldFormat("unVerifyAmountLocal", entry.get("unVerifyAmountLocal"), "bigdecimal");
        entryInfo.setUnVerifyAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("unVerifyAmountLocal"))));
        if (!this.isNull(entry.get("lockVerifyAmt"))) {
            this.verifyFieldFormat("lockVerifyAmt", entry.get("lockVerifyAmt"), "bigdecimal");
        }
        entryInfo.setLockVerifyAmt(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("lockVerifyAmt"))));
        if (!this.isNull(entry.get("lockVerifyAmtLocal"))) {
            this.verifyFieldFormat("lockVerifyAmtLocal", entry.get("lockVerifyAmtLocal"), "bigdecimal");
        }
        entryInfo.setLockVerifyAmtLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("lockVerifyAmtLocal"))));
        this.verifyFieldFormat("lockUnVerifyAmt", entry.get("lockUnVerifyAmt"), "bigdecimal");
        entryInfo.setLockUnVerifyAmt(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("lockUnVerifyAmt"))));
        this.verifyFieldFormat("lockUnVerifyAmtLocal", entry.get("lockUnVerifyAmtLocal"), "bigdecimal");
        entryInfo.setLockUnVerifyAmtLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("lockUnVerifyAmtLocal"))));
        entryInfo.setRemark((String)entry.get("remark"));
        this.verifyFieldFormat("quantity", entry.get("quantity"), "bigdecimal");
        entryInfo.setQuantity(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("quantity"))));
        this.verifyFieldFormat("price", entry.get("price"), "bigdecimal");
        entryInfo.setPrice(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("price"))));
        if (!this.isNull(entry.get("taxPrice"))) {
            this.verifyFieldFormat("taxPrice", entry.get("taxPrice"), "bigdecimal");
        }
        entryInfo.setTaxPrice(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("taxPrice"))));
        this.verifyFieldFormat("actualPrice", entry.get("actualPrice"), "bigdecimal");
        entryInfo.setActualPrice(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("actualPrice"))));
        if (!this.isNull(entry.get("discountRate"))) {
            this.verifyFieldFormat("discountRate", entry.get("discountRate"), "bigdecimal");
        }
        entryInfo.setDiscountRate(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("discountRate"))));
        if (!this.isNull(entry.get("discountAmount"))) {
            this.verifyFieldFormat("discountAmount", entry.get("discountAmount"), "bigdecimal");
        }
        entryInfo.setDiscountAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("discountAmount"))));
        if (!this.isNull(entry.get("discountAmountLocal"))) {
            this.verifyFieldFormat("discountAmountLocal", entry.get("discountAmountLocal"), "bigdecimal");
        }
        entryInfo.setDiscountAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("discountAmountLocal"))));
        if (!this.isNull(entry.get("taxRate"))) {
            this.verifyFieldFormat("taxRate", entry.get("taxRate"), "bigdecimal");
        }
        entryInfo.setTaxRate(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("taxRate"))));
        if (!this.isNull(entry.get("taxAmount"))) {
            this.verifyFieldFormat("taxAmount", entry.get("taxAmount"), "bigdecimal");
        }
        entryInfo.setTaxAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("taxAmount"))));
        if (!this.isNull(entry.get("taxAmountLocal"))) {
            this.verifyFieldFormat("taxAmountLocal", entry.get("taxAmountLocal"), "bigdecimal");
        }
        entryInfo.setTaxAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("taxAmountLocal"))));
        entryInfo.setRemark((String)entry.get("sourceBillId"));
        entryInfo.setRemark((String)entry.get("sourceBillEntryId"));
        this.verifyFieldFormat("amount", entry.get("amount"), "bigdecimal");
        entryInfo.setAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("amount"))));
        this.verifyFieldFormat("amountLocal", entry.get("amountLocal"), "bigdecimal");
        entryInfo.setAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("amountLocal"))));
        entryInfo.setRemark((String)entry.get("sourceBillAsstActID"));
        if (!this.isNull(entry.get("hisUnVerifyAmount"))) {
            this.verifyFieldFormat("hisUnVerifyAmount", entry.get("hisUnVerifyAmount"), "bigdecimal");
        }
        entryInfo.setHisUnVerifyAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("hisUnVerifyAmount"))));
        if (!this.isNull(entry.get("hisUnVerifyAmountLocal"))) {
            this.verifyFieldFormat("hisUnVerifyAmountLocal", entry.get("hisUnVerifyAmountLocal"), "bigdecimal");
        }
        entryInfo.setHisUnVerifyAmountLocal(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("hisUnVerifyAmountLocal"))));
        BillTypeInfo billTypeInfo = (BillTypeInfo)BillProertiesConvertor.getValueObject(entry.get("coreBillType"), BillTypeInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setCoreBillType(billTypeInfo);
        entryInfo.setRemark((String)entry.get("coreBillId"));
        entryInfo.setRemark((String)entry.get("coreBillEntryId"));
        entryInfo.setRemark((String)entry.get("coreBillNumber"));
        entryInfo.setRemark((String)entry.get("coreBillEntrySeq"));
        entryInfo.setRemark((String)entry.get("trackNumber"));
        MeasureUnitInfo muInfo = (MeasureUnitInfo)BillProertiesConvertor.getValueObject(entry.get("assistUnit"), MeasureUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setAssistUnit(muInfo);
        if (!this.isNull(entry.get("assistQty"))) {
            this.verifyFieldFormat("assistQty", entry.get("assistQty"), "bigdecimal");
        }
        entryInfo.setAssistQty(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("assistQty"))));
        AccountViewInfo oppAccountInfo = (AccountViewInfo)BillProertiesConvertor.getValueObject(entry.get("oppAccount"), AccountViewInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setOppAccount(oppAccountInfo);
        DiscountModeEnum dmEnum = DiscountModeEnum.getEnum((int)BillProertiesConvertor.getInt((String)((String)entry.get("discountType"))));
        if (dmEnum != null) {
            entryInfo.setDiscountType(dmEnum);
        }
        if (!this.isNull(entry.get("wittenOffBaseQty"))) {
            this.verifyFieldFormat("wittenOffBaseQty", entry.get("wittenOffBaseQty"), "bigdecimal");
        }
        entryInfo.setWittenOffBaseQty(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("wittenOffBaseQty"))));
        if (!this.isNull(entry.get("localWrittenOffAmount"))) {
            this.verifyFieldFormat("localWrittenOffAmount", entry.get("localWrittenOffAmount"), "bigdecimal");
        }
        entryInfo.setLocalWrittenOffAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("localWrittenOffAmount"))));
        this.verifyFieldFormat("unwriteOffBaseQty", entry.get("unwriteOffBaseQty"), "bigdecimal");
        entryInfo.setUnwriteOffBaseQty(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("unwriteOffBaseQty"))));
        this.verifyFieldFormat("localUnwriteOffAmount", entry.get("localUnwriteOffAmount"), "bigdecimal");
        entryInfo.setLocalUnwriteOffAmount(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("localUnwriteOffAmount"))));
        if (!this.isNull(entry.get("invoicedBaseQty"))) {
            this.verifyFieldFormat("invoicedBaseQty", entry.get("invoicedBaseQty"), "bigdecimal");
        }
        entryInfo.setInvoicedBaseQty(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("invoicedBaseQty"))));
        if (!this.isNull(entry.get("invoicedAmt"))) {
            this.verifyFieldFormat("invoicedAmt", entry.get("invoicedAmt"), "bigdecimal");
        }
        entryInfo.setInvoicedAmt(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("invoicedAmt"))));
        if (!this.isNull(entry.get("isInvoiced"))) {
            this.verifyFieldFormat("isInvoiced", entry.get("isInvoiced"), "bool");
        }
        entryInfo.setIsInvoiced(BillProertiesConvertor.getBool((String)((String)entry.get("isInvoiced"))));
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)BillProertiesConvertor.getValueObject(entry.get("baseUnit"), MeasureUnitInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setMeasureUnit(measureUnitInfo);
        if (!this.isNull(entry.get("baseQty"))) {
            this.verifyFieldFormat("baseQty", entry.get("baseQty"), "bigdecimal");
        }
        entryInfo.setBaseQty(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("baseQty"))));
        this.verifyFieldFormat("realPrice", entry.get("realPrice"), "bigdecimal");
        entryInfo.setRealPrice(BillProertiesConvertor.getBigDecimal((String)((String)entry.get("realPrice"))));
        ArPrintBillInfo apPrintBillInfo = (ArPrintBillInfo)BillProertiesConvertor.getValueObject(entry.get("apPrintBill"), ArPrintBillInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setApPrintBill(apPrintBillInfo);
        ArPrintBillEntryInfo apPrintBillEntryInfo = (ArPrintBillEntryInfo)BillProertiesConvertor.getValueObject(entry.get("apPrintBillEntry"), ArPrintBillEntryInfo.class, (FilterItemInfo)this.cuFilter, (Context)ctx);
        entryInfo.setApPrintBillEntry(apPrintBillEntryInfo);
        return entryInfo;
    }

    private void setPayPlans(OtherBillInfo info, List receivePlans) throws WrongArgumentException {
        OtherBillPlanCollection planCollection = info.getPayPlan();
        Iterator it = receivePlans.iterator();
        Map receivePlanEntry = null;
        while (it.hasNext()) {
            receivePlanEntry = (Map)it.next();
            OtherBillPlanInfo planInfo = this.getOtherBillPlanEntry(receivePlanEntry);
            planCollection.add(planInfo);
        }
    }

    private OtherBillPlanInfo getOtherBillPlanEntry(Map plan) throws WrongArgumentException {
        OtherBillPlanInfo planInfo = new OtherBillPlanInfo();
        this.verifyFieldFormat("seq", plan.get("seq"), "int");
        planInfo.setSeq(BillProertiesConvertor.getInt((String)((String)plan.get("seq"))));
        this.verifyFieldFormat("receivePayDate", plan.get("receivePayDate"), "date");
        planInfo.setRecievePayDate(BillProertiesConvertor.getTimestamp((String)((String)plan.get("receivePayDate"))));
        this.verifyFieldFormat("receivePayAmount", plan.get("receivePayAmount"), "bigdecimal");
        planInfo.setRecievePayAmount(BillProertiesConvertor.getBigDecimal((String)((String)plan.get("receivePayAmount"))));
        this.verifyFieldFormat("receivePayAmountLocal", plan.get("receivePayAmountLocal"), "bigdecimal");
        planInfo.setRecievePayAmount(BillProertiesConvertor.getBigDecimal((String)((String)plan.get("receivePayAmountLocal"))));
        if (!this.isNull(plan.get("verifyAmout"))) {
            this.verifyFieldFormat("verifyAmout", plan.get("verifyAmout"), "bigdecimal");
        }
        planInfo.setRecievePayAmount(BillProertiesConvertor.getBigDecimal((String)((String)plan.get("verifyAmout"))));
        if (!this.isNull(plan.get("verifyAmoutLocal"))) {
            this.verifyFieldFormat("verifyAmoutLocal", plan.get("verifyAmoutLocal"), "bigdecimal");
        }
        planInfo.setRecievePayAmount(BillProertiesConvertor.getBigDecimal((String)((String)plan.get("verifyAmoutLocal"))));
        planInfo.setRemark((String)plan.get("remark"));
        return planInfo;
    }

    private void verifyFieldFormat(String name, Object value, String dataType) throws WrongArgumentException {
        if (dataType.equals("int")) {
            String intString = (String)value;
            if (!Pattern.matches("[+|-]?\\d+", intString)) {
                throw new WrongArgumentException(name, "1002");
            }
        } else if (dataType.equals("bigdecimal")) {
            String bigDecimalStirng = (String)value;
            if (!Pattern.matches("[-|+]?\\d+(.\\d+)?(e[-|+]\\d+)?", bigDecimalStirng)) {
                throw new WrongArgumentException(name, "1004");
            }
        } else if (dataType.equals("date")) {
            String dateString = (String)value;
            if (!Pattern.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}", dateString)) {
                throw new WrongArgumentException(name, "1001");
            }
        } else if (dataType.equals("bool") && !value.equals("true") && !value.equals("false")) {
            throw new WrongArgumentException(name, "1003");
        }
    }

    private void verifyFieldNotNull(String name, Object value) throws WrongArgumentException {
        if (this.isNull(value)) {
            throw new WrongArgumentException(name, "1005");
        }
    }

    private boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        return false;
    }
}

