/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.util;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public abstract class APPrintDataSource
implements BOSQueryDelegate {
    private static String ENTRY = "entry";
    private static final String ARAPRESOURCE = "com.kingdee.eas.fi.arap.ARAPAutoGenerateResource";
    public static final int DT_DECIMAL = 1;
    public static final int DT_DATE = 2;
    public static final int DT_ENUM = 3;
    public static final int DT_ELSE = 4;
    protected final AbstractObjectCollection billCol;
    private final DateFormat df;
    private final Properties decimalPro;
    private final Properties integerPro;
    private final Properties numberPro;

    public APPrintDataSource(AbstractObjectCollection bills) {
        this.billCol = bills;
        this.df = DateFormat.getDateInstance(1, SysContext.getSysContext().getLocale());
        this.decimalPro = APPrintDataSource.getDecimalUnitMapping();
        this.integerPro = APPrintDataSource.getIntegerUnitMapping();
        this.numberPro = APPrintDataSource.getNumberMapping();
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        DynamicRowSet drs = null;
        try {
            ColDesc[] desc = this.getColDesc();
            drs = new DynamicRowSet(desc.length + 1);
            ColInfo ciId = new ColInfo();
            ciId.colType = 12;
            ciId.columnName = "id";
            drs.setColInfo(1, ciId);
            for (int i = 0; i < desc.length; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = desc[i].getColId();
                ci.nullable = 1;
                drs.setColInfo(i + 2, ci);
            }
            drs.beforeFirst();
            Iterator itrBill = this.billCol.iterator();
            int billCount = 0;
            while (itrBill.hasNext()) {
                BillBaseInfo bill = (BillBaseInfo)itrBill.next();
                int srcType = bill.getInt("sourceBillType");
                boolean fMaterial = srcType != -1;
                for (CoreBaseInfo entry : (AbstractObjectCollection)bill.get(ENTRY)) {
                    drs.moveToInsertRow();
                    APPrintDataSource.clearRow((IRowSet)drs);
                    drs.updateString("id", Integer.toString(billCount));
                    for (int i = 0; i < desc.length; ++i) {
                        this.fillCol((IRowSet)drs, desc[i], bill, entry);
                    }
                    this.rowFilled((IRowSet)drs, bill, entry);
                    drs.updateString("fShowMaterail", fMaterial ? "true" : "false");
                    drs.insertRow();
                }
                ++billCount;
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            return null;
        }
        return drs;
    }

    public void fillCol(IRowSet rs, ColDesc d, BillBaseInfo bill, CoreBaseInfo entry) throws Exception {
        Object prop = APPrintDataSource.getProp(bill, entry, d.getPropName());
        if (prop == null) {
            return;
        }
        String val = null;
        switch (d.getDataType()) {
            case 1: {
                BigDecimal dec = TypeConversionUtils.objToBigDecimal((Object)prop);
                if (d.getExtraInfo() == null) {
                    val = this.formatNumber(dec);
                    break;
                }
                String fmt = d.getExtraInfo().toString().trim();
                if (fmt.startsWith("$")) {
                    val = this.getChineseFormat(dec);
                    break;
                }
                if (Character.isDigit(fmt.charAt(0))) {
                    val = this.formatNumber(dec, Integer.parseInt(fmt));
                    break;
                }
                Object prop1 = APPrintDataSource.getProp(bill, entry, fmt);
                if (prop1 == null) {
                    throw new Exception("The value of the property to be used as pattern should not be null!");
                }
                val = this.formatNumber(dec, Integer.parseInt(prop1.toString()));
                break;
            }
            case 2: {
                val = this.formatDate(TypeConversionUtils.objToDate((Object)prop));
                break;
            }
            case 3: {
                val = EnumUtil.getEnum((Class)d.getExtraInfo(), prop).toString();
                break;
            }
            case 4: {
                if (d.getExtraInfo() == null) {
                    val = prop.toString();
                    break;
                }
                String prefix = d.getPropName() == null ? "" : d.getPropName() + ".";
                String fmt = d.getExtraInfo().toString();
                StringBuffer buf = new StringBuffer();
                int n = fmt.length();
                for (int i = 0; i < n; ++i) {
                    char c = fmt.charAt(i);
                    if (c == '{') {
                        char nc;
                        StringBuffer sb = new StringBuffer(prefix);
                        while (++i < n && (nc = fmt.charAt(i)) != '}') {
                            sb.append(nc);
                        }
                        Object prop1 = APPrintDataSource.getProp(bill, entry, sb.toString());
                        if (prop1 == null) continue;
                        buf.append(prop1.toString());
                        continue;
                    }
                    buf.append(c);
                }
                val = buf.toString();
                break;
            }
            default: {
                throw new Exception("Unsupported data type!");
            }
        }
        rs.updateString(d.getColId(), val);
    }

    protected static Object getProp(BillBaseInfo bill, CoreBaseInfo entry, String pn) throws Exception {
        BillBaseInfo obj = bill;
        if ((pn = pn.trim()).startsWith(ENTRY + ".")) {
            pn = pn.substring(ENTRY.length() + 1);
            obj = entry;
        }
        String[] path = pn.split("\\.");
        for (int i = 0; i < path.length - 1; ++i) {
            Object p = obj.get(path[i].trim());
            if (p == null) {
                return null;
            }
            if (!(p instanceof CoreBaseInfo)) {
                throw new Exception("The property in the path should be instance of CoreBaseInfo or its subclasses!");
            }
            obj = (CoreBaseInfo)p;
        }
        return obj.get(path[path.length - 1].trim());
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int n = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= n; ++i) {
            rs.updateString(i, null);
        }
    }

    protected String formatNumber(BigDecimal val) {
        if (val == null) {
            return "";
        }
        return APPrintDataSource.withCommaAndTrim(val, val.scale());
    }

    private static String withCommaAndTrim(BigDecimal val, int scale) {
        String pattern = "#,##0.##########";
        if (scale > 10) {
            StringBuffer buf = new StringBuffer(pattern);
            for (int i = 10; i < scale; ++i) {
                buf.append("#");
            }
            pattern = buf.toString();
        }
        return new DecimalFormat(pattern).format(val);
    }

    protected String formatNumber(BigDecimal val, int scale) {
        if (val == null) {
            return "";
        }
        return APPrintDataSource.withComma(val.setScale(scale, 4), scale);
    }

    private static String withComma(BigDecimal val, int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return new DecimalFormat(pattern).format(val);
    }

    protected String getChineseFormat(BigDecimal number) {
        boolean integerEmpty;
        if (number == null) {
            return "";
        }
        String nagative = "";
        boolean isNagative = false;
        if (number.toString().indexOf("-") >= 0) {
            nagative = APPrintDataSource.getResource("174_APPrintDataSource");
            isNagative = true;
        }
        String valTemp = number.toString();
        if (isNagative) {
            valTemp = valTemp.replace('-', ' ').trim();
        }
        int dotIndex = valTemp.indexOf(".");
        String integerStr = "";
        String integerTempStr = null;
        String decimalStr = "";
        String decimalTempStr = null;
        if (dotIndex == -1) {
            integerTempStr = valTemp;
        } else {
            integerTempStr = valTemp.substring(0, dotIndex);
            decimalTempStr = valTemp.substring(dotIndex + 1);
        }
        if (integerTempStr != null) {
            int integerLen = integerTempStr.length() - 1;
            boolean zeroAttached = false;
            for (int i = integerLen; i >= 0; --i) {
                String index = String.valueOf(i);
                String str = String.valueOf(integerTempStr.charAt(integerLen - i));
                String numStr = this.numberPro.getProperty(str);
                String uombStr = this.integerPro.getProperty(index);
                boolean needed = false;
                if (uombStr.startsWith("*")) {
                    needed = true;
                    uombStr = uombStr.substring(1);
                }
                if ("0".equals(str)) {
                    if (zeroAttached) {
                        numStr = "";
                        if (needed) {
                            zeroAttached = false;
                            integerStr = integerStr.substring(0, integerStr.length() - 1);
                        } else {
                            uombStr = "";
                        }
                    } else if (!needed) {
                        zeroAttached = true;
                        uombStr = "";
                    } else {
                        zeroAttached = false;
                        numStr = "";
                    }
                } else {
                    zeroAttached = false;
                }
                integerStr = integerStr + numStr + uombStr;
            }
        }
        boolean bl = integerEmpty = integerStr.length() < 2;
        if (integerEmpty) {
            integerStr = "";
        }
        boolean decimalEmpty = true;
        if (decimalTempStr != null) {
            int n;
            int decimalLen = decimalTempStr.length();
            n = decimalLen > (n = this.decimalPro.size()) ? n : decimalLen;
            boolean zeroAttached = false;
            boolean ignoreLeadingZero = true;
            for (int j = 0; j < n; ++j) {
                String index = String.valueOf(j);
                String str = String.valueOf(decimalTempStr.charAt(j));
                String numStr = this.numberPro.getProperty(str);
                String uombStr = this.decimalPro.getProperty(index);
                if ("0".equals(str)) {
                    if (zeroAttached) {
                        numStr = "";
                        uombStr = "";
                        if (j == n - 1) {
                            decimalStr = decimalStr.substring(0, decimalStr.length() - 1);
                        }
                    } else {
                        if (j < n - 1 && !ignoreLeadingZero) {
                            zeroAttached = true;
                        } else {
                            numStr = "";
                        }
                        uombStr = "";
                    }
                } else {
                    zeroAttached = false;
                    ignoreLeadingZero = false;
                }
                decimalStr = decimalStr + numStr + uombStr;
            }
            boolean bl2 = decimalEmpty = decimalStr.length() < 2;
            if (decimalEmpty) {
                decimalStr = "";
            }
            String unDescriptable = "";
            int index = -1;
            for (int i = n; i < decimalLen; ++i) {
                char c = decimalTempStr.charAt(i);
                String numStr = this.numberPro.getProperty(String.valueOf(c));
                unDescriptable = unDescriptable + numStr;
                if ('0' == c) continue;
                index = i;
            }
            if (index >= 0) {
                decimalEmpty = false;
                if ('0' == decimalTempStr.charAt(n - 1)) {
                    decimalStr = decimalStr + APPrintDataSource.getResource("175_APPrintDataSource") + this.decimalPro.getProperty(String.valueOf(n - 1));
                }
                decimalStr = decimalStr + unDescriptable.substring(0, index - n + 1);
            }
        }
        if (integerEmpty && decimalEmpty) {
            integerStr = APPrintDataSource.getResource("43_APPrintDataSource");
        }
        return nagative + integerStr + decimalStr + APPrintDataSource.getResource("176_APPrintDataSource");
    }

    private static Properties getDecimalUnitMapping() {
        Properties decimalCurrencyUomb = new Properties();
        decimalCurrencyUomb.setProperty("0", APPrintDataSource.getResource("177_APPrintDataSource"));
        decimalCurrencyUomb.setProperty("1", APPrintDataSource.getResource("178_APPrintDataSource"));
        decimalCurrencyUomb.setProperty("2", APPrintDataSource.getResource("179_APPrintDataSource"));
        return decimalCurrencyUomb;
    }

    private static Properties getIntegerUnitMapping() {
        Properties integerCurrencyUomb = new Properties();
        integerCurrencyUomb.setProperty("0", APPrintDataSource.getResource("180_APPrintDataSource"));
        integerCurrencyUomb.setProperty("1", APPrintDataSource.getResource("181_APPrintDataSource"));
        integerCurrencyUomb.setProperty("2", APPrintDataSource.getResource("182_APPrintDataSource"));
        integerCurrencyUomb.setProperty("3", APPrintDataSource.getResource("183_APPrintDataSource"));
        integerCurrencyUomb.setProperty("4", APPrintDataSource.getResource("184_APPrintDataSource"));
        integerCurrencyUomb.setProperty("5", APPrintDataSource.getResource("181_APPrintDataSource"));
        integerCurrencyUomb.setProperty("6", APPrintDataSource.getResource("182_APPrintDataSource"));
        integerCurrencyUomb.setProperty("7", APPrintDataSource.getResource("183_APPrintDataSource"));
        integerCurrencyUomb.setProperty("8", APPrintDataSource.getResource("185_APPrintDataSource"));
        integerCurrencyUomb.setProperty("9", APPrintDataSource.getResource("181_APPrintDataSource"));
        integerCurrencyUomb.setProperty("10", APPrintDataSource.getResource("182_APPrintDataSource"));
        integerCurrencyUomb.setProperty("11", APPrintDataSource.getResource("183_APPrintDataSource"));
        integerCurrencyUomb.setProperty("12", APPrintDataSource.getResource("186_APPrintDataSource"));
        return integerCurrencyUomb;
    }

    private static Properties getNumberMapping() {
        Properties numberMapping = new Properties();
        numberMapping.setProperty("0", APPrintDataSource.getResource("175_APPrintDataSource"));
        numberMapping.setProperty("1", APPrintDataSource.getResource("187_APPrintDataSource"));
        numberMapping.setProperty("2", APPrintDataSource.getResource("188_APPrintDataSource"));
        numberMapping.setProperty("3", APPrintDataSource.getResource("189_APPrintDataSource"));
        numberMapping.setProperty("4", APPrintDataSource.getResource("190_APPrintDataSource"));
        numberMapping.setProperty("5", APPrintDataSource.getResource("191_APPrintDataSource"));
        numberMapping.setProperty("6", APPrintDataSource.getResource("192_APPrintDataSource"));
        numberMapping.setProperty("7", APPrintDataSource.getResource("193_APPrintDataSource"));
        numberMapping.setProperty("8", APPrintDataSource.getResource("194_APPrintDataSource"));
        numberMapping.setProperty("9", APPrintDataSource.getResource("195_APPrintDataSource"));
        return numberMapping;
    }

    protected String formatDate(Date date) {
        return this.df.format(date);
    }

    public abstract ColDesc[] getColDesc();

    public void rowFilled(IRowSet rs, BillBaseInfo bill, CoreBaseInfo entry) {
    }

    private static String getResource(String rssName) {
        return EASResource.getString((String)ARAPRESOURCE, (String)rssName);
    }

    public static class ColDesc {
        private String colId;
        private String propName;
        private int dataType;
        private Object extraInfo;

        public ColDesc(String colId, String propName) {
            this(colId, propName, 4, null);
        }

        public ColDesc(String colId, String propName, int dataType) {
            this(colId, propName, dataType, null);
        }

        public ColDesc(String colId, String propName, Object extraInfo) {
            this(colId, propName, 4, extraInfo);
        }

        public ColDesc(String colId, String propName, int dataType, Object extraInfo) {
            this.colId = colId;
            this.propName = propName;
            this.dataType = dataType;
            this.extraInfo = extraInfo;
        }

        public String getColId() {
            return this.colId;
        }

        public int getDataType() {
            return this.dataType;
        }

        public Object getExtraInfo() {
            return this.extraInfo;
        }

        public String getPropName() {
            return this.propName;
        }
    }

    protected static abstract class EnumUtil
    extends IntEnum {
        private EnumUtil(String name, int value) {
            super(name, value);
        }

        public static Enum getEnum(Class cls, Object val) {
            return IntEnum.getEnum((Class)cls, (int)Integer.parseInt(val.toString()));
        }
    }
}

