/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.service.formula.api.InvokeFunctionException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class ARAPFormulaFunctions
implements IFormulaFunctions {
    private Vector funcInfos = new Vector();
    private static String RES = "com.kingdee.eas.base.botp.BotpResx";

    public ARAPFormulaFunctions() {
        this.funcInfos.add(new FuncInfo("__BOTgetAccuralPrepareAccount", FuncInfo.CATEGORY_OTHER, ARAPFormulaFunctions.getStrResource("__BOTgetAccuralPrepareAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetCurrentPeriodStartDate", FuncInfo.CATEGORY_OTHER, ARAPFormulaFunctions.getStrResource("__BOTgetCurrentPeriodStartDate")));
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)this.funcInfos.get((int)i)).funcName;
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcDesc;
        }
        return null;
    }

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return true;
        }
        return false;
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        if (funcName == null) {
            return null;
        }
        try {
            if (paramList != null && paramList.size() > 0) {
                Context ctx = (Context)paramList.get(0);
                return this.getInnerAsstActProperty(ctx, funcName, paramList);
            }
        }
        catch (InvokeFunctionException e) {
            throw new KScriptException(e.toString());
        }
        catch (BOSException e) {
            throw new KScriptException(e.toString());
        }
        catch (EASBizException e) {
            throw new KScriptException(e.toString());
        }
        catch (NumberFormatException e) {
            throw new KScriptException(e.toString());
        }
        return null;
    }

    private Object getInnerAsstActProperty(Context ctx, String funcName, List paramList) throws InvokeFunctionException, BOSException, EASBizException, NumberFormatException {
        if ("__BOTgetAccuralPrepareAccount".equals(funcName)) {
            if (paramList == null || paramList.size() < 1) {
                throw new InvokeFunctionException(funcName, 2);
            }
            if (paramList.size() > 2) {
                throw new InvokeFunctionException(funcName, 1);
            }
            if (paramList.get(1) == null) {
                return null;
            }
            return this.getAccuralPrepareAccount(ctx, paramList.get(1).toString());
        }
        if ("__BOTgetCurrentPeriodStartDate".equals(funcName)) {
            if (paramList == null || paramList.size() < 3) {
                throw new InvokeFunctionException(funcName, 2);
            }
            if (paramList.size() > 3) {
                throw new InvokeFunctionException(funcName, 1);
            }
            if (paramList.get(1) == null || paramList.get(2) == null) {
                return null;
            }
            return this.getCurrentPeriodStartDate(ctx, paramList.get(1).toString().trim(), Integer.valueOf(paramList.get(2).toString().trim()));
        }
        return null;
    }

    private Object getCurrentPeriodStartDate(Context ctx, String companyID, int system) throws EASBizException, BOSException {
        PeriodInfo periodInfo;
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        CompanyOrgUnitInfo companyInfo = null;
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        SystemStatusCtrolInfo systmStsCtrlInfo = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyInfo, SystemEnum.getEnum((int)system));
        if (systmStsCtrlInfo != null && (periodInfo = systmStsCtrlInfo.getCurrentPeriod()) != null) {
            return periodInfo.getBeginDate();
        }
        return null;
    }

    private Object getAccuralPrepareAccount(Context ctx, String companyID) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        CompanyOrgUnitInfo companyInfo = null;
        AccountViewInfo accountInfo = null;
        try {
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
            accountInfo = this.getBadAccount(ctx, companyInfo);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        return accountInfo;
    }

    private HashMap getParams(Context ctx, IObjectValue company) throws BOSException, EASBizException {
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("");
        sql.append(" select param.fid paramid,param.fnumber fnumber,");
        sql.append(" param.FDefaultVal").append("_").append(lang);
        sql.append(" as defaultvalue,item.fid itemid,");
        sql.append(" item.fvalue").append("_").append(lang);
        sql.append(" as fvalue, item.forgunitid orgunitid,");
        sql.append(" item.fiscontrolsub iscontrolsub,item.fismodify ismodify ");
        sql.append(" from t_bas_param param left join t_bas_paramitem item on param.fid=item.fkeyid ");
        sql.append(" and item.forgunitid = ? ");
        sql.append(" where param.fsubsysid = ? and param.fnumber like 'arap00%'");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, ParamItemInfo> prop = new HashMap<String, ParamItemInfo>();
        try {
            con = EJBFactory.getConnnection((Context)ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, company.get(company.getPKField()).toString());
            ps.setString(2, "com.kingdee.eas.fi.ar.ar");
            rs = ps.executeQuery();
            while (rs.next()) {
                ParamItemInfo info = new ParamItemInfo();
                String id = rs.getString("itemid");
                String value = null;
                if (id != null) {
                    info.setId(BOSUuid.read((String)id));
                    value = rs.getString("fvalue");
                } else {
                    value = rs.getString("defaultvalue");
                }
                info.setValue(value);
                ParamInfo paraminfo = new ParamInfo();
                paraminfo.setId(BOSUuid.read((String)rs.getString("paramid")));
                String number = rs.getString("fnumber");
                paraminfo.setNumber(number);
                info.setKeyID(paraminfo);
                prop.put(number, info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return prop;
    }

    private AccountViewInfo getBadDebtPrepareAccount(Context ctx, Map value, String key) throws BOSException, EASBizException {
        if (value.size() <= 0) {
            return null;
        }
        ParamItemInfo accountIDItem = null;
        accountIDItem = (ParamItemInfo)value.get(key);
        String accountIDString = "";
        if (accountIDItem.getValue() != null) {
            accountIDString = accountIDItem.getValue();
        }
        if (accountIDString == null || "".equals(accountIDString.trim())) {
            return null;
        }
        BOSUuid accountID = BOSUuid.read((String)accountIDString);
        ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)accountPK);
        return account;
    }

    private AccountViewInfo getBadAcctPrepareAccount(Context ctx, IObjectValue company, String key) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = null;
        HashMap countBadDebtMethodOptions = this.getParams(ctx, company);
        if (((ParamItemInfo)countBadDebtMethodOptions.get(key)).getValue() != null && ((ParamItemInfo)countBadDebtMethodOptions.get(key)).getValue().toString().length() != 0) {
            accountViewInfo = this.getBadDebtPrepareAccount(ctx, countBadDebtMethodOptions, key);
        }
        return accountViewInfo;
    }

    public AccountViewInfo getBadAccount(Context ctx, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        AccountViewInfo account = null;
        IBadAccountFacade iBadAccountFacade = BadAccountFacadeFactory.getLocalInstance(ctx);
        String accuralParam = iBadAccountFacade.getAccuralParam(currentCompany);
        if (iBadAccountFacade.isDerectorTransferCancelMethod(currentCompany)) {
            account = this.getBadAcctPrepareAccount(ctx, (IObjectValue)currentCompany, "arap001002005");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(2))) {
            account = this.getBadAcctPrepareAccount(ctx, (IObjectValue)currentCompany, "arap001002002004");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(6))) {
            account = this.getBadAcctPrepareAccount(ctx, (IObjectValue)currentCompany, "arap001002002");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(5))) {
            account = this.getBadAcctPrepareAccount(ctx, (IObjectValue)currentCompany, "arap001002002002");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(3))) {
            account = this.getBadAcctPrepareAccount(ctx, (IObjectValue)currentCompany, "arap001002003");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(1))) {
            account = this.getBadAcctPrepareAccount(ctx, (IObjectValue)currentCompany, "arap001002001");
        }
        return account;
    }

    private static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    static /* synthetic */ String access$000(String x0) {
        return ARAPFormulaFunctions.getStrResource(x0);
    }

    static class FuncInfo {
        public static final String CATEGORY_OTHER = ARAPFormulaFunctions.access$000("OtherFunctions");
        String funcName;
        String funcCategory;
        String funcDesc;

        public FuncInfo(String name, String category, String desc) {
            this.funcName = name;
            this.funcCategory = category;
            this.funcDesc = desc;
        }

        public FuncInfo() {
        }

        public void setFuncName(String name) {
            this.funcName = name;
        }

        public void setFuncDesc(String desc) {
            this.funcDesc = desc;
        }

        public void setFuncCatetory(String category) {
            this.funcCategory = category;
        }
    }
}

