/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IAPBillDisposer;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.BillDisposerAction;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;

public class ARDisposeUtil {
    public static void dispose(Context ctx, OtherBillInfo info, DisposerActionEnum actionType) throws BOSException, EASBizException {
        IAPBillDisposer disposer = null;
        int j = 0;
        OtherBillentryCollection entries = info.getEntry();
        int lenj = entries.size();
        if (j < lenj) {
            OtherBillentryInfo entry = entries.get(j);
            disposer = ARDisposeUtil.getDisposer(entry.getSourceBillId());
        }
        if (disposer != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("entry.*");
            ev.setFilter(fi);
            ev.setSelector(sic);
            OtherBillCollection col = OtherBillFactory.getLocalInstance(ctx).getOtherBillCollection(ev);
            info = col.get(0);
            BillDisposerAction action = new BillDisposerAction();
            action.setActionType(actionType);
            action.setDestBill((CoreBaseInfo)info);
            disposer.dispose(ctx, action);
        }
    }

    private static IAPBillDisposer getDisposer(String bizBillId) throws BOSException {
        if (StringUtils.isEmpty((String)bizBillId)) {
            return null;
        }
        BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
        String disposerName = null;
        if (bosType.equals((Object)BOSObjectType.create((String)"65873F29"))) {
            disposerName = "com.kingdee.eas.sscbusiness.contract.BizOtherBillReBack";
        }
        if (disposerName == null) {
            return null;
        }
        try {
            return (IAPBillDisposer)Class.forName(disposerName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

